/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/
/**
 * @file plotWindow
 * @brief Ui to plot windows to display graphs
 * @author Johan Sarrazin
 * @date November 27 2012
 */

#ifndef PLOTWINDOW_H
#define PLOTWINDOW_H

#include <QMainWindow>
#include <qcustomplot.h>

namespace Ui {
class PlotWindow;
}
/**
 * Class dedicated to draw some type of plot with given data generated from @class mml2Csv
 */
class plotWindow : public QWidget {
    Q_OBJECT

public:
    /// constructor
    plotWindow(QWidget* parent = 0);
    /// destructor
    virtual ~plotWindow();

    /// Getter to obtain the QCustomWidget
    QCustomPlot* getCustomPlot();

private:
    /// reference to the Ui allowing to plot data
    Ui::PlotWindow *ui;
};

#endif //PLOTWINDOW_H
