/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/
#include "DicomImageComponent.h"
#include "gdcmImageReader.h"
#include "vtkGDCMImageReader.h"

// Qt includes
#include <QDir>

// VTK includes
#include <vtkStringArray.h>


using namespace camitk;
using namespace gdcm;

// --------------- Constructor -------------------
DicomImageComponent::DicomImageComponent(const QString & path) throw(AbortException) : ImageComponent(path)
{
    // Use GDCM libraries to handle dicom volume image files
    vtkGDCMImageReader *reader = vtkGDCMImageReader::New();
    
    // read the .dcm image file
    reader->SetFileName(path.toStdString().c_str());
    reader->UpdateWholeExtent();
        
    // Get the image pixels value from the gdcm reader
    vtkSmartPointer<vtkImageData> image = reader->GetOutput();
    
    // load the image into CamiTK
    setImageData(image, false);
}

// --------------- destructor -------------------
DicomImageComponent::~DicomImageComponent() {

}

