/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/
/**
 * @file mml2Csv
 * @brief Create a csv with monitors at the end of a mml output
 * @author Johan Sarrazin
 * @date November 27 2012
 */

#ifndef MML2CSV_H
#define MML2CSV_H

#include <string>
#include <list>
#include <memory>   // std::auto_ptr
#include <iostream>
#include <stdio.h>
#include "dataMonitoredList.h"
#include <MonitoringModel.hxx>


using namespace std;

/**
 * Class which allows you to generate CSV file which contains results vectors of modelisation which are monitored
 */
class mml2Csv{

  public:
    /// constructor
    mml2Csv(string saveFile,list<dataMonitoredList> monitors, list<string> filesMML);    
    /// destructor
    virtual ~mml2Csv();

    /**
     * Method to write a csv file with a list of dataMonitoredList 
     * @param filename path where the csv will be written
     * @param values object containing monitored values
     */
    void writeCSV(string filename,list<dataMonitoredList> values );
            
    /**
     * Method to add data at the right place in a dataMonitoredList object 
     * @param typeMonitor name of the monitor
     * @param values values to add at the right monitor
     */
    void addDataToList(string typeMonitor, vector<double> data);
    
  private:
    
     /// private structure with monitors for a time step
    struct timeStep{
      double time;
      multimap<string,mml::Monitor*> monitorsMap;
    };
    /// the mmlOut document
    string mmlOutFile;
    /// Object in the file generated by xsdcxx
    auto_ptr<mml::MonitoringOut> mmlOut;
    /** vector which contain alls monitors for each time step
     */
    vector<timeStep*> data;
    
    /// list of monitors with results data from this monitor
    list<dataMonitoredList> valuesMonitored;
    
    /// List of files to study
    list<string> filesMML;
    
    /// List of monitors
    list<string> monitors;
    
};

#endif // MML2CSV_H