/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/
/**
 * @file main
 * @brief allows you to run mml2Csv in command line
 * @author Johan Sarrazin
 * @date November 27 2012
 */

#include <iostream>
#include <list>
#include "mml2Csv.h"
#include "dataMonitoredList.h"
using namespace std;

// ------------- main ------------------------------------------------------------------------------
int main(int argc, const char* argv[]) {
    if (argc < 2) {
        cerr << "Usage : " << argv[0] << " Please enter at least one monitor and one mmlOut" << endl;
	cout << "HOWTO : ./mml2Csv -ARG -ARG2 ... Path_file1 Path_file2 ... :Path_to_save_csv" << endl;
        return 1;
    }
    string savefile = "result.csv";

    list<dataMonitoredList> valuesMonitored;
    list<string> filesMML;

    cout<< endl << "/*****************************************/"<< endl;
    // Take a look at the command line
    for (int i=1; i<argc; i++) {
        string temp = argv[i];
        if (temp.find("-")==0) {
            //It's a monitor
            temp = temp.substr(1);
            valuesMonitored.push_back(dataMonitoredList(temp));
	    cout<<"Monitor : "<<temp<<endl;
        }
        else if (temp.find(":")==0) {
            temp = temp.substr(1);
            //It's the path where the file must be saved.
            savefile=temp;
	    cout<< endl <<"Save as : "<<savefile<<endl;
        }
        else {  
            //It's a file to study
            filesMML.push_back(temp);
	    cout<<"Studying file : " <<temp<<endl;
        }
    }
    cout<< "/*****************************************/"<< endl<<endl;
    if (valuesMonitored.empty() || filesMML.empty()) {
        cerr<<"ERROR : The command line is incorrect !"<<endl;
	cout << "HOWTO : ./mml2Csv -ARG -ARG2 ... Path_file1 Path_file2 ... :Path_to_save_csv" << endl;
    } else {
        mml2Csv mml2Csv(savefile,valuesMonitored,filesMML);
    }
}

