/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/
/**
 * @file OffExtension.h
 * @brief .off file manager class.
 * @author Sonia Selmi
 * @date July 31 2012
 */

#include "OffComponent.h"
#include "OffExtension.h"

#include <QFileInfo>

#include <vtkCellType.h>
#include <vtkCell.h>

#include <Log.h>
#include <Application.h>

// declare the plugin
Q_EXPORT_PLUGIN2(OffExtension, OffExtension);


QString OffExtension::getName() const {
    return "Off Component";
}

QString OffExtension::getDescription() const {
    return "OFF <em>.off</em> files in <b>CamiTK</b>.(very few support!) <br>(c)TIMC-IMAG UJF 2012";
}

QStringList OffExtension::getFileExtensions() const {
    QStringList ext;
    ext << "off";
    return ext;
}

Component * OffExtension::open(const QString & fileName) throw (AbortException) {
    return new OffComponent(fileName);
}

