/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/
#ifndef OBJ_COMPONENT_H
#define OBJ_COMPONENT_H

#include <MeshComponent.h>
using namespace camitk;

/** The manager of the objdata (alias wavefront format).
 *  This component is using VtkObjReader to import the file and shows how
 *  to add static and dynamic properties to a component.
 * 
 * @author Emmanuel Promayon
 */
class ObjComponent : public MeshComponent {
    Q_OBJECT
    
  public:
    /// default constructor
    ObjComponent(const QString & file) throw(AbortException);

    /// @name Component Properties
    /// @{
    /** These are read-only static properties.
     *  You need to have a Q_OBJECT line at the top of the class for static properties to be correctly handled.
     *  This component also has dynamic property, @see initDynamicProperties
     */
    Q_PROPERTY(int nbPoints READ getNbPoints);
    Q_PROPERTY(int nbCells READ getNbCells);
    Q_PROPERTY(int memoryUsage READ getMemoryUsage);
    
    /// methods needed to manage the read-only static properties
    int getNbPoints();
    int getNbCells();
    int getMemoryUsage();

    /** updateProperty is overriden to manage the specific dynamic properties of this
     *  component.
     *  Do not forget to call the superclass method to manage inherited (dynamic) properties.
     * @param name the name of the dynamic property
     * @param value the new value to take into account
    */
    void updateProperty(QString name, QVariant value);
    /// @}
    
private:
    /// create and initialize dynamic properties
    void initDynamicProperties();
};

#endif
