/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef NIFTI_IMAGES_MANAGER_H
#define NIFTI_IMAGES_MANAGER_H

#include <vtkImageData.h>
#include <vtkSmartPointer.h>
#include <ImageComponent.h>

using namespace camitk;

/**This component manages nifti images (using ITK I/O helper class).
 * 
 * For more info about image data format: http://nifti.nimh.nih.gov/nifti-1/
 */


class NiftiImageComponent : public ImageComponent  {
    Q_OBJECT

public:
	/// default constructor: give it the name of the file containing the data
    NiftiImageComponent(const QString&) throw (AbortException);

    /// needed for deleting
    virtual ~NiftiImageComponent() {};

    virtual void createComponent(const QString&);

protected:
    vtkSmartPointer<vtkImageData> readVolume(const QString& filename);

};




#endif // NIFTI_IMAGES_MANAGER_H