#----------------------
# CamiTK configuration
#----------------------
# all CMake project names and variables should be in uppercase
#
# CamiTK extension framework is based on Qt. It can only work if Qt is compiled as shared lib (.dll or .so)
# Use keyword STATIC for tool library
# Use keyword SHARED for extensions
# Use keyword MODULE for actions

# To have verbose compilation:
#set (CMAKE_VERBOSE_MAKEFILE ON CACHE BOOL "Verbose makefile" FORCE)

#
# Convenience variables
#
# name of the camitk core lib
set(CAMITK_CORE_LIB camitkcore)

# List of directories where the linker should look for CamiTK core libraries and tools
set (CAMITK_LIB_DIRECTORIES
  ${CAMITK_LIB_DIR}
  ${CAMITK_BIN_DIR}
)

# List of directories where the compiler should look for CamiTK core headers as well
# as all the tools headers and dependencies headers (Qt, Vtk)
set (CAMITK_INCLUDE_DIRECTORIES
  ${CAMITK_INCLUDE_DIR}
  ${CAMITK_INCLUDE_DIR}/qtpropertybrowser
  ${CAMITK_INCLUDE_DIR}/${CAMITK_CORE_LIB}
  ${QT_INCLUDE_DIR}
  ${VTK_INCLUDE_DIRS}
)

# basic list of all lib needed for linking with CamiTK core
set (CAMITK_LIBRARIES
  ${QT_LIBRARIES}
  vtkCommon
  vtkFiltering
  vtkGenericFiltering
  vtkGraphics
  vtkHybrid
  vtkImaging
  vtkIO
  vtkRendering
  vtkVolumeRendering
  vtkftgl
  vtkWidgets
  QVTK
  qtpropertybrowser # in tools
)

if (CMAKE_CROSSCOMPILING)
        # there is some tiff dependencies to jpeg that are not well handled
        set (CAMITK_LIBRARIES ${CAMITK_LIBRARIES} jpeg)
endif()

mark_as_advanced ( CAMITK_LIB_DIRECTORIES CAMITK_INCLUDE_DIRECTORIES CAMITK_LIBRARIES CAMITK_CORE_LIB)

# rpath settings for linux
# This settings allow running the exe from the build tree and running them from its install location
# without doing anything in particular.
# see http://www.itk.org/Wiki/CMake_RPATH_handling
# use, i.e. don't skip the full RPATH for the build tree
set(CMAKE_SKIP_BUILD_RPATH FALSE)

# when building, don't use the install RPATH already
# (but later on when installing)
set(CMAKE_BUILD_WITH_INSTALL_RPATH FALSE)
set(CMAKE_INSTALL_RPATH "${CMAKE_INSTALL_PREFIX}/lib")

# add the automatically determined parts of the RPATH
# which point to directories outside the build tree to the install RPATH
set(CMAKE_INSTALL_RPATH_USE_LINK_PATH TRUE)

# the RPATH to be used when installing, but only if it's not a system directory
# TODO : write a specific macro camitk_install to use for installing library 
# This macro should not only do the usual install job, but also should add the 
# specific install path in the CMAKE_INSTALL_RPATH variables
# On windows: write a message at the end of the installation process with the value
# of CMAKE_INSTALL_RPATH
# On Windows: build a specific .bat for each application?
# Even better, try this: cumulate the CMAKE_INSTALL_RPATH in a file containing the list
# of all needed dir in the path. This file is read at run-time to add the path using 
# Application::instance()->addLibraryPath(path#i.canonicalPath());
list(FIND CMAKE_PLATFORM_IMPLICIT_LINK_DIRECTORIES "${CMAKE_INSTALL_PREFIX}/lib" isSystemDir)
if("${isSystemDir}" STREQUAL "-1")
   set(CMAKE_INSTALL_RPATH  "${CMAKE_INSTALL_PREFIX}/lib" 
                            "${CMAKE_INSTALL_PREFIX}/lib/${CAMITK_SHORT_VERSION_STRING}"
                            "${CMAKE_INSTALL_PREFIX}/lib/${CAMITK_SHORT_VERSION_STRING}/components" )
endif()


