#------------------
# CamiTK packaging
#------------------

# Do not forget to change the version variables in CamiTKBuild.cmake
#
# To make a source tar ball, just use the custom target camitk_package_source, e.g. "make camitk_package_source"
#
# To make an executable/installable, you will have to properly set a specific CAMITK_INSTALL_ROOT
#
# CAMITK_INSTALL_ROOT will be used as the root installation directory on the targeted plateform
# Usual values for unix are /usr or /usr/local
#
# Therefore, in order to produce a proper deb for system-wide install, you can run something like:
# cd tmp
# mkdir camitk
# cd camitk
# svn checkout svn://scm.forge.imag.fr/var/lib/gforge/chroot/scmrepos/svn/camitk/trunk/camitk
# mkdir build
# cd build
# cmake -DCMAKE_BUILD_TYPE:STRING=RelWithDebInfo -DCAMITK_INSTALL_ROOT:PATH=/usr -DTOOL_CORESCHEMA:BOOL=ON -DTOOL_LML:BOOL=TRUE -DTOOL_PML:BOOL=TRUE         -DMML_GENERATE_GUI:BOOL=ON -DTOOL_MML:BOOL=TRUE -DMML_GENERATE_XSD_LIB:BOOL=TRUE -DACTION_ITKSEGMENTATION:BOOL=TRUE -DACTION_ITKFILTERS:BOOL=TRUE -DAPPLICATION_WIZARD:BOOL=TRUE -DCOMPONENT_VTKMESH:BOOL=TRUE -DCOMPONENT_DICOM:BOOL=TRUE -DCOMPONENT_ITKIMAGE:BOOL=TRUE -DCOMPONENT_PHYSICALMODEL:BOOL=TRUE -DCOMPONENT_MML:BOOL=TRUE -DAPIDOC_GENERATE_FOR_CAMITK_CORE:BOOL=TRUE -DACTION_MML:BOOL=TRUE ../camitk
# (you can add -DMAKECOMMAND:STRING="/usr/bin/make -i -j5")
# make VERBOSE=1
# (or make -j5 VERBOSE=1 )
# make camitk_package VERBOSE=1
#
#
# To build source package
# make camitk_package_source
# (it generates the correct CamiTKVersion.h)
#
# Once CAMITK_INSTALL_ROOT is properly defined, type "make camitk_package"
# 
# To check the content of a deb package:
# dpkg --contents package.deb
# To install the content of a deb in a subdirectory instead of system-wide:
# dpkg --vextract package.deb subdirectory
#
# To produce a window installer with NSIS from linux, you need to install the nsis package (on ubuntu, type "sudo apt-get install nsis")
# Be sure to use the makensisw.exe and not makensis.exe as the value of the MAKENSIS variable.
#
# To generate different components that can be opt out at install time, see
# http://www.itk.org/Wiki/CMake:Component_Install_With_CPack
#
# More generally see http://www.itk.org/Wiki/CMake:CPackConfiguration

# package name
string(TOLOWER ${CAMITK_PROJECT_NAME} CPACK_PACKAGE_NAME)
set(CPACK_PACKAGE_VERSION_MAJOR ${CAMITK_VER_MAJ})
set(CPACK_PACKAGE_VERSION_MINOR ${CAMITK_VER_MIN})
set(CPACK_PACKAGE_VERSION_PATCH ${CAMITK_VER_PACKAGE_PAT})
string(TOLOWER "${CPACK_PACKAGE_NAME}-${CPACK_PACKAGE_VERSION_MAJOR}.${CPACK_PACKAGE_VERSION_MINOR}.${CPACK_PACKAGE_VERSION_PATCH}-${CAMITK_VER_NICKNAME}-${LSB_DISTRIB}_${CPACK_PACKAGE_ARCHITECTURE}" CPACK_PACKAGE_FILE_NAME)

# contact information
set(CPACK_PACKAGE_VENDOR "UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525")
set(CPACK_PACKAGE_CONTACT "http://camitk.imag.fr")
set(CPACK_DEBIAN_PACKAGE_MAINTAINER "CamiTK Developers <camitk-developers@lists.forge.imag.fr>")

# resource files
set(CPACK_RESOURCE_FILE_README "${CAMITK_SOURCE_DIR}/README")
set(CPACK_RESOURCE_FILE_LICENSE "${CAMITK_SOURCE_DIR}/COPYRIGHT")

# executable
set(CPACK_PACKAGE_EXECUTABLES "camitk-imp" "camitk-imp") #"wizard" "wizard")

# CamiTK package description
#set(CPACK_PACKAGE_DESCRIPTION_SUMMARY "CamiTK user package.")
set(CPACK_PACKAGE_DESCRIPTION_SUMMARY "CamiTK stands for Computer Assisted Medical Intervention Tool Kit and aims at providing an easy way to protype medical applications. CamiTK functionnalities are extendable thanks to plugins. This package includes the IMP application with main plugins that allow users to interact with medical images (2D, 3D), process them and simulate biomechanichal deformations.")

# Files to ignore during generation of the package
set(CPACK_SOURCE_IGNORE_FILES
"~$"
"/\\\\.svn/"
"/\\\\.git/"
"/kdev4$/"
"/build/"
${CPACK_SOURCE_IGNORE_FILES}
)

set(CPACK_SOURCE_GENERATOR "TGZ" "ZIP" )


# ----------------
# Debian packages
# ----------------
if (UNIX AND NOT WIN32)
   
   message(STATUS "Packaging CamiTK for UNIX systems")
   # Try to find architecture
   execute_process(COMMAND uname -m OUTPUT_VARIABLE CPACK_PACKAGE_ARCHITECTURE)
   string(STRIP "${CPACK_PACKAGE_ARCHITECTURE}" CPACK_PACKAGE_ARCHITECTURE)
   # Try to find distro name and distro-specific arch
   execute_process(COMMAND lsb_release -is OUTPUT_VARIABLE LSB_ID)
   execute_process(COMMAND lsb_release -rs OUTPUT_VARIABLE LSB_RELEASE)
   string(STRIP "${LSB_ID}" LSB_ID)
   string(STRIP "${LSB_RELEASE}" LSB_RELEASE)
   set(LSB_DISTRIB "${LSB_ID}${LSB_RELEASE}")
   if(NOT LSB_DISTRIB)
      set(LSB_DISTRIB "unix")
   endif(NOT LSB_DISTRIB)
   message(STATUS "Packager architecture : ${LSB_DISTRIB}")

   #Find DPKG
   find_program(DPKG
      NAMES dpkg-deb
      PATHS "/usr/bin" #Add paths here
   )
   if ( DPKG )
      get_filename_component(DPKG_PATH ${DPKG} ABSOLUTE)
      message(STATUS "Packaging deb using ${DPKG_PATH}: OK")
      set(DPKG_FOUND "YES")
   else() 
      set(DPKG_FOUND "NO")
   endif()
   
   # Packaging requires ITK
   find_package(ITK REQUIRED)
   include(${ITK_USE_FILE})
   
   # For Debian-based distribs we want to create DEB packages.
   if("${LSB_DISTRIB}" MATCHES "Ubuntu|Debian")

      # We need to alter the architecture names as per distro rules
      if("${CPACK_PACKAGE_ARCHITECTURE}" MATCHES "i[3-6]86")
         set(CPACK_PACKAGE_ARCHITECTURE i386)
      endif()
      if("${CPACK_PACKAGE_ARCHITECTURE}" MATCHES "x86_64")
         set(CPACK_PACKAGE_ARCHITECTURE amd64)
      endif()
      # Set the dependencies based on the distrib version

      # Installation path
      # Set the install location to "/usr"
      # PLEASE, set the CamiTK install root path in your CMake command line / GUI (and not directly here)      
      set(CPACK_PACKAGING_INSTALL_PREFIX "/usr")
      set(CPACK_PACKAGE_DEFAULT_LOCATION "/usr")
      set(CPACK_SET_DESTDIR TRUE)

      # Dependencies depending on the Operating System.
      # Ubuntu11.10
      if("${LSB_DISTRIB}" MATCHES "Ubuntu11.10")
         set(CPACK_DEBIAN_PACKAGE_DEPENDS "libqt4-dev, libinsighttoolkit3.20, libxml2, libvtk5.6-qt4, libxerces-c3.1 ")
      endif()
      # For Ubuntu12.xx 
      if("${LSB_DISTRIB}" MATCHES "Ubuntu12.04")
         set(LSB_DISTRIB "Ubuntu12.xx")
         set(CPACK_DEBIAN_PACKAGE_DEPENDS "libqt4-dev, libinsighttoolkit3.20, libxml2, libvtk5.8-qt4, libxerces-c3.1 ")
      endif()
      if("${LSB_DISTRIB}" MATCHES "Ubuntu12.04.1")
         set(LSB_DISTRIB "Ubuntu12.xx")
         set(CPACK_DEBIAN_PACKAGE_DEPENDS "libqt4-dev, libinsighttoolkit3.20, libxml2, libvtk5.8-qt4, libxerces-c3.1 ")
                endif()
      if("${LSB_DISTRIB}" MATCHES "Ubuntu12.10")
         set(LSB_DISTRIB "Ubuntu12.xx")
         set(CPACK_DEBIAN_PACKAGE_DEPENDS "libqt4-dev, libinsighttoolkit3.20, libxml2, libvtk5.8-qt4, libxerces-c3.1 ")
      endif()
                
      # TODO Debian dependencies
#     if("${LSB_DISTRIB}" MATCHES "Debian5.*")
#        set(CPACK_DEBIAN_PACKAGE_DEPENDS "libgtk2.0-0, libsqlite3-0, libglade2-0, libgegl-0.0-0, libcairo2, libexiv2-5, liblcms1, libjpeg62, libpng12-0, liblensfun0, liblensfun-data")
# 
#     endif("${LSB_DISTRIB}" MATCHES "Debian5.*")
#     if("${LSB_DISTRIB}" MATCHES "Debiantesting")
#        set(CPACK_DEBIAN_PACKAGE_DEPENDS "libgtk2.0-0, libsqlite3-0, libglade2-0, libgegl-0.0-0, libcairo2, libexiv2-5, liblcms1, libjpeg62, libpng12-0, liblensfun0, liblensfun-data")
#     endif("${LSB_DISTRIB}" MATCHES "Debiantesting")

      if(NOT CPACK_DEBIAN_PACKAGE_DEPENDS)
         message(STATUS "Packaging for ${LSB_DISTRIB} not supported yet.\n")
      endif()

   endif()

   # package name
   string(TOLOWER "${CPACK_PACKAGE_NAME}_${CPACK_PACKAGE_VERSION_MAJOR}.${CPACK_PACKAGE_VERSION_MINOR}.${CPACK_PACKAGE_VERSION_PATCH}-${CAMITK_VER_NICKNAME}-${LSB_DISTRIB}_${CPACK_PACKAGE_ARCHITECTURE}" CPACK_PACKAGE_FILE_NAME)
   message(STATUS "CPACK_PACKAGE_FILE_NAME = ${CPACK_PACKAGE_FILE_NAME}")

endif()



if(WIN32 AND NOT UNIX)
   # -----------------------
   # NSIS Windows installer
   # -----------------------
   
   # Update package name for windows release
   set(LSB_DISTRIB "win32")
   set(CPACK_PACKAGE_ARCHITECTURE i386)
   string(TOLOWER "${CPACK_PACKAGE_NAME}-${CPACK_PACKAGE_VERSION_MAJOR}.${CPACK_PACKAGE_VERSION_MINOR}.${CPACK_PACKAGE_VERSION_PATCH}-${CAMITK_VER_NICKNAME}-${LSB_DISTRIB}" CPACK_PACKAGE_FILE_NAME)
   
   # Try to find Makensis on Linux distribution
   find_program(MAKENSIS
     NAMES makensis
     PATHS "/usr/bin"
   )

   if(MAKENSIS)
   
      set(ITK_ROOT_DIR "C:/dev/ITK/3.20.1")
      	
      # MinGW compiler
      if ("${CMAKE_GENERATOR}" MATCHES "MinGW Makefiles")
	  
         message(STATUS "Packaging nsis using ${MAKENSIS} with MinGW compiler")
		 
         set(CMAKE_INSTALL_SYSTEM_RUNTIME_LIBS 
         ##TODO use GetPrerequisites.cmake (i.e. find a better way to list dependencies)
         ##get_prerequisites() is not well enough documented to justify the time investement - EP May 2011
         # Qt dependencies
         ${QT_BINARY_DIR}/QtCore4.dll 
         ${QT_BINARY_DIR}/QtGui4.dll
         ${QT_BINARY_DIR}/QtSvg4.dll
         ${QT_BINARY_DIR}/QtXml4.dll
         ${QT_BINARY_DIR}/QtNetwork4.dll
         ${QT_BINARY_DIR}/QtSql4.dll
         ${QT_BINARY_DIR}/QtWebKit4.dll
         # VTK dependencies
         ${VTK_LIBRARY_DIRS}/libQVTK.dll 
         ${VTK_LIBRARY_DIRS}/libvtkCommon.dll 
         ${VTK_LIBRARY_DIRS}/libvtksys.dll 
         ${VTK_LIBRARY_DIRS}/libvtkFiltering.dll 
         ${VTK_LIBRARY_DIRS}/libvtkGraphics.dll 
         ${VTK_LIBRARY_DIRS}/libvtkHybrid.dll 
         ${VTK_LIBRARY_DIRS}/libvtkIO.dll 
         ${VTK_LIBRARY_DIRS}/libvtkImaging.dll
         ${VTK_LIBRARY_DIRS}/libvtkRendering.dll 
         ${VTK_LIBRARY_DIRS}/libvtkVolumeRendering.dll
         ${VTK_LIBRARY_DIRS}/libvtkverdict.dll 
         ${VTK_LIBRARY_DIRS}/libvtkDICOMParser.dll 
         ${VTK_LIBRARY_DIRS}/libvtkNetCDF.dll 
         ${VTK_LIBRARY_DIRS}/libvtkNetCDF_cxx.dll
         ${VTK_LIBRARY_DIRS}/libvtkexpat.dll 
         ${VTK_LIBRARY_DIRS}/libvtkjpeg.dll 
         ${VTK_LIBRARY_DIRS}/libvtkmetaio.dll 
         ${VTK_LIBRARY_DIRS}/libvtkpng.dll 
         ${VTK_LIBRARY_DIRS}/libvtktiff.dll 
         ${VTK_LIBRARY_DIRS}/libvtkzlib.dll 
         ${VTK_LIBRARY_DIRS}/libvtkInfovis.dll 
         ${VTK_LIBRARY_DIRS}/libvtkfreetype.dll 
         ${VTK_LIBRARY_DIRS}/libvtkftgl.dll
         ${VTK_LIBRARY_DIRS}/libvtkalglib.dll 
         ${VTK_LIBRARY_DIRS}/libvtklibxml2.dll 
         ${VTK_LIBRARY_DIRS}/libvtkViews.dll 
         ${VTK_LIBRARY_DIRS}/libvtkexoIIc.dll
         ${VTK_LIBRARY_DIRS}/libvtkWidgets.dll
         ${VTK_LIBRARY_DIRS}/vtkhdf5.dll 
         ${VTK_LIBRARY_DIRS}/vtkhdf5_hl.dll 
         ${VTK_LIBRARY_DIRS}/libLSDyna.dll      		 
         # Xerces-c dependency
         # ${XERCESC_ROOT_DIR}/bin/xerces-c_3_1.dll 
         # Libxml2 dependencies
         # ${LIBXML2_INCLUDE_DIR}/../bin/iconv.dll
         C:/dev/libxml2/2.8/bin/libxml2-2.dll
         # ${LIBXML2_INCLUDE_DIR}/../bin/zlib1.dll
         # ITK dependency 
         ${ITK_ROOT_DIR}/bin/libITKCommon.dll
         ${ITK_ROOT_DIR}/bin/libITKBasicFilters.dll
         ${ITK_ROOT_DIR}/lib/InsightToolkit/libitksys.dll
         ${ITK_ROOT_DIR}/bin/libitkvnl.dll
         ${ITK_ROOT_DIR}/bin/libitkvnl_algo.dll
         ${ITK_ROOT_DIR}/bin/libITKIO.dll
         ${ITK_ROOT_DIR}/bin/libitkv3p_lsqr.dll
         ${ITK_ROOT_DIR}/bin/libitkv3p_netlib.dll
         ${ITK_ROOT_DIR}/bin/libITKDICOMParser.dll
         ${ITK_ROOT_DIR}/bin/libITKEXPAT.dll
         ${ITK_ROOT_DIR}/bin/libitkgdcm.dll
         ${ITK_ROOT_DIR}/bin/libitkjpeg8.dll
         ${ITK_ROOT_DIR}/bin/libITKMetaIO.dll
         ${ITK_ROOT_DIR}/bin/libITKniftiio.dll
         ${ITK_ROOT_DIR}/bin/libITKNrrdIO.dll
         ${ITK_ROOT_DIR}/bin/libitkpng.dll
         ${ITK_ROOT_DIR}/bin/libitktiff.dll
         ${ITK_ROOT_DIR}/bin/libitkzlib.dll
         ${ITK_ROOT_DIR}/bin/libitkjpeg12.dll
         ${ITK_ROOT_DIR}/bin/libitkjpeg16.dll
         ${ITK_ROOT_DIR}/bin/libitkopenjpeg.dll
         ${ITK_ROOT_DIR}/bin/libITKznz.dll
         # MinGW Dependencies
         C:/dev/MinGW/bin/libgcc_s_dw2-1.dll
         C:/dev/MinGW/bin/libstdc++-6.dll
         C:/dev/MinGW/bin/mingwm10.dll
         )
         
      endif()
      
      # MSVC compiler
      if ("${CMAKE_GENERATOR}" MATCHES "Visual Studio 9 2008")
	  
         message(STATUS "Packaging nsis using ${MAKENSIS} with MSVC compiler")
		 
         set(CMAKE_INSTALL_SYSTEM_RUNTIME_LIBS 
         ##TODO use GetPrerequisites.cmake (i.e. find a better way to list dependencies)
         ##get_prerequisites() is not well enough documented to justify the time investement - EP May 2011
		 # Qt dependencies
         ${QT_BINARY_DIR}/QtCore4.dll 
         ${QT_BINARY_DIR}/QtGui4.dll
         ${QT_BINARY_DIR}/QtSvg4.dll
         ${QT_BINARY_DIR}/QtXml4.dll
         ${QT_BINARY_DIR}/QtNetwork4.dll
         ${QT_BINARY_DIR}/QtSql4.dll
         ${QT_BINARY_DIR}/QtWebKit4.dll
         # VTK dependencies
         ${VTK_LIBRARY_DIRS}/Release/QVTK.dll 
         ${VTK_LIBRARY_DIRS}/Release/vtkCommon.dll 
         ${VTK_LIBRARY_DIRS}/Release/vtksys.dll 
         ${VTK_LIBRARY_DIRS}/Release/vtkFiltering.dll 
         ${VTK_LIBRARY_DIRS}/Release/vtkGraphics.dll 
         ${VTK_LIBRARY_DIRS}/Release/vtkHybrid.dll 
         ${VTK_LIBRARY_DIRS}/Release/vtkIO.dll 
         ${VTK_LIBRARY_DIRS}/Release/vtkImaging.dll
         ${VTK_LIBRARY_DIRS}/Release/vtkRendering.dll 
         ${VTK_LIBRARY_DIRS}/Release/vtkVolumeRendering.dll
         ${VTK_LIBRARY_DIRS}/Release/vtkverdict.dll 
         ${VTK_LIBRARY_DIRS}/Release/vtkDICOMParser.dll 
         ${VTK_LIBRARY_DIRS}/Release/vtkNetCDF.dll 
         ${VTK_LIBRARY_DIRS}/Release/vtkNetCDF_cxx.dll
         ${VTK_LIBRARY_DIRS}/Release/vtkexpat.dll 
         ${VTK_LIBRARY_DIRS}/Release/vtkjpeg.dll 
         ${VTK_LIBRARY_DIRS}/Release/vtkmetaio.dll 
         ${VTK_LIBRARY_DIRS}/Release/vtkpng.dll 
         ${VTK_LIBRARY_DIRS}/Release/vtktiff.dll 
         ${VTK_LIBRARY_DIRS}/Release/vtkzlib.dll 
         ${VTK_LIBRARY_DIRS}/Release/vtkInfovis.dll 
         ${VTK_LIBRARY_DIRS}/Release/vtkfreetype.dll 
         ${VTK_LIBRARY_DIRS}/Release/vtkftgl.dll
         ${VTK_LIBRARY_DIRS}/Release/vtkalglib.dll 
         ${VTK_LIBRARY_DIRS}/Release/vtklibxml2.dll 
         ${VTK_LIBRARY_DIRS}/Release/vtkViews.dll 
         ${VTK_LIBRARY_DIRS}/Release/vtkexoIIc.dll
         ${VTK_LIBRARY_DIRS}/Release/vtkWidgets.dll  
         ${VTK_LIBRARY_DIRS}/Release/vtkhdf5.dll 
         ${VTK_LIBRARY_DIRS}/Release/vtkhdf5_hl.dll 
         ${VTK_LIBRARY_DIRS}/Release/LSDyna.dll
         # Xerces-c dependency
         ${XERCESC_ROOT_DIR}/bin/xerces-c_3_1.dll 
         # Libxml2 dependencies
         ${LIBXML2_INCLUDE_DIR}/../bin/iconv.dll
         ${LIBXML2_INCLUDE_DIR}/../bin/libxml2.dll
         ${LIBXML2_INCLUDE_DIR}/../bin/zlib1.dll
         # ITK dependency 
         ${ITK_ROOT_DIR}/bin/ITKCommon.dll
         )
		 
      endif()
      
            
      # Application icon
      set(CAMITK_PACKAGE_ICON "${CMAKE_CURRENT_SOURCE_DIR}\\\\core\\\\resources\\\\appIcon.ico") #set here the current icon for CamiTK
      set(CPACK_PACKAGE_ICON ${CAMITK_PACKAGE_ICON}) #icon for the top bar NSIS installer
      set(CPACK_NSIS_MUI_ICON ${CAMITK_PACKAGE_ICON}) #icon for the generated install program (the .exe to run to install CamiTK).
      set(CPACK_NSIS_MUI_UNIICON ${CAMITK_PACKAGE_ICON}) #icon for the generated uninstall program (the .exe to run to uninstall CamiTK).
      
      # Create desktop icons, by forcing CPack to build an internal command, as 'set(CPACK_NSIS_MODIFY_PATH ON)' option setted in the additional page doesn't work.
      set(CPACK_NSIS_EXTRA_INSTALL_COMMANDS "CreateShortCut \\\"$DESKTOP\\\\${CAMITK_PROJECT_NAME}-imp.lnk\\\" \\\"$INSTDIR\\\\bin\\\\imp.exe\\\"")              
            
      # Tell CPack to remove the icons after uninstalling
      set(CPACK_NSIS_EXTRA_UNINSTALL_COMMANDS "Delete \\\"$DESKTOP\\\\${CAMITK_PROJECT_NAME}-imp.lnk\\\"")
            
      # Installer name
      set(CPACK_NSIS_DISPLAY_NAME "CamiTK ${CAMITK_VER_MAJ}.${CAMITK_VER_MIN}.${CAMITK_VER_PACKAGE_PAT}")
      set(CPACK_NSIS_INSTALLED_ICON_NAME ${CAMITK_PROJECT_NAME})
      
      set(CPACK_PACKAGE_INSTALL_DIRECTORY ${CAMITK_PROJECT_NAME})
      set(CPACK_NSIS_HELP_LINK "http:\\\\\\\\camitk.imag.fr")
      set(CPACK_NSIS_URL_INFO_ABOUT "http:\\\\\\\\camitk.imag.fr")
      set(CPACK_NSIS_CONTACT ${CPACK_PACKAGE_CONTACT})
      # include(InstallRequiredSystemLibraries)
   else()
       message(STATUS "Can not find makensis: nsis packaging is not possible")
   endif()

endif()

# ---------------
# Mac App Bundle
# ---------------
if(APPLE)
    # TODO test this!
    set(CPACK_GENERATOR "PackageMaker")
    # Libraries are bundled directly
    set(CPACK_COMPONENT_LIBRARIES_HIDDEN TRUE)
    # Bundle Properties
    set(MACOSX_BUNDLE_BUNDLE_NAME ${CPACK_PACKAGE_NAME})
    set(MACOSX_BUNDLE_BUNDLE_VERSION ${PROJECT_VERSION})
    set(MACOSX_BUNDLE_SHORT_VERSION_STRING ${PROJECT_VERSION})
    set(MACOSX_BUNDLE_LONG_VERSION_STRING "Version ${PROJECT_VERSION}")
endif()


# -------------------------------------
# System and dependencies requirements
# -------------------------------------
include(InstallRequiredSystemLibraries)


# and here we go...
include(CPack)


# ----------------------------------
# CamiTK specific packaging targets
# ----------------------------------

# create specific target for package source
add_custom_target(camitk_package_source
    COMMAND ${CMAKE_COMMAND}
        -E copy ${CAMITK_BINARY_DIR}/CamiTKPackageVersion.h
                ${CAMITK_SOURCE_DIR}/core/CamiTKVersion.h
    COMMAND ${CMAKE_COMMAND}
        --build ${CMAKE_BINARY_DIR}
        --target package_source
    COMMAND ${CMAKE_COMMAND}
        -E remove ${CAMITK_SOURCE_DIR}/core/CamiTKVersion.h
)

# create specific target for binary package
add_custom_target(camitk_package
    COMMAND ${CMAKE_COMMAND}
        -E copy ${CAMITK_BINARY_DIR}/core/CamiTKVersion.h
                ${CAMITK_BINARY_DIR}/core/CamiTKVersion.h-backup
    COMMAND ${CMAKE_COMMAND}
        -E copy ${CAMITK_BINARY_DIR}/CamiTKPackageVersion.h
                ${CAMITK_BINARY_DIR}/core/CamiTKVersion.h
    COMMAND ${CMAKE_COMMAND}
        --build ${CMAKE_BINARY_DIR}
        --target package
    COMMAND ${CMAKE_COMMAND}
        -E copy ${CAMITK_BINARY_DIR}/core/CamiTKVersion.h-backup
                ${CAMITK_BINARY_DIR}/core/CamiTKVersion.h
)
