/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/
#include "ExtensionWindow.h"
#include "ExtTypeWindow.h"
#include "ExtensionGenerator.h"



#include "Extension.hxx"

#include <QString>
#include <QFileDialog>
#include <QMessageBox>
#include <QFileInfo>
#include <QTextStream>

#include <iostream>

using namespace coreschema;

ExtensionWindow::ExtensionWindow(QMainWindow * dad, QString workingDirectory, ExtTypeType extType) : QMainWindow(dad)
{
    ui.setupUi(this);
	this->extType = extType;
    this->dad = dad;
    this->workingDirectory = workingDirectory;
	this->personnalizeInterface();
}

QString ExtensionWindow::getExtensionClassName() {
    return ui.extensionClassNameLineEdit->text();
}
void ExtensionWindow::addExtTypeButtonClicked() {
	ExtTypeWindow * element = new ExtTypeWindow(this, workingDirectory, extType);
	element->show();
}


void ExtensionWindow::cancelClicked() {
    this->hide();
    dad->show();
}

void ExtensionWindow::rleToggle(RemovableLineEdit * rle,  bool res) {
	if (res == true) {
		QList<RemovableLineEdit *>::const_iterator it;
		for (it = extTypeFiles.begin(); it < extTypeFiles.end(); it++) {
			if ((*it) != rle) {
				(*it)->ui.TopLevelRadioButton->setChecked(false);
			}
		}
	}
}


void ExtensionWindow::addExtTypeFile(QString extTypeFileName) {

    RemovableLineEdit * extTypeLine = new RemovableLineEdit(this);
	switch (this->extType) {
		case Component:
			extTypeLine->ui.TopLevelRadioButton->show();
			if (this->extTypeFiles.empty()) {
				extTypeLine->ui.TopLevelRadioButton->setChecked(true);
			}
			break;
		default:
			extTypeLine->ui.TopLevelRadioButton->hide();
			break;
	}
    extTypeLine->ui.lineEdit->setText(extTypeFileName);
    extTypeLine->ui.lineEdit->setDisabled(true);
    this->extTypeFiles.push_back(extTypeLine);
	
	ui.addTypeButtonLayout->addWidget(extTypeLine);
}

void ExtensionWindow::addExtFileButtonClicked() {
	RemovableLineEdit * fileExt;
	switch(this->extType) {
		case Component:
			fileExt = new RemovableLineEdit(this);
			fileExt->ui.dotLabel->show();
			fileExt->ui.lineEdit->setText("example");
			fileExt->ui.TopLevelRadioButton->hide();
			this->fileExts.push_back(fileExt);

			ui.addFileExtensionHLayout->removeItem(ui.addTypeButtonLayout);
			ui.addFileExtensionHLayout->addWidget(fileExt);
			ui.addFileExtensionHLayout->addItem(ui.addTypeButtonLayout);
			break;

		default:
			break;
	}
}

void ExtensionWindow::removeExtTypeFile(RemovableLineEdit * extTypeRLE) {
	int index = extTypeFiles.indexOf(extTypeRLE);
	if (index > -1) {
	    ui.addTypeGroupBox->layout()->removeWidget(extTypeRLE);
		this->extTypeFiles.removeAt(index);
		delete extTypeRLE;
	}

	index = fileExts.indexOf(extTypeRLE);
	if (index > -1) {
		ui.addFileExtensionHLayout->removeWidget(extTypeRLE);
		this->fileExts.removeAt(index);
		delete extTypeRLE;
	}
}

void ExtensionWindow::addItkDependency() {
	ui.itkCheckBox->setChecked(true);
}

void ExtensionWindow::personnalizeInterface() {
	QString typeStr = "";
	QString aTypeStr = "";
	switch (extType) {
		case Action:
			typeStr = "Action";
			aTypeStr = "an Action";
			ui.fileExtensionGroupBox->hide();
			break;
		case Component:
			typeStr = "Component";
			aTypeStr = "a Component";
			ui.fileExtensionGroupBox->show();
			this->addExtFileButtonClicked();
			break;
		default:
			typeStr = "???";
			aTypeStr = "a What ?!?";
			ui.fileExtensionGroupBox->hide();
			break;
	}

	QString title = typeStr + " Extension";
	ui.titleLabel->setText(title);
	ui.extensionNameLineEdit->setText("Example of " + typeStr + " Extension");
	QString desc = "This extension is generated automatically and aims at showing CamiTK new users how to easily write an extension with one or several ";
	desc += typeStr + "(s)";
	ui.extensionDescriptionPlainTextEdit->setPlainText(desc);
	ui.extensionClassNameLineEdit->setText(typeStr + "ExtensionExample");

	ui.addTypeGroupBox->setTitle(typeStr + "s");
	ui.addTypePushButton->setText("Add " + aTypeStr);

	QString neededComps = "<!DOCTYPE HTML PUBLIC '-//W3C//DTD HTML 4.0//EN' 'http://www.w3.org/TR/REC-html40/strict.dtd'>";
	neededComps += "<html><head><meta name='qrichtext' content='1' /><style type='text/css'>";
	neededComps +="p, li { white-space: pre-wrap; }</style></head>";
	neededComps +="<body style=' font-family:\"Times New Roman\"; font-size:10pt; font-weight:400; font-style:italic;'>";
	neededComps += "<p style='margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;'>";
	neededComps +="Please check the components your types will need.</p>";
	neededComps +="<p align='justify' style=' margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;'>";
	neededComps += "<span style=' font-weight:600; text-decoration: underline;'>Note</span>: ";
	neededComps += "If your " + typeStr + " uses a generic volume images (<span style=' font-style:normal;'>";
	neededComps += "ImageComponent</span>) and/or generic meshs (<span style=' font-style:normal;'>";
	neededComps += "MeshComponent</span>) no matter the way they were open or will be saved, ";
	neededComps += "you DO NOT need to check any of the following. </p></body></html>";

	ui.neededComponentsTextBrowser->setText(neededComps);

}

void ExtensionWindow::okClicked() {

    // Extension object creation
    Extension::name_type name(ui.extensionNameLineEdit->text().toStdString());
    Extension::description_type description(ui.extensionDescriptionPlainTextEdit->toPlainText().toStdString());
    Extension::extensionClass_type extensionClass(ui.extensionClassNameLineEdit->text().toStdString());
    coreschema::Extension ext(name, description, extensionClass);
	Components::componentExtension_sequence fileExtSeq;
	
	Actions myActions;
	Components myComponents;
	switch (extType) {
		case Action:
		    ext.type("action");		    
		    // List of actions
			foreach (RemovableLineEdit * action, this->extTypeFiles) {
				Actions::actionFile_type act(action->ui.lineEdit->text().toStdString());
				myActions.actionFile().push_back(act);
			}
		    ext.actions(myActions);
			break;
		case Component:
			ext.type("component");		   
		    // List of components
			foreach (RemovableLineEdit * component, this->extTypeFiles) {
				Components::componentFile_type comp;
				comp.TopLevel(component->ui.TopLevelRadioButton->isChecked());
				comp.file(component->ui.lineEdit->text().toStdString());
				myComponents.componentFile().push_back(comp);
			}
			foreach (RemovableLineEdit * fileExt, this->fileExts) {
				Components::componentExtension_type compFileExt;
				compFileExt.name(fileExt->ui.lineEdit->text().toStdString());
				fileExtSeq.push_back(compFileExt);
			}
			myComponents.componentExtension(fileExtSeq);
			ext.components(myComponents);
			
			break;
		default:
			break;
	}

   // External needs
    // Components
    QStringList neededComponents;
    if (ui.dicomComponent->isChecked())
        neededComponents << "dicom";
    if (ui.itkimage->isChecked())
        neededComponents << "itkimage";
    if (ui.physicalmodel->isChecked())
        neededComponents << "physicalmodel";
    if (ui.mml->isChecked())
        neededComponents << "mml";
    if (ui.vtkimage->isChecked())
        neededComponents << "vtkimage";
    if (ui.vtkmesh->isChecked())
        neededComponents << "vtkmesh";
    if (! ui.otherNeededCompLlineEdit->text().isEmpty())
        neededComponents << ui.otherNeededCompLlineEdit->text().split(" ");
    
    foreach(QString comp, neededComponents) {
        External extComp("component", comp.toStdString());
        ext.external().push_back(extComp);
    }

    // Tools    
    QStringList neededTools;
    if (ui.mmlTool->isChecked())
        neededTools << "mml";
    if (ui.lmlTool->isChecked())
        neededTools << "lml";
    if (ui.pmlTool->isChecked())
        neededTools << "pml";
    foreach(QString tool, neededTools) {
        External extTool("tool", tool.toStdString());
        ext.external().push_back(extTool);
    }

    // Libs
    if (ui.itkCheckBox->isChecked()) {
        External lib("library", "ITK");
        lib.additional("ITKBasicFilters ITKCommon ITKIO");
        ext.external().push_back(lib);
    }
    if (ui.OpenCVCheckBox->isChecked()) {
        External lib("library", "OPENCV");
        ext.external().push_back(lib);
     }
    if (ui.libXml2CheckBox->isChecked()) {
        External lib("library", "LIBXML2");
        ext.external().push_back(lib);
    }

    // Serialization of ext to a std::string
    xml_schema::namespace_infomap map;
    map[""].schema = "../../schemas/Extension.xsd";
    std::ostringstream oss;
    extension(oss, ext, map);
    std::string xml (oss.str ());
  
    // Writing in the right xml file
    QString extensionClassName(ui.extensionClassNameLineEdit->text());
	QDir xmlDir(this->workingDirectory);
	if (!xmlDir.exists("xml"))
		xmlDir.mkdir("xml");
	xmlDir.cd("xml");
    QFileInfo xmlFileInfo;
	xmlFileInfo.setFile(xmlDir.absolutePath(), extensionClassName + ".xml");
    QFile xmlFile(xmlFileInfo.absoluteFilePath());
    if (! xmlFile.open(QIODevice::WriteOnly | QIODevice::Text)) {
        QString msg = "Exception from extension xml file generation \n    Cannot write on file " + xmlFileInfo.absoluteFilePath() + "\n";
        throw msg;
    }
    QTextStream qout(&xmlFile);
    qout << xml.c_str();
    xmlFile.close();


    // Creating .h and .cpp
	try {
	    ExtensionGenerator::generateExtensionFiles(xmlFileInfo.absoluteFilePath(), workingDirectory);
	} catch (QString e) {
		QMessageBox::warning(this, "Could not produce .h and .cxx files", e);
	}

	this->close();

}

