/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

// -- command line options
#include "CommandLineParser.h"

// -- Application Imp stuff
#include "ImpMainWindow.h"

// -- Core stuff
#include <Application.h>
#include <Core.h>
#include <ExtensionManager.h>
using namespace camitk;

// Complete description 
// If you modify this description, PLEASE do not forget to 
// also update the associated "camitk-imp.1" man page 
// (both texts should be marginally different)
const char* description = "Please visit http://camitk.imag.fr for more information.\n"
"(c) UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525\n\n"
"camitk-imp is a medical image analysis and modeling software.\n"
"This is the flagship GUI application of a larger framework called CamiTK\n"
"(Computer Assisted Medical Interventions Tool Kit) designed to ease the\n"
"collaborative work of a research team.\n\n"
"The targeted users are in R&D departments or laboratories.\n"
"camitk-imp provides an easy and interactive access to all your data and\n"
"algorithm parameters.\n\n"
"camitk-imp can visualize medical images from a lot of different (standard)\n"
"formats, offers image processing and segmentation algorithms to reconstruct a\n"
"mesh geometry and run a biomechanical simulation.\n\n"
"For a tutorial on camitk-imp, please visit the website:\n"
"https://forge.imag.fr/plugins/mediawiki/wiki/camitk/index.php/Camitk-imp_tutorial\n\n"
"CamiTK is highly modular and make an extensive use of extensions (plugins).\n\n"
"CamiTK goals are to:\n"
"- Gather knowledge & know-how from several fields\n"
"- Avoid reinventing the wheel\n"
"- Accelerate the integration/validation of new algorithms\n"
"- Provide fast technological transfer between students (PhD and others), \n"
"  research scientists, clinicians and industrial partners\n"
"- Rapidly provide a stable and usable prototype for clinicians\n"
"- Support for lectures and dissemination";

int main(int argc, char *argv[]) {    
    // parse command line
    CommandLineParser clp(argc, argv);
    clp.setDescription(description);
    clp.addOption("noConsole", "Disable CamiTK application console and redirect everything to\n                     the standard output  (default=off)");
    clp.addOption("printPath", "Print CamiTK path on the standard output and exit\n");
    clp.addOption("config", "Print all information for a complete CamiTK diagnosis and exit\n");
    clp.parse();

    // init the camitk application context
    Application a("imp", argc, argv);

    if (clp.option("printPath")) {
      std::cout << "CamiTK version: " << Core::version << std::endl;
      std::cout << "- Install Directory............... " << Core::installDir << std::endl;
      std::cout << "- Core Library Directory.......... " << Core::getCoreLibDir().toStdString() << std::endl;
      std::cout << "- Test Data Directory............. " << Core::getTestDataDir().toStdString() << std::endl;
      std::cout << "- Component Extension Directory... " << Core::getComponentDir().toStdString() << std::endl;
      std::cout << "- Action Extension Directory...... " << Core::getActionDir().toStdString() << std::endl;
      exit(EXIT_SUCCESS);
    }

    if (clp.option("config")) {
      std::cout << Core::getConfig().toStdString() << std::endl;
      exit(EXIT_SUCCESS);
    }
    
    // set the ImpMainWindow as the main window
    a.setMainWindow(new ImpMainWindow());
    
    // check for given filenames
    for (std::vector<std::string>::iterator it = clp.getRemainingArguments().begin(); it!=clp.getRemainingArguments().end(); it++)
      Application::open((*it).c_str()); 

    return a.exec();
}

