/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2012 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/
#include "BasicCellProperties.h"

//----------------------- Class member init -----------------------
void BasicCellProperties::resetUniqueIndex() {
  BasicCellProperties::maxUniqueIndex = 0;
}

BasicCellProperties::BasicCellProperties(PhysicalModel * p, const StructureProperties::GeometricType t, xmlNodePtr node)  : StructureProperties(p, t) {

  //search the name attribute
  xmlChar *pname = xmlGetProp(node, (const xmlChar*) "name");

  if (pname)
    setName((char*)pname);

  xmlFree(pname);

  //search the index attribute
  xmlChar *pindex = xmlGetProp(node, (const xmlChar*) "index");

  if (pindex)
    index = atoi((char*)pindex);
  else
    index = maxUniqueIndex++;

  xmlFree(pindex);

  //search the unknown attributes to fill the property fields map
  xmlAttr * attrs = node->properties;

  xmlNodePtr unknownAttrs = xmlNewNode(NULL, (xmlChar*)("unknownAttrs"));

  while (attrs)
  {
    const xmlChar * pname = attrs->name;
    xmlChar * pval = attrs->children->content;

    if (pname && xmlStrcmp(pname, (xmlChar*)"name")
        && xmlStrcmp(pname, (xmlChar*)"x")
        && xmlStrcmp(pname, (xmlChar*)"y")
        && xmlStrcmp(pname, (xmlChar*)"z")
        && xmlStrcmp(pname, (xmlChar*)"type")
        && xmlStrcmp(pname, (xmlChar*)"index")){
          xmlSetProp(unknownAttrs, pname, pval);
    }

    attrs = attrs->next;
  }

  //transform the unknown attributes to a property field map
  domToFields(unknownAttrs);
  xmlFree(unknownAttrs);
}

// initializing the static class member
unsigned int BasicCellProperties::maxUniqueIndex = 0;

//----------------------- Constructors -----------------------
BasicCellProperties::BasicCellProperties(PhysicalModel *p, const StructureProperties::GeometricType t)  : StructureProperties(p, t) {
  index = maxUniqueIndex++;
}

BasicCellProperties::BasicCellProperties(PhysicalModel *p, const StructureProperties::GeometricType t, const unsigned int ind)  :  StructureProperties(p, t) {
  index = ind;

  if (ind >= maxUniqueIndex)
    maxUniqueIndex = ind + 1;
}

/// write the default xml properties (beginning)
void BasicCellProperties::beginXML(std::ostream & o) {
  o << "<cellProperties index=\"" << index << "\"";
  // print the type

  switch (getType()) {

    case StructureProperties::TETRAHEDRON:
      o << " type=\"TETRAHEDRON\"";
      break;

    case StructureProperties::HEXAHEDRON:
      o << " type=\"HEXAHEDRON\"";
      break;

    case StructureProperties::WEDGE:
      o << " type=\"WEDGE\"";
      break;

    case StructureProperties::POLY_LINE:
      o << " type=\"POLY_LINE\"";
      break;

    case StructureProperties::POLY_VERTEX:
      o << " type=\"POLY_VERTEX\"";
      break;

    case StructureProperties::LINE:
      o << " type=\"LINE\"";
      break;

    case StructureProperties::TRIANGLE:
      o << " type=\"TRIANGLE\"";
      break;

    case StructureProperties::QUAD:
      o << " type=\"QUAD\"";
      break;

    default:
      o << " type=\"???\"";
      break;
  }

  if (getName() != "")
    o << " name=\"" << getName().c_str() << "\" ";

}

/// write the default xml properties (end)
void BasicCellProperties::endXML(std::ostream & o) {
  o << "/>" << std::endl;
}
