/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2012 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/


#include "tools/Tools.h"

#include <iostream>
#include "math.h"

// -------------------- distance --------------------
double distance(double pos[3], double pos2[3]){
  return sqrt(  (pos[0] - pos2[0])*(pos[0] - pos2[0])
              + (pos[1] - pos2[1])*(pos[1] - pos2[1])
              + (pos[2] - pos2[2])*(pos[2] - pos2[2]));
}

// -------------------- timeParameter2double --------------------
double timeParameter2double(mml::TimeParameter& t){
  switch (t.unit()){
    case mml::TimeUnit::ms: return 0.001*t.value(); break;
    case mml::TimeUnit::s: return 1*t.value(); break;
    case mml::TimeUnit::min: return 60*t.value(); break;
    default: std::cerr << "Time unit error" << std::endl;
  }
  return 0;
}