/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2012 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef IMAGEVOLUMEMANAGERComponentPOPUP_H
#define IMAGEVOLUMEMANAGERComponentPOPUP_H


// -- Core stuff
#include "ComponentPopupMenu.h"

// -- VTK stuff
#include <vtkSmartPointer.h>
#include <vtkImageData.h>


namespace camitk {

// -- Core image component stuff classes
class MedicalDataOriginDialog;
class ImageComponent;


/** The popup menu of the Image Volume manager data component.
  *
  */

class ImageComponentPopup : public ComponentPopupMenu  {

    Q_OBJECT

public:
    ImageComponentPopup ( camitk::Component *, QWidget* );
    ~ImageComponentPopup();


public slots:
    /// update the check box state
    void updateDisplayIn3D ( bool );

    void selectOrigin();

    /// Show/hide the  volume in the 3D viewer.
    void displayIn3D();

private:


    MedicalDataOriginDialog * medicalDataOriginDialog;

    ImageComponent * dad;

    vtkSmartPointer<vtkImageData> imgData;


    /// Image filter sub-menu
    QMenu * imageFilterMenu;

    /// The id of the displayIn3D action in the popup menu
    QAction* displayIn3Did;

};

}

#endif
