/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2012 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef CAMITKCORE_H
#define CAMITKCORE_H

// -- Core stuff
#include "CamiTKAPI.h"

namespace camitk
{
/**
 * Core class specifies the basic static information for the CamiTK API.
 */
class CAMITK_API Core {
public:
    
    /// @name runtime directory information
    ///@{
    /// get the camitk component extension directory name
    /// @return a null QString, checkable with isNull(), if no component dir found
    static const QString getComponentDir();
    
    /// get the camitk action directory name
    /// @return a null QString, checkable with isNull(), if no action dir found
    static const QString getActionDir();
    
    /// get the camitk module extension directory name
	/// @param subpath name of the module type (and subdirectory) to get (this simplifies getting the subdir name on plateform with hasBuildTypeDirectory() 
    /// @return a null QString, checkable with isNull(), if no module dir found
    static const QString getModuleDir(const QString & subpath = QString());
    
    /// get the camitk test data directory name
    /// @return a null QString, checkable with isNull(), if no test data directory found
    static const QString getTestDataDir();

    /// get the camitk core lib directory name (where the camitkcore dll/shared/dynamic lib is)
    static const QString getCoreLibDir();
    ///@}

    /// @name miscallaneous utility method or variables
    ///@{    
    /// complete version string
    static const char *version;
    /// short version string (all in lower case, without the patch number)
    static const char *shortVersion;
    /// fall-back install directory (if the autodetection did not work...)
    static const char *installDir;
    ///@}
    
private:
    /// check if plateform has debug/release subdirs 
    /// @return null string if not debug/release plateform or build type if debug/release plateform
    static const QString hasBuildTypeDirectory();
    
    /// check if on MacOS (TODO test this!)
    static const bool hasMacOSDirectory();
    
    /// check if installed
    static const bool isInstalled();
    
    /// get the camitk root directory name (it is either the build dir or the installation directory)
    /// @return a null QString, checkable with isNull(), if no installation dir found
    static const QString getRootDir();
    
    /// @return true only if the camitk core lib is in the given directory
    static bool checkCoreLibDir(QString dir);
    
    /// name of main directory where the shared lib (dll, so or dylib) can be found 
    /// It is "bin" on windows, "lib" on unix (unless isInstalled() is true, then it is still in bin)
    static const QString sharedDirectory();
    
    /// does this plateform puts all dll/so/dylib in a CamiTK::shortVersion directory
    static const bool hasBinaryVersionSubdir();

	/// return the name of the bin directory 
	static const QString getBinDirName();

	/// name of the bin directory (can be "bin" or "binDebug" for installed debug version!)
	static QString binDirName;
};

}

#endif // CAMITKCORE_H
