/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2012 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef LoadsSimulation_H
#define LoadsSimulation_H

#include <QDialog>

#include "ui_AnimationMotorDialog.h"

//class used in this file
class LoadsSimulation;
class LoadsManager;
class LoadsSimulationDriver;
class AnimationMotorAddon;
class QToolBar;

/** This dialog allows to run a simulation using a simulation motor.
 *	It plays the impload, allowing the user to see the evolution of translations along time.
 *
 *	

 */
class LoadsSimulation : public QDialog {
    Q_OBJECT

public:
    /**Default Constructor*/
    LoadsSimulation(LoadsManager * myLoadsManager,  QWidget* parent = 0);
    /**Destructor*/
    virtual ~LoadsSimulation();

    /// get the actual time
    double getTime() const;

    /** update time display
     *  @param getMotorTime if force is true, then the time taken by the method is not the simulation
     *                driver time, but the animation motor add-on time.
     */
    void updateTime(bool getMotorTime=false);

    /// add a tabulation (will be remove when the current animation motor add-on will be removed
    void addTab(QWidget *);

    /** update the display (the boolean indicates if the scene3d has to be refresh or not)
      * @param force if true force display update independantly from refresh dt (default is false)
     */
    void updateDisplay(bool force);

public slots :

    /** do one step of simulation
      * @return true only if the step was done (it happens that it can not be done if the timer is too fast, so it might return false sometimes)
      */
    bool doOneStep();

    /// Slot called when the button Pause is clicked
    void pause();

    /// Slot called when the button Play is clicked
    void simulate();

    /// Slot called when the next step is clicked
    void simulateOneStep();

    /// Slot called when the button Rewind is clicked
    void rewind();

    /// dialog is closed
    virtual void reject();

    // other widget interaction slots:
    virtual void dtChanged();
    virtual void tMaxChanged();
    virtual void dtModified();
    virtual void tMaxModified();
    virtual void refreshDtChanged();
    virtual void refreshDtModified();
    virtual void chooseOutputDir();
    virtual void videoToggled(bool);

    /// adding a animation motor add-on (in the 2nd tab)
    virtual void addAnimationMotorAddon();

    /// init display
    void init();

private :

    /// set the rew,play,pause,step buttons enable or not
    void enableButtons(bool enable);

    /// load a animation motor add-on using a filename (shared lib location)
    void loadAddon(QString);
	QString addonFilename;

    /// the load manager
    LoadsManager * myLM;

    /// the initial bg color
    QColor bgColor;

    /// the code core for the display of a loads
    LoadsSimulationDriver * simDriver;

    /// the motor
    AnimationMotorAddon * myMotor;

    /// the tool bar
    QToolBar *simulationToolBar;

    /// toolbar t line edit
    QLineEdit *tLineEditToolbar;

    /// the output directory name for making videos
    QString outputDirName;

    /// the output directory name for making videos
    QString outputDir;

    /// the number of screenshots
    unsigned int imageId;

    /// toolbar buttons
    QAction *rewindToolbar;
    QAction *playToolbar;
    QAction *playOneStepToolbar;
    QAction *pauseToolbar;

    /// record video or not?
    bool video;

    /// if there is no output directory we can't make video
    bool output;

    /// total elapsed time (to calculate simulator frequency)
    double elapsed;

    /// total nr of iteration computed (to calculate simulator frequency)
    double iterationCount;

    /// the ui dialog designed in qtdesigner
    Ui::AnimationMotorDialog ui;
};



#endif // LoadsSimulation_H


