/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2012 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#include<monitoringgui/MonitoringGuiManager.h>
#include<monitoringgui/MonitoringDialog.h>
#include<monitoring/manager/MonitoringManager.h>

#include <Log.h>

#include <AbortException.h>

#include <PMManagerDC.h>


#include "MMLComponent.h"

#include "MMLDisplay.h"
#include "MMLComponentPopup.h"



#include <Application.h>
#include <MainWindow.h>

#include <QDockWidget>
#include <QMessageBox>



// -------------------- default constructor --------------------
MMLComponent::MMLComponent(const QString & fileName) throw(AbortException) : Component(fileName, QFileInfo(fileName).baseName()) {
    myPopupMenu = NULL;
    QString file = fileName;
    QFileInfo fi = QFileInfo(myFileName);

    try {
        // initialize the MML export file name
        exportedMml = "";
        if (fi.completeSuffix() == "scn") {
            file = QFileInfo(fi).absolutePath() + "/" + QFileInfo(fi).baseName() + ".mml";
            // check if the mml already exist
            if (!QFileInfo(file).exists()) {
                // create an empty mmlIn file with .scn (in the same directory as the .scn)
                mml::TimeParameter dt = mml::TimeParameter(0.1, "s");
                mml::TimeParameter refresh = mml::TimeParameter(1, "s");
                mml::MonitoringIn mmlIn(dt, refresh, "sofa");
                mmlIn.simulatorFile(fi.fileName().toStdString().c_str());

                xml_schema::namespace_infomap map;
                map[""].name = "";
                map[""].schema = "";

                exportedMml = file;

                ofstream ofs(exportedMml.toStdString().c_str());
                mml::monitoringIn(ofs, mmlIn, map);
            }
            else {
                CAMITK_ERROR("MMLComponent", "constructor", "Cannot create MMLComponent from " + myFileName.toStdString() + ": mml file exists.\nPlease try to open " + file.toStdString());
                throw AbortException("Cannot create MMLComponent from " + myFileName.toStdString() + ": mml file exists.\nPlease try to open " + file.toStdString());
            }
        }

        mmlGUI = new MonitoringGuiManager;
        display = new MMLDisplay(this);
        mmlDock = new QDockWidget(fi.baseName(), Application::getMainWindow());
        mmlDock->setAllowedAreas(Qt::RightDockWidgetArea);
        mmlDock->setWidget(mmlGUI->getDialog());
        Application::getMainWindow()->addDockWidget(Qt::RightDockWidgetArea, mmlDock);
        mmlGUI->loadMmlInFile(file);
        // this gives the ownership of pml pointer to the PMManagerDC, use takePml() not getPml()
        pmMgr = new PMManagerDC( mmlGUI->getMonitoringManager()->takePml(),  mmlGUI->getMonitoringManager()->getPmlFileName().c_str());
        addChild(pmMgr);
    }
    catch (xml_schema::exception & e) {
        CAMITK_ERROR("MMLComponent", "constructor", "xml_schema exception, attempt to read from " + myFileName.toStdString() << endl << e);
        throw AbortException("Cannot create MMLComponent from " + myFileName.toStdString() + ": xml_schema exception.\nReason: " + e.what());
    }
}

// ---------------------- destructor ----------------------------
MMLComponent::~MMLComponent() {
    /*if (exportedMml!="")
      remove(exportedMml.toStdString().c_str());
    */
    if (pmMgr) {
        delete pmMgr;
        pmMgr = NULL;
    }
    //mmlGUI->getMonitoringManager()->setPml(NULL);
    if (mmlGUI) {
        delete mmlGUI;
        mmlGUI = NULL;
    }
    if (display) {
        delete display;
        display = NULL;
    }
    if (myPopupMenu) {
        delete myPopupMenu;
        myPopupMenu = NULL;
    }
    if (mmlDock) {
        Application::getMainWindow()->removeDockWidget(mmlDock);
        delete mmlDock;
        mmlDock = NULL;
    }
}

// -------------------- getMonitoringGuiManager --------------------
MonitoringGuiManager* MMLComponent::getMonitoringGuiManager() {
    return mmlGUI;
}

// -------------------- getPMManager --------------------
PMManagerDC* MMLComponent::getPMManager() {
    return pmMgr;
}

// -------------------- getDisplay --------------------
MMLDisplay* MMLComponent::getDisplay() {
    return display;
}


// -------------------- connectPml --------------------
void MMLComponent::connectPml() {
    removeChild(pmMgr);
    delete pmMgr;
    pmMgr = NULL;
    deleteChildren();
    refreshInterfaceNode();
    // this gives the ownership of pml pointer to the PMManagerDC, use takePml() not getPml()
    pmMgr = new PMManagerDC( mmlGUI->getMonitoringManager()->takePml(),  mmlGUI->getMonitoringManager()->getPmlFileName().c_str());
    addChild(pmMgr);
    refreshInterfaceNode();
    pmMgr->refresh();
    display->updateDisplay();
}

// -------------------- getPopupMenu --------------------
QMenu * MMLComponent::getPopupMenu(QWidget* parent) {
    if (!myPopupMenu) {
        myPopupMenu = new MMLComponentPopup(this, parent);
    }

    return myPopupMenu;
}

// -------------------- isDockVisible --------------------
bool MMLComponent::isDockVisible() {
    return mmlDock->isVisible();
}

// -------------------- setDockVisible --------------------
void MMLComponent::setDockVisible(bool visible) {
    mmlDock->setVisible(visible);
}
