#----------------------------
# CamiTK extension packaging
#---------------------------

# See also CamiTKPackaging.cmake 

string(TOLOWER ${EXTENSION_NAME} CPACK_PACKAGE_NAME)
set(CPACK_PACKAGE_VERSION_MAJOR ${CAMITK_VER_MAJ})
set(CPACK_PACKAGE_VERSION_MINOR ${CAMITK_VER_MIN})

# use the nickname of the package version
set(CPACK_SOURCE_PACKAGE_FILE_NAME "${CPACK_PACKAGE_NAME}-${CPACK_PACKAGE_VERSION_MAJOR}.${CPACK_PACKAGE_VERSION_MINOR}")
set(CPACK_PACKAGE_FILE_NAME "${CPACK_SOURCE_PACKAGE_FILE_NAME}")
set(CPACK_PACKAGE_INSTALL_DIRECTORY "/")

set(CPACK_PACKAGE_VENDOR "UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525")
set(CPACK_PACKAGE_CONTACT "http://camitk.imag.fr")
set(CPACK_RESOURCE_FILE_README "${CMAKE_CURRENT_SOURCE_DIR}/README")
set(CPACK_RESOURCE_FILE_LICENSE "${CMAKE_CURRENT_SOURCE_DIR}/COPYING")
#set(CPACK_PACKAGE_EXECUTABLES "imp" "CamiTK/imp")

set(CPACK_PACKAGE_DESCRIPTION_FILE "${CMAKE_CURRENT_SOURCE_DIR}/README")
set(CPACK_PACKAGE_DESCRIPTION_SUMMARY "${EXTENSION_NAME} extension for CamiTK (Computer Assisted Medical Intervention Took Kit)")
SET(CPACK_PACKAGE_DESCRIPTION "${CPACK_PACKAGE_NAME}\n ${CPACK_PACKAGE_DESCRIPTION_SUMMARY}")

if (UNIX AND NOT WIN32)
  set(CPACK_GENERATOR "DEB" "RPM")
else()
  set(CPACK_GENERATOR "NSIS")
endif()

set(CPACK_SOURCE_GENERATOR "TGZ" "ZIP" )

set(CPACK_SOURCE_IGNORE_FILES
"~$"
"kdev4$"
"/\\\\.svn/"
"/\\\\.git/"
"/\\\\.kdev4/"
"/build/"
${CPACK_SOURCE_IGNORE_FILES}
)

# ----------------
# Debian packages
# ----------------
find_program(DPKG
    NAMES dpkg-deb
    PATHS "/usr/bin" #Add paths here
)

if ( DPKG )
    get_filename_component(DPKG_PATH ${DPKG} ABSOLUTE)
    message(STATUS "Packaging deb using ${DPKG_PATH}: OK")
    set(DPKG_FOUND "YES")
else() 
    set(DPKG_FOUND "NO")
endif()

if(DPKG_FOUND AND NOT WIN32)
    set(CPACK_DEBIAN_PACKAGE_DESCRIPTION ${CPACK_PACKAGE_DESCRIPTION})
    set(CPACK_PACKAGE_DESCRIPTION_SUMMARY ${CPACK_PACKAGE_DESCRIPTION_SUMMARY})
    set(CPACK_SET_DESTDIR TRUE)
    #set(CPACK_INSTALLED_DIRECTORIES "${CAMITK_INSTALL_ROOT}/include" "usr/include")
    set(CPACK_DEBIAN_PACKAGE_ARCHITECTURE i386) # Change to your architecture here, there is no such thing as i686 in deb!
    # TODO update list of dependencies
    set(CPACK_DEBIAN_PACKAGE_DEPENDS "libqt4-gui ( >= 4.6 ), libqt4-xml ( >= 4.6 )") # Specify other dependencies here
endif()

# -------------
# RPM packages
# -------------
# TODO test rpm packaging
find_program(RPMBUILD
    NAMES rpmbuild
    PATHS "/usr/bin"
)

if ( RPMBUILD )
    get_filename_component(RPMBUILD_PATH ${RPMBUILD} ABSOLUTE)
    message(STATUS "Packaging rpm using ${RPMBUILD_PATH}: OK")
    set(RPMBUILD_FOUND "YES")
else () 
    SET(RPMBUILD_FOUND "NO")
endif()

if(RPMBUILD_FOUND AND NOT WIN32)
    set(CPACK_SET_DESTDIR TRUE)
endif(RPMBUILD_FOUND AND NOT WIN32)


# -----------------------
# NSIS Windows installer
# -----------------------
find_program(MAKENSIS
  NAMES makensis
  PATHS "/usr/bin"
)

if(MAKENSIS)
  # NSIS Windows installer
  if(WIN32 AND NOT UNIX)
    message(STATUS "Packaging nsis using ${MAKENSIS}: OK")
    set(CMAKE_INSTALL_SYSTEM_RUNTIME_LIBS 
      ${QT_BINARY_DIR}/QtCore4.dll 
      ${QT_BINARY_DIR}/QtGui4.dll
      ${QT_BINARY_DIR}/QtSvg4.dll
      ${QT_BINARY_DIR}/QtXml4.dll
    )

    set(CPACK_NSIS_DISPLAY_NAME "${EXTENSION_NAME}")
    set(CPACK_NSIS_MODIFY_PATH ON)
    set(CPACK_PACKAGE_INSTALL_DIRECTORY ${EXTENSION_NAME})
    set(CPACK_NSIS_HELP_LINK "http:\\\\\\\\camitk.imag.fr")
    set(CPACK_NSIS_URL_INFO_ABOUT "http:\\\\\\\\camitk.imag.fr")
    set(CPACK_NSIS_CONTACT ${CPACK_PACKAGE_CONTACT})
  endif()
else()
    message(STATUS "Can not find makensis: nsis packaging is not possible")
endif()

# ---------------
# Mac App Bundle
# ---------------
if(APPLE)
    # TODO test this!
    set(CPACK_GENERATOR "PackageMaker")
    # Libraries are bundled directly
    set(CPACK_COMPONENT_LIBRARIES_HIDDEN TRUE)
    # Bundle Properties
    set(MACOSX_BUNDLE_BUNDLE_NAME ${CPACK_PACKAGE_NAME})
    set(MACOSX_BUNDLE_BUNDLE_VERSION ${PROJECT_VERSION})
    set(MACOSX_BUNDLE_SHORT_VERSION_STRING ${PROJECT_VERSION})
    set(MACOSX_BUNDLE_LONG_VERSION_STRING "Version ${PROJECT_VERSION}")
endif()

# -------------------------------------
# System and dependencies requirements
# -------------------------------------
include(InstallRequiredSystemLibraries)

# and here we go...
include(CPack)

