/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2012 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/
#include "ReportWindow.h"

#include <QDesktopServices>
#include <QFileInfo>
#include <QTextStream>
#include <QFileDialog>
#include <QMessageBox>
#include <QApplication>
#include <QXmlQuery>


ReportWindow::ReportWindow(QMainWindow * dad) : QMainWindow(dad)
{
    ui.setupUi(this);
    this->dad = dad;

    ui.forwardPushButton->setDisabled(true);
    ui.backPushButton->setDisabled(true);

}

ReportWindow::ReportWindow(QMainWindow * dad, QString fileName) : QMainWindow(dad) 
{
    ui.setupUi(this);
    this->dad = dad;
    ui.forwardPushButton->setDisabled(true);
    ui.backPushButton->setDisabled(true);

    setHTMLFile(fileName);
}

void ReportWindow::wizardPushButtonClicked() {
}

void ReportWindow::camiTKPushButtonClicked() {
    QDesktopServices::openUrl(QUrl("http://camitk.imag.fr/"));    
}
void ReportWindow::slotClose() {
    this->close();
}


void ReportWindow::slotFileOpen() {
    QString fileName = QFileDialog::getOpenFileName(this, tr("Choose an html file"), "", "File (*.html *.xml)");
    try {
        setHTMLFile(fileName);
    } catch (QString exception) {
        QMessageBox::warning(this, "Warning", exception);
        return;
    }
}

void ReportWindow::backPushButtonClicked() {
    if (backwardList.empty())
        return;
    forwardList << filename;
    filename = backwardList.last();
    ui.urlLineEdit->setText(filename);
    backwardList.pop_back();
    readHTMLFile();

    if (backwardList.empty())
        ui.backPushButton->setDisabled(true);
    ui.forwardPushButton->setDisabled(false);
}

void ReportWindow::forwardPushButtonClicked() {
    if (forwardList.empty())
        return;
    backwardList << filename;
    filename = forwardList.last();
    ui.urlLineEdit->setText(filename);
    forwardList.pop_back();
    readHTMLFile();

    if (forwardList.empty())
        ui.forwardPushButton->setDisabled(true);
    ui.backPushButton->setDisabled(false);

}

void ReportWindow::urlEdited() {
    if (! this->filename.isEmpty()) {
        backwardList << filename;
        ui.backPushButton->setEnabled(true);
    }

    filename = ui.urlLineEdit->text();
    readHTMLFile();
}

void ReportWindow::setHTMLFile(QString fileName) throw (QString) {
    if (! this->filename.isEmpty()) {
        backwardList << filename;
       ui.backPushButton->setEnabled(true);
    }

    this->filename = fileName;
    ui.urlLineEdit->setText(filename);
    readHTMLFile();
}

void ReportWindow::readHTMLFile() throw (QString) {
    QFileInfo fileInfo(filename);
    QFile htmlFile(fileInfo.absoluteFilePath());
    if (! htmlFile.open(QIODevice::ReadOnly | QIODevice::Text)) {
        QString msg = "Exception from html file reading \n    Cannot open file " + fileInfo.absoluteFilePath() + "\n";
        throw msg;
    }

    if (fileInfo.suffix() == "html") {
        QTextStream in(&htmlFile);
        ui.webView->setHtml(in.readAll(), QUrl(fileInfo.absolutePath()));
    }
    else if (fileInfo.suffix() == "xml") {
        QString fileString;
        QXmlQuery query(QXmlQuery::XSLT20);
        query.setFocus(QUrl(fileInfo.absoluteFilePath()));
        query.setQuery(QUrl("D:/cfouard/Projets/CamiTK/Dev/camitk_2.0/web/netbeansproject/web/scripts/tutorial2html.xsl"));

        if(!query.evaluateTo(&fileString))
        {
            QMessageBox::critical(this,"Erreur","Impossible d'ouvrir le fichier");
        }else{
            ui.webView->setHtml(fileString);
        }
    }

}
