/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2012 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/
#include "ExtTypeWindow.h"
#include "ExtensionWindow.h"

#include "Action.hxx"
#include "Component.hxx"
#include "ItkFilter.hxx"

#include <QString>
#include <QFileDialog>
#include <QMessageBox>
#include <QFileInfo>
#include <QTextStream>



ExtTypeWindow::ExtTypeWindow(ExtensionWindow * dad, QString workingDirectory, ExtTypeType type) : QMainWindow(dad)
{
    this->dad = dad;
	this->type = type;		
	typeStr = "";
	switch (this->type) {
		case Action:
			typeStr = "Action";
			break;
		case Application:
			typeStr = "Application";
			break;
		case Component:
			typeStr = "Component";
			break;
		case Viewer:
			typeStr = "Viewer";
			break;
		default:
			typeStr = "???";
			break;
	}

    ui.setupUi(this);
	this->personnalizeInterface();
    this->workingDirectory = workingDirectory;

}


void ExtTypeWindow::personnalizeInterface() {
	ui.centralwidget->setWindowTitle(typeStr);
	ui.centralwidget->setWindowIcon(QIcon(QString(":/resources/" + typeStr.toLower())));
    ui.componentClassLineEdit->hide();
    ui.extensionClassLineEdit->setText(dad->getExtensionClassName());

	ui.titleLabel->setText(typeStr);
	ui.extTypeNameLabel->setText("Name of the " + typeStr);
	ui.extTypeNameLineEdit->setText("Example of " + typeStr);
	ui.extTypeDescriptionLabel->setText("Description of the " + typeStr);
	ui.extTypeDescriptionPlainTextEdit->setPlainText("This " + typeStr + " is generated automatically and aims at showing CamiTK new users how to easily write a(n) " + typeStr + ".");
	ui.extensionClassNameLabel->setText("File and class name of the " + typeStr);
	ui.extTypeClassNameLineEdit->setText("Example" + typeStr);
	switch (this->type) {
		case Action:
			ui.componentGroupBox->setTitle("Component on which apply the Action");
			ui.componentInheritCheckBox->setChecked(true);
			ui.componentInheritCheckBox->hide();
			ui.parametersGroupBox->setTitle("Parameters");
			ui.addParametrPushButton->setText("Add a Parameter");
			ui.representationGroupBox->hide();
			ui.itkFilterCheckBox->setChecked(false);
			ui.itkOutputImageLabel->setEnabled(false);
			ui.itkOutputTypeComboBox->setEnabled(false);
			break;
		case Component:
			ui.componentGroupBox->setTitle("Parent component if ihnerited");
			ui.componentInheritCheckBox->setChecked(false);
			ui.componentClassComboBox->setEnabled(false);
			ui.componentClassLineEdit->setEnabled(false);
			ui.parametersGroupBox->setTitle("Properties");
			ui.addParametrPushButton->setText("add a Property");
			ui.componentGroupBox->hide();
			ui.classificationGroupBox->hide();
			break;
		default:
			ui.componentGroupBox->hide();
			break;
	}
	


}

void ExtTypeWindow::cancelClicked() {
    dad->show();
    this->hide();
}

void ExtTypeWindow::addParameterClicked() {
    ParameterWidget * parameter = new ParameterWidget(this);
    this->parameters.push_back(parameter);
    ui.parametersGroupBox->layout()->removeItem(ui.addParameterLayout);
    ui.parametersGroupBox->layout()->addWidget(parameter);
    ui.parametersGroupBox->layout()->addItem(ui.addParameterLayout);
}

void ExtTypeWindow::removeParameter(ParameterWidget * param) {
    ui.parametersGroupBox->layout()->removeWidget(param);
    parameters.removeAt(parameters.indexOf(param));
    delete param;

}

void ExtTypeWindow::addTagClicked() {
    int nbCols = 3;
    int row = tags.size() / nbCols;
    int column = tags.size() % nbCols;


    RemovableLineEdit * tag = new RemovableLineEdit(this);
    tags.push_back(tag);
    ui.tagLayout->addWidget(tag, row, column);

}

void ExtTypeWindow::removeLineEdit(RemovableLineEdit *tag) {
    ui.tagLayout->removeWidget(tag);
    tags.removeAt(tags.indexOf(tag));
    delete tag;

    int nbCols = 3;
    for (int i = 0; i < tags.size(); i++) {
        int row = i / nbCols;
        int column = i % nbCols;
        ui.tagLayout->addWidget(tags[i], row, column);
    }
}

void ExtTypeWindow::componentComboBoxChanged(QString currentItem) {
    if (currentItem == QString("Other..."))
        ui.componentClassLineEdit->show();
    else
        ui.componentClassLineEdit->hide();

	if (currentItem == QString("ImageComponent"))
		ui.itkFilterCheckBox->setEnabled(true);
	else
		ui.itkFilterCheckBox->setEnabled(false);


}

void ExtTypeWindow::okClicked() {
	bool succeed = false;
	className = ui.extTypeClassNameLineEdit->text();

	switch (this->type) {
		case Action:
			succeed = makeActionXML();
			break;
		case Component:
			succeed = makeComponentXML();
			break;
		default:
			succeed = false;
			break;
	}
	if (succeed) {
		this->dad->addExtTypeFile(QString(className + ".xml"));
		this->dad->show();
		this->close();
	}
	else {
		QString title = typeStr + " XML File Creation failed !";
		QString msg = "CamiTK Wizard was not able tocreate the corresponding ";
		msg += this->typeStr + ", sorry\n";
		msg += "Without the XML file, CamiTK Wizard won't be able to create corresponding .h and .cpp files.\n";
		msg += "\n Press Retry to modify the " + typeStr + " window and then Ok to retry createing an XML file.\n";
		msg += "\n Press Cancel to go back to the previous window\n";


		switch(QMessageBox::warning(this, title, msg, QMessageBox::Retry, QMessageBox::Cancel)) {
			case QMessageBox::Retry:
				break;
			case QMessageBox::Cancel:
			default:
				this->cancelClicked();
				return;
				break;
		}
	}
}

bool ExtTypeWindow::makeActionXML() {
	
    // Check validity of fields

    // Requiered fileds
	QString qName(ui.extTypeNameLineEdit->text());
	QString qDescription(ui.extTypeDescriptionPlainTextEdit->toPlainText());
	QString qComponentClass(ui.componentClassComboBox->currentText());
    if (qComponentClass == QString("Other..."))
        qComponentClass = ui.componentClassLineEdit->text();
	QString qActionClassName(ui.extTypeClassNameLineEdit->text());
	QString qExtensionName(ui.extensionClassLineEdit->text());
	QString qFamily(ui.familyLineEdit->text());
    QStringList qTags;
	foreach (RemovableLineEdit * e, tags)
        qTags.push_back(e->ui.lineEdit->text());
    
    // Name  
    coreschema::Action::name_type aName(qName.toStdString());
    // Description
    coreschema::Action::description_type aDesc(qDescription.toStdString());
    // Class names (action class, component class, extension class)
    coreschema::ClassNames aClasses(qComponentClass.toStdString(), qExtensionName.toStdString());
    aClasses.actionClass(qActionClassName.toStdString());
    coreschema::Action::classification_type aClassification(qFamily.toStdString());
    foreach (QString t, qTags) 
        aClassification.tag().push_back(t.toStdString());
	if (ui.itkFilterCheckBox->isChecked()) {
		QString outputItkType = ui.itkOutputTypeComboBox->currentText();
		coreschema::ItkFilter itkFilter;
		itkFilter.outputType(outputItkType.toStdString());
		aClassification.itkFilter(itkFilter);
	}
   
    // Action definition
    coreschema::Action myAction(aName, aDesc, aClasses, aClassification);

    // Optional fields
    // Parameters
    if (! this->parameters.empty()) {
        coreschema::Parameters params;
        foreach (ParameterWidget * p, this->parameters) {
            QString pName = p->ui.parameterNameLineEdit->text();
            QString pType = p->ui.parameterTypeComboBox->currentText();
            QString pDefault = p->ui.parameterDefaultValueLineEdit->text();

            coreschema::Parameter aParam(pName.toStdString(), pType.toStdString());
            if (! pDefault.isEmpty())
                aParam.defaultValue(pDefault.toStdString());

            params.parameter().push_back(aParam);
        }
        myAction.parameters(params);
    }
    // Serialization of ext to a std::string
    xml_schema::namespace_infomap map;
    map[""].schema = "../../schemas/Action.xsd";
    std::ostringstream oss;
    coreschema::action(oss, myAction, map);
    std::string xml (oss.str ());
  
    // Writing in the right xml file
	QDir xmlDir(this->workingDirectory);
	if (! xmlDir.exists("xml"))
		xmlDir.mkdir("xml");
	xmlDir.cd("xml");

    QFileInfo xmlFileInfo;
	xmlFileInfo.setFile(xmlDir.absolutePath(), qActionClassName + ".xml");
    QFile xmlFile(xmlFileInfo.absoluteFilePath());
    if (! xmlFile.open(QIODevice::WriteOnly | QIODevice::Text)) {
        QString msg = "Exception from action xml file generation \n    Cannot write on file " + xmlFileInfo.absoluteFilePath() + "\n";
        throw msg;
    }
    QTextStream qout(&xmlFile);
    qout << xml.c_str();
    xmlFile.close();

	if (ui.itkFilterCheckBox->isChecked())
		dad->addItkDependency();

	return true;
}

bool ExtTypeWindow::makeApplicationXML() {
	return true;
}

bool ExtTypeWindow::makeComponentXML() {
    // Check validity of fields

    // Requiered fileds
	QString qName(ui.extTypeNameLineEdit->text());
	QString qDescription(ui.extTypeDescriptionPlainTextEdit->toPlainText());
	QString qComponentClassName(ui.extTypeClassNameLineEdit->text());
	QString qExtensionName(ui.extensionClassLineEdit->text());
	QString qRep(ui.representationComboBox->currentText());
    
    // Name  
	coreschema::Component::name_type aName(qName.toStdString());
    // Description
	coreschema::Component::description_type aDesc(qDescription.toStdString());
    // Class names (component class, extension class)
    coreschema::ClassNames aClasses(qComponentClassName.toStdString(), qExtensionName.toStdString());
	// Representation
	coreschema::Representation aRep(qRep.toStdString());

    // Component definition
	coreschema::Component myComponent(aName, aDesc, aClasses, aRep);

    // Optional fields
    // Properties
    if (! this->parameters.empty()) {
		coreschema::Parameters params;
        foreach (ParameterWidget * p, this->parameters) {
            QString pName = p->ui.parameterNameLineEdit->text();
            QString pType = p->ui.parameterTypeComboBox->currentText();
            QString pDefault = p->ui.parameterDefaultValueLineEdit->text();
//            bool edit = p->ui.parameterEditablecheckBox->isChecked();

            coreschema::Parameter aParam(pName.toStdString(), pType.toStdString());
            if (! pDefault.isEmpty())
                aParam.defaultValue(pDefault.toStdString());
//            aParam.editable(edit);

            params.parameter().push_back(aParam);
        }
		myComponent.properties(params);
    }

    // Serialization of ext to a std::string
    xml_schema::namespace_infomap map;
    map[""].schema = "../../schemas/Component.xsd";
    std::ostringstream oss;
	coreschema::component(oss, myComponent, map);
    std::string xml (oss.str ());
  
    // Writing in the right xml file
	QDir xmlDir(this->workingDirectory);
	if (! xmlDir.exists("xml"))
		xmlDir.mkdir("xml");
	xmlDir.cd("xml");

    QFileInfo xmlFileInfo;
	xmlFileInfo.setFile(xmlDir.absolutePath(), qComponentClassName + ".xml");
    QFile xmlFile(xmlFileInfo.absoluteFilePath());
    if (! xmlFile.open(QIODevice::WriteOnly | QIODevice::Text)) {
        QString msg = "Exception from action xml file generation \n    Cannot write on file " + xmlFileInfo.absoluteFilePath() + "\n";
        throw msg;
    }
    QTextStream qout(&xmlFile);
    qout << xml.c_str();
    xmlFile.close();

	return true;
}

bool ExtTypeWindow::makeViewerXML() {
	return false;
}
