(*********************************************************************************)
(*                Cameleon                                                         *)
(*                                                                               *)
(*    Copyright (C) 2005 Institut National de Recherche en Informatique et       *)
(*    en Automatique. All rights reserved.                                       *)
(*                                                                               *)
(*    This program is free software; you can redistribute it and/or modify       *)
(*    it under the terms of the GNU General Public License as published          *)
(*    by the Free Software Foundation; either version 2.1 of the License, or     *)
(*    any later version.                                                         *)
(*                                                                               *)
(*    This program is distributed in the hope that it will be useful,            *)
(*    but WITHOUT ANY WARRANTY; without even the implied warranty of             *)
(*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *)
(*    GNU Lesser General Public License for more details.                        *)
(*                                                                               *)
(*    You should have received a copy of the GNU General Public License          *)
(*    along with this program; if not, write to the Free Software                *)
(*    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA                   *)
(*    02111-1307  USA                                                            *)
(*                                                                               *)
(*    Contact: Maxence.Guesdon@inria.fr                                          *)
(*                                                                               *)
(*********************************************************************************)

open Dbf_sql.SQL_db
open Dbf_sql

let indexes_of_table = fun t ->
  List.filter (fun i -> (table_of_index i) == t)

let indexes_of_vtable = fun t ->
  List.filter
    (fun i ->
       ((table_of_index i) == t.vt_ftable ||
        (List.exists (fun (t, _) -> (table_of_index i) == t) t.vt_join)))

let _ =
  let in_file  = Sys.argv.(1) in
  let db = Dbf_sql_io.db_of_file in_file in
    List.iter
      (fun table ->
         let idxes = indexes_of_table table db.db_indexes in
           Dbf_sql_gen.print (table, idxes) stdout)
      db.db_tables;
    List.iter
      (fun vtable ->
         let idxes = indexes_of_vtable vtable db.db_indexes in
           Dbf_sql_vgen.print (vtable, idxes) stdout)
      db.db_vtables
