(* $Id: cam_rc.mli,v 1.2 2005/04/14 09:35:20 zoggy Exp $ *)

(** Handling configuration files *)

(** The directory where personal config files are stored. *)
val rc_dir : string

(** {2 The core configuration} *)

val core_ini : Config_file.group
val save_core : unit -> unit
val load_core : unit -> unit

(** {2 the GUI configuration file} *)

val gui_ini : Config_file.group
val save_gui : unit -> unit
val load_gui : unit -> unit

(** {2 Keeping windows positions and sizes} *)

(** [handle_window win name] *)
val handle_window : GWindow.window -> string -> unit

(** {2 Utils} *)

val add_binding :
  < get : ((Gdk.Tags.modifier list * int) * 'a) list;
    set : ((Gdk.Tags.modifier list * int) * 'a) list -> 'b; .. > ->
  string -> 'a -> 'b
