(* $Id: cam_log.ml,v 1.1 2005/05/19 14:50:07 zoggy Exp $ *)

class box () =
  let wscroll = GBin.scrolled_window
      ~hpolicy: `AUTOMATIC
      ~vpolicy: `AUTOMATIC () in
  let tag_table = GText.tag_table () in
  let buffer = GText.buffer ~tag_table () in
  let view = GText.view
      ~cursor_visible: false
      ~wrap_mode: `CHAR
      ~buffer ~editable: false ~packing: wscroll#add () in
  let new_tag props =
    let t = GText.tag () in
    t#set_properties props;
    tag_table#add t#as_tag;
    t
  in
  let fixed_font = new_tag [`FONT "fixed"] in

  object(self)
    method box = wscroll#coerce
    method print color =
      let c = new_tag [`FOREGROUND color] in
      fun s ->
	let s = s^"\n" in
	buffer#insert
	  ~iter: buffer#end_iter
          ~tags: [fixed_font ; c]
          (Glib.Convert.locale_to_utf8 s);
	let l = buffer#char_count in
	if l > Cam_constant.log_max_size then
	  (
	   buffer#delete
	     ~start: buffer#start_iter
	     ~stop: (buffer#get_iter_at_char (max (Cam_constant.log_max_size / 2) (String.length s)));
	   buffer#insert ~iter: buffer#start_iter "...\n"
	  )


  end

let log_window () =
  let window = GWindow.window ~kind: `TOPLEVEL
      ~width: 500 ~height: 600 ()
      ~title: "Cameleon log"
  in
  ignore (window#event#connect#delete (fun _ -> window#misc#hide (); true));
  let vbox = GPack.vbox ~packing: window#add () in
  let v = new box () in
  ignore(vbox#pack ~expand: true v#box);
  let wb_close = GButton.button
      ~label: Cam_messages.close
      ~packing: (vbox#pack ~expand: false)
      ()
  in
  ignore (wb_close#connect#clicked window#misc#hide);
  Cam_hooks.set_display_message (v#print "Black");
  Cam_hooks.set_warning_message (v#print "Orange");
  Cam_hooks.set_error_message (v#print "Red");
  window
