(* $Id: cam_doc_gui.mli,v 1.3 2005/06/09 09:52:11 zoggy Exp $ *)

(** Gui for documentation browser. *)

open Odoc_info

val modules_window :
    (GWindow.window * string GList.clist * GEdit.combo * Odoc_info.Name.t list)
    option ref

val create_or_update_list_window :
    Odoc_info.Module.t_module list ref -> unit
val search_elements_by_exact_names :
    Odoc_info.Module.t_module list ref -> string -> unit
val search_exact : Odoc_info.Module.t_module list ref ->unit
val search_regexp : Odoc_info.Module.t_module list ref ->unit
val update_module_box_if_displayed : Odoc_info.Module.t_module list ref ->unit
val open_element : Odoc_info.Module.t_module list ref -> Cam_doc.element -> unit
val show_odoc_info_and_code :
    title: string -> info: Odoc_info.info -> code: string -> unit
