%{
open Tdl_filter
%}
%token GROUP ITEM EMPTY STATE DESC BEFORE
%token EOF
%token <string> String
%token <Tdl_date.t> Date
%token <Tdl_types.state> State
%type <Tdl_filter.filter> filter
%token LPAR RPAR
%token OR AND
%token NOT
%left OR
%left AND
%nonassoc NOT
%start filter
%%
filter:
| GROUP String {
  Tdl_filter.Group $2
  }
| ITEM String {
  Tdl_filter.Item $2
  }
| EMPTY {
  Tdl_filter.Empty
  }
| STATE State {
  Tdl_filter.State $2
  }
| DESC String {
  Tdl_filter.Desc $2
  }
| BEFORE Date {
  Tdl_filter.Before $2
  }
| NOT filter {
  Tdl_filter.Not $2
  }
| filter AND filter {
  Tdl_filter.And ($1, $3)
  }
| LPAR filter RPAR {
  $2
  }
| filter OR filter {
  Tdl_filter.Or ($1, $3)
  }
;

%%