// Dear Emacs, please note this is a -*-text-*- file. Thank you.
//
// Caudium - An extensible World Wide Web server
// Copyright  2000-2004 The Caudium Group
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of the
// License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// $Id: language.es,v 1.30.2.2 2004/02/24 23:52:45 vida Exp $
//

//
// The language template file format
// ---------------------------------
//
// Message definitions are formatted as follows:
//
// #define<TAB>NAME[<TAB>ID]<TAB>MESSAGE
//
// There MUST be only ONE tab character between the definition fields.
// Never enclose the message in double quotes! Below are few escape sequences
// you can use in the message text:
//
// \s - space (needed at the start and the end of message since the parser strips
//             both leading and trailing whitespace)
// \t - TAB (as above)
// \# - # sign (only needed at the start of message if you need it to start with #).
//      # used at the start of message makes this message a function invocation, and
//      not a string. It means that it won't be enclosed in the quotation marks in the
//      output.
//
// Comments starting with //! are "attached" to the message definition that follows them
// and output in the target file as an attachment of that same kind.
//
// The target file contains also another kind of entry market with the //#DIRECTIVE 
// comment. The following directives are defined:
//
//  ORIG - the line contains the original version of the string for change testing when
//         the translation and the template are combined.
//  FLAG - followed by several flags marks the state of this entry:
//           <changed>  - the entry has been changed in the original (default) file
//                        and the translation needs to be updated.
//           <new>      - new entry merged from the default file
//
//  Neither the attachment comment nor the directive comment should be edited by hand!!
//


// For the translation system internal usage. Not used by CAMAS.

//! Maintainer of this particular file
//#ORIG Xavier Beaudouin <kiwi@isdnet.net>
#define	TS_MAINTAINER	11111	Etienne Roulland <Etienne.Roulland@cvf.fr>

//! This file version
//#ORIG 1.0.0-dev
#define	TS_VERSION	11112	1.1.1-DEV

//! Output in camas_XX.pike as default message (translate it to your language)
//#ORIG \s** MISSING MESSAGE **\s
#define	TS_NOMSGFOUND	11113	\s** MENSAJE AUSENTE **\s

//! Native language name
//#ORIG English
#define	TS_LANGNAME	11114	Espaol

//! Language charset
//#ORIG iso-8859-1
#define	TS_CHARSET	11115	iso-8859-1

//! Character encodable in the above charset
//#ORIG ?
#define	TS_ENCCHAR	11116	?

//! CVS version of the file (leave set to $Id: language.es,v 1.30.2.2 2004/02/24 23:52:45 vida Exp $ if you don't use CVS)
//#ORIG $Id: language.es,v 1.30.2.2 2004/02/24 23:52:45 vida Exp $
#define	TS_CVSVER	11117	$Id: language.es,v 1.30.2.2 2004/02/24 23:52:45 vida Exp $

//! The copyright string put in the target .pike file
//#ORIG 2000 The Caudium Group
#define	TS_COPYRIGHT	11118	2000 The Caudium Group


// CAMAS Messages

//#ORIG Back
#define	M_MAILMISSINGBACK	Atrs

//#ORIG Nickname
#define	M_NICKNAME	Apodo

//#ORIG Add to filter book
#define	M_ADDADDRESSFILTER	Aadir a la lista de filtros

//#ORIG Show text messages
#define	M_PSHOWTEXT	Mostrar los mensajes de texto

//#ORIG Work country
#define	M_WORKCOUNTRY	Pas de trabajo

//#ORIG \#sprintf ("<b>Could not log in:</b> %s", @arg)
#define	M_NOLOGIN	\#sprintf ("<b>No se pudo conectar :</b> %s", @arg)

//#ORIG Mark all
#define	M_MARKALL	Marcar todos

//#ORIG Mail notification
#define	M_MAILNOTIFYWINDOW	Aviso de nuevo mensaje

//#ORIG Manual correction
#define	M_MANUALCORRECTION	Correccin del manual

//#ORIG Previous
#define	M_SPELLPREV	Anterior

//#ORIG Showing mail with\s
#define	M_SEARCHSHOWINGMAIL	Mostrar mensajes con\s

//#ORIG Delete address
#define	M_DELETEADDRESS	Borrar direccin

//#ORIG Upload and import
#define	M_UPLOADANDIMPORT	Cargar e importar

//#ORIG Messages
#define	M_MESSAGES	Mensajes

//#ORIG Language
#define	M_PLANGUAGE	Idioma

//#ORIG Continue and move
#define	M_CONTINUECOMPOSEMOVE	Continuar y mover

//#ORIG Send
#define	M_SEND	Enviar

//#ORIG Prev
#define	M_EBACKN	Anterior

//#ORIG Mail is too big to be shown. Click here to download it.
#define	M_MAILTOOBIG	Es imposible leer el mensaje por su tamao excesivo. Haga click aqu para bajarlo.

//#ORIG in all headers
#define	M_SEARCHHEADERS	en todas las cabezeras

//#ORIG Address
#define	M_ADDRESS	Direccin

//#ORIG You must select a mailbox to rename and supply a new name.
#define	M_NOMBOXERROR	Tienes que seleccionar la carpeta que debe cambiar de nombre, y darle un nuevo nombre.

//#ORIG Monday
#define	M_MONDAY	Lunes

//#ORIG Signature
#define	M_PSIGNATURE	Firma

//#ORIG Recipients don't see each other
#define	M_SENDBLIND	Los recipientes no se ven entre ellos

//#ORIG Trash
#define	M_SHARED_BOXTRASH	Papelera

//#ORIG Received
#define	M_RECEIVED	Recibido

//#ORIG Inbox
#define	M_INBOX	Bandeja de entrada

//#ORIG Organization
#define	M_PORGANIZATION	Organizacin

//#ORIG Name
#define	M_PNAME	Nombre

//#ORIG Thread
#define	M_THREADSHOW	Thread

//#ORIG Email address
#define	M_EMAILADDRESS	Email

//#ORIG Spell check
#define	M_SPELLCHECK	Ortografa

//#ORIG \#sprintf("Are you sure you want to delete the %d marked message(s)?", @arg)
#define	M_DELETEMARKEDP	\#sprintf("Est Ud. seguro de que desea eliminar los %d mensajes marcados ?", @arg)

//#ORIG Common addresses:
#define	M_GLOBALADDRESSES	Direcciones :

//#ORIG \#sprintf ("%s requested a receipt to be returned. Do you wish to send one ?", @arg)
#define	M_NOTIFYTO	\#sprintf ("%s pidi un acusado de recepcin. Desea enviar uno ?", @arg)

//#ORIG Sticky Filter
#define	M_STICKYFILTER	Filtro \"Sticky\"

//#ORIG Save and use
#define	M_SAVEADDRESS	Grabar y utilizar

//#ORIG Send marked drafts
#define	M_SENDMARKEDDRAFTS	Enviar los borradores seleccionados

//#ORIG used
#define	M_USED	utilizado

//#ORIG Save and use
#define	M_SAVEADDRESSFILTER	Grabar y utilizar

//#ORIG Trash folder
#define	M_PTRASHFOLDER	Papelera

//#ORIG Answered
#define	M_SHARED_BOXANSWERED	Respondido

//#ORIG Select a mailbox
#define	M_SELECTMBOX	Seleccione una carpeta

//#ORIG Forward
#define	M_FORWARD	Reenviar

//#ORIG Hide full headers
#define	M_HIDEFULLHEADERS	Esconder las cabezeras

//#ORIG Show all
#define	M_SHOWALLAFTERSEARCH	Mostrar todo

//#ORIG \#sprintf("This is a Return Receipt for the mail that you sent to %s.Note: this Return Receipt only acknowledges that the message was displayed on the recipient's machine. There is no guarantee that the content has been read or understood.", @arg)
#define	M_MDNMESSAGE	\#sprintf("Esto es un acusado de recepcion del mensaje que Ud. ha enviado a %s.Nota: este acusado solo asegura que el mensaje apareci en la pantalla. No es una prueba de que el contenido haya sido leido o entendido.", @arg)

//#ORIG Search mail
#define	M_SEARCHMAILTITLE	Bsqueda de mensajes

//#ORIG Inactive logout (minutes)
#define	M_PINACTIVELOGOUT	Desconexin por inactividad (minutos)

//#ORIG Include mail when replying
#define	M_PINCLUDEMAIL	Incluir el mensaje en las respuestas

//#ORIG Subject
#define	M_SUBJECT	Asunto

//#ORIG Upload
#define	M_UPLOAD	Cargar

//#ORIG To:
#define	M_FWD_TO	A :

//#ORIG Back to compose
#define	M_BACKTOCOMPOSE	Volver a la composicin de mensajes

//#ORIG Check inboxes
#define	M_CHECKACTIVEMAILBOXES	Comprobar carpetas

//#ORIG Recipients don't see each other button
#define	M_PSENDBLIND	Los recipientes no ven cada uno de los botones

//#ORIG Change to
#define	M_SPELLCHANGETO	Cambiar a

//#ORIG Folder
#define	M_ADDRESSFILTER	Carperta

//#ORIG Delete all addressbook
#define	M_DELETEALLADDRESS	Borrar todas las listas de contactos

//#ORIG Cannot import this addressbook, since its\nformat is not recognized.
#define	M_CANNOTIMPORT	No se puede importar esta lista de contactos, ya que\nsu formato es desconocido.

//#ORIG ------ Forwarded message ------
#define	M_FWD_SEP	------ Forwarded message ------

//#ORIG \#sprintf("%sattachment of type %s",@arg)
#define	M_ATTACHMENTLINK	\#sprintf("%sadjuntos del tipo %s",@arg)

//#ORIG Extra headers
#define	M_PHEADER	Otras cabezeras

//#ORIG Next
#define	M_EFORWARDN	Suguiente

//#ORIG Search in all mailboxes
#define	M_SEARCHALLMBOX	Buscar en todos los archivos

//#ORIG Total size
#define	M_TOTALSIZE	Tamao total

//#ORIG Import address book
#define	M_IMPORTADDRESSBOOK	Importar el libro de contactos

//#ORIG Company
#define	M_COMPANY	Compaa

//#ORIG Mailboxes
#define	M_MAILBOXES	Carpetas

//#ORIG Reply and move
#define	M_REPLYMOVE	Responder y mover

//#ORIG Delete marked
#define	M_DELETEMARKED	Borrar marcados

//#ORIG Index name (click to add as recipient)
#define	M_INDEXNAMERECIPIENT	Nombre de ndice (haz click para aadir como destinatario)

//#ORIG N
#define	M_NEWFLAG	N

//#ORIG Work postal address
#define	M_WORKPOSTALADDRESS	Cdigo postal del trabajo

//#ORIG Mail address
#define	M_PMAILADDRESS	Direccin electrnica

//#ORIG Search and replace
#define	M_SEARCHREPLACE	Buscar y remplazar

//#ORIG Postal code
#define	M_POSTALCODE	Cdigo postal

//#ORIG Failed to rename mailbox. The name may be illegal or the mailbox may exist.
#define	M_RENAMEMBOXERROR	Fallo en el cambio de nombre de carpeta. El nombre puede ser ilegal o la carpeta ya existente.

//#ORIG Default screen after successful login
#define	M_PPOSTLOGINSCREEN	Pantalla por omisin despus de una conexin vlida

//#ORIG Cc
#define	M_CC	Cc

//#ORIG Reply selected mails
#define	M_REPLYMARKED	Responder a los correos seleccionados

//#ORIG Size
#define	M_SIZE	Tamao

//#ORIG Default filterbook (not extended)
#define	M_PADDRESSBOOKFILTER	Lista de filtros por omision (no extendida)

//#ORIG Reply-To:
#define	M_FWD_REPLYTO	Reply-To:

//#ORIG No attachments
#define	M_NOATTACHMENTS	Sin adjunto

//#ORIG Default addressbook (not extended)
#define	M_PADDRESSBOOK	Lista de contactos (no extendida)

//#ORIG Password:
#define	M_PASSWORD	Clave :

//#ORIG Empty the trash folder
#define	M_DELETEALLTRASH	Vaciar la papelera

//#ORIG Mail was sent successfully, but save in folder failed.
#define	M_SENDSAVEFAILED	El mensaje ha sido enviado, pero no ha podido ser guardado en la carpeta.

//#ORIG Address(es), comma separated
#define	M_ADDRESSFORMAT	Direccin(es), separadas por comas

//#ORIG Index field (click to select a field)
#define	M_INDEXNAMEFIELDFILTER	Indice (Haz click para seleccionar un tema)

//#ORIG Saturday
#define	M_SATURDAY	Sbado

//#ORIG Current Mailbox
#define	M_CURRMAILBOX	Bandeja de entrada

//#ORIG Default Bcc address
#define	M_PDEFAULTBCC	Direccin Bcc por omisin

//#ORIG Mail
#define	M_MAIL	Mensaje

//#ORIG \#sprintf("[<< Prev %d]", @arg)
#define	M_BACKN	\#sprintf("[<< Anteriores %d]", @arg)

//#ORIG in the 'to' field
#define	M_SEARCHTOFIELD	en la direccin de entrega

//#ORIG Home postal address
#define	M_HOMEPOSTALADDRESS	Cdigo postal particular

//#ORIG Rename a mailbox
#define	M_RENAMEMBOX	Cambiar el nombre de una carpeta

//#ORIG Imported fields
#define	M_IMPORTEDFIELDS	Temas importados

//#ORIG Compose
#define	M_NEWMAIL	Nuevo correo

//#ORIG Read previous
#define	M_READPREV	Leer el anterior

//#ORIG Report delivery
#define	M_MDN	Acusado de entrega

//#ORIG LDAP search
#define	M_LDAP	Bsqueda en LDAP

//#ORIG Edit filter
#define	M_EDITADDRESSFILTER	Editar el filtro

//#ORIG Type in a name first.
#define	M_NEWMBOXNONAME	Teclee un nombre primero.

//#ORIG End this CAMAS session ?
#define	M_ENDSESSION	 Terminar esta sesin ?

//#ORIG Work state
#define	M_WORKSTATE	Estado de trabajo

//#ORIG Windows users: Due to a bug in some browsers, filenames can be crippled. Avoid this by replacing the last \\ with \\\\ before pressing 'Upload'.
#define	M_WINDOWSBUG	Atencin usuarios de Windows : debido a un error en algunos visualizadores WEB, los nombres de fichero pueden aparecer recortados. Para evitarlo, puede sustituir el ltimo '\\' por '\\\\' antes de pulsar 'Cargar (upload)'.

//#ORIG Reload this page to login.
#define	M_LOGOUTRELOAD	Recargue esta pgina para volver a acceder a su correo.

//#ORIG URI
#define	M_URI	URI

//#ORIG Search in history
#define	M_HISTSEARCH	Buscar en el histrico

//#ORIG Continue
#define	M_CONTINUECOMPOSE	Continuar

//#ORIG Time
#define	M_TIME	Hora

//#ORIG No spelling errors found.
#define	M_NOSPELLINGERRORS	Ningn error de ortografa encontrado.

//#ORIG Quota
#define	M_QUOTA	Cuota

//#ORIG Date:
#define	M_FWD_DATE	Fecha :

//#ORIG Sort on column
#define	M_PSORTCOLUMN	Ordenar por columna

//#ORIG OK
#define	M_LOGIN_OK	OK

//#ORIG AND
#define	M_SEARCHAND	Y

//#ORIG Add to address book
#define	M_ADDADDRESS	Aadir a la lista de contactos

//#ORIG Thursday
#define	M_THURSDAY	Jueves

//#ORIG Preferences
#define	M_PREFS	Preferencias

//#ORIG \#([ "forward": "forward", "backward":"backward"])[arg[0]]
#define	M_PSORTORDERS	\#([ "forward": "adelante", "backward":"atrs"])[arg[0]]

//#ORIG Get new mail
#define	M_GETNEWMAIL	Recibir nuevos mensajes

//#ORIG Select matching fields
#define	M_SELECTMATCHINGFIELDS	Seleccionar los temas que corresponden

//#ORIG Sent
#define	M_BOXSENTMAIL	Elementos enviados

//#ORIG From preferences
#define	M_SAVEDUSERINTERFACE	De las preferencias

//#ORIG Address book
#define	M_ADDRESSBOOK	Lista de contactos

//#ORIG Cancel
#define	M_DIALOGCANCEL	Cancelar

//#ORIG Info
#define	M_INFO	Informacin

//#ORIG Save a copy
#define	M_SAVEMAILCOPY	Guardar una copia

//#ORIG OU
#define	M_OU	OU

//#ORIG (Name)
#define	M_NEWMBOXNAME	(Nombre)

//#ORIG Edit the filter
#define	M_EDITFILTER	Editar el filtro

//#ORIG Home phone
#define	M_HOMEPHONE	Telfono particular

//#ORIG Pager
#define	M_PAGER	Paginador

//#ORIG Port
#define	M_PORT	Puerto

//#ORIG Delay
#define	M_DELAY	Retardar

//#ORIG Destination to import to
#define	M_DESTINATIONIMPORT	Destino a importar a

//#ORIG Move to trash
#define	M_MOVETHISTOTRASH	Poner en la papelera

//#ORIG Send market drafts and move
#define	M_SENDMARKEDDRAFTSMOVE	Enviar los borradores marcados y mover

//#ORIG Filters
#define	M_FILTERBOOK	Filtros de correo

//#ORIG Please mark some messages first.
#define	M_DELETEMARKEDNONE	Por favor, marque algunos mensajes primero.

//#ORIG Cancel
#define	M_CANCELADDRESS	Cancelar

//#ORIG Unseen
#define	M_UNSEEN	Sin ver

//#ORIG [Previous level]
#define	M_PREVIOUS_LEVEL	[Nivel anterior]

//#ORIG Compose mail
#define	M_COMPOSEMAIL	Componer el mensaje

//#ORIG \#sprintf("[Next %d >>]", @arg)
#define	M_FORWARDN	\#sprintf("[Siguientes %d >>]", @arg)

//#ORIG Delete marked
#define	M_DELETEMARKEDMBOX	Borrar marcados

//#ORIG Reply to all
#define	M_REPLYTOALL	Responder a todos

//#ORIG Index field
#define	M_INDEXFIELDFILTER	Indice

//#ORIG New address
#define	M_NEWADDRESS	Nueva direccin

//#ORIG Index field
#define	M_INDEXNAMEEDITFIELDFILTER	Indice

//#ORIG Tuesday
#define	M_TUESDAY	Martes

//#ORIG Save and use
#define	M_PSAVEANDUSE	Grabar y utilizar

//#ORIG Search name containing:
#define	M_NAMECONT	Buscar un nombre que contenga :

//#ORIG <strong>Error:</strong> Failed to fetch mail. The mail might have a faulty format.<br />
#define	M_MAILMISSING	<strong>Error:</strong>Fallo al acceder a su correo. Intntelo de nuevo.<br />

//#ORIG Attachment list too big
#define	M_ATTACHTOOBIG	Lista de adjuntos demasiado grande

//#ORIG Mail Filter
#define	M_FILTERBOOKTITLE	Reglas de correo

//#ORIG M
#define	M_MARKFLAG	M

//#ORIG Path
#define	M_FOLDER_PATH	Camino

//#ORIG Answered mail folder
#define	M_PANSWEREDFOLDER	Archivo de correo de respuestas

//#ORIG anywhere
#define	M_SEARCHANYWHERE	en todas las carpetas

//#ORIG Yes
#define	M_YES	S

//#ORIG Show full headers
#define	M_SHOWFULLHEADERS	Mostrar todas las cabezeras

//#ORIG Logged out
#define	M_LOGGEDOUT	Desconectado

//#ORIG Report delayed delivery.
#define	M_DSN_DELAY	Recibir acusado de entrega retrasada.

//#ORIG Surname
#define	M_SURNAME	Apellido

//#ORIG Include attachments
#define	M_PSAVEATTACHMENTS	Guardar adjuntos

//#ORIG No answers matching you query
#define	M_NOSEARCHRESULTS	Ninguna respuesta que corresponde a tu pregunta

//#ORIG Index filter
#define	M_INDEXNAMEFILTER	Filtro del ndice

//#ORIG Work city
#define	M_WORKCITY	Cuidad de trabajo

//#ORIG With this option a rule is automatically build when you move a mail to a specified mailbox. When the same sender come back,  his mail is moved to th mailbox you already specified
#define	M_PAUTOFILTER	Con esta opcin, una regla es automaticamente  hecha cuando mueves un mensaje a una carpeta especfica. Cuando el mismo remitente vuelve, su mensaje va directamente a la carpeta correspondiente

//#ORIG Do not save this mail
#define	M_DONTSAVEMAIL	No guardar este mensaje

//#ORIG [No mail]
#define	M_NOMAILS	[No hay mensajes]

//#ORIG Address Book
#define	M_ADDRESSBOOKTITLE	Lista de contactos

//#ORIG Done
#define	M_SPELLDONE	Hecho

//#ORIG Index name
#define	M_INDEXNAME	Nombre de ndice

//#ORIG Folder
#define	M_FOLDER	Archivo

//#ORIG Sent mail folder
#define	M_PSENTFOLDER	Carpeta de mensajes enviados

//#ORIG Reply and move selected mails
#define	M_REPLYMOVEMARKED	Responder y mover los mensajes seleccionados

//#ORIG \#sprintf("Mail %d-%d of %d", @arg)
#define	M_MAILSHOWN	\#sprintf("Mensaje %d-%d de %d", @arg)

//#ORIG Attachments
#define	M_ATTACHMENTSHEADER	Adjuntos

//#ORIG No addresses
#define	M_NOADDRESSES	No hay direcciones

//#ORIG Today
#define	M_TODAY	Hoy

//#ORIG Prefix
#define	M_PQUOTEPREFIX	Prefijo

//#ORIG Add marked to attachments
#define	M_ADDMARKEDTOATTACHMENTS	Aadir los marcados a los adjuntos

//#ORIG Date
#define	M_DATE	Fecha

//#ORIG Mark at least one mailbox.
#define	M_MBOXMARKONE	Marque al menos una carpeta.

//#ORIG Add recipients
#define	M_ADDRECIPIENTS	Aadir recipientes

//#ORIG \#sprintf("You have %d Kb available for upload.",@arg)
#define	M_AVAILSPACE	\#sprintf("Ud. tiene %d Kbytes disponibles para cargar.",@arg)

//#ORIG There was a problem talking to the mail (IMAP) server.<br>Please contact the administrator.
#define	M_IMAPERROR	Ha habido un problema en la comunicatin con el servidor IMAP.<br>Por favor, contacte con el administrador.

//#ORIG -------------
#define	M_FWD_REP_SEP	-------------

//#ORIG No files
#define	M_NOATTACHFILES	No hay ficheros

//#ORIG Close this browser window to make sure no one can read your mail.
#define	M_LOGOUTCLOSE	Cierre esta ventana para asegurarse de que nadie podr leer sus mensajes.

//#ORIG Wrong login or password. Try again.
#define	M_LOGINERROR	Nombre de usuario o clave incorrecta. Intntalo de nuevo.

//#ORIG Select
#define	M_SELECT	Seleccionar

//#ORIG (Lines with headers in this format: header:value)
#define	M_PHEADERDESC	(Lineas con cabezeras en este formato : cabezera: valor)

//#ORIG Select files to send. Press 'Ctrl' to toggle-select multiple files.
#define	M_SENDMOREFILES	Seleccione los archivos a enviar. Pulse 'Ctrl' para (de)seleccionar varios archivos.

//#ORIG Messages shown in a mailbox
#define	M_PVISIBLEMESSAGES	Mensajes mostrados en carpeta

//#ORIG #
#define	M_NUMBER	#

//#ORIG No filter
#define	M_NOADDRESSESFILTER	Ningn filtro

//#ORIG of
#define	M_OF	de

//#ORIG Index name (click to add as recipient)
#define	M_INDEXNAMERECIPIENTFILTER	Nombre de ndice (haz click para aadirlo como recipiente)

//#ORIG Move marked to
#define	M_MOVEMARKED	Mover marcados a

//#ORIG Delete
#define	M_DELETE	Borrar

//#ORIG IMAP server
#define	M_IMAPSERVER	Servidor IMAP

//#ORIG OK
#define	M_DIALOGOK	OK

//#ORIG Mail searchpath
#define	M_PMAILPATH	Directorio de Correo

//#ORIG \#sprintf ("The mail \"%s\" was sent to: %s", @arg)
#define	M_SMTPOK	\#sprintf ("El mensaje \"%s\" ha sido enviado a : %s", @arg)

//#ORIG User interface
#define	M_PUSERINTERFACE	Interfaz de usuario

//#ORIG There was a problem talking to the addressbook server (LDAP)
#define	M_ADDRBOOKERRROR	Hubo un problema en el dialogo con el servidor de direcciones (LDAP)

//#ORIG Bcc
#define	M_BCC	Bcc

//#ORIG Create a new mailbox
#define	M_CREATEMBOX	Crear una nueva carpeta de correo

//#ORIG Type
#define	M_MIMETYPE	Tipo

//#ORIG Fwd:
#define	M_FWD_SUBJECT	Fwd:

//#ORIG Add attachment
#define	M_ADDATTACHMENT	Aadir adjunto

//#ORIG Upload to attachments
#define	M_UPLOADTOATTACHMENTS	Cargar a adjuntos

//#ORIG Drafts folder
#define	M_PDRAFTSFOLDER	Borradores

//#ORIG Suggestions
#define	M_SPELLSUGGESTIONS	Sugerencias

//#ORIG Next
#define	M_SPELLNEXT	Siguiente

//#ORIG Department
#define	M_DEPARTMENT	Distrito

//#ORIG Enable <em>\"Show full headers\"</em>-button
#define	M_PSHOWHIDDENHEADERS	Enable <em>\"Mostrar todas las cabezeras\"</em>-button

//#ORIG Sunday
#define	M_SUNDAY	Domingo

//#ORIG Enable or disable the background IMAP client started after your login. If the background IMAP client is enable, some features like fast search or faster mailboxes browsing are avaible. However the interface will be slower for a few minutes after you logged in.
#define	M_PENABLEDISABLECACHEFEEDER	Activa o desactiva el cliente IMAP lanzado despus de tu conexin. Si el cliente IMAP est activado, algunas puntos como la bsqueda rpida o el barrido rpido de los archivos sern an posibles. Sin embargo, el interfaz ser ms lento durante un corto tiempo despus de haberte conectado.

//#ORIG in subject
#define	M_SEARCHSUBJECT	en el asunto

//#ORIG Drafts
#define	M_BOXDRAFTS	Borradores

//#ORIG Sent
#define	M_SHARED_BOXSENTMAIL	Enviar

//#ORIG \#sprintf("Mailbox: %s",@arg)
#define	M_MAILBOX	\#sprintf("Carpeta : %s",@arg)

//#ORIG Failed to create mailbox. The name may be illegal or the mailbox may exist.
#define	M_CREATEMBOXERROR	Fallo en la creacin de carpeta. Motivos: nombre ilegal o carpeta ya existente.

//#ORIG Don't remember the previous search
#define	M_NOSEARCHREMEMBER	No recuerdes la bsqueda anterior

//#ORIG Read next
#define	M_READNEXT	Leer el siguiente

//#ORIG Send blind copy to administrator
#define	M_CHECKBCC	Enviar una copia oculta al administrador

//#ORIG Delete marked
#define	M_DELETEMARKEDFILES	Borrar los marcados

//#ORIG Search LDAP
#define	M_SEARCHLDAP	Buscar en LDAP

//#ORIG Title
#define	M_TITLE	Ttulo

//#ORIG You have no uploaded files
#define	M_NOFILES	Ud. no tiene ficheros cargados

//#ORIG Change sort order
#define	M_CHANGESORTORDER	Cambiar el orden

//#ORIG You must specify a recipient of the mail.
#define	M_SENDNORECV	Ud. tiene que escribir una direccin de correo para la entrega.

//#ORIG Description
#define	M_DESCRIPTION	Descripcin

//#ORIG To
#define	M_TO	A

//#ORIG Archive
#define	M_ARCHIVE	Archivo

//#ORIG Index folder
#define	M_FILTERFOLDER	Carpeta del ndice

//#ORIG Filename
#define	M_FILENAME	Fichero

//#ORIG From:
#define	M_FWD_FROM	De :

//#ORIG \#sprintf("Warning! Unable to decode the characterset \"%s\". Message is presented undecoded.",@arg)
#define	M_CHARSETWARNING	\#sprintf(" Atencin! Imposible de descodificar el cdigo de caracteres \"%s\". El mensaje se presenta sin descodificar",@arg)

//#ORIG User interface:
#define	M_USERINTERFACE	Interfaz de usuario:

//#ORIG Show HTML messages
#define	M_PSHOWHTML	Mostrar los mensajes HTML

//#ORIG You must specify at least the field(s)
#define	M_MUSTSELECTFIELD	Debes seleccionar por lo menos el(los) tema(s)

//#ORIG Upload attachment
#define	M_UPLOADATTACHMENT	Cargar adjunto

//! Label on the login screen
//#ORIG Login:
#define	M_LOGIN	Usuario :

//#ORIG Move marked to trash
#define	M_MOVETOTRASH	Mover los mensajes marcados a la papelera

//#ORIG Friday
#define	M_FRIDAY	Viernes

//#ORIG Logout
#define	M_LOGOUT	Salir

//#ORIG Index filter (click to edit)
#define	M_INDEXNAMEEDITFILTER	Filtro del ndice (haz click para editar)

//#ORIG Cancel
#define	M_CANCELADDRESSFILTER	Cancelar

//#ORIG Forward and move
#define	M_FORWARDMOVE	Reenviar y mover move

//#ORIG Check for new mail
#define	M_CHECKNEWMAIL	Comprobar si hay nuevo correo

//#ORIG Search
#define	M_SEARCHMAIL	Buscar

//#ORIG Answered
#define	M_BOXANSWERED	Respondido

//#ORIG Index name (click to edit)
#define	M_INDEXNAMEEDIT	Nombre de ndice (haz click editar)

//#ORIG Return Receipt (displayed) -\s
#define	M_MDNHEADER	Acusado de recepcin -\s

//#ORIG Add file as an attachment
#define	M_ADDFILEASATTACHMENT	Aadir el fichero como adjunto

//#ORIG Reply on top of the message
#define	M_PREPLYONTOP	Responde encima del mensaje

//#ORIG Available fields
#define	M_AVAILABLEFIELDS	Temas disponibles

//#ORIG Reply
#define	M_REPLY	Responder

//#ORIG Save draft
#define	M_SAVEDRAFT	Guardar borrador

//#ORIG LDAP addresses
#define	M_LDAPTITLE	Gua de direcciones LDAP

//#ORIG in the 'from' field
#define	M_SEARCHFROMFIELD	en el remitente

//#ORIG Are you sure you want to delete the following mailboxes?
#define	M_MBOXREMOVEP	Est Ud. seguro de que desea eliminar las siguientes carpetas ?

//#ORIG Attachments
#define	M_ATTACHMENTS	Adjuntos

//#ORIG \#sprintf("The address \"%s\" is not a correct email address. Please correct it and try again.", arg[0])
#define	M_SENDBROKENADDR	\#sprintf("La direccin de correo \"%s\" no es una direccin de email correcta. Por favor, corrigela y intntalo de nuevo.", arg[0])

//#ORIG Back to mail index
#define	M_BACKTOMAILINDEX	Volver al ndice de correo

//#ORIG Work phone
#define	M_WORKPHONE	Telfono particular

//#ORIG \#sprintf(There was a problem talking to the outgoing mail (SMTP) server, and the mail was not sent to %s. The recipient of the mail might not exist.", @arg)
#define	M_SMTPERROR	\#sprintf("Ha habido un problema en la comunicacin con el servidor SMTP, y el mensaje no ha sido enviado a %s. Puede ser que la direccion de correo de entrega no exista.", @arg)

//#ORIG You have been logged out.
#define	M_LOGOUTMSG	Ud. ha sido desconectado del sistema.

//#ORIG Upload a Pine, an exported Netscape (.ldif) or Outlook (.csv) address book
#define	M_UPLOADADDRESSBOOK	Cargar una lista de contactos en formato Pine,  Netscape (.ldif) o Outlook (.csv)

//#ORIG Mobile
#define	M_MOBILE	Telfono mobil

//#ORIG History
#define	M_HISTFLAG	Histrico

//#ORIG From
#define	M_FROM	De

//#ORIG You must specify non-empty index folder and filter(s).
#define	M_EMPTYADDRESSFILTER	Debes especificar carpetas y filtros no vacos.

//#ORIG The Pine address book is often in ~/.addressbook
#define	M_PINELOCATION	La lista de contactos Pine suele estar en ~/.addressbook

//#ORIG New
#define	M_NEW	Nuevo

//#ORIG Delete filter
#define	M_DELETEADDRESSFILTER	Borrar filtro

//#ORIG Cc:
#define	M_FWD_CC	Cc:

//#ORIG Cancel
#define	M_CANCELSEND	Cancelar

//#ORIG Reply to all and move
#define	M_REPLYTOALLMOVE	Responder a todo y mover

//#ORIG in the mail body
#define	M_SEARCHBODY	dentro del mensaje

//#ORIG Edit address
#define	M_EDITADDRESS	Editar direccin

//#ORIG Wednesday
#define	M_WEDNESDAY	Mircoles

//#ORIG Mail sort order
#define	M_PSORTORDER	Orden de mensajes

//#ORIG Files
#define	M_FILES	Archivos

//#ORIG Drafts
#define	M_SHARED_BOXDRAFTS	Borradores

//#ORIG Problem while writing to address book
#define	M_ADDRESSBOOKWRITEPROBLEM	Problema durante la escritura a la lista de contactos

//#ORIG Import address book
#define	M_IMPORTADDRESSBOOKTITLE	Importar lista de contactos

//#ORIG A
#define	M_ANSWEREDFLAG	R

//#ORIG Trash
#define	M_BOXTRASH	Papelera

//#ORIG New filter
#define	M_NEWADDRESSFILTER	Nuevo filtro

//#ORIG No
#define	M_NO	No

//#ORIG Remove marked attachments
#define	M_REMOVEMARKEDATTACHMENTS	Borrar los adjuntos seleccionados

//#ORIG Question
#define	M_QUESTION	Pregunta

//#ORIG Report successful delivery.
#define	M_DSN_SUCCESS	Recibir acusado de recepcin con xito.

//#ORIG You can't search multiple mailboxes for now, please wait a few moments if you want this feature
#define	M_SEARCHCACHENOTFEEDED	La busqueda de varias carpetas es imposible por el momento, por favor espera un poco si quieres hacerlo

//#ORIG Mailbox (m/r/u/s)
#define	M_MBOXNAME	Carpeta (m/r/u/s)

//#ORIG (Select a field)
#define	M_SELECTFIELD	(Selecciona un tema)

