/*
  Copyright (c) 2006 Gábor Lehel <illissius@gmail.com>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this library; see the file COPYING.LIB.  If not, write to
  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
  Boston, MA 02110-1301, USA.
*/

#ifndef KO_DOCUMENT_SECTION_TOOLTIP_H
#define KO_DOCUMENT_SECTION_TOOLTIP_H

#include "KoItemToolTip.h"

class KisDocumentSectionModel;

/**
 * A default tooltip for a KisDocumentSection that shows a thumbnail
 * image and the list of properties associated with the document model.
 */
class KisDocumentSectionToolTip: public KoItemToolTip
{
    Q_OBJECT

public:
    KisDocumentSectionToolTip();
    virtual ~KisDocumentSectionToolTip();

protected:
    virtual QTextDocument *createDocument(const QModelIndex &index);

private:
    typedef KisDocumentSectionModel Model;
};

#endif
