/*
 * Decompiled with CFR 0.152.
 */
package mso.generator.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ParserGeneratorUtils {
    static Collection<String> getDependencies(Element element) {
        TreeSet<String> treeSet = new TreeSet<String>();
        NodeList nodeList = element.getElementsByTagName("type");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            if (element2.hasAttribute("count") || element2.hasAttribute("array")) continue;
            treeSet.add(element2.getAttribute("type"));
        }
        return treeSet;
    }

    static List<Element> getOrderedStructureList(Document document) throws IOException {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        NodeList nodeList = document.getElementsByTagName("struct");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            arrayList.add((Element)nodeList.item(i));
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<Element> arrayList3 = new ArrayList<Element>();
        while (arrayList.size() > 0) {
            int n = arrayList.size();
            int n2 = 0;
            while (n2 < arrayList.size()) {
                Element element = (Element)arrayList.get(n2);
                Collection<String> object = ParserGeneratorUtils.getDependencies(element);
                object.removeAll(arrayList2);
                if (object.size() == 0) {
                    arrayList3.add(element);
                    arrayList2.add(element.getAttribute("name"));
                    arrayList.remove(element);
                    continue;
                }
                ++n2;
            }
            if (n != arrayList.size()) continue;
            String string = "";
            for (Element element : arrayList) {
                Collection<String> collection = ParserGeneratorUtils.getDependencies(element);
                collection.removeAll(arrayList2);
                string = string + element.getAttribute("name") + ": " + collection + "\n";
            }
            throw new IOException(string + n);
        }
        return arrayList3;
    }

    public static Map<Integer, String> getRecordTypeNames(Document document) throws XPathExpressionException {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        XPath xPath = XPathFactory.newInstance().newXPath();
        String string = "/mso/struct/type[@name='rh']/limitation[@name='recType']";
        NodeList nodeList = (NodeList)xPath.evaluate(string, document, XPathConstants.NODESET);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            String string2 = ((Element)element.getParentNode().getParentNode()).getAttribute("name");
            String string3 = element.getAttribute("value").replace("0x", "");
            for (String string4 : string3.split("\\|")) {
                int n = Integer.parseInt(string4, 16);
                if (hashMap.containsKey(n)) {
                    string2 = (String)hashMap.get(n) + "/" + string2;
                }
                hashMap.put(n, string2);
            }
        }
        return hashMap;
    }
}

