/*
 *  Copyright (c) 2006 Boudewijn Rempt  <boud@valdyas.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include "kis_import_catcher.h"
#include <kis_debug.h>

#include <kimageio.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kglobal.h>
#include <kmimetype.h>
#include <kapplication.h>
#include <kdebug.h>
#include <kio/netaccess.h>
#include <kio/job.h>

#include <KoFilterManager.h>
#include <KoColorSpaceRegistry.h>

#include "kis_node_manager.h"
#include "kis_types.h"
#include "kis_count_visitor.h"
#include "kis_view2.h"
#include "kis_doc2.h"
#include "kis_image.h"
#include "kis_layer.h"
#include "kis_selection.h"
#include "kis_node_commands_adapter.h"
#include "kis_group_layer.h"
#include "kis_part2.h"
#include "kis_statusbar.h"
#include "kis_progress_widget.h"

#include <QMessageBox>

struct KisImportCatcher::Private
{
public:
    KisPart2* part;
    KisDoc2* doc;
    KisView2* view;
    KUrl url;
};

KisImportCatcher::KisImportCatcher(const KUrl & url, KisView2 * view)
        : m_d(new Private)
{
    KisPart2 *part = new KisPart2(0);
    m_d->doc = new KisDoc2(part);
    part->setDocument(m_d->doc);

    KoProgressProxy *progressProxy = view->statusBar()->progress()->progressProxy();
    m_d->doc->setProgressProxy(progressProxy);
    m_d->view = view;
    m_d->url = url;
    KoFilterManager manager(m_d->doc);
    m_d->doc->openUrl(url);

//    if (KMimeType::findByUrl(url)->name() == "application/x-krita") {
//        m_d->doc->loadNativeFormat(url.toLocalFile());
//    }
//    else {
//        KoFilter::ConversionStatus status;
//        manager.importDocument(url.pathOrUrl(), QString(), status);
//    }
    KisImageWSP importedImage = m_d->doc->image();

    if (importedImage) {
        KisLayerSP importedImageLayer =
                new KisPaintLayer(importedImage.data(),
                                  importedImage->nextLayerName(),
                                  OPACITY_OPAQUE_U8,
                                  importedImage->projection());

        if (!importedImageLayer.isNull()) {
            QStringList list;
            list << "KisLayer";

            KisCountVisitor visitor(list, KoProperties());
            importedImageLayer->accept(visitor);

            if (visitor.count() == 2) {
                // Don't import the root if this is not a layered image (1 group layer
                // plus 1 other).
                importedImageLayer = dynamic_cast<KisLayer*>(importedImageLayer->firstChild().data());
                if (importedImageLayer)
                    importedImage->removeNode(importedImageLayer.data());
            }

            importedImageLayer->setName(m_d->url.prettyUrl());
            importedImageLayer->setImage(m_d->view->image());

            KisNodeSP parent = 0;
            KisLayerSP currentActiveLayer = m_d->view->activeLayer();

            if (currentActiveLayer) {
                parent = currentActiveLayer->parent();
            }

            if (parent.isNull()) {
                parent = m_d->view->image()->rootLayer();
            }

            KisNodeCommandsAdapter adapter(m_d->view);
            adapter.addNode(importedImageLayer.data(), parent, currentActiveLayer.data());
        }
    }

    m_d->doc->deleteLater();
    deleteLater();
}

KisImportCatcher::~KisImportCatcher()
{
    delete m_d;
}

#include "kis_import_catcher.moc"
