/* This file is part of the KDE project
 * Copyright (C) 2006 Thomas Zander <zander@kde.org>
 * Copyright (C) 2011 KoGmbh <cbo@kogmbh.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef KWANCHORINGPROPERTIES_H
#define KWANCHORINGPROPERTIES_H

#include <ui_KWAnchoringProperties.h>
#include <dialogs/KWShapeConfigFactory.h>

#include <KoShapeConfigWidgetBase.h>
#include <KoTextAnchor.h>

#include <QList>
#include <QPointF>

class KWFrame;
class KoShape;

/// A widget that is shown to allow the user to select the anchoring properties
class KWAnchoringProperties : public KoShapeConfigWidgetBase
{
    Q_OBJECT
public:
    /// constructor
    explicit KWAnchoringProperties(FrameConfigSharedState *state);

    /// load all info from the argument frames into this widget
    void open(const QList<KWFrame*> &frames);
    /// reimplemented
    void open(KoShape *shape);
    /// reimplemented
    void save();

    /// reimplemented
    virtual bool showOnShapeCreate() {
        return true;
    }

private slots:
    void anchorTypeChanged(int anchorType);
    void vertPosChanged(int verticalAlign, QPointF offset = QPointF());
    void horizPosChanged(int horizontalAlign, QPointF offset = QPointF());

private:
    static const int vertRels[4][20];

    static const int horizRels[4][20];


    Ui::KWAnchoringProperties widget;
    FrameConfigSharedState *m_state;

    QButtonGroup *m_anchorTypeGroup;
    QButtonGroup *m_vertPosGroup;
    QButtonGroup *m_horizPosGroup;
    QList<KWFrame*> m_frames;
    QList<KoTextAnchor *> m_anchors;
    KoShape *m_shape;
    int m_anchorType;
    int m_vertPos;
    int m_horizPos;
    int m_vertRel;
    int m_horizRel;
};

#endif
