/*
 * This file is part of Calligra
 *
 * Copyright (C) 2011 Jan Hambrecht <jaham@gmx.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include "CSThumbProviderKarbon.h"

#include <KarbonPart.h>

#include <QApplication>
#include <QEventLoop>
#include <QtGui/QPixmap>
#include <QtGui/QPainter>

void processEvents()
{
    int i = 100;
    while (QCoreApplication::hasPendingEvents() && i > 0) {
        --i;
        QCoreApplication::processEvents(QEventLoop::ExcludeUserInputEvents);
    }
}

CSThumbProviderKarbon::CSThumbProviderKarbon(KarbonPart *doc)
: m_doc(doc)
{
}

CSThumbProviderKarbon::~CSThumbProviderKarbon()
{
}

QList<QPixmap> CSThumbProviderKarbon::createThumbnails(const QSize &thumbSize)
{
    // make sure everything is rendered before painting
    processEvents();

    QPixmap thumbnail(thumbSize);
    thumbnail.fill(Qt::white);
    QPainter thumbPainter(&thumbnail);
    m_doc->paintContent(thumbPainter, QRect(QPoint(0, 0), thumbSize));

    // make sure there are no events; this fixes a crash on shutdown
    processEvents();

    return QList<QPixmap>() << thumbnail;
}
