/*
 *  Copyright (c) 2007 Sven Langkamp <sven.langkamp@gmail.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
#ifndef KIS_SET_GLOBAL_SELECTION_COMMAND_H
#define KIS_SET_GLOBAL_SELECTION_COMMAND_H

#include <krita_export.h>
#include <kundo2command.h>
#include "kis_types.h"

/// The command for setting the global selection
class KRITAIMAGE_EXPORT KisSetGlobalSelectionCommand : public KUndo2Command
{

public:
    /**
     * Constructor
     * @param image the image to set the global selection on
     * @param parent the parent command
     * @param selection the selection that will be set a global selection, if 0 a new selection will be created
     */
    KisSetGlobalSelectionCommand(KisImageWSP image, KUndo2Command * parent = 0, KisSelectionSP selection = 0);
    virtual ~KisSetGlobalSelectionCommand();

    virtual void redo();
    virtual void undo();

private:
    KisImageWSP m_image;
    KisSelectionSP m_newSelection;
    KisSelectionSP m_oldSelection;
};

#endif //KIS_SET_GLOBAL_SELECTION_COMMAND_H
