/*
 * Decompiled with CFR 0.152.
 */
package mso.generator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mso.generator.Choice;
import mso.generator.Member;
import mso.generator.TypeRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class Struct
extends TypeRegistry.Type {
    final List<Member> members;
    final String sizeExpression;
    final boolean containsArrayMember;
    final boolean containsOptionalMember;
    final boolean containsUnknownLengthArrayMember;
    final boolean containsKnownLengthArrayMember;
    final boolean containsUnsureChoice;
    final boolean containsSureChoice;
    final boolean containsChoice;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static int getSize(TypeRegistry registry, Element e) throws IOException {
        int size = 0;
        NodeList l = e.getChildNodes();
        int i = 0;
        while (i < l.getLength()) {
            Element me;
            Node n = l.item(i);
            if (n instanceof Element && !(me = (Element)n).getNodeName().equals("limitation")) {
                Member m = new Member(registry, me);
                if (m.isOptional || m.condition != null || m.type() == null || m.type().size == -1) {
                    return -1;
                }
                if (m.isArray) {
                    Integer asize = null;
                    try {
                        if (m.size != null) {
                            asize = Integer.decode(m.size);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    Integer count = null;
                    try {
                        if (m.count != null) {
                            count = Integer.decode(m.count);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (asize != null) {
                        size += asize * 8;
                    } else {
                        if (count == null || m.type().size == -1) return -1;
                        size += count * m.type().size;
                    }
                } else {
                    size += m.type().size;
                }
            }
            ++i;
        }
        if (size == 0) {
            throw new Error("size is 0 for " + e.getAttribute("name"));
        }
        if (size % 8 == 0) return size;
        throw new Error("sizes do not add up to multiple of 8: " + size + " for " + e.getAttribute("name"));
    }

    Struct(TypeRegistry registry, Element e) throws IOException {
        TypeRegistry typeRegistry = registry;
        typeRegistry.getClass();
        super(typeRegistry, registry, e.getAttribute("name"), Struct.getSize(registry, e));
        this.members = new ArrayList<Member>();
        this.sizeExpression = e.getAttribute("size");
        boolean _containsArrayMember = false;
        boolean _containsOptionalMember = false;
        boolean _containsUnknownLengthArrayMember = false;
        boolean _containsKnownLengthArrayMember = false;
        boolean _containsSureChoice = false;
        boolean _containsUnsureChoice = false;
        NodeList l = e.getChildNodes();
        int i = 0;
        while (i < l.getLength()) {
            Node n = l.item(i);
            if (n instanceof Element) {
                Element me = (Element)n;
                if (me.getNodeName().equals("limitation")) break;
                Member m = new Member(registry, me);
                this.members.add(m);
                _containsArrayMember = _containsArrayMember || m.isArray;
                _containsOptionalMember = _containsOptionalMember || m.isOptional;
                _containsUnknownLengthArrayMember = _containsUnknownLengthArrayMember || m.isArray && m.count == null;
                boolean bl = _containsKnownLengthArrayMember = _containsKnownLengthArrayMember || m.count != null;
                if (m.type() instanceof Choice) {
                    _containsSureChoice = _containsSureChoice || ((Choice)m.type()).commonType != null;
                    _containsUnsureChoice = _containsSureChoice || ((Choice)m.type()).commonType == null;
                }
            }
            ++i;
        }
        this.containsArrayMember = _containsArrayMember;
        this.containsOptionalMember = _containsOptionalMember;
        this.containsUnknownLengthArrayMember = _containsUnknownLengthArrayMember;
        this.containsKnownLengthArrayMember = _containsKnownLengthArrayMember;
        this.containsUnsureChoice = _containsUnsureChoice;
        this.containsSureChoice = _containsSureChoice;
        this.containsChoice = this.containsUnsureChoice || this.containsSureChoice;
    }
}

