/*
 * Decompiled with CFR 0.152.
 */
package mso.generator;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mso.generator.Choice;
import mso.generator.Limitation;
import mso.generator.MSO;
import mso.generator.Member;
import mso.generator.Option;
import mso.generator.Stream;
import mso.generator.Struct;
import mso.generator.TypeRegistry;

public class QtParserGenerator {
    public final QtParserConfiguration config = new QtParserConfiguration();
    private final String generatedWarning = "/* This code was generated by msoscheme (http://gitorious.org/msoscheme) */";

    void generate(MSO mso) throws IOException {
        FileWriter fout = this.config.createHeader ? new FileWriter(String.valueOf(this.config.outputdir) + File.separator + this.config.basename + ".h") : new FileWriter(String.valueOf(this.config.outputdir) + File.separator + this.config.basename + ".cpp");
        PrintWriter out = new PrintWriter(fout);
        out.println("/* This code was generated by msoscheme (http://gitorious.org/msoscheme) */");
        if (this.config.createHeader) {
            out.println("#ifndef " + this.config.basename.toUpperCase() + "_H");
            out.println("#define " + this.config.basename.toUpperCase() + "_H");
        }
        out.println("#include <QString>");
        out.println("#include <QByteArray>");
        out.println("#include <QVector>");
        out.println("#include <QSharedPointer>// replace with QScopedPointer when switching to Qt 4.6");
        if (this.config.enableXml) {
            out.println("#include <QXmlStreamReader>");
        }
        if (this.config.enableWriting) {
            out.println("#include \"leoutputstream.h\"");
        }
        if (this.config.enableIntrospection) {
            out.println("#include \"introspection.h\"");
        }
        out.println("class LEInputStream;");
        out.println("namespace " + this.config.namespace + "{");
        if (this.config.enableXml) {
            out.println("void skipToStartElement(QXmlStreamReader& in) {");
            out.println("    do {");
            out.println("        in.readNext();");
            out.println("    } while (!in.atEnd() && !in.isStartElement());");
            out.println("}");
        }
        if (!this.config.enableIntrospection) {
            out.println("class StreamOffset {");
            out.println("public:");
            out.println("    virtual ~StreamOffset() {}");
            out.println("    quint32 streamOffset;");
            out.println("};");
        }
        for (Struct s : mso.structs) {
            out.println("class " + s.name + ";");
            out.println("void parse" + s.name + "(LEInputStream& in, " + s.name + "& _s);");
            if (this.config.enableXml) {
                out.println("void parse" + s.name + "(QXmlStreamReader& in, " + s.name + "& _s);");
            }
            if (!this.config.enableWriting) continue;
            out.println("void write(const " + s.name + "& v, LEOutputStream& out);");
        }
        for (Struct s : mso.structs) {
            this.printStructureClassDeclaration(out, s);
        }
        if (this.config.createHeader) {
            out.println("} // close namespace");
            out.println("#endif");
            out.close();
            fout = new FileWriter(String.valueOf(this.config.outputdir) + File.separator + this.config.basename + ".cpp");
            out = new PrintWriter(fout);
            out.println("/* This code was generated by msoscheme (http://gitorious.org/msoscheme) */");
            out.println("#include \"" + this.config.basename + ".h\"");
            out.println("using namespace " + this.config.namespace + ";");
        }
        out.println("#include \"leinputstream.h\"");
        if (this.config.enableIntrospection) {
            for (Struct s : mso.structs) {
                this.printStructureClassImplementation(out, s);
            }
        }
        for (Struct s : mso.structs) {
            this.printStructureParser(out, s);
            if (this.config.enableWriting) {
                this.printStructureWriter(out, s);
            }
            if (!this.config.enableXml) continue;
            this.printStructureXmlParser(out, s);
        }
        if (!this.config.createHeader) {
            out.println("}");
        }
        if (this.config.enableIntrospection) {
            out.println("const Introspectable* parse(const QString& key, LEInputStream& in) {");
            out.println("    const Introspectable* i = 0;");
            boolean first = true;
            for (Stream s : mso.streams) {
                out.print("    ");
                if (first) {
                    first = false;
                } else {
                    out.print("} else ");
                }
                out.println("if (\"" + s.key + "\" == key) {");
                out.println("        " + s.type + " *_t = new " + s.type + "(0);");
                out.println("        parse" + s.type + "(in, *_t);");
                out.println("        i = _t;");
            }
            out.println("    } else {");
            out.println("        TODOS* _t = new TODOS(0);");
            out.println("        parseTODOS(in, *_t);");
            out.println("        i = _t;");
            out.println("    }");
            out.println("    return i;");
            out.println("}");
        }
        if (this.config.enableXml) {
            out.println("const QMap<QString,QSharedPointer<const Introspectable> > parse(QXmlStreamReader& in) {");
            out.println("    QMap<QString,QSharedPointer<const Introspectable> > streams;");
            out.println("    // skip until first element");
            out.println("    while (!in.atEnd() && !in.isStartElement()) {");
            out.println("        in.readNext();");
            out.println("    }");
            out.println("    if (!in.isStartElement()) {");
            out.println("        return streams;");
            out.println("    }");
            out.println("    do {");
            out.println("        in.readNext();");
            out.println("    } while (!in.atEnd() && !in.isStartElement());");
            out.println("    if (!in.isStartElement()) {");
            out.println("        return streams;");
            out.println("    }");
            out.println("    do {");
            out.println("        QString name = in.name().toString();");
            out.println("        if (streams.contains(name)) {");
            out.println("            streams.clear();");
            out.println("            return streams;");
            out.println("        }");
            boolean first = true;
            for (Stream s : mso.streams) {
                out.print("        ");
                if (first) {
                    first = false;
                } else {
                    out.print("} else ");
                }
                out.println("if (\"" + s.key + "\" == name) {");
                out.println("            QSharedPointer<Introspectable> _t(new " + s.type + "(0));");
                out.println("            parse" + s.type + "(in, *static_cast<" + s.type + "*>(_t.data()));");
                out.println("            streams[name] = _t;");
            }
            out.println("        } else { // unknown stream should be binary");
            out.println("            QSharedPointer<Introspectable> _t(new TODOS(0));");
            out.println("            parseTODOS(in, *static_cast<TODOS*>(_t.data()));");
            out.println("            streams[name] = _t;");
            out.println("        }");
            out.println("        do {");
            out.println("            in.readNext();");
            out.println("        } while (in.isWhitespace());");
            out.println("    } while (in.isStartElement());");
            out.println("    qDebug() << in.tokenType();");
            out.println("    if (!in.isEndElement()) {");
            out.println("        qDebug() << \"parsing error: not at end of an element\";");
            out.println("        streams.clear();");
            out.println("    }");
            out.println("    in.readNext();");
            out.println("    if (!in.isEndDocument()) {");
            out.println("        qDebug() << \"parsing error: not at end of xml\";");
            out.println("        streams.clear();");
            out.println("    }");
            out.println("    return streams;");
            out.println("}");
            out.println("void serialize(const Introspectable* i, const QString& key, LEOutputStream& out)  {");
            first = true;
            for (Stream s : mso.streams) {
                out.print("    ");
                if (first) {
                    first = false;
                } else {
                    out.print("} else ");
                }
                out.println("if (\"" + s.key + "\" == key) {");
                out.println("        write(*static_cast<const " + s.type + "*>(i), out);");
            }
            out.println("    } else {");
            out.println("        write(*static_cast<const TODOS*>(i), out);");
            out.println("    }");
            out.println("}");
        }
        out.close();
        fout.close();
    }

    private void printStructureParser(PrintWriter out, Struct s) {
        out.print("void ");
        if (this.config.namespace != null && this.config.namespace.length() > 0) {
            out.print(String.valueOf(this.config.namespace) + "::");
        }
        out.println("parse" + s.name + "(LEInputStream& in, " + s.name + "& _s) {");
        out.println("    _s.streamOffset = in.getPosition();");
        if (s.containsKnownLengthArrayMember) {
            out.println("    int _c;");
        }
        if (s.containsArrayMember || s.containsOptionalMember || s.containsChoice) {
            out.println("    LEInputStream::Mark _m;");
        }
        if (s.containsOptionalMember) {
            out.println("    bool _possiblyPresent;");
        }
        if (s.containsUnknownLengthArrayMember) {
            out.println("    bool _atend;");
        }
        for (Member m : s.members) {
            if (this.config.enableStyleTextPropAtomFix && s.name.equals("StyleTextPropAtom") && m.name.equals("todo")) break;
            this.printStructureMemberParser(out, s.name, m);
            m.type().name.contains("RecordHeader");
            if (!this.config.enableStyleTextPropAtomFix || !s.name.equals("TextContainer") || !m.name.equals("style")) continue;
            this.styleTextPropAtomFix2(out);
        }
        out.println("}");
    }

    private void printStructureXmlParser(PrintWriter out, Struct s) {
        out.println("void parse" + s.name + "(QXmlStreamReader& in, " + s.name + "& _s) {");
        out.println("    in.readNext();");
        for (Member m : s.members) {
            this.printStructureMemberXmlParser(out, m);
        }
        out.println("}");
    }

    private static String prependStructureToExpression(String expression, String structureName) {
        if (expression.length() > 0) {
            Pattern p = Pattern.compile("([^.\\w])([.a-zA-Z])");
            Matcher m = p.matcher(expression);
            expression = m.replaceAll("$1" + structureName + ".$2");
            p = Pattern.compile("^([a-zA-Z])");
            m = p.matcher(expression);
            expression = m.replaceAll(String.valueOf(structureName) + ".$1");
        }
        return expression;
    }

    private void printStructureMemberParser(PrintWriter out, String structure, Member m) {
        String parse;
        String index;
        String s = "    ";
        String string = index = m.count == null ? "" : "[_i]";
        if (m.condition != null) {
            String condition = QtParserGenerator.prependStructureToExpression(m.condition, "_s");
            if (!m.isStruct) {
                out.println(String.valueOf(s) + "_s._has_" + m.name + " = " + condition + ";");
                out.println(String.valueOf(s) + "if (_s._has_" + m.name + ") {");
            } else {
                out.println(String.valueOf(s) + "if (" + condition + ") {");
            }
            s = String.valueOf(s) + "    ";
            if (m.isStruct) {
                out.println(String.valueOf(s) + "_s." + m.name + " = QSharedPointer<" + m.type().name + ">(new " + m.type().name + "(&_s));");
                index = ".data()";
            }
        }
        if (m.isStruct) {
            String star = m.condition == null ? "" : "*";
            parse = "parse" + m.type().name + "(in, " + star + "_s." + m.name + index + ");";
        } else {
            parse = "_s." + m.name + index + " = in.read" + m.type().name + "();";
        }
        if (m.isChoice) {
            this.printChoiceParser(out, s, structure, m);
            return;
        }
        if (m.isArray && m.count == null) {
            if (m.size != null) {
                this.printFixedSizeArrayParser(out, s, m);
            } else {
                this.printVariableArrayParser(out, s, m);
            }
            return;
        }
        if (m.isOptional) {
            this.printOptionalMemberParser(out, s, m);
            return;
        }
        if (m.count != null) {
            String count = QtParserGenerator.prependStructureToExpression(m.count, "_s");
            out.println(String.valueOf(s) + "_c = " + count + ";");
        }
        if (m.count != null) {
            if (!m.isStruct) {
                out.println(String.valueOf(s) + "_s." + m.name + ".resize(_c);");
            }
            if (m.type() == m.registry.uint8) {
                out.println(String.valueOf(s) + "in.readBytes(_s." + m.name + ");");
            } else {
                out.println(String.valueOf(s) + "for (int _i=0; _i<_c; ++_i) {");
                if (m.isStruct) {
                    out.println(String.valueOf(s) + "    _s." + m.name + ".append(" + m.type().name + "(&_s));");
                }
                out.println(String.valueOf(s) + "    " + parse);
                this.printLimitationCheck(out, "        ", "_s." + m.name + "[_i]", m);
                out.println(String.valueOf(s) + "}");
            }
        } else {
            out.println(String.valueOf(s) + parse);
            this.printLimitationCheck(out, s, "_s." + m.name, m);
        }
        if (m.condition != null) {
            out.println("    }");
        }
    }

    private void printStructureMemberXmlParser(PrintWriter out, Member m) {
        String s = "    ";
        out.println(String.valueOf(s) + "if (!in.isStartElement()) {");
        out.println(String.valueOf(s) + "    qDebug() << \"not startelement in " + m.type().name + " \" << in.lineNumber();");
        out.println(String.valueOf(s) + "    return;");
        out.println(String.valueOf(s) + "}");
        if (!m.isOptional && !m.isArray) {
            out.println(String.valueOf(s) + "if (in.name() != \"" + m.name + "\") {");
            out.println(String.valueOf(s) + "    qDebug() << \"not startelement in " + m.name + " \" << in.lineNumber();");
            out.println(String.valueOf(s) + "    return;");
            out.println(String.valueOf(s) + "}");
        }
        if (m.isOptional) {
            out.println(String.valueOf(s) + "if (in.name() == \"" + m.name + "\") {");
            s = String.valueOf(s) + "    ";
        }
        if (!m.isStruct) {
            out.println(String.valueOf(s) + "in.readElementText();");
        } else {
            out.println(String.valueOf(s) + "skipToStartElement(in);");
        }
        if (m.isOptional) {
            out.println("    }");
        }
    }

    private void printStructureWriter(PrintWriter out, Struct s) {
        out.println("void write(const " + s.name + "& _s, LEOutputStream& out) {");
        for (Member m : s.members) {
            this.printStructureMemberWriter(out, m);
        }
        out.println("}");
    }

    private void printStructureMemberWriter(PrintWriter out, Member m) {
        String s = "    ";
        if (m.condition != null) {
            out.println("    if (" + QtParserGenerator.getExpression("_s", m.condition) + ") {");
            s = String.valueOf(s) + "    ";
        }
        if (m.isChoice) {
            boolean first = true;
            String[] stringArray = ((Choice)m.type()).getChoiceNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String t = stringArray[n2];
                out.print(s);
                if (!first) {
                    out.print("} else ");
                }
                first = false;
                out.println("if (_s." + m.name + ".is<" + t + ">()) {");
                out.println(String.valueOf(s) + "    write(*_s." + m.name + ".get<" + t + ">(), out);");
                ++n2;
            }
            out.println(String.valueOf(s) + "}");
        } else if (m.isArray) {
            if (m.type() == m.registry.uint8) {
                out.println(String.valueOf(s) + "out.writeBytes(_s." + m.name + ");");
            } else {
                String t = this.getTypeName(m.type());
                out.println(String.valueOf(s) + "foreach (" + t + " _i, _s." + m.name + ") {");
                if (m.isStruct) {
                    out.println(String.valueOf(s) + "    write(_i, out);");
                } else {
                    out.println(String.valueOf(s) + "    out.write" + m.type().name + "(_i);");
                }
                out.println(String.valueOf(s) + "}");
            }
        } else if (m.isStruct) {
            out.print(s);
            if (m.isOptional || m.condition != null) {
                out.print("if (_s." + m.name + ") write(*");
            } else {
                out.print("write(");
            }
            out.println("_s." + m.name + ", out);");
        } else {
            out.println(String.valueOf(s) + "out.write" + m.type().name + "(_s." + m.name + ");");
        }
        if (m.condition != null) {
            out.println("    }");
        }
    }

    private String getTypeName(TypeRegistry.Type t) {
        TypeRegistry r = t.registry;
        if (t instanceof Choice) {
            return this.createChoiceClass(t.name, (Choice)t);
        }
        if (t == r.bit) {
            return "bool";
        }
        if (t == r.uint2 || t == r.uint3 || t == r.uint4 || t == r.uint5 || t == r.uint6 || t == r.uint7 || t == r.uint8) {
            return "quint8";
        }
        if (t == r.uint9 || t == r.uint12 || t == r.uint13 || t == r.uint14 || t == r.uint15 || t == r.uint16) {
            return "quint16";
        }
        if (t == r.uint20 || t == r.uint30 || t == r.uint32) {
            return "quint32";
        }
        if (t == r.int16) {
            return "qint16";
        }
        if (t == r.int32) {
            return "qint32";
        }
        return t.name;
    }

    private String createChoiceClass(String name, Choice c) {
        String base = "StreamOffset";
        if (this.config.enableIntrospection) {
            base = "Introspectable";
        }
        String choice = "class " + name + " : public QSharedPointer<" + base + "> {\n";
        choice = String.valueOf(choice) + "    public:\n";
        choice = String.valueOf(choice) + "        " + name + "() {}\n";
        String[] stringArray = c.getChoiceNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            choice = String.valueOf(choice) + "        explicit " + name + "(" + s + "* a) :QSharedPointer<" + base + ">(a) {}\n";
            ++n2;
        }
        choice = String.valueOf(choice) + "        template <typename T> T*get() { return dynamic_cast<T*>(this->data()); }\n";
        choice = String.valueOf(choice) + "        template <typename T> const T*get() const { return dynamic_cast<const T*>(this->data()); }\n";
        choice = String.valueOf(choice) + "        template <typename T> bool is() const { return get<T>(); }\n";
        choice = String.valueOf(choice) + "    };\n";
        choice = String.valueOf(choice) + "    " + name;
        return choice;
    }

    private String getMemberDeclaration(Member m) {
        String t = this.getTypeName(m.type());
        if (m.isArray) {
            if (m.isStruct) {
                return "QList<" + m.type().name + "> " + m.name;
            }
            if ("quint8".equals(t)) {
                return "QByteArray " + m.name;
            }
            return "QVector<" + t + "> " + m.name;
        }
        if (m.isStruct && (m.isOptional || m.condition != null)) {
            return "QSharedPointer<" + t + "> " + m.name;
        }
        return String.valueOf(t) + " " + m.name;
    }

    private String memberToString(Member m, String prefix) {
        String mn = String.valueOf(prefix) + m.name;
        String s = m.isArray ? "\"[array of " + mn + "]\"" : (m.isInteger ? "QString::number(" + mn + ") + \"(\" + QString::number(" + mn + ",16).toUpper() + \")\"" : (m.type() == m.type().registry.bit ? "QString::number(" + mn + ")" : (m.isChoice ? "\"<choice>\"" : (m.isOptional || m.condition != null ? "((" + mn + ")?" + mn + "->toString() :\"null\")" : String.valueOf(mn) + ".toString()"))));
        return s;
    }

    private void styleTextPropAtomFix(PrintWriter out) {
        out.println("    RecordHeader rh;");
        out.println("    QList<TextPFRun> rgTextPFRun;");
        out.println("    QList<TextCFRun> rgTextCFRun;");
    }

    private void styleTextPropAtomFix2(PrintWriter out) {
        out.println("    if (_s.style) {");
        out.println("        quint32 count = 0;");
        out.println("        if (_s.text.is<TextCharsAtom>()) {");
        out.println("            count = _s.text.get<TextCharsAtom>()->textChars.size();");
        out.println("        }");
        out.println("        if (_s.text.is<TextBytesAtom>()) {");
        out.println("            count = _s.text.get<TextBytesAtom>()->textChars.size();");
        out.println("        }");
        out.println("        quint32 sum = 0;");
        out.println("        do {");
        out.println("        _s.style->rgTextPFRun.append(TextPFRun(_s.style.data()));");
        out.println("            parseTextPFRun(in, _s.style->rgTextPFRun.last());");
        out.println("            sum += _s.style->rgTextPFRun.last().count;");
        out.println("        } while (sum <= count);");
        out.println("        sum = 0;");
        out.println("        do {");
        out.println("            _s.style->rgTextCFRun.append(TextCFRun(_s.style.data()));");
        out.println("            parseTextCFRun(in, _s.style->rgTextCFRun.last());");
        out.println("            sum += _s.style->rgTextCFRun.last().count;");
        out.println("        } while (sum <= count);");
        out.println("    }");
    }

    private void printStructureClassDeclaration(PrintWriter out, Struct s) {
        out.print("class " + s.name);
        if (this.config.enableIntrospection) {
            out.println(" : public Introspectable {");
            out.println("private:");
            out.println("    class _Introspection;");
        } else {
            out.println(" : public StreamOffset {");
        }
        out.println("public:");
        if (this.config.enableIntrospection) {
            out.println("    static const Introspection _introspection;");
        }
        for (Member m : s.members) {
            if (m.isStruct || m.condition == null) continue;
            out.println("    bool _has_" + m.name + ";");
        }
        if (this.config.enableStyleTextPropAtomFix && s.name.equals("StyleTextPropAtom")) {
            this.styleTextPropAtomFix(out);
        } else {
            for (Member m : s.members) {
                String d = this.getMemberDeclaration(m);
                out.println("    " + d + ";");
            }
        }
        boolean first = true;
        if (this.config.enableIntrospection) {
            out.print("    explicit " + s.name + "(const Introspectable* parent)");
            out.print("\n       :Introspectable(parent)");
            first = false;
            for (Member m : s.members) {
                if (!m.isStruct || m.isArray || m.isOptional || m.isChoice || m.condition != null) continue;
                if (first) {
                    out.print("\n       :");
                    first = false;
                } else {
                    out.print(",\n        ");
                }
                out.print(String.valueOf(m.name) + "(this)");
            }
            out.println(" {}");
        } else {
            out.println("    " + s.name + "(void* /*dummy*/ = 0) {}");
        }
        if (this.config.enableToString) {
            out.println("    QString toString() {");
            out.println("        QString _s = \"" + s.name + ":\";");
            for (Member m : s.members) {
                out.print("        _s = _s + \"" + m.name + ": \" + ");
                out.print(this.memberToString(m, ""));
                out.println(" + \", \";");
            }
            out.println("        return _s;");
            out.println("    }");
        }
        if (this.config.enableIntrospection) {
            out.println("    const Introspection* getIntrospection() const { return &_introspection; }");
        }
        out.println("};");
    }

    private void printStructureClassImplementation(PrintWriter out, Struct s) {
        int nm = s.members.size();
        String ns = String.valueOf(s.name) + "::_Introspection";
        out.println("class " + ns + " {");
        out.println("public:");
        out.println("    static const QString name;");
        out.println("    static const int numberOfMembers;");
        out.println("    static const QString names[" + nm + "];");
        out.println("    static int (* const numberOfInstances[" + nm + "])(const Introspectable*);");
        out.println("    static QVariant (* const value[" + nm + "])(const Introspectable*, int position);");
        out.println("    static const Introspectable* (* const introspectable[" + nm + "])(const Introspectable*, int position);");
        for (Member m : s.members) {
            if (s.name.equals("StyleTextPropAtom") && this.config.enableStyleTextPropAtomFix && m.name.equals("todo")) break;
            if (!m.isStruct && !m.isChoice) {
                if (m.condition != null) {
                    out.println("    static int count_" + m.name + "(const Introspectable* i) {");
                    out.println("        return static_cast<const " + s.name + "*>(i)->_has_" + m.name + " ?1 :0;");
                    out.println("    }");
                }
            } else if (m.isOptional || m.condition != null) {
                out.println("    static int count_" + m.name + "(const Introspectable* i) {");
                out.println("        return get_" + m.name + "(i, 0) ?1 :0;");
                out.println("    }");
            } else if (m.isArray) {
                out.println("    static int count_" + m.name + "(const Introspectable* i) {");
                out.println("        return static_cast<const " + s.name + "*>(i)->" + m.name + ".size();");
                out.println("    }");
            }
            if (m.isStruct || m.isChoice) {
                out.println("    static const Introspectable* get_" + m.name + "(const Introspectable* i, int j) {");
            } else {
                out.println("    static QVariant get_" + m.name + "(const Introspectable* i, int j) {");
            }
            String dm = "static_cast<const " + s.name + "*>(i)->" + m.name;
            if (!m.isChoice) {
                out.print("        ");
                if (!m.isStruct) {
                    if (m.isArray && m.type() != m.type().registry.uint8) {
                        out.println("return qVariantFromValue(" + dm + ");");
                    } else {
                        out.println("return " + dm + ";");
                    }
                } else if (m.isArray) {
                    out.println("return &(" + dm + "[j]);");
                } else if (m.isOptional || m.condition != null) {
                    out.println("return " + dm + ".data();");
                } else {
                    out.println("return &(" + dm + ");");
                }
            } else {
                out.println("        return static_cast<const " + s.name + "*>(i)->" + m.name + ".data();");
            }
            out.println("    }");
        }
        out.println("};");
        out.println("const QString " + ns + "::name(\"" + s.name + "\");");
        out.println("const int " + ns + "::numberOfMembers(" + nm + ");");
        out.println("const QString " + ns + "::names[" + nm + "] = {");
        for (Member m : s.members) {
            out.println("    \"" + m.name + "\",");
        }
        out.println("};");
        out.println("int (* const " + ns + "::numberOfInstances[" + nm + "])(const Introspectable*) = {");
        for (Member m : s.members) {
            if (m.condition != null || (m.isStruct || m.isChoice) && (m.isOptional || m.isArray)) {
                out.println("    _Introspection::count_" + m.name + ",");
                continue;
            }
            out.println("    Introspection::one,");
        }
        out.println("};");
        out.println("QVariant (* const " + ns + "::value[" + nm + "])(const Introspectable*, int position) = {");
        for (Member m : s.members) {
            if (s.name.equals("StyleTextPropAtom") && this.config.enableStyleTextPropAtomFix && m.name.equals("todo")) break;
            if (m.isStruct || m.isChoice) {
                out.println("    Introspection::nullValue,");
                continue;
            }
            out.println("    _Introspection::get_" + m.name + ",");
        }
        out.println("};");
        out.println("const Introspectable* (* const " + ns + "::introspectable[" + nm + "])(const Introspectable*, int position) = {");
        for (Member m : s.members) {
            if (m.isStruct || m.isChoice) {
                out.println("    _Introspection::get_" + m.name + ",");
                continue;
            }
            out.println("    Introspection::null,");
        }
        out.println("};");
        out.println("const Introspection " + s.name + "::_introspection(");
        out.println("    \"" + s.name + "\", " + s.members.size() + ", _Introspection::names, _Introspection::numberOfInstances, _Introspection::value, _Introspection::introspectable);");
    }

    private void printChoiceParser(PrintWriter out, String s, String structure, Member m) {
        Choice c = (Choice)m.type();
        if (c.commonType == null) {
            this.printUnsureChoiceParser(out, s, structure, m);
        } else {
            this.printSureChoiceParser(out, s, structure, m);
        }
    }

    String getClause(String name, TypeRegistry.Type t, Option.Lim lim) {
        String ls;
        block6: {
            block5: {
                ls = "";
                if (lim.limitations == null || lim.limitations.length <= 0) break block5;
                int i = 0;
                while (i < lim.limitations.length) {
                    Limitation l = lim.limitations[i];
                    String condition = l.expression;
                    String mname = name;
                    if (t instanceof Struct) {
                        mname = String.valueOf(mname) + "." + l.name;
                    }
                    condition = condition == null ? QtParserGenerator.getCondition(mname, l) : QtParserGenerator.getExpression(mname, condition);
                    if (ls.length() > 0) {
                        ls = String.valueOf(ls) + "&&";
                    }
                    ls = String.valueOf(ls) + "(" + condition + ")";
                    ++i;
                }
                break block6;
            }
            if (lim.lims == null || lim.lims.length <= 0) break block6;
            int i = 0;
            while (i < lim.lims.length) {
                Option.Lim l = lim.lims[i];
                String condition = this.getClause(name, t, l);
                if (ls.length() > 0) {
                    ls = String.valueOf(ls) + "||";
                }
                ls = String.valueOf(ls) + "(" + condition + ")";
                ++i;
            }
        }
        return ls.replace("..", ".");
    }

    private void printSureChoiceParser(PrintWriter out, String s, String structure, Member m) {
        out.println(String.valueOf(s) + "_m = in.setMark();");
        Choice c = (Choice)m.type();
        String type = this.getTypeName(c.commonType);
        if (c.commonType instanceof Struct) {
            out.println(String.valueOf(s) + type + " _choice(&_s);");
            out.println(String.valueOf(s) + "parse" + type + "(in, _choice);");
        } else {
            out.println(String.valueOf(s) + type + " _choice = in.read" + c.commonType.name + "();");
        }
        out.println(String.valueOf(s) + "in.rewind(_m);");
        out.println(String.valueOf(s) + "qint64 startPos = in.getPosition();");
        int i = 0;
        while (i < c.options.size()) {
            out.print(s);
            Option o = c.options.get(i);
            String clause = this.getClause("_choice", o.limitsType, o.lim);
            out.print("if (startPos == in.getPosition()");
            if (clause == null || !m.isOptional && i == c.options.size() - 1) {
                out.println(") {");
            } else {
                out.println(" && (" + clause + ")) {");
            }
            out.println(String.valueOf(s) + "    _s." + m.name + " = " + structure + "::" + m.type().name + "(new " + o.type.name + "(&_s));");
            out.println(String.valueOf(s) + "    parse" + o.type.name + "(in, *(" + o.type.name + "*)_s." + m.name + ".data());");
            out.println(String.valueOf(s) + "}");
            ++i;
        }
    }

    private void printUnsureChoiceParser(PrintWriter out, String s, String structure, Member m) {
        String choice;
        String closing = "";
        String exception = "_x";
        out.println(String.valueOf(s) + "_m = in.setMark();");
        Choice c = (Choice)m.type();
        String[] choices = c.getChoiceNames();
        int length = m.isOptional ? choices.length : choices.length - 1;
        int i = 0;
        while (i < length) {
            choice = choices[i];
            out.println(String.valueOf(s) + "try {");
            out.println(String.valueOf(s) + "    _s." + m.name + " = " + structure + "::" + c.name + "(new " + choice + "(&_s));");
            out.println(String.valueOf(s) + "    parse" + choice + "(in, *(" + choice + "*)_s." + m.name + ".data());");
            out.println(String.valueOf(s) + "} catch (IncorrectValueException " + exception + ") {");
            out.println(String.valueOf(s) + "    _s." + m.name + ".clear();");
            out.println(String.valueOf(s) + "    in.rewind(_m);");
            exception = String.valueOf(exception) + "x";
            closing = String.valueOf(closing) + "}";
            ++i;
        }
        if (!m.isOptional) {
            choice = choices[choices.length - 1];
            out.println(String.valueOf(s) + "    _s." + m.name + " = " + structure + "::" + c.name + "(new " + choice + "(&_s));");
            out.println(String.valueOf(s) + "    parse" + choice + "(in, *(" + choice + "*)_s." + m.name + ".data());");
        }
        out.println(String.valueOf(s) + closing);
    }

    private void printFixedSizeArrayParser(PrintWriter out, String s, Member m) {
        out.println(String.valueOf(s) + "qint64 _startPos = in.getPosition();");
        out.println(String.valueOf(s) + "int _totalSize = qMin(" + QtParserGenerator.getExpression("_s", m.size) + ", quint32(in.getSize() - _startPos));");
        out.println(String.valueOf(s) + "_atend = in.getPosition() - _startPos >= _totalSize;");
        out.println(String.valueOf(s) + "while (!_atend) {");
        out.println(String.valueOf(s) + "    _s." + m.name + ".append(" + m.type().name + "(&_s));");
        out.println(String.valueOf(s) + "    parse" + m.type().name + "(in, _s." + m.name + ".last());");
        out.println(String.valueOf(s) + "    _atend = in.getPosition() - _startPos >= _totalSize;");
        out.println(String.valueOf(s) + "}");
    }

    private void printVariableArrayParser(PrintWriter out, String s, Member m) {
        out.println(String.valueOf(s) + "_atend = false;");
        out.println(String.valueOf(s) + "while (!_atend) {");
        out.println(String.valueOf(s) + "    _m = in.setMark();");
        out.println(String.valueOf(s) + "    try {");
        out.println(String.valueOf(s) + "        _s." + m.name + ".append(" + m.type().name + "(&_s));");
        out.println(String.valueOf(s) + "        parse" + m.type().name + "(in, _s." + m.name + ".last());");
        out.println(String.valueOf(s) + "    } catch(IncorrectValueException _e) {");
        out.println(String.valueOf(s) + "        _s." + m.name + ".removeLast();");
        out.println(String.valueOf(s) + "        _atend = true;");
        out.println(String.valueOf(s) + "        in.rewind(_m);");
        out.println(String.valueOf(s) + "    } catch(EOFException _e) {");
        out.println(String.valueOf(s) + "        _s." + m.name + ".removeLast();");
        out.println(String.valueOf(s) + "        _atend = true;");
        out.println(String.valueOf(s) + "        in.rewind(_m);");
        out.println(String.valueOf(s) + "    }");
        out.println(String.valueOf(s) + "}");
    }

    private void printOptionalMemberParser(PrintWriter out, String s, Member m) {
        out.println(String.valueOf(s) + "_m = in.setMark();");
        Option o = new Option((Struct)m.type(), null);
        String type = this.getTypeName(o.limitsType);
        out.println(String.valueOf(s) + "try {");
        out.println(String.valueOf(s) + "    " + type + " _optionCheck(&_s);");
        out.println(String.valueOf(s) + "    parse" + type + "(in, _optionCheck);");
        out.println(String.valueOf(s) + "    _possiblyPresent = " + this.getClause("_optionCheck", o.limitsType, o.lim) + ";");
        out.println(String.valueOf(s) + "} catch(EOFException _e) {");
        out.println(String.valueOf(s) + "    _possiblyPresent = false;");
        out.println(String.valueOf(s) + "}");
        out.println(String.valueOf(s) + "in.rewind(_m);");
        out.println(String.valueOf(s) + "_m = in.setMark();");
        out.println(String.valueOf(s) + "if (_possiblyPresent) {");
        out.println(String.valueOf(s) + "    try {");
        out.println(String.valueOf(s) + "        _s." + m.name + " = QSharedPointer<" + m.type().name + ">(new " + m.type().name + "(&_s));");
        out.println(String.valueOf(s) + "        parse" + m.type().name + "(in, *_s." + m.name + ".data());");
        out.println(String.valueOf(s) + "    } catch(IncorrectValueException _e) {");
        out.println(String.valueOf(s) + "        _s." + m.name + ".clear();");
        out.println(String.valueOf(s) + "        in.rewind(_m);");
        out.println(String.valueOf(s) + "    } catch(EOFException _e) {");
        out.println(String.valueOf(s) + "        _s." + m.name + ".clear();");
        out.println(String.valueOf(s) + "        in.rewind(_m);");
        out.println(String.valueOf(s) + "    }");
        out.println(String.valueOf(s) + "}");
    }

    private void printLimitationCheck(PrintWriter out, String s, String name, Member m) {
        Limitation[] limitationArray = m.limitations;
        int n = m.limitations.length;
        int n2 = 0;
        while (n2 < n) {
            String condition;
            Limitation l = limitationArray[n2];
            String mname = l.name;
            mname = !"".equals(mname) ? String.valueOf(name) + "." + mname : name;
            if (!m.isStruct) {
                mname = "((" + this.getTypeName(m.type()) + ")" + mname + ")";
            }
            condition = (condition = l.expression) == null ? QtParserGenerator.getCondition(mname, l) : QtParserGenerator.getExpression(mname, condition);
            out.println(String.valueOf(s) + "if (!(" + condition + ")) {");
            String exceptionType = "IncorrectValueException";
            out.println(String.valueOf(s) + "    throw " + exceptionType + "(in.getPosition(), \"" + condition + "\");");
            out.println(String.valueOf(s) + "}");
            ++n2;
        }
    }

    static String getExpression(String structure, String expression) {
        if (Pattern.matches(".*[A-Za-z].*", expression)) {
            return QtParserGenerator.prependStructureToExpression(expression, structure);
        }
        return String.valueOf(structure) + expression;
    }

    static String getCondition(String name, Limitation l) {
        String value = l.value;
        String cmp = " == ";
        String cmb = " || ";
        if (value.startsWith("!")) {
            value = value.substring(1);
            cmp = " != ";
            cmb = " && ";
        }
        if (value.contains("|")) {
            String[] values = value.split("\\|");
            String c = String.valueOf(name) + cmp + values[0];
            int i = 1;
            while (i < values.length) {
                c = String.valueOf(c) + cmb + name + cmp + values[i];
                ++i;
            }
            return c;
        }
        if (!"".equals(value)) {
            return String.valueOf(name) + cmp + value;
        }
        return l.value;
    }

    public class QtParserConfiguration {
        public String namespace;
        public String outputdir;
        public String basename;
        public boolean createHeader;
        public boolean enableXml;
        public boolean enableWriting;
        public boolean enableIntrospection;
        public boolean enableToString;
        public boolean enableStyleTextPropAtomFix;
    }
}

