/*
 * Decompiled with CFR 0.152.
 */
package mso.generator;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import mso.generator.Choice;
import mso.generator.Limitation;
import mso.generator.MSO;
import mso.generator.Member;
import mso.generator.Option;
import mso.generator.QtParserGenerator;
import mso.generator.Struct;
import mso.generator.TypeRegistry;

public class QtApiGenerator {
    public final QtApiConfiguration config = new QtApiConfiguration();
    private final String generatedWarning = "/* This code was generated by msoscheme (http://gitorious.org/msoscheme) */";

    void generate(MSO mso) throws IOException {
        FileWriter fout = this.config.createHeader ? new FileWriter(String.valueOf(this.config.outputdir) + File.separator + this.config.basename + ".h") : new FileWriter(String.valueOf(this.config.outputdir) + File.separator + this.config.basename + ".cpp");
        PrintWriter out = new PrintWriter(fout);
        out.println("/* This code was generated by msoscheme (http://gitorious.org/msoscheme) */");
        if (this.config.createHeader) {
            out.println("#ifndef " + this.config.basename.toUpperCase() + "_H");
            out.println("#define " + this.config.basename.toUpperCase() + "_H");
        }
        out.println("#include \"leinput.h\"");
        out.println("namespace " + this.config.namespace + "{");
        for (Struct s : mso.structs) {
            out.println("class " + s.name + ";");
        }
        for (Struct s : mso.structs) {
            this.printStructureClassDeclaration(out, s);
        }
        if (this.config.createHeader) {
            out.println("} // close namespace");
            out.println("#endif");
            out.close();
            fout = new FileWriter(String.valueOf(this.config.outputdir) + File.separator + this.config.basename + ".cpp");
            out = new PrintWriter(fout);
            out.println("/* This code was generated by msoscheme (http://gitorious.org/msoscheme) */");
            out.println("#include \"" + this.config.basename + ".h\"");
        }
        for (Struct s : mso.structs) {
            this.printStructureDefinition(out, s);
        }
        if (!this.config.createHeader) {
            out.println("}");
        }
        out.close();
        fout.close();
    }

    private void printStructureClassDeclaration(PrintWriter out, Struct s) {
        out.println("class " + s.name + " {");
        out.println("public:");
        out.println("    const char* _data;");
        if (s.size == -1) {
            out.println("    quint32 _size;");
            out.println("    " + s.name + "() :_data(0), _size(0) {}");
            out.println("    explicit " + s.name + "(const char* data, const quint32 maxsize);");
        } else {
            out.println("    static const quint32 _size;");
            out.println("    " + s.name + "() :_data(0) {}");
            out.println("    " + s.name + "(const char* data, quint32/*ignored*/ = 0);// " + s.size / 8 + " bytes");
        }
        boolean hasData = false;
        for (Member m : s.members) {
            hasData = hasData || m.name.equals("data");
            this.printMemberDeclaration(out, m, s.name);
        }
        for (Member m : s.members) {
            if (!m.isSimple || m.condition == null) continue;
            out.println("    bool _has_" + m.name + ";");
        }
        out.println("    inline operator const void * () const { return _data; }");
        out.println("    inline const " + s.name + "* operator->() const { return this; }");
        out.println("    inline const " + s.name + "& operator*() const { return *this; }");
        if (!hasData) {
            out.println("    inline const " + s.name + "* data() const { return this; }");
        }
        out.println("};");
    }

    private String definitionPrefix() {
        return this.config.namespace == null || this.config.namespace.length() == 0 ? "" : String.valueOf(this.config.namespace) + "::";
    }

    private void printStructureDefinition(PrintWriter out, Struct s) {
        String c = String.valueOf(this.definitionPrefix()) + s.name + "::";
        if (s.size == -1) {
            out.println(String.valueOf(c) + s.name + "(const char* _d, quint32 _maxsize) :_data(0), _size(0)");
            out.println("{");
        } else {
            out.println("const quint32 " + c + "_size = " + s.size / 8 + ";");
            out.println(String.valueOf(c) + s.name + "(const char* _d, quint32/*ignored*/) :_data(0)");
            out.println("{");
        }
        out.println("    quint32 _position = 0;");
        out.println("    quint32 _msize;");
        int bytepos = 0;
        for (Member m : s.members) {
            String sp = "    ";
            int msize = this.getSize(m);
            String condition = m.condition;
            if (m.isSimple && condition != null) {
                out.println(String.valueOf(sp) + "_has_" + m.name + " = " + condition + ";");
                condition = "_has_" + m.name;
            }
            if (condition != null) {
                out.println(String.valueOf(sp) + "if (" + condition + ") {");
                sp = "        ";
            }
            if (msize != -1 && s.size == -1) {
                out.print(String.valueOf(sp) + "if (_position + " + msize);
                if (m.isOptional) {
                    sp = String.valueOf(sp) + "    ";
                    out.println(" <= _maxsize) {");
                } else {
                    out.println(" > _maxsize) return;");
                }
            }
            bytepos = this.printMemberParser(out, sp, s, m, bytepos);
            this.printLimitationCheck(out, sp, m.name, m);
            out.println(String.valueOf(sp) + "_position += _msize;");
            while (sp.length() > 4) {
                sp = sp.substring(sp.length() - 4);
                out.println(String.valueOf(sp) + "}");
            }
        }
        if (s.size == -1) {
            out.println("    _size = _position;");
        }
        out.println("    _data = _d;");
        out.println("}");
        for (Member m : s.members) {
            if (m.isArray && m.isStruct || !m.isChoice) continue;
            this.printChoiceAccessor(out, s, m);
        }
    }

    private int printMemberParser(PrintWriter out, String sp, Struct s, Member m, int bytepos) {
        if (m.isArray) {
            if (m.isSimple) {
                this.printSimpleArrayMemberParser(out, sp, s, m);
            } else {
                this.printStructArrayMemberParser(out, sp, s, m);
            }
            if (m.isChoice) {
                throw new Error("There should be no choice in an array.");
            }
        } else {
            if (m.isSimple) {
                return this.printSimpleMemberParser(out, sp, s, m, bytepos);
            }
            if (m.isStruct) {
                this.printStructMemberParser(out, sp, s, m);
            } else if (m.isChoice) {
                this.printChoiceMemberParser(out, sp, s, m);
            }
        }
        return 0;
    }

    private int printSimpleMemberParser(PrintWriter out, String sp, Struct s, Member m, int bytepos) {
        out.println(String.valueOf(sp) + m.name + " = read" + m.type().name + (bytepos > 0 ? "_" + String.valueOf(bytepos) : "") + "(_d + _position);");
        int size = m.type().size / 8;
        if (bytepos != 0 && (bytepos + m.type().size) % 8 == 0) {
            ++size;
        }
        bytepos = (bytepos + m.type().size) % 8;
        out.println(String.valueOf(sp) + "_msize = " + size + ";");
        return bytepos;
    }

    private int getSize(Member m) {
        int size = -1;
        if (m.count != null && m.isArray && m.type().size != -1) {
            try {
                size = m.type().size * Integer.parseInt(m.count) / 8;
            }
            catch (NumberFormatException e) {
                size = -1;
            }
        } else if (m.size != null) {
            try {
                size = Integer.parseInt(m.size);
            }
            catch (NumberFormatException e) {
                size = -1;
            }
        } else if (!m.isArray) {
            return m.type().size / 8;
        }
        return size;
    }

    private void printSimpleArrayMemberParser(PrintWriter out, String sp, Struct s, Member m) {
        if (m.type().size % 8 != 0) {
            throw new Error("only arrays of types with a size of a multiple of 8 bits are allowed.");
        }
        int size = this.getSize(m);
        String count = String.valueOf(size * 8 / m.type().size);
        if (size == -1) {
            count = m.count != null ? m.count : "(" + m.size + ")/" + m.type().size / 8;
        } else if (size % (m.type().size / 8) != 0) {
            throw new Error("array size must be a multiple of the size of the type for " + m.type().name + " and size " + size);
        }
        String type = this.getTypeName(m.type());
        if ("quint8".equals(type)) {
            type = "char";
        }
        out.println(String.valueOf(sp) + m.name + " = MSOCastArray<" + type + ">((const " + type + "*)(_d + _position), " + count + ");");
        out.println(String.valueOf(sp) + "_msize = (" + count + ")*" + m.type().size / 8 + ";");
    }

    private void printStructArrayMemberParser(PrintWriter out, String sp, Struct s, Member m) {
        if (m.count != null) {
            String size = "_maxsize - _position, ";
            if (m.type().size != -1) {
                size = String.valueOf(m.type().size / 8) + " * " + m.count + ", ";
            }
            out.println(String.valueOf(sp) + m.name + " = MSOArray<" + m.type().name + ">(_d + _position, " + size + m.count + ");");
            out.println(String.valueOf(sp) + "if (" + m.name + "._count != " + m.count + ") return;");
        } else if (m.size != null) {
            out.println(String.valueOf(sp) + "if (_maxsize - _position < " + m.size + ") return;");
            out.println(String.valueOf(sp) + m.name + " = MSOArray<" + m.type().name + ">(_d + _position, " + m.size + ");");
            out.println(String.valueOf(sp) + "if (" + m.name + "._size != " + m.size + ") return;");
        } else {
            out.println(String.valueOf(sp) + m.name + " = MSOArray<" + m.type().name + ">(_d + _position, _maxsize - _position);");
            out.println(String.valueOf(sp) + "if (" + m.name + "._data == 0) return;");
        }
        out.println(String.valueOf(sp) + "    _msize = " + m.name + "._size;");
    }

    private void printStructMemberParser(PrintWriter out, String sp, Struct s, Member m) {
        if (m.type().size == -1) {
            out.println(String.valueOf(sp) + m.name + " = " + m.type().name + "(_d + _position, _maxsize - _position);");
        } else {
            out.println(String.valueOf(sp) + m.name + " = " + m.type().name + "(_d + _position);");
        }
        if (m.isOptional) {
            out.println(String.valueOf(sp) + "_msize = (" + m.name + "._data) ?" + m.name + "._size :0;");
        } else {
            out.println(String.valueOf(sp) + "if (" + m.name + "._data == 0) return;");
            out.println(String.valueOf(sp) + "_msize = " + m.name + "._size;");
        }
    }

    private void printChoiceMemberParser(PrintWriter out, String sp, Struct s, Member m) {
        Choice c = (Choice)m.type();
        boolean first = true;
        String sp2 = sp;
        for (Option o : c.options) {
            Struct t = o.type;
            if (!first) {
                out.println(String.valueOf(sp) + "if (_msize == 0) {");
            }
            String name = String.valueOf(m.name) + "._" + t.name;
            if (t.size == -1) {
                out.println(String.valueOf(sp2) + name + " = " + t.name + "(_d + _position, _maxsize - _position);");
                out.println(String.valueOf(sp2) + "_msize = " + name + "._size;");
            } else {
                out.println(String.valueOf(sp2) + name + " = " + t.name + "(_d + _position);");
                out.println(String.valueOf(sp2) + "_msize = (" + name + "._data) ?" + t.name + "::_size : 0;");
            }
            if (!first) {
                out.println(String.valueOf(sp) + "}");
            } else {
                sp2 = String.valueOf(sp) + "    ";
            }
            first = false;
        }
        if (!m.isOptional) {
            out.println(String.valueOf(sp) + "if (_msize == 0) return;");
        }
    }

    private String getTypeName(TypeRegistry.Type t) {
        TypeRegistry r = t.registry;
        if (t instanceof Choice) {
            return t.name;
        }
        if (t == r.bit) {
            return "bool";
        }
        if (t == r.uint2 || t == r.uint3 || t == r.uint4 || t == r.uint5 || t == r.uint6 || t == r.uint7 || t == r.uint8) {
            return "quint8";
        }
        if (t == r.uint9 || t == r.uint12 || t == r.uint13 || t == r.uint14 || t == r.uint15 || t == r.uint16) {
            return "quint16";
        }
        if (t == r.uint20 || t == r.uint30 || t == r.uint32) {
            return "quint32";
        }
        if (t == r.int16) {
            return "qint16";
        }
        if (t == r.int32) {
            return "qint32";
        }
        return t.name;
    }

    private void printChoiceAccessor(PrintWriter out, TypeRegistry.Type s, Member m) {
        Choice c = (Choice)m.type();
        out.println("namespace " + this.config.namespace + " {");
        for (Option o : c.options) {
            String t = o.type.name;
            out.println("    template <> const " + t + "* " + s.name + "::C_" + m.name + "::get<" + t + ">() const {");
            out.println("        return &_" + t + ";");
            out.println("    }");
            out.println("    template <> bool " + s.name + "::C_" + m.name + "::is<" + t + ">() const {");
            out.println("        return _" + t + "._data;");
            out.println("    }");
        }
        out.println("}");
    }

    private void printMemberDeclaration(PrintWriter out, Member m, String className) {
        String t = this.getTypeName(m.type());
        if (m.isArray) {
            if (m.isSimple) {
                if ("quint8".equals(t)) {
                    t = "char";
                }
                out.println("    MSOCastArray<" + t + "> " + m.name + ";");
            }
            if (m.isStruct || m.isChoice) {
                if (m.type().size == -1) {
                    out.println("    MSOArray<" + t + "> " + m.name + ";");
                } else {
                    out.println("    MSOArray<" + t + "> " + m.name + ";");
                }
            }
        } else if (m.isChoice) {
            Choice c = (Choice)m.type();
            out.println("    class C_" + m.name + " {");
            out.println("    friend class " + className + ";");
            out.println("    private:");
            for (Option o : c.options) {
                Struct ct = o.type;
                out.println("        " + ct.name + " _" + ct.name + ";");
            }
            out.println("    public:");
            out.println("        template <typename A> const A* get() const;");
            out.println("        template <typename A> bool is() const;");
            out.println("    };");
            out.println("    C_" + m.name + " " + m.name + ";");
        } else {
            out.println("    " + t + " " + m.name + ";");
        }
    }

    private void printLimitationCheck(PrintWriter out, String s, String name, Member m) {
        if (m.type() instanceof Choice) {
            return;
        }
        Limitation[] limitationArray = m.limitations;
        int n = m.limitations.length;
        int n2 = 0;
        while (n2 < n) {
            String condition;
            Limitation l = limitationArray[n2];
            String mname = l.name;
            mname = !"".equals(mname) ? String.valueOf(name) + "." + mname : name;
            if (!m.isStruct) {
                mname = "((" + this.getTypeName(m.type()) + ")" + mname + ")";
            }
            condition = (condition = l.expression) == null ? QtParserGenerator.getCondition(mname, l) : QtParserGenerator.getExpression(mname, condition);
            out.println(String.valueOf(s) + "if (!(" + condition + ")) {");
            out.println(String.valueOf(s) + "     return;");
            out.println(String.valueOf(s) + "}");
            ++n2;
        }
    }

    public class QtApiConfiguration {
        public String namespace;
        public String outputdir;
        public String basename;
        public boolean createHeader;
    }
}

