/*
 * Decompiled with CFR 0.152.
 */
package mso.generator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ParserGeneratorUtils {
    static Collection<String> getDependencies(Element e) {
        TreeSet<String> deps = new TreeSet<String>();
        NodeList l = e.getElementsByTagName("type");
        int i = 0;
        while (i < l.getLength()) {
            Element se = (Element)l.item(i);
            if (!se.hasAttribute("count") && !se.hasAttribute("array")) {
                deps.add(se.getAttribute("type"));
            }
            ++i;
        }
        return deps;
    }

    static List<Element> getOrderedStructureList(Document dom) throws IOException {
        ArrayList<Element> unorderedList = new ArrayList<Element>();
        NodeList l = dom.getElementsByTagName("struct");
        int i = 0;
        while (i < l.getLength()) {
            unorderedList.add((Element)l.item(i));
            ++i;
        }
        ArrayList<String> done = new ArrayList<String>();
        ArrayList<Element> orderedList = new ArrayList<Element>();
        while (unorderedList.size() > 0) {
            int count = unorderedList.size();
            int i2 = 0;
            while (i2 < unorderedList.size()) {
                Element e = (Element)unorderedList.get(i2);
                Collection<String> deps = ParserGeneratorUtils.getDependencies(e);
                deps.removeAll(done);
                if (deps.size() == 0) {
                    orderedList.add(e);
                    done.add(e.getAttribute("name"));
                    unorderedList.remove(e);
                    continue;
                }
                ++i2;
            }
            if (count != unorderedList.size()) continue;
            String msg = "";
            for (Element e : unorderedList) {
                Collection<String> deps = ParserGeneratorUtils.getDependencies(e);
                deps.removeAll(done);
                msg = String.valueOf(msg) + e.getAttribute("name") + ": " + deps + "\n";
            }
            throw new IOException(String.valueOf(msg) + count);
        }
        return orderedList;
    }

    static Map<Integer, String> getRecordTypeNames(Document dom) throws XPathExpressionException {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        XPath xpath = XPathFactory.newInstance().newXPath();
        String expression = "/mso/struct/type[@name='rh']/limitation[@name='recType']";
        NodeList list = (NodeList)xpath.evaluate(expression, dom, XPathConstants.NODESET);
        int i = 0;
        while (i < list.getLength()) {
            Element e = (Element)list.item(i);
            String name = ((Element)e.getParentNode().getParentNode()).getAttribute("name");
            String type = e.getAttribute("value").replace("0x", "");
            String[] stringArray = type.split("\\|");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                int typeNumber = Integer.parseInt(s, 16);
                if (map.containsKey(typeNumber)) {
                    name = String.valueOf((String)map.get(typeNumber)) + "/" + name;
                }
                map.put(typeNumber, name);
                ++n2;
            }
            ++i;
        }
        return map;
    }
}

