/*
 * Decompiled with CFR 0.152.
 */
package mso.generator;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import mso.generator.JavaParserGenerator;
import mso.generator.MSO;
import mso.generator.QtApiGenerator;
import mso.generator.QtParserGenerator;
import org.w3c.dom.Document;

public class ParserGeneratorRunner {
    public static void main(String[] args) throws Exception {
        String xmlfilename = "mso.xml";
        String xsdfilename = "mso.xsd";
        ParserGeneratorRunner pgr = new ParserGeneratorRunner();
        new File("src/mso/javaparser").mkdirs();
        new File("cpp").mkdirs();
        Validator v = pgr.createValidator("mso.xsd");
        v.validate(new StreamSource(pgr.open("mso.xml")));
        Document dom = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(pgr.open("mso.xml"));
        MSO mso = new MSO(dom);
        pgr.generateJavaParser(mso);
        pgr.generateQtParser(mso);
        pgr.generateSimpleQtParser(mso);
        pgr.generateApi(mso);
    }

    void generateJavaParser(MSO mso) throws IOException {
        JavaParserGenerator g = new JavaParserGenerator();
        g.generate(mso, "src", "mso.javaparser", "GeneratedMsoParser");
    }

    void generateQtParser(MSO mso) throws IOException {
        QtParserGenerator g = new QtParserGenerator();
        g.config.namespace = "";
        g.config.basename = "generatedclasses";
        g.config.outputdir = "cpp";
        g.config.createHeader = false;
        g.config.enableIntrospection = true;
        g.config.enableXml = true;
        g.config.enableWriting = true;
        g.config.enableToString = true;
        g.config.enableStyleTextPropAtomFix = false;
        g.generate(mso);
    }

    void generateSimpleQtParser(MSO mso) throws IOException {
        QtParserGenerator g = new QtParserGenerator();
        g.config.namespace = "MSO";
        g.config.basename = "simpleParser";
        g.config.outputdir = "cpp";
        g.config.createHeader = true;
        g.config.enableIntrospection = false;
        g.config.enableXml = false;
        g.config.enableWriting = false;
        g.config.enableToString = false;
        g.config.enableStyleTextPropAtomFix = true;
        g.generate(mso);
    }

    void generateApi(MSO mso) throws IOException {
        QtApiGenerator g = new QtApiGenerator();
        g.config.namespace = "MSO";
        g.config.basename = "api";
        g.config.outputdir = "cpp";
        g.config.createHeader = true;
        g.generate(mso);
    }

    InputStream open(String name) throws Exception {
        File f = new File(name);
        if (f.canRead()) {
            System.out.println("Reading " + f.getAbsolutePath());
            return new FileInputStream(f.getAbsolutePath());
        }
        f = new File("src/" + name);
        if (f.canRead()) {
            System.out.println("Reading " + f.getAbsolutePath());
            return new FileInputStream(f.getAbsolutePath());
        }
        System.out.println("Reading " + name + " from jar file.");
        return this.getClass().getResourceAsStream("/" + name);
    }

    Validator createValidator(String xsdfilename) throws Exception {
        String schemaLang = "http://www.w3.org/2001/XMLSchema";
        SchemaFactory factory = SchemaFactory.newInstance(schemaLang);
        Source[] sources = new Source[]{new StreamSource(this.open(xsdfilename))};
        Schema schema = factory.newSchema(sources);
        return schema.newValidator();
    }
}

