/*
 * Decompiled with CFR 0.152.
 */
package mso.generator;

import mso.generator.Choice;
import mso.generator.Limitation;
import mso.generator.Member;
import mso.generator.Struct;
import mso.generator.TypeRegistry;

class Option {
    Struct type;
    TypeRegistry.Type limitsType;
    Lim lim = new Lim();

    Option(Struct s, TypeRegistry.Type suggestedType) {
        this.type = s;
        this.setLimitations(s, suggestedType);
    }

    Option(Struct s) {
        this.type = s;
        this.setLimitations(s, null);
    }

    private void setLimitations(Choice c) {
        this.lim.lims = new Lim[c.options.size()];
        int i = 0;
        while (i < c.options.size()) {
            this.lim.lims[i] = c.options.get((int)i).lim;
            ++i;
        }
        this.limitsType = c.commonType;
    }

    private void setLimitations(Struct s, TypeRegistry.Type suggestedType) {
        Member m = s.members.get(0);
        if (m.isOptional) {
            throw new Error("choice member may not be optional");
        }
        TypeRegistry.Type t = m.type();
        if (t instanceof Choice) {
            this.setLimitations((Choice)t);
            return;
        }
        if (t == suggestedType) {
            this.lim.limitations = m.limitations;
            this.limitsType = suggestedType;
            return;
        }
        if (m.limitations.length == 0) {
            this.setLimitations((Struct)t, suggestedType);
            return;
        }
        this.lim.limitations = m.limitations;
        this.limitsType = t;
    }

    class Lim {
        Limitation[] limitations;
        Lim[] lims;

        Lim() {
        }

        boolean containsCommonLimitation(Limitation l) {
            if (this.limitations != null) {
                int i = 0;
                while (i < this.limitations.length) {
                    if (this.limitations[i].equals(l)) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }

        void removeLimitation(Limitation l) {
            if (!this.containsCommonLimitation(l)) {
                return;
            }
            if (this.limitations != null) {
                Limitation[] nl = new Limitation[this.limitations.length - 1];
                int pos = 0;
                int i = 0;
                while (i < this.limitations.length) {
                    if (!this.limitations[i].equals(l)) {
                        nl[pos++] = this.limitations[i];
                    }
                    ++i;
                }
                this.limitations = nl;
            }
        }
    }
}

