/*
 * Decompiled with CFR 0.152.
 */
package mso.generator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.CRC32;
import mso.generator.Choice;
import mso.generator.Limitation;
import mso.generator.Struct;
import mso.generator.TypeRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class Member {
    final TypeRegistry registry;
    final String name;
    private final String typeName;
    final String count;
    final String size;
    final String condition;
    final boolean isArray;
    final boolean isOptional;
    final boolean isInteger;
    final boolean isSimple;
    final boolean isStruct;
    final boolean isChoice;
    final Limitation[] limitations;

    Member(TypeRegistry r, Element e) throws IOException {
        this.registry = r;
        this.name = e.getAttribute("name");
        this.condition = e.hasAttribute("condition") ? e.getAttribute("condition") : null;
        this.count = e.hasAttribute("count") ? e.getAttribute("count") : null;
        this.size = e.hasAttribute("size") ? e.getAttribute("size") : null;
        this.isOptional = e.hasAttribute("optional");
        boolean bl = this.isArray = this.count != null || e.hasAttribute("array");
        if (this.isOptional && this.isArray) {
            throw new IOException("Member " + this.name + " is optional and array, which is not allowed.");
        }
        if (e.hasAttribute("type")) {
            this.typeName = e.getAttribute("type");
            this.isInteger = false;
            this.isSimple = false;
            this.isChoice = false;
            this.isStruct = true;
        } else if (e.getNodeName().equals("choice")) {
            NodeList l = e.getElementsByTagName("type");
            String choiceName = "";
            ArrayList<Struct> choices = new ArrayList<Struct>();
            Element msoelement = (Element)e.getParentNode().getParentNode();
            int i = 0;
            while (i < l.getLength()) {
                String type = ((Element)l.item(i)).getAttribute("type");
                Element ce = Member.getStructElement(msoelement, type);
                choiceName = String.valueOf(choiceName) + type;
                TypeRegistry.Type t = this.registry.getType(ce.getAttribute("name"));
                if (t instanceof Struct) {
                    choices.add((Struct)t);
                } else {
                    choices.add(new Struct(this.registry, ce));
                }
                ++i;
            }
            CRC32 crc = new CRC32();
            crc.update(choiceName.getBytes());
            this.typeName = choiceName = "choice" + crc.getValue();
            if (this.registry.getType(this.typeName) == null) {
                new Choice(this.registry, choiceName, choices, this.isOptional);
            }
            this.isInteger = false;
            this.isSimple = false;
            this.isChoice = true;
            this.isStruct = false;
        } else {
            this.typeName = e.getNodeName();
            this.isInteger = this.typeName.startsWith("int") || this.typeName.startsWith("uint");
            this.isSimple = true;
            this.isChoice = false;
            this.isStruct = false;
        }
        ArrayList<Limitation> _limitations = new ArrayList<Limitation>();
        NodeList l = e.getChildNodes();
        int i = 0;
        while (i < l.getLength()) {
            if (l.item(i) instanceof Element) {
                _limitations.add(new Limitation((Element)l.item(i)));
            }
            ++i;
        }
        this.limitations = _limitations.toArray(new Limitation[0]);
    }

    public TypeRegistry.Type type() {
        return this.registry.getType(this.typeName);
    }

    private static Element getStructElement(Element mso, String typename) {
        NodeList l = mso.getElementsByTagName("struct");
        int i = 0;
        while (i < l.getLength()) {
            Element e = (Element)l.item(i);
            if (e.getAttribute("name").equals(typename)) {
                return e;
            }
            ++i;
        }
        return null;
    }
}

