/*
 * Decompiled with CFR 0.152.
 */
package mso.generator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mso.generator.Choice;
import mso.generator.Member;
import mso.generator.ParserGeneratorUtils;
import mso.generator.Stream;
import mso.generator.Struct;
import mso.generator.TypeRegistry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class MSO {
    final List<Struct> structs = new ArrayList<Struct>();
    final List<Choice> choices = new ArrayList<Choice>();
    final List<Stream> streams = new ArrayList<Stream>();

    MSO(Document dom) throws IOException {
        TypeRegistry typeRegistry = new TypeRegistry();
        List<Element> orderedElements = ParserGeneratorUtils.getOrderedStructureList(dom);
        for (Element e : orderedElements) {
            String typeName = e.getAttribute("name");
            TypeRegistry.Type t = typeRegistry.getType(typeName);
            Struct s = null;
            s = t instanceof Struct ? (Struct)t : new Struct(typeRegistry, e);
            this.structs.add(s);
        }
        for (Struct s : this.structs) {
            for (Member m : s.members) {
                if (m.type() != null) continue;
                throw new Error("Member " + m.name + " of structure " + s.name + " has no parsed type.");
            }
        }
        for (TypeRegistry.Type t : typeRegistry.types.values()) {
            if (!(t instanceof Choice)) continue;
            this.choices.add((Choice)t);
        }
        NodeList l = dom.getElementsByTagName("stream");
        int i = 0;
        while (i < l.getLength()) {
            this.streams.add(new Stream((Element)l.item(i)));
            ++i;
        }
    }
}

