/*
 * Decompiled with CFR 0.152.
 */
package mso.generator;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mso.generator.Choice;
import mso.generator.Limitation;
import mso.generator.MSO;
import mso.generator.Member;
import mso.generator.Stream;
import mso.generator.Struct;
import mso.generator.TypeRegistry;

public class JavaParserGenerator {
    void generate(MSO mso, String dir, String packagename, String classname) throws IOException {
        FileWriter fout = new FileWriter(String.valueOf(dir) + "/" + packagename.replace('.', '/') + "/" + classname + ".java");
        PrintWriter out = new PrintWriter(fout);
        out.println("package " + packagename + ";");
        out.println("import java.io.IOException;");
        out.println("public class " + classname + " {");
        out.println("    Object parse(String key, LEInputStream in) throws IOException {");
        boolean first = true;
        for (Stream stream : mso.streams) {
            out.print("        ");
            if (first) {
                first = false;
            } else {
                out.print("} else ");
            }
            out.println("if (\"" + stream.key + "\".equals(key)) {");
            out.println("            return parse" + stream.type + "(in);");
        }
        out.println("        } else {");
        out.println("            return parseTODOS(in);");
        out.println("        }");
        out.println("    }");
        out.println("    void serialize(String key, Object o, LEOutputStream out) throws IOException {");
        first = true;
        for (Stream stream : mso.streams) {
            out.print("        ");
            if (first) {
                first = false;
            } else {
                out.print("} else ");
            }
            out.println("if (\"" + stream.key + "\".equals(key)) {");
            out.println("            write((" + stream.type + ")o, out);");
        }
        out.println("        } else {");
        out.println("            write((TODOS)o, out);");
        out.println("        }");
        out.println("    }");
        for (Struct struct : mso.structs) {
            this.printStructureParser(out, struct);
            this.printStructureWriter(out, struct);
        }
        out.println("}");
        for (Struct struct : mso.structs) {
            this.printStructureClass(out, struct);
        }
        out.close();
        fout.close();
    }

    void printStructureParser(PrintWriter out, Struct s) {
        out.println("    " + s.name + " parse" + s.name + "(LEInputStream in) throws IOException  {");
        out.println("        " + s.name + " _s = new " + s.name + "();");
        if (s.containsKnownLengthArrayMember) {
            out.println("        int _c;");
        }
        boolean variableArray = false;
        for (Member m : s.members) {
            if (!m.isArray || m.count != null || m.size != null) continue;
            variableArray = s.containsUnknownLengthArrayMember;
        }
        if (s.containsOptionalMember || variableArray || s.containsChoice) {
            out.println("        Object _m;");
        }
        if (variableArray) {
            out.println("        boolean _atend;");
        }
        for (Member m : s.members) {
            this.printStructureMemberParser(out, m);
        }
        if (s.name.contains("RecordHeader")) {
            out.println("System.out.println(in.getPosition()+\" \"+_s);");
        }
        out.println("        return _s;");
        out.println("    }");
    }

    void printStructureWriter(PrintWriter out, Struct s) {
        out.println("    void write(" + s.name + " _s, LEOutputStream out) throws IOException  {");
        for (Member m : s.members) {
            this.printStructureMemberWriter(out, m);
        }
        out.println("    }");
    }

    void printStructureMemberWriter(PrintWriter out, Member m) {
        String s = "        ";
        if (m.condition != null) {
            out.println("        if (" + this.getExpression("_s", m.condition) + ") {");
            s = String.valueOf(s) + "    ";
        }
        if (m.isChoice) {
            boolean first = true;
            Choice c = (Choice)m.type();
            String[] stringArray = c.getChoiceNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String t = stringArray[n2];
                out.print(s);
                if (!first) {
                    out.print("} else ");
                }
                first = false;
                out.println("if (_s." + m.name + " instanceof " + t + ") {");
                out.println(String.valueOf(s) + "    write((" + t + ")_s." + m.name + ", out);");
                ++n2;
            }
            out.println(String.valueOf(s) + "}");
        } else if (m.isArray) {
            String t = this.getTypeName(m);
            out.println(String.valueOf(s) + "for (" + t + " _i: _s." + m.name + ") {");
            if (m.isStruct) {
                out.println(String.valueOf(s) + "    write(_i, out);");
            } else {
                out.println(String.valueOf(s) + "    out.write" + m.type().name + "(_i);");
            }
            out.println(String.valueOf(s) + "}");
        } else if (m.isStruct) {
            out.print(s);
            if (m.isOptional) {
                out.print("if (_s." + m.name + " != null) ");
            }
            out.println("write(_s." + m.name + ", out);");
        } else {
            out.println(String.valueOf(s) + "out.write" + m.type().name + "(_s." + m.name + ");");
        }
        if (m.condition != null) {
            out.println("        }");
        }
    }

    String getTypeName(Member m) {
        TypeRegistry.Type t = m.type();
        TypeRegistry r = m.registry;
        if (t instanceof Struct) {
            return m.type().name;
        }
        if (t instanceof Choice) {
            return "Object";
        }
        if (t == r.bit) {
            return "boolean";
        }
        if (t == r.uint2 || t == r.uint3 || t == r.uint4 || t == r.uint5 || t == r.uint6 || t == r.uint7 || t == r.uint8) {
            return "byte";
        }
        if (t == r.uint9 || t == r.uint12 || t == r.uint13 || t == r.uint14 || t == r.uint15 || t == r.int16) {
            return "short";
        }
        if (t == r.uint16 || t == r.uint20 || t == r.uint30 || t == r.uint32 || t == r.int32) {
            return "int";
        }
        return t.name;
    }

    String getMemberDeclaration(Member m) {
        if (m.isArray) {
            if (m.count == null) {
                return "final java.util.List<" + m.type().name + "> " + m.name + " = new java.util.ArrayList<" + m.type().name + ">()";
            }
            return String.valueOf(this.getTypeName(m)) + "[] " + m.name;
        }
        return String.valueOf(this.getTypeName(m)) + " " + m.name;
    }

    void printStructureClass(PrintWriter out, Struct s) {
        out.println("class " + s.name + " {");
        for (Member m : s.members) {
            String d = this.getMemberDeclaration(m);
            out.println("    " + d + ";");
        }
        out.println("    public String toString() {");
        out.println("        String _s = \"" + s.name + ":\";");
        for (Member m : s.members) {
            out.print("        _s = _s + \"" + m.name + ": \" + String.valueOf(" + m.name + ") + \"");
            if (m.isInteger && !m.isArray) {
                out.print("(\" + Integer.toHexString(" + m.name + ").toUpperCase() + \")");
            }
            out.println(", \";");
        }
        out.println("        return _s;");
        out.println("    }");
        out.println("}");
    }

    String prependStructureToExpression(String expression, String structureName) {
        if (expression.length() > 0) {
            Pattern p = Pattern.compile("([^.\\w])([.a-zA-Z])");
            Matcher m = p.matcher(expression);
            expression = m.replaceAll("$1" + structureName + ".$2");
            p = Pattern.compile("^([a-zA-Z])");
            m = p.matcher(expression);
            expression = m.replaceAll(String.valueOf(structureName) + ".$1");
        }
        return expression;
    }

    void printStructureMemberParser(PrintWriter out, Member m) {
        String s = "        ";
        String condition = null;
        if (m.condition != null) {
            condition = this.prependStructureToExpression(m.condition, "_s");
            s = String.valueOf(s) + "    ";
            out.println("        if (" + condition + ") {");
        }
        String count = null;
        if (m.count != null) {
            count = this.prependStructureToExpression(m.count, "_s");
        }
        String parse = m.isStruct ? "parse" + m.type().name + "(in);" : "in.read" + m.type().name + "();";
        if (m.isChoice) {
            this.printChoiceParser(out, s, m);
            return;
        }
        if (m.isArray && m.count == null) {
            if (m.size != null) {
                this.printFixedSizeArrayParser(out, s, m);
            } else {
                this.printVariableArrayParser(out, s, m);
            }
            return;
        }
        if (m.isOptional) {
            this.printOptionalMemberParser(out, s, m);
            return;
        }
        if (count != null) {
            out.println(String.valueOf(s) + "_c = " + count + ";");
        }
        out.print(String.valueOf(s) + "_s." + m.name + " = ");
        if (count != null) {
            if (m.type() == m.registry.uint8) {
                out.println("in.readBytes(_c);");
            } else {
                out.println("new " + this.getTypeName(m) + "[_c];");
                out.println(String.valueOf(s) + "for (int _j=0; _j<_c; ++_j) {");
                out.println(String.valueOf(s) + "    _s." + m.name + "[_j] = " + parse);
                this.printLimitationCheck(out, "            ", "_s." + m.name + "[_j]", m);
                out.println(String.valueOf(s) + "}");
            }
        } else {
            out.println(parse);
            this.printLimitationCheck(out, "        ", "_s." + m.name, m);
        }
        if (condition != null) {
            out.println("        }");
        }
    }

    void printChoiceParser(PrintWriter out, String s, Member m) {
        String closing = "";
        String exception = "_x";
        out.println(String.valueOf(s) + "_m = in.setMark();");
        Choice c = (Choice)m.type();
        String[] choices = c.getChoiceNames();
        int length = m.isOptional ? choices.length : choices.length - 1;
        int i = 0;
        while (i < length) {
            out.println(String.valueOf(s) + "try {");
            out.println(String.valueOf(s) + "    _s." + m.name + " = parse" + choices[i] + "(in);");
            out.println(String.valueOf(s) + "} catch (IOException " + exception + ") {");
            out.println(String.valueOf(s) + "    if (!(" + exception + " instanceof IncorrectValueException) && !(" + exception + " instanceof java.io.EOFException)) throw " + exception + ";");
            out.println(String.valueOf(s) + "    in.rewind(_m);");
            exception = String.valueOf(exception) + "x";
            closing = String.valueOf(closing) + "}";
            ++i;
        }
        if (!m.isOptional) {
            out.println(String.valueOf(s) + "    _s." + m.name + " = parse" + choices[choices.length - 1] + "(in);");
        }
        out.println(String.valueOf(s) + closing + " finally {");
        out.println(String.valueOf(s) + "    in.releaseMark(_m);");
        out.println(String.valueOf(s) + "}");
    }

    void printFixedSizeArrayParser(PrintWriter out, String s, Member m) {
        out.println(String.valueOf(s) + "int _startPos = in.getPosition();");
        out.println(String.valueOf(s) + "while (in.getPosition() - _startPos < " + this.getExpression("_s", m.size) + ") {");
        out.println(String.valueOf(s) + "    " + m.type().name + " _t = parse" + m.type().name + "(in);");
        out.println(String.valueOf(s) + "    _s." + m.name + ".add(_t);");
        out.println(String.valueOf(s) + "}");
    }

    void printVariableArrayParser(PrintWriter out, String s, Member m) {
        out.println(String.valueOf(s) + "_atend = false;");
        out.println(String.valueOf(s) + "while (!_atend) {");
        out.println(String.valueOf(s) + "    _m = in.setMark();");
        out.println(String.valueOf(s) + "    try {");
        out.println(String.valueOf(s) + "        " + m.type().name + " _t = parse" + m.type().name + "(in);");
        out.println(String.valueOf(s) + "        _s." + m.name + ".add(_t);");
        out.println(String.valueOf(s) + "    } catch(IncorrectValueException _e) {");
        out.println(String.valueOf(s) + "        _atend = true;");
        out.println(String.valueOf(s) + "        in.rewind(_m);");
        out.println(String.valueOf(s) + "    } catch(java.io.EOFException _e) {");
        out.println(String.valueOf(s) + "        _atend = true;");
        out.println(String.valueOf(s) + "        in.rewind(_m);");
        out.println(String.valueOf(s) + "    } finally {");
        out.println(String.valueOf(s) + "        in.releaseMark(_m);");
        out.println(String.valueOf(s) + "   }");
        out.println(String.valueOf(s) + "}");
    }

    void printOptionalMemberParser(PrintWriter out, String s, Member m) {
        out.println(String.valueOf(s) + "_m = in.setMark();");
        out.println(String.valueOf(s) + "try {");
        out.println(String.valueOf(s) + "    _s." + m.name + " = parse" + m.type().name + "(in);");
        out.println(String.valueOf(s) + "} catch(IncorrectValueException _e) {");
        out.println(String.valueOf(s) + "    if (in.distanceFromMark(_m) > 16) throw new IOException(_e);//onlyfordebug");
        out.println(String.valueOf(s) + "    in.rewind(_m);");
        out.println(String.valueOf(s) + "} catch(java.io.EOFException _e) {");
        out.println(String.valueOf(s) + "    in.rewind(_m);");
        out.println(String.valueOf(s) + "} finally {");
        out.println(String.valueOf(s) + "    in.releaseMark(_m);");
        out.println(String.valueOf(s) + "}");
    }

    void printLimitationCheck(PrintWriter out, String s, String name, Member m) {
        Limitation[] limitationArray = m.limitations;
        int n = m.limitations.length;
        int n2 = 0;
        while (n2 < n) {
            Limitation l = limitationArray[n2];
            String mname = l.name;
            mname = !"".equals(mname) ? String.valueOf(name) + "." + mname : name;
            String condition = l.expression == null ? this.getCondition(mname, l) : this.getExpression(mname, l.expression);
            out.println(String.valueOf(s) + "if (!(" + condition + ")) {");
            String exceptionType = "IncorrectValueException";
            out.println(String.valueOf(s) + "    throw new " + exceptionType + "(in.getPosition() + \"" + condition + " for value \" + String.valueOf(" + name + ") );");
            out.println(String.valueOf(s) + "}");
            ++n2;
        }
    }

    String getExpression(String structure, String expression) {
        if (Pattern.matches(".*[A-Za-z].*", expression)) {
            return this.prependStructureToExpression(expression, structure);
        }
        return String.valueOf(structure) + expression;
    }

    String getCondition(String name, Limitation l) {
        String value = l.value;
        String cmp = " == ";
        String cmb = " || ";
        if (value.startsWith("!")) {
            value = value.substring(1);
            cmp = " != ";
            cmb = " && ";
        }
        if (value.contains("|")) {
            String[] values = value.split("\\|");
            String c = String.valueOf(name) + cmp + values[0];
            int i = 1;
            while (i < values.length) {
                c = String.valueOf(c) + cmb + name + cmp + values[i];
                ++i;
            }
            return c;
        }
        return String.valueOf(name) + cmp + value;
    }
}

