/*
 * Decompiled with CFR 0.152.
 */
package mso.generator;

import java.util.ArrayList;
import java.util.List;
import mso.generator.Limitation;
import mso.generator.Member;
import mso.generator.Option;
import mso.generator.Struct;
import mso.generator.TypeRegistry;

class Choice
extends TypeRegistry.Type {
    final TypeRegistry.Type commonType;
    final List<Option> options;

    static int getSize(List<Struct> choices) {
        int size = choices.get((int)0).size;
        for (Struct s : choices) {
            if (s.size == size) continue;
            return -1;
        }
        return size;
    }

    Choice(TypeRegistry registry, String name, List<Struct> choices, boolean optional) {
        TypeRegistry typeRegistry = registry;
        typeRegistry.getClass();
        super(typeRegistry, registry, name, Choice.getSize(choices));
        this.options = new ArrayList<Option>();
        TypeRegistry.Type common = null;
        for (Struct s : choices) {
            Option o = new Option(s, common);
            if (common != null && o.limitsType != common && !Choice.compareTypes(common, o.limitsType)) {
                throw new Error("Conflicting common type: " + common.name + " vs " + o.limitsType.name);
            }
            common = o.limitsType;
            this.options.add(o);
        }
        for (Option o : this.options) {
            if (Choice.compareTypes(common, o.limitsType)) continue;
            String types = "";
            for (Option op : this.options) {
                types = String.valueOf(types) + " " + op.type.name;
            }
            System.err.println("The choice " + name + " has no common options for types" + types);
            common = null;
            break;
        }
        if (common == null) {
            this.commonType = null;
            return;
        }
        int i = 0;
        while (i < this.options.size()) {
            int last = optional ? this.options.size() : this.options.size() - 1;
            int j = i + 1;
            while (j < last) {
                Option a = this.options.get(i);
                Option b = this.options.get(j);
                if (!Choice.noOverlap(a.lim, b.lim)) {
                    System.err.println("Options " + a.type.name + " and " + b.type.name + " have overlap.");
                    common = null;
                }
                ++j;
            }
            ++i;
        }
        this.commonType = common;
        if (!optional && common != null) {
            this.removeNonDistinctiveLimitations();
        }
    }

    private static boolean noOverlap(Option.Lim a, Option.Lim b) {
        if (a.limitations == null && a.lims == null) {
            return false;
        }
        if (a.limitations != null && !Choice.noOverlap(a.limitations, b)) {
            return false;
        }
        if (a.lims != null) {
            Option.Lim[] limArray = a.lims;
            int n = a.lims.length;
            int n2 = 0;
            while (n2 < n) {
                Option.Lim sa = limArray[n2];
                if (!Choice.noOverlap(sa, b)) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    private static boolean noOverlap(Limitation[] a, Option.Lim b) {
        if (b.limitations == null && b.lims == null) {
            return false;
        }
        if (b.limitations != null && !Choice.noOverlap(a, b.limitations)) {
            return false;
        }
        if (b.lims != null) {
            Option.Lim[] limArray = b.lims;
            int n = b.lims.length;
            int n2 = 0;
            while (n2 < n) {
                Option.Lim sb = limArray[n2];
                if (!Choice.noOverlap(a, sb)) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    private static boolean noOverlap(Limitation[] a, Limitation[] b) {
        int i = 0;
        while (i < a.length) {
            int j = 0;
            while (j < b.length) {
                if (a[i].name.equals(b[j].name) && Choice.noOverlap(a[i].value, b[j].value)) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private static boolean noOverlap(String a, String b) {
        if (a == null || b == null) {
            return false;
        }
        String[] avalues = a.split("\\|");
        String[] bvalues = b.split("\\|");
        int i = 0;
        while (i < avalues.length) {
            int j = 0;
            while (j < bvalues.length) {
                if (avalues[i].equals(bvalues[j])) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    private static boolean compareMembers(Member a, Member b) {
        if (a.isArray != b.isArray) {
            return false;
        }
        if (a.type() != b.type()) {
            return false;
        }
        return a.isOptional == b.isOptional;
    }

    private static boolean structsWithSameMembers(TypeRegistry.Type a, TypeRegistry.Type b) {
        if (a instanceof Struct && b instanceof Struct) {
            Struct as = (Struct)a;
            Struct bs = (Struct)b;
            if (as.members.size() != bs.members.size()) {
                return false;
            }
            int i = 0;
            while (i < as.members.size()) {
                if (!Choice.compareMembers(as.members.get(i), bs.members.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private static boolean compareTypes(TypeRegistry.Type a, TypeRegistry.Type b) {
        return a == b || Choice.structsWithSameMembers(a, b);
    }

    public String[] getChoiceNames() {
        String[] n = new String[this.options.size()];
        int i = 0;
        while (i < this.options.size()) {
            n[i] = this.options.get((int)i).type.name;
            ++i;
        }
        return n;
    }

    void removeNonDistinctiveLimitations() {
        Option.Lim a = this.options.get((int)0).lim;
        if (a.limitations != null) {
            int i = 0;
            while (i < a.limitations.length) {
                Limitation l = a.limitations[i];
                boolean common = true;
                int j = 1;
                while (j < this.options.size()) {
                    common = common && this.options.get((int)j).lim.containsCommonLimitation(l);
                    ++j;
                }
                if (common) {
                    j = 0;
                    while (j < this.options.size()) {
                        this.options.get((int)j).lim.removeLimitation(l);
                        ++j;
                    }
                    i = 0;
                }
                ++i;
            }
        }
    }
}

