(function(){
    "use strict";
    var ρσ_iterator_symbol = (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") ? Symbol.iterator : "iterator-Symbol-5d0927e5554349048cf0e3762a228256";
    var ρσ_kwargs_symbol = (typeof Symbol === "function") ? Symbol("kwargs-object") : "kwargs-object-Symbol-5d0927e5554349048cf0e3762a228256";
    var ρσ_cond_temp, ρσ_expr_temp, ρσ_last_exception;
    var ρσ_object_counter = 0;
var ρσ_len;
function ρσ_bool(val) {
    return !!val;
};
if (!ρσ_bool.__argnames__) Object.defineProperties(ρσ_bool, {
    __argnames__ : {value: ["val"]},
    __module__ : {value: "__main__"}
});

function ρσ_print() {
    var parts;
    if (typeof console === "object") {
        parts = [];
        for (var i = 0; i < arguments.length; i++) {
            parts.push(ρσ_str(arguments[(typeof i === "number" && i < 0) ? arguments.length + i : i]));
        }
        console.log(parts.join(" "));
    }
};
if (!ρσ_print.__module__) Object.defineProperties(ρσ_print, {
    __module__ : {value: "__main__"}
});

function ρσ_int(val, base) {
    var ans;
    if (typeof val === "number") {
        ans = val | 0;
    } else {
        ans = parseInt(val, base || 10);
    }
    if (isNaN(ans)) {
        throw new ValueError("Invalid literal for int with base " + (base || 10) + ": " + val);
    }
    return ans;
};
if (!ρσ_int.__argnames__) Object.defineProperties(ρσ_int, {
    __argnames__ : {value: ["val", "base"]},
    __module__ : {value: "__main__"}
});

function ρσ_float(val) {
    var ans;
    if (typeof val === "number") {
        ans = val;
    } else {
        ans = parseFloat(val);
    }
    if (isNaN(ans)) {
        throw new ValueError("Could not convert string to float: " + arguments[0]);
    }
    return ans;
};
if (!ρσ_float.__argnames__) Object.defineProperties(ρσ_float, {
    __argnames__ : {value: ["val"]},
    __module__ : {value: "__main__"}
});

function ρσ_arraylike_creator() {
    var names;
    names = "Int8Array Uint8Array Uint8ClampedArray Int16Array Uint16Array Int32Array Uint32Array Float32Array Float64Array".split(" ");
    if (typeof HTMLCollection === "function") {
        names = names.concat("HTMLCollection NodeList NamedNodeMap TouchList".split(" "));
    }
    return (function() {
        var ρσ_anonfunc = function (x) {
            if (Array.isArray(x) || typeof x === "string" || names.indexOf(Object.prototype.toString.call(x).slice(8, -1)) > -1) {
                return true;
            }
            return false;
        };
        if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
            __argnames__ : {value: ["x"]},
            __module__ : {value: "__main__"}
        });
        return ρσ_anonfunc;
    })();
};
if (!ρσ_arraylike_creator.__module__) Object.defineProperties(ρσ_arraylike_creator, {
    __module__ : {value: "__main__"}
});

function options_object(f) {
    return (function() {
        var ρσ_anonfunc = function () {
            if (typeof arguments[arguments.length - 1] === "object") {
                arguments[ρσ_bound_index(arguments.length - 1, arguments)][ρσ_kwargs_symbol] = true;
            }
            return f.apply(this, arguments);
        };
        if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
            __module__ : {value: "__main__"}
        });
        return ρσ_anonfunc;
    })();
};
if (!options_object.__argnames__) Object.defineProperties(options_object, {
    __argnames__ : {value: ["f"]},
    __module__ : {value: "__main__"}
});

function ρσ_id(x) {
    return x.ρσ_object_id;
};
if (!ρσ_id.__argnames__) Object.defineProperties(ρσ_id, {
    __argnames__ : {value: ["x"]},
    __module__ : {value: "__main__"}
});

function ρσ_dir(item) {
    var arr;
    arr = ρσ_list_decorate([]);
    for (var i in item) {
        arr.push(i);
    }
    return arr;
};
if (!ρσ_dir.__argnames__) Object.defineProperties(ρσ_dir, {
    __argnames__ : {value: ["item"]},
    __module__ : {value: "__main__"}
});

function ρσ_ord(x) {
    var ans, second;
    ans = x.charCodeAt(0);
    if (55296 <= ans && ans <= 56319) {
        second = x.charCodeAt(1);
        if (56320 <= second && second <= 57343) {
            return (ans - 55296) * 1024 + second - 56320 + 65536;
        }
        throw new TypeError("string is missing the low surrogate char");
    }
    return ans;
};
if (!ρσ_ord.__argnames__) Object.defineProperties(ρσ_ord, {
    __argnames__ : {value: ["x"]},
    __module__ : {value: "__main__"}
});

function ρσ_chr(code) {
    if (code <= 65535) {
        return String.fromCharCode(code);
    }
    code -= 65536;
    return String.fromCharCode(55296 + (code >> 10), 56320 + (code & 1023));
};
if (!ρσ_chr.__argnames__) Object.defineProperties(ρσ_chr, {
    __argnames__ : {value: ["code"]},
    __module__ : {value: "__main__"}
});

function ρσ_callable(x) {
    return typeof x === "function";
};
if (!ρσ_callable.__argnames__) Object.defineProperties(ρσ_callable, {
    __argnames__ : {value: ["x"]},
    __module__ : {value: "__main__"}
});

function ρσ_bin(x) {
    var ans;
    if (typeof x !== "number" || x % 1 !== 0) {
        throw new TypeError("integer required");
    }
    ans = x.toString(2);
    if (ans[0] === "-") {
        ans = "-" + "0b" + ans.slice(1);
    } else {
        ans = "0b" + ans;
    }
    return ans;
};
if (!ρσ_bin.__argnames__) Object.defineProperties(ρσ_bin, {
    __argnames__ : {value: ["x"]},
    __module__ : {value: "__main__"}
});

function ρσ_hex(x) {
    var ans;
    if (typeof x !== "number" || x % 1 !== 0) {
        throw new TypeError("integer required");
    }
    ans = x.toString(16);
    if (ans[0] === "-") {
        ans = "-" + "0x" + ans.slice(1);
    } else {
        ans = "0x" + ans;
    }
    return ans;
};
if (!ρσ_hex.__argnames__) Object.defineProperties(ρσ_hex, {
    __argnames__ : {value: ["x"]},
    __module__ : {value: "__main__"}
});

function ρσ_enumerate(iterable) {
    var ans, iterator;
    ans = {"_i":-1};
    ans[ρσ_iterator_symbol] = (function() {
        var ρσ_anonfunc = function () {
            return this;
        };
        if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
            __module__ : {value: "__main__"}
        });
        return ρσ_anonfunc;
    })();
    if (ρσ_arraylike(iterable)) {
        ans["next"] = (function() {
            var ρσ_anonfunc = function () {
                this._i += 1;
                if (this._i < iterable.length) {
                    return {'done':false, 'value':[this._i, iterable[this._i]]};
                }
                return {'done':true};
            };
            if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
                __module__ : {value: "__main__"}
            });
            return ρσ_anonfunc;
        })();
        return ans;
    }
    if (typeof iterable[ρσ_iterator_symbol] === "function") {
        iterator = (typeof Map === "function" && iterable instanceof Map) ? iterable.keys() : iterable[ρσ_iterator_symbol]();
        ans["_iterator"] = iterator;
        ans["next"] = (function() {
            var ρσ_anonfunc = function () {
                var r;
                r = this._iterator.next();
                if (r.done) {
                    return {'done':true};
                }
                this._i += 1;
                return {'done':false, 'value':[this._i, r.value]};
            };
            if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
                __module__ : {value: "__main__"}
            });
            return ρσ_anonfunc;
        })();
        return ans;
    }
    return ρσ_enumerate(Object.keys(iterable));
};
if (!ρσ_enumerate.__argnames__) Object.defineProperties(ρσ_enumerate, {
    __argnames__ : {value: ["iterable"]},
    __module__ : {value: "__main__"}
});

function ρσ_reversed(iterable) {
    var ans;
    if (ρσ_arraylike(iterable)) {
        ans = {"_i": iterable.length};
        ans["next"] = (function() {
            var ρσ_anonfunc = function () {
                this._i -= 1;
                if (this._i > -1) {
                    return {'done':false, 'value':iterable[this._i]};
                }
                return {'done':true};
            };
            if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
                __module__ : {value: "__main__"}
            });
            return ρσ_anonfunc;
        })();
        ans[ρσ_iterator_symbol] = (function() {
            var ρσ_anonfunc = function () {
                return this;
            };
            if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
                __module__ : {value: "__main__"}
            });
            return ρσ_anonfunc;
        })();
        return ans;
    }
    throw new TypeError("reversed() can only be called on arrays or strings");
};
if (!ρσ_reversed.__argnames__) Object.defineProperties(ρσ_reversed, {
    __argnames__ : {value: ["iterable"]},
    __module__ : {value: "__main__"}
});

function ρσ_iter(iterable) {
    var ans;
    if (typeof iterable[ρσ_iterator_symbol] === "function") {
        return (typeof Map === "function" && iterable instanceof Map) ? iterable.keys() : iterable[ρσ_iterator_symbol]();
    }
    if (ρσ_arraylike(iterable)) {
        ans = {"_i":-1};
        ans[ρσ_iterator_symbol] = (function() {
            var ρσ_anonfunc = function () {
                return this;
            };
            if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
                __module__ : {value: "__main__"}
            });
            return ρσ_anonfunc;
        })();
        ans["next"] = (function() {
            var ρσ_anonfunc = function () {
                this._i += 1;
                if (this._i < iterable.length) {
                    return {'done':false, 'value':iterable[this._i]};
                }
                return {'done':true};
            };
            if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
                __module__ : {value: "__main__"}
            });
            return ρσ_anonfunc;
        })();
        return ans;
    }
    return ρσ_iter(Object.keys(iterable));
};
if (!ρσ_iter.__argnames__) Object.defineProperties(ρσ_iter, {
    __argnames__ : {value: ["iterable"]},
    __module__ : {value: "__main__"}
});

function ρσ_range_next(step, length) {
    var ρσ_unpack;
    this._i += step;
    this._idx += 1;
    if (this._idx >= length) {
        ρσ_unpack = [this.__i, -1];
        this._i = ρσ_unpack[0];
        this._idx = ρσ_unpack[1];
        return {'done':true};
    }
    return {'done':false, 'value':this._i};
};
if (!ρσ_range_next.__argnames__) Object.defineProperties(ρσ_range_next, {
    __argnames__ : {value: ["step", "length"]},
    __module__ : {value: "__main__"}
});

function ρσ_range(start, stop, step) {
    var length, ans;
    if (arguments.length <= 1) {
        stop = start || 0;
        start = 0;
    }
    step = arguments[2] || 1;
    length = Math.max(Math.ceil((stop - start) / step), 0);
    ans = {start:start, step:step, stop:stop};
    ans[ρσ_iterator_symbol] = (function() {
        var ρσ_anonfunc = function () {
            var it;
            it = {"_i": start - step, "_idx": -1};
            it.next = ρσ_range_next.bind(it, step, length);
            it[ρσ_iterator_symbol] = (function() {
                var ρσ_anonfunc = function () {
                    return this;
                };
                if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
                    __module__ : {value: "__main__"}
                });
                return ρσ_anonfunc;
            })();
            return it;
        };
        if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
            __module__ : {value: "__main__"}
        });
        return ρσ_anonfunc;
    })();
    ans.count = (function() {
        var ρσ_anonfunc = function (val) {
            if (!this._cached) {
                this._cached = list(this);
            }
            return this._cached.count(val);
        };
        if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
            __argnames__ : {value: ["val"]},
            __module__ : {value: "__main__"}
        });
        return ρσ_anonfunc;
    })();
    ans.index = (function() {
        var ρσ_anonfunc = function (val) {
            if (!this._cached) {
                this._cached = list(this);
            }
            return this._cached.index(val);
        };
        if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
            __argnames__ : {value: ["val"]},
            __module__ : {value: "__main__"}
        });
        return ρσ_anonfunc;
    })();
    ans.__len__ = (function() {
        var ρσ_anonfunc = function () {
            return length;
        };
        if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
            __module__ : {value: "__main__"}
        });
        return ρσ_anonfunc;
    })();
    ans.__repr__ = (function() {
        var ρσ_anonfunc = function () {
            return "range(" + ρσ_str.format("{}", start) + ", " + ρσ_str.format("{}", stop) + ", " + ρσ_str.format("{}", step) + ")";
        };
        if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
            __module__ : {value: "__main__"}
        });
        return ρσ_anonfunc;
    })();
    ans.__str__ = ans.toString = ans.__repr__;
    if (typeof Proxy === "function") {
        ans = new Proxy(ans, (function(){
            var ρσ_d = {};
            ρσ_d["get"] = (function() {
                var ρσ_anonfunc = function (obj, prop) {
                    var iprop;
                    if (typeof prop === "string") {
                        iprop = parseInt(prop);
                        if (!isNaN(iprop)) {
                            prop = iprop;
                        }
                    }
                    if (typeof prop === "number") {
                        if (!obj._cached) {
                            obj._cached = list(obj);
                        }
                        return (ρσ_expr_temp = obj._cached)[(typeof prop === "number" && prop < 0) ? ρσ_expr_temp.length + prop : prop];
                    }
                    return obj[(typeof prop === "number" && prop < 0) ? obj.length + prop : prop];
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["obj", "prop"]},
                    __module__ : {value: "__main__"}
                });
                return ρσ_anonfunc;
            })();
            return ρσ_d;
        }).call(this));
    }
    return ans;
};
if (!ρσ_range.__argnames__) Object.defineProperties(ρσ_range, {
    __argnames__ : {value: ["start", "stop", "step"]},
    __module__ : {value: "__main__"}
});

function ρσ_getattr(obj, name, defval) {
    var ret;
    try {
        ret = obj[(typeof name === "number" && name < 0) ? obj.length + name : name];
    } catch (ρσ_Exception) {
        ρσ_last_exception = ρσ_Exception;
        if (ρσ_Exception instanceof TypeError) {
            if (defval === undefined) {
                throw new AttributeError("The attribute " + name + " is not present");
            }
            return defval;
        } else {
            throw ρσ_Exception;
        }
    }
    if (ret === undefined && !(name in obj)) {
        if (defval === undefined) {
            throw new AttributeError("The attribute " + name + " is not present");
        }
        ret = defval;
    }
    return ret;
};
if (!ρσ_getattr.__argnames__) Object.defineProperties(ρσ_getattr, {
    __argnames__ : {value: ["obj", "name", "defval"]},
    __module__ : {value: "__main__"}
});

function ρσ_setattr(obj, name, value) {
    obj[(typeof name === "number" && name < 0) ? obj.length + name : name] = value;
};
if (!ρσ_setattr.__argnames__) Object.defineProperties(ρσ_setattr, {
    __argnames__ : {value: ["obj", "name", "value"]},
    __module__ : {value: "__main__"}
});

function ρσ_hasattr(obj, name) {
    return name in obj;
};
if (!ρσ_hasattr.__argnames__) Object.defineProperties(ρσ_hasattr, {
    __argnames__ : {value: ["obj", "name"]},
    __module__ : {value: "__main__"}
});

ρσ_len = (function() {
    var ρσ_anonfunc = function () {
        function len(obj) {
            if (ρσ_arraylike(obj)) {
                return obj.length;
            }
            if (typeof obj.__len__ === "function") {
                return obj.__len__();
            }
            if (obj instanceof Set || obj instanceof Map) {
                return obj.size;
            }
            return Object.keys(obj).length;
        };
        if (!len.__argnames__) Object.defineProperties(len, {
            __argnames__ : {value: ["obj"]},
            __module__ : {value: "__main__"}
        });

        function len5(obj) {
            if (ρσ_arraylike(obj)) {
                return obj.length;
            }
            if (typeof obj.__len__ === "function") {
                return obj.__len__();
            }
            return Object.keys(obj).length;
        };
        if (!len5.__argnames__) Object.defineProperties(len5, {
            __argnames__ : {value: ["obj"]},
            __module__ : {value: "__main__"}
        });

        return (typeof Set === "function" && typeof Map === "function") ? len : len5;
    };
    if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})()();
function ρσ_get_module(name) {
    return ρσ_modules[(typeof name === "number" && name < 0) ? ρσ_modules.length + name : name];
};
if (!ρσ_get_module.__argnames__) Object.defineProperties(ρσ_get_module, {
    __argnames__ : {value: ["name"]},
    __module__ : {value: "__main__"}
});

function ρσ_pow(x, y, z) {
    var ans;
    ans = Math.pow(x, y);
    if (z !== undefined) {
        ans %= z;
    }
    return ans;
};
if (!ρσ_pow.__argnames__) Object.defineProperties(ρσ_pow, {
    __argnames__ : {value: ["x", "y", "z"]},
    __module__ : {value: "__main__"}
});

function ρσ_type(x) {
    return x.constructor;
};
if (!ρσ_type.__argnames__) Object.defineProperties(ρσ_type, {
    __argnames__ : {value: ["x"]},
    __module__ : {value: "__main__"}
});

function ρσ_divmod(x, y) {
    var d;
    if (y === 0) {
        throw new ZeroDivisionError("integer division or modulo by zero");
    }
    d = Math.floor(x / y);
    return [d, x - d * y];
};
if (!ρσ_divmod.__argnames__) Object.defineProperties(ρσ_divmod, {
    __argnames__ : {value: ["x", "y"]},
    __module__ : {value: "__main__"}
});

function ρσ_max() {
    var kwargs = arguments[arguments.length-1];
    if (kwargs === null || typeof kwargs !== "object" || kwargs [ρσ_kwargs_symbol] !== true) kwargs = {};
    var args = Array.prototype.slice.call(arguments, 0);
    if (kwargs !== null && typeof kwargs === "object" && kwargs [ρσ_kwargs_symbol] === true) args.pop();
    var args, x;
    if (args.length === 0) {
        if (kwargs.defval !== undefined) {
            return kwargs.defval;
        }
        throw new TypeError("expected at least one argument");
    }
    if (args.length === 1) {
        args = args[0];
    }
    if (kwargs.key) {
        args = (function() {
            var ρσ_Iter = ρσ_Iterable(args), ρσ_Result = [], x;
            for (var ρσ_Index = 0; ρσ_Index < ρσ_Iter.length; ρσ_Index++) {
                x = ρσ_Iter[ρσ_Index];
                ρσ_Result.push(kwargs.key(x));
            }
            ρσ_Result = ρσ_list_constructor(ρσ_Result);
            return ρσ_Result;
        })();
    }
    if (!Array.isArray(args)) {
        args = list(args);
    }
    if (args.length) {
        return this.apply(null, args);
    }
    if (kwargs.defval !== undefined) {
        return kwargs.defval;
    }
    throw new TypeError("expected at least one argument");
};
if (!ρσ_max.__handles_kwarg_interpolation__) Object.defineProperties(ρσ_max, {
    __handles_kwarg_interpolation__ : {value: true},
    __module__ : {value: "__main__"}
});

var abs = Math.abs, max = ρσ_max.bind(Math.max), min = ρσ_max.bind(Math.min), bool = ρσ_bool, type = ρσ_type;
var float = ρσ_float, int = ρσ_int, arraylike = ρσ_arraylike_creator(), ρσ_arraylike = arraylike;
var print = ρσ_print, id = ρσ_id, get_module = ρσ_get_module, pow = ρσ_pow, divmod = ρσ_divmod;
var dir = ρσ_dir, ord = ρσ_ord, chr = ρσ_chr, bin = ρσ_bin, hex = ρσ_hex, callable = ρσ_callable;
var enumerate = ρσ_enumerate, iter = ρσ_iter, reversed = ρσ_reversed, len = ρσ_len;
var range = ρσ_range, getattr = ρσ_getattr, setattr = ρσ_setattr, hasattr = ρσ_hasattr;function ρσ_equals(a, b) {
    var ρσ_unpack, akeys, bkeys, key;
    if (a === b) {
        return true;
    }
    if (a && typeof a.__eq__ === "function") {
        return a.__eq__(b);
    }
    if (b && typeof b.__eq__ === "function") {
        return b.__eq__(a);
    }
    if (ρσ_arraylike(a) && ρσ_arraylike(b)) {
        if ((a.length !== b.length && (typeof a.length !== "object" || ρσ_not_equals(a.length, b.length)))) {
            return false;
        }
        for (var i=0; i < a.length; i++) {
            if (!(((a[(typeof i === "number" && i < 0) ? a.length + i : i] === b[(typeof i === "number" && i < 0) ? b.length + i : i] || typeof a[(typeof i === "number" && i < 0) ? a.length + i : i] === "object" && ρσ_equals(a[(typeof i === "number" && i < 0) ? a.length + i : i], b[(typeof i === "number" && i < 0) ? b.length + i : i]))))) {
                return false;
            }
        }
        return true;
    }
    if (typeof a === "object" && typeof b === "object" && a !== null && b !== null && (a.constructor === Object && b.constructor === Object || Object.getPrototypeOf(a) === null && Object.getPrototypeOf(b) === null)) {
        ρσ_unpack = [Object.keys(a), Object.keys(b)];
        akeys = ρσ_unpack[0];
        bkeys = ρσ_unpack[1];
        if (akeys.length !== bkeys.length) {
            return false;
        }
        for (var j=0; j < akeys.length; j++) {
            key = akeys[(typeof j === "number" && j < 0) ? akeys.length + j : j];
            if (!(((a[(typeof key === "number" && key < 0) ? a.length + key : key] === b[(typeof key === "number" && key < 0) ? b.length + key : key] || typeof a[(typeof key === "number" && key < 0) ? a.length + key : key] === "object" && ρσ_equals(a[(typeof key === "number" && key < 0) ? a.length + key : key], b[(typeof key === "number" && key < 0) ? b.length + key : key]))))) {
                return false;
            }
        }
        return true;
    }
    return false;
};
if (!ρσ_equals.__argnames__) Object.defineProperties(ρσ_equals, {
    __argnames__ : {value: ["a", "b"]},
    __module__ : {value: "__main__"}
});

function ρσ_not_equals(a, b) {
    if (a === b) {
        return false;
    }
    if (a && typeof a.__ne__ === "function") {
        return a.__ne__(b);
    }
    if (b && typeof b.__ne__ === "function") {
        return b.__ne__(a);
    }
    return !ρσ_equals(a, b);
};
if (!ρσ_not_equals.__argnames__) Object.defineProperties(ρσ_not_equals, {
    __argnames__ : {value: ["a", "b"]},
    __module__ : {value: "__main__"}
});

var equals = ρσ_equals;
function ρσ_list_extend(iterable) {
    var start, iterator, result;
    if (Array.isArray(iterable) || typeof iterable === "string") {
        start = this.length;
        this.length += iterable.length;
        for (var i = 0; i < iterable.length; i++) {
            (ρσ_expr_temp = this)[ρσ_bound_index(start + i, ρσ_expr_temp)] = iterable[(typeof i === "number" && i < 0) ? iterable.length + i : i];
        }
    } else {
        iterator = (typeof Map === "function" && iterable instanceof Map) ? iterable.keys() : iterable[ρσ_iterator_symbol]();
        result = iterator.next();
        while (!result.done) {
            this.push(result.value);
            result = iterator.next();
        }
    }
};
if (!ρσ_list_extend.__argnames__) Object.defineProperties(ρσ_list_extend, {
    __argnames__ : {value: ["iterable"]},
    __module__ : {value: "__main__"}
});

function ρσ_list_index(val, start, stop) {
    start = start || 0;
    if (start < 0) {
        start = this.length + start;
    }
    if (start < 0) {
        throw new ValueError(val + " is not in list");
    }
    if (stop === undefined) {
        stop = this.length;
    }
    if (stop < 0) {
        stop = this.length + stop;
    }
    for (var i = start; i < stop; i++) {
        if (((ρσ_expr_temp = this)[(typeof i === "number" && i < 0) ? ρσ_expr_temp.length + i : i] === val || typeof (ρσ_expr_temp = this)[(typeof i === "number" && i < 0) ? ρσ_expr_temp.length + i : i] === "object" && ρσ_equals((ρσ_expr_temp = this)[(typeof i === "number" && i < 0) ? ρσ_expr_temp.length + i : i], val))) {
            return i;
        }
    }
    throw new ValueError(val + " is not in list");
};
if (!ρσ_list_index.__argnames__) Object.defineProperties(ρσ_list_index, {
    __argnames__ : {value: ["val", "start", "stop"]},
    __module__ : {value: "__main__"}
});

function ρσ_list_pop(index) {
    var ans;
    if (this.length === 0) {
        throw new IndexError("list is empty");
    }
    if (index === undefined) {
        index = -1;
    }
    ans = this.splice(index, 1);
    if (!ans.length) {
        throw new IndexError("pop index out of range");
    }
    return ans[0];
};
if (!ρσ_list_pop.__argnames__) Object.defineProperties(ρσ_list_pop, {
    __argnames__ : {value: ["index"]},
    __module__ : {value: "__main__"}
});

function ρσ_list_remove(value) {
    for (var i = 0; i < this.length; i++) {
        if (((ρσ_expr_temp = this)[(typeof i === "number" && i < 0) ? ρσ_expr_temp.length + i : i] === value || typeof (ρσ_expr_temp = this)[(typeof i === "number" && i < 0) ? ρσ_expr_temp.length + i : i] === "object" && ρσ_equals((ρσ_expr_temp = this)[(typeof i === "number" && i < 0) ? ρσ_expr_temp.length + i : i], value))) {
            this.splice(i, 1);
            return;
        }
    }
    throw new ValueError(value + " not in list");
};
if (!ρσ_list_remove.__argnames__) Object.defineProperties(ρσ_list_remove, {
    __argnames__ : {value: ["value"]},
    __module__ : {value: "__main__"}
});

function ρσ_list_to_string() {
    return "[" + this.join(", ") + "]";
};
if (!ρσ_list_to_string.__module__) Object.defineProperties(ρσ_list_to_string, {
    __module__ : {value: "__main__"}
});

function ρσ_list_insert(index, val) {
    if (index < 0) {
        index += this.length;
    }
    index = min(this.length, max(index, 0));
    if (index === 0) {
        this.unshift(val);
        return;
    }
    for (var i = this.length; i > index; i--) {
        (ρσ_expr_temp = this)[(typeof i === "number" && i < 0) ? ρσ_expr_temp.length + i : i] = (ρσ_expr_temp = this)[ρσ_bound_index(i - 1, ρσ_expr_temp)];
    }
    (ρσ_expr_temp = this)[(typeof index === "number" && index < 0) ? ρσ_expr_temp.length + index : index] = val;
};
if (!ρσ_list_insert.__argnames__) Object.defineProperties(ρσ_list_insert, {
    __argnames__ : {value: ["index", "val"]},
    __module__ : {value: "__main__"}
});

function ρσ_list_copy() {
    return ρσ_list_constructor(this);
};
if (!ρσ_list_copy.__module__) Object.defineProperties(ρσ_list_copy, {
    __module__ : {value: "__main__"}
});

function ρσ_list_clear() {
    this.length = 0;
};
if (!ρσ_list_clear.__module__) Object.defineProperties(ρσ_list_clear, {
    __module__ : {value: "__main__"}
});

function ρσ_list_as_array() {
    return Array.prototype.slice.call(this);
};
if (!ρσ_list_as_array.__module__) Object.defineProperties(ρσ_list_as_array, {
    __module__ : {value: "__main__"}
});

function ρσ_list_count(value) {
    return this.reduce((function() {
        var ρσ_anonfunc = function (n, val) {
            return n + (val === value);
        };
        if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
            __argnames__ : {value: ["n", "val"]},
            __module__ : {value: "__main__"}
        });
        return ρσ_anonfunc;
    })(), 0);
};
if (!ρσ_list_count.__argnames__) Object.defineProperties(ρσ_list_count, {
    __argnames__ : {value: ["value"]},
    __module__ : {value: "__main__"}
});

function ρσ_list_sort_key(value) {
    var t;
    t = typeof value;
    if (t === "string" || t === "number") {
        return value;
    }
    return value.toString();
};
if (!ρσ_list_sort_key.__argnames__) Object.defineProperties(ρσ_list_sort_key, {
    __argnames__ : {value: ["value"]},
    __module__ : {value: "__main__"}
});

function ρσ_list_sort_cmp(a, b, ap, bp) {
    if (a < b) {
        return -1;
    }
    if (a > b) {
        return 1;
    }
    return ap - bp;
};
if (!ρσ_list_sort_cmp.__argnames__) Object.defineProperties(ρσ_list_sort_cmp, {
    __argnames__ : {value: ["a", "b", "ap", "bp"]},
    __module__ : {value: "__main__"}
});

function ρσ_list_sort() {
    var key = (arguments[0] === undefined || ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? ρσ_list_sort.__defaults__.key : arguments[0];
    var reverse = (arguments[1] === undefined || ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? ρσ_list_sort.__defaults__.reverse : arguments[1];
    var ρσ_kwargs_obj = arguments[arguments.length-1];
    if (ρσ_kwargs_obj === null || typeof ρσ_kwargs_obj !== "object" || ρσ_kwargs_obj [ρσ_kwargs_symbol] !== true) ρσ_kwargs_obj = {};
    if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "key")){
        key = ρσ_kwargs_obj.key;
    }
    if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "reverse")){
        reverse = ρσ_kwargs_obj.reverse;
    }
    var mult, keymap, posmap, k;
    key = key || ρσ_list_sort_key;
    mult = (reverse) ? -1 : 1;
    keymap = dict();
    posmap = dict();
    for (var i=0; i < this.length; i++) {
        k = (ρσ_expr_temp = this)[(typeof i === "number" && i < 0) ? ρσ_expr_temp.length + i : i];
        keymap.set(k, key(k));
        posmap.set(k, i);
    }
    this.sort((function() {
        var ρσ_anonfunc = function (a, b) {
            return mult * ρσ_list_sort_cmp(keymap.get(a), keymap.get(b), posmap.get(a), posmap.get(b));
        };
        if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
            __argnames__ : {value: ["a", "b"]},
            __module__ : {value: "__main__"}
        });
        return ρσ_anonfunc;
    })());
};
if (!ρσ_list_sort.__defaults__) Object.defineProperties(ρσ_list_sort, {
    __defaults__ : {value: {key:null, reverse:false}},
    __handles_kwarg_interpolation__ : {value: true},
    __argnames__ : {value: ["key", "reverse"]},
    __module__ : {value: "__main__"}
});

function ρσ_list_concat() {
    var ans;
    ans = Array.prototype.concat.apply(this, arguments);
    ρσ_list_decorate(ans);
    return ans;
};
if (!ρσ_list_concat.__module__) Object.defineProperties(ρσ_list_concat, {
    __module__ : {value: "__main__"}
});

function ρσ_list_slice() {
    var ans;
    ans = Array.prototype.slice.apply(this, arguments);
    ρσ_list_decorate(ans);
    return ans;
};
if (!ρσ_list_slice.__module__) Object.defineProperties(ρσ_list_slice, {
    __module__ : {value: "__main__"}
});

function ρσ_list_iterator(value) {
    var self;
    self = this;
    return (function(){
        var ρσ_d = {};
        ρσ_d["_i"] = -1;
        ρσ_d["_list"] = self;
        ρσ_d["next"] = (function() {
            var ρσ_anonfunc = function () {
                this._i += 1;
                if (this._i >= this._list.length) {
                    return (function(){
                        var ρσ_d = {};
                        ρσ_d["done"] = true;
                        return ρσ_d;
                    }).call(this);
                }
                return (function(){
                    var ρσ_d = {};
                    ρσ_d["done"] = false;
                    ρσ_d["value"] = (ρσ_expr_temp = this._list)[ρσ_bound_index(this._i, ρσ_expr_temp)];
                    return ρσ_d;
                }).call(this);
            };
            if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
                __module__ : {value: "__main__"}
            });
            return ρσ_anonfunc;
        })();
        return ρσ_d;
    }).call(this);
};
if (!ρσ_list_iterator.__argnames__) Object.defineProperties(ρσ_list_iterator, {
    __argnames__ : {value: ["value"]},
    __module__ : {value: "__main__"}
});

function ρσ_list_len() {
    return this.length;
};
if (!ρσ_list_len.__module__) Object.defineProperties(ρσ_list_len, {
    __module__ : {value: "__main__"}
});

function ρσ_list_contains(val) {
    for (var i = 0; i < this.length; i++) {
        if (((ρσ_expr_temp = this)[(typeof i === "number" && i < 0) ? ρσ_expr_temp.length + i : i] === val || typeof (ρσ_expr_temp = this)[(typeof i === "number" && i < 0) ? ρσ_expr_temp.length + i : i] === "object" && ρσ_equals((ρσ_expr_temp = this)[(typeof i === "number" && i < 0) ? ρσ_expr_temp.length + i : i], val))) {
            return true;
        }
    }
    return false;
};
if (!ρσ_list_contains.__argnames__) Object.defineProperties(ρσ_list_contains, {
    __argnames__ : {value: ["val"]},
    __module__ : {value: "__main__"}
});

function ρσ_list_eq(other) {
    if (!ρσ_arraylike(other)) {
        return false;
    }
    if ((this.length !== other.length && (typeof this.length !== "object" || ρσ_not_equals(this.length, other.length)))) {
        return false;
    }
    for (var i = 0; i < this.length; i++) {
        if (!((((ρσ_expr_temp = this)[(typeof i === "number" && i < 0) ? ρσ_expr_temp.length + i : i] === other[(typeof i === "number" && i < 0) ? other.length + i : i] || typeof (ρσ_expr_temp = this)[(typeof i === "number" && i < 0) ? ρσ_expr_temp.length + i : i] === "object" && ρσ_equals((ρσ_expr_temp = this)[(typeof i === "number" && i < 0) ? ρσ_expr_temp.length + i : i], other[(typeof i === "number" && i < 0) ? other.length + i : i]))))) {
            return false;
        }
    }
    return true;
};
if (!ρσ_list_eq.__argnames__) Object.defineProperties(ρσ_list_eq, {
    __argnames__ : {value: ["other"]},
    __module__ : {value: "__main__"}
});

function ρσ_list_decorate(ans) {
    ans.append = Array.prototype.push;
    ans.toString = ρσ_list_to_string;
    ans.inspect = ρσ_list_to_string;
    ans.extend = ρσ_list_extend;
    ans.index = ρσ_list_index;
    ans.pypop = ρσ_list_pop;
    ans.remove = ρσ_list_remove;
    ans.insert = ρσ_list_insert;
    ans.copy = ρσ_list_copy;
    ans.clear = ρσ_list_clear;
    ans.count = ρσ_list_count;
    ans.concat = ρσ_list_concat;
    ans.pysort = ρσ_list_sort;
    ans.slice = ρσ_list_slice;
    ans.as_array = ρσ_list_as_array;
    ans.__len__ = ρσ_list_len;
    ans.__contains__ = ρσ_list_contains;
    ans.__eq__ = ρσ_list_eq;
    ans.constructor = ρσ_list_constructor;
    if (typeof ans[ρσ_iterator_symbol] !== "function") {
        ans[ρσ_iterator_symbol] = ρσ_list_iterator;
    }
    return ans;
};
if (!ρσ_list_decorate.__argnames__) Object.defineProperties(ρσ_list_decorate, {
    __argnames__ : {value: ["ans"]},
    __module__ : {value: "__main__"}
});

function ρσ_list_constructor(iterable) {
    var ans, iterator, result;
    if (iterable === undefined) {
        ans = [];
    } else if (ρσ_arraylike(iterable)) {
        ans = new Array(iterable.length);
        for (var i = 0; i < iterable.length; i++) {
            ans[(typeof i === "number" && i < 0) ? ans.length + i : i] = iterable[(typeof i === "number" && i < 0) ? iterable.length + i : i];
        }
    } else if (typeof iterable[ρσ_iterator_symbol] === "function") {
        iterator = (typeof Map === "function" && iterable instanceof Map) ? iterable.keys() : iterable[ρσ_iterator_symbol]();
        ans = ρσ_list_decorate([]);
        result = iterator.next();
        while (!result.done) {
            ans.push(result.value);
            result = iterator.next();
        }
    } else if (typeof iterable === "number") {
        ans = new Array(iterable);
    } else {
        ans = Object.keys(iterable);
    }
    return ρσ_list_decorate(ans);
};
if (!ρσ_list_constructor.__argnames__) Object.defineProperties(ρσ_list_constructor, {
    __argnames__ : {value: ["iterable"]},
    __module__ : {value: "__main__"}
});

ρσ_list_constructor.__name__ = "list";
var list = ρσ_list_constructor, list_wrap = ρσ_list_decorate;
function sorted() {
    var iterable = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[0];
    var key = (arguments[1] === undefined || ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? sorted.__defaults__.key : arguments[1];
    var reverse = (arguments[2] === undefined || ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? sorted.__defaults__.reverse : arguments[2];
    var ρσ_kwargs_obj = arguments[arguments.length-1];
    if (ρσ_kwargs_obj === null || typeof ρσ_kwargs_obj !== "object" || ρσ_kwargs_obj [ρσ_kwargs_symbol] !== true) ρσ_kwargs_obj = {};
    if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "key")){
        key = ρσ_kwargs_obj.key;
    }
    if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "reverse")){
        reverse = ρσ_kwargs_obj.reverse;
    }
    var ans;
    ans = ρσ_list_constructor(iterable);
    ans.pysort(key, reverse);
    return ans;
};
if (!sorted.__defaults__) Object.defineProperties(sorted, {
    __defaults__ : {value: {key:null, reverse:false}},
    __handles_kwarg_interpolation__ : {value: true},
    __argnames__ : {value: ["iterable", "key", "reverse"]},
    __module__ : {value: "__main__"}
});

var ρσ_global_object_id = 0, ρσ_set_implementation;
function ρσ_set_keyfor(x) {
    var t, ans;
    t = typeof x;
    if (t === "string" || t === "number" || t === "boolean") {
        return "_" + t[0] + x;
    }
    if (x === null) {
        return "__!@#$0";
    }
    ans = x.ρσ_hash_key_prop;
    if (ans === undefined) {
        ans = "_!@#$" + (++ρσ_global_object_id);
        Object.defineProperty(x, "ρσ_hash_key_prop", (function(){
            var ρσ_d = {};
            ρσ_d["value"] = ans;
            return ρσ_d;
        }).call(this));
    }
    return ans;
};
if (!ρσ_set_keyfor.__argnames__) Object.defineProperties(ρσ_set_keyfor, {
    __argnames__ : {value: ["x"]},
    __module__ : {value: "__main__"}
});

function ρσ_set_polyfill() {
    this._store = {};
    this.size = 0;
};
if (!ρσ_set_polyfill.__module__) Object.defineProperties(ρσ_set_polyfill, {
    __module__ : {value: "__main__"}
});

ρσ_set_polyfill.prototype.add = (function() {
    var ρσ_anonfunc = function (x) {
        var key;
        key = ρσ_set_keyfor(x);
        if (!Object.prototype.hasOwnProperty.call(this._store, key)) {
            this.size += 1;
            (ρσ_expr_temp = this._store)[(typeof key === "number" && key < 0) ? ρσ_expr_temp.length + key : key] = x;
        }
        return this;
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["x"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_set_polyfill.prototype.clear = (function() {
    var ρσ_anonfunc = function (x) {
        this._store = {};
        this.size = 0;
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["x"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_set_polyfill.prototype.delete = (function() {
    var ρσ_anonfunc = function (x) {
        var key;
        key = ρσ_set_keyfor(x);
        if (Object.prototype.hasOwnProperty.call(this._store, key)) {
            this.size -= 1;
            delete this._store[key];
            return true;
        }
        return false;
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["x"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_set_polyfill.prototype.has = (function() {
    var ρσ_anonfunc = function (x) {
        return Object.prototype.hasOwnProperty.call(this._store, ρσ_set_keyfor(x));
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["x"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_set_polyfill.prototype.values = (function() {
    var ρσ_anonfunc = function (x) {
        var ans;
        ans = {'_keys': Object.keys(this._store), '_i':-1, '_s':this._store};
        ans[ρσ_iterator_symbol] = (function() {
            var ρσ_anonfunc = function () {
                return this;
            };
            if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
                __module__ : {value: "__main__"}
            });
            return ρσ_anonfunc;
        })();
        ans["next"] = (function() {
            var ρσ_anonfunc = function () {
                this._i += 1;
                if (this._i >= this._keys.length) {
                    return {'done': true};
                }
                return {'done':false, 'value':this._s[this._keys[this._i]]};
            };
            if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
                __module__ : {value: "__main__"}
            });
            return ρσ_anonfunc;
        })();
        return ans;
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["x"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
if (typeof Set !== "function" || typeof Set.prototype.delete !== "function") {
    ρσ_set_implementation = ρσ_set_polyfill;
} else {
    ρσ_set_implementation = Set;
}
function ρσ_set(iterable) {
    var ans, s, iterator, result, keys;
    if (this instanceof ρσ_set) {
        this.jsset = new ρσ_set_implementation;
        ans = this;
        if (iterable === undefined) {
            return ans;
        }
        s = ans.jsset;
        if (ρσ_arraylike(iterable)) {
            for (var i = 0; i < iterable.length; i++) {
                s.add(iterable[(typeof i === "number" && i < 0) ? iterable.length + i : i]);
            }
        } else if (typeof iterable[ρσ_iterator_symbol] === "function") {
            iterator = (typeof Map === "function" && iterable instanceof Map) ? iterable.keys() : iterable[ρσ_iterator_symbol]();
            result = iterator.next();
            while (!result.done) {
                s.add(result.value);
                result = iterator.next();
            }
        } else {
            keys = Object.keys(iterable);
            for (var j=0; j < keys.length; j++) {
                s.add(keys[(typeof j === "number" && j < 0) ? keys.length + j : j]);
            }
        }
        return ans;
    } else {
        return new ρσ_set(iterable);
    }
};
if (!ρσ_set.__argnames__) Object.defineProperties(ρσ_set, {
    __argnames__ : {value: ["iterable"]},
    __module__ : {value: "__main__"}
});

ρσ_set.prototype.__name__ = "set";
Object.defineProperties(ρσ_set.prototype, (function(){
    var ρσ_d = {};
    ρσ_d["length"] = (function(){
        var ρσ_d = {};
        ρσ_d["get"] = (function() {
            var ρσ_anonfunc = function () {
                return this.jsset.size;
            };
            if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
                __module__ : {value: "__main__"}
            });
            return ρσ_anonfunc;
        })();
        return ρσ_d;
    }).call(this);
    ρσ_d["size"] = (function(){
        var ρσ_d = {};
        ρσ_d["get"] = (function() {
            var ρσ_anonfunc = function () {
                return this.jsset.size;
            };
            if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
                __module__ : {value: "__main__"}
            });
            return ρσ_anonfunc;
        })();
        return ρσ_d;
    }).call(this);
    return ρσ_d;
}).call(this));
ρσ_set.prototype.__len__ = (function() {
    var ρσ_anonfunc = function () {
        return this.jsset.size;
    };
    if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_set.prototype.has = ρσ_set.prototype.__contains__ = (function() {
    var ρσ_anonfunc = function (x) {
        return this.jsset.has(x);
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["x"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_set.prototype.add = (function() {
    var ρσ_anonfunc = function (x) {
        this.jsset.add(x);
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["x"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_set.prototype.clear = (function() {
    var ρσ_anonfunc = function () {
        this.jsset.clear();
    };
    if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_set.prototype.copy = (function() {
    var ρσ_anonfunc = function () {
        return ρσ_set(this);
    };
    if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_set.prototype.discard = (function() {
    var ρσ_anonfunc = function (x) {
        this.jsset.delete(x);
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["x"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_set.prototype[ρσ_iterator_symbol] = (function() {
    var ρσ_anonfunc = function () {
        return this.jsset.values();
    };
    if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_set.prototype.difference = (function() {
    var ρσ_anonfunc = function () {
        var ans, s, iterator, r, x, has;
        ans = new ρσ_set;
        s = ans.jsset;
        iterator = this.jsset.values();
        r = iterator.next();
        while (!r.done) {
            x = r.value;
            has = false;
            for (var i = 0; i < arguments.length; i++) {
                if (arguments[(typeof i === "number" && i < 0) ? arguments.length + i : i].has(x)) {
                    has = true;
                    break;
                }
            }
            if (!has) {
                s.add(x);
            }
            r = iterator.next();
        }
        return ans;
    };
    if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_set.prototype.difference_update = (function() {
    var ρσ_anonfunc = function () {
        var s, remove, iterator, r, x;
        s = this.jsset;
        remove = [];
        iterator = s.values();
        r = iterator.next();
        while (!r.done) {
            x = r.value;
            for (var i = 0; i < arguments.length; i++) {
                if (arguments[(typeof i === "number" && i < 0) ? arguments.length + i : i].has(x)) {
                    remove.push(x);
                    break;
                }
            }
            r = iterator.next();
        }
        for (var j = 0; j < remove.length; j++) {
            s.delete(remove[(typeof j === "number" && j < 0) ? remove.length + j : j]);
        }
    };
    if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_set.prototype.intersection = (function() {
    var ρσ_anonfunc = function () {
        var ans, s, iterator, r, x, has;
        ans = new ρσ_set;
        s = ans.jsset;
        iterator = this.jsset.values();
        r = iterator.next();
        while (!r.done) {
            x = r.value;
            has = true;
            for (var i = 0; i < arguments.length; i++) {
                if (!arguments[(typeof i === "number" && i < 0) ? arguments.length + i : i].has(x)) {
                    has = false;
                    break;
                }
            }
            if (has) {
                s.add(x);
            }
            r = iterator.next();
        }
        return ans;
    };
    if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_set.prototype.intersection_update = (function() {
    var ρσ_anonfunc = function () {
        var s, remove, iterator, r, x;
        s = this.jsset;
        remove = [];
        iterator = s.values();
        r = iterator.next();
        while (!r.done) {
            x = r.value;
            for (var i = 0; i < arguments.length; i++) {
                if (!arguments[(typeof i === "number" && i < 0) ? arguments.length + i : i].has(x)) {
                    remove.push(x);
                    break;
                }
            }
            r = iterator.next();
        }
        for (var j = 0; j < remove.length; j++) {
            s.delete(remove[(typeof j === "number" && j < 0) ? remove.length + j : j]);
        }
    };
    if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_set.prototype.isdisjoint = (function() {
    var ρσ_anonfunc = function (other) {
        var iterator, r, x;
        iterator = this.jsset.values();
        r = iterator.next();
        while (!r.done) {
            x = r.value;
            if (other.has(x)) {
                return false;
            }
            r = iterator.next();
        }
        return true;
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["other"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_set.prototype.issubset = (function() {
    var ρσ_anonfunc = function (other) {
        var iterator, r, x;
        iterator = this.jsset.values();
        r = iterator.next();
        while (!r.done) {
            x = r.value;
            if (!other.has(x)) {
                return false;
            }
            r = iterator.next();
        }
        return true;
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["other"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_set.prototype.issuperset = (function() {
    var ρσ_anonfunc = function (other) {
        var s, iterator, r, x;
        s = this.jsset;
        iterator = other.jsset.values();
        r = iterator.next();
        while (!r.done) {
            x = r.value;
            if (!s.has(x)) {
                return false;
            }
            r = iterator.next();
        }
        return true;
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["other"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_set.prototype.pop = (function() {
    var ρσ_anonfunc = function () {
        var iterator, r;
        iterator = this.jsset.values();
        r = iterator.next();
        if (r.done) {
            throw new KeyError("pop from an empty set");
        }
        this.jsset.delete(r.value);
        return r.value;
    };
    if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_set.prototype.remove = (function() {
    var ρσ_anonfunc = function (x) {
        if (!this.jsset.delete(x)) {
            throw new KeyError(x.toString());
        }
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["x"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_set.prototype.symmetric_difference = (function() {
    var ρσ_anonfunc = function (other) {
        return this.union(other).difference(this.intersection(other));
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["other"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_set.prototype.symmetric_difference_update = (function() {
    var ρσ_anonfunc = function (other) {
        var common;
        common = this.intersection(other);
        this.update(other);
        this.difference_update(common);
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["other"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_set.prototype.union = (function() {
    var ρσ_anonfunc = function () {
        var ans;
        ans = ρσ_set(this);
        ans.update.apply(ans, arguments);
        return ans;
    };
    if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_set.prototype.update = (function() {
    var ρσ_anonfunc = function () {
        var s, iterator, r;
        s = this.jsset;
        for (var i=0; i < arguments.length; i++) {
            iterator = arguments[(typeof i === "number" && i < 0) ? arguments.length + i : i][ρσ_iterator_symbol]();
            r = iterator.next();
            while (!r.done) {
                s.add(r.value);
                r = iterator.next();
            }
        }
    };
    if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_set.prototype.toString = ρσ_set.prototype.__repr__ = ρσ_set.prototype.__str__ = ρσ_set.prototype.inspect = (function() {
    var ρσ_anonfunc = function () {
        return "{" + list(this).join(", ") + "}";
    };
    if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_set.prototype.__eq__ = (function() {
    var ρσ_anonfunc = function (other) {
        var iterator, r;
        if (!other instanceof this.constructor) {
            return false;
        }
        if (other.size !== this.size) {
            return false;
        }
        if (other.size === 0) {
            return true;
        }
        iterator = other[ρσ_iterator_symbol]();
        r = iterator.next();
        while (!r.done) {
            if (!this.has(r.value)) {
                return false;
            }
            r = iterator.next();
        }
        return true;
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["other"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
function ρσ_set_wrap(x) {
    var ans;
    ans = new ρσ_set;
    ans.jsset = x;
    return ans;
};
if (!ρσ_set_wrap.__argnames__) Object.defineProperties(ρσ_set_wrap, {
    __argnames__ : {value: ["x"]},
    __module__ : {value: "__main__"}
});

var set = ρσ_set, set_wrap = ρσ_set_wrap;
var ρσ_dict_implementation;
function ρσ_dict_polyfill() {
    this._store = {};
    this.size = 0;
};
if (!ρσ_dict_polyfill.__module__) Object.defineProperties(ρσ_dict_polyfill, {
    __module__ : {value: "__main__"}
});

ρσ_dict_polyfill.prototype.set = (function() {
    var ρσ_anonfunc = function (x, value) {
        var key;
        key = ρσ_set_keyfor(x);
        if (!Object.prototype.hasOwnProperty.call(this._store, key)) {
            this.size += 1;
        }
        (ρσ_expr_temp = this._store)[(typeof key === "number" && key < 0) ? ρσ_expr_temp.length + key : key] = [x, value];
        return this;
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["x", "value"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_dict_polyfill.prototype.clear = (function() {
    var ρσ_anonfunc = function (x) {
        this._store = {};
        this.size = 0;
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["x"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_dict_polyfill.prototype.delete = (function() {
    var ρσ_anonfunc = function (x) {
        var key;
        key = ρσ_set_keyfor(x);
        if (Object.prototype.hasOwnProperty.call(this._store, key)) {
            this.size -= 1;
            delete this._store[key];
            return true;
        }
        return false;
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["x"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_dict_polyfill.prototype.has = (function() {
    var ρσ_anonfunc = function (x) {
        return Object.prototype.hasOwnProperty.call(this._store, ρσ_set_keyfor(x));
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["x"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_dict_polyfill.prototype.get = (function() {
    var ρσ_anonfunc = function (x) {
        try {
            return (ρσ_expr_temp = this._store)[ρσ_bound_index(ρσ_set_keyfor(x), ρσ_expr_temp)][1];
        } catch (ρσ_Exception) {
            ρσ_last_exception = ρσ_Exception;
            if (ρσ_Exception instanceof TypeError) {
                return undefined;
            } else {
                throw ρσ_Exception;
            }
        }
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["x"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_dict_polyfill.prototype.values = (function() {
    var ρσ_anonfunc = function (x) {
        var ans;
        ans = {'_keys': Object.keys(this._store), '_i':-1, '_s':this._store};
        ans[ρσ_iterator_symbol] = (function() {
            var ρσ_anonfunc = function () {
                return this;
            };
            if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
                __module__ : {value: "__main__"}
            });
            return ρσ_anonfunc;
        })();
        ans["next"] = (function() {
            var ρσ_anonfunc = function () {
                this._i += 1;
                if (this._i >= this._keys.length) {
                    return {'done': true};
                }
                return {'done':false, 'value':this._s[this._keys[this._i]][1]};
            };
            if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
                __module__ : {value: "__main__"}
            });
            return ρσ_anonfunc;
        })();
        return ans;
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["x"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_dict_polyfill.prototype.keys = (function() {
    var ρσ_anonfunc = function (x) {
        var ans;
        ans = {'_keys': Object.keys(this._store), '_i':-1, '_s':this._store};
        ans[ρσ_iterator_symbol] = (function() {
            var ρσ_anonfunc = function () {
                return this;
            };
            if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
                __module__ : {value: "__main__"}
            });
            return ρσ_anonfunc;
        })();
        ans["next"] = (function() {
            var ρσ_anonfunc = function () {
                this._i += 1;
                if (this._i >= this._keys.length) {
                    return {'done': true};
                }
                return {'done':false, 'value':this._s[this._keys[this._i]][0]};
            };
            if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
                __module__ : {value: "__main__"}
            });
            return ρσ_anonfunc;
        })();
        return ans;
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["x"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_dict_polyfill.prototype.entries = (function() {
    var ρσ_anonfunc = function (x) {
        var ans;
        ans = {'_keys': Object.keys(this._store), '_i':-1, '_s':this._store};
        ans[ρσ_iterator_symbol] = (function() {
            var ρσ_anonfunc = function () {
                return this;
            };
            if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
                __module__ : {value: "__main__"}
            });
            return ρσ_anonfunc;
        })();
        ans["next"] = (function() {
            var ρσ_anonfunc = function () {
                this._i += 1;
                if (this._i >= this._keys.length) {
                    return {'done': true};
                }
                return {'done':false, 'value':this._s[this._keys[this._i]]};
            };
            if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
                __module__ : {value: "__main__"}
            });
            return ρσ_anonfunc;
        })();
        return ans;
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["x"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
if (typeof Map !== "function" || typeof Map.prototype.delete !== "function") {
    ρσ_dict_implementation = ρσ_dict_polyfill;
} else {
    ρσ_dict_implementation = Map;
}
function ρσ_dict() {
    var iterable = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[0];
    var kw = arguments[arguments.length-1];
    if (kw === null || typeof kw !== "object" || kw [ρσ_kwargs_symbol] !== true) kw = {};
    if (this instanceof ρσ_dict) {
        this.jsmap = new ρσ_dict_implementation;
        if (iterable !== undefined) {
            this.update(iterable);
        }
        this.update(kw);
        return this;
    } else {
        return ρσ_interpolate_kwargs_constructor.call(Object.create(ρσ_dict.prototype), false, ρσ_dict, [iterable].concat([ρσ_desugar_kwargs(kw)]));
    }
};
if (!ρσ_dict.__handles_kwarg_interpolation__) Object.defineProperties(ρσ_dict, {
    __handles_kwarg_interpolation__ : {value: true},
    __argnames__ : {value: ["iterable"]},
    __module__ : {value: "__main__"}
});

ρσ_dict.prototype.__name__ = "dict";
Object.defineProperties(ρσ_dict.prototype, (function(){
    var ρσ_d = {};
    ρσ_d["length"] = (function(){
        var ρσ_d = {};
        ρσ_d["get"] = (function() {
            var ρσ_anonfunc = function () {
                return this.jsmap.size;
            };
            if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
                __module__ : {value: "__main__"}
            });
            return ρσ_anonfunc;
        })();
        return ρσ_d;
    }).call(this);
    ρσ_d["size"] = (function(){
        var ρσ_d = {};
        ρσ_d["get"] = (function() {
            var ρσ_anonfunc = function () {
                return this.jsmap.size;
            };
            if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
                __module__ : {value: "__main__"}
            });
            return ρσ_anonfunc;
        })();
        return ρσ_d;
    }).call(this);
    return ρσ_d;
}).call(this));
ρσ_dict.prototype.__len__ = (function() {
    var ρσ_anonfunc = function () {
        return this.jsmap.size;
    };
    if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_dict.prototype.has = ρσ_dict.prototype.__contains__ = (function() {
    var ρσ_anonfunc = function (x) {
        return this.jsmap.has(x);
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["x"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_dict.prototype.set = ρσ_dict.prototype.__setitem__ = (function() {
    var ρσ_anonfunc = function (key, value) {
        this.jsmap.set(key, value);
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["key", "value"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_dict.prototype.__delitem__ = (function() {
    var ρσ_anonfunc = function (key) {
        this.jsmap.delete(key);
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["key"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_dict.prototype.clear = (function() {
    var ρσ_anonfunc = function () {
        this.jsmap.clear();
    };
    if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_dict.prototype.copy = (function() {
    var ρσ_anonfunc = function () {
        return ρσ_dict(this);
    };
    if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_dict.prototype.keys = (function() {
    var ρσ_anonfunc = function () {
        return this.jsmap.keys();
    };
    if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_dict.prototype.values = (function() {
    var ρσ_anonfunc = function () {
        return this.jsmap.values();
    };
    if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_dict.prototype.items = ρσ_dict.prototype.entries = (function() {
    var ρσ_anonfunc = function () {
        return this.jsmap.entries();
    };
    if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_dict.prototype[ρσ_iterator_symbol] = (function() {
    var ρσ_anonfunc = function () {
        return this.jsmap.keys();
    };
    if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_dict.prototype.__getitem__ = (function() {
    var ρσ_anonfunc = function (key) {
        var ans;
        ans = this.jsmap.get(key);
        if (ans === undefined && !this.jsmap.has(key)) {
            throw new KeyError(key + "");
        }
        return ans;
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["key"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_dict.prototype.get = (function() {
    var ρσ_anonfunc = function (key, defval) {
        var ans;
        ans = this.jsmap.get(key);
        if (ans === undefined && !this.jsmap.has(key)) {
            return (defval === undefined) ? null : defval;
        }
        return ans;
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["key", "defval"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_dict.prototype.set_default = ρσ_dict.prototype.setdefault = (function() {
    var ρσ_anonfunc = function (key, defval) {
        var j;
        j = this.jsmap;
        if (!j.has(key)) {
            j.set(key, defval);
            return defval;
        }
        return j.get(key);
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["key", "defval"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_dict.fromkeys = ρσ_dict.prototype.fromkeys = (function() {
    var ρσ_anonfunc = function () {
        var iterable = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[0];
        var value = (arguments[1] === undefined || ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? ρσ_anonfunc.__defaults__.value : arguments[1];
        var ρσ_kwargs_obj = arguments[arguments.length-1];
        if (ρσ_kwargs_obj === null || typeof ρσ_kwargs_obj !== "object" || ρσ_kwargs_obj [ρσ_kwargs_symbol] !== true) ρσ_kwargs_obj = {};
        if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "value")){
            value = ρσ_kwargs_obj.value;
        }
        var ans, iterator, r;
        ans = ρσ_dict();
        iterator = iter(iterable);
        r = iterator.next();
        while (!r.done) {
            ans.set(r.value, value);
            r = iterator.next();
        }
        return ans;
    };
    if (!ρσ_anonfunc.__defaults__) Object.defineProperties(ρσ_anonfunc, {
        __defaults__ : {value: {value:null}},
        __handles_kwarg_interpolation__ : {value: true},
        __argnames__ : {value: ["iterable", "value"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_dict.prototype.pop = (function() {
    var ρσ_anonfunc = function (key, defval) {
        var ans;
        ans = this.jsmap.get(key);
        if (ans === undefined && !this.jsmap.has(key)) {
            if (defval === undefined) {
                throw new KeyError(key);
            }
            return defval;
        }
        this.jsmap.delete(key);
        return ans;
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["key", "defval"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_dict.prototype.popitem = (function() {
    var ρσ_anonfunc = function () {
        var last, e, r;
        last = null;
        e = this.jsmap.entries();
        while (true) {
            r = e.next();
            if (r.done) {
                if (last === null) {
                    throw new KeyError("dict is empty");
                }
                this.jsmap.delete(last.value[0]);
                return last.value;
            }
            last = r;
        }
    };
    if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_dict.prototype.update = (function() {
    var ρσ_anonfunc = function () {
        var m, iterable, iterator, result, keys;
        if (arguments.length === 0) {
            return;
        }
        m = this.jsmap;
        iterable = arguments[0];
        if (Array.isArray(iterable)) {
            for (var i = 0; i < iterable.length; i++) {
                m.set(iterable[(typeof i === "number" && i < 0) ? iterable.length + i : i][0], iterable[(typeof i === "number" && i < 0) ? iterable.length + i : i][1]);
            }
        } else if (iterable instanceof ρσ_dict) {
            iterator = iterable.items();
            result = iterator.next();
            while (!result.done) {
                m.set(result.value[0], result.value[1]);
                result = iterator.next();
            }
        } else if (typeof Map === "function" && iterable instanceof Map) {
            iterator = iterable.entries();
            result = iterator.next();
            while (!result.done) {
                m.set(result.value[0], result.value[1]);
                result = iterator.next();
            }
        } else if (typeof iterable[ρσ_iterator_symbol] === "function") {
            iterator = iterable[ρσ_iterator_symbol]();
            result = iterator.next();
            while (!result.done) {
                m.set(result.value[0], result.value[1]);
                result = iterator.next();
            }
        } else {
            keys = Object.keys(iterable);
            for (var j=0; j < keys.length; j++) {
                if (keys[(typeof j === "number" && j < 0) ? keys.length + j : j] !== ρσ_iterator_symbol) {
                    m.set(keys[(typeof j === "number" && j < 0) ? keys.length + j : j], iterable[ρσ_bound_index(keys[(typeof j === "number" && j < 0) ? keys.length + j : j], iterable)]);
                }
            }
        }
        if (arguments.length > 1) {
            ρσ_dict.prototype.update.call(this, arguments[1]);
        }
    };
    if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_dict.prototype.toString = ρσ_dict.prototype.inspect = ρσ_dict.prototype.__str__ = ρσ_dict.prototype.__repr__ = (function() {
    var ρσ_anonfunc = function () {
        var entries, iterator, r;
        entries = [];
        iterator = this.jsmap.entries();
        r = iterator.next();
        while (!r.done) {
            entries.push(ρσ_repr(r.value[0]) + ": " + ρσ_repr(r.value[1]));
            r = iterator.next();
        }
        return "{" + entries.join(", ") + "}";
    };
    if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_dict.prototype.__eq__ = (function() {
    var ρσ_anonfunc = function (other) {
        var iterator, r, x;
        if (!(other instanceof this.constructor)) {
            return false;
        }
        if (other.size !== this.size) {
            return false;
        }
        if (other.size === 0) {
            return true;
        }
        iterator = other.items();
        r = iterator.next();
        while (!r.done) {
            x = this.jsmap.get(r.value[0]);
            if (x === undefined && !this.jsmap.has(r.value[0]) || x !== r.value[1]) {
                return false;
            }
            r = iterator.next();
        }
        return true;
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["other"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_dict.prototype.as_object = (function() {
    var ρσ_anonfunc = function (other) {
        var ans, iterator, r;
        ans = {};
        iterator = this.jsmap.entries();
        r = iterator.next();
        while (!r.done) {
            ans[ρσ_bound_index(r.value[0], ans)] = r.value[1];
            r = iterator.next();
        }
        return ans;
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["other"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
function ρσ_dict_wrap(x) {
    var ans;
    ans = new ρσ_dict;
    ans.jsmap = x;
    return ans;
};
if (!ρσ_dict_wrap.__argnames__) Object.defineProperties(ρσ_dict_wrap, {
    __argnames__ : {value: ["x"]},
    __module__ : {value: "__main__"}
});

var dict = ρσ_dict, dict_wrap = ρσ_dict_wrap;// }}}
var NameError;
NameError = ReferenceError;
function Exception() {
    if (this.ρσ_object_id === undefined) Object.defineProperty(this, "ρσ_object_id", {"value":++ρσ_object_counter});
    Exception.prototype.__init__.apply(this, arguments);
}
ρσ_extends(Exception, Error);
Exception.prototype.__init__ = function __init__(message) {
    var self = this;
    self.message = message;
    self.stack = (new Error).stack;
    self.name = self.constructor.name;
};
if (!Exception.prototype.__init__.__argnames__) Object.defineProperties(Exception.prototype.__init__, {
    __argnames__ : {value: ["message"]},
    __module__ : {value: "__main__"}
});
Exception.__argnames__ = Exception.prototype.__init__.__argnames__;
Exception.__handles_kwarg_interpolation__ = Exception.prototype.__init__.__handles_kwarg_interpolation__;
Exception.prototype.__repr__ = function __repr__() {
    var self = this;
    return self.name + ": " + self.message;
};
if (!Exception.prototype.__repr__.__module__) Object.defineProperties(Exception.prototype.__repr__, {
    __module__ : {value: "__main__"}
});
Exception.prototype.__str__ = function __str__ () {
    if(Error.prototype.__str__) return Error.prototype.__str__.call(this);
return this.__repr__();
};
Object.defineProperty(Exception.prototype, "__bases__", {value: [Error]});

function AttributeError() {
    if (this.ρσ_object_id === undefined) Object.defineProperty(this, "ρσ_object_id", {"value":++ρσ_object_counter});
    AttributeError.prototype.__init__.apply(this, arguments);
}
ρσ_extends(AttributeError, Exception);
AttributeError.prototype.__init__ = function __init__ () {
    Exception.prototype.__init__ && Exception.prototype.__init__.apply(this, arguments);
};
AttributeError.prototype.__repr__ = function __repr__ () {
    if(Exception.prototype.__repr__) return Exception.prototype.__repr__.call(this);
    return "<" + __name__ + "." + this.constructor.name + " #" + this.ρσ_object_id + ">";
};
AttributeError.prototype.__str__ = function __str__ () {
    if(Exception.prototype.__str__) return Exception.prototype.__str__.call(this);
return this.__repr__();
};
Object.defineProperty(AttributeError.prototype, "__bases__", {value: [Exception]});


function IndexError() {
    if (this.ρσ_object_id === undefined) Object.defineProperty(this, "ρσ_object_id", {"value":++ρσ_object_counter});
    IndexError.prototype.__init__.apply(this, arguments);
}
ρσ_extends(IndexError, Exception);
IndexError.prototype.__init__ = function __init__ () {
    Exception.prototype.__init__ && Exception.prototype.__init__.apply(this, arguments);
};
IndexError.prototype.__repr__ = function __repr__ () {
    if(Exception.prototype.__repr__) return Exception.prototype.__repr__.call(this);
    return "<" + __name__ + "." + this.constructor.name + " #" + this.ρσ_object_id + ">";
};
IndexError.prototype.__str__ = function __str__ () {
    if(Exception.prototype.__str__) return Exception.prototype.__str__.call(this);
return this.__repr__();
};
Object.defineProperty(IndexError.prototype, "__bases__", {value: [Exception]});


function KeyError() {
    if (this.ρσ_object_id === undefined) Object.defineProperty(this, "ρσ_object_id", {"value":++ρσ_object_counter});
    KeyError.prototype.__init__.apply(this, arguments);
}
ρσ_extends(KeyError, Exception);
KeyError.prototype.__init__ = function __init__ () {
    Exception.prototype.__init__ && Exception.prototype.__init__.apply(this, arguments);
};
KeyError.prototype.__repr__ = function __repr__ () {
    if(Exception.prototype.__repr__) return Exception.prototype.__repr__.call(this);
    return "<" + __name__ + "." + this.constructor.name + " #" + this.ρσ_object_id + ">";
};
KeyError.prototype.__str__ = function __str__ () {
    if(Exception.prototype.__str__) return Exception.prototype.__str__.call(this);
return this.__repr__();
};
Object.defineProperty(KeyError.prototype, "__bases__", {value: [Exception]});


function ValueError() {
    if (this.ρσ_object_id === undefined) Object.defineProperty(this, "ρσ_object_id", {"value":++ρσ_object_counter});
    ValueError.prototype.__init__.apply(this, arguments);
}
ρσ_extends(ValueError, Exception);
ValueError.prototype.__init__ = function __init__ () {
    Exception.prototype.__init__ && Exception.prototype.__init__.apply(this, arguments);
};
ValueError.prototype.__repr__ = function __repr__ () {
    if(Exception.prototype.__repr__) return Exception.prototype.__repr__.call(this);
    return "<" + __name__ + "." + this.constructor.name + " #" + this.ρσ_object_id + ">";
};
ValueError.prototype.__str__ = function __str__ () {
    if(Exception.prototype.__str__) return Exception.prototype.__str__.call(this);
return this.__repr__();
};
Object.defineProperty(ValueError.prototype, "__bases__", {value: [Exception]});


function UnicodeDecodeError() {
    if (this.ρσ_object_id === undefined) Object.defineProperty(this, "ρσ_object_id", {"value":++ρσ_object_counter});
    UnicodeDecodeError.prototype.__init__.apply(this, arguments);
}
ρσ_extends(UnicodeDecodeError, Exception);
UnicodeDecodeError.prototype.__init__ = function __init__ () {
    Exception.prototype.__init__ && Exception.prototype.__init__.apply(this, arguments);
};
UnicodeDecodeError.prototype.__repr__ = function __repr__ () {
    if(Exception.prototype.__repr__) return Exception.prototype.__repr__.call(this);
    return "<" + __name__ + "." + this.constructor.name + " #" + this.ρσ_object_id + ">";
};
UnicodeDecodeError.prototype.__str__ = function __str__ () {
    if(Exception.prototype.__str__) return Exception.prototype.__str__.call(this);
return this.__repr__();
};
Object.defineProperty(UnicodeDecodeError.prototype, "__bases__", {value: [Exception]});


function AssertionError() {
    if (this.ρσ_object_id === undefined) Object.defineProperty(this, "ρσ_object_id", {"value":++ρσ_object_counter});
    AssertionError.prototype.__init__.apply(this, arguments);
}
ρσ_extends(AssertionError, Exception);
AssertionError.prototype.__init__ = function __init__ () {
    Exception.prototype.__init__ && Exception.prototype.__init__.apply(this, arguments);
};
AssertionError.prototype.__repr__ = function __repr__ () {
    if(Exception.prototype.__repr__) return Exception.prototype.__repr__.call(this);
    return "<" + __name__ + "." + this.constructor.name + " #" + this.ρσ_object_id + ">";
};
AssertionError.prototype.__str__ = function __str__ () {
    if(Exception.prototype.__str__) return Exception.prototype.__str__.call(this);
return this.__repr__();
};
Object.defineProperty(AssertionError.prototype, "__bases__", {value: [Exception]});


function ZeroDivisionError() {
    if (this.ρσ_object_id === undefined) Object.defineProperty(this, "ρσ_object_id", {"value":++ρσ_object_counter});
    ZeroDivisionError.prototype.__init__.apply(this, arguments);
}
ρσ_extends(ZeroDivisionError, Exception);
ZeroDivisionError.prototype.__init__ = function __init__ () {
    Exception.prototype.__init__ && Exception.prototype.__init__.apply(this, arguments);
};
ZeroDivisionError.prototype.__repr__ = function __repr__ () {
    if(Exception.prototype.__repr__) return Exception.prototype.__repr__.call(this);
    return "<" + __name__ + "." + this.constructor.name + " #" + this.ρσ_object_id + ">";
};
ZeroDivisionError.prototype.__str__ = function __str__ () {
    if(Exception.prototype.__str__) return Exception.prototype.__str__.call(this);
return this.__repr__();
};
Object.defineProperty(ZeroDivisionError.prototype, "__bases__", {value: [Exception]});

var ρσ_in, ρσ_desugar_kwargs, ρσ_exists;
function ρσ_eslice(arr, step, start, end) {
    var is_string;
    if (typeof arr === "string" || arr instanceof String) {
        is_string = true;
        arr = arr.split("");
    }
    if (step < 0) {
        step = -step;
        arr = arr.slice().reverse();
        if (typeof start !== "undefined") {
            start = arr.length - start - 1;
        }
        if (typeof end !== "undefined") {
            end = arr.length - end - 1;
        }
    }
    if (typeof start === "undefined") {
        start = 0;
    }
    if (typeof end === "undefined") {
        end = arr.length;
    }
    arr = arr.slice(start, end).filter((function() {
        var ρσ_anonfunc = function (e, i) {
            return i % step === 0;
        };
        if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
            __argnames__ : {value: ["e", "i"]},
            __module__ : {value: "__main__"}
        });
        return ρσ_anonfunc;
    })());
    if (is_string) {
        arr = arr.join("");
    }
    return arr;
};
if (!ρσ_eslice.__argnames__) Object.defineProperties(ρσ_eslice, {
    __argnames__ : {value: ["arr", "step", "start", "end"]},
    __module__ : {value: "__main__"}
});

function ρσ_delslice(arr, step, start, end) {
    var is_string, ρσ_unpack, indices;
    if (typeof arr === "string" || arr instanceof String) {
        is_string = true;
        arr = arr.split("");
    }
    if (step < 0) {
        if (typeof start === "undefined") {
            start = arr.length;
        }
        if (typeof end === "undefined") {
            end = 0;
        }
        ρσ_unpack = [end, start, -step];
        start = ρσ_unpack[0];
        end = ρσ_unpack[1];
        step = ρσ_unpack[2];
    }
    if (typeof start === "undefined") {
        start = 0;
    }
    if (typeof end === "undefined") {
        end = arr.length;
    }
    if (step === 1) {
        arr.splice(start, end - start);
    } else {
        if (end > start) {
            indices = [];
            for (var i = start; i < end; i += step) {
                indices.push(i);
            }
            for (var i = indices.length - 1; i >= 0; i--) {
                arr.splice(indices[(typeof i === "number" && i < 0) ? indices.length + i : i], 1);
            }
        }
    }
    if (is_string) {
        arr = arr.join("");
    }
    return arr;
};
if (!ρσ_delslice.__argnames__) Object.defineProperties(ρσ_delslice, {
    __argnames__ : {value: ["arr", "step", "start", "end"]},
    __module__ : {value: "__main__"}
});

function ρσ_flatten(arr) {
    var ans, value;
    ans = ρσ_list_decorate([]);
    for (var i=0; i < arr.length; i++) {
        value = arr[(typeof i === "number" && i < 0) ? arr.length + i : i];
        if (Array.isArray(value)) {
            ans = ans.concat(ρσ_flatten(value));
        } else {
            ans.push(value);
        }
    }
    return ans;
};
if (!ρσ_flatten.__argnames__) Object.defineProperties(ρσ_flatten, {
    __argnames__ : {value: ["arr"]},
    __module__ : {value: "__main__"}
});

function ρσ_unpack_asarray(num, iterable) {
    var ans, iterator, result;
    if (ρσ_arraylike(iterable)) {
        return iterable;
    }
    ans = [];
    if (typeof iterable[ρσ_iterator_symbol] === "function") {
        iterator = (typeof Map === "function" && iterable instanceof Map) ? iterable.keys() : iterable[ρσ_iterator_symbol]();
        result = iterator.next();
        while (!result.done && ans.length < num) {
            ans.push(result.value);
            result = iterator.next();
        }
    }
    return ans;
};
if (!ρσ_unpack_asarray.__argnames__) Object.defineProperties(ρσ_unpack_asarray, {
    __argnames__ : {value: ["num", "iterable"]},
    __module__ : {value: "__main__"}
});

function ρσ_extends(child, parent) {
    child.prototype = Object.create(parent.prototype);
    child.prototype.constructor = child;
};
if (!ρσ_extends.__argnames__) Object.defineProperties(ρσ_extends, {
    __argnames__ : {value: ["child", "parent"]},
    __module__ : {value: "__main__"}
});

ρσ_in = (function() {
    var ρσ_anonfunc = function () {
        if (typeof Map === "function" && typeof Set === "function") {
            return (function() {
                var ρσ_anonfunc = function (val, arr) {
                    if (typeof arr === "string") {
                        return arr.indexOf(val) !== -1;
                    }
                    if (typeof arr.__contains__ === "function") {
                        return arr.__contains__(val);
                    }
                    if (arr instanceof Map || arr instanceof Set) {
                        return arr.has(val);
                    }
                    if (ρσ_arraylike(arr)) {
                        return ρσ_list_contains.call(arr, val);
                    }
                    return Object.prototype.hasOwnProperty.call(arr, val);
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["val", "arr"]},
                    __module__ : {value: "__main__"}
                });
                return ρσ_anonfunc;
            })();
        }
        return (function() {
            var ρσ_anonfunc = function (val, arr) {
                if (typeof arr === "string") {
                    return arr.indexOf(val) !== -1;
                }
                if (typeof arr.__contains__ === "function") {
                    return arr.__contains__(val);
                }
                if (ρσ_arraylike(arr)) {
                    return ρσ_list_contains.call(arr, val);
                }
                return Object.prototype.hasOwnProperty.call(arr, val);
            };
            if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                __argnames__ : {value: ["val", "arr"]},
                __module__ : {value: "__main__"}
            });
            return ρσ_anonfunc;
        })();
    };
    if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})()();
function ρσ_Iterable(iterable) {
    var iterator, ans, result;
    if (ρσ_arraylike(iterable)) {
        return iterable;
    }
    if (typeof iterable[ρσ_iterator_symbol] === "function") {
        iterator = (typeof Map === "function" && iterable instanceof Map) ? iterable.keys() : iterable[ρσ_iterator_symbol]();
        ans = ρσ_list_decorate([]);
        result = iterator.next();
        while (!result.done) {
            ans.push(result.value);
            result = iterator.next();
        }
        return ans;
    }
    return Object.keys(iterable);
};
if (!ρσ_Iterable.__argnames__) Object.defineProperties(ρσ_Iterable, {
    __argnames__ : {value: ["iterable"]},
    __module__ : {value: "__main__"}
});

ρσ_desugar_kwargs = (function() {
    var ρσ_anonfunc = function () {
        if (typeof Object.assign === "function") {
            return (function() {
                var ρσ_anonfunc = function () {
                    var ans;
                    ans = Object.create(null);
                    ans[ρσ_kwargs_symbol] = true;
                    for (var i = 0; i < arguments.length; i++) {
                        Object.assign(ans, arguments[(typeof i === "number" && i < 0) ? arguments.length + i : i]);
                    }
                    return ans;
                };
                if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
                    __module__ : {value: "__main__"}
                });
                return ρσ_anonfunc;
            })();
        }
        return (function() {
            var ρσ_anonfunc = function () {
                var ans, keys;
                ans = Object.create(null);
                ans[ρσ_kwargs_symbol] = true;
                for (var i = 0; i < arguments.length; i++) {
                    keys = Object.keys(arguments[(typeof i === "number" && i < 0) ? arguments.length + i : i]);
                    for (var j = 0; j < keys.length; j++) {
                        ans[ρσ_bound_index(keys[(typeof j === "number" && j < 0) ? keys.length + j : j], ans)] = (ρσ_expr_temp = arguments[(typeof i === "number" && i < 0) ? arguments.length + i : i])[ρσ_bound_index(keys[(typeof j === "number" && j < 0) ? keys.length + j : j], ρσ_expr_temp)];
                    }
                }
                return ans;
            };
            if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
                __module__ : {value: "__main__"}
            });
            return ρσ_anonfunc;
        })();
    };
    if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})()();
function ρσ_interpolate_kwargs(f, supplied_args) {
    var has_prop, kwobj, args, prop;
    if (!f.__argnames__) {
        return f.apply(this, supplied_args);
    }
    has_prop = Object.prototype.hasOwnProperty;
    kwobj = supplied_args.pop();
    if (f.__handles_kwarg_interpolation__) {
        args = new Array(Math.max(supplied_args.length, f.__argnames__.length) + 1);
        args[args.length-1] = kwobj;
        for (var i = 0; i < args.length - 1; i++) {
            if (i < f.__argnames__.length) {
                prop = (ρσ_expr_temp = f.__argnames__)[(typeof i === "number" && i < 0) ? ρσ_expr_temp.length + i : i];
                if (has_prop.call(kwobj, prop)) {
                    args[(typeof i === "number" && i < 0) ? args.length + i : i] = kwobj[(typeof prop === "number" && prop < 0) ? kwobj.length + prop : prop];
                    delete kwobj[prop];
                } else if (i < supplied_args.length) {
                    args[(typeof i === "number" && i < 0) ? args.length + i : i] = supplied_args[(typeof i === "number" && i < 0) ? supplied_args.length + i : i];
                }
            } else {
                args[(typeof i === "number" && i < 0) ? args.length + i : i] = supplied_args[(typeof i === "number" && i < 0) ? supplied_args.length + i : i];
            }
        }
        return f.apply(this, args);
    }
    for (var i = 0; i < f.__argnames__.length; i++) {
        prop = (ρσ_expr_temp = f.__argnames__)[(typeof i === "number" && i < 0) ? ρσ_expr_temp.length + i : i];
        if (has_prop.call(kwobj, prop)) {
            supplied_args[(typeof i === "number" && i < 0) ? supplied_args.length + i : i] = kwobj[(typeof prop === "number" && prop < 0) ? kwobj.length + prop : prop];
        }
    }
    return f.apply(this, supplied_args);
};
if (!ρσ_interpolate_kwargs.__argnames__) Object.defineProperties(ρσ_interpolate_kwargs, {
    __argnames__ : {value: ["f", "supplied_args"]},
    __module__ : {value: "__main__"}
});

function ρσ_interpolate_kwargs_constructor(apply, f, supplied_args) {
    if (apply) {
        f.apply(this, supplied_args);
    } else {
        ρσ_interpolate_kwargs.call(this, f, supplied_args);
    }
    return this;
};
if (!ρσ_interpolate_kwargs_constructor.__argnames__) Object.defineProperties(ρσ_interpolate_kwargs_constructor, {
    __argnames__ : {value: ["apply", "f", "supplied_args"]},
    __module__ : {value: "__main__"}
});

function ρσ_getitem(obj, key) {
    if (obj.__getitem__) {
        return obj.__getitem__(key);
    }
    if (typeof key === "number" && key < 0) {
        key += obj.length;
    }
    return obj[(typeof key === "number" && key < 0) ? obj.length + key : key];
};
if (!ρσ_getitem.__argnames__) Object.defineProperties(ρσ_getitem, {
    __argnames__ : {value: ["obj", "key"]},
    __module__ : {value: "__main__"}
});

function ρσ_setitem(obj, key, val) {
    if (obj.__setitem__) {
        obj.__setitem__(key, val);
    } else {
        if (typeof key === "number" && key < 0) {
            key += obj.length;
        }
        obj[(typeof key === "number" && key < 0) ? obj.length + key : key] = val;
    }
    return val;
};
if (!ρσ_setitem.__argnames__) Object.defineProperties(ρσ_setitem, {
    __argnames__ : {value: ["obj", "key", "val"]},
    __module__ : {value: "__main__"}
});

function ρσ_delitem(obj, key) {
    if (obj.__delitem__) {
        obj.__delitem__(key);
    } else if (typeof obj.splice === "function") {
        obj.splice(key, 1);
    } else {
        if (typeof key === "number" && key < 0) {
            key += obj.length;
        }
        delete obj[key];
    }
};
if (!ρσ_delitem.__argnames__) Object.defineProperties(ρσ_delitem, {
    __argnames__ : {value: ["obj", "key"]},
    __module__ : {value: "__main__"}
});

function ρσ_bound_index(idx, arr) {
    if (typeof idx === "number" && idx < 0) {
        idx += arr.length;
    }
    return idx;
};
if (!ρσ_bound_index.__argnames__) Object.defineProperties(ρσ_bound_index, {
    __argnames__ : {value: ["idx", "arr"]},
    __module__ : {value: "__main__"}
});

function ρσ_splice(arr, val, start, end) {
    start = start || 0;
    if (start < 0) {
        start += arr.length;
    }
    if (end === undefined) {
        end = arr.length;
    }
    if (end < 0) {
        end += arr.length;
    }
    Array.prototype.splice.apply(arr, [start, end - start].concat(val));
};
if (!ρσ_splice.__argnames__) Object.defineProperties(ρσ_splice, {
    __argnames__ : {value: ["arr", "val", "start", "end"]},
    __module__ : {value: "__main__"}
});

ρσ_exists = (function(){
    var ρσ_d = {};
    ρσ_d["n"] = (function() {
        var ρσ_anonfunc = function (expr) {
            return expr !== undefined && expr !== null;
        };
        if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
            __argnames__ : {value: ["expr"]},
            __module__ : {value: "__main__"}
        });
        return ρσ_anonfunc;
    })();
    ρσ_d["d"] = (function() {
        var ρσ_anonfunc = function (expr) {
            if (expr === undefined || expr === null) {
                return Object.create(null);
            }
            return expr;
        };
        if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
            __argnames__ : {value: ["expr"]},
            __module__ : {value: "__main__"}
        });
        return ρσ_anonfunc;
    })();
    ρσ_d["c"] = (function() {
        var ρσ_anonfunc = function (expr) {
            if (typeof expr === "function") {
                return expr;
            }
            return (function() {
                var ρσ_anonfunc = function () {
                    return undefined;
                };
                if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
                    __module__ : {value: "__main__"}
                });
                return ρσ_anonfunc;
            })();
        };
        if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
            __argnames__ : {value: ["expr"]},
            __module__ : {value: "__main__"}
        });
        return ρσ_anonfunc;
    })();
    ρσ_d["g"] = (function() {
        var ρσ_anonfunc = function (expr) {
            if (expr === undefined || expr === null || typeof expr.__getitem__ !== "function") {
                return (function(){
                    var ρσ_d = {};
                    ρσ_d["__getitem__"] = (function() {
                        var ρσ_anonfunc = function () {
                            return undefined;
                        };
                        if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
                            __module__ : {value: "__main__"}
                        });
                        return ρσ_anonfunc;
                    })();
                    return ρσ_d;
                }).call(this);
            }
        };
        if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
            __argnames__ : {value: ["expr"]},
            __module__ : {value: "__main__"}
        });
        return ρσ_anonfunc;
    })();
    ρσ_d["e"] = (function() {
        var ρσ_anonfunc = function (expr, alt) {
            return (expr === undefined || expr === null) ? alt : expr;
        };
        if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
            __argnames__ : {value: ["expr", "alt"]},
            __module__ : {value: "__main__"}
        });
        return ρσ_anonfunc;
    })();
    return ρσ_d;
}).call(this);
function ρσ_mixin() {
    var seen, resolved_props, p, target, props, name;
    seen = Object.create(null);
    seen.__argnames__ = seen.__handles_kwarg_interpolation__ = seen.__init__ = seen.__annotations__ = seen.__doc__ = seen.__bind_methods__ = seen.__bases__ = seen.constructor = seen.__class__ = true;
    resolved_props = {};
    p = target = arguments[0].prototype;
    while (p && p !== Object.prototype) {
        props = Object.getOwnPropertyNames(p);
        for (var i = 0; i < props.length; i++) {
            seen[ρσ_bound_index(props[(typeof i === "number" && i < 0) ? props.length + i : i], seen)] = true;
        }
        p = Object.getPrototypeOf(p);
    }
    for (var c = 1; c < arguments.length; c++) {
        p = arguments[(typeof c === "number" && c < 0) ? arguments.length + c : c].prototype;
        while (p && p !== Object.prototype) {
            props = Object.getOwnPropertyNames(p);
            for (var i = 0; i < props.length; i++) {
                name = props[(typeof i === "number" && i < 0) ? props.length + i : i];
                if (seen[(typeof name === "number" && name < 0) ? seen.length + name : name]) {
                    continue;
                }
                seen[(typeof name === "number" && name < 0) ? seen.length + name : name] = true;
                resolved_props[(typeof name === "number" && name < 0) ? resolved_props.length + name : name] = Object.getOwnPropertyDescriptor(p, name);
            }
            p = Object.getPrototypeOf(p);
        }
    }
    Object.defineProperties(target, resolved_props);
};
if (!ρσ_mixin.__module__) Object.defineProperties(ρσ_mixin, {
    __module__ : {value: "__main__"}
});

function ρσ_instanceof() {
    var obj, bases, q, cls, p;
    obj = arguments[0];
    bases = "";
    if (obj && obj.constructor && obj.constructor.prototype) {
        bases = obj.constructor.prototype.__bases__ || "";
    }
    for (var i = 1; i < arguments.length; i++) {
        q = arguments[(typeof i === "number" && i < 0) ? arguments.length + i : i];
        if (obj instanceof q) {
            return true;
        }
        if ((q === Array || q === ρσ_list_constructor) && Array.isArray(obj)) {
            return true;
        }
        if (q === ρσ_str && (typeof obj === "string" || obj instanceof String)) {
            return true;
        }
        if (q === ρσ_int && typeof obj === "number" && Number.isInteger(obj)) {
            return true;
        }
        if (q === ρσ_float && typeof obj === "number" && !Number.isInteger(obj)) {
            return true;
        }
        if (bases.length > 1) {
            for (var c = 1; c < bases.length; c++) {
                cls = bases[(typeof c === "number" && c < 0) ? bases.length + c : c];
                while (cls) {
                    if (q === cls) {
                        return true;
                    }
                    p = Object.getPrototypeOf(cls.prototype);
                    if (!p) {
                        break;
                    }
                    cls = p.constructor;
                }
            }
        }
    }
    return false;
};
if (!ρσ_instanceof.__module__) Object.defineProperties(ρσ_instanceof, {
    __module__ : {value: "__main__"}
});
function sum(iterable, start) {
    var ans, iterator, r;
    if (Array.isArray(iterable)) {
        return iterable.reduce((function() {
            var ρσ_anonfunc = function (prev, cur) {
                return prev + cur;
            };
            if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                __argnames__ : {value: ["prev", "cur"]},
                __module__ : {value: "__main__"}
            });
            return ρσ_anonfunc;
        })(), start || 0);
    }
    ans = start || 0;
    iterator = iter(iterable);
    r = iterator.next();
    while (!r.done) {
        ans += r.value;
        r = iterator.next();
    }
    return ans;
};
if (!sum.__argnames__) Object.defineProperties(sum, {
    __argnames__ : {value: ["iterable", "start"]},
    __module__ : {value: "__main__"}
});

function map() {
    var iterators, func, args, ans;
    iterators = new Array(arguments.length - 1);
    func = arguments[0];
    args = new Array(arguments.length - 1);
    for (var i = 1; i < arguments.length; i++) {
        iterators[ρσ_bound_index(i - 1, iterators)] = iter(arguments[(typeof i === "number" && i < 0) ? arguments.length + i : i]);
    }
    ans = {'_func':func, '_iterators':iterators, '_args':args};
    ans[ρσ_iterator_symbol] = (function() {
        var ρσ_anonfunc = function () {
            return this;
        };
        if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
            __module__ : {value: "__main__"}
        });
        return ρσ_anonfunc;
    })();
    ans["next"] = (function() {
        var ρσ_anonfunc = function () {
            var r;
            for (var i = 0; i < this._iterators.length; i++) {
                r = (ρσ_expr_temp = this._iterators)[(typeof i === "number" && i < 0) ? ρσ_expr_temp.length + i : i].next();
                if (r.done) {
                    return {'done':true};
                }
                (ρσ_expr_temp = this._args)[(typeof i === "number" && i < 0) ? ρσ_expr_temp.length + i : i] = r.value;
            }
            return {'done':false, 'value':this._func.apply(undefined, this._args)};
        };
        if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
            __module__ : {value: "__main__"}
        });
        return ρσ_anonfunc;
    })();
    return ans;
};
if (!map.__module__) Object.defineProperties(map, {
    __module__ : {value: "__main__"}
});

function filter(func_or_none, iterable) {
    var func, ans;
    func = (func_or_none === null) ? ρσ_bool : func_or_none;
    ans = {'_func':func, '_iterator':ρσ_iter(iterable)};
    ans[ρσ_iterator_symbol] = (function() {
        var ρσ_anonfunc = function () {
            return this;
        };
        if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
            __module__ : {value: "__main__"}
        });
        return ρσ_anonfunc;
    })();
    ans["next"] = (function() {
        var ρσ_anonfunc = function () {
            var r;
            r = this._iterator.next();
            while (!r.done) {
                if (this._func(r.value)) {
                    return r;
                }
                r = this._iterator.next();
            }
            return {'done':true};
        };
        if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
            __module__ : {value: "__main__"}
        });
        return ρσ_anonfunc;
    })();
    return ans;
};
if (!filter.__argnames__) Object.defineProperties(filter, {
    __argnames__ : {value: ["func_or_none", "iterable"]},
    __module__ : {value: "__main__"}
});

function zip() {
    var iterators, ans;
    iterators = new Array(arguments.length);
    for (var i = 0; i < arguments.length; i++) {
        iterators[(typeof i === "number" && i < 0) ? iterators.length + i : i] = iter(arguments[(typeof i === "number" && i < 0) ? arguments.length + i : i]);
    }
    ans = {'_iterators':iterators};
    ans[ρσ_iterator_symbol] = (function() {
        var ρσ_anonfunc = function () {
            return this;
        };
        if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
            __module__ : {value: "__main__"}
        });
        return ρσ_anonfunc;
    })();
    ans["next"] = (function() {
        var ρσ_anonfunc = function () {
            var args, r;
            args = new Array(this._iterators.length);
            for (var i = 0; i < this._iterators.length; i++) {
                r = (ρσ_expr_temp = this._iterators)[(typeof i === "number" && i < 0) ? ρσ_expr_temp.length + i : i].next();
                if (r.done) {
                    return {'done':true};
                }
                args[(typeof i === "number" && i < 0) ? args.length + i : i] = r.value;
            }
            return {'done':false, 'value':args};
        };
        if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
            __module__ : {value: "__main__"}
        });
        return ρσ_anonfunc;
    })();
    return ans;
};
if (!zip.__module__) Object.defineProperties(zip, {
    __module__ : {value: "__main__"}
});

function any(iterable) {
    var i;
    var ρσ_Iter0 = ρσ_Iterable(iterable);
    for (var ρσ_Index0 = 0; ρσ_Index0 < ρσ_Iter0.length; ρσ_Index0++) {
        i = ρσ_Iter0[ρσ_Index0];
        if (i) {
            return true;
        }
    }
    return false;
};
if (!any.__argnames__) Object.defineProperties(any, {
    __argnames__ : {value: ["iterable"]},
    __module__ : {value: "__main__"}
});

function all(iterable) {
    var i;
    var ρσ_Iter1 = ρσ_Iterable(iterable);
    for (var ρσ_Index1 = 0; ρσ_Index1 < ρσ_Iter1.length; ρσ_Index1++) {
        i = ρσ_Iter1[ρσ_Index1];
        if (!i) {
            return false;
        }
    }
    return true;
};
if (!all.__argnames__) Object.defineProperties(all, {
    __argnames__ : {value: ["iterable"]},
    __module__ : {value: "__main__"}
});
var decimal_sep, define_str_func, ρσ_unpack, ρσ_orig_split, ρσ_orig_replace;
decimal_sep = 1.1.toLocaleString()[1];
function ρσ_repr_js_builtin(x, as_array) {
    var ans, b, keys, key;
    ans = [];
    b = "{}";
    if (as_array) {
        b = "[]";
        for (var i = 0; i < x.length; i++) {
            ans.push(ρσ_repr(x[(typeof i === "number" && i < 0) ? x.length + i : i]));
        }
    } else {
        keys = Object.keys(x);
        for (var k = 0; k < keys.length; k++) {
            key = keys[(typeof k === "number" && k < 0) ? keys.length + k : k];
            ans.push(JSON.stringify(key) + ":" + ρσ_repr(x[(typeof key === "number" && key < 0) ? x.length + key : key]));
        }
    }
    return b[0] + ans.join(", ") + b[1];
};
if (!ρσ_repr_js_builtin.__argnames__) Object.defineProperties(ρσ_repr_js_builtin, {
    __argnames__ : {value: ["x", "as_array"]},
    __module__ : {value: "__main__"}
});

function ρσ_html_element_to_string(elem) {
    var attrs, val, attr, ans;
    attrs = [];
    var ρσ_Iter0 = ρσ_Iterable(elem.attributes);
    for (var ρσ_Index0 = 0; ρσ_Index0 < ρσ_Iter0.length; ρσ_Index0++) {
        attr = ρσ_Iter0[ρσ_Index0];
        if (attr.specified) {
            val = attr.value;
            if (val.length > 10) {
                val = val.slice(0, 15) + "...";
            }
            val = JSON.stringify(val);
            attrs.push("" + ρσ_str.format("{}", attr.name) + "=" + ρσ_str.format("{}", val) + "");
        }
    }
    attrs = (attrs.length) ? " " + attrs.join(" ") : "";
    ans = "<" + ρσ_str.format("{}", elem.tagName) + "" + ρσ_str.format("{}", attrs) + ">";
    return ans;
};
if (!ρσ_html_element_to_string.__argnames__) Object.defineProperties(ρσ_html_element_to_string, {
    __argnames__ : {value: ["elem"]},
    __module__ : {value: "__main__"}
});

function ρσ_repr(x) {
    var ans, name;
    if (x === null) {
        return "None";
    }
    if (x === undefined) {
        return "undefined";
    }
    ans = x;
    if (typeof x.__repr__ === "function") {
        ans = x.__repr__();
    } else if (x === true || x === false) {
        ans = (x) ? "True" : "False";
    } else if (Array.isArray(x)) {
        ans = ρσ_repr_js_builtin(x, true);
    } else if (typeof x === "function") {
        ans = x.toString();
    } else if (typeof x === "object" && !x.toString) {
        ans = ρσ_repr_js_builtin(x);
    } else {
        name = Object.prototype.toString.call(x).slice(8, -1);
        if (ρσ_not_equals("Int8Array Uint8Array Uint8ClampedArray Int16Array Uint16Array Int32Array Uint32Array Float32Array Float64Array".indexOf(name), -1)) {
            return name + "([" + x.map((function() {
                var ρσ_anonfunc = function (i) {
                    return str.format("0x{:02x}", i);
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["i"]},
                    __module__ : {value: "__main__"}
                });
                return ρσ_anonfunc;
            })()).join(", ") + "])";
        }
        if (typeof HTMLElement !== "undefined" && x instanceof HTMLElement) {
            ans = ρσ_html_element_to_string(x);
        } else {
            ans = (typeof x.toString === "function") ? x.toString() : x;
        }
        if (ans === "[object Object]") {
            return ρσ_repr_js_builtin(x);
        }
        try {
            ans = JSON.stringify(x);
        } catch (ρσ_Exception) {
            ρσ_last_exception = ρσ_Exception;
            {
            } 
        }
    }
    return ans + "";
};
if (!ρσ_repr.__argnames__) Object.defineProperties(ρσ_repr, {
    __argnames__ : {value: ["x"]},
    __module__ : {value: "__main__"}
});

function ρσ_str(x) {
    var ans, name;
    if (x === null) {
        return "None";
    }
    if (x === undefined) {
        return "undefined";
    }
    ans = x;
    if (typeof x.__str__ === "function") {
        ans = x.__str__();
    } else if (typeof x.__repr__ === "function") {
        ans = x.__repr__();
    } else if (x === true || x === false) {
        ans = (x) ? "True" : "False";
    } else if (Array.isArray(x)) {
        ans = ρσ_repr_js_builtin(x, true);
    } else if (typeof x.toString === "function") {
        name = Object.prototype.toString.call(x).slice(8, -1);
        if (ρσ_not_equals("Int8Array Uint8Array Uint8ClampedArray Int16Array Uint16Array Int32Array Uint32Array Float32Array Float64Array".indexOf(name), -1)) {
            return name + "([" + x.map((function() {
                var ρσ_anonfunc = function (i) {
                    return str.format("0x{:02x}", i);
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["i"]},
                    __module__ : {value: "__main__"}
                });
                return ρσ_anonfunc;
            })()).join(", ") + "])";
        }
        if (typeof HTMLElement !== "undefined" && x instanceof HTMLElement) {
            ans = ρσ_html_element_to_string(x);
        } else {
            ans = x.toString();
        }
        if (ans === "[object Object]") {
            ans = ρσ_repr_js_builtin(x);
        }
    } else if (typeof x === "object" && !x.toString) {
        ans = ρσ_repr_js_builtin(x);
    }
    return ans + "";
};
if (!ρσ_str.__argnames__) Object.defineProperties(ρσ_str, {
    __argnames__ : {value: ["x"]},
    __module__ : {value: "__main__"}
});

define_str_func = (function() {
    var ρσ_anonfunc = function (name, func) {
        var f;
        (ρσ_expr_temp = ρσ_str.prototype)[(typeof name === "number" && name < 0) ? ρσ_expr_temp.length + name : name] = func;
        ρσ_str[(typeof name === "number" && name < 0) ? ρσ_str.length + name : name] = f = func.call.bind(func);
        if (func.__argnames__) {
            Object.defineProperty(f, "__argnames__", (function(){
                var ρσ_d = {};
                ρσ_d["value"] = ['string'].concat(func.__argnames__);
                return ρσ_d;
            }).call(this));
        }
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["name", "func"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_unpack = [String.prototype.split.call.bind(String.prototype.split), String.prototype.replace.call.bind(String.prototype.replace)];
ρσ_orig_split = ρσ_unpack[0];
ρσ_orig_replace = ρσ_unpack[1];
define_str_func("format", (function() {
    var ρσ_anonfunc = function () {
        var template, args, kwargs, explicit, implicit, idx, split, ans, pos, in_brace, markup, ch;
        template = this;
        if (template === undefined) {
            throw new TypeError("Template is required");
        }
        args = Array.prototype.slice.call(arguments);
        kwargs = {};
        if (args[args.length-1] && args[args.length-1][ρσ_kwargs_symbol] !== undefined) {
            kwargs = args[args.length-1];
            args = args.slice(0, -1);
        }
        explicit = implicit = false;
        idx = 0;
        split = ρσ_orig_split;
        if (ρσ_str.format._template_resolve_pat === undefined) {
            ρσ_str.format._template_resolve_pat = /[.\[]/;
        }
        function resolve(arg, object) {
            var ρσ_unpack, first, key, rest, ans;
            if (!arg) {
                return object;
            }
            ρσ_unpack = [arg[0], arg.slice(1)];
            first = ρσ_unpack[0];
            arg = ρσ_unpack[1];
            key = split(arg, ρσ_str.format._template_resolve_pat, 1)[0];
            rest = arg.slice(key.length);
            ans = (first === "[") ? object[ρσ_bound_index(key.slice(0, -1), object)] : getattr(object, key);
            if (ans === undefined) {
                throw new KeyError((first === "[") ? key.slice(0, -1) : key);
            }
            return resolve(rest, ans);
        };
        if (!resolve.__argnames__) Object.defineProperties(resolve, {
            __argnames__ : {value: ["arg", "object"]},
            __module__ : {value: "__main__"}
        });

        function resolve_format_spec(format_spec) {
            if (ρσ_str.format._template_resolve_fs_pat === undefined) {
                ρσ_str.format._template_resolve_fs_pat = /[{]([a-zA-Z0-9_]+)[}]/g;
            }
            return format_spec.replace(ρσ_str.format._template_resolve_fs_pat, (function() {
                var ρσ_anonfunc = function (match, key) {
                    if (!Object.prototype.hasOwnProperty.call(kwargs, key)) {
                        return "";
                    }
                    return "" + kwargs[(typeof key === "number" && key < 0) ? kwargs.length + key : key];
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["match", "key"]},
                    __module__ : {value: "__main__"}
                });
                return ρσ_anonfunc;
            })());
        };
        if (!resolve_format_spec.__argnames__) Object.defineProperties(resolve_format_spec, {
            __argnames__ : {value: ["format_spec"]},
            __module__ : {value: "__main__"}
        });

        function set_comma(ans, comma) {
            var sep;
            if (comma !== ",") {
                sep = 1234;
                sep = sep.toLocaleString(undefined, {useGrouping: true})[1];
                ans = str.replace(ans, sep, comma);
            }
            return ans;
        };
        if (!set_comma.__argnames__) Object.defineProperties(set_comma, {
            __argnames__ : {value: ["ans", "comma"]},
            __module__ : {value: "__main__"}
        });

        function safe_comma(value, comma) {
            try {
                return set_comma(value.toLocaleString(undefined, {useGrouping: true}), comma);
            } catch (ρσ_Exception) {
                ρσ_last_exception = ρσ_Exception;
                {
                    return value.toString(10);
                } 
            }
        };
        if (!safe_comma.__argnames__) Object.defineProperties(safe_comma, {
            __argnames__ : {value: ["value", "comma"]},
            __module__ : {value: "__main__"}
        });

        function safe_fixed(value, precision, comma) {
            if (!comma) {
                return value.toFixed(precision);
            }
            try {
                return set_comma(value.toLocaleString(undefined, {useGrouping: true, minimumFractionDigits: precision, maximumFractionDigits: precision}), comma);
            } catch (ρσ_Exception) {
                ρσ_last_exception = ρσ_Exception;
                {
                    return value.toFixed(precision);
                } 
            }
        };
        if (!safe_fixed.__argnames__) Object.defineProperties(safe_fixed, {
            __argnames__ : {value: ["value", "precision", "comma"]},
            __module__ : {value: "__main__"}
        });

        function apply_formatting(value, format_spec) {
            var ρσ_unpack, fill, align, sign, fhash, zeropad, width, comma, precision, ftype, is_numeric, is_int, lftype, code, prec, exp, nval, is_positive, left, right;
            if (format_spec.indexOf("{") !== -1) {
                format_spec = resolve_format_spec(format_spec);
            }
            if (ρσ_str.format._template_format_pat === undefined) {
                ρσ_str.format._template_format_pat = /([^{}](?=[<>=^]))?([<>=^])?([-+\x20])?(\#)?(0)?(\d+)?([,_])?(?:\.(\d+))?([bcdeEfFgGnosxX%])?/;
            }
            try {
                ρσ_unpack = format_spec.match(ρσ_str.format._template_format_pat).slice(1);
ρσ_unpack = ρσ_unpack_asarray(9, ρσ_unpack);
                fill = ρσ_unpack[0];
                align = ρσ_unpack[1];
                sign = ρσ_unpack[2];
                fhash = ρσ_unpack[3];
                zeropad = ρσ_unpack[4];
                width = ρσ_unpack[5];
                comma = ρσ_unpack[6];
                precision = ρσ_unpack[7];
                ftype = ρσ_unpack[8];
            } catch (ρσ_Exception) {
                ρσ_last_exception = ρσ_Exception;
                if (ρσ_Exception instanceof TypeError) {
                    return value;
                } else {
                    throw ρσ_Exception;
                }
            }
            if (zeropad) {
                fill = fill || "0";
                align = align || "=";
            } else {
                fill = fill || " ";
                align = align || ">";
            }
            is_numeric = Number(value) === value;
            is_int = is_numeric && value % 1 === 0;
            precision = parseInt(precision, 10);
            lftype = (ftype || "").toLowerCase();
            if (ftype === "n") {
                is_numeric = true;
                if (is_int) {
                    if (comma) {
                        throw new ValueError("Cannot specify ',' with 'n'");
                    }
                    value = parseInt(value, 10).toLocaleString();
                } else {
                    value = parseFloat(value).toLocaleString();
                }
            } else if (['b', 'c', 'd', 'o', 'x'].indexOf(lftype) !== -1) {
                value = parseInt(value, 10);
                is_numeric = true;
                if (!isNaN(value)) {
                    if (ftype === "b") {
                        value = (value >>> 0).toString(2);
                        if (fhash) {
                            value = "0b" + value;
                        }
                    } else if (ftype === "c") {
                        if (value > 65535) {
                            code = value - 65536;
                            value = String.fromCharCode(55296 + (code >> 10), 56320 + (code & 1023));
                        } else {
                            value = String.fromCharCode(value);
                        }
                    } else if (ftype === "d") {
                        if (comma) {
                            value = safe_comma(value, comma);
                        } else {
                            value = value.toString(10);
                        }
                    } else if (ftype === "o") {
                        value = value.toString(8);
                        if (fhash) {
                            value = "0o" + value;
                        }
                    } else if (lftype === "x") {
                        value = value.toString(16);
                        value = (ftype === "x") ? value.toLowerCase() : value.toUpperCase();
                        if (fhash) {
                            value = "0x" + value;
                        }
                    }
                }
            } else if (['e','f','g','%'].indexOf(lftype) !== -1) {
                is_numeric = true;
                value = parseFloat(value);
                prec = (isNaN(precision)) ? 6 : precision;
                if (lftype === "e") {
                    value = value.toExponential(prec);
                    value = (ftype === "E") ? value.toUpperCase() : value.toLowerCase();
                } else if (lftype === "f") {
                    value = safe_fixed(value, prec, comma);
                    value = (ftype === "F") ? value.toUpperCase() : value.toLowerCase();
                } else if (lftype === "%") {
                    value *= 100;
                    value = safe_fixed(value, prec, comma) + "%";
                } else if (lftype === "g") {
                    prec = max(1, prec);
                    exp = parseInt(split(value.toExponential(prec - 1).toLowerCase(), "e")[1], 10);
                    if (-4 <= exp && exp < prec) {
                        value = safe_fixed(value, prec - 1 - exp, comma);
                    } else {
                        value = value.toExponential(prec - 1);
                    }
                    value = value.replace(/0+$/g, "");
                    if (value[value.length-1] === decimal_sep) {
                        value = value.slice(0, -1);
                    }
                    if (ftype === "G") {
                        value = value.toUpperCase();
                    }
                }
            } else {
                if (comma) {
                    value = parseInt(value, 10);
                    if (isNaN(value)) {
                        throw new ValueError("Must use numbers with , or _");
                    }
                    value = safe_comma(value, comma);
                }
                value += "";
                if (!isNaN(precision)) {
                    value = value.slice(0, precision);
                }
            }
            value += "";
            if (is_numeric && sign) {
                nval = Number(value);
                is_positive = !isNaN(nval) && nval >= 0;
                if (is_positive && (sign === " " || sign === "+")) {
                    value = sign + value;
                }
            }
            function repeat(char, num) {
                return (new Array(num+1)).join(char);
            };
            if (!repeat.__argnames__) Object.defineProperties(repeat, {
                __argnames__ : {value: ["char", "num"]},
                __module__ : {value: "__main__"}
            });

            if (is_numeric && width && width[0] === "0") {
                width = width.slice(1);
                ρσ_unpack = ["0", "="];
                fill = ρσ_unpack[0];
                align = ρσ_unpack[1];
            }
            width = parseInt(width || "-1", 10);
            if (isNaN(width)) {
                throw new ValueError("Invalid width specification: " + width);
            }
            if (fill && value.length < width) {
                if (align === "<") {
                    value = value + repeat(fill, width - value.length);
                } else if (align === ">") {
                    value = repeat(fill, width - value.length) + value;
                } else if (align === "^") {
                    left = Math.floor((width - value.length) / 2);
                    right = width - left - value.length;
                    value = repeat(fill, left) + value + repeat(fill, right);
                } else if (align === "=") {
                    if (ρσ_in(value[0], "+- ")) {
                        value = value[0] + repeat(fill, width - value.length) + value.slice(1);
                    } else {
                        value = repeat(fill, width - value.length) + value;
                    }
                } else {
                    throw new ValueError("Unrecognized alignment: " + align);
                }
            }
            return value;
        };
        if (!apply_formatting.__argnames__) Object.defineProperties(apply_formatting, {
            __argnames__ : {value: ["value", "format_spec"]},
            __module__ : {value: "__main__"}
        });

        function parse_markup(markup) {
            var key, transformer, format_spec, pos, state, ch;
            key = transformer = format_spec = "";
            pos = 0;
            state = 0;
            while (pos < markup.length) {
                ch = markup[(typeof pos === "number" && pos < 0) ? markup.length + pos : pos];
                if (state === 0) {
                    if (ch === "!") {
                        state = 1;
                    } else if (ch === ":") {
                        state = 2;
                    } else {
                        key += ch;
                    }
                } else if (state === 1) {
                    if (ch === ":") {
                        state = 2;
                    } else {
                        transformer += ch;
                    }
                } else {
                    format_spec += ch;
                }
                pos += 1;
            }
            return [key, transformer, format_spec];
        };
        if (!parse_markup.__argnames__) Object.defineProperties(parse_markup, {
            __argnames__ : {value: ["markup"]},
            __module__ : {value: "__main__"}
        });

        function render_markup(markup) {
            var ρσ_unpack, key, transformer, format_spec, ends_with_equal, lkey, nvalue, object, ans;
            ρσ_unpack = parse_markup(markup);
ρσ_unpack = ρσ_unpack_asarray(3, ρσ_unpack);
            key = ρσ_unpack[0];
            transformer = ρσ_unpack[1];
            format_spec = ρσ_unpack[2];
            if (transformer && ['a', 'r', 's'].indexOf(transformer) === -1) {
                throw new ValueError("Unknown conversion specifier: " + transformer);
            }
            ends_with_equal = key.endsWith("=");
            if (ends_with_equal) {
                key = key.slice(0, -1);
            }
            lkey = key.length && split(key, /[.\[]/, 1)[0];
            if (lkey) {
                explicit = true;
                if (implicit) {
                    throw new ValueError("cannot switch from automatic field numbering to manual field specification");
                }
                nvalue = parseInt(lkey);
                object = (isNaN(nvalue)) ? kwargs[(typeof lkey === "number" && lkey < 0) ? kwargs.length + lkey : lkey] : args[(typeof nvalue === "number" && nvalue < 0) ? args.length + nvalue : nvalue];
                if (object === undefined) {
                    if (isNaN(nvalue)) {
                        throw new KeyError(lkey);
                    }
                    throw new IndexError(lkey);
                }
                object = resolve(key.slice(lkey.length), object);
            } else {
                implicit = true;
                if (explicit) {
                    throw new ValueError("cannot switch from manual field specification to automatic field numbering");
                }
                if (idx >= args.length) {
                    throw new IndexError("Not enough arguments to match template: " + template);
                }
                object = args[(typeof idx === "number" && idx < 0) ? args.length + idx : idx];
                idx += 1;
            }
            if (typeof object === "function") {
                object = object();
            }
            ans = "" + object;
            if (format_spec) {
                ans = apply_formatting(ans, format_spec);
            }
            if (ends_with_equal) {
                ans = "" + ρσ_str.format("{}", key) + "=" + ρσ_str.format("{}", ans) + "";
            }
            return ans;
        };
        if (!render_markup.__argnames__) Object.defineProperties(render_markup, {
            __argnames__ : {value: ["markup"]},
            __module__ : {value: "__main__"}
        });

        ans = "";
        pos = 0;
        in_brace = 0;
        markup = "";
        while (pos < template.length) {
            ch = template[(typeof pos === "number" && pos < 0) ? template.length + pos : pos];
            if (in_brace) {
                if (ch === "{") {
                    in_brace += 1;
                    markup += "{";
                } else if (ch === "}") {
                    in_brace -= 1;
                    if (in_brace > 0) {
                        markup += "}";
                    } else {
                        ans += render_markup(markup);
                    }
                } else {
                    markup += ch;
                }
            } else {
                if (ch === "{") {
                    if (template[ρσ_bound_index(pos + 1, template)] === "{") {
                        pos += 1;
                        ans += "{";
                    } else {
                        in_brace = 1;
                        markup = "";
                    }
                } else {
                    ans += ch;
                    if (ch === "}" && template[ρσ_bound_index(pos + 1, template)] === "}") {
                        pos += 1;
                    }
                }
            }
            pos += 1;
        }
        if (in_brace) {
            throw new ValueError("expected '}' before end of string");
        }
        return ans;
    };
    if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})());
define_str_func("capitalize", (function() {
    var ρσ_anonfunc = function () {
        var string;
        string = this;
        if (string) {
            string = string[0].toUpperCase() + string.slice(1).toLowerCase();
        }
        return string;
    };
    if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})());
define_str_func("center", (function() {
    var ρσ_anonfunc = function (width, fill) {
        var left, right;
        left = Math.floor((width - this.length) / 2);
        right = width - left - this.length;
        fill = fill || " ";
        return new Array(left+1).join(fill) + this + new Array(right+1).join(fill);
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["width", "fill"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})());
define_str_func("count", (function() {
    var ρσ_anonfunc = function (needle, start, end) {
        var string, ρσ_unpack, pos, step, ans;
        string = this;
        start = start || 0;
        end = end || string.length;
        if (start < 0 || end < 0) {
            string = string.slice(start, end);
            ρσ_unpack = [0, string.length];
            start = ρσ_unpack[0];
            end = ρσ_unpack[1];
        }
        pos = start;
        step = needle.length;
        if (!step) {
            return 0;
        }
        ans = 0;
        while (pos !== -1) {
            pos = string.indexOf(needle, pos);
            if (pos !== -1) {
                ans += 1;
                pos += step;
            }
        }
        return ans;
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["needle", "start", "end"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})());
define_str_func("endswith", (function() {
    var ρσ_anonfunc = function (suffixes, start, end) {
        var string, q;
        string = this;
        start = start || 0;
        if (typeof suffixes === "string") {
            suffixes = [suffixes];
        }
        if (end !== undefined) {
            string = string.slice(0, end);
        }
        for (var i = 0; i < suffixes.length; i++) {
            q = suffixes[(typeof i === "number" && i < 0) ? suffixes.length + i : i];
            if (string.indexOf(q, Math.max(start, string.length - q.length)) !== -1) {
                return true;
            }
        }
        return false;
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["suffixes", "start", "end"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})());
define_str_func("startswith", (function() {
    var ρσ_anonfunc = function (prefixes, start, end) {
        var prefix;
        start = start || 0;
        if (typeof prefixes === "string") {
            prefixes = [prefixes];
        }
        for (var i = 0; i < prefixes.length; i++) {
            prefix = prefixes[(typeof i === "number" && i < 0) ? prefixes.length + i : i];
            end = (end === undefined) ? this.length : end;
            if (end - start >= prefix.length && prefix === this.slice(start, start + prefix.length)) {
                return true;
            }
        }
        return false;
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["prefixes", "start", "end"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})());
define_str_func("find", (function() {
    var ρσ_anonfunc = function (needle, start, end) {
        var ans;
        while (start < 0) {
            start += this.length;
        }
        ans = this.indexOf(needle, start);
        if (end !== undefined && ans !== -1) {
            while (end < 0) {
                end += this.length;
            }
            if (ans >= end - needle.length) {
                return -1;
            }
        }
        return ans;
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["needle", "start", "end"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})());
define_str_func("rfind", (function() {
    var ρσ_anonfunc = function (needle, start, end) {
        var ans;
        while (end < 0) {
            end += this.length;
        }
        ans = this.lastIndexOf(needle, end - 1);
        if (start !== undefined && ans !== -1) {
            while (start < 0) {
                start += this.length;
            }
            if (ans < start) {
                return -1;
            }
        }
        return ans;
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["needle", "start", "end"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})());
define_str_func("index", (function() {
    var ρσ_anonfunc = function (needle, start, end) {
        var ans;
        ans = ρσ_str.prototype.find.apply(this, arguments);
        if (ans === -1) {
            throw new ValueError("substring not found");
        }
        return ans;
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["needle", "start", "end"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})());
define_str_func("rindex", (function() {
    var ρσ_anonfunc = function (needle, start, end) {
        var ans;
        ans = ρσ_str.prototype.rfind.apply(this, arguments);
        if (ans === -1) {
            throw new ValueError("substring not found");
        }
        return ans;
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["needle", "start", "end"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})());
define_str_func("islower", (function() {
    var ρσ_anonfunc = function () {
        return this.length > 0 && this.toLowerCase() === this.toString();
    };
    if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})());
define_str_func("isupper", (function() {
    var ρσ_anonfunc = function () {
        return this.length > 0 && this.toUpperCase() === this.toString();
    };
    if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})());
define_str_func("isspace", (function() {
    var ρσ_anonfunc = function () {
        return this.length > 0 && /^\s+$/.test(this);
    };
    if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})());
define_str_func("join", (function() {
    var ρσ_anonfunc = function (iterable) {
        var ans, r;
        if (Array.isArray(iterable)) {
            return iterable.join(this);
        }
        ans = "";
        r = iterable.next();
        while (!r.done) {
            if (ans) {
                ans += this;
            }
            ans += r.value;
            r = iterable.next();
        }
        return ans;
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["iterable"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})());
define_str_func("ljust", (function() {
    var ρσ_anonfunc = function (width, fill) {
        var string;
        string = this;
        if (width > string.length) {
            fill = fill || " ";
            string += new Array(width - string.length + 1).join(fill);
        }
        return string;
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["width", "fill"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})());
define_str_func("rjust", (function() {
    var ρσ_anonfunc = function (width, fill) {
        var string;
        string = this;
        if (width > string.length) {
            fill = fill || " ";
            string = new Array(width - string.length + 1).join(fill) + string;
        }
        return string;
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["width", "fill"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})());
define_str_func("lower", (function() {
    var ρσ_anonfunc = function () {
        return this.toLowerCase();
    };
    if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})());
define_str_func("upper", (function() {
    var ρσ_anonfunc = function () {
        return this.toUpperCase();
    };
    if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})());
define_str_func("lstrip", (function() {
    var ρσ_anonfunc = function (chars) {
        var string, pos;
        string = this;
        pos = 0;
        chars = chars || ρσ_str.whitespace;
        while (chars.indexOf(string[(typeof pos === "number" && pos < 0) ? string.length + pos : pos]) !== -1) {
            pos += 1;
        }
        if (pos) {
            string = string.slice(pos);
        }
        return string;
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["chars"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})());
define_str_func("rstrip", (function() {
    var ρσ_anonfunc = function (chars) {
        var string, pos;
        string = this;
        pos = string.length - 1;
        chars = chars || ρσ_str.whitespace;
        while (chars.indexOf(string[(typeof pos === "number" && pos < 0) ? string.length + pos : pos]) !== -1) {
            pos -= 1;
        }
        if (pos < string.length - 1) {
            string = string.slice(0, pos + 1);
        }
        return string;
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["chars"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})());
define_str_func("strip", (function() {
    var ρσ_anonfunc = function (chars) {
        return ρσ_str.prototype.lstrip.call(ρσ_str.prototype.rstrip.call(this, chars), chars);
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["chars"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})());
define_str_func("partition", (function() {
    var ρσ_anonfunc = function (sep) {
        var idx;
        idx = this.indexOf(sep);
        if (idx === -1) {
            return [this, "", ""];
        }
        return [this.slice(0, idx), sep, this.slice(idx + sep.length)];
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["sep"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})());
define_str_func("rpartition", (function() {
    var ρσ_anonfunc = function (sep) {
        var idx;
        idx = this.lastIndexOf(sep);
        if (idx === -1) {
            return ["", "", this];
        }
        return [this.slice(0, idx), sep, this.slice(idx + sep.length)];
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["sep"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})());
define_str_func("replace", (function() {
    var ρσ_anonfunc = function (old, repl, count) {
        var string, pos, idx;
        string = this;
        if (count === 1) {
            return ρσ_orig_replace(string, old, repl);
        }
        if (count < 1) {
            return string;
        }
        count = count || Number.MAX_VALUE;
        pos = 0;
        while (count > 0) {
            count -= 1;
            idx = string.indexOf(old, pos);
            if (idx === -1) {
                break;
            }
            pos = idx + repl.length;
            string = string.slice(0, idx) + repl + string.slice(idx + old.length);
        }
        return string;
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["old", "repl", "count"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})());
define_str_func("split", (function() {
    var ρσ_anonfunc = function (sep, maxsplit) {
        var split, ans, extra, parts;
        if (maxsplit === 0) {
            return ρσ_list_decorate([ this ]);
        }
        split = ρσ_orig_split;
        if (sep === undefined || sep === null) {
            if (maxsplit > 0) {
                ans = split(this, /(\s+)/);
                extra = "";
                parts = [];
                for (var i = 0; i < ans.length; i++) {
                    if (parts.length >= maxsplit + 1) {
                        extra += ans[(typeof i === "number" && i < 0) ? ans.length + i : i];
                    } else if (i % 2 === 0) {
                        parts.push(ans[(typeof i === "number" && i < 0) ? ans.length + i : i]);
                    }
                }
                parts[parts.length-1] += extra;
                ans = parts;
            } else {
                ans = split(this, /\s+/);
            }
        } else {
            if (sep === "") {
                throw new ValueError("empty separator");
            }
            ans = split(this, sep);
            if (maxsplit > 0 && ans.length > maxsplit) {
                extra = ans.slice(maxsplit).join(sep);
                ans = ans.slice(0, maxsplit);
                ans.push(extra);
            }
        }
        return ρσ_list_decorate(ans);
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["sep", "maxsplit"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})());
define_str_func("rsplit", (function() {
    var ρσ_anonfunc = function (sep, maxsplit) {
        var split, ans, is_space, pos, current, spc, ch, end, idx;
        if (!maxsplit) {
            return ρσ_str.prototype.split.call(this, sep);
        }
        split = ρσ_orig_split;
        if (sep === undefined || sep === null) {
            if (maxsplit > 0) {
                ans = [];
                is_space = /\s/;
                pos = this.length - 1;
                current = "";
                while (pos > -1 && maxsplit > 0) {
                    spc = false;
                    ch = (ρσ_expr_temp = this)[(typeof pos === "number" && pos < 0) ? ρσ_expr_temp.length + pos : pos];
                    while (pos > -1 && is_space.test(ch)) {
                        spc = true;
                        ch = this[--pos];
                    }
                    if (spc) {
                        if (current) {
                            ans.push(current);
                            maxsplit -= 1;
                        }
                        current = ch;
                    } else {
                        current += ch;
                    }
                    pos -= 1;
                }
                ans.push(this.slice(0, pos + 1) + current);
                ans.reverse();
            } else {
                ans = split(this, /\s+/);
            }
        } else {
            if (sep === "") {
                throw new ValueError("empty separator");
            }
            ans = [];
            pos = end = this.length;
            while (pos > -1 && maxsplit > 0) {
                maxsplit -= 1;
                idx = this.lastIndexOf(sep, pos);
                if (idx === -1) {
                    break;
                }
                ans.push(this.slice(idx + sep.length, end));
                pos = idx - 1;
                end = idx;
            }
            ans.push(this.slice(0, end));
            ans.reverse();
        }
        return ρσ_list_decorate(ans);
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["sep", "maxsplit"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})());
define_str_func("splitlines", (function() {
    var ρσ_anonfunc = function (keepends) {
        var split, parts, ans;
        split = ρσ_orig_split;
        if (keepends) {
            parts = split(this, /((?:\r?\n)|\r)/);
            ans = [];
            for (var i = 0; i < parts.length; i++) {
                if (i % 2 === 0) {
                    ans.push(parts[(typeof i === "number" && i < 0) ? parts.length + i : i]);
                } else {
                    ans[ans.length-1] += parts[(typeof i === "number" && i < 0) ? parts.length + i : i];
                }
            }
        } else {
            ans = split(this, /(?:\r?\n)|\r/);
        }
        return ρσ_list_decorate(ans);
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["keepends"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})());
define_str_func("swapcase", (function() {
    var ρσ_anonfunc = function () {
        var ans, a, b;
        ans = new Array(this.length);
        for (var i = 0; i < ans.length; i++) {
            a = (ρσ_expr_temp = this)[(typeof i === "number" && i < 0) ? ρσ_expr_temp.length + i : i];
            b = a.toLowerCase();
            if (a === b) {
                b = a.toUpperCase();
            }
            ans[(typeof i === "number" && i < 0) ? ans.length + i : i] = b;
        }
        return ans.join("");
    };
    if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})());
define_str_func("zfill", (function() {
    var ρσ_anonfunc = function (width) {
        var string;
        string = this;
        if (width > string.length) {
            string = new Array(width - string.length + 1).join("0") + string;
        }
        return string;
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["width"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})());
ρσ_str.uchrs = (function() {
    var ρσ_anonfunc = function (string, with_positions) {
        return (function(){
            var ρσ_d = {};
            ρσ_d["_string"] = string;
            ρσ_d["_pos"] = 0;
            ρσ_d[ρσ_iterator_symbol] = (function() {
                var ρσ_anonfunc = function () {
                    return this;
                };
                if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
                    __module__ : {value: "__main__"}
                });
                return ρσ_anonfunc;
            })();
            ρσ_d["next"] = (function() {
                var ρσ_anonfunc = function () {
                    var length, pos, value, ans, extra;
                    length = this._string.length;
                    if (this._pos >= length) {
                        return (function(){
                            var ρσ_d = {};
                            ρσ_d["done"] = true;
                            return ρσ_d;
                        }).call(this);
                    }
                    pos = this._pos;
                    value = this._string.charCodeAt(this._pos++);
                    ans = "\ufffd";
                    if (55296 <= value && value <= 56319) {
                        if (this._pos < length) {
                            extra = this._string.charCodeAt(this._pos++);
                            if ((extra & 56320) === 56320) {
                                ans = String.fromCharCode(value, extra);
                            }
                        }
                    } else if ((value & 56320) !== 56320) {
                        ans = String.fromCharCode(value);
                    }
                    if (with_positions) {
                        return (function(){
                            var ρσ_d = {};
                            ρσ_d["done"] = false;
                            ρσ_d["value"] = ρσ_list_decorate([ pos, ans ]);
                            return ρσ_d;
                        }).call(this);
                    } else {
                        return (function(){
                            var ρσ_d = {};
                            ρσ_d["done"] = false;
                            ρσ_d["value"] = ans;
                            return ρσ_d;
                        }).call(this);
                    }
                };
                if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
                    __module__ : {value: "__main__"}
                });
                return ρσ_anonfunc;
            })();
            return ρσ_d;
        }).call(this);
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["string", "with_positions"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_str.uslice = (function() {
    var ρσ_anonfunc = function (string, start, end) {
        var items, iterator, r;
        items = [];
        iterator = ρσ_str.uchrs(string);
        r = iterator.next();
        while (!r.done) {
            items.push(r.value);
            r = iterator.next();
        }
        return items.slice(start || 0, (end === undefined) ? items.length : end).join("");
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["string", "start", "end"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_str.ulen = (function() {
    var ρσ_anonfunc = function (string) {
        var iterator, r, ans;
        iterator = ρσ_str.uchrs(string);
        r = iterator.next();
        ans = 0;
        while (!r.done) {
            r = iterator.next();
            ans += 1;
        }
        return ans;
    };
    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
        __argnames__ : {value: ["string"]},
        __module__ : {value: "__main__"}
    });
    return ρσ_anonfunc;
})();
ρσ_str.ascii_lowercase = "abcdefghijklmnopqrstuvwxyz";
ρσ_str.ascii_uppercase = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
ρσ_str.ascii_letters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
ρσ_str.digits = "0123456789";
ρσ_str.punctuation = "!\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~";
ρσ_str.printable = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ!\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~ \t\n\r\u000b\f";
ρσ_str.whitespace = " \t\n\r\u000b\f";
define_str_func = undefined;
var str = ρσ_str, repr = ρσ_repr;;
    var ρσ_modules = {};
    ρσ_modules.elementmaker = {};
    ρσ_modules.pythonize = {};
    ρσ_modules.initialize = {};
    ρσ_modules.traceback = {};
    ρσ_modules.gettext = {};
    ρσ_modules.ajax = {};
    ρσ_modules.book_list = {};
    ρσ_modules["book_list.globals"] = {};
    ρσ_modules.lru_cache = {};
    ρσ_modules.encodings = {};
    ρσ_modules.uuid = {};
    ρσ_modules.session = {};
    ρσ_modules["book_list.theme"] = {};
    ρσ_modules.utils = {};
    ρσ_modules["book_list.library_data"] = {};
    ρσ_modules.date = {};
    ρσ_modules.dom = {};
    ρσ_modules.popups = {};
    ρσ_modules.widgets = {};
    ρσ_modules.modals = {};
    ρσ_modules.qt = {};
    ρσ_modules.read_book = {};
    ρσ_modules["book_list.constants"] = {};
    ρσ_modules["book_list.router"] = {};
    ρσ_modules.aes = {};
    ρσ_modules["read_book.globals"] = {};
    ρσ_modules["read_book.viewport"] = {};
    ρσ_modules["read_book.cfi"] = {};
    ρσ_modules["read_book.annotations"] = {};
    ρσ_modules["read_book.db"] = {};
    ρσ_modules.iframe_comm = {};
    ρσ_modules["read_book.settings"] = {};
    ρσ_modules["read_book.resources"] = {};
    ρσ_modules["read_book.footnotes"] = {};
    ρσ_modules.fs_images = {};
    ρσ_modules.range_utils = {};
    ρσ_modules["read_book.extract"] = {};
    ρσ_modules["read_book.find"] = {};
    ρσ_modules["read_book.flow_mode"] = {};
    ρσ_modules.complete = {};
    ρσ_modules["read_book.highlights"] = {};
    ρσ_modules["read_book.shortcuts"] = {};
    ρσ_modules["read_book.hints"] = {};
    ρσ_modules["read_book.mathjax"] = {};
    ρσ_modules["read_book.paged_mode"] = {};
    ρσ_modules["read_book.referencing"] = {};
    ρσ_modules["read_book.toc"] = {};
    ρσ_modules["read_book.touch"] = {};
    ρσ_modules.select = {};
    ρσ_modules["read_book.iframe"] = {};
    ρσ_modules["book_list.item_list"] = {};
    ρσ_modules["read_book.open_book"] = {};
    ρσ_modules["read_book.prefs"] = {};
    ρσ_modules["read_book.prefs.utils"] = {};
    ρσ_modules["read_book.prefs.head_foot"] = {};
    ρσ_modules["book_list.cover_grid"] = {};
    ρσ_modules["book_list.top_bar"] = {};
    ρσ_modules["book_list.ui"] = {};
    ρσ_modules["book_list.home"] = {};
    ρσ_modules["read_book.bookmarks"] = {};
    ρσ_modules["read_book.content_popup"] = {};
    ρσ_modules["read_book.goto"] = {};
    ρσ_modules.file_uploads = {};
    ρσ_modules["book_list.add"] = {};
    ρσ_modules["book_list.delete_book"] = {};
    ρσ_modules["book_list.details_list"] = {};
    ρσ_modules["book_list.custom_list"] = {};
    ρσ_modules["book_list.prefs"] = {};
    ρσ_modules["book_list.search"] = {};
    ρσ_modules["book_list.views"] = {};
    ρσ_modules["book_list.book_details"] = {};
    ρσ_modules["read_book.prefs.font_size"] = {};
    ρσ_modules["read_book.prefs.colors"] = {};
    ρσ_modules["read_book.prefs.fonts"] = {};
    ρσ_modules["read_book.prefs.keyboard"] = {};
    ρσ_modules["read_book.prefs.layout"] = {};
    ρσ_modules["read_book.prefs.misc"] = {};
    ρσ_modules["read_book.prefs.scrolling"] = {};
    ρσ_modules["read_book.selection_bar"] = {};
    ρσ_modules["read_book.prefs.selection"] = {};
    ρσ_modules.viewer = {};
    ρσ_modules["viewer.constants"] = {};
    ρσ_modules["read_book.prefs.user_stylesheet"] = {};
    ρσ_modules["read_book.prefs.main"] = {};
    ρσ_modules["read_book.word_actions"] = {};
    ρσ_modules["read_book.overlay"] = {};
    ρσ_modules["read_book.read_aloud"] = {};
    ρσ_modules["read_book.scrollbar"] = {};
    ρσ_modules["read_book.search_worker"] = {};
    ρσ_modules.worker = {};
    ρσ_modules["read_book.search"] = {};
    ρσ_modules["read_book.timers"] = {};
    ρσ_modules["read_book.view"] = {};

    (function(){
        var __name__ = "elementmaker";
        var html_elements, mathml_elements, svg_elements, html5_tags, E;
        html_elements = (function(){
            var s = ρσ_set();
            s.jsset.add("a");
            s.jsset.add("abbr");
            s.jsset.add("acronym");
            s.jsset.add("address");
            s.jsset.add("area");
            s.jsset.add("article");
            s.jsset.add("aside");
            s.jsset.add("audio");
            s.jsset.add("b");
            s.jsset.add("base");
            s.jsset.add("big");
            s.jsset.add("body");
            s.jsset.add("blockquote");
            s.jsset.add("br");
            s.jsset.add("button");
            s.jsset.add("canvas");
            s.jsset.add("caption");
            s.jsset.add("center");
            s.jsset.add("cite");
            s.jsset.add("code");
            s.jsset.add("col");
            s.jsset.add("colgroup");
            s.jsset.add("command");
            s.jsset.add("datagrid");
            s.jsset.add("datalist");
            s.jsset.add("dd");
            s.jsset.add("del");
            s.jsset.add("details");
            s.jsset.add("dfn");
            s.jsset.add("dialog");
            s.jsset.add("dir");
            s.jsset.add("div");
            s.jsset.add("dl");
            s.jsset.add("dt");
            s.jsset.add("em");
            s.jsset.add("event-source");
            s.jsset.add("fieldset");
            s.jsset.add("figcaption");
            s.jsset.add("figure");
            s.jsset.add("footer");
            s.jsset.add("font");
            s.jsset.add("form");
            s.jsset.add("header");
            s.jsset.add("h1");
            s.jsset.add("h2");
            s.jsset.add("h3");
            s.jsset.add("h4");
            s.jsset.add("h5");
            s.jsset.add("h6");
            s.jsset.add("hr");
            s.jsset.add("head");
            s.jsset.add("i");
            s.jsset.add("iframe");
            s.jsset.add("img");
            s.jsset.add("input");
            s.jsset.add("ins");
            s.jsset.add("keygen");
            s.jsset.add("kbd");
            s.jsset.add("label");
            s.jsset.add("legend");
            s.jsset.add("li");
            s.jsset.add("m");
            s.jsset.add("map");
            s.jsset.add("menu");
            s.jsset.add("meter");
            s.jsset.add("multicol");
            s.jsset.add("nav");
            s.jsset.add("nextid");
            s.jsset.add("ol");
            s.jsset.add("output");
            s.jsset.add("optgroup");
            s.jsset.add("option");
            s.jsset.add("p");
            s.jsset.add("pre");
            s.jsset.add("progress");
            s.jsset.add("q");
            s.jsset.add("s");
            s.jsset.add("samp");
            s.jsset.add("script");
            s.jsset.add("section");
            s.jsset.add("select");
            s.jsset.add("small");
            s.jsset.add("sound");
            s.jsset.add("source");
            s.jsset.add("spacer");
            s.jsset.add("span");
            s.jsset.add("strike");
            s.jsset.add("strong");
            s.jsset.add("style");
            s.jsset.add("sub");
            s.jsset.add("sup");
            s.jsset.add("table");
            s.jsset.add("tbody");
            s.jsset.add("td");
            s.jsset.add("textarea");
            s.jsset.add("time");
            s.jsset.add("tfoot");
            s.jsset.add("th");
            s.jsset.add("thead");
            s.jsset.add("tr");
            s.jsset.add("tt");
            s.jsset.add("u");
            s.jsset.add("ul");
            s.jsset.add("var");
            s.jsset.add("video");
            return s;
        })();
        mathml_elements = (function(){
            var s = ρσ_set();
            s.jsset.add("maction");
            s.jsset.add("math");
            s.jsset.add("merror");
            s.jsset.add("mfrac");
            s.jsset.add("mi");
            s.jsset.add("mmultiscripts");
            s.jsset.add("mn");
            s.jsset.add("mo");
            s.jsset.add("mover");
            s.jsset.add("mpadded");
            s.jsset.add("mphantom");
            s.jsset.add("mprescripts");
            s.jsset.add("mroot");
            s.jsset.add("mrow");
            s.jsset.add("mspace");
            s.jsset.add("msqrt");
            s.jsset.add("mstyle");
            s.jsset.add("msub");
            s.jsset.add("msubsup");
            s.jsset.add("msup");
            s.jsset.add("mtable");
            s.jsset.add("mtd");
            s.jsset.add("mtext");
            s.jsset.add("mtr");
            s.jsset.add("munder");
            s.jsset.add("munderover");
            s.jsset.add("none");
            return s;
        })();
        svg_elements = (function(){
            var s = ρσ_set();
            s.jsset.add("a");
            s.jsset.add("animate");
            s.jsset.add("animateColor");
            s.jsset.add("animateMotion");
            s.jsset.add("animateTransform");
            s.jsset.add("clipPath");
            s.jsset.add("circle");
            s.jsset.add("defs");
            s.jsset.add("desc");
            s.jsset.add("ellipse");
            s.jsset.add("font-face");
            s.jsset.add("font-face-name");
            s.jsset.add("font-face-src");
            s.jsset.add("g");
            s.jsset.add("glyph");
            s.jsset.add("hkern");
            s.jsset.add("linearGradient");
            s.jsset.add("line");
            s.jsset.add("marker");
            s.jsset.add("metadata");
            s.jsset.add("missing-glyph");
            s.jsset.add("mpath");
            s.jsset.add("path");
            s.jsset.add("polygon");
            s.jsset.add("polyline");
            s.jsset.add("radialGradient");
            s.jsset.add("rect");
            s.jsset.add("set");
            s.jsset.add("stop");
            s.jsset.add("svg");
            s.jsset.add("switch");
            s.jsset.add("text");
            s.jsset.add("title");
            s.jsset.add("tspan");
            s.jsset.add("use");
            return s;
        })();
        html5_tags = html_elements.union(mathml_elements).union(svg_elements);
        function _makeelement() {
            var tag = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[0];
            var kwargs = arguments[arguments.length-1];
            if (kwargs === null || typeof kwargs !== "object" || kwargs [ρσ_kwargs_symbol] !== true) kwargs = {};
            var args = Array.prototype.slice.call(arguments, 1);
            if (kwargs !== null && typeof kwargs === "object" && kwargs [ρσ_kwargs_symbol] === true) args.pop();
            var ans, vattr, val, attr, arg;
            ans = this.createElement(tag);
            var ρσ_Iter0 = ρσ_Iterable(kwargs);
            for (var ρσ_Index0 = 0; ρσ_Index0 < ρσ_Iter0.length; ρσ_Index0++) {
                attr = ρσ_Iter0[ρσ_Index0];
                vattr = str.replace(str.rstrip(attr, "_"), "_", "-");
                val = kwargs[(typeof attr === "number" && attr < 0) ? kwargs.length + attr : attr];
                if (callable(val)) {
                    if (str.startswith(attr, "on")) {
                        attr = attr.slice(2);
                    }
                    ans.addEventListener(attr, val);
                } else if (val === true) {
                    ans.setAttribute(vattr, vattr);
                } else if (typeof val === "string") {
                    ans.setAttribute(vattr, val);
                }
            }
            var ρσ_Iter1 = ρσ_Iterable(args);
            for (var ρσ_Index1 = 0; ρσ_Index1 < ρσ_Iter1.length; ρσ_Index1++) {
                arg = ρσ_Iter1[ρσ_Index1];
                if (typeof arg === "string") {
                    arg = this.createTextNode(arg);
                }
                ans.appendChild(arg);
            }
            return ans;
        };
        if (!_makeelement.__handles_kwarg_interpolation__) Object.defineProperties(_makeelement, {
            __handles_kwarg_interpolation__ : {value: true},
            __argnames__ : {value: ["tag"]},
            __module__ : {value: "elementmaker"}
        });

        function maker_for_document(document) {
            var E;
            E = _makeelement.bind(document);
            Object.defineProperties(E, (function() {
                var ρσ_Iter = ρσ_Iterable(html5_tags), ρσ_Result = {}, tag;
                for (var ρσ_Index = 0; ρσ_Index < ρσ_Iter.length; ρσ_Index++) {
                    tag = ρσ_Iter[ρσ_Index];
                    ρσ_Result[tag] = ((function(){
                        var ρσ_d = {};
                        ρσ_d["value"] = _makeelement.bind(document, tag);
                        return ρσ_d;
                    }).call(this));
                }
                return ρσ_Result;
            })());
            return E;
        };
        if (!maker_for_document.__argnames__) Object.defineProperties(maker_for_document, {
            __argnames__ : {value: ["document"]},
            __module__ : {value: "elementmaker"}
        });

        if (typeof document === "undefined") {
            E = maker_for_document((function(){
                var ρσ_d = {};
                ρσ_d["createTextNode"] = (function() {
                    var ρσ_anonfunc = function (value) {
                        return value;
                    };
                    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                        __argnames__ : {value: ["value"]},
                        __module__ : {value: "elementmaker"}
                    });
                    return ρσ_anonfunc;
                })();
                ρσ_d["createElement"] = (function() {
                    var ρσ_anonfunc = function (name) {
                        return (function(){
                            var ρσ_d = {};
                            ρσ_d["name"] = name;
                            ρσ_d["children"] = ρσ_list_decorate([]);
                            ρσ_d["attributes"] = {};
                            ρσ_d["setAttribute"] = (function() {
                                var ρσ_anonfunc = function (name, val) {
                                    (ρσ_expr_temp = this.attributes)[(typeof name === "number" && name < 0) ? ρσ_expr_temp.length + name : name] = val;
                                };
                                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                                    __argnames__ : {value: ["name", "val"]},
                                    __module__ : {value: "elementmaker"}
                                });
                                return ρσ_anonfunc;
                            })();
                            ρσ_d["appendChild"] = (function() {
                                var ρσ_anonfunc = function (child) {
                                    this.children.push(child);
                                };
                                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                                    __argnames__ : {value: ["child"]},
                                    __module__ : {value: "elementmaker"}
                                });
                                return ρσ_anonfunc;
                            })();
                            return ρσ_d;
                        }).call(this);
                    };
                    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                        __argnames__ : {value: ["name"]},
                        __module__ : {value: "elementmaker"}
                    });
                    return ρσ_anonfunc;
                })();
                return ρσ_d;
            }).call(this));
        } else {
            E = maker_for_document(document);
        }
        ρσ_modules.elementmaker.html_elements = html_elements;
        ρσ_modules.elementmaker.mathml_elements = mathml_elements;
        ρσ_modules.elementmaker.svg_elements = svg_elements;
        ρσ_modules.elementmaker.html5_tags = html5_tags;
        ρσ_modules.elementmaker.E = E;
        ρσ_modules.elementmaker._makeelement = _makeelement;
        ρσ_modules.elementmaker.maker_for_document = maker_for_document;
    })();

    (function(){
        var __name__ = "pythonize";
        function strings() {
            var string_funcs, exclude, name;
            string_funcs = set("capitalize strip lstrip rstrip islower isupper isspace lower upper swapcase center count endswith startswith find rfind index rindex format join ljust rjust partition rpartition replace split rsplit splitlines zfill".split(" "));
            if (!arguments.length) {
                exclude = (function(){
                    var s = ρσ_set();
                    s.jsset.add("split");
                    s.jsset.add("replace");
                    return s;
                })();
            } else if (arguments[0]) {
                exclude = Array.prototype.slice.call(arguments);
            } else {
                exclude = null;
            }
            if (exclude) {
                string_funcs = string_funcs.difference(set(exclude));
            }
            var ρσ_Iter0 = ρσ_Iterable(string_funcs);
            for (var ρσ_Index0 = 0; ρσ_Index0 < ρσ_Iter0.length; ρσ_Index0++) {
                name = ρσ_Iter0[ρσ_Index0];
                (ρσ_expr_temp = String.prototype)[(typeof name === "number" && name < 0) ? ρσ_expr_temp.length + name : name] = (ρσ_expr_temp = ρσ_str.prototype)[(typeof name === "number" && name < 0) ? ρσ_expr_temp.length + name : name];
            }
        };
        if (!strings.__module__) Object.defineProperties(strings, {
            __module__ : {value: "pythonize"}
        });

        ρσ_modules.pythonize.strings = strings;
    })();

    (function(){
        var __name__ = "initialize";
        var strings = ρσ_modules.pythonize.strings;

        strings();
    })();

    (function(){
        var __name__ = "traceback";
        function _get_internal_traceback(err) {
            var lines, final_lines, found_sentinel, sline, ρσ_unpack, i, line;
            if (ρσ_instanceof(err, Exception) && err.stack) {
                lines = ρσ_str.splitlines(err.stack);
                final_lines = [];
                found_sentinel = false;
                var ρσ_Iter0 = ρσ_Iterable(enumerate(lines));
                for (var ρσ_Index0 = 0; ρσ_Index0 < ρσ_Iter0.length; ρσ_Index0++) {
                    ρσ_unpack = ρσ_Iter0[ρσ_Index0];
                    i = ρσ_unpack[0];
                    line = ρσ_unpack[1];
                    sline = ρσ_str.strip(line);
                    if (i === 0) {
                        final_lines.push(line);
                        continue;
                    }
                    if (found_sentinel) {
                        final_lines.push(line);
                        continue;
                    }
                    if (sline.startsWith("at new " + err.name) || sline.startsWith(err.name + "@")) {
                        found_sentinel = true;
                    }
                }
                return final_lines.join("\n");
            }
            return err && err.stack;
        };
        if (!_get_internal_traceback.__argnames__) Object.defineProperties(_get_internal_traceback, {
            __argnames__ : {value: ["err"]},
            __module__ : {value: "traceback"}
        });

        function format_exception(exc, limit) {
            var tb, lines, e;
            if (typeof exc === "undefined") {
                exc = ρσ_last_exception;
            }
            if (!(ρσ_instanceof(exc, Error))) {
                if (exc && exc.toString) {
                    return ρσ_list_decorate([ exc.toString() ]);
                }
                return ρσ_list_decorate([]);
            }
            tb = _get_internal_traceback(exc);
            if (tb) {
                lines = ρσ_str.splitlines(tb);
                e = lines[0];
                lines = lines.slice(1);
                if (limit) {
                    lines = (limit > 0) ? lines.slice(0, limit + 1) : lines.slice(limit);
                }
                lines.reverse();
                lines.push(e);
                lines.insert(0, "Traceback (most recent call last):");
                return (function() {
                    var ρσ_Iter = ρσ_Iterable(lines), ρσ_Result = [], l;
                    for (var ρσ_Index = 0; ρσ_Index < ρσ_Iter.length; ρσ_Index++) {
                        l = ρσ_Iter[ρσ_Index];
                        ρσ_Result.push(l + "\n");
                    }
                    ρσ_Result = ρσ_list_constructor(ρσ_Result);
                    return ρσ_Result;
                })();
            }
            return ρσ_list_decorate([ exc.toString() ]);
        };
        if (!format_exception.__argnames__) Object.defineProperties(format_exception, {
            __argnames__ : {value: ["exc", "limit"]},
            __module__ : {value: "traceback"}
        });

        function format_exc(limit) {
            return format_exception(ρσ_last_exception, limit).join("");
        };
        if (!format_exc.__argnames__) Object.defineProperties(format_exc, {
            __argnames__ : {value: ["limit"]},
            __module__ : {value: "traceback"}
        });

        function print_exc(limit) {
            print(format_exc(limit));
        };
        if (!print_exc.__argnames__) Object.defineProperties(print_exc, {
            __argnames__ : {value: ["limit"]},
            __module__ : {value: "traceback"}
        });

        function format_stack(limit) {
            var stack, lines;
            stack = (new Error).stack;
            if (!stack) {
                return ρσ_list_decorate([]);
            }
            lines = str.splitlines(stack).slice(2);
            lines.reverse();
            if (limit) {
                lines = (limit > 0) ? lines.slice(0, limit + 1) : lines.slice(limit);
            }
            return (function() {
                var ρσ_Iter = ρσ_Iterable(lines), ρσ_Result = [], l;
                for (var ρσ_Index = 0; ρσ_Index < ρσ_Iter.length; ρσ_Index++) {
                    l = ρσ_Iter[ρσ_Index];
                    ρσ_Result.push(l + "\n");
                }
                ρσ_Result = ρσ_list_constructor(ρσ_Result);
                return ρσ_Result;
            })();
        };
        if (!format_stack.__argnames__) Object.defineProperties(format_stack, {
            __argnames__ : {value: ["limit"]},
            __module__ : {value: "traceback"}
        });

        function print_stack(limit) {
            print(format_stack(limit).join(""));
        };
        if (!print_stack.__argnames__) Object.defineProperties(print_stack, {
            __argnames__ : {value: ["limit"]},
            __module__ : {value: "traceback"}
        });

        ρσ_modules.traceback._get_internal_traceback = _get_internal_traceback;
        ρσ_modules.traceback.format_exception = format_exception;
        ρσ_modules.traceback.format_exc = format_exc;
        ρσ_modules.traceback.print_exc = print_exc;
        ρσ_modules.traceback.format_stack = format_stack;
        ρσ_modules.traceback.print_stack = print_stack;
    })();

    (function(){
        var __name__ = "gettext";
        var Jed, plural_forms_parser, _gettext, _ngettext, has_prop, empty_translation_data;
        Jed = {};
        
  Jed.PF = {};

  Jed.PF.parse = function ( p ) {
    var plural_str = Jed.PF.extractPluralExpr( p );
    return Jed.PF.parser.parse.call(Jed.PF.parser, plural_str);
  };

  Jed.PF.compile = function ( p ) {
    // Handle trues and falses as 0 and 1
    function imply( val ) {
      return (val === true ? 1 : val ? val : 0);
    }

    var ast = Jed.PF.parse( p );
    return function ( n ) {
      return imply( Jed.PF.interpreter( ast )( n ) );
    };
  };

  Jed.PF.interpreter = function ( ast ) {
    return function ( n ) {
      var res;
      switch ( ast.type ) {
        case 'GROUP':
          return Jed.PF.interpreter( ast.expr )( n );
        case 'TERNARY':
          if ( Jed.PF.interpreter( ast.expr )( n ) ) {
            return Jed.PF.interpreter( ast.truthy )( n );
          }
          return Jed.PF.interpreter( ast.falsey )( n );
        case 'OR':
          return Jed.PF.interpreter( ast.left )( n ) || Jed.PF.interpreter( ast.right )( n );
        case 'AND':
          return Jed.PF.interpreter( ast.left )( n ) && Jed.PF.interpreter( ast.right )( n );
        case 'LT':
          return Jed.PF.interpreter( ast.left )( n ) < Jed.PF.interpreter( ast.right )( n );
        case 'GT':
          return Jed.PF.interpreter( ast.left )( n ) > Jed.PF.interpreter( ast.right )( n );
        case 'LTE':
          return Jed.PF.interpreter( ast.left )( n ) <= Jed.PF.interpreter( ast.right )( n );
        case 'GTE':
          return Jed.PF.interpreter( ast.left )( n ) >= Jed.PF.interpreter( ast.right )( n );
        case 'EQ':
          return Jed.PF.interpreter( ast.left )( n ) == Jed.PF.interpreter( ast.right )( n );
        case 'NEQ':
          return Jed.PF.interpreter( ast.left )( n ) != Jed.PF.interpreter( ast.right )( n );
        case 'MOD':
          return Jed.PF.interpreter( ast.left )( n ) % Jed.PF.interpreter( ast.right )( n );
        case 'VAR':
          return n;
        case 'NUM':
          return ast.val;
        default:
          throw new Error("Invalid Token found.");
      }
    };
  };

  Jed.PF.extractPluralExpr = function ( p ) {
    // trim first
    p = p.replace(/^\s\s*/, '').replace(/\s\s*$/, '');

    if (! /;\s*$/.test(p)) {
      p = p.concat(';');
    }

    var nplurals_re = /nplurals\=(\d+);/,
        plural_re = /plural\=(.*);/,
        nplurals_matches = p.match( nplurals_re ),
        res = {},
        plural_matches;

    // Find the nplurals number
    if ( nplurals_matches.length > 1 ) {
      res.nplurals = nplurals_matches[1];
    }
    else {
      throw new Error('nplurals not found in plural_forms string: ' + p );
    }

    // remove that data to get to the formula
    p = p.replace( nplurals_re, "" );
    plural_matches = p.match( plural_re );

    if (!( plural_matches && plural_matches.length > 1 ) ) {
      throw new Error('`plural` expression not found: ' + p);
    }
    return plural_matches[ 1 ];
  };

  /* Jison generated parser */
  Jed.PF.parser = (function(){

var parser = {trace: function trace() { },
yy: {},
symbols_: {"error":2,"expressions":3,"e":4,"EOF":5,"?":6,":":7,"||":8,"&&":9,"<":10,"<=":11,">":12,">=":13,"!=":14,"==":15,"%":16,"(":17,")":18,"n":19,"NUMBER":20,"$accept":0,"$end":1},
terminals_: {2:"error",5:"EOF",6:"?",7:":",8:"||",9:"&&",10:"<",11:"<=",12:">",13:">=",14:"!=",15:"==",16:"%",17:"(",18:")",19:"n",20:"NUMBER"},
productions_: [0,[3,2],[4,5],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,1],[4,1]],
performAction: function anonymous(yytext,yyleng,yylineno,yy,yystate,$$,_$) {

var $0 = $$.length - 1;
switch (yystate) {
case 1: return { type : 'GROUP', expr: $$[$0-1] };
case 2:this.$ = { type: 'TERNARY', expr: $$[$0-4], truthy : $$[$0-2], falsey: $$[$0] };
break;
case 3:this.$ = { type: "OR", left: $$[$0-2], right: $$[$0] };
break;
case 4:this.$ = { type: "AND", left: $$[$0-2], right: $$[$0] };
break;
case 5:this.$ = { type: 'LT', left: $$[$0-2], right: $$[$0] };
break;
case 6:this.$ = { type: 'LTE', left: $$[$0-2], right: $$[$0] };
break;
case 7:this.$ = { type: 'GT', left: $$[$0-2], right: $$[$0] };
break;
case 8:this.$ = { type: 'GTE', left: $$[$0-2], right: $$[$0] };
break;
case 9:this.$ = { type: 'NEQ', left: $$[$0-2], right: $$[$0] };
break;
case 10:this.$ = { type: 'EQ', left: $$[$0-2], right: $$[$0] };
break;
case 11:this.$ = { type: 'MOD', left: $$[$0-2], right: $$[$0] };
break;
case 12:this.$ = { type: 'GROUP', expr: $$[$0-1] };
break;
case 13:this.$ = { type: 'VAR' };
break;
case 14:this.$ = { type: 'NUM', val: Number(yytext) };
break;
}
},
table: [{3:1,4:2,17:[1,3],19:[1,4],20:[1,5]},{1:[3]},{5:[1,6],6:[1,7],8:[1,8],9:[1,9],10:[1,10],11:[1,11],12:[1,12],13:[1,13],14:[1,14],15:[1,15],16:[1,16]},{4:17,17:[1,3],19:[1,4],20:[1,5]},{5:[2,13],6:[2,13],7:[2,13],8:[2,13],9:[2,13],10:[2,13],11:[2,13],12:[2,13],13:[2,13],14:[2,13],15:[2,13],16:[2,13],18:[2,13]},{5:[2,14],6:[2,14],7:[2,14],8:[2,14],9:[2,14],10:[2,14],11:[2,14],12:[2,14],13:[2,14],14:[2,14],15:[2,14],16:[2,14],18:[2,14]},{1:[2,1]},{4:18,17:[1,3],19:[1,4],20:[1,5]},{4:19,17:[1,3],19:[1,4],20:[1,5]},{4:20,17:[1,3],19:[1,4],20:[1,5]},{4:21,17:[1,3],19:[1,4],20:[1,5]},{4:22,17:[1,3],19:[1,4],20:[1,5]},{4:23,17:[1,3],19:[1,4],20:[1,5]},{4:24,17:[1,3],19:[1,4],20:[1,5]},{4:25,17:[1,3],19:[1,4],20:[1,5]},{4:26,17:[1,3],19:[1,4],20:[1,5]},{4:27,17:[1,3],19:[1,4],20:[1,5]},{6:[1,7],8:[1,8],9:[1,9],10:[1,10],11:[1,11],12:[1,12],13:[1,13],14:[1,14],15:[1,15],16:[1,16],18:[1,28]},{6:[1,7],7:[1,29],8:[1,8],9:[1,9],10:[1,10],11:[1,11],12:[1,12],13:[1,13],14:[1,14],15:[1,15],16:[1,16]},{5:[2,3],6:[2,3],7:[2,3],8:[2,3],9:[1,9],10:[1,10],11:[1,11],12:[1,12],13:[1,13],14:[1,14],15:[1,15],16:[1,16],18:[2,3]},{5:[2,4],6:[2,4],7:[2,4],8:[2,4],9:[2,4],10:[1,10],11:[1,11],12:[1,12],13:[1,13],14:[1,14],15:[1,15],16:[1,16],18:[2,4]},{5:[2,5],6:[2,5],7:[2,5],8:[2,5],9:[2,5],10:[2,5],11:[2,5],12:[2,5],13:[2,5],14:[2,5],15:[2,5],16:[1,16],18:[2,5]},{5:[2,6],6:[2,6],7:[2,6],8:[2,6],9:[2,6],10:[2,6],11:[2,6],12:[2,6],13:[2,6],14:[2,6],15:[2,6],16:[1,16],18:[2,6]},{5:[2,7],6:[2,7],7:[2,7],8:[2,7],9:[2,7],10:[2,7],11:[2,7],12:[2,7],13:[2,7],14:[2,7],15:[2,7],16:[1,16],18:[2,7]},{5:[2,8],6:[2,8],7:[2,8],8:[2,8],9:[2,8],10:[2,8],11:[2,8],12:[2,8],13:[2,8],14:[2,8],15:[2,8],16:[1,16],18:[2,8]},{5:[2,9],6:[2,9],7:[2,9],8:[2,9],9:[2,9],10:[2,9],11:[2,9],12:[2,9],13:[2,9],14:[2,9],15:[2,9],16:[1,16],18:[2,9]},{5:[2,10],6:[2,10],7:[2,10],8:[2,10],9:[2,10],10:[2,10],11:[2,10],12:[2,10],13:[2,10],14:[2,10],15:[2,10],16:[1,16],18:[2,10]},{5:[2,11],6:[2,11],7:[2,11],8:[2,11],9:[2,11],10:[2,11],11:[2,11],12:[2,11],13:[2,11],14:[2,11],15:[2,11],16:[2,11],18:[2,11]},{5:[2,12],6:[2,12],7:[2,12],8:[2,12],9:[2,12],10:[2,12],11:[2,12],12:[2,12],13:[2,12],14:[2,12],15:[2,12],16:[2,12],18:[2,12]},{4:30,17:[1,3],19:[1,4],20:[1,5]},{5:[2,2],6:[1,7],7:[2,2],8:[1,8],9:[1,9],10:[1,10],11:[1,11],12:[1,12],13:[1,13],14:[1,14],15:[1,15],16:[1,16],18:[2,2]}],
defaultActions: {6:[2,1]},
parseError: function parseError(str, hash) {
    throw new Error(str);
},
parse: function parse(input) {
    var self = this,
        stack = [0],
        vstack = [null], // semantic value stack
        lstack = [], // location stack
        table = this.table,
        yytext = '',
        yylineno = 0,
        yyleng = 0,
        recovering = 0,
        TERROR = 2,
        EOF = 1;

    //this.reductionCount = this.shiftCount = 0;

    this.lexer.setInput(input);
    this.lexer.yy = this.yy;
    this.yy.lexer = this.lexer;
    if (typeof this.lexer.yylloc == 'undefined')
        this.lexer.yylloc = {};
    var yyloc = this.lexer.yylloc;
    lstack.push(yyloc);

    if (typeof this.yy.parseError === 'function')
        this.parseError = this.yy.parseError;

    function popStack (n) {
        stack.length = stack.length - 2*n;
        vstack.length = vstack.length - n;
        lstack.length = lstack.length - n;
    }

    function lex() {
        var token;
        token = self.lexer.lex() || 1; // $end = 1
        // if token isn't its numeric value, convert
        if (typeof token !== 'number') {
            token = self.symbols_[token] || token;
        }
        return token;
    }

    var symbol, preErrorSymbol, state, action, a, r, yyval={},p,len,newState, expected, errStr;
    while (true) {
        // retreive state number from top of stack
        state = stack[stack.length-1];

        // use default actions if available
        if (this.defaultActions[state]) {
            action = this.defaultActions[state];
        } else {
            if (symbol === null || symbol === undefined)
                symbol = lex();
            // read action for current state and first input
            action = table[state] && table[state][symbol];
        }

        // handle parse error
        _handle_error:
        if (typeof action === 'undefined' || !action.length || !action[0]) {

            if (!recovering) {
                // Report error
                expected = [];
                for (p in table[state]) if (this.terminals_[p] && p > 2) {
                    expected.push("'"+this.terminals_[p]+"'");
                }
                errStr = '';
                if (this.lexer.showPosition) {
                    errStr = 'Parse error on line '+(yylineno+1)+":\n"+this.lexer.showPosition()+"\nExpecting "+expected.join(', ') + ", got '" + this.terminals_[symbol]+ "'";
                } else {
                    errStr = 'Parse error on line '+(yylineno+1)+": Unexpected " +
                                  (symbol == 1 /*EOF*/ ? "end of input" :
                                              ("'"+(this.terminals_[symbol] || symbol)+"'"));
                }
                this.parseError(errStr,
                    {text: this.lexer.match, token: this.terminals_[symbol] || symbol, line: this.lexer.yylineno, loc: yyloc, expected: expected});
            }

            // just recovered from another error
            if (recovering == 3) {
                if (symbol == EOF) {
                    throw new Error(errStr || 'Parsing halted.');
                }

                // discard current lookahead and grab another
                yyleng = this.lexer.yyleng;
                yytext = this.lexer.yytext;
                yylineno = this.lexer.yylineno;
                yyloc = this.lexer.yylloc;
                symbol = lex();
            }

            // try to recover from error
            while (1) {
                // check for error recovery rule in this state
                if ((TERROR.toString()) in table[state]) {
                    break;
                }
                if (state === 0) {
                    throw new Error(errStr || 'Parsing halted.');
                }
                popStack(1);
                state = stack[stack.length-1];
            }

            preErrorSymbol = symbol; // save the lookahead token
            symbol = TERROR;         // insert generic error symbol as new lookahead
            state = stack[stack.length-1];
            action = table[state] && table[state][TERROR];
            recovering = 3; // allow 3 real symbols to be shifted before reporting a new error
        }

        // this shouldn't happen, unless resolve defaults are off
        if (action[0] instanceof Array && action.length > 1) {
            throw new Error('Parse Error: multiple actions possible at state: '+state+', token: '+symbol);
        }

        switch (action[0]) {

            case 1: // shift
                //this.shiftCount++;

                stack.push(symbol);
                vstack.push(this.lexer.yytext);
                lstack.push(this.lexer.yylloc);
                stack.push(action[1]); // push state
                symbol = null;
                if (!preErrorSymbol) { // normal execution/no error
                    yyleng = this.lexer.yyleng;
                    yytext = this.lexer.yytext;
                    yylineno = this.lexer.yylineno;
                    yyloc = this.lexer.yylloc;
                    if (recovering > 0)
                        recovering--;
                } else { // error just occurred, resume old lookahead f/ before error
                    symbol = preErrorSymbol;
                    preErrorSymbol = null;
                }
                break;

            case 2: // reduce
                //this.reductionCount++;

                len = this.productions_[action[1]][1];

                // perform semantic action
                yyval.$ = vstack[vstack.length-len]; // default to $$ = $1
                // default location, uses first token for firsts, last for lasts
                yyval._$ = {
                    first_line: lstack[lstack.length-(len||1)].first_line,
                    last_line: lstack[lstack.length-1].last_line,
                    first_column: lstack[lstack.length-(len||1)].first_column,
                    last_column: lstack[lstack.length-1].last_column
                };
                r = this.performAction.call(yyval, yytext, yyleng, yylineno, this.yy, action[1], vstack, lstack);

                if (typeof r !== 'undefined') {
                    return r;
                }

                // pop off stack
                if (len) {
                    stack = stack.slice(0,-1*len*2);
                    vstack = vstack.slice(0, -1*len);
                    lstack = lstack.slice(0, -1*len);
                }

                stack.push(this.productions_[action[1]][0]);    // push nonterminal (reduce)
                vstack.push(yyval.$);
                lstack.push(yyval._$);
                // goto new state = table[STATE][NONTERMINAL]
                newState = table[stack[stack.length-2]][stack[stack.length-1]];
                stack.push(newState);
                break;

            case 3: // accept
                return true;
        }

    }

    return true;
}};/* Jison generated lexer */
var lexer = (function(){

var lexer = ({EOF:1,
parseError:function parseError(str, hash) {
        if (this.yy.parseError) {
            this.yy.parseError(str, hash);
        } else {
            throw new Error(str);
        }
    },
setInput:function (input) {
        this._input = input;
        this._more = this._less = this.done = false;
        this.yylineno = this.yyleng = 0;
        this.yytext = this.matched = this.match = '';
        this.conditionStack = ['INITIAL'];
        this.yylloc = {first_line:1,first_column:0,last_line:1,last_column:0};
        return this;
    },
input:function () {
        var ch = this._input[0];
        this.yytext+=ch;
        this.yyleng++;
        this.match+=ch;
        this.matched+=ch;
        var lines = ch.match(/\n/);
        if (lines) this.yylineno++;
        this._input = this._input.slice(1);
        return ch;
    },
unput:function (ch) {
        this._input = ch + this._input;
        return this;
    },
more:function () {
        this._more = true;
        return this;
    },
pastInput:function () {
        var past = this.matched.substr(0, this.matched.length - this.match.length);
        return (past.length > 20 ? '...':'') + past.substr(-20).replace(/\n/g, "");
    },
upcomingInput:function () {
        var next = this.match;
        if (next.length < 20) {
            next += this._input.substr(0, 20-next.length);
        }
        return (next.substr(0,20)+(next.length > 20 ? '...':'')).replace(/\n/g, "");
    },
showPosition:function () {
        var pre = this.pastInput();
        var c = new Array(pre.length + 1).join("-");
        return pre + this.upcomingInput() + "\n" + c+"^";
    },
next:function () {
        if (this.done) {
            return this.EOF;
        }
        if (!this._input) this.done = true;

        var token,
            match,
            col,
            lines;
        if (!this._more) {
            this.yytext = '';
            this.match = '';
        }
        var rules = this._currentRules();
        for (var i=0;i < rules.length; i++) {
            match = this._input.match(this.rules[rules[i]]);
            if (match) {
                lines = match[0].match(/\n.*/g);
                if (lines) this.yylineno += lines.length;
                this.yylloc = {first_line: this.yylloc.last_line,
                               last_line: this.yylineno+1,
                               first_column: this.yylloc.last_column,
                               last_column: lines ? lines[lines.length-1].length-1 : this.yylloc.last_column + match[0].length};
                this.yytext += match[0];
                this.match += match[0];
                this.matches = match;
                this.yyleng = this.yytext.length;
                this._more = false;
                this._input = this._input.slice(match[0].length);
                this.matched += match[0];
                token = this.performAction.call(this, this.yy, this, rules[i],this.conditionStack[this.conditionStack.length-1]);
                if (token) return token;
                else return;
            }
        }
        if (this._input === "") {
            return this.EOF;
        } else {
            this.parseError('Lexical error on line '+(this.yylineno+1)+'. Unrecognized text.\n'+this.showPosition(),
                    {text: "", token: null, line: this.yylineno});
        }
    },
lex:function lex() {
        var r = this.next();
        if (typeof r !== 'undefined') {
            return r;
        } else {
            return this.lex();
        }
    },
begin:function begin(condition) {
        this.conditionStack.push(condition);
    },
popState:function popState() {
        return this.conditionStack.pop();
    },
_currentRules:function _currentRules() {
        return this.conditions[this.conditionStack[this.conditionStack.length-1]].rules;
    },
topState:function () {
        return this.conditionStack[this.conditionStack.length-2];
    },
pushState:function begin(condition) {
        this.begin(condition);
    }});
lexer.performAction = function anonymous(yy,yy_,$avoiding_name_collisions,YY_START) {

var YYSTATE=YY_START;
switch($avoiding_name_collisions) {
case 0:/* skip whitespace */
break;
case 1:return 20
break;
case 2:return 19
break;
case 3:return 8
break;
case 4:return 9
break;
case 5:return 6
break;
case 6:return 7
break;
case 7:return 11
break;
case 8:return 13
break;
case 9:return 10
break;
case 10:return 12
break;
case 11:return 14
break;
case 12:return 15
break;
case 13:return 16
break;
case 14:return 17
break;
case 15:return 18
break;
case 16:return 5
break;
case 17:return 'INVALID'
break;
}
};
lexer.rules = [/^\s+/,/^[0-9]+(\.[0-9]+)?\b/,/^n\b/,/^\|\|/,/^&&/,/^\?/,/^:/,/^<=/,/^>=/,/^</,/^>/,/^!=/,/^==/,/^%/,/^\(/,/^\)/,/^$/,/^./];
lexer.conditions = {"INITIAL":{"rules":[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17],"inclusive":true}};return lexer;})()
parser.lexer = lexer;
return parser;
})();
;
        plural_forms_parser = Jed.PF;
        function _get_plural_forms_function(plural_forms_string) {
            return plural_forms_parser.compile(plural_forms_string || "nplurals=2; plural=(n != 1);");
        };
        if (!_get_plural_forms_function.__argnames__) Object.defineProperties(_get_plural_forms_function, {
            __argnames__ : {value: ["plural_forms_string"]},
            __module__ : {value: "gettext"}
        });

        _gettext = (function() {
            var ρσ_anonfunc = function (text) {
                return text;
            };
            if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                __argnames__ : {value: ["text"]},
                __module__ : {value: "gettext"}
            });
            return ρσ_anonfunc;
        })();
        _ngettext = (function() {
            var ρσ_anonfunc = function (text, plural, n) {
                return (n === 1) ? text : plural;
            };
            if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                __argnames__ : {value: ["text", "plural", "n"]},
                __module__ : {value: "gettext"}
            });
            return ρσ_anonfunc;
        })();
        function gettext(text) {
            return _gettext(text);
        };
        if (!gettext.__argnames__) Object.defineProperties(gettext, {
            __argnames__ : {value: ["text"]},
            __module__ : {value: "gettext"}
        });

        function ngettext(text, plural, n) {
            return _ngettext(text, plural, n);
        };
        if (!ngettext.__argnames__) Object.defineProperties(ngettext, {
            __argnames__ : {value: ["text", "plural", "n"]},
            __module__ : {value: "gettext"}
        });

        function install(translation_data) {
            var t, func;
            t = new Translations(translation_data);
            t.install();
            var ρσ_Iter0 = ρσ_Iterable(register_callback.install_callbacks);
            for (var ρσ_Index0 = 0; ρσ_Index0 < ρσ_Iter0.length; ρσ_Index0++) {
                func = ρσ_Iter0[ρσ_Index0];
                try {
                    func(t);
                } catch (ρσ_Exception) {
                    ρσ_last_exception = ρσ_Exception;
                    {
                    } 
                }
            }
            return t;
        };
        if (!install.__argnames__) Object.defineProperties(install, {
            __argnames__ : {value: ["translation_data"]},
            __module__ : {value: "gettext"}
        });

        has_prop = Object.prototype.hasOwnProperty.call.bind(Object.prototype.hasOwnProperty);
        function register_callback(func) {
            register_callback.install_callbacks.push(func);
        };
        if (!register_callback.__argnames__) Object.defineProperties(register_callback, {
            __argnames__ : {value: ["func"]},
            __module__ : {value: "gettext"}
        });

        register_callback.install_callbacks = [];
        empty_translation_data = (function(){
            var ρσ_d = {};
            ρσ_d["entries"] = {};
            return ρσ_d;
        }).call(this);
        function Translations() {
            if (this.ρσ_object_id === undefined) Object.defineProperty(this, "ρσ_object_id", {"value":++ρσ_object_counter});
            Translations.prototype.__init__.apply(this, arguments);
        }
        Translations.prototype.__init__ = function __init__(translation_data) {
            var self = this;
            var func;
            translation_data = translation_data || empty_translation_data;
            func = _get_plural_forms_function(translation_data.plural_forms);
            self.translations = ρσ_list_decorate([ ρσ_list_decorate([ translation_data, func ]) ]);
            self.language = translation_data["language"];
        };
        if (!Translations.prototype.__init__.__argnames__) Object.defineProperties(Translations.prototype.__init__, {
            __argnames__ : {value: ["translation_data"]},
            __module__ : {value: "gettext"}
        });
        Translations.__argnames__ = Translations.prototype.__init__.__argnames__;
        Translations.__handles_kwarg_interpolation__ = Translations.prototype.__init__.__handles_kwarg_interpolation__;
        Translations.prototype.add_fallback = function add_fallback(fallback) {
            var self = this;
            var func;
            fallback = fallback || empty_translation_data;
            func = _get_plural_forms_function(fallback.plural_forms);
            self.translations.push(ρσ_list_decorate([ fallback, func ]));
        };
        if (!Translations.prototype.add_fallback.__argnames__) Object.defineProperties(Translations.prototype.add_fallback, {
            __argnames__ : {value: ["fallback"]},
            __module__ : {value: "gettext"}
        });
        Translations.prototype.gettext = function gettext(text) {
            var self = this;
            var m, t;
            var ρσ_Iter1 = ρσ_Iterable(self.translations);
            for (var ρσ_Index1 = 0; ρσ_Index1 < ρσ_Iter1.length; ρσ_Index1++) {
                t = ρσ_Iter1[ρσ_Index1];
                m = t[0].entries;
                if (has_prop(m, text)) {
                    return m[(typeof text === "number" && text < 0) ? m.length + text : text][0];
                }
            }
            return text;
        };
        if (!Translations.prototype.gettext.__argnames__) Object.defineProperties(Translations.prototype.gettext, {
            __argnames__ : {value: ["text"]},
            __module__ : {value: "gettext"}
        });
        Translations.prototype.ngettext = function ngettext(text, plural, n) {
            var self = this;
            var m, idx, t;
            var ρσ_Iter2 = ρσ_Iterable(self.translations);
            for (var ρσ_Index2 = 0; ρσ_Index2 < ρσ_Iter2.length; ρσ_Index2++) {
                t = ρσ_Iter2[ρσ_Index2];
                m = t[0].entries;
                if (has_prop(m, text)) {
                    idx = t[1](n);
                    return (ρσ_expr_temp = m[(typeof text === "number" && text < 0) ? m.length + text : text])[(typeof idx === "number" && idx < 0) ? ρσ_expr_temp.length + idx : idx] || ((n === 1) ? text : plural);
                }
            }
            return (n === 1) ? text : plural;
        };
        if (!Translations.prototype.ngettext.__argnames__) Object.defineProperties(Translations.prototype.ngettext, {
            __argnames__ : {value: ["text", "plural", "n"]},
            __module__ : {value: "gettext"}
        });
        Translations.prototype.install = function install() {
            var self = this;
            _gettext = (function() {
                var ρσ_anonfunc = function () {
                    return self.gettext.apply(self, arguments);
                };
                if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
                    __module__ : {value: "gettext"}
                });
                return ρσ_anonfunc;
            })();
            _ngettext = (function() {
                var ρσ_anonfunc = function () {
                    return self.ngettext.apply(self, arguments);
                };
                if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
                    __module__ : {value: "gettext"}
                });
                return ρσ_anonfunc;
            })();
        };
        if (!Translations.prototype.install.__module__) Object.defineProperties(Translations.prototype.install, {
            __module__ : {value: "gettext"}
        });
        Translations.prototype.__repr__ = function __repr__ () {
                        return "<" + __name__ + "." + this.constructor.name + " #" + this.ρσ_object_id + ">";
        };
        Translations.prototype.__str__ = function __str__ () {
            return this.__repr__();
        };
        Object.defineProperty(Translations.prototype, "__bases__", {value: []});

        ρσ_modules.gettext.Jed = Jed;
        ρσ_modules.gettext.plural_forms_parser = plural_forms_parser;
        ρσ_modules.gettext._gettext = _gettext;
        ρσ_modules.gettext._ngettext = _ngettext;
        ρσ_modules.gettext.has_prop = has_prop;
        ρσ_modules.gettext.empty_translation_data = empty_translation_data;
        ρσ_modules.gettext._get_plural_forms_function = _get_plural_forms_function;
        ρσ_modules.gettext.gettext = gettext;
        ρσ_modules.gettext.ngettext = ngettext;
        ρσ_modules.gettext.install = install;
        ρσ_modules.gettext.register_callback = register_callback;
        ρσ_modules.gettext.Translations = Translations;
    })();

    (function(){
        var __name__ = "ajax";
        var default_timeout;
        var _ = ρσ_modules.gettext.gettext;

        default_timeout = 60;
        function set_default_timeout(val) {
            default_timeout = val;
        };
        if (!set_default_timeout.__argnames__) Object.defineProperties(set_default_timeout, {
            __argnames__ : {value: ["val"]},
            __module__ : {value: "ajax"}
        });

        function encode_query_component(x) {
            var ans;
            ans = encodeURIComponent(x);
            ans = ans.replace(/%2[fF]/g, "/");
            ans = ans.replace(/%40/g, "@");
            ans = ans.replace(/%5[bB]/g, "[");
            ans = ans.replace(/%5[dD]/g, "]");
            ans = ans.replace(/%5[eE]/g, "^");
            ans = ans.replace(/%3[aA]/g, ":");
            return ans;
        };
        if (!encode_query_component.__argnames__) Object.defineProperties(encode_query_component, {
            __argnames__ : {value: ["x"]},
            __module__ : {value: "ajax"}
        });

        function encode_query(query, qchar) {
            var keys, ans, val, k;
            if (!query) {
                return "";
            }
            qchar = qchar || "?";
            keys = Object.keys(query).sort();
            ans = "";
            if (keys.length) {
                var ρσ_Iter0 = ρσ_Iterable(keys);
                for (var ρσ_Index0 = 0; ρσ_Index0 < ρσ_Iter0.length; ρσ_Index0++) {
                    k = ρσ_Iter0[ρσ_Index0];
                    val = query[(typeof k === "number" && k < 0) ? query.length + k : k];
                    if (val === undefined || val === null || val === "") {
                        continue;
                    }
                    ans += qchar + encodeURIComponent(k) + "=" + encode_query_component(val.toString());
                    qchar = "&";
                }
            }
            return ans;
        };
        if (!encode_query.__argnames__) Object.defineProperties(encode_query, {
            __argnames__ : {value: ["query", "qchar"]},
            __module__ : {value: "ajax"}
        });

        function absolute_path(path) {
            var slash;
            if (path[0] !== "/") {
                slash = ((ρσ_expr_temp = window.location.pathname)[ρσ_expr_temp.length-1] === "/") ? "" : "/";
                path = window.location.pathname + slash + path;
            }
            return path;
        };
        if (!absolute_path.__argnames__) Object.defineProperties(absolute_path, {
            __argnames__ : {value: ["path"]},
            __module__ : {value: "ajax"}
        });

        function workaround_qt_bug() {
            var xhr = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[0];
            var end_type = ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[1];
            var ok_code = (arguments[2] === undefined || ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? workaround_qt_bug.__defaults__.ok_code : arguments[2];
            var ρσ_kwargs_obj = arguments[arguments.length-1];
            if (ρσ_kwargs_obj === null || typeof ρσ_kwargs_obj !== "object" || ρσ_kwargs_obj [ρσ_kwargs_symbol] !== true) ρσ_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "ok_code")){
                ok_code = ρσ_kwargs_obj.ok_code;
            }
            if (end_type === "error" && xhr.status === ok_code && window.navigator.userAgent.indexOf("calibre-viewer") === 0) {
                end_type = "load";
            }
            return end_type;
        };
        if (!workaround_qt_bug.__defaults__) Object.defineProperties(workaround_qt_bug, {
            __defaults__ : {value: {ok_code:200}},
            __handles_kwarg_interpolation__ : {value: true},
            __argnames__ : {value: ["xhr", "end_type", "ok_code"]},
            __module__ : {value: "ajax"}
        });

        function ajax() {
            var path = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[0];
            var on_complete = ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[1];
            var on_progress = (arguments[2] === undefined || ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? ajax.__defaults__.on_progress : arguments[2];
            var bypass_cache = (arguments[3] === undefined || ( 3 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? ajax.__defaults__.bypass_cache : arguments[3];
            var method = (arguments[4] === undefined || ( 4 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? ajax.__defaults__.method : arguments[4];
            var query = (arguments[5] === undefined || ( 5 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? ajax.__defaults__.query : arguments[5];
            var timeout = (arguments[6] === undefined || ( 6 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? ajax.__defaults__.timeout : arguments[6];
            var ok_code = (arguments[7] === undefined || ( 7 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? ajax.__defaults__.ok_code : arguments[7];
            var progress_totals_needed = (arguments[8] === undefined || ( 8 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? ajax.__defaults__.progress_totals_needed : arguments[8];
            var ρσ_kwargs_obj = arguments[arguments.length-1];
            if (ρσ_kwargs_obj === null || typeof ρσ_kwargs_obj !== "object" || ρσ_kwargs_obj [ρσ_kwargs_symbol] !== true) ρσ_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "on_progress")){
                on_progress = ρσ_kwargs_obj.on_progress;
            }
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "bypass_cache")){
                bypass_cache = ρσ_kwargs_obj.bypass_cache;
            }
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "method")){
                method = ρσ_kwargs_obj.method;
            }
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "query")){
                query = ρσ_kwargs_obj.query;
            }
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "timeout")){
                timeout = ρσ_kwargs_obj.timeout;
            }
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "ok_code")){
                ok_code = ρσ_kwargs_obj.ok_code;
            }
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "progress_totals_needed")){
                progress_totals_needed = ρσ_kwargs_obj.progress_totals_needed;
            }
            var xhr, eq, has_query;
            if (timeout === null) {
                timeout = default_timeout;
            }
            query = query || Object.create(null);
            xhr = new XMLHttpRequest;
            eq = encode_query(query);
            has_query = eq.length > 0;
            path = absolute_path(path) + eq;
            if (bypass_cache) {
                path += ((has_query) ? "&" : "?") + (new Date).getTime();
            }
            xhr.request_path = path;
            xhr.error_html = "";
            function set_error(event, is_network_error) {
                var rtext;
                if (is_network_error) {
                    xhr.error_html = str.format(_("Failed to communicate with \"{}\", network error. Is the server running and accessible?"), xhr.request_path);
                } else if (event === "timeout") {
                    xhr.error_html = str.format(_("Failed to communicate with \"{}\", timed out after: {} seconds"), xhr.request_path, timeout);
                } else if (event === "abort") {
                    xhr.error_html = str.format(_("Failed to communicate with \"{}\", aborted"), xhr.request_path);
                } else {
                    try {
                        rtext = xhr.responseText || "";
                    } catch (ρσ_Exception) {
                        ρσ_last_exception = ρσ_Exception;
                        {
                            rtext = "";
                        } 
                    }
                    xhr.error_html = str.format(_("Failed to communicate with \"{}\", with status: [{} ({})] {}<br><br>{}"), xhr.request_path, xhr.status, event, xhr.statusText, rtext.slice(0, 200));
                }
            };
            if (!set_error.__argnames__) Object.defineProperties(set_error, {
                __argnames__ : {value: ["event", "is_network_error"]},
                __module__ : {value: "ajax"}
            });

            function progress_callback(ev) {
                var ul;
                if (ev.lengthComputable) {
                    on_progress(ev.loaded, ev.total, xhr);
                } else if (ev.loaded) {
                    if (!progress_totals_needed) {
                        on_progress(ev.loaded, undefined, xhr);
                        return;
                    }
                    ul = xhr.getResponseHeader("Calibre-Uncompressed-Length");
                    if (ul) {
                        try {
                            ul = int(ul);
                        } catch (ρσ_Exception) {
                            ρσ_last_exception = ρσ_Exception;
                            if (ρσ_Exception instanceof Error) {
                                return;
                            } else {
                                throw ρσ_Exception;
                            }
                        }
                        on_progress(ev.loaded, ul, xhr);
                    }
                }
            };
            if (!progress_callback.__argnames__) Object.defineProperties(progress_callback, {
                __argnames__ : {value: ["ev"]},
                __module__ : {value: "ajax"}
            });

            function complete_callback(end_type, ev) {
                var is_network_error;
                is_network_error = (end_type === "error") ? ev : false;
                if (xhr.status !== ok_code && end_type === "load") {
                    end_type = "error";
                }
                end_type = workaround_qt_bug(xhr, end_type, ok_code);
                if (end_type !== "load") {
                    set_error(end_type, is_network_error);
                }
                on_complete(end_type, xhr, ev);
            };
            if (!complete_callback.__argnames__) Object.defineProperties(complete_callback, {
                __argnames__ : {value: ["end_type", "ev"]},
                __module__ : {value: "ajax"}
            });

            if (on_progress) {
                xhr.addEventListener("progress", progress_callback);
            }
            xhr.addEventListener("abort", (function() {
                var ρσ_anonfunc = function (ev) {
                    complete_callback("abort", ev);
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["ev"]},
                    __module__ : {value: "ajax"}
                });
                return ρσ_anonfunc;
            })());
            xhr.addEventListener("error", (function() {
                var ρσ_anonfunc = function (ev) {
                    complete_callback("error", ev);
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["ev"]},
                    __module__ : {value: "ajax"}
                });
                return ρσ_anonfunc;
            })());
            xhr.addEventListener("load", (function() {
                var ρσ_anonfunc = function (ev) {
                    complete_callback("load", ev);
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["ev"]},
                    __module__ : {value: "ajax"}
                });
                return ρσ_anonfunc;
            })());
            xhr.addEventListener("timeout", (function() {
                var ρσ_anonfunc = function (ev) {
                    complete_callback("timeout", ev);
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["ev"]},
                    __module__ : {value: "ajax"}
                });
                return ρσ_anonfunc;
            })());
            xhr.open(method, path);
            xhr.timeout = timeout * 1e3;
            return xhr;
        };
        if (!ajax.__defaults__) Object.defineProperties(ajax, {
            __defaults__ : {value: {on_progress:null, bypass_cache:true, method:"GET", query:null, timeout:null, ok_code:200, progress_totals_needed:true}},
            __handles_kwarg_interpolation__ : {value: true},
            __argnames__ : {value: ["path", "on_complete", "on_progress", "bypass_cache", "method", "query", "timeout", "ok_code", "progress_totals_needed"]},
            __module__ : {value: "ajax"}
        });

        function ajax_send() {
            var path = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[0];
            var data = ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[1];
            var on_complete = ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[2];
            var on_progress = (arguments[3] === undefined || ( 3 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? ajax_send.__defaults__.on_progress : arguments[3];
            var query = (arguments[4] === undefined || ( 4 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? ajax_send.__defaults__.query : arguments[4];
            var timeout = (arguments[5] === undefined || ( 5 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? ajax_send.__defaults__.timeout : arguments[5];
            var ok_code = (arguments[6] === undefined || ( 6 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? ajax_send.__defaults__.ok_code : arguments[6];
            var ρσ_kwargs_obj = arguments[arguments.length-1];
            if (ρσ_kwargs_obj === null || typeof ρσ_kwargs_obj !== "object" || ρσ_kwargs_obj [ρσ_kwargs_symbol] !== true) ρσ_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "on_progress")){
                on_progress = ρσ_kwargs_obj.on_progress;
            }
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "query")){
                query = ρσ_kwargs_obj.query;
            }
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "timeout")){
                timeout = ρσ_kwargs_obj.timeout;
            }
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "ok_code")){
                ok_code = ρσ_kwargs_obj.ok_code;
            }
            var xhr;
            xhr = ajax(path, on_complete, on_progress, false, "POST", query, timeout, ok_code);
            xhr.setRequestHeader("Content-Type", "application/json;charset=UTF-8");
            xhr.send(JSON.stringify(data));
            return xhr;
        };
        if (!ajax_send.__defaults__) Object.defineProperties(ajax_send, {
            __defaults__ : {value: {on_progress:null, query:null, timeout:null, ok_code:200}},
            __handles_kwarg_interpolation__ : {value: true},
            __argnames__ : {value: ["path", "data", "on_complete", "on_progress", "query", "timeout", "ok_code"]},
            __module__ : {value: "ajax"}
        });

        function ajax_send_file() {
            var path = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[0];
            var file = ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[1];
            var on_complete = ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[2];
            var on_progress = ( 3 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[3];
            var timeout = (arguments[4] === undefined || ( 4 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? ajax_send_file.__defaults__.timeout : arguments[4];
            var ok_code = (arguments[5] === undefined || ( 5 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? ajax_send_file.__defaults__.ok_code : arguments[5];
            var ρσ_kwargs_obj = arguments[arguments.length-1];
            if (ρσ_kwargs_obj === null || typeof ρσ_kwargs_obj !== "object" || ρσ_kwargs_obj [ρσ_kwargs_symbol] !== true) ρσ_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "timeout")){
                timeout = ρσ_kwargs_obj.timeout;
            }
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "ok_code")){
                ok_code = ρσ_kwargs_obj.ok_code;
            }
            var xhr;
            xhr = ajax(path, on_complete, on_progress, false, "POST", timeout, ok_code);
            if (file.type) {
                xhr.overrideMimeType(file.type);
            }
            xhr.send(file);
            return xhr;
        };
        if (!ajax_send_file.__defaults__) Object.defineProperties(ajax_send_file, {
            __defaults__ : {value: {timeout:null, ok_code:200}},
            __handles_kwarg_interpolation__ : {value: true},
            __argnames__ : {value: ["path", "file", "on_complete", "on_progress", "timeout", "ok_code"]},
            __module__ : {value: "ajax"}
        });

        function console_print() {
            var args = Array.prototype.slice.call(arguments, 0);
            if (arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) args.pop();
            var data, xhr;
            ρσ_print.apply(this, args);
            data = " ".join(map(str, args)) + "\n";
            xhr = ρσ_interpolate_kwargs.call(this, ajax, ["console-print", (function() {
                var ρσ_anonfunc = function () {
                };
                if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
                    __module__ : {value: "ajax"}
                });
                return ρσ_anonfunc;
            })()].concat([ρσ_desugar_kwargs({method: "POST", progress_totals_needed: false})]));
            xhr.send(data);
        };
        if (!console_print.__handles_kwarg_interpolation__) Object.defineProperties(console_print, {
            __handles_kwarg_interpolation__ : {value: true},
            __module__ : {value: "ajax"}
        });

        ρσ_modules.ajax.default_timeout = default_timeout;
        ρσ_modules.ajax.set_default_timeout = set_default_timeout;
        ρσ_modules.ajax.encode_query_component = encode_query_component;
        ρσ_modules.ajax.encode_query = encode_query;
        ρσ_modules.ajax.absolute_path = absolute_path;
        ρσ_modules.ajax.workaround_qt_bug = workaround_qt_bug;
        ρσ_modules.ajax.ajax = ajax;
        ρσ_modules.ajax.ajax_send = ajax_send;
        ρσ_modules.ajax.ajax_send_file = ajax_send_file;
        ρσ_modules.ajax.console_print = console_print;
    })();

    (function(){
        var __name__ = "book_list";

    })();

    (function(){
        var __name__ = "book_list.globals";
        var session_data;
        session_data = null;
        function set_session_data(sd) {
            session_data = sd;
            return session_data;
        };
        if (!set_session_data.__argnames__) Object.defineProperties(set_session_data, {
            __argnames__ : {value: ["sd"]},
            __module__ : {value: "book_list.globals"}
        });

        function get_session_data() {
            return session_data;
        };
        if (!get_session_data.__module__) Object.defineProperties(get_session_data, {
            __module__ : {value: "book_list.globals"}
        });

        function main_js(newval) {
            if (newval !== undefined) {
                main_js.ans = newval;
            }
            return main_js.ans;
        };
        if (!main_js.__argnames__) Object.defineProperties(main_js, {
            __argnames__ : {value: ["newval"]},
            __module__ : {value: "book_list.globals"}
        });

        function get_current_query(newval) {
            if (newval) {
                get_current_query.ans = newval;
            }
            return get_current_query.ans;
        };
        if (!get_current_query.__argnames__) Object.defineProperties(get_current_query, {
            __argnames__ : {value: ["newval"]},
            __module__ : {value: "book_list.globals"}
        });

        function get_db(db) {
            if (db) {
                get_db.db = db;
            }
            return get_db.db;
        };
        if (!get_db.__argnames__) Object.defineProperties(get_db, {
            __argnames__ : {value: ["db"]},
            __module__ : {value: "book_list.globals"}
        });

        function get_translations(val) {
            if (val) {
                get_translations.ans = val;
            }
            return get_translations.ans;
        };
        if (!get_translations.__argnames__) Object.defineProperties(get_translations, {
            __argnames__ : {value: ["val"]},
            __module__ : {value: "book_list.globals"}
        });

        ρσ_modules["book_list.globals"].session_data = session_data;
        ρσ_modules["book_list.globals"].set_session_data = set_session_data;
        ρσ_modules["book_list.globals"].get_session_data = get_session_data;
        ρσ_modules["book_list.globals"].main_js = main_js;
        ρσ_modules["book_list.globals"].get_current_query = get_current_query;
        ρσ_modules["book_list.globals"].get_db = get_db;
        ρσ_modules["book_list.globals"].get_translations = get_translations;
    })();

    (function(){
        var __name__ = "lru_cache";
        function lru_node(key, val) {
            return (function(){
                var ρσ_d = Object.create(null);
                ρσ_d["key"] = key;
                ρσ_d["val"] = val;
                ρσ_d["prev"] = null;
                ρσ_d["next"] = null;
                return ρσ_d;
            }).call(this);
        };
        if (!lru_node.__argnames__) Object.defineProperties(lru_node, {
            __argnames__ : {value: ["key", "val"]},
            __module__ : {value: "lru_cache"}
        });

        function LRUCache() {
            if (this.ρσ_object_id === undefined) Object.defineProperty(this, "ρσ_object_id", {"value":++ρσ_object_counter});
            LRUCache.prototype.__bind_methods__.call(this);
            LRUCache.prototype.__init__.apply(this, arguments);
        }
        Object.defineProperty(LRUCache.prototype, "__bind_methods__", {value: function () {
            this.set_head = LRUCache.prototype.set_head.bind(this);
            this.pop = LRUCache.prototype.pop.bind(this);
            this.set = LRUCache.prototype.set.bind(this);
            this.get = LRUCache.prototype.get.bind(this);
            this.clear = LRUCache.prototype.clear.bind(this);
        }});
        LRUCache.prototype.__init__ = function __init__(size) {
            var self = this;
            self.limit = 200;
            self.clear(size);
        };
        if (!LRUCache.prototype.__init__.__argnames__) Object.defineProperties(LRUCache.prototype.__init__, {
            __argnames__ : {value: ["size"]},
            __module__ : {value: "lru_cache"}
        });
        LRUCache.__argnames__ = LRUCache.prototype.__init__.__argnames__;
        LRUCache.__handles_kwarg_interpolation__ = LRUCache.prototype.__init__.__handles_kwarg_interpolation__;
        LRUCache.prototype.set_head = function set_head(node) {
            var self = this;
            node.next = self.head;
            node.prev = null;
            if (self.head !== null) {
                self.head.prev = node;
            }
            self.head = node;
            if (self.tail === null) {
                self.tail = node;
            }
            self.size += 1;
            (ρσ_expr_temp = self.map)[ρσ_bound_index(node.key, ρσ_expr_temp)] = node;
        };
        if (!LRUCache.prototype.set_head.__argnames__) Object.defineProperties(LRUCache.prototype.set_head, {
            __argnames__ : {value: ["node"]},
            __module__ : {value: "lru_cache"}
        });
        LRUCache.prototype.pop = function pop(key) {
            var self = this;
            var node;
            node = (ρσ_expr_temp = self.map)[(typeof key === "number" && key < 0) ? ρσ_expr_temp.length + key : key];
            if (!node) {
                return;
            }
            if (node.prev !== null) {
                node.prev.next = node.next;
            } else {
                self.head = node.next;
            }
            if (node.next !== null) {
                node.next.prev = node.prev;
            } else {
                self.tail = node.prev;
            }
            delete self.map[key];
            self.size -= 1;
        };
        if (!LRUCache.prototype.pop.__argnames__) Object.defineProperties(LRUCache.prototype.pop, {
            __argnames__ : {value: ["key"]},
            __module__ : {value: "lru_cache"}
        });
        LRUCache.prototype.set = function set(key, val) {
            var self = this;
            var node, existing;
            node = lru_node(key, val);
            existing = (ρσ_expr_temp = self.map)[(typeof key === "number" && key < 0) ? ρσ_expr_temp.length + key : key];
            if (existing) {
                existing.value = node.value;
                self.pop(node.key);
            } else if (self.size > self.limit) {
                delete self.map[self.tail.key];
                self.size -= 1;
                self.tail = self.tail.prev;
                self.tail.next = null;
            }
            self.set_head(node);
        };
        if (!LRUCache.prototype.set.__argnames__) Object.defineProperties(LRUCache.prototype.set, {
            __argnames__ : {value: ["key", "val"]},
            __module__ : {value: "lru_cache"}
        });
        LRUCache.prototype.get = function get(key, defval) {
            var self = this;
            var existing, val, node;
            existing = (ρσ_expr_temp = self.map)[(typeof key === "number" && key < 0) ? ρσ_expr_temp.length + key : key];
            if (!existing) {
                return (defval === undefined) ? null : defval;
            }
            val = existing.value;
            node = lru_node(key, val);
            self.pop(key);
            self.set_head(node);
            return val;
        };
        if (!LRUCache.prototype.get.__argnames__) Object.defineProperties(LRUCache.prototype.get, {
            __argnames__ : {value: ["key", "defval"]},
            __module__ : {value: "lru_cache"}
        });
        LRUCache.prototype.clear = function clear(size) {
            var self = this;
            self.size = 0;
            self.map = Object.create(null);
            self.head = self.tail = null;
            if (typeof size === "number") {
                self.limit = size;
            }
        };
        if (!LRUCache.prototype.clear.__argnames__) Object.defineProperties(LRUCache.prototype.clear, {
            __argnames__ : {value: ["size"]},
            __module__ : {value: "lru_cache"}
        });
        LRUCache.prototype.__repr__ = function __repr__ () {
                        return "<" + __name__ + "." + this.constructor.name + " #" + this.ρσ_object_id + ">";
        };
        LRUCache.prototype.__str__ = function __str__ () {
            return this.__repr__();
        };
        Object.defineProperty(LRUCache.prototype, "__bases__", {value: []});

        ρσ_modules.lru_cache.lru_node = lru_node;
        ρσ_modules.lru_cache.LRUCache = LRUCache;
    })();

    (function(){
        var __name__ = "encodings";
        var utf8_decoder_table, _u8enc, utf8_encode;
        function base64encode(bytes, altchars, pad_char) {
            var l, remainder, main_length, encodings, ans, chunk;
            l = bytes.length;
            remainder = l % 3;
            main_length = l - remainder;
            encodings = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" + (altchars || "+/");
            pad_char = (pad_char === undefined) ? "=" : pad_char;
            ans = [];
            for (var i = 0; i < main_length; i += 3) {
                chunk = bytes[(typeof i === "number" && i < 0) ? bytes.length + i : i] << 16 | bytes[ρσ_bound_index(i + 1, bytes)] << 8 | bytes[ρσ_bound_index(i + 2, bytes)];
                ans.push(encodings[ρσ_bound_index((chunk & 16515072) >> 18, encodings)], encodings[ρσ_bound_index((chunk & 258048) >> 12, encodings)], encodings[ρσ_bound_index((chunk & 4032) >> 6, encodings)], encodings[ρσ_bound_index(chunk & 63, encodings)]);
            }
            if (remainder === 1) {
                chunk = bytes[(typeof main_length === "number" && main_length < 0) ? bytes.length + main_length : main_length];
                ans.push(encodings[ρσ_bound_index((chunk & 252) >> 2, encodings)], encodings[ρσ_bound_index((chunk & 3) << 4, encodings)], pad_char, pad_char);
            } else if (remainder === 2) {
                chunk = bytes[(typeof main_length === "number" && main_length < 0) ? bytes.length + main_length : main_length] << 8 | bytes[ρσ_bound_index(main_length + 1, bytes)];
                ans.push(encodings[ρσ_bound_index((chunk & 64512) >> 10, encodings)], encodings[ρσ_bound_index((chunk & 1008) >> 4, encodings)], encodings[ρσ_bound_index((chunk & 15) << 2, encodings)], pad_char);
            }
            return ans.join("");
        };
        if (!base64encode.__argnames__) Object.defineProperties(base64encode, {
            __argnames__ : {value: ["bytes", "altchars", "pad_char"]},
            __module__ : {value: "encodings"}
        });

        function base64decode(string) {
            var chars, ans, i;
            if (typeof window !== "undefined") {
                chars = window.atob(string);
            } else {
                chars = new Buffer(string, "base64").toString("binary");
            }
            ans = new Uint8Array(chars.length);
            for (var ρσ_Index0 = 0; ρσ_Index0 < ans.length; ρσ_Index0++) {
                i = ρσ_Index0;
                ans[(typeof i === "number" && i < 0) ? ans.length + i : i] = chars.charCodeAt(i);
            }
            return ans;
        };
        if (!base64decode.__argnames__) Object.defineProperties(base64decode, {
            __argnames__ : {value: ["string"]},
            __module__ : {value: "encodings"}
        });

        function urlsafe_b64encode(bytes, pad_char) {
            return base64encode(bytes, "-_", pad_char);
        };
        if (!urlsafe_b64encode.__argnames__) Object.defineProperties(urlsafe_b64encode, {
            __argnames__ : {value: ["bytes", "pad_char"]},
            __module__ : {value: "encodings"}
        });

        function urlsafe_b64decode(string) {
            string = String.prototype.replace.call(string, /[_-]/g, (function() {
                var ρσ_anonfunc = function (m) {
                    return (m === "-") ? "+" : "/";
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["m"]},
                    __module__ : {value: "encodings"}
                });
                return ρσ_anonfunc;
            })());
            return base64decode(string);
        };
        if (!urlsafe_b64decode.__argnames__) Object.defineProperties(urlsafe_b64decode, {
            __argnames__ : {value: ["string"]},
            __module__ : {value: "encodings"}
        });

        function hexlify(bytes) {
            var ans, x;
            ans = [];
            for (var i = 0; i < bytes.length; i++) {
                x = bytes[(typeof i === "number" && i < 0) ? bytes.length + i : i].toString(16);
                if (x.length === 1) {
                    x = "0" + x;
                }
                ans.push(x);
            }
            return ans.join("");
        };
        if (!hexlify.__argnames__) Object.defineProperties(hexlify, {
            __argnames__ : {value: ["bytes"]},
            __module__ : {value: "encodings"}
        });

        function unhexlify(string) {
            var num, ans, x;
            num = Math.floor(string.length / 2);
            if (num * 2 !== string.length) {
                throw new ValueError("string length is not a multiple of two");
            }
            ans = new Uint8Array(num);
            for (var i = 0; i < num; i++) {
                x = parseInt(string.slice(i * 2, i * 2 + 2), 16);
                if (isNaN(x)) {
                    throw new ValueError("string is not hex-encoded");
                }
                ans[(typeof i === "number" && i < 0) ? ans.length + i : i] = x;
            }
            return ans;
        };
        if (!unhexlify.__argnames__) Object.defineProperties(unhexlify, {
            __argnames__ : {value: ["string"]},
            __module__ : {value: "encodings"}
        });

        utf8_decoder_table = [
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, // 00..1f
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, // 20..3f
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, // 40..5f
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, // 60..7f
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9, // 80..9f
  7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7, // a0..bf
  8,8,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2, // c0..df
  0xa,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x4,0x3,0x3, // e0..ef
  0xb,0x6,0x6,0x6,0x5,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8, // f0..ff
  0x0,0x1,0x2,0x3,0x5,0x8,0x7,0x1,0x1,0x1,0x4,0x6,0x1,0x1,0x1,0x1, // s0..s0
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,0,1,0,1,1,1,1,1,1, // s1..s2
  1,2,1,1,1,1,1,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1, // s3..s4
  1,2,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,3,1,3,1,1,1,1,1,1, // s5..s6
  1,3,1,1,1,1,1,3,1,3,1,1,1,1,1,1,1,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1, // s7..s8
];
        function _from_code_point(x) {
            if (x <= 65535) {
                return String.fromCharCode(x);
            }
            x -= 65536;
            return String.fromCharCode((x >> 10) + 55296, x % 1024 + 56320);
        };
        if (!_from_code_point.__argnames__) Object.defineProperties(_from_code_point, {
            __argnames__ : {value: ["x"]},
            __module__ : {value: "encodings"}
        });

        function utf8_decode(bytes, errors, replacement) {
            var state, ans, byte, typ, codep;
            state = 0;
            ans = [];
            for (var i = 0, l = bytes.length; i < l; i++) {
                byte = bytes[(typeof i === "number" && i < 0) ? bytes.length + i : i];
                typ = utf8_decoder_table[(typeof byte === "number" && byte < 0) ? utf8_decoder_table.length + byte : byte];
                codep = (state !== 0) ? byte & 63 | codep << 6 : 255 >> typ & byte;
                state = utf8_decoder_table[ρσ_bound_index(256 + state * 16 + typ, utf8_decoder_table)];
                if (state === 0) {
                    ans.push(_from_code_point(codep));
                } else if (state === 1) {
                    if (!errors || errors === "strict") {
                        throw new UnicodeDecodeError(str.format("The byte 0x{:02x} at position {} is not valid UTF-8", byte, i));
                    } else if (errors === "replace") {
                        ans.push(replacement || "?");
                    }
                }
            }
            return ans.join("");
        };
        if (!utf8_decode.__argnames__) Object.defineProperties(utf8_decode, {
            __argnames__ : {value: ["bytes", "errors", "replacement"]},
            __module__ : {value: "encodings"}
        });

        function utf8_encode_js(string) {
            var escstr, ans, ch, i;
            escstr = encodeURIComponent(string);
            ans = [];
            for (var i = 0; i < escstr.length; i++) {
                ch = escstr[(typeof i === "number" && i < 0) ? escstr.length + i : i];
                if (ch === "%") {
                    ans.push(parseInt(escstr.slice(i + 1, i + 3), 16));
                    i += 2;
                } else {
                    ans.push(ch.charCodeAt(0));
                }
            }
            return new Uint8Array(ans);
        };
        if (!utf8_encode_js.__argnames__) Object.defineProperties(utf8_encode_js, {
            __argnames__ : {value: ["string"]},
            __module__ : {value: "encodings"}
        });

        if (typeof TextEncoder === "function") {
            _u8enc = new TextEncoder("utf-8");
            utf8_encode = _u8enc.encode.bind(_u8enc);
            _u8enc = undefined;
        } else {
            utf8_encode = utf8_encode_js;
        }
        function utf8_encode_native(string) {
            return _u8enc.encode(string);
        };
        if (!utf8_encode_native.__argnames__) Object.defineProperties(utf8_encode_native, {
            __argnames__ : {value: ["string"]},
            __module__ : {value: "encodings"}
        });

        ρσ_modules.encodings.utf8_decoder_table = utf8_decoder_table;
        ρσ_modules.encodings._u8enc = _u8enc;
        ρσ_modules.encodings.utf8_encode = utf8_encode;
        ρσ_modules.encodings.base64encode = base64encode;
        ρσ_modules.encodings.base64decode = base64decode;
        ρσ_modules.encodings.urlsafe_b64encode = urlsafe_b64encode;
        ρσ_modules.encodings.urlsafe_b64decode = urlsafe_b64decode;
        ρσ_modules.encodings.hexlify = hexlify;
        ρσ_modules.encodings.unhexlify = unhexlify;
        ρσ_modules.encodings._from_code_point = _from_code_point;
        ρσ_modules.encodings.utf8_decode = utf8_decode;
        ρσ_modules.encodings.utf8_encode_js = utf8_encode_js;
        ρσ_modules.encodings.utf8_encode_native = utf8_encode_native;
    })();

    (function(){
        var __name__ = "uuid";
        var RFC_4122, random_bytes;
        var hexlify = ρσ_modules.encodings.hexlify;
        var urlsafe_b64decode = ρσ_modules.encodings.urlsafe_b64decode;
        var urlsafe_b64encode = ρσ_modules.encodings.urlsafe_b64encode;

        RFC_4122 = 1;
        if (typeof crypto === "object" && crypto.getRandomValues) {
            random_bytes = (function() {
                var ρσ_anonfunc = function (num) {
                    var ans;
                    ans = new Uint8Array(num || 16);
                    crypto.getRandomValues(ans);
                    return ans;
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["num"]},
                    __module__ : {value: "uuid"}
                });
                return ρσ_anonfunc;
            })();
        } else {
            random_bytes = (function() {
                var ρσ_anonfunc = function (num) {
                    var ans, i;
                    ans = new Uint8Array(num || 16);
                    for (var ρσ_Index0 = 0; ρσ_Index0 < ans.length; ρσ_Index0++) {
                        i = ρσ_Index0;
                        ans[(typeof i === "number" && i < 0) ? ans.length + i : i] = Math.floor(Math.random() * 256);
                    }
                    return ans;
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["num"]},
                    __module__ : {value: "uuid"}
                });
                return ρσ_anonfunc;
            })();
        }
        function uuid4_bytes() {
            var data;
            data = random_bytes();
            data[6] = 64 | data[6] & 15;
            data[8] = (data[8] >> 4 & 3 | 8) << 4 | data[8] & 15;
            return data;
        };
        if (!uuid4_bytes.__module__) Object.defineProperties(uuid4_bytes, {
            __module__ : {value: "uuid"}
        });

        function as_str() {
            var h;
            h = this.hex;
            return h.slice(0, 8) + "-" + h.slice(8, 12) + "-" + h.slice(12, 16) + "-" + h.slice(16, 20) + "-" + h.slice(20);
        };
        if (!as_str.__module__) Object.defineProperties(as_str, {
            __module__ : {value: "uuid"}
        });

        function uuid4() {
            var b;
            b = uuid4_bytes();
            return (function(){
                var ρσ_d = Object.create(null);
                ρσ_d["hex"] = hexlify(b);
                ρσ_d["bytes"] = b;
                ρσ_d["variant"] = RFC_4122;
                ρσ_d["version"] = 4;
                ρσ_d["__str__"] = as_str;
                ρσ_d["toString"] = as_str;
                return ρσ_d;
            }).call(this);
        };
        if (!uuid4.__module__) Object.defineProperties(uuid4, {
            __module__ : {value: "uuid"}
        });

        function num_to_string(numbers, alphabet, pad_to_length) {
            var ans, alphabet_len, x, number;
            ans = [];
            alphabet_len = alphabet.length;
            numbers = Array.prototype.slice.call(numbers);
            for (var i = 0; i < numbers.length - 1; i++) {
                x = divmod(numbers[(typeof i === "number" && i < 0) ? numbers.length + i : i], alphabet_len);
                numbers[(typeof i === "number" && i < 0) ? numbers.length + i : i] = x[0];
                numbers[ρσ_bound_index(i + 1, numbers)] += x[1];
            }
            for (var i = 0; i < numbers.length; i++) {
                number = numbers[(typeof i === "number" && i < 0) ? numbers.length + i : i];
                while (number) {
                    x = divmod(number, alphabet_len);
                    number = x[0];
                    ans.push(alphabet[ρσ_bound_index(x[1], alphabet)]);
                }
            }
            if (pad_to_length && pad_to_length > ans.length) {
                ans.push(alphabet[0].repeat(pad_to_length - ans.length));
            }
            return ans.join("");
        };
        if (!num_to_string.__argnames__) Object.defineProperties(num_to_string, {
            __argnames__ : {value: ["numbers", "alphabet", "pad_to_length"]},
            __module__ : {value: "uuid"}
        });

        function short_uuid() {
            return urlsafe_b64encode(random_bytes(), "");
        };
        if (!short_uuid.__module__) Object.defineProperties(short_uuid, {
            __module__ : {value: "uuid"}
        });

        function short_uuid4() {
            return urlsafe_b64encode(uuid4_bytes(), "");
        };
        if (!short_uuid4.__module__) Object.defineProperties(short_uuid4, {
            __module__ : {value: "uuid"}
        });

        function decode_short_uuid(val) {
            return urlsafe_b64decode(val + "==");
        };
        if (!decode_short_uuid.__argnames__) Object.defineProperties(decode_short_uuid, {
            __argnames__ : {value: ["val"]},
            __module__ : {value: "uuid"}
        });

        ρσ_modules.uuid.RFC_4122 = RFC_4122;
        ρσ_modules.uuid.random_bytes = random_bytes;
        ρσ_modules.uuid.uuid4_bytes = uuid4_bytes;
        ρσ_modules.uuid.as_str = as_str;
        ρσ_modules.uuid.uuid4 = uuid4;
        ρσ_modules.uuid.num_to_string = num_to_string;
        ρσ_modules.uuid.short_uuid = short_uuid;
        ρσ_modules.uuid.short_uuid4 = short_uuid4;
        ρσ_modules.uuid.decode_short_uuid = decode_short_uuid;
    })();

    (function(){
        var __name__ = "session";
        var defaults, is_local_setting, default_interface_data;
        var short_uuid = ρσ_modules.uuid.short_uuid;

        var ajax_send = ρσ_modules.ajax.ajax_send;

        defaults = (function(){
            var ρσ_d = Object.create(null);
            ρσ_d["copy_to_library_dupes"] = "add;overwrite";
            ρσ_d["last_sort_order"] = Object.create(null);
            ρσ_d["show_all_metadata"] = false;
            ρσ_d["sort"] = "timestamp.desc";
            ρσ_d["view_mode"] = "cover_grid";
            ρσ_d["fts_related_words"] = true;
            ρσ_d["and_search_terms"] = false;
            ρσ_d["collapse_at"] = 25;
            ρσ_d["dont_collapse"] = "";
            ρσ_d["hide_empty_categories"] = "no";
            ρσ_d["partition_method"] = "first letter";
            ρσ_d["sort_tags_by"] = "name";
            ρσ_d["background_image_fade"] = 0;
            ρσ_d["background_image_style"] = "scaled";
            ρσ_d["background_image"] = null;
            ρσ_d["base_font_size"] = 16;
            ρσ_d["book_scrollbar"] = false;
            ρσ_d["columns_per_screen"] = (function(){
                var ρσ_d = Object.create(null);
                ρσ_d["portrait"] = 0;
                ρσ_d["landscape"] = 0;
                return ρσ_d;
            }).call(this);
            ρσ_d["controls_help_shown_count"] = 0;
            ρσ_d["controls_help_shown_count_rtl_page_progression"] = 0;
            ρσ_d["cover_preserve_aspect_ratio"] = true;
            ρσ_d["current_color_scheme"] = "system";
            ρσ_d["footer"] = (function(){
                var ρσ_d = Object.create(null);
                ρσ_d["right"] = "progress";
                return ρσ_d;
            }).call(this);
            ρσ_d["header"] = Object.create(null);
            ρσ_d["controls_footer"] = (function(){
                var ρσ_d = Object.create(null);
                ρσ_d["right"] = "progress";
                return ρσ_d;
            }).call(this);
            ρσ_d["left-margin"] = Object.create(null);
            ρσ_d["right-margin"] = Object.create(null);
            ρσ_d["hide_tooltips"] = false;
            ρσ_d["keyboard_shortcuts"] = Object.create(null);
            ρσ_d["lines_per_sec_auto"] = 1;
            ρσ_d["lines_per_sec_smooth"] = 20;
            ρσ_d["margin_bottom"] = 20;
            ρσ_d["margin_left"] = 20;
            ρσ_d["margin_right"] = 20;
            ρσ_d["margin_top"] = 20;
            ρσ_d["max_text_height"] = 0;
            ρσ_d["max_text_width"] = 0;
            ρσ_d["override_book_colors"] = "never";
            ρσ_d["paged_margin_clicks_scroll_by_screen"] = true;
            ρσ_d["paged_wheel_scrolls_by_screen"] = false;
            ρσ_d["paged_taps_scroll_by_screen"] = false;
            ρσ_d["paged_pixel_scroll_threshold"] = 60;
            ρσ_d["read_mode"] = "paged";
            ρσ_d["scroll_auto_boundary_delay"] = 5;
            ρσ_d["scroll_stop_boundaries"] = false;
            ρσ_d["standalone_font_settings"] = Object.create(null);
            ρσ_d["standalone_misc_settings"] = Object.create(null);
            ρσ_d["standalone_recently_opened"] = [];
            ρσ_d["user_color_schemes"] = Object.create(null);
            ρσ_d["user_stylesheet"] = "";
            ρσ_d["word_actions"] = [];
            ρσ_d["highlight_style"] = null;
            ρσ_d["highlights_export_format"] = "text";
            ρσ_d["custom_highlight_styles"] = [];
            ρσ_d["show_selection_bar"] = true;
            ρσ_d["net_search_url"] = "https://google.com/search?q={q}";
            ρσ_d["selection_bar_actions"] = ['copy', 'lookup', 'highlight', 'remove_highlight', 'search_net', 'clear'];
            ρσ_d["selection_bar_quick_highlights"] = [];
            ρσ_d["skipped_dialogs"] = {};
            ρσ_d["tts"] = {};
            ρσ_d["tts_backend"] = {};
            ρσ_d["fullscreen_when_opening"] = "auto";
            ρσ_d["book_search_mode"] = "contains";
            ρσ_d["book_search_case_sensitive"] = false;
            ρσ_d["reverse_page_turn_zones"] = false;
            return ρσ_d;
        }).call(this);
        is_local_setting = (function(){
            var ρσ_d = Object.create(null);
            ρσ_d["skipped_dialogs"] = true;
            ρσ_d["background_image_fade"] = true;
            ρσ_d["background_image_style"] = true;
            ρσ_d["background_image"] = true;
            ρσ_d["base_font_size"] = true;
            ρσ_d["columns_per_screen"] = true;
            ρσ_d["controls_help_shown_count"] = true;
            ρσ_d["controls_help_shown_count_rtl_page_progression"] = true;
            ρσ_d["lines_per_sec_auto"] = true;
            ρσ_d["lines_per_sec_smooth"] = true;
            ρσ_d["margin_bottom"] = true;
            ρσ_d["margin_left"] = true;
            ρσ_d["margin_right"] = true;
            ρσ_d["margin_top"] = true;
            ρσ_d["max_text_height"] = true;
            ρσ_d["max_text_width"] = true;
            ρσ_d["read_mode"] = "paged";
            ρσ_d["scroll_auto_boundary_delay"] = true;
            ρσ_d["scroll_stop_boundaries"] = true;
            ρσ_d["standalone_font_settings"] = true;
            ρσ_d["standalone_misc_settings"] = true;
            ρσ_d["standalone_recently_opened"] = true;
            ρσ_d["user_stylesheet"] = true;
            ρσ_d["highlight_style"] = true;
            ρσ_d["tts"] = true;
            ρσ_d["tts_backend"] = true;
            ρσ_d["fullscreen_when_opening"] = true;
            ρσ_d["highlights_export_format"] = true;
            ρσ_d["book_search_mode"] = true;
            ρσ_d["book_search_case_sensitive"] = true;
            ρσ_d["reverse_page_turn_zones"] = true;
            return ρσ_d;
        }).call(this);
        function session_defaults() {
            return defaults;
        };
        if (!session_defaults.__module__) Object.defineProperties(session_defaults, {
            __module__ : {value: "session"}
        });

        function storage_available(which) {
            var storage, x;
            which = which || "localStorage";
            try {
                storage = window[(typeof which === "number" && which < 0) ? window.length + which : which];
                x = "__storage__test__";
                storage.setItem(x, x);
                storage.removeItem(x);
                return true;
            } catch (ρσ_Exception) {
                ρσ_last_exception = ρσ_Exception;
                {
                    return false;
                } 
            }
        };
        if (!storage_available.__argnames__) Object.defineProperties(storage_available, {
            __argnames__ : {value: ["which"]},
            __module__ : {value: "session"}
        });

        function FakeStorage() {
            if (this.ρσ_object_id === undefined) Object.defineProperty(this, "ρσ_object_id", {"value":++ρσ_object_counter});
            FakeStorage.prototype.__bind_methods__.call(this);
            FakeStorage.prototype.__init__.apply(this, arguments);
        }
        Object.defineProperty(FakeStorage.prototype, "__bind_methods__", {value: function () {
            this.getItem = FakeStorage.prototype.getItem.bind(this);
            this.setItem = FakeStorage.prototype.setItem.bind(this);
            this.clear = FakeStorage.prototype.clear.bind(this);
        }});
        FakeStorage.prototype.__init__ = function __init__() {
            var self = this;
            self.data = Object.create(null);
        };
        if (!FakeStorage.prototype.__init__.__module__) Object.defineProperties(FakeStorage.prototype.__init__, {
            __module__ : {value: "session"}
        });
        FakeStorage.__argnames__ = FakeStorage.prototype.__init__.__argnames__;
        FakeStorage.__handles_kwarg_interpolation__ = FakeStorage.prototype.__init__.__handles_kwarg_interpolation__;
        FakeStorage.prototype.getItem = function getItem(key) {
            var self = this;
            return (ρσ_expr_temp = self.data)[(typeof key === "number" && key < 0) ? ρσ_expr_temp.length + key : key];
        };
        if (!FakeStorage.prototype.getItem.__argnames__) Object.defineProperties(FakeStorage.prototype.getItem, {
            __argnames__ : {value: ["key"]},
            __module__ : {value: "session"}
        });
        FakeStorage.prototype.setItem = function setItem(key, value) {
            var self = this;
            if (typeof value !== "string") {
                value = JSON.stringify(value);
            }
            (ρσ_expr_temp = self.data)[(typeof key === "number" && key < 0) ? ρσ_expr_temp.length + key : key] = value;
        };
        if (!FakeStorage.prototype.setItem.__argnames__) Object.defineProperties(FakeStorage.prototype.setItem, {
            __argnames__ : {value: ["key", "value"]},
            __module__ : {value: "session"}
        });
        FakeStorage.prototype.clear = function clear() {
            var self = this;
            self.data = Object.create(null);
        };
        if (!FakeStorage.prototype.clear.__module__) Object.defineProperties(FakeStorage.prototype.clear, {
            __module__ : {value: "session"}
        });
        FakeStorage.prototype.__repr__ = function __repr__ () {
                        return "<" + __name__ + "." + this.constructor.name + " #" + this.ρσ_object_id + ">";
        };
        FakeStorage.prototype.__str__ = function __str__ () {
            return this.__repr__();
        };
        Object.defineProperty(FakeStorage.prototype, "__bases__", {value: []});

        function get_session_storage() {
            if (!get_session_storage.ans) {
                if (storage_available("localStorage")) {
                    get_session_storage.ans = window.localStorage;
                } else if (storage_available("sessionStorage")) {
                    get_session_storage.ans = window.sessionStorage;
                    console.error("localStorage not available using sessionStorage instead");
                } else {
                    get_session_storage.ans = new FakeStorage;
                    console.error("sessionStorage and localStorage not available using a temp cache instead");
                }
            }
            return get_session_storage.ans;
        };
        if (!get_session_storage.__module__) Object.defineProperties(get_session_storage, {
            __module__ : {value: "session"}
        });

        function SessionData() {
            if (this.ρσ_object_id === undefined) Object.defineProperty(this, "ρσ_object_id", {"value":++ρσ_object_counter});
            SessionData.prototype.__bind_methods__.call(this);
            SessionData.prototype.__init__.apply(this, arguments);
        }
        Object.defineProperty(SessionData.prototype, "__bind_methods__", {value: function () {
            this.get = SessionData.prototype.get.bind(this);
            this.set = SessionData.prototype.set.bind(this);
            this.clear = SessionData.prototype.clear.bind(this);
        }});
        SessionData.prototype.__init__ = function __init__() {
            var self = this;
            var global_prefix = (arguments[0] === undefined || ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? __init__.__defaults__.global_prefix : arguments[0];
            var ρσ_kwargs_obj = arguments[arguments.length-1];
            if (ρσ_kwargs_obj === null || typeof ρσ_kwargs_obj !== "object" || ρσ_kwargs_obj [ρσ_kwargs_symbol] !== true) ρσ_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "global_prefix")){
                global_prefix = ρσ_kwargs_obj.global_prefix;
            }
            self.global_prefix = global_prefix || "calibre-session-";
            self.storage = get_session_storage();
            self.overflow_storage = Object.create(null);
            self.has_overflow = false;
        };
        if (!SessionData.prototype.__init__.__defaults__) Object.defineProperties(SessionData.prototype.__init__, {
            __defaults__ : {value: {global_prefix:null}},
            __handles_kwarg_interpolation__ : {value: true},
            __argnames__ : {value: ["global_prefix"]},
            __module__ : {value: "session"}
        });
        SessionData.__argnames__ = SessionData.prototype.__init__.__argnames__;
        SessionData.__handles_kwarg_interpolation__ = SessionData.prototype.__init__.__handles_kwarg_interpolation__;
        SessionData.prototype.get = function get(key, defval) {
            var self = this;
            var ans;
            key = self.global_prefix + key;
            if (self.has_overflow) {
                ans = (ρσ_expr_temp = self.overflow_storage)[(typeof key === "number" && key < 0) ? ρσ_expr_temp.length + key : key];
                if (ans === undefined) {
                    ans = self.storage.getItem(key);
                }
            } else {
                ans = self.storage.getItem(key);
            }
            if (ans === undefined || ans === null) {
                if (defval === undefined) {
                    defval = null;
                }
                return defval;
            }
            try {
                return JSON.parse(ans);
            } catch (ρσ_Exception) {
                ρσ_last_exception = ρσ_Exception;
                {
                    if (defval === undefined) {
                        defval = null;
                    }
                    return defval;
                } 
            }
        };
        if (!SessionData.prototype.get.__argnames__) Object.defineProperties(SessionData.prototype.get, {
            __argnames__ : {value: ["key", "defval"]},
            __module__ : {value: "session"}
        });
        SessionData.prototype.set = function set(key, value) {
            var self = this;
            key = self.global_prefix + key;
            if (value === null) {
                self.storage.removeItem(key);
                delete self.overflow_storage[key];
                return true;
            }
            value = JSON.stringify(value);
            try {
                self.storage.setItem(key, value);
                delete self.overflow_storage[key];
                return true;
            } catch (ρσ_Exception) {
                ρσ_last_exception = ρσ_Exception;
                {
                    (ρσ_expr_temp = self.overflow_storage)[(typeof key === "number" && key < 0) ? ρσ_expr_temp.length + key : key] = value;
                    self.has_overflow = true;
                    console.error("session storage has overflowed, using a temp cache instead");
                } 
            }
            return false;
        };
        if (!SessionData.prototype.set.__argnames__) Object.defineProperties(SessionData.prototype.set, {
            __argnames__ : {value: ["key", "value"]},
            __module__ : {value: "session"}
        });
        SessionData.prototype.clear = function clear() {
            var self = this;
            self.storage.clear();
            self.overflow_storage = Object.create(null);
            self.has_overflow = false;
        };
        if (!SessionData.prototype.clear.__module__) Object.defineProperties(SessionData.prototype.clear, {
            __module__ : {value: "session"}
        });
        SessionData.prototype.__repr__ = function __repr__ () {
                        return "<" + __name__ + "." + this.constructor.name + " #" + this.ρσ_object_id + ">";
        };
        SessionData.prototype.__str__ = function __str__ () {
            return this.__repr__();
        };
        Object.defineProperty(SessionData.prototype, "__bases__", {value: []});

        function local_storage() {
            if (!local_storage.storage) {
                local_storage.storage = new SessionData("calibre-local-");
            }
            return local_storage.storage;
        };
        if (!local_storage.__module__) Object.defineProperties(local_storage, {
            __module__ : {value: "session"}
        });

        function get_device_uuid() {
            var s, ans;
            if (!get_device_uuid.ans) {
                s = local_storage();
                ans = s.get("device_uuid");
                if (!ans) {
                    ans = short_uuid();
                    s.set("device_uuid", ans);
                }
                get_device_uuid.ans = ans;
            }
            return get_device_uuid.ans;
        };
        if (!get_device_uuid.__module__) Object.defineProperties(get_device_uuid, {
            __module__ : {value: "session"}
        });

        default_interface_data = (function(){
            var ρσ_d = Object.create(null);
            ρσ_d["username"] = null;
            ρσ_d["output_format"] = "EPUB";
            ρσ_d["input_formats"] = (function(){
                var s = ρσ_set();
                s.jsset.add("EPUB");
                s.jsset.add("MOBI");
                s.jsset.add("AZW3");
                return s;
            })();
            ρσ_d["gui_pubdate_display_format"] = "MMM yyyy";
            ρσ_d["gui_timestamp_display_format"] = "dd MMM yyyy";
            ρσ_d["gui_last_modified_display_format"] = "dd MMM yyyy";
            ρσ_d["use_roman_numerals_for_series_number"] = true;
            ρσ_d["default_library_id"] = null;
            ρσ_d["default_book_list_mode"] = defaults.view_mode;
            ρσ_d["library_map"] = null;
            ρσ_d["search_the_net_urls"] = ρσ_list_decorate([]);
            ρσ_d["donate_link"] = "https://calibre-ebook.com/donate";
            ρσ_d["icon_map"] = Object.create(null);
            ρσ_d["icon_path"] = "";
            ρσ_d["custom_list_template"] = null;
            ρσ_d["num_per_page"] = 50;
            ρσ_d["lang_code_for_user_manual"] = "";
            return ρσ_d;
        }).call(this);
        function get_interface_data() {
            var ans, k;
            if (!get_interface_data.storage) {
                get_interface_data.storage = new SessionData("calibre-interface-data-");
            }
            ans = get_interface_data.storage.get("current");
            if (ans) {
                ans.is_default = false;
            } else {
                ans = (function(){
                    var ρσ_d = Object.create(null);
                    ρσ_d["is_default"] = true;
                    return ρσ_d;
                }).call(this);
                var ρσ_Iter0 = ρσ_Iterable(default_interface_data);
                for (var ρσ_Index0 = 0; ρσ_Index0 < ρσ_Iter0.length; ρσ_Index0++) {
                    k = ρσ_Iter0[ρσ_Index0];
                    ans[(typeof k === "number" && k < 0) ? ans.length + k : k] = default_interface_data[(typeof k === "number" && k < 0) ? default_interface_data.length + k : k];
                }
            }
            return ans;
        };
        if (!get_interface_data.__module__) Object.defineProperties(get_interface_data, {
            __module__ : {value: "session"}
        });

        function update_interface_data(new_data) {
            var data, nval, k;
            data = get_interface_data();
            var ρσ_Iter1 = ρσ_Iterable(default_interface_data);
            for (var ρσ_Index1 = 0; ρσ_Index1 < ρσ_Iter1.length; ρσ_Index1++) {
                k = ρσ_Iter1[ρσ_Index1];
                nval = new_data[(typeof k === "number" && k < 0) ? new_data.length + k : k];
                if (k !== undefined) {
                    data[(typeof k === "number" && k < 0) ? data.length + k : k] = nval;
                }
            }
            if (!get_interface_data.storage) {
                get_interface_data.storage = new SessionData("calibre-interface-data-");
            }
            get_interface_data.storage.set("current", data);
        };
        if (!update_interface_data.__argnames__) Object.defineProperties(update_interface_data, {
            __argnames__ : {value: ["new_data"]},
            __module__ : {value: "session"}
        });

        function get_translations(newval) {
            if (!get_translations.storage) {
                get_translations.storage = new SessionData("calibre-translations-");
            }
            if ((typeof newval !== "undefined" && newval !== null)) {
                get_translations.storage.set("current", newval);
            } else {
                return get_translations.storage.get("current");
            }
        };
        if (!get_translations.__argnames__) Object.defineProperties(get_translations, {
            __argnames__ : {value: ["newval"]},
            __module__ : {value: "session"}
        });

        function UserSessionData() {
            if (this.ρσ_object_id === undefined) Object.defineProperty(this, "ρσ_object_id", {"value":++ρσ_object_counter});
            UserSessionData.prototype.__bind_methods__.call(this);
            UserSessionData.prototype.__init__.apply(this, arguments);
        }
        ρσ_extends(UserSessionData, SessionData);
        Object.defineProperty(UserSessionData.prototype, "__bind_methods__", {value: function () {
            SessionData.prototype.__bind_methods__ && SessionData.prototype.__bind_methods__.call(this);
            this.defval = UserSessionData.prototype.defval.bind(this);
            this.get = UserSessionData.prototype.get.bind(this);
            this.get_library_option = UserSessionData.prototype.get_library_option.bind(this);
            this.set = UserSessionData.prototype.set.bind(this);
            this.set_library_option = UserSessionData.prototype.set_library_option.bind(this);
            this.push_to_server = UserSessionData.prototype.push_to_server.bind(this);
        }});
        UserSessionData.prototype.__init__ = function __init__(username, saved_data) {
            var self = this;
            var key;
            self.prefix = (username || "") + "-";
            self.has_user = bool(username);
            self.username = username;
            SessionData.prototype.__init__.call(self);
            self.echo_changes = false;
            self.changes = Object.create(null);
            self.has_changes = false;
            self.push_timer_id = null;
            if (saved_data) {
                var ρσ_Iter2 = ρσ_Iterable(saved_data);
                for (var ρσ_Index2 = 0; ρσ_Index2 < ρσ_Iter2.length; ρσ_Index2++) {
                    key = ρσ_Iter2[ρσ_Index2];
                    if (!is_local_setting[(typeof key === "number" && key < 0) ? is_local_setting.length + key : key]) {
                        self.set(key, saved_data[(typeof key === "number" && key < 0) ? saved_data.length + key : key]);
                    }
                }
            }
            self.echo_changes = true;
        };
        if (!UserSessionData.prototype.__init__.__argnames__) Object.defineProperties(UserSessionData.prototype.__init__, {
            __argnames__ : {value: ["username", "saved_data"]},
            __module__ : {value: "session"}
        });
        UserSessionData.__argnames__ = UserSessionData.prototype.__init__.__argnames__;
        UserSessionData.__handles_kwarg_interpolation__ = UserSessionData.prototype.__init__.__handles_kwarg_interpolation__;
        UserSessionData.prototype.defval = function defval(key) {
            var self = this;
            return defaults[(typeof key === "number" && key < 0) ? defaults.length + key : key];
        };
        if (!UserSessionData.prototype.defval.__argnames__) Object.defineProperties(UserSessionData.prototype.defval, {
            __argnames__ : {value: ["key"]},
            __module__ : {value: "session"}
        });
        UserSessionData.prototype.get = function get(key, defval) {
            var self = this;
            if (defval === undefined) {
                defval = defaults[(typeof key === "number" && key < 0) ? defaults.length + key : key];
            }
            return SessionData.prototype.get.call(self, self.prefix + key, defval);
        };
        if (!UserSessionData.prototype.get.__argnames__) Object.defineProperties(UserSessionData.prototype.get, {
            __argnames__ : {value: ["key", "defval"]},
            __module__ : {value: "session"}
        });
        UserSessionData.prototype.get_library_option = function get_library_option(library_id, key, defval) {
            var self = this;
            var lkey;
            if (!library_id) {
                return self.get(key, defval);
            }
            lkey = key + "-||-" + library_id;
            if (defval === undefined) {
                defval = defaults[(typeof key === "number" && key < 0) ? defaults.length + key : key];
            }
            return self.get(lkey, defval);
        };
        if (!UserSessionData.prototype.get_library_option.__argnames__) Object.defineProperties(UserSessionData.prototype.get_library_option, {
            __argnames__ : {value: ["library_id", "key", "defval"]},
            __module__ : {value: "session"}
        });
        UserSessionData.prototype.set = function set(key, value) {
            var self = this;
            if (self.echo_changes && self.has_user && !is_local_setting[(typeof key === "number" && key < 0) ? is_local_setting.length + key : key]) {
                (ρσ_expr_temp = self.changes)[(typeof key === "number" && key < 0) ? ρσ_expr_temp.length + key : key] = value;
                self.has_changes = true;
                if (self.push_timer_id !== null) {
                    clearTimeout(self.push_timer_id);
                }
                self.push_timer_id = setTimeout(self.push_to_server.bind(self), 1e3);
            }
            return SessionData.prototype.set.call(self, self.prefix + key, value);
        };
        if (!UserSessionData.prototype.set.__argnames__) Object.defineProperties(UserSessionData.prototype.set, {
            __argnames__ : {value: ["key", "value"]},
            __module__ : {value: "session"}
        });
        UserSessionData.prototype.set_library_option = function set_library_option(library_id, key, value) {
            var self = this;
            if (library_id) {
                key = key + "-||-" + library_id;
            }
            return self.set(key, value);
        };
        if (!UserSessionData.prototype.set_library_option.__argnames__) Object.defineProperties(UserSessionData.prototype.set_library_option, {
            __argnames__ : {value: ["library_id", "key", "value"]},
            __module__ : {value: "session"}
        });
        UserSessionData.prototype.push_to_server = function push_to_server() {
            var self = this;
            if (self.has_changes) {
                ajax_send("interface-data/set-session-data", self.changes, (function() {
                    var ρσ_anonfunc = function (end_type, xhr, ev) {
                        if (end_type !== "load") {
                            console.error("Failed to send session data to server: " + xhr.error_html);
                        }
                    };
                    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                        __argnames__ : {value: ["end_type", "xhr", "ev"]},
                        __module__ : {value: "session"}
                    });
                    return ρσ_anonfunc;
                })());
                self.changes = Object.create(null);
                self.has_changes = false;
            }
        };
        if (!UserSessionData.prototype.push_to_server.__module__) Object.defineProperties(UserSessionData.prototype.push_to_server, {
            __module__ : {value: "session"}
        });
        UserSessionData.prototype.__repr__ = function __repr__ () {
            if(SessionData.prototype.__repr__) return SessionData.prototype.__repr__.call(this);
            return "<" + __name__ + "." + this.constructor.name + " #" + this.ρσ_object_id + ">";
        };
        UserSessionData.prototype.__str__ = function __str__ () {
            if(SessionData.prototype.__str__) return SessionData.prototype.__str__.call(this);
return this.__repr__();
        };
        Object.defineProperty(UserSessionData.prototype, "__bases__", {value: [SessionData]});

        ρσ_modules.session.defaults = defaults;
        ρσ_modules.session.is_local_setting = is_local_setting;
        ρσ_modules.session.default_interface_data = default_interface_data;
        ρσ_modules.session.session_defaults = session_defaults;
        ρσ_modules.session.storage_available = storage_available;
        ρσ_modules.session.FakeStorage = FakeStorage;
        ρσ_modules.session.get_session_storage = get_session_storage;
        ρσ_modules.session.SessionData = SessionData;
        ρσ_modules.session.local_storage = local_storage;
        ρσ_modules.session.get_device_uuid = get_device_uuid;
        ρσ_modules.session.get_interface_data = get_interface_data;
        ρσ_modules.session.update_interface_data = update_interface_data;
        ρσ_modules.session.get_translations = get_translations;
        ρσ_modules.session.UserSessionData = UserSessionData;
    })();

    (function(){
        var __name__ = "book_list.theme";
        var DARK, LIGHT, LIGHT_DARKER, LIGHT_GRADIENT, DT_DARK, DT_DARK_DARKER, DT_DARK_LIGHTER, DT_DARK_LIGTHER_CONTRAST, DT_LIGHT, DARK_GRADIENT, DEFAULT_COLORS, DEFAULT_SIZES, DEFAULT_FONTS;
        DARK = "#39322B";
        LIGHT = "#F6F3E9";
        LIGHT_DARKER = "#b6b3a8";
        LIGHT_GRADIENT = "linear-gradient(to bottom, {}, {})".format(LIGHT, LIGHT_DARKER);
        DT_DARK = "#2d2d2d";
        DT_DARK_DARKER = "black";
        DT_DARK_LIGHTER = "#777";
        DT_DARK_LIGTHER_CONTRAST = "#1d1d1d";
        DT_LIGHT = "#ddd";
        DARK_GRADIENT = "linear-gradient(to bottom, {}, {})".format(DT_DARK_LIGHTER, DT_DARK);
        function c(light, dark) {
            return (function(){
                var ρσ_d = Object.create(null);
                ρσ_d["light"] = light;
                ρσ_d["dark"] = dark || light;
                return ρσ_d;
            }).call(this);
        };
        if (!c.__argnames__) Object.defineProperties(c, {
            __argnames__ : {value: ["light", "dark"]},
            __module__ : {value: "book_list.theme"}
        });

        DEFAULT_COLORS = (function(){
            var ρσ_d = Object.create(null);
            ρσ_d["window-background"] = c(LIGHT, DT_DARK);
            ρσ_d["window-background2"] = c(LIGHT_DARKER, DT_DARK_LIGHTER);
            ρσ_d["window-foreground"] = c(DARK, DT_LIGHT);
            ρσ_d["window-error-foreground"] = c("red", "#C40233");
            ρσ_d["window-hover-foreground"] = c("red", "#C40233");
            ρσ_d["link-foreground"] = c("blue", "#6cb4ee");
            ρσ_d["bar-background"] = c(DARK, DT_DARK_LIGHTER);
            ρσ_d["bar-foreground"] = c(LIGHT, DT_DARK_LIGTHER_CONTRAST);
            ρσ_d["bar-highlight"] = c("yellow");
            ρσ_d["heart"] = c("#B92111");
            ρσ_d["list-hover-background"] = c(DARK, DT_DARK_LIGHTER);
            ρσ_d["list-hover-foreground"] = c(LIGHT, DT_DARK_LIGTHER_CONTRAST);
            ρσ_d["tree-highlight-item"] = c(LIGHT_DARKER, DT_DARK_LIGHTER);
            ρσ_d["button-start"] = c(DARK, DT_LIGHT);
            ρσ_d["button-end"] = c("#49423B", "#666");
            ρσ_d["button-text"] = c(LIGHT, DT_DARK);
            ρσ_d["dialog-background"] = c(LIGHT, DT_DARK);
            ρσ_d["dialog-background-image"] = c(LIGHT_GRADIENT, DARK_GRADIENT);
            ρσ_d["dialog-foreground"] = c(DARK, DT_LIGHT);
            ρσ_d["input-background"] = c("field", DT_DARK_DARKER);
            ρσ_d["input-foreground"] = c("fieldtext", DT_LIGHT);
            ρσ_d["input-focus-outline-color"] = c("#4D90FE", DT_LIGHT);
            return ρσ_d;
        }).call(this);
        DEFAULT_SIZES = (function(){
            var ρσ_d = Object.create(null);
            ρσ_d["title"] = "1.4rem";
            ρσ_d["item-list-title"] = "1.1rem";
            ρσ_d["item-list-subtitle"] = "0.8rem";
            return ρσ_d;
        }).call(this);
        DEFAULT_FONTS = (function(){
            var ρσ_d = Object.create(null);
            ρσ_d["main"] = "sans-serif";
            return ρσ_d;
        }).call(this);
        function set_ui_colors(is_dark_theme) {
            var attr, s, val, k;
            attr = (is_dark_theme) ? "dark" : "light";
            s = document.documentElement.style;
            var ρσ_Iter0 = ρσ_Iterable(DEFAULT_COLORS);
            for (var ρσ_Index0 = 0; ρσ_Index0 < ρσ_Iter0.length; ρσ_Index0++) {
                k = ρσ_Iter0[ρσ_Index0];
                val = (ρσ_expr_temp = DEFAULT_COLORS[(typeof k === "number" && k < 0) ? DEFAULT_COLORS.length + k : k])[(typeof attr === "number" && attr < 0) ? ρσ_expr_temp.length + attr : attr];
                s.setProperty("--calibre-color-" + k, val);
            }
            get_color_as_rgba.cache = Object.create(null);
            cached_color_to_rgba.cache = Object.create(null);
            document.documentElement.style.colorScheme = (is_dark_theme) ? "dark" : "light";
        };
        if (!set_ui_colors.__argnames__) Object.defineProperties(set_ui_colors, {
            __argnames__ : {value: ["is_dark_theme"]},
            __module__ : {value: "book_list.theme"}
        });

        function browser_in_dark_mode() {
            return window.matchMedia("(prefers-color-scheme: dark)").matches;
        };
        if (!browser_in_dark_mode.__module__) Object.defineProperties(browser_in_dark_mode, {
            __module__ : {value: "book_list.theme"}
        });

        function color_scheme() {
            return (browser_in_dark_mode() || document.documentElement.style.colorScheme === "dark") ? "dark" : "light";
        };
        if (!color_scheme.__module__) Object.defineProperties(color_scheme, {
            __module__ : {value: "book_list.theme"}
        });

        function css_for_variables() {
            var input_css, is_dark_theme, attr, ans, val, k;
            input_css = "\n        input, textarea {\n            color: var(--calibre-color-input-foreground);             background-color: var(--calibre-color-input-background);         }\n        input:focus, textarea:focus {\n            outline-color: var(--calibre-color-input-focus-outline-color);         }\n    ";
            is_dark_theme = browser_in_dark_mode();
            attr = (is_dark_theme) ? "dark" : "light";
            ans = [];
            var ρσ_Iter1 = ρσ_Iterable(DEFAULT_COLORS);
            for (var ρσ_Index1 = 0; ρσ_Index1 < ρσ_Iter1.length; ρσ_Index1++) {
                k = ρσ_Iter1[ρσ_Index1];
                val = (ρσ_expr_temp = DEFAULT_COLORS[(typeof k === "number" && k < 0) ? DEFAULT_COLORS.length + k : k])[(typeof attr === "number" && attr < 0) ? ρσ_expr_temp.length + attr : attr];
                ans.push("--calibre-color-" + ρσ_str.format("{}", k) + ": " + ρσ_str.format("{}", val) + ";");
            }
            return ":root { color-scheme: " + ρσ_str.format("{}", attr) + "; " + ans.join("\n") + "}\n\n" + input_css;
        };
        if (!css_for_variables.__module__) Object.defineProperties(css_for_variables, {
            __module__ : {value: "book_list.theme"}
        });

        function get_color(name) {
            return "var(--calibre-color-" + ρσ_str.format("{}", name) + ")";
        };
        if (!get_color.__argnames__) Object.defineProperties(get_color, {
            __argnames__ : {value: ["name"]},
            __module__ : {value: "book_list.theme"}
        });

        function color_to_rgba(color) {
            var cvs, ctx;
            cvs = document.createElement("canvas");
            cvs.height = 1;
            cvs.width = 1;
            if (color.startsWith("var(")) {
                color = window.getComputedStyle(document.documentElement).getPropertyValue(color.slice(4, -1));
            }
            ctx = cvs.getContext("2d");
            ctx.fillStyle = color;
            ctx.fillRect(0, 0, 1, 1);
            return ctx.getImageData(0, 0, 1, 1).data;
        };
        if (!color_to_rgba.__argnames__) Object.defineProperties(color_to_rgba, {
            __argnames__ : {value: ["color"]},
            __module__ : {value: "book_list.theme"}
        });

        function cached_color_to_rgba(color) {
            var cache;
            cache = cached_color_to_rgba.cache;
            if (!cache[(typeof color === "number" && color < 0) ? cache.length + color : color]) {
                cache[(typeof color === "number" && color < 0) ? cache.length + color : color] = color_to_rgba(color);
            }
            return cache[(typeof color === "number" && color < 0) ? cache.length + color : color];
        };
        if (!cached_color_to_rgba.__argnames__) Object.defineProperties(cached_color_to_rgba, {
            __argnames__ : {value: ["color"]},
            __module__ : {value: "book_list.theme"}
        });

        cached_color_to_rgba.cache = Object.create(null);
        function get_color_as_rgba(name) {
            var cache;
            cache = get_color_as_rgba.cache;
            if (!cache[(typeof name === "number" && name < 0) ? cache.length + name : name]) {
                cache[(typeof name === "number" && name < 0) ? cache.length + name : name] = color_to_rgba(get_color(name));
            }
            return cache[(typeof name === "number" && name < 0) ? cache.length + name : name];
        };
        if (!get_color_as_rgba.__argnames__) Object.defineProperties(get_color_as_rgba, {
            __argnames__ : {value: ["name"]},
            __module__ : {value: "book_list.theme"}
        });

        get_color_as_rgba.cache = Object.create(null);
        function get_font_size(name) {
            return DEFAULT_SIZES[(typeof name === "number" && name < 0) ? DEFAULT_SIZES.length + name : name];
        };
        if (!get_font_size.__argnames__) Object.defineProperties(get_font_size, {
            __argnames__ : {value: ["name"]},
            __module__ : {value: "book_list.theme"}
        });

        function get_font_family(name) {
            name = name || "main";
            return DEFAULT_FONTS[(typeof name === "number" && name < 0) ? DEFAULT_FONTS.length + name : name];
        };
        if (!get_font_family.__argnames__) Object.defineProperties(get_font_family, {
            __argnames__ : {value: ["name"]},
            __module__ : {value: "book_list.theme"}
        });

        ρσ_modules["book_list.theme"].DARK = DARK;
        ρσ_modules["book_list.theme"].LIGHT = LIGHT;
        ρσ_modules["book_list.theme"].LIGHT_DARKER = LIGHT_DARKER;
        ρσ_modules["book_list.theme"].LIGHT_GRADIENT = LIGHT_GRADIENT;
        ρσ_modules["book_list.theme"].DT_DARK = DT_DARK;
        ρσ_modules["book_list.theme"].DT_DARK_DARKER = DT_DARK_DARKER;
        ρσ_modules["book_list.theme"].DT_DARK_LIGHTER = DT_DARK_LIGHTER;
        ρσ_modules["book_list.theme"].DT_DARK_LIGTHER_CONTRAST = DT_DARK_LIGTHER_CONTRAST;
        ρσ_modules["book_list.theme"].DT_LIGHT = DT_LIGHT;
        ρσ_modules["book_list.theme"].DARK_GRADIENT = DARK_GRADIENT;
        ρσ_modules["book_list.theme"].DEFAULT_COLORS = DEFAULT_COLORS;
        ρσ_modules["book_list.theme"].DEFAULT_SIZES = DEFAULT_SIZES;
        ρσ_modules["book_list.theme"].DEFAULT_FONTS = DEFAULT_FONTS;
        ρσ_modules["book_list.theme"].c = c;
        ρσ_modules["book_list.theme"].set_ui_colors = set_ui_colors;
        ρσ_modules["book_list.theme"].browser_in_dark_mode = browser_in_dark_mode;
        ρσ_modules["book_list.theme"].color_scheme = color_scheme;
        ρσ_modules["book_list.theme"].css_for_variables = css_for_variables;
        ρσ_modules["book_list.theme"].get_color = get_color;
        ρσ_modules["book_list.theme"].color_to_rgba = color_to_rgba;
        ρσ_modules["book_list.theme"].cached_color_to_rgba = cached_color_to_rgba;
        ρσ_modules["book_list.theme"].get_color_as_rgba = get_color_as_rgba;
        ρσ_modules["book_list.theme"].get_font_size = get_font_size;
        ρσ_modules["book_list.theme"].get_font_family = get_font_family;
    })();

    (function(){
        var __name__ = "utils";
        var is_ios, ios_major_version, v, copy_hash, _roman, _data_ns;
        var encode_query = ρσ_modules.ajax.encode_query;

        var hexlify = ρσ_modules.encodings.hexlify;

        var get_font_family = ρσ_modules["book_list.theme"].get_font_family;

        is_ios = !!navigator.platform && /iPad|iPhone|iPod/.test(navigator.platform);
        ios_major_version = 0;
        if (!is_ios && !!navigator.platform && (typeof window !== "undefined" && window !== null) && window.navigator.platform === "MacIntel" && window.navigator.maxTouchPoints > 1) {
            is_ios = true;
        }
        if (is_ios) {
            v = navigator.appVersion.match(/OS (\d+)/);
            if (v && v[1]) {
                ios_major_version = parseInt(v[1], 10) || 0;
            }
        }
        function default_context_menu_should_be_allowed(evt) {
            if (evt.target && evt.target.tagName && ρσ_in(evt.target.tagName.toLowerCase(), ["input", 
            "textarea"])) {
                return true;
            }
            return false;
        };
        if (!default_context_menu_should_be_allowed.__argnames__) Object.defineProperties(default_context_menu_should_be_allowed, {
            __argnames__ : {value: ["evt"]},
            __module__ : {value: "utils"}
        });

        function debounce() {
            var func = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[0];
            var wait = ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[1];
            var immediate = (arguments[2] === undefined || ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? debounce.__defaults__.immediate : arguments[2];
            var ρσ_kwargs_obj = arguments[arguments.length-1];
            if (ρσ_kwargs_obj === null || typeof ρσ_kwargs_obj !== "object" || ρσ_kwargs_obj [ρσ_kwargs_symbol] !== true) ρσ_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "immediate")){
                immediate = ρσ_kwargs_obj.immediate;
            }
            var timeout;
            timeout = null;
            return (function() {
                var ρσ_anonfunc = function debounce_inner() {
                    var ρσ_unpack, context, args, call_now;
                    ρσ_unpack = [this, arguments];
                    context = ρσ_unpack[0];
                    args = ρσ_unpack[1];
                    function later() {
                        timeout = null;
                        if (!immediate) {
                            func.apply(context, args);
                        }
                    };
                    if (!later.__module__) Object.defineProperties(later, {
                        __module__ : {value: "utils"}
                    });

                    call_now = immediate && !timeout;
                    window.clearTimeout(timeout);
                    timeout = window.setTimeout(later, wait);
                    if (call_now) {
                        func.apply(context, args);
                    }
                };
                if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
                    __module__ : {value: "utils"}
                });
                return ρσ_anonfunc;
            })();
        };
        if (!debounce.__defaults__) Object.defineProperties(debounce, {
            __defaults__ : {value: {immediate:false}},
            __handles_kwarg_interpolation__ : {value: true},
            __argnames__ : {value: ["func", "wait", "immediate"]},
            __module__ : {value: "utils"}
        });

        if (Object.assign) {
            copy_hash = (function() {
                var ρσ_anonfunc = function (obj) {
                    return Object.assign(Object.create(null), obj);
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["obj"]},
                    __module__ : {value: "utils"}
                });
                return ρσ_anonfunc;
            })();
        } else {
            copy_hash = (function() {
                var ρσ_anonfunc = function (obj) {
                    return (function() {
                        var ρσ_Iter = ρσ_Iterable(Object.keys(obj)), ρσ_Result = Object.create(null), k;
                        for (var ρσ_Index = 0; ρσ_Index < ρσ_Iter.length; ρσ_Index++) {
                            k = ρσ_Iter[ρσ_Index];
                            ρσ_Result[k] = (obj[(typeof k === "number" && k < 0) ? obj.length + k : k]);
                        }
                        return ρσ_Result;
                    })();
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["obj"]},
                    __module__ : {value: "utils"}
                });
                return ρσ_anonfunc;
            })();
        }
        function parse_url_params() {
            var url = (arguments[0] === undefined || ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? parse_url_params.__defaults__.url : arguments[0];
            var allow_multiple = (arguments[1] === undefined || ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? parse_url_params.__defaults__.allow_multiple : arguments[1];
            var ρσ_kwargs_obj = arguments[arguments.length-1];
            if (ρσ_kwargs_obj === null || typeof ρσ_kwargs_obj !== "object" || ρσ_kwargs_obj [ρσ_kwargs_symbol] !== true) ρσ_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "url")){
                url = ρσ_kwargs_obj.url;
            }
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "allow_multiple")){
                allow_multiple = ρσ_kwargs_obj.allow_multiple;
            }
            var cache, qs, ans, q, pairs, ρσ_unpack, key, val, pair;
            cache = parse_url_params.cache;
            url = url || window.location.href;
            if (cache[(typeof url === "number" && url < 0) ? cache.length + url : url]) {
                return copy_hash((ρσ_expr_temp = parse_url_params.cache)[(typeof url === "number" && url < 0) ? ρσ_expr_temp.length + url : url]);
            }
            qs = url.indexOf("#");
            ans = Object.create(null);
            if (qs < 0) {
                cache[(typeof url === "number" && url < 0) ? cache.length + url : url] = ans;
                return copy_hash(ans);
            }
            q = url.slice(qs + 1, url.length + 1);
            if (!q) {
                cache[(typeof url === "number" && url < 0) ? cache.length + url : url] = ans;
                return copy_hash(ans);
            }
            pairs = q.replace(/\+/g, " ").split("&");
            var ρσ_Iter0 = ρσ_Iterable(pairs);
            for (var ρσ_Index0 = 0; ρσ_Index0 < ρσ_Iter0.length; ρσ_Index0++) {
                pair = ρσ_Iter0[ρσ_Index0];
                ρσ_unpack = ρσ_eslice(pair.partition("="), 2);
ρσ_unpack = ρσ_unpack_asarray(2, ρσ_unpack);
                key = ρσ_unpack[0];
                val = ρσ_unpack[1];
                ρσ_unpack = [decodeURIComponent(key), decodeURIComponent(val)];
                key = ρσ_unpack[0];
                val = ρσ_unpack[1];
                if (allow_multiple) {
                    if (ans[(typeof key === "number" && key < 0) ? ans.length + key : key] === undefined) {
                        ans[(typeof key === "number" && key < 0) ? ans.length + key : key] = [];
                    }
                    ans[(typeof key === "number" && key < 0) ? ans.length + key : key].append(val);
                } else {
                    ans[(typeof key === "number" && key < 0) ? ans.length + key : key] = val;
                }
            }
            cache[(typeof url === "number" && url < 0) ? cache.length + url : url] = ans;
            return copy_hash(ans);
        };
        if (!parse_url_params.__defaults__) Object.defineProperties(parse_url_params, {
            __defaults__ : {value: {url:null, allow_multiple:false}},
            __handles_kwarg_interpolation__ : {value: true},
            __argnames__ : {value: ["url", "allow_multiple"]},
            __module__ : {value: "utils"}
        });

        parse_url_params.cache = Object.create(null);
        function encode_query_with_path(query, path) {
            path = path || window.location.pathname;
            return path + encode_query(query, "#");
        };
        if (!encode_query_with_path.__argnames__) Object.defineProperties(encode_query_with_path, {
            __argnames__ : {value: ["query", "path"]},
            __module__ : {value: "utils"}
        });

        function full_screen_supported(elem) {
            elem = elem || document.documentElement;
            if (elem.requestFullScreen || elem.webkitRequestFullScreen || elem.mozRequestFullScreen) {
                return true;
            }
            return false;
        };
        if (!full_screen_supported.__argnames__) Object.defineProperties(full_screen_supported, {
            __argnames__ : {value: ["elem"]},
            __module__ : {value: "utils"}
        });

        function request_full_screen(elem) {
            var options;
            elem = elem || document.documentElement;
            options = (function(){
                var ρσ_d = Object.create(null);
                ρσ_d["navigationUI"] = "hide";
                return ρσ_d;
            }).call(this);
            if (elem.requestFullScreen) {
                elem.requestFullScreen(options);
            } else if (elem.webkitRequestFullScreen) {
                elem.webkitRequestFullScreen();
            } else if (elem.mozRequestFullScreen) {
                elem.mozRequestFullScreen();
            }
        };
        if (!request_full_screen.__argnames__) Object.defineProperties(request_full_screen, {
            __argnames__ : {value: ["elem"]},
            __module__ : {value: "utils"}
        });

        function full_screen_element() {
            return document.fullscreenElement || document.webkitFullscreenElement || document.mozFullScreenElement || document.msFullscreenElement;
        };
        if (!full_screen_element.__module__) Object.defineProperties(full_screen_element, {
            __module__ : {value: "utils"}
        });

        _roman = list(zip(ρσ_list_decorate([ 1e3, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1 ]), ρσ_list_decorate([ "M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I" ])));
        function roman(num) {
            var result, ρσ_unpack, d, r;
            if (num <= 0 || num >= 4e3 || int(num) !== num) {
                return num + "";
            }
            result = ρσ_list_decorate([]);
            var ρσ_Iter1 = ρσ_Iterable(_roman);
            for (var ρσ_Index1 = 0; ρσ_Index1 < ρσ_Iter1.length; ρσ_Index1++) {
                ρσ_unpack = ρσ_Iter1[ρσ_Index1];
                d = ρσ_unpack[0];
                r = ρσ_unpack[1];
                while (num >= d) {
                    result.append(r);
                    num -= d;
                }
            }
            return result.join("");
        };
        if (!roman.__argnames__) Object.defineProperties(roman, {
            __argnames__ : {value: ["num"]},
            __module__ : {value: "utils"}
        });

        function fmt_sidx() {
            var val = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[0];
            var fmt = (arguments[1] === undefined || ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? fmt_sidx.__defaults__.fmt : arguments[1];
            var use_roman = (arguments[2] === undefined || ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? fmt_sidx.__defaults__.use_roman : arguments[2];
            var ρσ_kwargs_obj = arguments[arguments.length-1];
            if (ρσ_kwargs_obj === null || typeof ρσ_kwargs_obj !== "object" || ρσ_kwargs_obj [ρσ_kwargs_symbol] !== true) ρσ_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "fmt")){
                fmt = ρσ_kwargs_obj.fmt;
            }
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "use_roman")){
                use_roman = ρσ_kwargs_obj.use_roman;
            }
            if (val === undefined || val === null || val === "") {
                return "1";
            }
            if (int(val) === float(val)) {
                if (use_roman) {
                    return roman(val);
                }
                return int(val) + "";
            }
            return fmt.format(float(val));
        };
        if (!fmt_sidx.__defaults__) Object.defineProperties(fmt_sidx, {
            __defaults__ : {value: {fmt:"{:.2f}", use_roman:true}},
            __handles_kwarg_interpolation__ : {value: true},
            __argnames__ : {value: ["val", "fmt", "use_roman"]},
            __module__ : {value: "utils"}
        });

        function rating_to_stars() {
            var value = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[0];
            var allow_half_stars = (arguments[1] === undefined || ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? rating_to_stars.__defaults__.allow_half_stars : arguments[1];
            var star = (arguments[2] === undefined || ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? rating_to_stars.__defaults__.star : arguments[2];
            var half = (arguments[3] === undefined || ( 3 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? rating_to_stars.__defaults__.half : arguments[3];
            var ρσ_kwargs_obj = arguments[arguments.length-1];
            if (ρσ_kwargs_obj === null || typeof ρσ_kwargs_obj !== "object" || ρσ_kwargs_obj [ρσ_kwargs_symbol] !== true) ρσ_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "allow_half_stars")){
                allow_half_stars = ρσ_kwargs_obj.allow_half_stars;
            }
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "star")){
                star = ρσ_kwargs_obj.star;
            }
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "half")){
                half = ρσ_kwargs_obj.half;
            }
            var r, ans;
            r = max(0, min(int(value || 0), 10));
            if (allow_half_stars) {
                ans = star.repeat(Math.floor(r / 2));
                if (r % 2) {
                    ans += half;
                }
            } else {
                ans = star.repeat(int(r / 2));
            }
            return ans;
        };
        if (!rating_to_stars.__defaults__) Object.defineProperties(rating_to_stars, {
            __defaults__ : {value: {allow_half_stars:false, star:"★", half:"⯨"}},
            __handles_kwarg_interpolation__ : {value: true},
            __argnames__ : {value: ["value", "allow_half_stars", "star", "half"]},
            __module__ : {value: "utils"}
        });

        function human_readable() {
            var size = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[0];
            var sep = (arguments[1] === undefined || ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? human_readable.__defaults__.sep : arguments[1];
            var ρσ_kwargs_obj = arguments[arguments.length-1];
            if (ρσ_kwargs_obj === null || typeof ρσ_kwargs_obj !== "object" || ρσ_kwargs_obj [ρσ_kwargs_symbol] !== true) ρσ_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "sep")){
                sep = ρσ_kwargs_obj.sep;
            }
            var ρσ_unpack, divisor, suffix, i, candidate, pos;
            ρσ_unpack = [1, "B"];
            divisor = ρσ_unpack[0];
            suffix = ρσ_unpack[1];
            var ρσ_Iter2 = ρσ_Iterable(enumerate(["B", "KB", "MB", "GB", "TB", "PB", "EB"]));
            for (var ρσ_Index2 = 0; ρσ_Index2 < ρσ_Iter2.length; ρσ_Index2++) {
                ρσ_unpack = ρσ_Iter2[ρσ_Index2];
                i = ρσ_unpack[0];
                candidate = ρσ_unpack[1];
                if (size < 1 << (i + 1) * 10) {
                    ρσ_unpack = [1 << i * 10, candidate];
                    divisor = ρσ_unpack[0];
                    suffix = ρσ_unpack[1];
                    break;
                }
            }
            size = float(size) / divisor + "";
            pos = size.find(".");
            if (pos > -1) {
                size = size.slice(0, pos + 2);
            }
            if (size.endswith(".0")) {
                size = size.slice(0, -2);
            }
            return size + sep + suffix;
        };
        if (!human_readable.__defaults__) Object.defineProperties(human_readable, {
            __defaults__ : {value: {sep:" "}},
            __handles_kwarg_interpolation__ : {value: true},
            __argnames__ : {value: ["size", "sep"]},
            __module__ : {value: "utils"}
        });

        function document_height() {
            var html;
            html = document.documentElement;
            return max(document.body.scrollHeight, document.body.offsetHeight, html.clientHeight, html.scrollHeight, html.offsetHeight);
        };
        if (!document_height.__module__) Object.defineProperties(document_height, {
            __module__ : {value: "utils"}
        });

        function document_width() {
            var html;
            html = document.documentElement;
            return max(document.body.scrollWidth, document.body.offsetWidth, html.clientWidth, html.scrollWidth, html.offsetWidth);
        };
        if (!document_width.__module__) Object.defineProperties(document_width, {
            __module__ : {value: "utils"}
        });

        _data_ns = null;
        function data_ns(name) {
            var rand;
            if (_data_ns === null) {
                rand = new Uint8Array(12);
                window.crypto.getRandomValues(rand);
                _data_ns = "data-" + hexlify(rand) + "-";
            }
            return _data_ns + name;
        };
        if (!data_ns.__argnames__) Object.defineProperties(data_ns, {
            __argnames__ : {value: ["name"]},
            __module__ : {value: "utils"}
        });

        function get_elem_data(elem, name, defval) {
            var ans;
            ans = elem.getAttribute(data_ns(name));
            if (ans === null) {
                return (typeof defval !== "undefined" && defval !== null ? defval : null);
            }
            return JSON.parse(ans);
        };
        if (!get_elem_data.__argnames__) Object.defineProperties(get_elem_data, {
            __argnames__ : {value: ["elem", "name", "defval"]},
            __module__ : {value: "utils"}
        });

        function set_elem_data(elem, name, val) {
            elem.setAttribute(data_ns(name), JSON.stringify(val));
        };
        if (!set_elem_data.__argnames__) Object.defineProperties(set_elem_data, {
            __argnames__ : {value: ["elem", "name", "val"]},
            __module__ : {value: "utils"}
        });

        function username_key(username) {
            return ((username) ? "u" : "n") + username;
        };
        if (!username_key.__argnames__) Object.defineProperties(username_key, {
            __argnames__ : {value: ["username"]},
            __module__ : {value: "utils"}
        });

        function html_escape(text) {
            var repl;
            repl = (function(){
                var ρσ_d = Object.create(null);
                ρσ_d["&"] = "&amp;";
                ρσ_d["\""] = "&quot;";
                ρσ_d["<"] = "&lt;";
                ρσ_d[">"] = "&gt;";
                return ρσ_d;
            }).call(this);
            return String.prototype.replace.call(text, /[&"<>]/g, (function() {
                var ρσ_anonfunc = function (c) {
                    return repl[(typeof c === "number" && c < 0) ? repl.length + c : c];
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["c"]},
                    __module__ : {value: "utils"}
                });
                return ρσ_anonfunc;
            })());
        };
        if (!html_escape.__argnames__) Object.defineProperties(html_escape, {
            __argnames__ : {value: ["text"]},
            __module__ : {value: "utils"}
        });

        function uniq(vals) {
            var ans, seen, x;
            ans = [];
            seen = Object.create(null);
            var ρσ_Iter3 = ρσ_Iterable(vals);
            for (var ρσ_Index3 = 0; ρσ_Index3 < ρσ_Iter3.length; ρσ_Index3++) {
                x = ρσ_Iter3[ρσ_Index3];
                if (!seen[(typeof x === "number" && x < 0) ? seen.length + x : x]) {
                    seen[(typeof x === "number" && x < 0) ? seen.length + x : x] = true;
                    ans.push(x);
                }
            }
            return ans;
        };
        if (!uniq.__argnames__) Object.defineProperties(uniq, {
            __argnames__ : {value: ["vals"]},
            __module__ : {value: "utils"}
        });

        function conditional_timeout(elem_id, timeout, func) {
            function ct_impl() {
                var elem;
                elem = document.getElementById(elem_id);
                if (elem) {
                    func.call(elem);
                }
            };
            if (!ct_impl.__module__) Object.defineProperties(ct_impl, {
                __module__ : {value: "utils"}
            });

            window.setTimeout(ct_impl, timeout);
        };
        if (!conditional_timeout.__argnames__) Object.defineProperties(conditional_timeout, {
            __argnames__ : {value: ["elem_id", "timeout", "func"]},
            __module__ : {value: "utils"}
        });

        function simple_markup(html) {
            var div;
            html = (html || "").replace(/\uffff/g, "").replace(/<\s*(\/?[a-zA-Z1-6]+)[^>]*>/g, (function() {
                var ρσ_anonfunc = function (match, tag) {
                    var is_closing;
                    tag = tag.toLowerCase();
                    is_closing = (tag[0] === "/") ? "/" : "";
                    if (is_closing) {
                        tag = tag.slice(1);
                    }
                    if (simple_markup.allowed_tags.indexOf(tag) < 0) {
                        tag = "span";
                    }
                    return "\uffff" + ρσ_str.format("{}", is_closing) + "" + ρσ_str.format("{}", tag) + "\uffff";
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["match", "tag"]},
                    __module__ : {value: "utils"}
                });
                return ρσ_anonfunc;
            })());
            div = document.createElement("b");
            div.textContent = html;
            html = div.innerHTML;
            return html.replace(/\uffff(\/?[a-z1-6]+)\uffff/g, "<$1>");
        };
        if (!simple_markup.__argnames__) Object.defineProperties(simple_markup, {
            __argnames__ : {value: ["html"]},
            __module__ : {value: "utils"}
        });

        simple_markup.allowed_tags = 'a|b|i|br|hr|h1|h2|h3|h4|h5|h6|div|em|strong|span'.split('|');
        function safe_set_inner_html(elem, html) {
            elem.innerHTML = simple_markup(html);
            return elem;
        };
        if (!safe_set_inner_html.__argnames__) Object.defineProperties(safe_set_inner_html, {
            __argnames__ : {value: ["elem", "html"]},
            __module__ : {value: "utils"}
        });

        function sandboxed_html(html, style, sandbox) {
            var ans, css, final_html;
            ans = document.createElement("iframe");
            ans.setAttribute("sandbox", sandbox || "");
            ans.setAttribute("seamless", "");
            ans.style.width = "100%";
            html = html || "";
            css = "html, body { margin: 0; padding: 0; font-family: __FONT__ } p:first-child { margin-top: 0; padding-top: 0; -webkit-margin-before: 0 }".replace("__FONT__", get_font_family());
            css += style || "";
            final_html = "<!DOCTYPE html><html><head><style>" + ρσ_str.format("{}", css) + "</style></head><body>" + ρσ_str.format("{}", html) + "</body></html>";
            ans.srcdoc = final_html;
            return ans;
        };
        if (!sandboxed_html.__argnames__) Object.defineProperties(sandboxed_html, {
            __argnames__ : {value: ["html", "style", "sandbox"]},
            __module__ : {value: "utils"}
        });

        ρσ_modules.utils.is_ios = is_ios;
        ρσ_modules.utils.ios_major_version = ios_major_version;
        ρσ_modules.utils.v = v;
        ρσ_modules.utils.copy_hash = copy_hash;
        ρσ_modules.utils._roman = _roman;
        ρσ_modules.utils._data_ns = _data_ns;
        ρσ_modules.utils.default_context_menu_should_be_allowed = default_context_menu_should_be_allowed;
        ρσ_modules.utils.debounce = debounce;
        ρσ_modules.utils.parse_url_params = parse_url_params;
        ρσ_modules.utils.encode_query_with_path = encode_query_with_path;
        ρσ_modules.utils.full_screen_supported = full_screen_supported;
        ρσ_modules.utils.request_full_screen = request_full_screen;
        ρσ_modules.utils.full_screen_element = full_screen_element;
        ρσ_modules.utils.roman = roman;
        ρσ_modules.utils.fmt_sidx = fmt_sidx;
        ρσ_modules.utils.rating_to_stars = rating_to_stars;
        ρσ_modules.utils.human_readable = human_readable;
        ρσ_modules.utils.document_height = document_height;
        ρσ_modules.utils.document_width = document_width;
        ρσ_modules.utils.data_ns = data_ns;
        ρσ_modules.utils.get_elem_data = get_elem_data;
        ρσ_modules.utils.set_elem_data = set_elem_data;
        ρσ_modules.utils.username_key = username_key;
        ρσ_modules.utils.html_escape = html_escape;
        ρσ_modules.utils.uniq = uniq;
        ρσ_modules.utils.conditional_timeout = conditional_timeout;
        ρσ_modules.utils.simple_markup = simple_markup;
        ρσ_modules.utils.safe_set_inner_html = safe_set_inner_html;
        ρσ_modules.utils.sandboxed_html = sandboxed_html;
    })();

    (function(){
        var __name__ = "book_list.library_data";
        var load_status, library_data, thumbnail_cache;
        var _ = ρσ_modules.gettext.gettext;

        var absolute_path = ρσ_modules.ajax.absolute_path;
        var ajax = ρσ_modules.ajax.ajax;

        var get_session_data = ρσ_modules["book_list.globals"].get_session_data;

        var LRUCache = ρσ_modules.lru_cache.LRUCache;

        var get_interface_data = ρσ_modules.session.get_interface_data;

        var parse_url_params = ρσ_modules.utils.parse_url_params;

        load_status = (function(){
            var ρσ_d = Object.create(null);
            ρσ_d["loading"] = true;
            ρσ_d["ok"] = false;
            ρσ_d["error_html"] = null;
            ρσ_d["current_fetch"] = null;
            ρσ_d["http_error_code"] = 0;
            return ρσ_d;
        }).call(this);
        library_data = (function(){
            var ρσ_d = Object.create(null);
            ρσ_d["metadata"] = Object.create(null);
            ρσ_d["previous_book_ids"] = [];
            ρσ_d["force_refresh"] = false;
            ρσ_d["bools_are_tristate"] = true;
            return ρσ_d;
        }).call(this);
        function current_library_id() {
            var q;
            q = parse_url_params();
            return q.library_id || get_interface_data().default_library_id;
        };
        if (!current_library_id.__module__) Object.defineProperties(current_library_id, {
            __module__ : {value: "book_list.library_data"}
        });

        function all_libraries() {
            var interface_data, lids;
            interface_data = get_interface_data();
            lids = ρσ_interpolate_kwargs.call(this, sorted, [interface_data.library_map].concat([ρσ_desugar_kwargs({key: (function() {
                var ρσ_anonfunc = function (x) {
                    return (ρσ_expr_temp = interface_data.library_map)[(typeof x === "number" && x < 0) ? ρσ_expr_temp.length + x : x];
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["x"]},
                    __module__ : {value: "book_list.library_data"}
                });
                return ρσ_anonfunc;
            })()})]));
            return (function() {
                var ρσ_Iter = ρσ_Iterable(lids), ρσ_Result = [], lid;
                for (var ρσ_Index = 0; ρσ_Index < ρσ_Iter.length; ρσ_Index++) {
                    lid = ρσ_Iter[ρσ_Index];
                    ρσ_Result.push([lid, (ρσ_expr_temp = interface_data.library_map)[(typeof lid === "number" && lid < 0) ? ρσ_expr_temp.length + lid : lid]]);
                }
                ρσ_Result = ρσ_list_constructor(ρσ_Result);
                return ρσ_Result;
            })();
        };
        if (!all_libraries.__module__) Object.defineProperties(all_libraries, {
            __module__ : {value: "book_list.library_data"}
        });

        function current_virtual_library() {
            var q;
            q = parse_url_params();
            return q.vl || "";
        };
        if (!current_virtual_library.__module__) Object.defineProperties(current_virtual_library, {
            __module__ : {value: "book_list.library_data"}
        });

        function last_virtual_library_for(library_id) {
            if (last_virtual_library_for.library_id === library_id) {
                return last_virtual_library_for.vl || "";
            }
            return "";
        };
        if (!last_virtual_library_for.__argnames__) Object.defineProperties(last_virtual_library_for, {
            __argnames__ : {value: ["library_id"]},
            __module__ : {value: "book_list.library_data"}
        });

        function url_books_query(sd) {
            var q, lid;
            q = parse_url_params();
            sd = sd || get_session_data();
            lid = current_library_id();
            return (function(){
                var ρσ_d = Object.create(null);
                ρσ_d["library_id"] = lid;
                ρσ_d["sort"] = q.sort || sd.get_library_option(lid, "sort");
                ρσ_d["search"] = q.search;
                ρσ_d["vl"] = current_virtual_library();
                return ρσ_d;
            }).call(this);
        };
        if (!url_books_query.__argnames__) Object.defineProperties(url_books_query, {
            __argnames__ : {value: ["sd"]},
            __module__ : {value: "book_list.library_data"}
        });

        function loaded_books_query() {
            var sr, sort;
            sr = library_data.search_result;
            sort = null;
            if (sr) {
                sort = (function() {
                    var ρσ_Iter = ρσ_Iterable(zip(sr.sort.split(","), sr.sort_order.split(","))), ρσ_Result = [], s, o;
                    for (var ρσ_Index = 0; ρσ_Index < ρσ_Iter.length; ρσ_Index++) {
                        ρσ_unpack = ρσ_Iter[ρσ_Index];
                        s = ρσ_unpack[0];
                        o = ρσ_unpack[1];
                        ρσ_Result.push(s + "." + o);
                    }
                    ρσ_Result = ρσ_list_constructor(ρσ_Result);
                    return ρσ_Result;
                })().join(",");
            }
            return (function(){
                var ρσ_d = Object.create(null);
                ρσ_d["library_id"] = (sr) ? sr.library_id : null;
                ρσ_d["sort"] = sort;
                ρσ_d["search"] = (typeof sr !== "undefined" && sr !== null ? sr : Object.create(null)).query;
                ρσ_d["vl"] = (typeof sr !== "undefined" && sr !== null ? sr : Object.create(null)).vl;
                return ρσ_d;
            }).call(this);
        };
        if (!loaded_books_query.__module__) Object.defineProperties(loaded_books_query, {
            __module__ : {value: "book_list.library_data"}
        });

        function current_sorted_field() {
            var sort, csf, csfo;
            if (library_data.search_result) {
                return [library_data.search_result.sort, library_data.search_result.sort_order];
            }
            sort = url_books_query().sort.partition(",")[0];
            csf = sort.partition(".")[0];
            csfo = sort.partition(".")[2] || "asc";
            return [csf, csfo];
        };
        if (!current_sorted_field.__module__) Object.defineProperties(current_sorted_field, {
            __module__ : {value: "book_list.library_data"}
        });

        function all_virtual_libraries() {
            return library_data.virtual_libraries || Object.create(null);
        };
        if (!all_virtual_libraries.__module__) Object.defineProperties(all_virtual_libraries, {
            __module__ : {value: "book_list.library_data"}
        });

        function update_library_data(data) {
            var key, sr;
            load_status.loading = false;
            load_status.ok = true;
            load_status.error_html = null;
            load_status.http_error_code = 0;
            library_data.previous_book_ids = [];
            if (library_data.for_library !== current_library_id()) {
                library_data.field_names = Object.create(null);
            }
            library_data.for_library = current_library_id();
            var ρσ_Iter0 = ρσ_Iterable("search_result sortable_fields field_metadata metadata virtual_libraries book_display_fields bools_are_tristate book_details_vertical_categories".split(" "));
            for (var ρσ_Index0 = 0; ρσ_Index0 < ρσ_Iter0.length; ρσ_Index0++) {
                key = ρσ_Iter0[ρσ_Index0];
                library_data[(typeof key === "number" && key < 0) ? library_data.length + key : key] = data[(typeof key === "number" && key < 0) ? data.length + key : key];
            }
            sr = library_data.search_result;
            if (sr) {
                last_virtual_library_for.library_id = sr.library_id;
                last_virtual_library_for.vl = sr.vl;
            } else {
                last_virtual_library_for.library_id = null;
                last_virtual_library_for.vl = null;
            }
        };
        if (!update_library_data.__argnames__) Object.defineProperties(update_library_data, {
            __argnames__ : {value: ["data"]},
            __module__ : {value: "book_list.library_data"}
        });

        function add_more_books(data) {
            var key, sr;
            var ρσ_Iter1 = ρσ_Iterable(data.metadata);
            for (var ρσ_Index1 = 0; ρσ_Index1 < ρσ_Iter1.length; ρσ_Index1++) {
                key = ρσ_Iter1[ρσ_Index1];
                (ρσ_expr_temp = library_data.metadata)[(typeof key === "number" && key < 0) ? ρσ_expr_temp.length + key : key] = (ρσ_expr_temp = data.metadata)[(typeof key === "number" && key < 0) ? ρσ_expr_temp.length + key : key];
            }
            sr = library_data.search_result;
            if (sr && sr.book_ids && sr.book_ids.length > 0) {
                library_data.previous_book_ids = library_data.previous_book_ids.concat(sr.book_ids);
            }
            library_data.search_result = data.search_result;
        };
        if (!add_more_books.__argnames__) Object.defineProperties(add_more_books, {
            __argnames__ : {value: ["data"]},
            __module__ : {value: "book_list.library_data"}
        });

        function current_book_ids() {
            return library_data.previous_book_ids.concat(library_data.search_result.book_ids);
        };
        if (!current_book_ids.__module__) Object.defineProperties(current_book_ids, {
            __module__ : {value: "book_list.library_data"}
        });

        function remove_from_array(array, item) {
            var idx;
            while (true) {
                idx = array.indexOf(item);
                if (idx < 0) {
                    break;
                }
                array.splice(idx, 1);
            }
        };
        if (!remove_from_array.__argnames__) Object.defineProperties(remove_from_array, {
            __argnames__ : {value: ["array", "item"]},
            __module__ : {value: "book_list.library_data"}
        });

        function remove_book(book_id) {
            book_id = int(book_id);
            if (library_data.previous_book_ids) {
                remove_from_array(library_data.previous_book_ids, book_id);
            }
            if (ρσ_exists.d(library_data.search_result).book_ids) {
                remove_from_array(library_data.search_result.book_ids, book_id);
            }
        };
        if (!remove_book.__argnames__) Object.defineProperties(remove_book, {
            __argnames__ : {value: ["book_id"]},
            __module__ : {value: "book_list.library_data"}
        });

        function book_after(book_id, delta) {
            var ids, idx, new_idx;
            if (!delta) {
                delta = 1;
            }
            ids = current_book_ids();
            idx = ids.indexOf(int(book_id));
            if (idx > -1) {
                new_idx = (idx + ids.length + delta) % ids.length;
                return ids[(typeof new_idx === "number" && new_idx < 0) ? ids.length + new_idx : new_idx];
            }
        };
        if (!book_after.__argnames__) Object.defineProperties(book_after, {
            __argnames__ : {value: ["book_id", "delta"]},
            __module__ : {value: "book_list.library_data"}
        });

        function on_data_loaded(end_type, xhr, ev) {
            var data, sd, q;
            load_status.current_fetch = null;
            function bad_load(msg) {
                load_status.ok = false;
                load_status.loading = false;
                load_status.error_html = msg || xhr.error_html;
                load_status.http_error_code = xhr.status;
            };
            if (!bad_load.__argnames__) Object.defineProperties(bad_load, {
                __argnames__ : {value: ["msg"]},
                __module__ : {value: "book_list.library_data"}
            });

            if (end_type === "load") {
                data = JSON.parse(xhr.responseText);
                if (data.bad_restriction) {
                    bad_load(_("The library restriction for the current user is invalid: {}").format(data.bad_restriction));
                } else {
                    update_library_data(data);
                    sd = get_session_data();
                    q = loaded_books_query();
                    sd.set_library_option(q.library_id, "sort", q.sort);
                }
            } else if (end_type === "abort") {
            } else {
                bad_load();
            }
        };
        if (!on_data_loaded.__argnames__) Object.defineProperties(on_data_loaded, {
            __argnames__ : {value: ["end_type", "xhr", "ev"]},
            __module__ : {value: "book_list.library_data"}
        });

        function fetch_init_data() {
            var query;
            if (load_status.current_fetch) {
                load_status.current_fetch.abort();
            }
            query = url_books_query();
            load_status.loading = true;
            load_status.ok = false;
            load_status.error_html = null;
            load_status.http_error_code = 0;
            load_status.current_fetch = ρσ_interpolate_kwargs.call(this, ajax, ["interface-data/books-init", on_data_loaded].concat([ρσ_desugar_kwargs({query: query})]));
            load_status.current_fetch.send();
        };
        if (!fetch_init_data.__module__) Object.defineProperties(fetch_init_data, {
            __module__ : {value: "book_list.library_data"}
        });

        function field_names_received(library_id, field, proceed, end_type, xhr, event) {
            var names;
            if (library_id !== current_library_id()) {
                return;
            }
            if (end_type !== "load") {
                if (end_type !== "abort") {
                    proceed(false, field, xhr.error_html);
                }
                return;
            }
            try {
                names = JSON.parse(xhr.responseText);
            } catch (ρσ_Exception) {
                ρσ_last_exception = ρσ_Exception;
                if (ρσ_Exception instanceof Error) {
                    var traceback = ρσ_modules.traceback;

                    traceback.print_exc();
                    proceed(false, field, "Invalid JSON from server");
                    return;
                } else {
                    throw ρσ_Exception;
                }
            }
            (ρσ_expr_temp = library_data.field_names)[(typeof field === "number" && field < 0) ? ρσ_expr_temp.length + field : field] = (function(){
                var ρσ_d = Object.create(null);
                ρσ_d["loading"] = false;
                ρσ_d["loaded"] = true;
                ρσ_d["last_updated_at"] = Date.now();
                ρσ_d["names"] = names;
                return ρσ_d;
            }).call(this);
            proceed(true, field, names);
        };
        if (!field_names_received.__argnames__) Object.defineProperties(field_names_received, {
            __argnames__ : {value: ["library_id", "field", "proceed", "end_type", "xhr", "event"]},
            __module__ : {value: "book_list.library_data"}
        });

        function field_names_for(field, proceed) {
            if ((ρσ_expr_temp = library_data.field_names)[(typeof field === "number" && field < 0) ? ρσ_expr_temp.length + field : field] && (ρσ_expr_temp = library_data.field_names)[(typeof field === "number" && field < 0) ? ρσ_expr_temp.length + field : field].loaded) {
                proceed(true, field, (ρσ_expr_temp = library_data.field_names)[(typeof field === "number" && field < 0) ? ρσ_expr_temp.length + field : field].names);
            }
            if (!(ρσ_expr_temp = library_data.field_names)[(typeof field === "number" && field < 0) ? ρσ_expr_temp.length + field : field] || !(ρσ_expr_temp = library_data.field_names)[(typeof field === "number" && field < 0) ? ρσ_expr_temp.length + field : field].loading && Date.now() - (ρσ_expr_temp = library_data.field_names)[(typeof field === "number" && field < 0) ? ρσ_expr_temp.length + field : field].last_updated_at > 3600 * 1e3) {
                ρσ_interpolate_kwargs.call(this, ajax, ["interface-data/field-names/" + ρσ_str.format("{}", encodeURIComponent(field)) + "", field_names_received.bind(null, current_library_id(), field, proceed)].concat([ρσ_desugar_kwargs({query: (function(){
                    var ρσ_d = Object.create(null);
                    ρσ_d["library_id"] = current_library_id();
                    return ρσ_d;
                }).call(this)})])).send();
                if (!(ρσ_expr_temp = library_data.field_names)[(typeof field === "number" && field < 0) ? ρσ_expr_temp.length + field : field]) {
                    (ρσ_expr_temp = library_data.field_names)[(typeof field === "number" && field < 0) ? ρσ_expr_temp.length + field : field] = (function(){
                        var ρσ_d = Object.create(null);
                        ρσ_d["last_updated_at"] = 0;
                        ρσ_d["loaded"] = false;
                        ρσ_d["names"] = [];
                        return ρσ_d;
                    }).call(this);
                }
                (ρσ_expr_temp = library_data.field_names)[(typeof field === "number" && field < 0) ? ρσ_expr_temp.length + field : field].loading = true;
            }
        };
        if (!field_names_for.__argnames__) Object.defineProperties(field_names_for, {
            __argnames__ : {value: ["field", "proceed"]},
            __module__ : {value: "book_list.library_data"}
        });

        function thumbnail_url(book_id, width, height) {
            var query, prefix, lid;
            query = "sz=" + ρσ_str.format("{}", Math.ceil(width * window.devicePixelRatio)) + "x" + ρσ_str.format("{}", Math.ceil(height * window.devicePixelRatio)) + "";
            prefix = "get/thumb/" + ρσ_str.format("{}", book_id) + "";
            lid = loaded_books_query().library_id || current_library_id();
            if (lid) {
                prefix += "/" + ρσ_str.format("{}", lid) + "";
            }
            return absolute_path("" + ρσ_str.format("{}", prefix) + "?" + ρσ_str.format("{}", query) + "");
        };
        if (!thumbnail_url.__argnames__) Object.defineProperties(thumbnail_url, {
            __argnames__ : {value: ["book_id", "width", "height"]},
            __module__ : {value: "book_list.library_data"}
        });

        function cover_url(book_id) {
            var lid;
            lid = current_library_id();
            return absolute_path("get/cover/" + ρσ_str.format("{}", book_id) + "/" + ρσ_str.format("{}", lid) + "");
        };
        if (!cover_url.__argnames__) Object.defineProperties(cover_url, {
            __argnames__ : {value: ["book_id"]},
            __module__ : {value: "book_list.library_data"}
        });

        function download_url(book_id, fmt, content_disposition) {
            var lid, ans;
            lid = current_library_id();
            ans = absolute_path("get/" + ρσ_str.format("{}", fmt) + "/" + ρσ_str.format("{}", book_id) + "/" + ρσ_str.format("{}", lid) + "");
            if (content_disposition) {
                ans += "?content_disposition=" + ρσ_str.format("{}", content_disposition) + "";
            }
            return ans;
        };
        if (!download_url.__argnames__) Object.defineProperties(download_url, {
            __argnames__ : {value: ["book_id", "fmt", "content_disposition"]},
            __module__ : {value: "book_list.library_data"}
        });

        function book_metadata(book_id) {
            return (ρσ_expr_temp = library_data.metadata)[(typeof book_id === "number" && book_id < 0) ? ρσ_expr_temp.length + book_id : book_id];
        };
        if (!book_metadata.__argnames__) Object.defineProperties(book_metadata, {
            __argnames__ : {value: ["book_id"]},
            __module__ : {value: "book_list.library_data"}
        });

        function set_book_metadata(book_id, value) {
            (ρσ_expr_temp = library_data.metadata)[(typeof book_id === "number" && book_id < 0) ? ρσ_expr_temp.length + book_id : book_id] = value;
        };
        if (!set_book_metadata.__argnames__) Object.defineProperties(set_book_metadata, {
            __argnames__ : {value: ["book_id", "value"]},
            __module__ : {value: "book_list.library_data"}
        });

        function loaded_book_ids() {
            return Object.keys(library_data.metadata);
        };
        if (!loaded_book_ids.__module__) Object.defineProperties(loaded_book_ids, {
            __module__ : {value: "book_list.library_data"}
        });

        function force_refresh_on_next_load() {
            library_data.force_refresh = true;
        };
        if (!force_refresh_on_next_load.__module__) Object.defineProperties(force_refresh_on_next_load, {
            __module__ : {value: "book_list.library_data"}
        });

        function ensure_current_library_data() {
            var fr, matches, q, loaded, key;
            fr = library_data.force_refresh;
            library_data.force_refresh = false;
            function is_same(a, b) {
                if (!a && !b) {
                    return true;
                }
                return a === b;
            };
            if (!is_same.__argnames__) Object.defineProperties(is_same, {
                __argnames__ : {value: ["a", "b"]},
                __module__ : {value: "book_list.library_data"}
            });

            if (fr) {
                matches = false;
            } else {
                q = url_books_query();
                loaded = loaded_books_query();
                matches = true;
                var ρσ_Iter2 = ρσ_Iterable(q);
                for (var ρσ_Index2 = 0; ρσ_Index2 < ρσ_Iter2.length; ρσ_Index2++) {
                    key = ρσ_Iter2[ρσ_Index2];
                    if (!is_same(q[(typeof key === "number" && key < 0) ? q.length + key : key], loaded[(typeof key === "number" && key < 0) ? loaded.length + key : key])) {
                        matches = false;
                        break;
                    }
                }
            }
            if (!matches) {
                fetch_init_data();
            }
        };
        if (!ensure_current_library_data.__module__) Object.defineProperties(ensure_current_library_data, {
            __module__ : {value: "book_list.library_data"}
        });

        function ThumbnailCache() {
            if (this.ρσ_object_id === undefined) Object.defineProperty(this, "ρσ_object_id", {"value":++ρσ_object_counter});
            ThumbnailCache.prototype.__bind_methods__.call(this);
            ThumbnailCache.prototype.__init__.apply(this, arguments);
        }
        Object.defineProperty(ThumbnailCache.prototype, "__bind_methods__", {value: function () {
            this.get = ThumbnailCache.prototype.get.bind(this);
            this.load_finished = ThumbnailCache.prototype.load_finished.bind(this);
        }});
        ThumbnailCache.prototype.__init__ = function __init__() {
            var self = this;
            var size = (arguments[0] === undefined || ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? __init__.__defaults__.size : arguments[0];
            var ρσ_kwargs_obj = arguments[arguments.length-1];
            if (ρσ_kwargs_obj === null || typeof ρσ_kwargs_obj !== "object" || ρσ_kwargs_obj [ρσ_kwargs_symbol] !== true) ρσ_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "size")){
                size = ρσ_kwargs_obj.size;
            }
            self.cache = new LRUCache(size);
        };
        if (!ThumbnailCache.prototype.__init__.__defaults__) Object.defineProperties(ThumbnailCache.prototype.__init__, {
            __defaults__ : {value: {size:256}},
            __handles_kwarg_interpolation__ : {value: true},
            __argnames__ : {value: ["size"]},
            __module__ : {value: "book_list.library_data"}
        });
        ThumbnailCache.__argnames__ = ThumbnailCache.prototype.__init__.__argnames__;
        ThumbnailCache.__handles_kwarg_interpolation__ = ThumbnailCache.prototype.__init__.__handles_kwarg_interpolation__;
        ThumbnailCache.prototype.get = function get(book_id, width, height, callback) {
            var self = this;
            var url, item, img;
            url = thumbnail_url(book_id, width, height);
            item = self.cache.get(url);
            if (!item) {
                img = new Image;
                item = (function(){
                    var ρσ_d = Object.create(null);
                    ρσ_d["img"] = img;
                    ρσ_d["load_type"] = null;
                    ρσ_d["callbacks"] = [callback];
                    return ρσ_d;
                }).call(this);
                img.onerror = self.load_finished.bind(null, item, "error");
                img.onload = self.load_finished.bind(null, item, "load");
                img.onabort = self.load_finished.bind(null, item, "abort");
                img.dataset.bookId = book_id + "";
                img.src = url;
                self.cache.set(url, item);
                return img;
            }
            if (item.load_type === null) {
                if (item.callbacks.indexOf(callback) < 0) {
                    item.callbacks.push(callback);
                }
            } else {
                callback(item.img, item.load_type);
            }
            return item.img;
        };
        if (!ThumbnailCache.prototype.get.__argnames__) Object.defineProperties(ThumbnailCache.prototype.get, {
            __argnames__ : {value: ["book_id", "width", "height", "callback"]},
            __module__ : {value: "book_list.library_data"}
        });
        ThumbnailCache.prototype.load_finished = function load_finished(item, load_type) {
            var self = this;
            var img, callback;
            item.load_type = load_type;
            img = item.img;
            img.onload = img.onerror = img.onabort = null;
            var ρσ_Iter3 = ρσ_Iterable(item.callbacks);
            for (var ρσ_Index3 = 0; ρσ_Index3 < ρσ_Iter3.length; ρσ_Index3++) {
                callback = ρσ_Iter3[ρσ_Index3];
                callback(img, load_type);
            }
        };
        if (!ThumbnailCache.prototype.load_finished.__argnames__) Object.defineProperties(ThumbnailCache.prototype.load_finished, {
            __argnames__ : {value: ["item", "load_type"]},
            __module__ : {value: "book_list.library_data"}
        });
        ThumbnailCache.prototype.__repr__ = function __repr__ () {
                        return "<" + __name__ + "." + this.constructor.name + " #" + this.ρσ_object_id + ">";
        };
        ThumbnailCache.prototype.__str__ = function __str__ () {
            return this.__repr__();
        };
        Object.defineProperty(ThumbnailCache.prototype, "__bases__", {value: []});

        thumbnail_cache = new ThumbnailCache;
        function sync_library_books(library_id, to_sync, callback) {
            var url, which, lrmap, ρσ_unpack, book_id, fmt, key, last_read;
            url = "book-get-annotations/" + ρσ_str.format("{}", library_id) + "/";
            which = [];
            lrmap = Object.create(null);
            var ρσ_Iter4 = ρσ_Iterable(to_sync);
            for (var ρσ_Index4 = 0; ρσ_Index4 < ρσ_Iter4.length; ρσ_Index4++) {
                ρσ_unpack = ρσ_Iter4[ρσ_Index4];
                key = ρσ_unpack[0];
                last_read = ρσ_unpack[1];
                ρσ_unpack = key;
ρσ_unpack = ρσ_unpack_asarray(3, ρσ_unpack);
                library_id = ρσ_unpack[0];
                book_id = ρσ_unpack[1];
                fmt = ρσ_unpack[2];
                fmt = fmt.upper();
                which.push("" + ρσ_str.format("{}", book_id) + "-" + ρσ_str.format("{}", fmt) + "");
                lrmap[ρσ_bound_index("" + ρσ_str.format("{}", book_id) + ":" + ρσ_str.format("{}", fmt) + "", lrmap)] = last_read;
            }
            url += which.join("_");
            ajax(url, callback.bind(null, library_id, lrmap)).send();
        };
        if (!sync_library_books.__argnames__) Object.defineProperties(sync_library_books, {
            __argnames__ : {value: ["library_id", "to_sync", "callback"]},
            __module__ : {value: "book_list.library_data"}
        });

        ρσ_modules["book_list.library_data"].load_status = load_status;
        ρσ_modules["book_list.library_data"].library_data = library_data;
        ρσ_modules["book_list.library_data"].thumbnail_cache = thumbnail_cache;
        ρσ_modules["book_list.library_data"].current_library_id = current_library_id;
        ρσ_modules["book_list.library_data"].all_libraries = all_libraries;
        ρσ_modules["book_list.library_data"].current_virtual_library = current_virtual_library;
        ρσ_modules["book_list.library_data"].last_virtual_library_for = last_virtual_library_for;
        ρσ_modules["book_list.library_data"].url_books_query = url_books_query;
        ρσ_modules["book_list.library_data"].loaded_books_query = loaded_books_query;
        ρσ_modules["book_list.library_data"].current_sorted_field = current_sorted_field;
        ρσ_modules["book_list.library_data"].all_virtual_libraries = all_virtual_libraries;
        ρσ_modules["book_list.library_data"].update_library_data = update_library_data;
        ρσ_modules["book_list.library_data"].add_more_books = add_more_books;
        ρσ_modules["book_list.library_data"].current_book_ids = current_book_ids;
        ρσ_modules["book_list.library_data"].remove_from_array = remove_from_array;
        ρσ_modules["book_list.library_data"].remove_book = remove_book;
        ρσ_modules["book_list.library_data"].book_after = book_after;
        ρσ_modules["book_list.library_data"].on_data_loaded = on_data_loaded;
        ρσ_modules["book_list.library_data"].fetch_init_data = fetch_init_data;
        ρσ_modules["book_list.library_data"].field_names_received = field_names_received;
        ρσ_modules["book_list.library_data"].field_names_for = field_names_for;
        ρσ_modules["book_list.library_data"].thumbnail_url = thumbnail_url;
        ρσ_modules["book_list.library_data"].cover_url = cover_url;
        ρσ_modules["book_list.library_data"].download_url = download_url;
        ρσ_modules["book_list.library_data"].book_metadata = book_metadata;
        ρσ_modules["book_list.library_data"].set_book_metadata = set_book_metadata;
        ρσ_modules["book_list.library_data"].loaded_book_ids = loaded_book_ids;
        ρσ_modules["book_list.library_data"].force_refresh_on_next_load = force_refresh_on_next_load;
        ρσ_modules["book_list.library_data"].ensure_current_library_data = ensure_current_library_data;
        ρσ_modules["book_list.library_data"].ThumbnailCache = ThumbnailCache;
        ρσ_modules["book_list.library_data"].sync_library_books = sync_library_books;
    })();

    (function(){
        var __name__ = "date";
        var UNDEFINED_DATE_ISO, UNDEFINED_DATE, lcdata, supports_locales, fd_function_index;
        UNDEFINED_DATE_ISO = "0101-01-01T00:00:00+00:00";
        UNDEFINED_DATE = new Date(UNDEFINED_DATE_ISO);
        function is_date_undefined(date) {
            var ρσ_unpack, dy, uy;
            ρσ_unpack = [date.getUTCFullYear(), UNDEFINED_DATE.getUTCFullYear()];
            dy = ρσ_unpack[0];
            uy = ρσ_unpack[1];
            return dy < uy || dy === uy && date.getUTCMonth() === UNDEFINED_DATE.getUTCMonth() && date.getUTCDate() <= UNDEFINED_DATE.getUTCDate() + 1;
        };
        if (!is_date_undefined.__argnames__) Object.defineProperties(is_date_undefined, {
            __argnames__ : {value: ["date"]},
            __module__ : {value: "date"}
        });

        lcdata = (function(){
            var ρσ_d = Object.create(null);
            ρσ_d["abday"] = ρσ_list_decorate([ "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" ]);
            ρσ_d["abmon"] = ρσ_list_decorate([ "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" ]);
            ρσ_d["day"] = ρσ_list_decorate([ "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday" ]);
            ρσ_d["mon"] = ρσ_list_decorate([ "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December" ]);
            return ρσ_d;
        }).call(this);
        supports_locales = false;
        try {
            (new Date).toLocaleString("dfkjghdfkgj");
        } catch (ρσ_Exception) {
            ρσ_last_exception = ρσ_Exception;
            if (ρσ_Exception instanceof RangeError) {
                supports_locales = true;
            } else {
            } 
        }
        function fmt_date_pat() {
            var ans;
            ans = fmt_date_pat.ans;
            if (!(typeof ans !== "undefined" && ans !== null)) {
                ans = fmt_date_pat.ans = /(s{1,2})|(m{1,2})|(h{1,2})|(H{1,2})|(zzz)|(z)|(ap)|(AP)|(a)|(A)|(t)|(d{1,4}|M{1,4}|(?:yyyy|yy))/g;
            }
            return ans;
        };
        if (!fmt_date_pat.__module__) Object.defineProperties(fmt_date_pat, {
            __module__ : {value: "date"}
        });

        function fd_format_hour(dt, ampm, hr, as_utc) {
            var h;
            h = (as_utc) ? dt.getUTCHours() : dt.getHours();
            if (ampm) {
                h %= 12;
            }
            return (hr.length === 1) ? h.toString() : str.format("{:02d}", h);
        };
        if (!fd_format_hour.__argnames__) Object.defineProperties(fd_format_hour, {
            __argnames__ : {value: ["dt", "ampm", "hr", "as_utc"]},
            __module__ : {value: "date"}
        });

        function fd_format_hour24(dt, ampm, hr, as_utc) {
            return fd_format_hour(dt, false, hr, as_utc);
        };
        if (!fd_format_hour24.__argnames__) Object.defineProperties(fd_format_hour24, {
            __argnames__ : {value: ["dt", "ampm", "hr", "as_utc"]},
            __module__ : {value: "date"}
        });

        function fd_format_minute(dt, ampm, min, as_utc) {
            var m;
            m = (as_utc) ? dt.getUTCMinutes() : dt.getMinutes();
            return (min.length === 1) ? m.toString() : str.format("{:02d}", m);
        };
        if (!fd_format_minute.__argnames__) Object.defineProperties(fd_format_minute, {
            __argnames__ : {value: ["dt", "ampm", "min", "as_utc"]},
            __module__ : {value: "date"}
        });

        function fd_format_second(dt, ampm, min, as_utc) {
            var s;
            s = (as_utc) ? dt.getUTCSeconds() : dt.getSeconds();
            return (min.length === 1) ? s.toString() : str.format("{:02d}", s);
        };
        if (!fd_format_second.__argnames__) Object.defineProperties(fd_format_second, {
            __argnames__ : {value: ["dt", "ampm", "min", "as_utc"]},
            __module__ : {value: "date"}
        });

        function fd_format_ms(dt, ampm, min, as_utc) {
            var s;
            s = (as_utc) ? dt.getUTCMilliseconds() : dt.getSeconds();
            return (min.length === 1) ? s.toString() : str.format("{:03d}", s);
        };
        if (!fd_format_ms.__argnames__) Object.defineProperties(fd_format_ms, {
            __argnames__ : {value: ["dt", "ampm", "min", "as_utc"]},
            __module__ : {value: "date"}
        });

        function fd_format_timezone(dt, ampm, t, as_utc) {
            var short, full, idx;
            short = dt.toLocaleTimeString();
            full = dt.toLocaleTimeString([], (function(){
                var ρσ_d = Object.create(null);
                ρσ_d["timeZoneName"] = "long";
                return ρσ_d;
            }).call(this));
            idx = full.indexOf(short);
            if (idx > -1) {
                return full.slice(idx + short.length).strip();
            }
            return window.Intl.DateTimeFormat().resolvedOptions().timeZone;
        };
        if (!fd_format_timezone.__argnames__) Object.defineProperties(fd_format_timezone, {
            __argnames__ : {value: ["dt", "ampm", "t", "as_utc"]},
            __module__ : {value: "date"}
        });

        function fd_format_ampm(dt, ampm, ap, as_utc) {
            var h, ans;
            h = (as_utc) ? dt.getUTCHours() : dt.getHours();
            ans = (h < 12) ? "am" : "pm";
            return (ap === "ap" || ap === "a") ? ans : ans.toUpperCase();
        };
        if (!fd_format_ampm.__argnames__) Object.defineProperties(fd_format_ampm, {
            __argnames__ : {value: ["dt", "ampm", "ap", "as_utc"]},
            __module__ : {value: "date"}
        });

        function fd_format_day(dt, ampm, dy, as_utc) {
            var d, options, w;
            d = (as_utc) ? dt.getUTCDate() : dt.getDate();
            if (dy.length === 1) {
                return d.toString();
            }
            if (dy.length === 2) {
                return str.format("{:02d}", d);
            }
            if (supports_locales) {
                options = (function(){
                    var ρσ_d = Object.create(null);
                    ρσ_d["weekday"] = (dy.length === 3) ? "short" : "long";
                    return ρσ_d;
                }).call(this);
                if (as_utc) {
                    options["timeZone"] = "UTC";
                }
                return dt.toLocaleString(window.navigator.language, options);
            }
            w = (as_utc) ? dt.getUTCDay() : dt.getDay();
            return (ρσ_expr_temp = lcdata[ρσ_bound_index((dy.length === 3) ? "abday" : "day", lcdata)])[ρσ_bound_index((w + 1) % 7, ρσ_expr_temp)];
        };
        if (!fd_format_day.__argnames__) Object.defineProperties(fd_format_day, {
            __argnames__ : {value: ["dt", "ampm", "dy", "as_utc"]},
            __module__ : {value: "date"}
        });

        function fd_format_month(dt, ampm, mo, as_utc) {
            var m, options;
            m = (as_utc) ? dt.getUTCMonth() : dt.getMonth();
            if (mo.length === 1) {
                return (m + 1).toString();
            }
            if (mo.length === 2) {
                return str.format("{:02d}", m + 1);
            }
            if (supports_locales) {
                options = (function(){
                    var ρσ_d = Object.create(null);
                    ρσ_d["month"] = (ρσ_expr_temp = (function(){
                        var ρσ_d = Object.create(null);
                        ρσ_d[1] = "numeric";
                        ρσ_d[2] = "2-digit";
                        ρσ_d[3] = "short";
                        ρσ_d[4] = "long";
                        return ρσ_d;
                    }).call(this))[ρσ_bound_index(mo.length, ρσ_expr_temp)] || "long";
                    return ρσ_d;
                }).call(this);
                if (as_utc) {
                    options["timeZone"] = "UTC";
                }
                return dt.toLocaleString(window.navigator.language, options);
            }
            return (ρσ_expr_temp = lcdata[ρσ_bound_index((mo.length === 3) ? "abmon" : "mon", lcdata)])[(typeof m === "number" && m < 0) ? ρσ_expr_temp.length + m : m];
        };
        if (!fd_format_month.__argnames__) Object.defineProperties(fd_format_month, {
            __argnames__ : {value: ["dt", "ampm", "mo", "as_utc"]},
            __module__ : {value: "date"}
        });

        function fd_format_year(dt, ampm, yr, as_utc) {
            var y;
            y = (as_utc) ? dt.getUTCFullYear() : dt.getFullYear();
            if (yr.length === 2) {
                return str.format("{:02d}", y % 100);
            }
            return str.format("{:04d}", y);
        };
        if (!fd_format_year.__argnames__) Object.defineProperties(fd_format_year, {
            __argnames__ : {value: ["dt", "ampm", "yr", "as_utc"]},
            __module__ : {value: "date"}
        });

        fd_function_index = (function(){
            var ρσ_d = Object.create(null);
            ρσ_d["d"] = fd_format_day;
            ρσ_d["M"] = fd_format_month;
            ρσ_d["y"] = fd_format_year;
            ρσ_d["h"] = fd_format_hour;
            ρσ_d["H"] = fd_format_hour24;
            ρσ_d["m"] = fd_format_minute;
            ρσ_d["s"] = fd_format_second;
            ρσ_d["a"] = fd_format_ampm;
            ρσ_d["A"] = fd_format_ampm;
            ρσ_d["z"] = fd_format_ms;
            ρσ_d["t"] = fd_format_timezone;
            return ρσ_d;
        }).call(this);
        function am_pm_pat() {
            var ans;
            ans = am_pm_pat.ans;
            if (!(typeof ans !== "undefined" && ans !== null)) {
                ans = am_pm_pat.ans = /(ap)|(a)|(AP)|(A)/;
            }
            return ans;
        };
        if (!am_pm_pat.__module__) Object.defineProperties(am_pm_pat, {
            __module__ : {value: "date"}
        });

        function as_iso(date) {
            var tzo, dif;
            tzo = -date.getTimezoneOffset();
            dif = (tzo >= 0) ? "+" : "-";
            function pad(num) {
                return ((num < 10) ? "0" : "") + num;
            };
            if (!pad.__argnames__) Object.defineProperties(pad, {
                __argnames__ : {value: ["num"]},
                __module__ : {value: "date"}
            });

            return date.getFullYear() + "-" + pad(date.getMonth() + 1) + "-" + pad(date.getDate()) + " " + pad(date.getHours()) + ":" + pad(date.getMinutes()) + ":" + pad(date.getSeconds()) + dif + pad(Math.floor(Math.abs(tzo) / 60)) + ":" + pad(Math.abs(tzo) % 60);
        };
        if (!as_iso.__argnames__) Object.defineProperties(as_iso, {
            __argnames__ : {value: ["date"]},
            __module__ : {value: "date"}
        });

        function format_date() {
            var date = (arguments[0] === undefined || ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? format_date.__defaults__.date : arguments[0];
            var fmt = (arguments[1] === undefined || ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? format_date.__defaults__.fmt : arguments[1];
            var as_utc = (arguments[2] === undefined || ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? format_date.__defaults__.as_utc : arguments[2];
            var ρσ_kwargs_obj = arguments[arguments.length-1];
            if (ρσ_kwargs_obj === null || typeof ρσ_kwargs_obj !== "object" || ρσ_kwargs_obj [ρσ_kwargs_symbol] !== true) ρσ_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "date")){
                date = ρσ_kwargs_obj.date;
            }
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "fmt")){
                fmt = ρσ_kwargs_obj.fmt;
            }
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "as_utc")){
                as_utc = ρσ_kwargs_obj.as_utc;
            }
            var ampm;
            fmt = fmt || "dd MMM yyyy";
            ampm = am_pm_pat().test(fmt);
            if (typeof date === "string") {
                date = new Date(date);
            }
            date = date || new Date;
            if (is_date_undefined(date)) {
                return "";
            }
            if (fmt === "iso") {
                return as_iso(date);
            }
            return fmt.replace(fmt_date_pat(), (function() {
                var ρσ_anonfunc = function (match) {
                    if (!match) {
                        return "";
                    }
                    try {
                        return fd_function_index[ρσ_bound_index(match[0], fd_function_index)](date, ampm, match, as_utc);
                    } catch (ρσ_Exception) {
                        ρσ_last_exception = ρσ_Exception;
                        if (ρσ_Exception instanceof Error) {
                            print(str.format("Failed to format date with format: {} and match: {}", fmt, match));
                            return "";
                        } else {
                            throw ρσ_Exception;
                        }
                    }
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["match"]},
                    __module__ : {value: "date"}
                });
                return ρσ_anonfunc;
            })());
        };
        if (!format_date.__defaults__) Object.defineProperties(format_date, {
            __defaults__ : {value: {date:null, fmt:"dd MMM yyyy", as_utc:false}},
            __handles_kwarg_interpolation__ : {value: true},
            __argnames__ : {value: ["date", "fmt", "as_utc"]},
            __module__ : {value: "date"}
        });

        ρσ_modules.date.UNDEFINED_DATE_ISO = UNDEFINED_DATE_ISO;
        ρσ_modules.date.UNDEFINED_DATE = UNDEFINED_DATE;
        ρσ_modules.date.lcdata = lcdata;
        ρσ_modules.date.supports_locales = supports_locales;
        ρσ_modules.date.fd_function_index = fd_function_index;
        ρσ_modules.date.is_date_undefined = is_date_undefined;
        ρσ_modules.date.fmt_date_pat = fmt_date_pat;
        ρσ_modules.date.fd_format_hour = fd_format_hour;
        ρσ_modules.date.fd_format_hour24 = fd_format_hour24;
        ρσ_modules.date.fd_format_minute = fd_format_minute;
        ρσ_modules.date.fd_format_second = fd_format_second;
        ρσ_modules.date.fd_format_ms = fd_format_ms;
        ρσ_modules.date.fd_format_timezone = fd_format_timezone;
        ρσ_modules.date.fd_format_ampm = fd_format_ampm;
        ρσ_modules.date.fd_format_day = fd_format_day;
        ρσ_modules.date.fd_format_month = fd_format_month;
        ρσ_modules.date.fd_format_year = fd_format_year;
        ρσ_modules.date.am_pm_pat = am_pm_pat;
        ρσ_modules.date.as_iso = as_iso;
        ρσ_modules.date.format_date = format_date;
    })();

    (function(){
        var __name__ = "dom";
        var simple_vendor_prefixes, extra_css, add_extra_css;
        simple_vendor_prefixes = (function(){
            var ρσ_d = Object.create(null);
            ρσ_d["animation"] = ['webkit', 'moz', 'o'];
            ρσ_d["animation-name"] = ['webkit', 'moz', 'o'];
            ρσ_d["animation-duration"] = ['webkit', 'moz', 'o'];
            ρσ_d["animation-timing-function"] = ['webkit', 'moz', 'o'];
            ρσ_d["animation-delay"] = ['webkit', 'moz', 'o'];
            ρσ_d["animation-iteration-count"] = ['webkit', 'moz', 'o'];
            ρσ_d["animation-direction"] = ['webkit', 'moz', 'o'];
            ρσ_d["animation-fill-mode"] = ['webkit', 'moz', 'o'];
            ρσ_d["animation-play-state"] = ['webkit', 'moz', 'o'];
            ρσ_d["hyphens"] = ['webkit', 'moz', 'ms'];
            ρσ_d["transform"] = ['webkit', 'ms', 'moz', 'o'];
            ρσ_d["transform-origin"] = ['webkit', 'ms', 'moz', 'o'];
            ρσ_d["transition"] = ['webkit', 'moz', 'o'];
            ρσ_d["filter"] = ['webkit'];
            ρσ_d["user-select"] = ['webkit', 'moz', 'ms'];
            ρσ_d["break-before"] = ['webkit-column'];
            ρσ_d["break-after"] = ['webkit-column'];
            ρσ_d["break-inside"] = ['webkit-column'];
            ρσ_d["column-gap"] = ['webkit', 'moz'];
            ρσ_d["column-width"] = ['webkit', 'moz'];
            ρσ_d["column-rule"] = ['webkit', 'moz'];
            ρσ_d["column-fill"] = ['moz'];
            return ρσ_d;
        }).call(this);
        function set_css() {
            var elem = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[0];
            var kw = arguments[arguments.length-1];
            if (kw === null || typeof kw !== "object" || kw [ρσ_kwargs_symbol] !== true) kw = {};
            var s, ρσ_unpack, name, val, prefixes, prefix, prop;
            if (typeof elem === "string") {
                elem = document.querySelector(elem);
            }
            s = elem.style;
            if (s) {
                var ρσ_Iter0 = ρσ_Iterable(kw);
                for (var ρσ_Index0 = 0; ρσ_Index0 < ρσ_Iter0.length; ρσ_Index0++) {
                    prop = ρσ_Iter0[ρσ_Index0];
                    ρσ_unpack = [str.replace(str.rstrip(prop, "_"), "_", "-"), kw[(typeof prop === "number" && prop < 0) ? kw.length + prop : prop]];
                    name = ρσ_unpack[0];
                    val = ρσ_unpack[1];
                    if (val === null || val === undefined) {
                        s.removeProperty(name);
                    } else {
                        s.setProperty(name, val);
                    }
                    prefixes = simple_vendor_prefixes[(typeof name === "number" && name < 0) ? simple_vendor_prefixes.length + name : name];
                    if (prefixes) {
                        var ρσ_Iter1 = ρσ_Iterable(prefixes);
                        for (var ρσ_Index1 = 0; ρσ_Index1 < ρσ_Iter1.length; ρσ_Index1++) {
                            prefix = ρσ_Iter1[ρσ_Index1];
                            if (val === null || val === undefined) {
                                s.removeProperty("-" + prefix + "-" + name);
                            } else {
                                s.setProperty("-" + prefix + "-" + name, val);
                            }
                        }
                    }
                }
            }
            return elem;
        };
        if (!set_css.__handles_kwarg_interpolation__) Object.defineProperties(set_css, {
            __handles_kwarg_interpolation__ : {value: true},
            __argnames__ : {value: ["elem"]},
            __module__ : {value: "dom"}
        });

        function set_important_css() {
            var elem = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[0];
            var kw = arguments[arguments.length-1];
            if (kw === null || typeof kw !== "object" || kw [ρσ_kwargs_symbol] !== true) kw = {};
            var s, ρσ_unpack, name, val, prefixes, prefix, prop;
            if (typeof elem === "string") {
                elem = document.querySelector(elem);
            }
            s = elem.style;
            if (s) {
                var ρσ_Iter2 = ρσ_Iterable(kw);
                for (var ρσ_Index2 = 0; ρσ_Index2 < ρσ_Iter2.length; ρσ_Index2++) {
                    prop = ρσ_Iter2[ρσ_Index2];
                    ρσ_unpack = [str.replace(str.rstrip(prop, "_"), "_", "-"), kw[(typeof prop === "number" && prop < 0) ? kw.length + prop : prop]];
                    name = ρσ_unpack[0];
                    val = ρσ_unpack[1];
                    if (val === null || val === undefined) {
                        s.removeProperty(name);
                    } else {
                        s.setProperty(name, val, "important");
                    }
                    prefixes = simple_vendor_prefixes[(typeof name === "number" && name < 0) ? simple_vendor_prefixes.length + name : name];
                    if (prefixes) {
                        var ρσ_Iter3 = ρσ_Iterable(prefixes);
                        for (var ρσ_Index3 = 0; ρσ_Index3 < ρσ_Iter3.length; ρσ_Index3++) {
                            prefix = ρσ_Iter3[ρσ_Index3];
                            if (val === null || val === undefined) {
                                s.removeProperty("-" + prefix + "-" + name);
                            } else {
                                s.setProperty("-" + prefix + "-" + name, val, "important");
                            }
                        }
                    }
                }
            }
            return elem;
        };
        if (!set_important_css.__handles_kwarg_interpolation__) Object.defineProperties(set_important_css, {
            __handles_kwarg_interpolation__ : {value: true},
            __argnames__ : {value: ["elem"]},
            __module__ : {value: "dom"}
        });

        function build_rule() {
            var selector = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[0];
            var kw = arguments[arguments.length-1];
            if (kw === null || typeof kw !== "object" || kw [ρσ_kwargs_symbol] !== true) kw = {};
            var ans, ρσ_unpack, name, val, prefixes, prefix, prop;
            ans = [selector + " { "];
            var ρσ_Iter4 = ρσ_Iterable(kw);
            for (var ρσ_Index4 = 0; ρσ_Index4 < ρσ_Iter4.length; ρσ_Index4++) {
                prop = ρσ_Iter4[ρσ_Index4];
                ρσ_unpack = [str.replace(str.rstrip(prop, "_"), "_", "-"), kw[(typeof prop === "number" && prop < 0) ? kw.length + prop : prop]];
                name = ρσ_unpack[0];
                val = ρσ_unpack[1];
                ans.push(name + ":" + val + ";");
                prefixes = simple_vendor_prefixes[(typeof name === "number" && name < 0) ? simple_vendor_prefixes.length + name : name];
                if (prefixes) {
                    var ρσ_Iter5 = ρσ_Iterable(prefixes);
                    for (var ρσ_Index5 = 0; ρσ_Index5 < ρσ_Iter5.length; ρσ_Index5++) {
                        prefix = ρσ_Iter5[ρσ_Index5];
                        ans.push("-" + prefix + "-" + name + ":" + val + ";");
                    }
                }
            }
            ans.push("}");
            return ans.join("\n") + "\n";
        };
        if (!build_rule.__handles_kwarg_interpolation__) Object.defineProperties(build_rule, {
            __handles_kwarg_interpolation__ : {value: true},
            __argnames__ : {value: ["selector"]},
            __module__ : {value: "dom"}
        });

        function clear() {
            var node;
            for (var i = 0; i < arguments.length; i++) {
                node = arguments[(typeof i === "number" && i < 0) ? arguments.length + i : i];
                while (node.firstChild) {
                    node.removeChild(node.firstChild);
                }
            }
        };
        if (!clear.__module__) Object.defineProperties(clear, {
            __module__ : {value: "dom"}
        });

        function remove_all_attributes() {
            var node;
            for (var i = 0; i < arguments.length; i++) {
                node = arguments[(typeof i === "number" && i < 0) ? arguments.length + i : i];
                while (node.attributes.length > 0) {
                    node.removeAttributeNode(node.attributes[0]);
                }
            }
        };
        if (!remove_all_attributes.__module__) Object.defineProperties(remove_all_attributes, {
            __module__ : {value: "dom"}
        });

        function create_keyframes() {
            var animation_name = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[0];
            var frames = Array.prototype.slice.call(arguments, 1);
            if (arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) frames.pop();
            var ans, frame, prefix;
            ans = [];
            var ρσ_Iter6 = ρσ_Iterable(ρσ_list_decorate([ "-webkit-", "-moz-", "-o-", "" ]));
            for (var ρσ_Index6 = 0; ρσ_Index6 < ρσ_Iter6.length; ρσ_Index6++) {
                prefix = ρσ_Iter6[ρσ_Index6];
                ans.push("@" + prefix + "keyframes " + animation_name + " {");
                var ρσ_Iter7 = ρσ_Iterable(frames);
                for (var ρσ_Index7 = 0; ρσ_Index7 < ρσ_Iter7.length; ρσ_Index7++) {
                    frame = ρσ_Iter7[ρσ_Index7];
                    ans.push(frame);
                }
                ans.push("}");
            }
            return ans.join("\n") + "\n";
        };
        if (!create_keyframes.__handles_kwarg_interpolation__) Object.defineProperties(create_keyframes, {
            __handles_kwarg_interpolation__ : {value: true},
            __argnames__ : {value: ["animation_name"]},
            __module__ : {value: "dom"}
        });

        function change_icon_image(icon_element, new_name) {
            if (new_name) {
                icon_element.firstChild.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", "#icon-" + new_name);
            } else {
                icon_element.firstChild.removeAttributeNS("http://www.w3.org/1999/xlink", "xlink:href");
            }
        };
        if (!change_icon_image.__argnames__) Object.defineProperties(change_icon_image, {
            __argnames__ : {value: ["icon_element", "new_name"]},
            __module__ : {value: "dom"}
        });

        function svgicon(name, height, width, tooltip) {
            var ans, u, tt;
            ans = document.createElementNS("http://www.w3.org/2000/svg", "svg");
            ans.setAttribute("style", "fill: currentColor; height: {}; width: {}; vertical-align: text-top".format((typeof height !== "undefined" && height !== null ? height : "2ex"), (typeof width !== "undefined" && width !== null ? width : "2ex")));
            u = document.createElementNS("http://www.w3.org/2000/svg", "use");
            ans.appendChild(u);
            if (name) {
                ans.firstChild.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", "#icon-" + name);
            }
            if (tooltip) {
                tt = document.createElementNS("http://www.w3.org/2000/svg", "title");
                tt.textContent = tooltip;
                ans.appendChild(tt);
            }
            return ans;
        };
        if (!svgicon.__argnames__) Object.defineProperties(svgicon, {
            __argnames__ : {value: ["name", "height", "width", "tooltip"]},
            __module__ : {value: "dom"}
        });

        function element(elem_id, child_selector) {
            var ans;
            ans = (elem_id) ? document.getElementById(elem_id) : document.body;
            if (child_selector) {
                ans = ans.querySelector(child_selector);
            }
            return ans;
        };
        if (!element.__argnames__) Object.defineProperties(element, {
            __argnames__ : {value: ["elem_id", "child_selector"]},
            __module__ : {value: "dom"}
        });

        function selector() {
            var id_selector = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[0];
            var args = Array.prototype.slice.call(arguments, 1);
            if (arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) args.pop();
            var ans, x;
            ans = "#" + id_selector;
            var ρσ_Iter8 = ρσ_Iterable(args);
            for (var ρσ_Index8 = 0; ρσ_Index8 < ρσ_Iter8.length; ρσ_Index8++) {
                x = ρσ_Iter8[ρσ_Index8];
                ans += " " + x;
            }
            return ans;
        };
        if (!selector.__handles_kwarg_interpolation__) Object.defineProperties(selector, {
            __handles_kwarg_interpolation__ : {value: true},
            __argnames__ : {value: ["id_selector"]},
            __module__ : {value: "dom"}
        });

        function rule() {
            var id_selector = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[0];
            var kw = arguments[arguments.length-1];
            if (kw === null || typeof kw !== "object" || kw [ρσ_kwargs_symbol] !== true) kw = {};
            var args = Array.prototype.slice.call(arguments, 1);
            if (kw !== null && typeof kw === "object" && kw [ρσ_kwargs_symbol] === true) args.pop();
            return ρσ_interpolate_kwargs.call(this, build_rule, [selector.apply(this, [id_selector].concat(args))].concat([ρσ_desugar_kwargs(kw)]));
        };
        if (!rule.__handles_kwarg_interpolation__) Object.defineProperties(rule, {
            __handles_kwarg_interpolation__ : {value: true},
            __argnames__ : {value: ["id_selector"]},
            __module__ : {value: "dom"}
        });

        function unique_id(prefix) {
            var num;
            prefix = prefix || "auto-id";
            (ρσ_expr_temp = unique_id.counts)[(typeof prefix === "number" && prefix < 0) ? ρσ_expr_temp.length + prefix : prefix] = num = ((ρσ_expr_temp = unique_id.counts)[(typeof prefix === "number" && prefix < 0) ? ρσ_expr_temp.length + prefix : prefix] || 0) + 1;
            return prefix + "-" + num;
        };
        if (!unique_id.__argnames__) Object.defineProperties(unique_id, {
            __argnames__ : {value: ["prefix"]},
            __module__ : {value: "dom"}
        });

        unique_id.counts = Object.create(null);
        function ensure_id(w, prefix) {
            var ans;
            ans = w.getAttribute("id");
            if (!ans) {
                ans = unique_id(prefix);
                w.setAttribute("id", ans);
            }
            return ans;
        };
        if (!ensure_id.__argnames__) Object.defineProperties(ensure_id, {
            __argnames__ : {value: ["w", "prefix"]},
            __module__ : {value: "dom"}
        });

        extra_css = [];
        add_extra_css = extra_css.push.bind(extra_css);
        function get_widget_css() {
            var ans, func;
            ans = [];
            var ρσ_Iter9 = ρσ_Iterable(extra_css);
            for (var ρσ_Index9 = 0; ρσ_Index9 < ρσ_Iter9.length; ρσ_Index9++) {
                func = ρσ_Iter9[ρσ_Index9];
                ans.push(func());
            }
            return ans.join("\n");
        };
        if (!get_widget_css.__module__) Object.defineProperties(get_widget_css, {
            __module__ : {value: "dom"}
        });

        function set_radio_group_value(parent, name, val) {
            var changed, inp;
            changed = false;
            var ρσ_Iter10 = ρσ_Iterable(parent.querySelectorAll("input[name=" + ρσ_str.format("{}", name) + "]"));
            for (var ρσ_Index10 = 0; ρσ_Index10 < ρσ_Iter10.length; ρσ_Index10++) {
                inp = ρσ_Iter10[ρσ_Index10];
                inp.checked = inp.value === val;
                changed = true;
            }
            if (!changed) {
                throw new KeyError("No radio group with name=" + ρσ_str.format("{}", name) + " found");
            }
        };
        if (!set_radio_group_value.__argnames__) Object.defineProperties(set_radio_group_value, {
            __argnames__ : {value: ["parent", "name", "val"]},
            __module__ : {value: "dom"}
        });

        ρσ_modules.dom.simple_vendor_prefixes = simple_vendor_prefixes;
        ρσ_modules.dom.extra_css = extra_css;
        ρσ_modules.dom.add_extra_css = add_extra_css;
        ρσ_modules.dom.set_css = set_css;
        ρσ_modules.dom.set_important_css = set_important_css;
        ρσ_modules.dom.build_rule = build_rule;
        ρσ_modules.dom.clear = clear;
        ρσ_modules.dom.remove_all_attributes = remove_all_attributes;
        ρσ_modules.dom.create_keyframes = create_keyframes;
        ρσ_modules.dom.change_icon_image = change_icon_image;
        ρσ_modules.dom.svgicon = svgicon;
        ρσ_modules.dom.element = element;
        ρσ_modules.dom.selector = selector;
        ρσ_modules.dom.rule = rule;
        ρσ_modules.dom.unique_id = unique_id;
        ρσ_modules.dom.ensure_id = ensure_id;
        ρσ_modules.dom.get_widget_css = get_widget_css;
        ρσ_modules.dom.set_radio_group_value = set_radio_group_value;
    })();

    (function(){
        var __name__ = "popups";
        var MODAL_Z_INDEX, POPUP_Z_INDEX, popup_count, shown_popups, associated_widgets;
        var get_color = ρσ_modules["book_list.theme"].get_color;

        var set_css = ρσ_modules.dom.set_css;
        var ensure_id = ρσ_modules.dom.ensure_id;
        var clear = ρσ_modules.dom.clear;
        var build_rule = ρσ_modules.dom.build_rule;
        var add_extra_css = ρσ_modules.dom.add_extra_css;

        var E = ρσ_modules.elementmaker.E;

        MODAL_Z_INDEX = 1e3;
        POPUP_Z_INDEX = MODAL_Z_INDEX + 1;
        popup_count = 0;
        shown_popups = set();
        associated_widgets = Object.create(null);
        function element_contains_click_event(element, event) {
            var r;
            r = element.getBoundingClientRect();
            return r.left <= (ρσ_cond_temp = event.clientX) && ρσ_cond_temp <= r.right && r.top <= (ρσ_cond_temp = event.clientY) && ρσ_cond_temp <= r.bottom;
        };
        if (!element_contains_click_event.__argnames__) Object.defineProperties(element_contains_click_event, {
            __argnames__ : {value: ["element", "event"]},
            __module__ : {value: "popups"}
        });

        function click_in_popup(event) {
            var popup, w, widget, wid, popup_id;
            var ρσ_Iter0 = ρσ_Iterable(shown_popups);
            for (var ρσ_Index0 = 0; ρσ_Index0 < ρσ_Iter0.length; ρσ_Index0++) {
                popup_id = ρσ_Iter0[ρσ_Index0];
                popup = document.getElementById(popup_id);
                if (popup && element_contains_click_event(popup, event)) {
                    return true;
                }
                w = associated_widgets[(typeof popup_id === "number" && popup_id < 0) ? associated_widgets.length + popup_id : popup_id];
                if (w && w.length) {
                    var ρσ_Iter1 = ρσ_Iterable(w);
                    for (var ρσ_Index1 = 0; ρσ_Index1 < ρσ_Iter1.length; ρσ_Index1++) {
                        wid = ρσ_Iter1[ρσ_Index1];
                        widget = document.getElementById(wid);
                        if (widget && element_contains_click_event(widget, event)) {
                            return true;
                        }
                    }
                }
            }
            return false;
        };
        if (!click_in_popup.__argnames__) Object.defineProperties(click_in_popup, {
            __argnames__ : {value: ["event"]},
            __module__ : {value: "popups"}
        });

        function filter_clicks(event) {
            var popup_id;
            if (shown_popups.length) {
                if (!click_in_popup(event)) {
                    var ρσ_Iter2 = ρσ_Iterable(shown_popups);
                    for (var ρσ_Index2 = 0; ρσ_Index2 < ρσ_Iter2.length; ρσ_Index2++) {
                        popup_id = ρσ_Iter2[ρσ_Index2];
                        hide_popup(popup_id);
                    }
                    shown_popups.clear();
                    [event.stopPropagation(), event.preventDefault()];
                }
            }
        };
        if (!filter_clicks.__argnames__) Object.defineProperties(filter_clicks, {
            __argnames__ : {value: ["event"]},
            __module__ : {value: "popups"}
        });

        function install_event_filters() {
            window.addEventListener("click", filter_clicks, true);
        };
        if (!install_event_filters.__module__) Object.defineProperties(install_event_filters, {
            __module__ : {value: "popups"}
        });

        function create_popup(parent, idprefix) {
            var pid, div;
            popup_count += 1;
            pid = (idprefix || "popup") + "-" + popup_count;
            div = ρσ_interpolate_kwargs.call(E, E.div, [ρσ_desugar_kwargs({id: pid, style: "display: none; position: fixed; z-index: {}".format(POPUP_Z_INDEX)})]);
            parent = parent || document.body;
            parent.appendChild(div);
            return div;
        };
        if (!create_popup.__argnames__) Object.defineProperties(create_popup, {
            __argnames__ : {value: ["parent", "idprefix"]},
            __module__ : {value: "popups"}
        });

        function show_popup() {
            var popup_id = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[0];
            var associated_widget_ids = (arguments[1] === undefined || ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? show_popup.__defaults__.associated_widget_ids : arguments[1];
            var ρσ_kwargs_obj = arguments[arguments.length-1];
            if (ρσ_kwargs_obj === null || typeof ρσ_kwargs_obj !== "object" || ρσ_kwargs_obj [ρσ_kwargs_symbol] !== true) ρσ_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "associated_widget_ids")){
                associated_widget_ids = ρσ_kwargs_obj.associated_widget_ids;
            }
            var elem;
            elem = document.getElementById(popup_id);
            elem.style.display = "block";
            shown_popups.add(popup_id);
            associated_widgets[(typeof popup_id === "number" && popup_id < 0) ? associated_widgets.length + popup_id : popup_id] = associated_widget_ids;
        };
        if (!show_popup.__defaults__) Object.defineProperties(show_popup, {
            __defaults__ : {value: {associated_widget_ids:null}},
            __handles_kwarg_interpolation__ : {value: true},
            __argnames__ : {value: ["popup_id", "associated_widget_ids"]},
            __module__ : {value: "popups"}
        });

        function hide_popup(popup_id) {
            var elem;
            elem = document.getElementById(popup_id);
            if (elem) {
                elem.style.display = "none";
            }
            delete associated_widgets[popup_id];
        };
        if (!hide_popup.__argnames__) Object.defineProperties(hide_popup, {
            __argnames__ : {value: ["popup_id"]},
            __module__ : {value: "popups"}
        });

        function CompletionPopup() {
            if (this.ρσ_object_id === undefined) Object.defineProperty(this, "ρσ_object_id", {"value":++ρσ_object_counter});
            CompletionPopup.prototype.__bind_methods__.call(this);
            CompletionPopup.prototype.__init__.apply(this, arguments);
        }
        Object.defineProperty(CompletionPopup.prototype, "__bind_methods__", {value: function () {
            this.set_all_items = CompletionPopup.prototype.set_all_items.bind(this);
            this.add_associated_widget = CompletionPopup.prototype.add_associated_widget.bind(this);
            this.popup = CompletionPopup.prototype.popup.bind(this);
            this.show_at_widget = CompletionPopup.prototype.show_at_widget.bind(this);
            this.set_query = CompletionPopup.prototype.set_query.bind(this);
            this.hide = CompletionPopup.prototype.hide.bind(this);
            this.handle_keydown = CompletionPopup.prototype.handle_keydown.bind(this);
            this.move_highlight = CompletionPopup.prototype.move_highlight.bind(this);
            this._show_at = CompletionPopup.prototype._show_at.bind(this);
            this._apply_query = CompletionPopup.prototype._apply_query.bind(this);
            this._render_matches = CompletionPopup.prototype._render_matches.bind(this);
            this.onmouseenter = CompletionPopup.prototype.onmouseenter.bind(this);
            this.onclick = CompletionPopup.prototype.onclick.bind(this);
        }});
        Object.defineProperties(CompletionPopup.prototype,  {
            "container": {
                "enumerable": true, 
                "get": function container() {
                    var self = this;
                    return document.getElementById(self.container_id);
                }, 
                "set": function () { throw new AttributeError("can't set attribute") }
            }, 
            "is_visible": {
                "enumerable": true, 
                "get": function is_visible() {
                    var self = this;
                    return self.container.style.display !== "none";
                }, 
                "set": function () { throw new AttributeError("can't set attribute") }
            }, 
            "current_item": {
                "enumerable": true, 
                "get": function current_item() {
                    var self = this;
                    var c;
                    c = self.container;
                    return c.querySelector("div.{} > div.{}".format(self.CLASS, self.CURRENT_ITEM_CLASS));
                }, 
                "set": function () { throw new AttributeError("can't set attribute") }
            }, 
            "current_text": {
                "enumerable": true, 
                "get": function current_text() {
                    var self = this;
                    return ρσ_exists.d(self.current_item).textContent;
                }, 
                "set": function () { throw new AttributeError("can't set attribute") }
            }, 
        });
        CompletionPopup.prototype.__init__ = function __init__() {
            var self = this;
            var parent = (arguments[0] === undefined || ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? __init__.__defaults__.parent : arguments[0];
            var max_items = (arguments[1] === undefined || ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? __init__.__defaults__.max_items : arguments[1];
            var onselect = (arguments[2] === undefined || ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? __init__.__defaults__.onselect : arguments[2];
            var ρσ_kwargs_obj = arguments[arguments.length-1];
            if (ρσ_kwargs_obj === null || typeof ρσ_kwargs_obj !== "object" || ρσ_kwargs_obj [ρσ_kwargs_symbol] !== true) ρσ_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "parent")){
                parent = ρσ_kwargs_obj.parent;
            }
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "max_items")){
                max_items = ρσ_kwargs_obj.max_items;
            }
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "onselect")){
                onselect = ρσ_kwargs_obj.onselect;
            }
            var c, ρσ_unpack;
            self.max_items = max_items;
            c = create_popup(parent);
            ρσ_interpolate_kwargs.call(this, set_css, [c].concat([ρσ_desugar_kwargs({user_select: "none"})]));
            self.container_id = c.getAttribute("id");
            self.onselect = onselect;
            self.items = ρσ_list_decorate([]);
            self.matches = ρσ_list_decorate([]);
            c.appendChild(ρσ_interpolate_kwargs.call(E, E.div, [ρσ_desugar_kwargs({class_: self.CLASS})]));
            self.associated_widget_ids = set();
            ρσ_unpack = ["", false];
            self.current_query = ρσ_unpack[0];
            self.is_upwards = ρσ_unpack[1];
            self.applied_query = self.current_query;
        };
        if (!CompletionPopup.prototype.__init__.__defaults__) Object.defineProperties(CompletionPopup.prototype.__init__, {
            __defaults__ : {value: {parent:null, max_items:25, onselect:null}},
            __handles_kwarg_interpolation__ : {value: true},
            __argnames__ : {value: ["parent", "max_items", "onselect"]},
            __module__ : {value: "popups"}
        });
        CompletionPopup.__argnames__ = CompletionPopup.prototype.__init__.__argnames__;
        CompletionPopup.__handles_kwarg_interpolation__ = CompletionPopup.prototype.__init__.__handles_kwarg_interpolation__;
        CompletionPopup.prototype.set_all_items = function set_all_items(items) {
            var self = this;
            self.items = list(items);
            self.matches = ρσ_list_decorate([]);
            self.applied_query = null;
        };
        if (!CompletionPopup.prototype.set_all_items.__argnames__) Object.defineProperties(CompletionPopup.prototype.set_all_items, {
            __argnames__ : {value: ["items"]},
            __module__ : {value: "popups"}
        });
        CompletionPopup.prototype.add_associated_widget = function add_associated_widget(widget_or_id) {
            var self = this;
            if (typeof widget_or_id !== "string") {
                widget_or_id = ensure_id(widget_or_id);
            }
            self.associated_widget_ids.add(widget_or_id);
        };
        if (!CompletionPopup.prototype.add_associated_widget.__argnames__) Object.defineProperties(CompletionPopup.prototype.add_associated_widget, {
            __argnames__ : {value: ["widget_or_id"]},
            __module__ : {value: "popups"}
        });
        CompletionPopup.prototype.popup = function popup(widget) {
            var self = this;
            if (!self.is_visible) {
                if (self.applied_query !== self.current_query) {
                    self._apply_query();
                }
                if (self.matches.length) {
                    self.show_at_widget(widget);
                }
            }
        };
        if (!CompletionPopup.prototype.popup.__argnames__) Object.defineProperties(CompletionPopup.prototype.popup, {
            __argnames__ : {value: ["widget"]},
            __module__ : {value: "popups"}
        });
        CompletionPopup.prototype.show_at_widget = function show_at_widget(w) {
            var self = this;
            var br, ρσ_unpack, y, upwards;
            br = w.getBoundingClientRect();
            if (br.top > window.innerHeight - br.bottom) {
                ρσ_unpack = [br.top, true];
                y = ρσ_unpack[0];
                upwards = ρσ_unpack[1];
            } else {
                ρσ_unpack = [br.bottom, false];
                y = ρσ_unpack[0];
                upwards = ρσ_unpack[1];
            }
            self._show_at(br.left, y, br.width, upwards);
        };
        if (!CompletionPopup.prototype.show_at_widget.__argnames__) Object.defineProperties(CompletionPopup.prototype.show_at_widget, {
            __argnames__ : {value: ["w"]},
            __module__ : {value: "popups"}
        });
        CompletionPopup.prototype.set_query = function set_query(query) {
            var self = this;
            self.current_query = query;
            if (self.is_visible && self.applied_query !== self.current_query) {
                self._apply_query();
                if (!self.matches.length) {
                    self.hide();
                }
            }
        };
        if (!CompletionPopup.prototype.set_query.__argnames__) Object.defineProperties(CompletionPopup.prototype.set_query, {
            __argnames__ : {value: ["query"]},
            __module__ : {value: "popups"}
        });
        CompletionPopup.prototype.hide = function hide() {
            var self = this;
            var c;
            self.container.style.display = "none";
            c = self.current_item;
            if (c) {
                c.classList.remove(self.CURRENT_ITEM_CLASS);
            }
        };
        if (!CompletionPopup.prototype.hide.__module__) Object.defineProperties(CompletionPopup.prototype.hide, {
            __module__ : {value: "popups"}
        });
        CompletionPopup.prototype.handle_keydown = function handle_keydown(event) {
            var self = this;
            var key;
            key = event.key;
            if (key === "Escape" || key === "Esc") {
                self.hide();
                return true;
            }
            if (key === "ArrowUp") {
                self.move_highlight(true);
                return true;
            }
            if (key === "ArrowDown") {
                self.move_highlight(false);
                return true;
            }
            return false;
        };
        if (!CompletionPopup.prototype.handle_keydown.__argnames__) Object.defineProperties(CompletionPopup.prototype.handle_keydown, {
            __argnames__ : {value: ["event"]},
            __module__ : {value: "popups"}
        });
        CompletionPopup.prototype.move_highlight = function move_highlight() {
            var self = this;
            var up = (arguments[0] === undefined || ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? move_highlight.__defaults__.up : arguments[0];
            var ρσ_kwargs_obj = arguments[arguments.length-1];
            if (ρσ_kwargs_obj === null || typeof ρσ_kwargs_obj !== "object" || ρσ_kwargs_obj [ρσ_kwargs_symbol] !== true) ρσ_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "up")){
                up = ρσ_kwargs_obj.up;
            }
            var ans, div, c;
            if (up === null) {
                up = self.is_upwards;
            }
            ans = null;
            div = self.current_item;
            if (div) {
                div.classList.remove(self.CURRENT_ITEM_CLASS);
                ans = (up) ? div.previousSibling : div.nextSibling;
            }
            if (!ans) {
                c = self.container.firstChild;
                ans = (up) ? c.lastChild : c.firstChild;
            }
            if (ans) {
                ans.classList.add(self.CURRENT_ITEM_CLASS);
            }
        };
        if (!CompletionPopup.prototype.move_highlight.__defaults__) Object.defineProperties(CompletionPopup.prototype.move_highlight, {
            __defaults__ : {value: {up:null}},
            __handles_kwarg_interpolation__ : {value: true},
            __argnames__ : {value: ["up"]},
            __module__ : {value: "popups"}
        });
        CompletionPopup.prototype._show_at = function _show_at(x, y, width, upwards) {
            var self = this;
            var c, cs;
            self.is_upwards = upwards;
            c = self.container;
            cs = c.style;
            cs.left = x + "px";
            cs.top = (upwards) ? "auto" : y + "px";
            cs.bottom = (upwards) ? window.innerHeight - y + "px" : "auto";
            cs.width = width + "px";
            cs.maxHeight = ((upwards) ? y : window.innerHeight - y) - 10 + "px";
            show_popup(self.container_id, self.associated_widget_ids);
        };
        if (!CompletionPopup.prototype._show_at.__argnames__) Object.defineProperties(CompletionPopup.prototype._show_at, {
            __argnames__ : {value: ["x", "y", "width", "upwards"]},
            __module__ : {value: "popups"}
        });
        CompletionPopup.prototype._apply_query = function _apply_query() {
            var self = this;
            var q, i;
            q = self.current_query.toLowerCase();
            self.matches.clear();
            self.applied_query = self.current_query;
            if (!q) {
                self.matches = list(self.items.slice(0, self.max_items + 1));
            } else {
                i = 0;
                while (self.matches.length < self.max_items && i < self.items.length) {
                    if ((ρσ_expr_temp = self.items)[(typeof i === "number" && i < 0) ? ρσ_expr_temp.length + i : i].toLowerCase().startswith(q)) {
                        self.matches.push((ρσ_expr_temp = self.items)[(typeof i === "number" && i < 0) ? ρσ_expr_temp.length + i : i]);
                    }
                    i += 1;
                }
            }
            self._render_matches();
        };
        if (!CompletionPopup.prototype._apply_query.__module__) Object.defineProperties(CompletionPopup.prototype._apply_query, {
            __module__ : {value: "popups"}
        });
        CompletionPopup.prototype._render_matches = function _render_matches() {
            var self = this;
            var c, items, m;
            c = self.container;
            clear(c.firstChild);
            items = self.matches;
            if (self.is_upwards) {
                items = reversed(items);
            }
            var ρσ_Iter3 = ρσ_Iterable(items);
            for (var ρσ_Index3 = 0; ρσ_Index3 < ρσ_Iter3.length; ρσ_Index3++) {
                m = ρσ_Iter3[ρσ_Index3];
                c.firstChild.appendChild(ρσ_interpolate_kwargs.call(E, E.div, [m].concat([ρσ_desugar_kwargs({onmouseenter: self.onmouseenter, onclick: self.onclick})])));
            }
        };
        if (!CompletionPopup.prototype._render_matches.__module__) Object.defineProperties(CompletionPopup.prototype._render_matches, {
            __module__ : {value: "popups"}
        });
        CompletionPopup.prototype.onmouseenter = function onmouseenter(event) {
            var self = this;
            var div;
            div = self.current_item;
            if (div) {
                div.classList.remove(self.CURRENT_ITEM_CLASS);
            }
            event.currentTarget.classList.add(self.CURRENT_ITEM_CLASS);
        };
        if (!CompletionPopup.prototype.onmouseenter.__argnames__) Object.defineProperties(CompletionPopup.prototype.onmouseenter, {
            __argnames__ : {value: ["event"]},
            __module__ : {value: "popups"}
        });
        CompletionPopup.prototype.onclick = function onclick(event) {
            var self = this;
            self.onmouseenter(event);
            try {
                if (self.onselect) {
                    self.onselect(self.current_text);
                }
            } finally {
                self.hide();
            }
        };
        if (!CompletionPopup.prototype.onclick.__argnames__) Object.defineProperties(CompletionPopup.prototype.onclick, {
            __argnames__ : {value: ["event"]},
            __module__ : {value: "popups"}
        });
        CompletionPopup.prototype.__repr__ = function __repr__ () {
                        return "<" + __name__ + "." + this.constructor.name + " #" + this.ρσ_object_id + ">";
        };
        CompletionPopup.prototype.__str__ = function __str__ () {
            return this.__repr__();
        };
        Object.defineProperty(CompletionPopup.prototype, "__bases__", {value: []});
        CompletionPopup.prototype.CLASS = "popup-completion-items";
        CompletionPopup.prototype.CURRENT_ITEM_CLASS = "popup-completion-current-item";
        
        
        
        

        add_extra_css((function() {
            var ρσ_anonfunc = function () {
                var sel, style;
                sel = "div." + CompletionPopup.prototype.CLASS;
                style = ρσ_interpolate_kwargs.call(this, build_rule, [sel].concat([ρσ_desugar_kwargs({overflow: "hidden", text_align: "left", background_color: get_color("window-background"), border: "solid 1px " + get_color("window-foreground")})]));
                sel += " > div";
                style += ρσ_interpolate_kwargs.call(this, build_rule, [sel].concat([ρσ_desugar_kwargs({cursor: "pointer", padding: "1ex 1rem", white_space: "nowrap", text_overflow: "ellipsis", overflow: "hidden"})]));
                sel += "." + CompletionPopup.prototype.CURRENT_ITEM_CLASS;
                style += ρσ_interpolate_kwargs.call(this, build_rule, [sel].concat([ρσ_desugar_kwargs({color: get_color("list-hover-foreground"), background_color: get_color("list-hover-background")})]));
                return style;
            };
            if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
                __module__ : {value: "popups"}
            });
            return ρσ_anonfunc;
        })());
        ρσ_modules.popups.MODAL_Z_INDEX = MODAL_Z_INDEX;
        ρσ_modules.popups.POPUP_Z_INDEX = POPUP_Z_INDEX;
        ρσ_modules.popups.popup_count = popup_count;
        ρσ_modules.popups.shown_popups = shown_popups;
        ρσ_modules.popups.associated_widgets = associated_widgets;
        ρσ_modules.popups.element_contains_click_event = element_contains_click_event;
        ρσ_modules.popups.click_in_popup = click_in_popup;
        ρσ_modules.popups.filter_clicks = filter_clicks;
        ρσ_modules.popups.install_event_filters = install_event_filters;
        ρσ_modules.popups.create_popup = create_popup;
        ρσ_modules.popups.show_popup = show_popup;
        ρσ_modules.popups.hide_popup = hide_popup;
        ρσ_modules.popups.CompletionPopup = CompletionPopup;
    })();

    (function(){
        var __name__ = "widgets";
        var build_rule = ρσ_modules.dom.build_rule;
        var clear = ρσ_modules.dom.clear;
        var svgicon = ρσ_modules.dom.svgicon;
        var create_keyframes = ρσ_modules.dom.create_keyframes;
        var set_css = ρσ_modules.dom.set_css;
        var change_icon_image = ρσ_modules.dom.change_icon_image;
        var add_extra_css = ρσ_modules.dom.add_extra_css;
        var ensure_id = ρσ_modules.dom.ensure_id;

        var E = ρσ_modules.elementmaker.E;

        var get_color = ρσ_modules["book_list.theme"].get_color;

        function create_button() {
            var text = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[0];
            var icon = (arguments[1] === undefined || ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? create_button.__defaults__.icon : arguments[1];
            var action = (arguments[2] === undefined || ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? create_button.__defaults__.action : arguments[2];
            var tooltip = (arguments[3] === undefined || ( 3 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? create_button.__defaults__.tooltip : arguments[3];
            var highlight = (arguments[4] === undefined || ( 4 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? create_button.__defaults__.highlight : arguments[4];
            var download_filename = (arguments[5] === undefined || ( 5 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? create_button.__defaults__.download_filename : arguments[5];
            var class_ = (arguments[6] === undefined || ( 6 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? create_button.__defaults__.class_ : arguments[6];
            var ρσ_kwargs_obj = arguments[arguments.length-1];
            if (ρσ_kwargs_obj === null || typeof ρσ_kwargs_obj !== "object" || ρσ_kwargs_obj [ρσ_kwargs_symbol] !== true) ρσ_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "icon")){
                icon = ρσ_kwargs_obj.icon;
            }
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "action")){
                action = ρσ_kwargs_obj.action;
            }
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "tooltip")){
                tooltip = ρσ_kwargs_obj.tooltip;
            }
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "highlight")){
                highlight = ρσ_kwargs_obj.highlight;
            }
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "download_filename")){
                download_filename = ρσ_kwargs_obj.download_filename;
            }
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "class_")){
                class_ = ρσ_kwargs_obj.class_;
            }
            var ic, ans;
            ic = "";
            if (icon) {
                ic = svgicon(icon);
                text = " " + text;
            }
            ans = ρσ_interpolate_kwargs.call(E, E.a, [ic, E.span(text)].concat([ρσ_desugar_kwargs({class_: "calibre-push-button " + class_, href: "javascript: void(0)", role: "button", title: tooltip || ""})]));
            if (download_filename && "download" in ans) {
                ans.setAttribute("download", download_filename);
            }
            if (action !== null) {
                if (typeof action === "string") {
                    ans.setAttribute("href", action);
                } else {
                    ans.addEventListener("click", (function() {
                        var ρσ_anonfunc = function (event) {
                            [event.preventDefault(), action(event)];
                        };
                        if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                            __argnames__ : {value: ["event"]},
                            __module__ : {value: "widgets"}
                        });
                        return ρσ_anonfunc;
                    })());
                }
            }
            if (highlight) {
                ρσ_interpolate_kwargs.call(this, set_css, [ans].concat([ρσ_desugar_kwargs({font_size: "larger", font_weight: "bold"})]));
            }
            return ans;
        };
        if (!create_button.__defaults__) Object.defineProperties(create_button, {
            __defaults__ : {value: {icon:null, action:null, tooltip:null, highlight:false, download_filename:null, class_:""}},
            __handles_kwarg_interpolation__ : {value: true},
            __argnames__ : {value: ["text", "icon", "action", "tooltip", "highlight", "download_filename", "class_"]},
            __module__ : {value: "widgets"}
        });

        create_button.style = ρσ_interpolate_kwargs.call(this, build_rule, ["a.calibre-push-button"].concat([ρσ_desugar_kwargs({border_radius: "1em", background_clip: "padding-box", background_color: get_color("button-start"), background_image: "linear-gradient(to bottom, {}, {})".format(get_color("button-start"), get_color("button-end")), padding: "0.5ex 1em", color: get_color("button-text"), cursor: "pointer", font_size: "inherit", display: "inline-flex", align_items: "center", user_select: "none", box_shadow: "0px 2px 1px rgba(50, 50, 50, 0.75)", white_space: "nowrap"})]));
        create_button.style += ρσ_interpolate_kwargs.call(this, build_rule, ["a.calibre-push-button:hover"].concat([ρσ_desugar_kwargs({transform: "scale(1.05)"})]));
        create_button.style += ρσ_interpolate_kwargs.call(this, build_rule, ["a.calibre-push-button:active"].concat([ρσ_desugar_kwargs({transform: "scale(1.1)"})]));
        create_button.style += ρσ_interpolate_kwargs.call(this, build_rule, ["a.calibre-push-button:visited"].concat([ρσ_desugar_kwargs({color: get_color("button-text")})]));
        function create_spinner(height, width) {
            var ans;
            ans = svgicon("cog", height, width);
            ans.classList.add("spin");
            return ans;
        };
        if (!create_spinner.__argnames__) Object.defineProperties(create_spinner, {
            __argnames__ : {value: ["height", "width"]},
            __module__ : {value: "widgets"}
        });

        create_spinner.style = ρσ_interpolate_kwargs.call(this, build_rule, [".spin"].concat([ρσ_desugar_kwargs({animation: "spin 2s infinite linear"})]));
        create_spinner.style += create_keyframes("spin", "from { transform: rotate(0deg); } to { transform: rotate(359deg);}");
        function Breadcrumbs() {
            if (this.ρσ_object_id === undefined) Object.defineProperty(this, "ρσ_object_id", {"value":++ρσ_object_counter});
            Breadcrumbs.prototype.__init__.apply(this, arguments);
        }
        Object.defineProperties(Breadcrumbs.prototype,  {
            "container": {
                "enumerable": true, 
                "get": function container() {
                    var self = this;
                    return document.getElementById(self.container_id);
                }, 
                "set": function () { throw new AttributeError("can't set attribute") }
            }, 
        });
        Breadcrumbs.prototype.__init__ = function __init__(container) {
            var self = this;
            self.container_id = ensure_id(container, "calibre-breadcrumbs-");
            container.classList.add("calibre-breadcrumbs");
            clear(container);
        };
        if (!Breadcrumbs.prototype.__init__.__argnames__) Object.defineProperties(Breadcrumbs.prototype.__init__, {
            __argnames__ : {value: ["container"]},
            __module__ : {value: "widgets"}
        });
        Breadcrumbs.__argnames__ = Breadcrumbs.prototype.__init__.__argnames__;
        Breadcrumbs.__handles_kwarg_interpolation__ = Breadcrumbs.prototype.__init__.__handles_kwarg_interpolation__;
        Breadcrumbs.prototype.reset = function reset() {
            var self = this;
            clear(self.container);
        };
        if (!Breadcrumbs.prototype.reset.__module__) Object.defineProperties(Breadcrumbs.prototype.reset, {
            __module__ : {value: "widgets"}
        });
        Breadcrumbs.prototype.add_crumb = function add_crumb(callback) {
            var self = this;
            var li;
            li = E.li();
            if (callback) {
                li.addEventListener("click", callback);
            }
            self.container.appendChild(li);
            return li;
        };
        if (!Breadcrumbs.prototype.add_crumb.__argnames__) Object.defineProperties(Breadcrumbs.prototype.add_crumb, {
            __argnames__ : {value: ["callback"]},
            __module__ : {value: "widgets"}
        });
        Breadcrumbs.prototype.__repr__ = function __repr__ () {
                        return "<" + __name__ + "." + this.constructor.name + " #" + this.ρσ_object_id + ">";
        };
        Breadcrumbs.prototype.__str__ = function __str__ () {
            return this.__repr__();
        };
        Object.defineProperty(Breadcrumbs.prototype, "__bases__", {value: []});
        Breadcrumbs.prototype.STYLE_RULES = ρσ_interpolate_kwargs.call(this, build_rule, [".calibre-breadcrumbs"].concat([ρσ_desugar_kwargs({user_select: "none", white_space: "nowrap", background_color: get_color("window-background2"), z_index: "-1", border_radius: "10px", margin: "1ex 1em", margin_bottom: "0"})]));
        Breadcrumbs.prototype.STYLE_RULES += ρσ_interpolate_kwargs.call(this, build_rule, [".calibre-breadcrumbs > li"].concat([ρσ_desugar_kwargs({cursor: "pointer", display: "inline-block", line_height: "26px", margin: "0 9px 0 -10px", padding: "0.5ex 1rem", position: "relative"})]));
        Breadcrumbs.prototype.STYLE_RULES += ρσ_interpolate_kwargs.call(this, build_rule, [".calibre-breadcrumbs > li:hover"].concat([ρσ_desugar_kwargs({color: get_color("window-hover-foreground")})]));
        Breadcrumbs.prototype.STYLE_RULES += ρσ_interpolate_kwargs.call(this, build_rule, [".calibre-breadcrumbs > li:active"].concat([ρσ_desugar_kwargs({color: get_color("window-hover-foreground"), transform: "scale(1.5)"})]));
        Breadcrumbs.prototype.STYLE_RULES += ρσ_interpolate_kwargs.call(this, build_rule, [".calibre-breadcrumbs > li:before, .calibre-breadcrumbs > li:after"].concat([ρσ_desugar_kwargs({border_right: "2px solid currentColor", content: "\"\"", display: "block", height: "50%", position: "absolute", left: "0", top: "0", right: "0", transform: "skewX(45deg)"})]));
        Breadcrumbs.prototype.STYLE_RULES += ρσ_interpolate_kwargs.call(this, build_rule, [".calibre-breadcrumbs > li:after"].concat([ρσ_desugar_kwargs({bottom: "0", top: "auto", transform: "skewX(-45deg)"})]));
        Breadcrumbs.prototype.STYLE_RULES += ρσ_interpolate_kwargs.call(this, build_rule, [".calibre-breadcrumbs > li:last-of-type:before, .calibre-breadcrumbs > li:last-of-type:after"].concat([ρσ_desugar_kwargs({display: "none"})]));
        

        function create_tree(root, populate_data, onclick) {
            var container;
            container = ρσ_interpolate_kwargs.call(E, E.div, [ρσ_desugar_kwargs({class_: "simple-tree"})]);
            ρσ_interpolate_kwargs.call(this, set_css, [container].concat([ρσ_desugar_kwargs({overflow: "auto"})]));
            function toggle_node(li) {
                if (li.dataset.treeState === "closed") {
                    li.dataset.treeState = "open";
                    li.lastChild.style.display = "block";
                    change_icon_image(li.firstChild.firstChild, "caret-down");
                } else {
                    li.dataset.treeState = "closed";
                    li.lastChild.style.display = "none";
                    change_icon_image(li.firstChild.firstChild, "caret-right");
                }
            };
            if (!toggle_node.__argnames__) Object.defineProperties(toggle_node, {
                __argnames__ : {value: ["li"]},
                __module__ : {value: "widgets"}
            });

            function bullet(icon) {
                var ans;
                ans = svgicon(icon, "2ex", "2ex");
                ans.style.minWidth = "2ex";
                ans.style.minHeight = "2ex";
                return ans;
            };
            if (!bullet.__argnames__) Object.defineProperties(bullet, {
                __argnames__ : {value: ["icon"]},
                __module__ : {value: "widgets"}
            });

            function process_node(node, parent_container, level) {
                var ul, icon, li, child;
                if (ρσ_exists.d(node.children).length) {
                    ul = E.div();
                    parent_container.appendChild(ul);
                    var ρσ_Iter0 = ρσ_Iterable(node.children);
                    for (var ρσ_Index0 = 0; ρσ_Index0 < ρσ_Iter0.length; ρσ_Index0++) {
                        child = ρσ_Iter0[ρσ_Index0];
                        icon = (ρσ_exists.d(child.children).length) ? "caret-right" : null;
                        li = ρσ_interpolate_kwargs.call(E, E.div, [ρσ_interpolate_kwargs.call(E, E.div, [bullet(icon), E.span(" "), ρσ_interpolate_kwargs.call(E, E.a, [ρσ_desugar_kwargs({href: "javascript: void(0)", class_: "simple-link tree-item-title", onclick: (function() {
                            var ρσ_anonfunc = function (event) {
                                if (onclick) {
                                    if (event.button === 0) {
                                        [event.preventDefault(), event.stopPropagation()];
                                    }
                                    onclick(event, event.currentTarget.parentNode.parentNode);
                                }
                            };
                            if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                                __argnames__ : {value: ["event"]},
                                __module__ : {value: "widgets"}
                            });
                            return ρσ_anonfunc;
                        })()})])].concat([ρσ_desugar_kwargs({style: "display:flex; align-items: center"})])), ρσ_interpolate_kwargs.call(E, E.div, [ρσ_desugar_kwargs({style: "display:none", data_tree_subtree_container: "1"})])].concat([ρσ_desugar_kwargs({style: "display:flex; flex-direction:column; margin: 1ex 1em; margin-left: {}em".format(level + 1), data_tree_state: "closed"})]));
                        ul.appendChild(li);
                        populate_data(child, li, li.firstChild.lastChild);
                        if (icon) {
                            ρσ_interpolate_kwargs.call(this, set_css, [li.firstChild.firstChild].concat([ρσ_desugar_kwargs({cursor: "pointer"})]));
                            li.firstChild.firstChild.addEventListener("click", (function() {
                                var ρσ_anonfunc = function (event) {
                                    toggle_node(event.currentTarget.parentNode.parentNode);
                                };
                                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                                    __argnames__ : {value: ["event"]},
                                    __module__ : {value: "widgets"}
                                });
                                return ρσ_anonfunc;
                            })());
                            process_node(child, li.lastChild, level + 1);
                        }
                    }
                }
            };
            if (!process_node.__argnames__) Object.defineProperties(process_node, {
                __argnames__ : {value: ["node", "parent_container", "level"]},
                __module__ : {value: "widgets"}
            });

            if (root) {
                process_node(root, container, 0);
            }
            return container;
        };
        if (!create_tree.__argnames__) Object.defineProperties(create_tree, {
            __argnames__ : {value: ["root", "populate_data", "onclick"]},
            __module__ : {value: "widgets"}
        });

        function find_text_in_tree(container, q) {
            var last_match, lm, before, seen, ans, a;
            q = q.lower();
            last_match = container.querySelector("a[data-tree-last-match]");
            if (last_match) {
                last_match.parentNode.style.backgroundColor = "transparent";
                last_match.parentNode.style.borderRadius = "0";
                lm = last_match.getAttribute("data-tree-last-match");
                last_match.removeAttribute("data-tree-last-match");
                if (lm !== q) {
                    last_match = null;
                }
            }
            if (!q) {
                return;
            }
            before = ρσ_list_decorate([]);
            seen = false;
            ans = null;
            var ρσ_Iter1 = ρσ_Iterable(container.querySelectorAll("a.tree-item-title"));
            for (var ρσ_Index1 = 0; ρσ_Index1 < ρσ_Iter1.length; ρσ_Index1++) {
                a = ρσ_Iter1[ρσ_Index1];
                if (a === last_match) {
                    seen = true;
                } else {
                    if (ρσ_not_equals(a.textContent.lower().indexOf(q), -1)) {
                        if (seen) {
                            ans = a;
                            break;
                        }
                        if (last_match === null) {
                            ans = a;
                            break;
                        }
                        before.push(a);
                    }
                }
            }
            if (!ans && before.length) {
                ans = before[0];
            }
            ans = ans || last_match;
            if (ans) {
                ans.dataset.treeLastMatch = q;
            }
            if (ans) {
                ans.parentNode.style.backgroundColor = get_color("tree-highlight-item");
                ans.parentNode.style.borderRadius = "5px";
                ans = ans.parentNode.parentNode;
            }
            return ans;
        };
        if (!find_text_in_tree.__argnames__) Object.defineProperties(find_text_in_tree, {
            __argnames__ : {value: ["container", "q"]},
            __module__ : {value: "widgets"}
        });

        function scroll_tree_item_into_view(item) {
            var p;
            p = ρσ_exists.d(item.parentNode).parentNode;
            while (p && p.getAttribute("data-tree-subtree-container")) {
                p.style.display = "block";
                p = ρσ_exists.d(ρσ_exists.d(p.parentNode).parentNode).parentNode;
            }
            item.scrollIntoView();
        };
        if (!scroll_tree_item_into_view.__argnames__) Object.defineProperties(scroll_tree_item_into_view, {
            __argnames__ : {value: ["item"]},
            __module__ : {value: "widgets"}
        });

        add_extra_css((function() {
            var ρσ_anonfunc = function () {
                var ans;
                ans = "a, button:focus { outline: none }; a, button::-moz-focus-inner { border: 0 }\n";
                ans += ".simple-link { cursor: pointer } .simple-link:hover { color: HC } .simple-link:active { transform: scale(1.5) }\n".replace("HC", get_color("window-hover-foreground"));
                ans += ".blue-link { cursor: pointer; color: COL } .blue-link:visited { color: COL} .blue-link:hover { color: HC } .blue-link:active { transform: scale(1.5) }\n".replace("HC", get_color("window-hover-foreground")).replace(/COL/g, get_color("link-foreground"));
                ans += create_button.style + "\n";
                ans += create_button.style + "\n";
                ans += create_spinner.style + "\n";
                ans += Breadcrumbs.prototype.STYLE_RULES + "\n";
                ans += "\n        select, textarea, input[type=\"text\"], input[type=\"password\"],\n        input[type=\"datetime\"], input[type=\"datetime-local\"],\n        input[type=\"date\"], input[type=\"month\"], input[type=\"time\"],\n        input[type=\"week\"], input[type=\"number\"], input[type=\"email\"],\n        input[type=\"url\"], input[type=\"search\"] { font-size: 1em }\n    ";
                return ans;
            };
            if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
                __module__ : {value: "widgets"}
            });
            return ρσ_anonfunc;
        })());
        function enable_escape_key(container, action) {
            container.setAttribute("tabindex", "0");
            container.addEventListener("keydown", (function() {
                var ρσ_anonfunc = function (ev) {
                    if (ev.key === "Escape") {
                        [ev.stopPropagation(), ev.preventDefault()];
                        action();
                    }
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["ev"]},
                    __module__ : {value: "widgets"}
                });
                return ρσ_anonfunc;
            })(), (function(){
                var ρσ_d = Object.create(null);
                ρσ_d["passive"] = false;
                return ρσ_d;
            }).call(this));
            container.focus();
        };
        if (!enable_escape_key.__argnames__) Object.defineProperties(enable_escape_key, {
            __argnames__ : {value: ["container", "action"]},
            __module__ : {value: "widgets"}
        });

        ρσ_modules.widgets.create_button = create_button;
        ρσ_modules.widgets.create_spinner = create_spinner;
        ρσ_modules.widgets.Breadcrumbs = Breadcrumbs;
        ρσ_modules.widgets.create_tree = create_tree;
        ρσ_modules.widgets.find_text_in_tree = find_text_in_tree;
        ρσ_modules.widgets.scroll_tree_item_into_view = scroll_tree_item_into_view;
        ρσ_modules.widgets.enable_escape_key = enable_escape_key;
    })();

    (function(){
        var __name__ = "modals";
        var modal_container, modal_count;
        var E = ρσ_modules.elementmaker.E;

        var _ = ρσ_modules.gettext.gettext;

        var ajax = ρσ_modules.ajax.ajax;
        var ajax_send = ρσ_modules.ajax.ajax_send;

        var get_color = ρσ_modules["book_list.theme"].get_color;
        var get_font_size = ρσ_modules["book_list.theme"].get_font_size;

        var add_extra_css = ρσ_modules.dom.add_extra_css;
        var build_rule = ρσ_modules.dom.build_rule;
        var clear = ρσ_modules.dom.clear;
        var set_css = ρσ_modules.dom.set_css;
        var svgicon = ρσ_modules.dom.svgicon;
        var unique_id = ρσ_modules.dom.unique_id;

        var MODAL_Z_INDEX = ρσ_modules.popups.MODAL_Z_INDEX;

        var safe_set_inner_html = ρσ_modules.utils.safe_set_inner_html;

        var create_button = ρσ_modules.widgets.create_button;

        var get_session_data = ρσ_modules["book_list.globals"].get_session_data;

        modal_container = null;
        modal_count = 0;
        add_extra_css((function() {
            var ρσ_anonfunc = function () {
                var style;
                style = ρσ_interpolate_kwargs.call(this, build_rule, ["#modal-container > div > a:hover"].concat([ρσ_desugar_kwargs({color: get_color("dialog-foreground") + " !important", background_color: get_color("dialog-background") + " !important"})]));
                style += ρσ_interpolate_kwargs.call(this, build_rule, [".button-box"].concat([ρσ_desugar_kwargs({display: "flex", justify_content: "flex-end", padding: "1rem 0rem", overflow: "hidden"})]));
                style += ρσ_interpolate_kwargs.call(this, build_rule, [".button-box .calibre-push-button"].concat([ρσ_desugar_kwargs({transform_origin: "right"})]));
                return style;
            };
            if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
                __module__ : {value: "modals"}
            });
            return ρσ_anonfunc;
        })());
        function Modal() {
            if (this.ρσ_object_id === undefined) Object.defineProperty(this, "ρσ_object_id", {"value":++ρσ_object_counter});
            Modal.prototype.__init__.apply(this, arguments);
        }
        Modal.prototype.__init__ = function __init__(create_func, on_close, show_close, onkeydown) {
            var self = this;
            var ρσ_unpack;
            ρσ_unpack = [create_func, on_close, show_close];
            self.create_func = ρσ_unpack[0];
            self.on_close = ρσ_unpack[1];
            self.show_close = ρσ_unpack[2];
            self.onkeydown = onkeydown;
            modal_count += 1;
            self.id = modal_count;
        };
        if (!Modal.prototype.__init__.__argnames__) Object.defineProperties(Modal.prototype.__init__, {
            __argnames__ : {value: ["create_func", "on_close", "show_close", "onkeydown"]},
            __module__ : {value: "modals"}
        });
        Modal.__argnames__ = Modal.prototype.__init__.__argnames__;
        Modal.__handles_kwarg_interpolation__ = Modal.prototype.__init__.__handles_kwarg_interpolation__;
        Modal.prototype.__repr__ = function __repr__ () {
                        return "<" + __name__ + "." + this.constructor.name + " #" + this.ρσ_object_id + ">";
        };
        Modal.prototype.__str__ = function __str__ () {
            return this.__repr__();
        };
        Object.defineProperty(Modal.prototype, "__bases__", {value: []});

        function ModalContainer() {
            if (this.ρσ_object_id === undefined) Object.defineProperty(this, "ρσ_object_id", {"value":++ρσ_object_counter});
            ModalContainer.prototype.__init__.apply(this, arguments);
        }
        Object.defineProperties(ModalContainer.prototype,  {
            "modal_container": {
                "enumerable": true, 
                "get": function modal_container() {
                    var self = this;
                    return document.getElementById("modal-container");
                }, 
                "set": function () { throw new AttributeError("can't set attribute") }
            }, 
        });
        ModalContainer.prototype.__init__ = function __init__() {
            var self = this;
            var div;
            div = ρσ_interpolate_kwargs.call(E, E.div, [E.div(E.div(), ρσ_interpolate_kwargs.call(E, E.a, [svgicon("close")].concat([ρσ_desugar_kwargs({title: _("Close")})])))].concat([ρσ_desugar_kwargs({id: "modal-container", tabindex: "0"})]));
            div.addEventListener("keydown", self.onkeydown.bind(self), (function(){
                var ρσ_d = Object.create(null);
                ρσ_d["passive"] = false;
                return ρσ_d;
            }).call(this));
            document.body.appendChild(div);
            ρσ_interpolate_kwargs.call(this, set_css, [div].concat([ρσ_desugar_kwargs({position: "fixed", top: "0", right: "0", bottom: "0", left: "0", background_color: "rgba(0,0,0,0.8)", z_index: MODAL_Z_INDEX + "", display: "none", text_align: "center", user_select: "none"})]));
            ρσ_interpolate_kwargs.call(this, set_css, [div.firstChild, get_color("dialog-background"), get_color("dialog-background2")].concat([ρσ_desugar_kwargs({position: "relative", display: "inline-block", top: "50vh", transform: "translateY(-50%)", min_width: "25vw", max_width: "70vw", border_radius: "1em", padding: "1em 2em", margin_right: "1em", margin_left: "1em", background: get_color("dialog-background"), color: get_color("dialog-foreground"), background_image: get_color("dialog-background-image")})]));
            ρσ_interpolate_kwargs.call(this, set_css, [div.firstChild.lastChild].concat([ρσ_desugar_kwargs({font_size: "1.5em", line_height: "100%", cursor: "pointer", position: "absolute", right: "-0.5em", top: "-0.5em", width: "1em", height: "1em", background_color: get_color("window-foreground"), color: get_color("window-background"), display: "inline-box", border_radius: "50%", padding: "4px", text_align: "center", box_shadow: "1px 1px 3px black"})]));
            div.firstChild.lastChild.addEventListener("click", (function() {
                var ρσ_anonfunc = function (event) {
                    [event.preventDefault(), self.close_current_modal(event)];
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["event"]},
                    __module__ : {value: "modals"}
                });
                return ρσ_anonfunc;
            })());
            ρσ_interpolate_kwargs.call(this, set_css, [div.firstChild.firstChild].concat([ρσ_desugar_kwargs({user_select: "text", max_height: "60vh", overflow: "auto", padding: "1px"})]));
            self.modals = [];
            self.current_modal = null;
            self.hide = self.close_current_modal.bind(self);
        };
        if (!ModalContainer.prototype.__init__.__module__) Object.defineProperties(ModalContainer.prototype.__init__, {
            __module__ : {value: "modals"}
        });
        ModalContainer.__argnames__ = ModalContainer.prototype.__init__.__argnames__;
        ModalContainer.__handles_kwarg_interpolation__ = ModalContainer.prototype.__init__.__handles_kwarg_interpolation__;
        ModalContainer.prototype.show_modal = function show_modal() {
            var self = this;
            var create_func = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[0];
            var on_close = (arguments[1] === undefined || ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? show_modal.__defaults__.on_close : arguments[1];
            var show_close = (arguments[2] === undefined || ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? show_modal.__defaults__.show_close : arguments[2];
            var onkeydown = (arguments[3] === undefined || ( 3 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? show_modal.__defaults__.onkeydown : arguments[3];
            var ρσ_kwargs_obj = arguments[arguments.length-1];
            if (ρσ_kwargs_obj === null || typeof ρσ_kwargs_obj !== "object" || ρσ_kwargs_obj [ρσ_kwargs_symbol] !== true) ρσ_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "on_close")){
                on_close = ρσ_kwargs_obj.on_close;
            }
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "show_close")){
                show_close = ρσ_kwargs_obj.show_close;
            }
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "onkeydown")){
                onkeydown = ρσ_kwargs_obj.onkeydown;
            }
            var modal_id;
            self.modals.push(new Modal(create_func, on_close, show_close, onkeydown));
            modal_id = (ρσ_expr_temp = self.modals)[ρσ_expr_temp.length-1].id;
            self.update();
            window.setTimeout((function() {
                var ρσ_anonfunc = function () {
                    self.modal_container.focus();
                };
                if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
                    __module__ : {value: "modals"}
                });
                return ρσ_anonfunc;
            })(), 0);
            return modal_id;
        };
        if (!ModalContainer.prototype.show_modal.__defaults__) Object.defineProperties(ModalContainer.prototype.show_modal, {
            __defaults__ : {value: {on_close:null, show_close:true, onkeydown:null}},
            __handles_kwarg_interpolation__ : {value: true},
            __argnames__ : {value: ["create_func", "on_close", "show_close", "onkeydown"]},
            __module__ : {value: "modals"}
        });
        ModalContainer.prototype.hide_modal = function hide_modal(modal_id) {
            var self = this;
            var doomed_modal, ρσ_unpack, i, modal;
            if (self.current_modal !== null && self.current_modal.id === modal_id) {
                self.clear_current_modal();
            } else {
                doomed_modal = null;
                var ρσ_Iter0 = ρσ_Iterable(enumerate(self.modals));
                for (var ρσ_Index0 = 0; ρσ_Index0 < ρσ_Iter0.length; ρσ_Index0++) {
                    ρσ_unpack = ρσ_Iter0[ρσ_Index0];
                    i = ρσ_unpack[0];
                    modal = ρσ_unpack[1];
                    if (modal.id === modal_id) {
                        doomed_modal = i;
                        break;
                    }
                }
                if (doomed_modal !== null) {
                    self.modals.splice(doomed_modal, 1);
                }
            }
        };
        if (!ModalContainer.prototype.hide_modal.__argnames__) Object.defineProperties(ModalContainer.prototype.hide_modal, {
            __argnames__ : {value: ["modal_id"]},
            __module__ : {value: "modals"}
        });
        ModalContainer.prototype.update = function update() {
            var self = this;
            var c;
            if (self.current_modal === null && self.modals) {
                self.current_modal = self.modals.shift();
                c = self.modal_container;
                try {
                    self.current_modal.create_func(c.firstChild.firstChild, self.hide);
                } catch (ρσ_Exception) {
                    ρσ_last_exception = ρσ_Exception;
                    {
                        self.current_modal = null;
                        throw ρσ_Exception;
                    } 
                }
                if (c.style.display === "none") {
                    ρσ_interpolate_kwargs.call(this, set_css, [c].concat([ρσ_desugar_kwargs({display: "block"})]));
                }
                c.firstChild.lastChild.style.visibility = (self.current_modal.show_close) ? "visible" : "hidden";
            }
        };
        if (!ModalContainer.prototype.update.__module__) Object.defineProperties(ModalContainer.prototype.update, {
            __module__ : {value: "modals"}
        });
        ModalContainer.prototype.clear_current_modal = function clear_current_modal() {
            var self = this;
            var c;
            self.current_modal = null;
            c = self.modal_container;
            clear(c.firstChild.firstChild);
            if (self.modals.length === 0) {
                ρσ_interpolate_kwargs.call(this, set_css, [c].concat([ρσ_desugar_kwargs({display: "none"})]));
            } else {
                self.update();
            }
        };
        if (!ModalContainer.prototype.clear_current_modal.__module__) Object.defineProperties(ModalContainer.prototype.clear_current_modal, {
            __module__ : {value: "modals"}
        });
        ModalContainer.prototype.close_current_modal = function close_current_modal(event) {
            var self = this;
            if (self.current_modal !== null) {
                if (self.current_modal.on_close !== null && self.current_modal.on_close(event) === true) {
                    return;
                }
                self.clear_current_modal();
            }
        };
        if (!ModalContainer.prototype.close_current_modal.__argnames__) Object.defineProperties(ModalContainer.prototype.close_current_modal, {
            __argnames__ : {value: ["event"]},
            __module__ : {value: "modals"}
        });
        ModalContainer.prototype.close_all_modals = function close_all_modals() {
            var self = this;
            while (self.current_modal !== null) {
                self.close_current_modal();
            }
        };
        if (!ModalContainer.prototype.close_all_modals.__module__) Object.defineProperties(ModalContainer.prototype.close_all_modals, {
            __module__ : {value: "modals"}
        });
        ModalContainer.prototype.onkeydown = function onkeydown(event) {
            var self = this;
            if (self.current_modal !== null && self.current_modal.onkeydown) {
                return self.current_modal.onkeydown(event, self.clear_current_modal.bind(self));
            }
            if ((event.key === "Escape" || event.key === "Esc") && !event.altKey && !event.ctrlKey && !event.metaKey && !event.shiftKey) {
                [event.preventDefault(), event.stopPropagation()];
                self.close_current_modal(event);
            }
        };
        if (!ModalContainer.prototype.onkeydown.__argnames__) Object.defineProperties(ModalContainer.prototype.onkeydown, {
            __argnames__ : {value: ["event"]},
            __module__ : {value: "modals"}
        });
        ModalContainer.prototype.__repr__ = function __repr__ () {
                        return "<" + __name__ + "." + this.constructor.name + " #" + this.ρσ_object_id + ">";
        };
        ModalContainer.prototype.__str__ = function __str__ () {
            return this.__repr__();
        };
        Object.defineProperty(ModalContainer.prototype, "__bases__", {value: []});
        

        function create_simple_dialog_markup(title, msg, details, icon, prefix, icon_color, parent) {
            var show_details, is_html_msg, html_container, details_container;
            details = details || "";
            show_details = ρσ_interpolate_kwargs.call(E, E.a, [_("Show details")].concat([ρσ_desugar_kwargs({class_: "blue-link", style: "padding-top:1em; display:inline-block; margin-left: auto"})]));
            show_details.addEventListener("click", (function() {
                var ρσ_anonfunc = function () {
                    show_details.style.display = "none";
                    show_details.nextSibling.style.display = "block";
                };
                if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
                    __module__ : {value: "modals"}
                });
                return ρσ_anonfunc;
            })());
            is_html_msg = /<[a-zA-Z]/.test(msg);
            html_container = E.div();
            if (is_html_msg) {
                safe_set_inner_html(html_container, msg);
            }
            details_container = E.span();
            if (/<[a-zA-Z]/.test(details)) {
                safe_set_inner_html(details_container, details);
            } else {
                details_container.textContent = details;
            }
            if (prefix) {
                prefix = ρσ_interpolate_kwargs.call(E, E.span, [" " + prefix + " "].concat([ρσ_desugar_kwargs({style: "white-space:pre; font-variant: small-caps"})]));
            } else {
                prefix = " ";
            }
            parent.appendChild(ρσ_interpolate_kwargs.call(E, E.div, [ρσ_interpolate_kwargs.call(E, E.h2, [ρσ_interpolate_kwargs.call(E, E.span, [svgicon(icon)].concat([ρσ_desugar_kwargs({style: "color:" + ρσ_str.format("{}", icon_color) + ""})])), prefix, title].concat([ρσ_desugar_kwargs({style: "font-weight: bold; font-size: " + get_font_size("title")})])), ρσ_interpolate_kwargs.call(E, E.div, [(is_html_msg) ? html_container : msg].concat([ρσ_desugar_kwargs({style: "padding-top: 1em; margin-top: 1em; border-top: 1px solid currentColor"})])), ρσ_interpolate_kwargs.call(E, E.div, [show_details, ρσ_interpolate_kwargs.call(E, E.div, [details_container].concat([ρσ_desugar_kwargs({style: "display:none; white-space:pre-wrap; font-size: smaller; margin-top: 1em; border-top: solid 1px currentColor; padding-top: 1em"})]))].concat([ρσ_desugar_kwargs({style: "display: " + ((details) ? "block" : "none")})]))].concat([ρσ_desugar_kwargs({style: "max-width:40em; text-align: left"})])));
        };
        if (!create_simple_dialog_markup.__argnames__) Object.defineProperties(create_simple_dialog_markup, {
            __argnames__ : {value: ["title", "msg", "details", "icon", "prefix", "icon_color", "parent"]},
            __module__ : {value: "modals"}
        });

        function create_simple_dialog() {
            var title = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[0];
            var msg = ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[1];
            var details = ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[2];
            var icon = ( 3 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[3];
            var prefix = ( 4 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[4];
            var on_close = (arguments[5] === undefined || ( 5 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? create_simple_dialog.__defaults__.on_close : arguments[5];
            var icon_color = (arguments[6] === undefined || ( 6 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? create_simple_dialog.__defaults__.icon_color : arguments[6];
            var ρσ_kwargs_obj = arguments[arguments.length-1];
            if (ρσ_kwargs_obj === null || typeof ρσ_kwargs_obj !== "object" || ρσ_kwargs_obj [ρσ_kwargs_symbol] !== true) ρσ_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "on_close")){
                on_close = ρσ_kwargs_obj.on_close;
            }
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "icon_color")){
                icon_color = ρσ_kwargs_obj.icon_color;
            }
            ρσ_interpolate_kwargs.call(this, show_modal, [create_simple_dialog_markup.bind(null, title, msg, details, icon, prefix, icon_color)].concat([ρσ_desugar_kwargs({on_close: on_close})]));
        };
        if (!create_simple_dialog.__defaults__) Object.defineProperties(create_simple_dialog, {
            __defaults__ : {value: {on_close:null, icon_color:"red"}},
            __handles_kwarg_interpolation__ : {value: true},
            __argnames__ : {value: ["title", "msg", "details", "icon", "prefix", "on_close", "icon_color"]},
            __module__ : {value: "modals"}
        });

        function create_custom_dialog() {
            var title = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[0];
            var content_generator_func = ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[1];
            var on_close = (arguments[2] === undefined || ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? create_custom_dialog.__defaults__.on_close : arguments[2];
            var onkeydown = (arguments[3] === undefined || ( 3 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? create_custom_dialog.__defaults__.onkeydown : arguments[3];
            var ρσ_kwargs_obj = arguments[arguments.length-1];
            if (ρσ_kwargs_obj === null || typeof ρσ_kwargs_obj !== "object" || ρσ_kwargs_obj [ρσ_kwargs_symbol] !== true) ρσ_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "on_close")){
                on_close = ρσ_kwargs_obj.on_close;
            }
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "onkeydown")){
                onkeydown = ρσ_kwargs_obj.onkeydown;
            }
            function create_func(parent, close_modal) {
                var content_div;
                content_div = E.div();
                content_generator_func(content_div, close_modal);
                parent.appendChild(ρσ_interpolate_kwargs.call(E, E.div, [ρσ_interpolate_kwargs.call(E, E.h2, [title].concat([ρσ_desugar_kwargs({style: "font-weight: bold; font-size: " + get_font_size("title")})])), ρσ_interpolate_kwargs.call(E, E.div, [content_div].concat([ρσ_desugar_kwargs({style: "padding-top: 1em; margin-top: 1em; border-top: 1px solid currentColor"})]))].concat([ρσ_desugar_kwargs({style: "max-width:60em; text-align: left"})])));
            };
            if (!create_func.__argnames__) Object.defineProperties(create_func, {
                __argnames__ : {value: ["parent", "close_modal"]},
                __module__ : {value: "modals"}
            });

            ρσ_interpolate_kwargs.call(this, show_modal, [create_func].concat([ρσ_desugar_kwargs({on_close: on_close, onkeydown: onkeydown})]));
        };
        if (!create_custom_dialog.__defaults__) Object.defineProperties(create_custom_dialog, {
            __defaults__ : {value: {on_close:null, onkeydown:null}},
            __handles_kwarg_interpolation__ : {value: true},
            __argnames__ : {value: ["title", "content_generator_func", "on_close", "onkeydown"]},
            __module__ : {value: "modals"}
        });

        function get_text_dialog() {
            var title = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[0];
            var callback = ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[1];
            var initial_text = (arguments[2] === undefined || ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? get_text_dialog.__defaults__.initial_text : arguments[2];
            var msg = (arguments[3] === undefined || ( 3 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? get_text_dialog.__defaults__.msg : arguments[3];
            var rows = (arguments[4] === undefined || ( 4 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? get_text_dialog.__defaults__.rows : arguments[4];
            var ρσ_kwargs_obj = arguments[arguments.length-1];
            if (ρσ_kwargs_obj === null || typeof ρσ_kwargs_obj !== "object" || ρσ_kwargs_obj [ρσ_kwargs_symbol] !== true) ρσ_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "initial_text")){
                initial_text = ρσ_kwargs_obj.initial_text;
            }
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "msg")){
                msg = ρσ_kwargs_obj.msg;
            }
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "rows")){
                rows = ρσ_kwargs_obj.rows;
            }
            var called, cid;
            called = Object.create(null);
            cid = unique_id();
            function keyaction(ok, close_modal) {
                var text;
                if (called.done) {
                    return;
                }
                called.done = true;
                text = document.getElementById(cid).value || "";
                if (close_modal) {
                    close_modal();
                }
                callback(ok, text);
            };
            if (!keyaction.__argnames__) Object.defineProperties(keyaction, {
                __argnames__ : {value: ["ok", "close_modal"]},
                __module__ : {value: "modals"}
            });

            function on_keydown(event, close_modal) {
                if (event.altKey || event.ctrlKey || event.metaKey || event.shiftKey) {
                    return;
                }
                if (event.key === "Escape" || event.key === "Esc") {
                    [event.preventDefault(), event.stopPropagation()];
                    keyaction(false, close_modal);
                }
            };
            if (!on_keydown.__argnames__) Object.defineProperties(on_keydown, {
                __argnames__ : {value: ["event", "close_modal"]},
                __module__ : {value: "modals"}
            });

            ρσ_interpolate_kwargs.call(this, create_custom_dialog, [title, (function() {
                var ρσ_anonfunc = function (parent, close_modal) {
                    parent.appendChild(E.div(ρσ_interpolate_kwargs.call(E, E.textarea, [initial_text || ""].concat([ρσ_desugar_kwargs({placeholder: msg || "", id: cid, rows: rows + "", style: "min-width: min(40rem, 60vw)"})])), ρσ_interpolate_kwargs.call(E, E.div, [ρσ_interpolate_kwargs.call(this, create_button, [_("OK"), "check", keyaction.bind(null, true, close_modal)].concat([ρσ_desugar_kwargs({highlight: true})])), " ", create_button(_("Cancel"), "close", keyaction.bind(null, false, close_modal))].concat([ρσ_desugar_kwargs({class_: "button-box"})]))));
                    window.setTimeout((function() {
                        var ρσ_anonfunc = function () {
                            parent.querySelector("textarea").focus();
                        };
                        if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
                            __module__ : {value: "modals"}
                        });
                        return ρσ_anonfunc;
                    })(), 10);
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["parent", "close_modal"]},
                    __module__ : {value: "modals"}
                });
                return ρσ_anonfunc;
            })()].concat([ρσ_desugar_kwargs({on_close: keyaction.bind(null, false, null), onkeydown: on_keydown})]));
        };
        if (!get_text_dialog.__defaults__) Object.defineProperties(get_text_dialog, {
            __defaults__ : {value: {initial_text:null, msg:null, rows:12}},
            __handles_kwarg_interpolation__ : {value: true},
            __argnames__ : {value: ["title", "callback", "initial_text", "msg", "rows"]},
            __module__ : {value: "modals"}
        });

        function question_dialog() {
            var title = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[0];
            var msg = ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[1];
            var callback = ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[2];
            var yes_text = (arguments[3] === undefined || ( 3 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? question_dialog.__defaults__.yes_text : arguments[3];
            var no_text = (arguments[4] === undefined || ( 4 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? question_dialog.__defaults__.no_text : arguments[4];
            var skip_dialog_name = (arguments[5] === undefined || ( 5 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? question_dialog.__defaults__.skip_dialog_name : arguments[5];
            var skip_dialog_msg = (arguments[6] === undefined || ( 6 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? question_dialog.__defaults__.skip_dialog_msg : arguments[6];
            var skip_dialog_skipped_value = (arguments[7] === undefined || ( 7 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? question_dialog.__defaults__.skip_dialog_skipped_value : arguments[7];
            var skip_dialog_skip_precheck = (arguments[8] === undefined || ( 8 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? question_dialog.__defaults__.skip_dialog_skip_precheck : arguments[8];
            var ρσ_kwargs_obj = arguments[arguments.length-1];
            if (ρσ_kwargs_obj === null || typeof ρσ_kwargs_obj !== "object" || ρσ_kwargs_obj [ρσ_kwargs_symbol] !== true) ρσ_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "yes_text")){
                yes_text = ρσ_kwargs_obj.yes_text;
            }
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "no_text")){
                no_text = ρσ_kwargs_obj.no_text;
            }
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "skip_dialog_name")){
                skip_dialog_name = ρσ_kwargs_obj.skip_dialog_name;
            }
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "skip_dialog_msg")){
                skip_dialog_msg = ρσ_kwargs_obj.skip_dialog_msg;
            }
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "skip_dialog_skipped_value")){
                skip_dialog_skipped_value = ρσ_kwargs_obj.skip_dialog_skipped_value;
            }
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "skip_dialog_skip_precheck")){
                skip_dialog_skip_precheck = ρσ_kwargs_obj.skip_dialog_skip_precheck;
            }
            var called, skip_box, sd, skipped_dialogs;
            yes_text = yes_text || _("Yes");
            no_text = no_text || _("No");
            called = Object.create(null);
            function keyaction(yes, close_modal) {
                var sd, skipped_dialogs;
                if (called.done) {
                    return;
                }
                called.done = true;
                if (skip_dialog_name) {
                    if (!skip_box.querySelector("input").checked) {
                        sd = get_session_data();
                        skipped_dialogs = Object.assign({}, sd.get("skipped_dialogs", {}));
                        skipped_dialogs[(typeof skip_dialog_name === "number" && skip_dialog_name < 0) ? skipped_dialogs.length + skip_dialog_name : skip_dialog_name] = (new Date).toISOString();
                        sd.set("skipped_dialogs", skipped_dialogs);
                    }
                }
                if (close_modal) {
                    close_modal();
                }
                callback(yes);
            };
            if (!keyaction.__argnames__) Object.defineProperties(keyaction, {
                __argnames__ : {value: ["yes", "close_modal"]},
                __module__ : {value: "modals"}
            });

            function on_keydown(event, close_modal) {
                if (event.altKey || event.ctrlKey || event.metaKey || event.shiftKey) {
                    return;
                }
                if (event.key === "Escape" || event.key === "Esc") {
                    [event.preventDefault(), event.stopPropagation()];
                    keyaction(false, close_modal);
                }
                if (event.key === "Enter" || event.key === "Return" || event.key === "Space") {
                    [event.preventDefault(), event.stopPropagation()];
                    keyaction(true, close_modal);
                }
            };
            if (!on_keydown.__argnames__) Object.defineProperties(on_keydown, {
                __argnames__ : {value: ["event", "close_modal"]},
                __module__ : {value: "modals"}
            });

            skip_box = ρσ_interpolate_kwargs.call(E, E.div, [ρσ_desugar_kwargs({style: "margin-top: 2ex;"})]);
            if (skip_dialog_name) {
                sd = get_session_data();
                skipped_dialogs = sd.get("skipped_dialogs", {});
                if (skipped_dialogs[(typeof skip_dialog_name === "number" && skip_dialog_name < 0) ? skipped_dialogs.length + skip_dialog_name : skip_dialog_name]) {
                    return callback(skip_dialog_skipped_value);
                }
                skip_dialog_msg = skip_dialog_msg || _("Show this confirmation again");
                skip_box.appendChild(E.label(ρσ_interpolate_kwargs.call(E, E.input, [ρσ_desugar_kwargs({type: "checkbox", name: "skip_dialog"})]), " ", skip_dialog_msg));
                if (skip_dialog_skip_precheck) {
                    skip_box.querySelector("input").checked = true;
                }
            } else {
                skip_box.style.display = "none";
            }
            ρσ_interpolate_kwargs.call(this, create_custom_dialog, [title, (function() {
                var ρσ_anonfunc = function (parent, close_modal) {
                    parent.appendChild(E.div(E.div(msg), skip_box, ρσ_interpolate_kwargs.call(E, E.div, [ρσ_interpolate_kwargs.call(this, create_button, [yes_text, "check", keyaction.bind(null, true, close_modal)].concat([ρσ_desugar_kwargs({highlight: true})])), " ", create_button(no_text, "close", keyaction.bind(null, false, close_modal))].concat([ρσ_desugar_kwargs({class_: "button-box"})]))));
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["parent", "close_modal"]},
                    __module__ : {value: "modals"}
                });
                return ρσ_anonfunc;
            })()].concat([ρσ_desugar_kwargs({on_close: keyaction.bind(null, false, null), onkeydown: on_keydown})]));
        };
        if (!question_dialog.__defaults__) Object.defineProperties(question_dialog, {
            __defaults__ : {value: {yes_text:null, no_text:null, skip_dialog_name:null, skip_dialog_msg:null, skip_dialog_skipped_value:true, skip_dialog_skip_precheck:true}},
            __handles_kwarg_interpolation__ : {value: true},
            __argnames__ : {value: ["title", "msg", "callback", "yes_text", "no_text", "skip_dialog_name", "skip_dialog_msg", "skip_dialog_skipped_value", "skip_dialog_skip_precheck"]},
            __module__ : {value: "modals"}
        });

        function create_progress_dialog(msg, on_close) {
            var ρσ_unpack, pbar, msg_div, show_close, modal_id;
            msg = msg || _("Loading, please wait...");
            ρσ_unpack = [ρσ_interpolate_kwargs.call(E, E.progress, [ρσ_desugar_kwargs({style: "display:inline-block"})]), 
            ρσ_interpolate_kwargs.call(E, E.div, [msg].concat([ρσ_desugar_kwargs({style: "text-align:center; padding-top:1ex"})]))];
            pbar = ρσ_unpack[0];
            msg_div = ρσ_unpack[1];
            function create_func(parent) {
                parent.appendChild(ρσ_interpolate_kwargs.call(E, E.div, [pbar, msg_div].concat([ρσ_desugar_kwargs({style: "text-align: center"})])));
            };
            if (!create_func.__argnames__) Object.defineProperties(create_func, {
                __argnames__ : {value: ["parent"]},
                __module__ : {value: "modals"}
            });

            show_close = on_close !== null;
            modal_id = show_modal(create_func, on_close, show_close);
            return (function(){
                var ρσ_d = Object.create(null);
                ρσ_d["close"] = (function() {
                    var ρσ_anonfunc = function () {
                        modal_container.hide_modal(modal_id);
                    };
                    if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
                        __module__ : {value: "modals"}
                    });
                    return ρσ_anonfunc;
                })();
                ρσ_d["update_progress"] = (function() {
                    var ρσ_anonfunc = function (amount, total) {
                        var ρσ_unpack;
                        ρσ_unpack = [total, amount];
                        pbar.max = ρσ_unpack[0];
                        pbar.value = ρσ_unpack[1];
                    };
                    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                        __argnames__ : {value: ["amount", "total"]},
                        __module__ : {value: "modals"}
                    });
                    return ρσ_anonfunc;
                })();
                ρσ_d["set_msg"] = (function() {
                    var ρσ_anonfunc = function (new_msg) {
                        safe_set_inner_html(msg_div, new_msg);
                    };
                    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                        __argnames__ : {value: ["new_msg"]},
                        __module__ : {value: "modals"}
                    });
                    return ρσ_anonfunc;
                })();
                return ρσ_d;
            }).call(this);
        };
        if (!create_progress_dialog.__argnames__) Object.defineProperties(create_progress_dialog, {
            __argnames__ : {value: ["msg", "on_close"]},
            __module__ : {value: "modals"}
        });

        function create_modal_container() {
            if (modal_container === null) {
                modal_container = new ModalContainer;
            }
            return modal_container;
        };
        if (!create_modal_container.__module__) Object.defineProperties(create_modal_container, {
            __module__ : {value: "modals"}
        });

        function show_modal() {
            var create_func = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[0];
            var on_close = (arguments[1] === undefined || ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? show_modal.__defaults__.on_close : arguments[1];
            var show_close = (arguments[2] === undefined || ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? show_modal.__defaults__.show_close : arguments[2];
            var onkeydown = (arguments[3] === undefined || ( 3 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? show_modal.__defaults__.onkeydown : arguments[3];
            var ρσ_kwargs_obj = arguments[arguments.length-1];
            if (ρσ_kwargs_obj === null || typeof ρσ_kwargs_obj !== "object" || ρσ_kwargs_obj [ρσ_kwargs_symbol] !== true) ρσ_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "on_close")){
                on_close = ρσ_kwargs_obj.on_close;
            }
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "show_close")){
                show_close = ρσ_kwargs_obj.show_close;
            }
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "onkeydown")){
                onkeydown = ρσ_kwargs_obj.onkeydown;
            }
            return modal_container.show_modal(create_func, on_close, show_close, onkeydown);
        };
        if (!show_modal.__defaults__) Object.defineProperties(show_modal, {
            __defaults__ : {value: {on_close:null, show_close:true, onkeydown:null}},
            __handles_kwarg_interpolation__ : {value: true},
            __argnames__ : {value: ["create_func", "on_close", "show_close", "onkeydown"]},
            __module__ : {value: "modals"}
        });

        function close_all_modals() {
            return modal_container.close_all_modals();
        };
        if (!close_all_modals.__module__) Object.defineProperties(close_all_modals, {
            __module__ : {value: "modals"}
        });

        function error_dialog() {
            var title = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[0];
            var msg = ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[1];
            var details = (arguments[2] === undefined || ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? error_dialog.__defaults__.details : arguments[2];
            var on_close = (arguments[3] === undefined || ( 3 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? error_dialog.__defaults__.on_close : arguments[3];
            var ρσ_kwargs_obj = arguments[arguments.length-1];
            if (ρσ_kwargs_obj === null || typeof ρσ_kwargs_obj !== "object" || ρσ_kwargs_obj [ρσ_kwargs_symbol] !== true) ρσ_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "details")){
                details = ρσ_kwargs_obj.details;
            }
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "on_close")){
                on_close = ρσ_kwargs_obj.on_close;
            }
            create_simple_dialog(title, msg, details, "bug", _("Error:"), on_close);
        };
        if (!error_dialog.__defaults__) Object.defineProperties(error_dialog, {
            __defaults__ : {value: {details:null, on_close:null}},
            __handles_kwarg_interpolation__ : {value: true},
            __argnames__ : {value: ["title", "msg", "details", "on_close"]},
            __module__ : {value: "modals"}
        });

        function warning_dialog() {
            var title = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[0];
            var msg = ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[1];
            var details = (arguments[2] === undefined || ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? warning_dialog.__defaults__.details : arguments[2];
            var on_close = (arguments[3] === undefined || ( 3 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? warning_dialog.__defaults__.on_close : arguments[3];
            var ρσ_kwargs_obj = arguments[arguments.length-1];
            if (ρσ_kwargs_obj === null || typeof ρσ_kwargs_obj !== "object" || ρσ_kwargs_obj [ρσ_kwargs_symbol] !== true) ρσ_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "details")){
                details = ρσ_kwargs_obj.details;
            }
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "on_close")){
                on_close = ρσ_kwargs_obj.on_close;
            }
            create_simple_dialog(title, msg, details, "warning", _("Warning:"), on_close);
        };
        if (!warning_dialog.__defaults__) Object.defineProperties(warning_dialog, {
            __defaults__ : {value: {details:null, on_close:null}},
            __handles_kwarg_interpolation__ : {value: true},
            __argnames__ : {value: ["title", "msg", "details", "on_close"]},
            __module__ : {value: "modals"}
        });

        function info_dialog() {
            var title = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[0];
            var msg = ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[1];
            var details = (arguments[2] === undefined || ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? info_dialog.__defaults__.details : arguments[2];
            var on_close = (arguments[3] === undefined || ( 3 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? info_dialog.__defaults__.on_close : arguments[3];
            var ρσ_kwargs_obj = arguments[arguments.length-1];
            if (ρσ_kwargs_obj === null || typeof ρσ_kwargs_obj !== "object" || ρσ_kwargs_obj [ρσ_kwargs_symbol] !== true) ρσ_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "details")){
                details = ρσ_kwargs_obj.details;
            }
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "on_close")){
                on_close = ρσ_kwargs_obj.on_close;
            }
            ρσ_interpolate_kwargs.call(this, create_simple_dialog, [title, msg, details, "check", "", on_close].concat([ρσ_desugar_kwargs({icon_color: "green"})]));
        };
        if (!info_dialog.__defaults__) Object.defineProperties(info_dialog, {
            __defaults__ : {value: {details:null, on_close:null}},
            __handles_kwarg_interpolation__ : {value: true},
            __argnames__ : {value: ["title", "msg", "details", "on_close"]},
            __module__ : {value: "modals"}
        });

        function progress_dialog() {
            var msg = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[0];
            var on_close = (arguments[1] === undefined || ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? progress_dialog.__defaults__.on_close : arguments[1];
            var ρσ_kwargs_obj = arguments[arguments.length-1];
            if (ρσ_kwargs_obj === null || typeof ρσ_kwargs_obj !== "object" || ρσ_kwargs_obj [ρσ_kwargs_symbol] !== true) ρσ_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "on_close")){
                on_close = ρσ_kwargs_obj.on_close;
            }
            return create_progress_dialog(msg, on_close);
        };
        if (!progress_dialog.__defaults__) Object.defineProperties(progress_dialog, {
            __defaults__ : {value: {on_close:null}},
            __handles_kwarg_interpolation__ : {value: true},
            __argnames__ : {value: ["msg", "on_close"]},
            __module__ : {value: "modals"}
        });

        function ajax_progress_dialog() {
            var path = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[0];
            var on_complete = ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[1];
            var msg = ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[2];
            var extra_data_for_callback = (arguments[3] === undefined || ( 3 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? ajax_progress_dialog.__defaults__.extra_data_for_callback : arguments[3];
            var kw = arguments[arguments.length-1];
            if (kw === null || typeof kw !== "object" || kw [ρσ_kwargs_symbol] !== true) kw = {};
            if (Object.prototype.hasOwnProperty.call(kw, "extra_data_for_callback")){
                extra_data_for_callback = kw.extra_data_for_callback;
                delete kw.extra_data_for_callback;
            }
            var pd, xhr;
            pd = null;
            function on_complete_callback(event_type, xhr, ev) {
                pd.close();
                pd = undefined;
                return on_complete(event_type, xhr, ev);
            };
            if (!on_complete_callback.__argnames__) Object.defineProperties(on_complete_callback, {
                __argnames__ : {value: ["event_type", "xhr", "ev"]},
                __module__ : {value: "modals"}
            });

            function on_progress_callback(loaded, total, xhr) {
                pd.update_progress(loaded, total);
            };
            if (!on_progress_callback.__argnames__) Object.defineProperties(on_progress_callback, {
                __argnames__ : {value: ["loaded", "total", "xhr"]},
                __module__ : {value: "modals"}
            });

            xhr = ρσ_interpolate_kwargs.call(this, ajax, [path, on_complete_callback].concat([ρσ_desugar_kwargs(kw, {on_progress: on_progress_callback})]));
            xhr.extra_data_for_callback = extra_data_for_callback;
            pd = progress_dialog(msg, xhr.abort.bind(xhr));
            xhr.send();
            return [xhr, pd];
        };
        if (!ajax_progress_dialog.__defaults__) Object.defineProperties(ajax_progress_dialog, {
            __defaults__ : {value: {extra_data_for_callback:null}},
            __handles_kwarg_interpolation__ : {value: true},
            __argnames__ : {value: ["path", "on_complete", "msg", "extra_data_for_callback"]},
            __module__ : {value: "modals"}
        });

        function ajax_send_progress_dialog() {
            var path = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[0];
            var data = ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[1];
            var on_complete = ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[2];
            var msg = ( 3 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[3];
            var kw = arguments[arguments.length-1];
            if (kw === null || typeof kw !== "object" || kw [ρσ_kwargs_symbol] !== true) kw = {};
            var pd, xhr;
            pd = null;
            function on_complete_callback(event_type, xhr, ev) {
                pd.close();
                pd = undefined;
                return on_complete(event_type, xhr, ev);
            };
            if (!on_complete_callback.__argnames__) Object.defineProperties(on_complete_callback, {
                __argnames__ : {value: ["event_type", "xhr", "ev"]},
                __module__ : {value: "modals"}
            });

            function on_progress_callback(loaded, total, xhr) {
                pd.update_progress(loaded, total);
            };
            if (!on_progress_callback.__argnames__) Object.defineProperties(on_progress_callback, {
                __argnames__ : {value: ["loaded", "total", "xhr"]},
                __module__ : {value: "modals"}
            });

            xhr = ρσ_interpolate_kwargs.call(this, ajax_send, [path, data, on_complete_callback].concat([ρσ_desugar_kwargs(kw, {on_progress: on_progress_callback})]));
            pd = progress_dialog(msg, xhr.abort.bind(xhr));
            return [xhr, pd];
        };
        if (!ajax_send_progress_dialog.__handles_kwarg_interpolation__) Object.defineProperties(ajax_send_progress_dialog, {
            __handles_kwarg_interpolation__ : {value: true},
            __argnames__ : {value: ["path", "data", "on_complete", "msg"]},
            __module__ : {value: "modals"}
        });

        ρσ_modules.modals.modal_container = modal_container;
        ρσ_modules.modals.modal_count = modal_count;
        ρσ_modules.modals.Modal = Modal;
        ρσ_modules.modals.ModalContainer = ModalContainer;
        ρσ_modules.modals.create_simple_dialog_markup = create_simple_dialog_markup;
        ρσ_modules.modals.create_simple_dialog = create_simple_dialog;
        ρσ_modules.modals.create_custom_dialog = create_custom_dialog;
        ρσ_modules.modals.get_text_dialog = get_text_dialog;
        ρσ_modules.modals.question_dialog = question_dialog;
        ρσ_modules.modals.create_progress_dialog = create_progress_dialog;
        ρσ_modules.modals.create_modal_container = create_modal_container;
        ρσ_modules.modals.show_modal = show_modal;
        ρσ_modules.modals.close_all_modals = close_all_modals;
        ρσ_modules.modals.error_dialog = error_dialog;
        ρσ_modules.modals.warning_dialog = warning_dialog;
        ρσ_modules.modals.info_dialog = info_dialog;
        ρσ_modules.modals.progress_dialog = progress_dialog;
        ρσ_modules.modals.ajax_progress_dialog = ajax_progress_dialog;
        ρσ_modules.modals.ajax_send_progress_dialog = ajax_send_progress_dialog;
    })();

    (function(){
        var __name__ = "qt";
        var special_title, slots, to_python;
        special_title = "__webengine_messages_pending__";
        slots = Object.create(null);
        function ping(suffix) {
            document.title = special_title + suffix;
        };
        if (!ping.__argnames__) Object.defineProperties(ping, {
            __argnames__ : {value: ["suffix"]},
            __module__ : {value: "qt"}
        });

        function signal() {
            var args;
            args = Array.from(arguments);
            to_python._queue_message((function(){
                var ρσ_d = Object.create(null);
                ρσ_d["type"] = "signal";
                ρσ_d["name"] = this;
                ρσ_d["args"] = args;
                return ρσ_d;
            }).call(this));
        };
        if (!signal.__module__) Object.defineProperties(signal, {
            __module__ : {value: "qt"}
        });

        function ToPython() {
            if (this.ρσ_object_id === undefined) Object.defineProperty(this, "ρσ_object_id", {"value":++ρσ_object_counter});
            ToPython.prototype.__bind_methods__.call(this);
            ToPython.prototype.__init__.apply(this, arguments);
        }
        Object.defineProperty(ToPython.prototype, "__bind_methods__", {value: function () {
            this._ping = ToPython.prototype._ping.bind(this);
            this._queue_message = ToPython.prototype._queue_message.bind(this);
            this._register_signals = ToPython.prototype._register_signals.bind(this);
            this._poll = ToPython.prototype._poll.bind(this);
            this._from_python = ToPython.prototype._from_python.bind(this);
        }});
        ToPython.prototype.__init__ = function __init__() {
            var self = this;
            self._messages = [];
            self._last_ping_value = 0;
            self._ping_timer_id = -1;
            self._queue_message((function(){
                var ρσ_d = Object.create(null);
                ρσ_d["type"] = "qt-ready";
                return ρσ_d;
            }).call(this));
        };
        if (!ToPython.prototype.__init__.__module__) Object.defineProperties(ToPython.prototype.__init__, {
            __module__ : {value: "qt"}
        });
        ToPython.__argnames__ = ToPython.prototype.__init__.__argnames__;
        ToPython.__handles_kwarg_interpolation__ = ToPython.prototype.__init__.__handles_kwarg_interpolation__;
        ToPython.prototype._ping = function _ping() {
            var self = this;
            if (self._ping_timer_id < 0) {
                self._last_ping_value = (self._last_ping_value) ? 0 : 1;
                self._ping_timer_id = setTimeout((function() {
                    var ρσ_anonfunc = function () {
                        ping(self._last_ping_value);
                        self._ping_timer_id = -1;
                    };
                    if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
                        __module__ : {value: "qt"}
                    });
                    return ρσ_anonfunc;
                })(), 0);
            }
        };
        if (!ToPython.prototype._ping.__module__) Object.defineProperties(ToPython.prototype._ping, {
            __module__ : {value: "qt"}
        });
        ToPython.prototype._queue_message = function _queue_message(msg) {
            var self = this;
            self._messages.push(msg);
            self._ping();
        };
        if (!ToPython.prototype._queue_message.__argnames__) Object.defineProperties(ToPython.prototype._queue_message, {
            __argnames__ : {value: ["msg"]},
            __module__ : {value: "qt"}
        });
        ToPython.prototype._register_signals = function _register_signals(signals) {
            var self = this;
            var signal_name;
            var ρσ_Iter0 = ρσ_Iterable(signals);
            for (var ρσ_Index0 = 0; ρσ_Index0 < ρσ_Iter0.length; ρσ_Index0++) {
                signal_name = ρσ_Iter0[ρσ_Index0];
                self[(typeof signal_name === "number" && signal_name < 0) ? self.length + signal_name : signal_name] = signal.bind(signal_name);
            }
        };
        if (!ToPython.prototype._register_signals.__argnames__) Object.defineProperties(ToPython.prototype._register_signals, {
            __argnames__ : {value: ["signals"]},
            __module__ : {value: "qt"}
        });
        ToPython.prototype._poll = function _poll() {
            var self = this;
            var ans;
            ans = self._messages;
            self._messages = [];
            return ans;
        };
        if (!ToPython.prototype._poll.__module__) Object.defineProperties(ToPython.prototype._poll, {
            __module__ : {value: "qt"}
        });
        ToPython.prototype._from_python = function _from_python(name, args) {
            var self = this;
            var callback;
            callback = slots[(typeof name === "number" && name < 0) ? slots.length + name : name];
            if (callback) {
                callback.apply(null, args);
            } else {
                console.warn("Attempt to call non-existent python-to-js slot named: " + ρσ_str.format("{}", name) + "");
            }
        };
        if (!ToPython.prototype._from_python.__argnames__) Object.defineProperties(ToPython.prototype._from_python, {
            __argnames__ : {value: ["name", "args"]},
            __module__ : {value: "qt"}
        });
        ToPython.prototype.__repr__ = function __repr__ () {
                        return "<" + __name__ + "." + this.constructor.name + " #" + this.ρσ_object_id + ">";
        };
        ToPython.prototype.__str__ = function __str__ () {
            return this.__repr__();
        };
        Object.defineProperty(ToPython.prototype, "__bases__", {value: []});

        to_python = null;
        if (window === window.top) {
            window.python_comm = to_python = new ToPython;
        }
        function from_python(func) {
            slots[ρσ_bound_index(func.name, slots)] = func;
        };
        if (!from_python.__argnames__) Object.defineProperties(from_python, {
            __argnames__ : {value: ["func"]},
            __module__ : {value: "qt"}
        });

        ρσ_modules.qt.special_title = special_title;
        ρσ_modules.qt.slots = slots;
        ρσ_modules.qt.to_python = to_python;
        ρσ_modules.qt.ping = ping;
        ρσ_modules.qt.signal = signal;
        ρσ_modules.qt.ToPython = ToPython;
        ρσ_modules.qt.from_python = from_python;
    })();

    (function(){
        var __name__ = "read_book";

    })();

    (function(){
        var __name__ = "book_list.constants";
        var book_list_container_id, read_book_container_id, INIT_ENDPOINT;
        book_list_container_id = "book-list-container";
        read_book_container_id = "read-book-container";
        INIT_ENDPOINT = "interface-data/init";
        ρσ_modules["book_list.constants"].book_list_container_id = book_list_container_id;
        ρσ_modules["book_list.constants"].read_book_container_id = read_book_container_id;
        ρσ_modules["book_list.constants"].INIT_ENDPOINT = INIT_ENDPOINT;
    })();

    (function(){
        var __name__ = "book_list.router";
        var mode_handlers, default_mode_handler, read_book_mode;
        var absolute_path = ρσ_modules.ajax.absolute_path;
        var encode_query = ρσ_modules.ajax.encode_query;

        var E = ρσ_modules.elementmaker.E;

        var _ = ρσ_modules.gettext.gettext;

        var book_list_container_id = ρσ_modules["book_list.constants"].book_list_container_id;
        var read_book_container_id = ρσ_modules["book_list.constants"].read_book_container_id;

        var get_current_query = ρσ_modules["book_list.globals"].get_current_query;
        var get_session_data = ρσ_modules["book_list.globals"].get_session_data;

        var current_library_id = ρσ_modules["book_list.library_data"].current_library_id;

        var close_all_modals = ρσ_modules.modals.close_all_modals;

        var encode_query_with_path = ρσ_modules.utils.encode_query_with_path;
        var parse_url_params = ρσ_modules.utils.parse_url_params;
        var request_full_screen = ρσ_modules.utils.request_full_screen;
        var safe_set_inner_html = ρσ_modules.utils.safe_set_inner_html;

        mode_handlers = Object.create(null);
        default_mode_handler = null;
        read_book_mode = "read_book";
        function set_mode_handler(mode, handler) {
            mode_handlers[(typeof mode === "number" && mode < 0) ? mode_handlers.length + mode : mode] = handler;
        };
        if (!set_mode_handler.__argnames__) Object.defineProperties(set_mode_handler, {
            __argnames__ : {value: ["mode", "handler"]},
            __module__ : {value: "book_list.router"}
        });

        function set_default_mode_handler(handler) {
            default_mode_handler = handler;
        };
        if (!set_default_mode_handler.__argnames__) Object.defineProperties(set_default_mode_handler, {
            __argnames__ : {value: ["handler"]},
            __module__ : {value: "book_list.router"}
        });

        function update_window_title() {
            var subtitle = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[0];
            var title = (arguments[1] === undefined || ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? update_window_title.__defaults__.title : arguments[1];
            var sep = (arguments[2] === undefined || ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? update_window_title.__defaults__.sep : arguments[2];
            var ρσ_kwargs_obj = arguments[arguments.length-1];
            if (ρσ_kwargs_obj === null || typeof ρσ_kwargs_obj !== "object" || ρσ_kwargs_obj [ρσ_kwargs_symbol] !== true) ρσ_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "title")){
                title = ρσ_kwargs_obj.title;
            }
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "sep")){
                sep = ρσ_kwargs_obj.sep;
            }
            var extra;
            extra = (subtitle) ? sep + subtitle : "";
            document.title = title + extra;
        };
        if (!update_window_title.__defaults__) Object.defineProperties(update_window_title, {
            __defaults__ : {value: {title:"calibre", sep:" :: "}},
            __handles_kwarg_interpolation__ : {value: true},
            __argnames__ : {value: ["subtitle", "title", "sep"]},
            __module__ : {value: "book_list.router"}
        });

        function is_reading_book() {
            var cq;
            cq = get_current_query();
            return cq && cq.mode === read_book_mode;
        };
        if (!is_reading_book.__module__) Object.defineProperties(is_reading_book, {
            __module__ : {value: "book_list.router"}
        });

        function apply_mode() {
            var divid, div;
            divid = (is_reading_book()) ? read_book_container_id : book_list_container_id;
            var ρσ_Iter0 = ρσ_Iterable(document.getElementById(divid).parentNode.childNodes);
            for (var ρσ_Index0 = 0; ρσ_Index0 < ρσ_Iter0.length; ρσ_Index0++) {
                div = ρσ_Iter0[ρσ_Index0];
                div.style.display = (div.id === divid) ? "block" : "none";
            }
        };
        if (!apply_mode.__module__) Object.defineProperties(apply_mode, {
            __module__ : {value: "book_list.router"}
        });

        function apply_url(ignore_handler) {
            var data, handler;
            close_all_modals();
            data = parse_url_params();
            data.mode = data.mode || "book_list";
            get_current_query(data);
            apply_mode();
            if (!ignore_handler) {
                handler = mode_handlers[ρσ_bound_index(data.mode, mode_handlers)] || default_mode_handler;
                handler(data);
            }
        };
        if (!apply_url.__argnames__) Object.defineProperties(apply_url, {
            __argnames__ : {value: ["ignore_handler"]},
            __module__ : {value: "book_list.router"}
        });

        function request_full_screen_if_wanted() {
            var opt, has_touch, at_left, likely_wants_fullscreen;
            opt = get_session_data().get("fullscreen_when_opening");
            has_touch = "ontouchstart" in window;
            at_left = window.screenLeft === 0;
            likely_wants_fullscreen = has_touch && at_left;
            if (opt === "auto" && likely_wants_fullscreen || opt === "always") {
                request_full_screen();
            }
        };
        if (!request_full_screen_if_wanted.__module__) Object.defineProperties(request_full_screen_if_wanted, {
            __module__ : {value: "book_list.router"}
        });

        function open_book() {
            var book_id = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[0];
            var fmt = ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[1];
            var library_id = (arguments[2] === undefined || ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? open_book.__defaults__.library_id : arguments[2];
            var replace = (arguments[3] === undefined || ( 3 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? open_book.__defaults__.replace : arguments[3];
            var extra_query = (arguments[4] === undefined || ( 4 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? open_book.__defaults__.extra_query : arguments[4];
            var ρσ_kwargs_obj = arguments[arguments.length-1];
            if (ρσ_kwargs_obj === null || typeof ρσ_kwargs_obj !== "object" || ρσ_kwargs_obj [ρσ_kwargs_symbol] !== true) ρσ_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "library_id")){
                library_id = ρσ_kwargs_obj.library_id;
            }
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "replace")){
                replace = ρσ_kwargs_obj.replace;
            }
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "extra_query")){
                extra_query = ρσ_kwargs_obj.extra_query;
            }
            var q;
            request_full_screen_if_wanted();
            library_id = library_id || current_library_id();
            q = (function(){
                var ρσ_d = Object.create(null);
                ρσ_d["book_id"] = book_id;
                ρσ_d["fmt"] = fmt;
                ρσ_d["library_id"] = library_id;
                return ρσ_d;
            }).call(this);
            if (extra_query && typeof extra_query === "object") {
                Object.assign(q, extra_query);
            }
            ρσ_interpolate_kwargs.call(this, push_state, [q].concat([ρσ_desugar_kwargs({replace: replace, mode: read_book_mode})]));
        };
        if (!open_book.__defaults__) Object.defineProperties(open_book, {
            __defaults__ : {value: {library_id:null, replace:false, extra_query:null}},
            __handles_kwarg_interpolation__ : {value: true},
            __argnames__ : {value: ["book_id", "fmt", "library_id", "replace", "extra_query"]},
            __module__ : {value: "book_list.router"}
        });

        function open_book_url(book_id, fmt, extra_query) {
            var lid, ans, q;
            lid = current_library_id();
            ans = absolute_path("");
            q = (function(){
                var ρσ_d = Object.create(null);
                ρσ_d["book_id"] = book_id;
                ρσ_d["fmt"] = fmt;
                ρσ_d["mode"] = read_book_mode;
                return ρσ_d;
            }).call(this);
            if (lid) {
                q.library_id = lid;
            }
            if (extra_query) {
                Object.assign(q, extra_query);
            }
            return ans + encode_query(q, "#");
        };
        if (!open_book_url.__argnames__) Object.defineProperties(open_book_url, {
            __argnames__ : {value: ["book_id", "fmt", "extra_query"]},
            __module__ : {value: "book_list.router"}
        });

        function push_state() {
            var query = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[0];
            var replace = (arguments[1] === undefined || ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? push_state.__defaults__.replace : arguments[1];
            var mode = (arguments[2] === undefined || ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? push_state.__defaults__.mode : arguments[2];
            var call_handler = (arguments[3] === undefined || ( 3 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? push_state.__defaults__.call_handler : arguments[3];
            var ρσ_kwargs_obj = arguments[arguments.length-1];
            if (ρσ_kwargs_obj === null || typeof ρσ_kwargs_obj !== "object" || ρσ_kwargs_obj [ρσ_kwargs_symbol] !== true) ρσ_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "replace")){
                replace = ρσ_kwargs_obj.replace;
            }
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "mode")){
                mode = ρσ_kwargs_obj.mode;
            }
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "call_handler")){
                call_handler = ρσ_kwargs_obj.call_handler;
            }
            var k;
            query = (function() {
                var ρσ_Iter = ρσ_Iterable(query), ρσ_Result = Object.create(null), k;
                for (var ρσ_Index = 0; ρσ_Index < ρσ_Iter.length; ρσ_Index++) {
                    k = ρσ_Iter[ρσ_Index];
                    if (query[(typeof k === "number" && k < 0) ? query.length + k : k]) {
                        ρσ_Result[k] = (query[(typeof k === "number" && k < 0) ? query.length + k : k]);
                    }
                }
                return ρσ_Result;
            })();
            if (mode !== "book_list") {
                query.mode = mode;
            }
            query = encode_query_with_path(query);
            if (replace) {
                window.history.replaceState(null, "", query);
            } else {
                window.history.pushState(null, "", query);
                push_state.history_count += 1;
            }
            apply_url(!call_handler);
        };
        if (!push_state.__defaults__) Object.defineProperties(push_state, {
            __defaults__ : {value: {replace:false, mode:"book_list", call_handler:true}},
            __handles_kwarg_interpolation__ : {value: true},
            __argnames__ : {value: ["query", "replace", "mode", "call_handler"]},
            __module__ : {value: "book_list.router"}
        });

        push_state.history_count = 0;
        function on_pop_state(ev) {
            push_state.history_count = max(0, push_state.history_count - 1);
            apply_url();
        };
        if (!on_pop_state.__argnames__) Object.defineProperties(on_pop_state, {
            __argnames__ : {value: ["ev"]},
            __module__ : {value: "book_list.router"}
        });

        function back() {
            var cq, handler, q;
            if (push_state.history_count > 0) {
                window.history.back();
            } else {
                cq = get_current_query();
                handler = mode_handlers[ρσ_bound_index(cq.mode, mode_handlers)] || default_mode_handler;
                if (handler.back_from_current) {
                    q = handler.back_from_current(cq);
                } else {
                    q = Object.create(null);
                }
                ρσ_interpolate_kwargs.call(this, push_state, [q].concat([ρσ_desugar_kwargs({replace: true})]));
            }
        };
        if (!back.__module__) Object.defineProperties(back, {
            __module__ : {value: "book_list.router"}
        });

        function home() {
            var replace = (arguments[0] === undefined || ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? home.__defaults__.replace : arguments[0];
            var ρσ_kwargs_obj = arguments[arguments.length-1];
            if (ρσ_kwargs_obj === null || typeof ρσ_kwargs_obj !== "object" || ρσ_kwargs_obj [ρσ_kwargs_symbol] !== true) ρσ_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "replace")){
                replace = ρσ_kwargs_obj.replace;
            }
            push_state(Object.create(null));
        };
        if (!home.__defaults__) Object.defineProperties(home, {
            __defaults__ : {value: {replace:false}},
            __handles_kwarg_interpolation__ : {value: true},
            __argnames__ : {value: ["replace"]},
            __module__ : {value: "book_list.router"}
        });

        function report_a_load_failure(container, msg, error_html) {
            var err;
            err = E.div();
            safe_set_inner_html(err, error_html);
            container.appendChild(ρσ_interpolate_kwargs.call(E, E.div, [E.div(msg), err, ρσ_interpolate_kwargs.call(E, E.div, [ρσ_interpolate_kwargs.call(E, E.a, [_("Go back to the home page")].concat([ρσ_desugar_kwargs({onclick: (function() {
                var ρσ_anonfunc = function () {
                    ρσ_interpolate_kwargs.call(this, home, [ρσ_desugar_kwargs({replace: true})]);
                };
                if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
                    __module__ : {value: "book_list.router"}
                });
                return ρσ_anonfunc;
            })(), href: "javascript: void(0)", class_: "blue-link"})]))].concat([ρσ_desugar_kwargs({style: "margin-top: 1em; border-top: solid 1px currentColor; padding-top: 1ex;"})]))].concat([ρσ_desugar_kwargs({style: "margin: 1ex 1em"})])));
        };
        if (!report_a_load_failure.__argnames__) Object.defineProperties(report_a_load_failure, {
            __argnames__ : {value: ["container", "msg", "error_html"]},
            __module__ : {value: "book_list.router"}
        });

        ρσ_modules["book_list.router"].mode_handlers = mode_handlers;
        ρσ_modules["book_list.router"].default_mode_handler = default_mode_handler;
        ρσ_modules["book_list.router"].read_book_mode = read_book_mode;
        ρσ_modules["book_list.router"].set_mode_handler = set_mode_handler;
        ρσ_modules["book_list.router"].set_default_mode_handler = set_default_mode_handler;
        ρσ_modules["book_list.router"].update_window_title = update_window_title;
        ρσ_modules["book_list.router"].is_reading_book = is_reading_book;
        ρσ_modules["book_list.router"].apply_mode = apply_mode;
        ρσ_modules["book_list.router"].apply_url = apply_url;
        ρσ_modules["book_list.router"].request_full_screen_if_wanted = request_full_screen_if_wanted;
        ρσ_modules["book_list.router"].open_book = open_book;
        ρσ_modules["book_list.router"].open_book_url = open_book_url;
        ρσ_modules["book_list.router"].push_state = push_state;
        ρσ_modules["book_list.router"].on_pop_state = on_pop_state;
        ρσ_modules["book_list.router"].back = back;
        ρσ_modules["book_list.router"].home = home;
        ρσ_modules["book_list.router"].report_a_load_failure = report_a_load_failure;
    })();

    (function(){
        var __name__ = "aes";
        var string_to_bytes, bytes_to_string, number_of_rounds, rcon, S, Si, T1, T2, T3, T4, T5, T6, T7, T8, U1, U2, U3, U4, random_bytes, noderandom;
        function string_to_bytes_encoder(string) {
            return new TextEncoder("utf-8").encode(string + "");
        };
        if (!string_to_bytes_encoder.__argnames__) Object.defineProperties(string_to_bytes_encoder, {
            __argnames__ : {value: ["string"]},
            __module__ : {value: "aes"}
        });

        function string_to_bytes_slow(string) {
            var escstr, binstr, ua, ρσ_unpack, i, ch;
            escstr = encodeURIComponent(string);
            binstr = escstr.replace(/%([0-9A-F]{2})/g, (function() {
                var ρσ_anonfunc = function (match, p1) {
                    return String.fromCharCode("0x" + p1);
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["match", "p1"]},
                    __module__ : {value: "aes"}
                });
                return ρσ_anonfunc;
            })());
            ua = new Uint8Array(binstr.length);
            var ρσ_Iter0 = ρσ_Iterable(enumerate(binstr));
            for (var ρσ_Index0 = 0; ρσ_Index0 < ρσ_Iter0.length; ρσ_Index0++) {
                ρσ_unpack = ρσ_Iter0[ρσ_Index0];
                i = ρσ_unpack[0];
                ch = ρσ_unpack[1];
                ua[(typeof i === "number" && i < 0) ? ua.length + i : i] = ch.charCodeAt(0);
            }
            return ua;
        };
        if (!string_to_bytes_slow.__argnames__) Object.defineProperties(string_to_bytes_slow, {
            __argnames__ : {value: ["string"]},
            __module__ : {value: "aes"}
        });

        function as_hex() {
            var array = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[0];
            var sep = (arguments[1] === undefined || ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? as_hex.__defaults__.sep : arguments[1];
            var ρσ_kwargs_obj = arguments[arguments.length-1];
            if (ρσ_kwargs_obj === null || typeof ρσ_kwargs_obj !== "object" || ρσ_kwargs_obj [ρσ_kwargs_symbol] !== true) ρσ_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "sep")){
                sep = ρσ_kwargs_obj.sep;
            }
            var num, fmt;
            num = array.BYTES_PER_ELEMENT || 1;
            fmt = "{:0" + num * 2 + "x}";
            return (function() {
                var ρσ_Iter = ρσ_Iterable(array), ρσ_Result = [], x;
                for (var ρσ_Index = 0; ρσ_Index < ρσ_Iter.length; ρσ_Index++) {
                    x = ρσ_Iter[ρσ_Index];
                    ρσ_Result.push(str.format(fmt, x));
                }
                ρσ_Result = ρσ_list_constructor(ρσ_Result);
                return ρσ_Result;
            })().join(sep);
        };
        if (!as_hex.__defaults__) Object.defineProperties(as_hex, {
            __defaults__ : {value: {sep:""}},
            __handles_kwarg_interpolation__ : {value: true},
            __argnames__ : {value: ["array", "sep"]},
            __module__ : {value: "aes"}
        });

        function bytes_to_string_decoder(bytes, offset) {
            offset = offset || 0;
            if (offset) {
                bytes = bytes.subarray(offset);
            }
            return new TextDecoder("utf-8").decode(bytes);
        };
        if (!bytes_to_string_decoder.__argnames__) Object.defineProperties(bytes_to_string_decoder, {
            __argnames__ : {value: ["bytes", "offset"]},
            __module__ : {value: "aes"}
        });

        function bytes_to_string_slow(bytes, offset) {
            var ans, i, c;
            ans = [];
            i = offset || 0;
            while (i < bytes.length) {
                c = bytes[(typeof i === "number" && i < 0) ? bytes.length + i : i];
                if (c < 128) {
                    ans.push(String.fromCharCode(c));
                    i += 1;
                } else if (191 < c && c < 224) {
                    ans.push(String.fromCharCode((c & 31) << 6 | bytes[ρσ_bound_index(i + 1, bytes)] & 63));
                    i += 2;
                } else {
                    ans.push(String.fromCharCode((c & 15) << 12 | (bytes[ρσ_bound_index(i + 1, bytes)] & 63) << 6 | bytes[ρσ_bound_index(i + 2, bytes)] & 63));
                    i += 3;
                }
            }
            return ans.join("");
        };
        if (!bytes_to_string_slow.__argnames__) Object.defineProperties(bytes_to_string_slow, {
            __argnames__ : {value: ["bytes", "offset"]},
            __module__ : {value: "aes"}
        });

        string_to_bytes = (typeof TextEncoder === "function") ? string_to_bytes_encoder : string_to_bytes_slow;
        bytes_to_string = (typeof TextDecoder === "function") ? bytes_to_string_decoder : bytes_to_string_slow;
        function increment_counter(c) {
            for (var i = 15; i >= 12; i--) {
                if (c[(typeof i === "number" && i < 0) ? c.length + i : i] === 255) {
                    c[(typeof i === "number" && i < 0) ? c.length + i : i] = 0;
                } else {
                    c[(typeof i === "number" && i < 0) ? c.length + i : i] += 1;
                    break;
                }
            }
        };
        if (!increment_counter.__argnames__) Object.defineProperties(increment_counter, {
            __argnames__ : {value: ["c"]},
            __module__ : {value: "aes"}
        });

        function convert_to_int32(bytes, output, offset, length) {
            offset = offset || 0;
            length = length || bytes.length;
            for (var i = offset, j = 0; i < offset + length; i += 4, j++) {
                output[(typeof j === "number" && j < 0) ? output.length + j : j] = bytes[(typeof i === "number" && i < 0) ? bytes.length + i : i] << 24 | bytes[ρσ_bound_index(i + 1, bytes)] << 16 | bytes[ρσ_bound_index(i + 2, bytes)] << 8 | bytes[ρσ_bound_index(i + 3, bytes)];
            }
        };
        if (!convert_to_int32.__argnames__) Object.defineProperties(convert_to_int32, {
            __argnames__ : {value: ["bytes", "output", "offset", "length"]},
            __module__ : {value: "aes"}
        });

        function convert_to_int32_pad(bytes) {
            var extra, t, ans;
            extra = bytes.length % 4;
            if (extra) {
                t = new Uint8Array(bytes.length + 4 - extra);
                t.set(bytes);
                bytes = t;
            }
            ans = new Uint32Array(bytes.length / 4);
            convert_to_int32(bytes, ans);
            return ans;
        };
        if (!convert_to_int32_pad.__argnames__) Object.defineProperties(convert_to_int32_pad, {
            __argnames__ : {value: ["bytes"]},
            __module__ : {value: "aes"}
        });

        if (!Uint8Array.prototype.fill) {
            Uint8Array.prototype.fill = Uint32Array.prototype.fill = (function() {
                var ρσ_anonfunc = function (val, start, end) {
                    start = start || 0;
                    if (end === undefined) {
                        end = this.length;
                    }
                    if (start < 0) {
                        start += this.length;
                    }
                    if (end < 0) {
                        end += this.length;
                    }
                    for (var i = start; i < end; i++) {
                        (ρσ_expr_temp = this)[(typeof i === "number" && i < 0) ? ρσ_expr_temp.length + i : i] = val;
                    }
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["val", "start", "end"]},
                    __module__ : {value: "aes"}
                });
                return ρσ_anonfunc;
            })();
        }
        function from_64_to_32(num) {
            var ans;
            ans = new Uint32Array(2);
            ans[0] = num / 4294967296 | 0;
            ans[1] = num & 4294967295;
            return ans;
        };
        if (!from_64_to_32.__argnames__) Object.defineProperties(from_64_to_32, {
            __argnames__ : {value: ["num"]},
            __module__ : {value: "aes"}
        });

        number_of_rounds = (function(){
            var ρσ_d = {};
            ρσ_d[16] = 10;
            ρσ_d[24] = 12;
            ρσ_d[32] = 14;
            return ρσ_d;
        }).call(this);
        rcon = new Uint32Array([0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80, 0x1b, 0x36, 0x6c, 0xd8, 0xab, 0x4d, 0x9a, 0x2f, 0x5e, 0xbc, 0x63, 0xc6, 0x97, 0x35, 0x6a, 0xd4, 0xb3, 0x7d, 0xfa, 0xef, 0xc5, 0x91]);
        S = new Uint32Array([0x63, 0x7c, 0x77, 0x7b, 0xf2, 0x6b, 0x6f, 0xc5, 0x30, 0x01, 0x67, 0x2b, 0xfe, 0xd7, 0xab, 0x76, 0xca, 0x82, 0xc9, 0x7d, 0xfa, 0x59, 0x47, 0xf0, 0xad, 0xd4, 0xa2, 0xaf, 0x9c, 0xa4, 0x72, 0xc0, 0xb7, 0xfd, 0x93, 0x26, 0x36, 0x3f, 0xf7, 0xcc, 0x34, 0xa5, 0xe5, 0xf1, 0x71, 0xd8, 0x31, 0x15, 0x04, 0xc7, 0x23, 0xc3, 0x18, 0x96, 0x05, 0x9a, 0x07, 0x12, 0x80, 0xe2, 0xeb, 0x27, 0xb2, 0x75, 0x09, 0x83, 0x2c, 0x1a, 0x1b, 0x6e, 0x5a, 0xa0, 0x52, 0x3b, 0xd6, 0xb3, 0x29, 0xe3, 0x2f, 0x84, 0x53, 0xd1, 0x00, 0xed, 0x20, 0xfc, 0xb1, 0x5b, 0x6a, 0xcb, 0xbe, 0x39, 0x4a, 0x4c, 0x58, 0xcf, 0xd0, 0xef, 0xaa, 0xfb, 0x43, 0x4d, 0x33, 0x85, 0x45, 0xf9, 0x02, 0x7f, 0x50, 0x3c, 0x9f, 0xa8, 0x51, 0xa3, 0x40, 0x8f, 0x92, 0x9d, 0x38, 0xf5, 0xbc, 0xb6, 0xda, 0x21, 0x10, 0xff, 0xf3, 0xd2, 0xcd, 0x0c, 0x13, 0xec, 0x5f, 0x97, 0x44, 0x17, 0xc4, 0xa7, 0x7e, 0x3d, 0x64, 0x5d, 0x19, 0x73, 0x60, 0x81, 0x4f, 0xdc, 0x22, 0x2a, 0x90, 0x88, 0x46, 0xee, 0xb8, 0x14, 0xde, 0x5e, 0x0b, 0xdb, 0xe0, 0x32, 0x3a, 0x0a, 0x49, 0x06, 0x24, 0x5c, 0xc2, 0xd3, 0xac, 0x62, 0x91, 0x95, 0xe4, 0x79, 0xe7, 0xc8, 0x37, 0x6d, 0x8d, 0xd5, 0x4e, 0xa9, 0x6c, 0x56, 0xf4, 0xea, 0x65, 0x7a, 0xae, 0x08, 0xba, 0x78, 0x25, 0x2e, 0x1c, 0xa6, 0xb4, 0xc6, 0xe8, 0xdd, 0x74, 0x1f, 0x4b, 0xbd, 0x8b, 0x8a, 0x70, 0x3e, 0xb5, 0x66, 0x48, 0x03, 0xf6, 0x0e, 0x61, 0x35, 0x57, 0xb9, 0x86, 0xc1, 0x1d, 0x9e, 0xe1, 0xf8, 0x98, 0x11, 0x69, 0xd9, 0x8e, 0x94, 0x9b, 0x1e, 0x87, 0xe9, 0xce, 0x55, 0x28, 0xdf, 0x8c, 0xa1, 0x89, 0x0d, 0xbf, 0xe6, 0x42, 0x68, 0x41, 0x99, 0x2d, 0x0f, 0xb0, 0x54, 0xbb, 0x16]);
        Si = new Uint32Array([0x52, 0x09, 0x6a, 0xd5, 0x30, 0x36, 0xa5, 0x38, 0xbf, 0x40, 0xa3, 0x9e, 0x81, 0xf3, 0xd7, 0xfb, 0x7c, 0xe3, 0x39, 0x82, 0x9b, 0x2f, 0xff, 0x87, 0x34, 0x8e, 0x43, 0x44, 0xc4, 0xde, 0xe9, 0xcb, 0x54, 0x7b, 0x94, 0x32, 0xa6, 0xc2, 0x23, 0x3d, 0xee, 0x4c, 0x95, 0x0b, 0x42, 0xfa, 0xc3, 0x4e, 0x08, 0x2e, 0xa1, 0x66, 0x28, 0xd9, 0x24, 0xb2, 0x76, 0x5b, 0xa2, 0x49, 0x6d, 0x8b, 0xd1, 0x25, 0x72, 0xf8, 0xf6, 0x64, 0x86, 0x68, 0x98, 0x16, 0xd4, 0xa4, 0x5c, 0xcc, 0x5d, 0x65, 0xb6, 0x92, 0x6c, 0x70, 0x48, 0x50, 0xfd, 0xed, 0xb9, 0xda, 0x5e, 0x15, 0x46, 0x57, 0xa7, 0x8d, 0x9d, 0x84, 0x90, 0xd8, 0xab, 0x00, 0x8c, 0xbc, 0xd3, 0x0a, 0xf7, 0xe4, 0x58, 0x05, 0xb8, 0xb3, 0x45, 0x06, 0xd0, 0x2c, 0x1e, 0x8f, 0xca, 0x3f, 0x0f, 0x02, 0xc1, 0xaf, 0xbd, 0x03, 0x01, 0x13, 0x8a, 0x6b, 0x3a, 0x91, 0x11, 0x41, 0x4f, 0x67, 0xdc, 0xea, 0x97, 0xf2, 0xcf, 0xce, 0xf0, 0xb4, 0xe6, 0x73, 0x96, 0xac, 0x74, 0x22, 0xe7, 0xad, 0x35, 0x85, 0xe2, 0xf9, 0x37, 0xe8, 0x1c, 0x75, 0xdf, 0x6e, 0x47, 0xf1, 0x1a, 0x71, 0x1d, 0x29, 0xc5, 0x89, 0x6f, 0xb7, 0x62, 0x0e, 0xaa, 0x18, 0xbe, 0x1b, 0xfc, 0x56, 0x3e, 0x4b, 0xc6, 0xd2, 0x79, 0x20, 0x9a, 0xdb, 0xc0, 0xfe, 0x78, 0xcd, 0x5a, 0xf4, 0x1f, 0xdd, 0xa8, 0x33, 0x88, 0x07, 0xc7, 0x31, 0xb1, 0x12, 0x10, 0x59, 0x27, 0x80, 0xec, 0x5f, 0x60, 0x51, 0x7f, 0xa9, 0x19, 0xb5, 0x4a, 0x0d, 0x2d, 0xe5, 0x7a, 0x9f, 0x93, 0xc9, 0x9c, 0xef, 0xa0, 0xe0, 0x3b, 0x4d, 0xae, 0x2a, 0xf5, 0xb0, 0xc8, 0xeb, 0xbb, 0x3c, 0x83, 0x53, 0x99, 0x61, 0x17, 0x2b, 0x04, 0x7e, 0xba, 0x77, 0xd6, 0x26, 0xe1, 0x69, 0x14, 0x63, 0x55, 0x21, 0x0c, 0x7d]);
        T1 = new Uint32Array([0xc66363a5, 0xf87c7c84, 0xee777799, 0xf67b7b8d, 0xfff2f20d, 0xd66b6bbd, 0xde6f6fb1, 0x91c5c554, 0x60303050, 0x02010103, 0xce6767a9, 0x562b2b7d, 0xe7fefe19, 0xb5d7d762, 0x4dababe6, 0xec76769a, 0x8fcaca45, 0x1f82829d, 0x89c9c940, 0xfa7d7d87, 0xeffafa15, 0xb25959eb, 0x8e4747c9, 0xfbf0f00b, 0x41adadec, 0xb3d4d467, 0x5fa2a2fd, 0x45afafea, 0x239c9cbf, 0x53a4a4f7, 0xe4727296, 0x9bc0c05b, 0x75b7b7c2, 0xe1fdfd1c, 0x3d9393ae, 0x4c26266a, 0x6c36365a, 0x7e3f3f41, 0xf5f7f702, 0x83cccc4f, 0x6834345c, 0x51a5a5f4, 0xd1e5e534, 0xf9f1f108, 0xe2717193, 0xabd8d873, 0x62313153, 0x2a15153f, 0x0804040c, 0x95c7c752, 0x46232365, 0x9dc3c35e, 0x30181828, 0x379696a1, 0x0a05050f, 0x2f9a9ab5, 0x0e070709, 0x24121236, 0x1b80809b, 0xdfe2e23d, 0xcdebeb26, 0x4e272769, 0x7fb2b2cd, 0xea75759f, 0x1209091b, 0x1d83839e, 0x582c2c74, 0x341a1a2e, 0x361b1b2d, 0xdc6e6eb2, 0xb45a5aee, 0x5ba0a0fb, 0xa45252f6, 0x763b3b4d, 0xb7d6d661, 0x7db3b3ce, 0x5229297b, 0xdde3e33e, 0x5e2f2f71, 0x13848497, 0xa65353f5, 0xb9d1d168, 0x00000000, 0xc1eded2c, 0x40202060, 0xe3fcfc1f, 0x79b1b1c8, 0xb65b5bed, 0xd46a6abe, 0x8dcbcb46, 0x67bebed9, 0x7239394b, 0x944a4ade, 0x984c4cd4, 0xb05858e8, 0x85cfcf4a, 0xbbd0d06b, 0xc5efef2a, 0x4faaaae5, 0xedfbfb16, 0x864343c5, 0x9a4d4dd7, 0x66333355, 0x11858594, 0x8a4545cf, 0xe9f9f910, 0x04020206, 0xfe7f7f81, 0xa05050f0, 0x783c3c44, 0x259f9fba, 0x4ba8a8e3, 0xa25151f3, 0x5da3a3fe, 0x804040c0, 0x058f8f8a, 0x3f9292ad, 0x219d9dbc, 0x70383848, 0xf1f5f504, 0x63bcbcdf, 0x77b6b6c1, 0xafdada75, 0x42212163, 0x20101030, 0xe5ffff1a, 0xfdf3f30e, 0xbfd2d26d, 0x81cdcd4c, 0x180c0c14, 0x26131335, 0xc3ecec2f, 0xbe5f5fe1, 0x359797a2, 0x884444cc, 0x2e171739, 0x93c4c457, 0x55a7a7f2, 0xfc7e7e82, 0x7a3d3d47, 0xc86464ac, 0xba5d5de7, 0x3219192b, 0xe6737395, 0xc06060a0, 0x19818198, 0x9e4f4fd1, 0xa3dcdc7f, 0x44222266, 0x542a2a7e, 0x3b9090ab, 0x0b888883, 0x8c4646ca, 0xc7eeee29, 0x6bb8b8d3, 0x2814143c, 0xa7dede79, 0xbc5e5ee2, 0x160b0b1d, 0xaddbdb76, 0xdbe0e03b, 0x64323256, 0x743a3a4e, 0x140a0a1e, 0x924949db, 0x0c06060a, 0x4824246c, 0xb85c5ce4, 0x9fc2c25d, 0xbdd3d36e, 0x43acacef, 0xc46262a6, 0x399191a8, 0x319595a4, 0xd3e4e437, 0xf279798b, 0xd5e7e732, 0x8bc8c843, 0x6e373759, 0xda6d6db7, 0x018d8d8c, 0xb1d5d564, 0x9c4e4ed2, 0x49a9a9e0, 0xd86c6cb4, 0xac5656fa, 0xf3f4f407, 0xcfeaea25, 0xca6565af, 0xf47a7a8e, 0x47aeaee9, 0x10080818, 0x6fbabad5, 0xf0787888, 0x4a25256f, 0x5c2e2e72, 0x381c1c24, 0x57a6a6f1, 0x73b4b4c7, 0x97c6c651, 0xcbe8e823, 0xa1dddd7c, 0xe874749c, 0x3e1f1f21, 0x964b4bdd, 0x61bdbddc, 0x0d8b8b86, 0x0f8a8a85, 0xe0707090, 0x7c3e3e42, 0x71b5b5c4, 0xcc6666aa, 0x904848d8, 0x06030305, 0xf7f6f601, 0x1c0e0e12, 0xc26161a3, 0x6a35355f, 0xae5757f9, 0x69b9b9d0, 0x17868691, 0x99c1c158, 0x3a1d1d27, 0x279e9eb9, 0xd9e1e138, 0xebf8f813, 0x2b9898b3, 0x22111133, 0xd26969bb, 0xa9d9d970, 0x078e8e89, 0x339494a7, 0x2d9b9bb6, 0x3c1e1e22, 0x15878792, 0xc9e9e920, 0x87cece49, 0xaa5555ff, 0x50282878, 0xa5dfdf7a, 0x038c8c8f, 0x59a1a1f8, 0x09898980, 0x1a0d0d17, 0x65bfbfda, 0xd7e6e631, 0x844242c6, 0xd06868b8, 0x824141c3, 0x299999b0, 0x5a2d2d77, 0x1e0f0f11, 0x7bb0b0cb, 0xa85454fc, 0x6dbbbbd6, 0x2c16163a]);
        T2 = new Uint32Array([0xa5c66363, 0x84f87c7c, 0x99ee7777, 0x8df67b7b, 0x0dfff2f2, 0xbdd66b6b, 0xb1de6f6f, 0x5491c5c5, 0x50603030, 0x03020101, 0xa9ce6767, 0x7d562b2b, 0x19e7fefe, 0x62b5d7d7, 0xe64dabab, 0x9aec7676, 0x458fcaca, 0x9d1f8282, 0x4089c9c9, 0x87fa7d7d, 0x15effafa, 0xebb25959, 0xc98e4747, 0x0bfbf0f0, 0xec41adad, 0x67b3d4d4, 0xfd5fa2a2, 0xea45afaf, 0xbf239c9c, 0xf753a4a4, 0x96e47272, 0x5b9bc0c0, 0xc275b7b7, 0x1ce1fdfd, 0xae3d9393, 0x6a4c2626, 0x5a6c3636, 0x417e3f3f, 0x02f5f7f7, 0x4f83cccc, 0x5c683434, 0xf451a5a5, 0x34d1e5e5, 0x08f9f1f1, 0x93e27171, 0x73abd8d8, 0x53623131, 0x3f2a1515, 0x0c080404, 0x5295c7c7, 0x65462323, 0x5e9dc3c3, 0x28301818, 0xa1379696, 0x0f0a0505, 0xb52f9a9a, 0x090e0707, 0x36241212, 0x9b1b8080, 0x3ddfe2e2, 0x26cdebeb, 0x694e2727, 0xcd7fb2b2, 0x9fea7575, 0x1b120909, 0x9e1d8383, 0x74582c2c, 0x2e341a1a, 0x2d361b1b, 0xb2dc6e6e, 0xeeb45a5a, 0xfb5ba0a0, 0xf6a45252, 0x4d763b3b, 0x61b7d6d6, 0xce7db3b3, 0x7b522929, 0x3edde3e3, 0x715e2f2f, 0x97138484, 0xf5a65353, 0x68b9d1d1, 0x00000000, 0x2cc1eded, 0x60402020, 0x1fe3fcfc, 0xc879b1b1, 0xedb65b5b, 0xbed46a6a, 0x468dcbcb, 0xd967bebe, 0x4b723939, 0xde944a4a, 0xd4984c4c, 0xe8b05858, 0x4a85cfcf, 0x6bbbd0d0, 0x2ac5efef, 0xe54faaaa, 0x16edfbfb, 0xc5864343, 0xd79a4d4d, 0x55663333, 0x94118585, 0xcf8a4545, 0x10e9f9f9, 0x06040202, 0x81fe7f7f, 0xf0a05050, 0x44783c3c, 0xba259f9f, 0xe34ba8a8, 0xf3a25151, 0xfe5da3a3, 0xc0804040, 0x8a058f8f, 0xad3f9292, 0xbc219d9d, 0x48703838, 0x04f1f5f5, 0xdf63bcbc, 0xc177b6b6, 0x75afdada, 0x63422121, 0x30201010, 0x1ae5ffff, 0x0efdf3f3, 0x6dbfd2d2, 0x4c81cdcd, 0x14180c0c, 0x35261313, 0x2fc3ecec, 0xe1be5f5f, 0xa2359797, 0xcc884444, 0x392e1717, 0x5793c4c4, 0xf255a7a7, 0x82fc7e7e, 0x477a3d3d, 0xacc86464, 0xe7ba5d5d, 0x2b321919, 0x95e67373, 0xa0c06060, 0x98198181, 0xd19e4f4f, 0x7fa3dcdc, 0x66442222, 0x7e542a2a, 0xab3b9090, 0x830b8888, 0xca8c4646, 0x29c7eeee, 0xd36bb8b8, 0x3c281414, 0x79a7dede, 0xe2bc5e5e, 0x1d160b0b, 0x76addbdb, 0x3bdbe0e0, 0x56643232, 0x4e743a3a, 0x1e140a0a, 0xdb924949, 0x0a0c0606, 0x6c482424, 0xe4b85c5c, 0x5d9fc2c2, 0x6ebdd3d3, 0xef43acac, 0xa6c46262, 0xa8399191, 0xa4319595, 0x37d3e4e4, 0x8bf27979, 0x32d5e7e7, 0x438bc8c8, 0x596e3737, 0xb7da6d6d, 0x8c018d8d, 0x64b1d5d5, 0xd29c4e4e, 0xe049a9a9, 0xb4d86c6c, 0xfaac5656, 0x07f3f4f4, 0x25cfeaea, 0xafca6565, 0x8ef47a7a, 0xe947aeae, 0x18100808, 0xd56fbaba, 0x88f07878, 0x6f4a2525, 0x725c2e2e, 0x24381c1c, 0xf157a6a6, 0xc773b4b4, 0x5197c6c6, 0x23cbe8e8, 0x7ca1dddd, 0x9ce87474, 0x213e1f1f, 0xdd964b4b, 0xdc61bdbd, 0x860d8b8b, 0x850f8a8a, 0x90e07070, 0x427c3e3e, 0xc471b5b5, 0xaacc6666, 0xd8904848, 0x05060303, 0x01f7f6f6, 0x121c0e0e, 0xa3c26161, 0x5f6a3535, 0xf9ae5757, 0xd069b9b9, 0x91178686, 0x5899c1c1, 0x273a1d1d, 0xb9279e9e, 0x38d9e1e1, 0x13ebf8f8, 0xb32b9898, 0x33221111, 0xbbd26969, 0x70a9d9d9, 0x89078e8e, 0xa7339494, 0xb62d9b9b, 0x223c1e1e, 0x92158787, 0x20c9e9e9, 0x4987cece, 0xffaa5555, 0x78502828, 0x7aa5dfdf, 0x8f038c8c, 0xf859a1a1, 0x80098989, 0x171a0d0d, 0xda65bfbf, 0x31d7e6e6, 0xc6844242, 0xb8d06868, 0xc3824141, 0xb0299999, 0x775a2d2d, 0x111e0f0f, 0xcb7bb0b0, 0xfca85454, 0xd66dbbbb, 0x3a2c1616]);
        T3 = new Uint32Array([0x63a5c663, 0x7c84f87c, 0x7799ee77, 0x7b8df67b, 0xf20dfff2, 0x6bbdd66b, 0x6fb1de6f, 0xc55491c5, 0x30506030, 0x01030201, 0x67a9ce67, 0x2b7d562b, 0xfe19e7fe, 0xd762b5d7, 0xabe64dab, 0x769aec76, 0xca458fca, 0x829d1f82, 0xc94089c9, 0x7d87fa7d, 0xfa15effa, 0x59ebb259, 0x47c98e47, 0xf00bfbf0, 0xadec41ad, 0xd467b3d4, 0xa2fd5fa2, 0xafea45af, 0x9cbf239c, 0xa4f753a4, 0x7296e472, 0xc05b9bc0, 0xb7c275b7, 0xfd1ce1fd, 0x93ae3d93, 0x266a4c26, 0x365a6c36, 0x3f417e3f, 0xf702f5f7, 0xcc4f83cc, 0x345c6834, 0xa5f451a5, 0xe534d1e5, 0xf108f9f1, 0x7193e271, 0xd873abd8, 0x31536231, 0x153f2a15, 0x040c0804, 0xc75295c7, 0x23654623, 0xc35e9dc3, 0x18283018, 0x96a13796, 0x050f0a05, 0x9ab52f9a, 0x07090e07, 0x12362412, 0x809b1b80, 0xe23ddfe2, 0xeb26cdeb, 0x27694e27, 0xb2cd7fb2, 0x759fea75, 0x091b1209, 0x839e1d83, 0x2c74582c, 0x1a2e341a, 0x1b2d361b, 0x6eb2dc6e, 0x5aeeb45a, 0xa0fb5ba0, 0x52f6a452, 0x3b4d763b, 0xd661b7d6, 0xb3ce7db3, 0x297b5229, 0xe33edde3, 0x2f715e2f, 0x84971384, 0x53f5a653, 0xd168b9d1, 0x00000000, 0xed2cc1ed, 0x20604020, 0xfc1fe3fc, 0xb1c879b1, 0x5bedb65b, 0x6abed46a, 0xcb468dcb, 0xbed967be, 0x394b7239, 0x4ade944a, 0x4cd4984c, 0x58e8b058, 0xcf4a85cf, 0xd06bbbd0, 0xef2ac5ef, 0xaae54faa, 0xfb16edfb, 0x43c58643, 0x4dd79a4d, 0x33556633, 0x85941185, 0x45cf8a45, 0xf910e9f9, 0x02060402, 0x7f81fe7f, 0x50f0a050, 0x3c44783c, 0x9fba259f, 0xa8e34ba8, 0x51f3a251, 0xa3fe5da3, 0x40c08040, 0x8f8a058f, 0x92ad3f92, 0x9dbc219d, 0x38487038, 0xf504f1f5, 0xbcdf63bc, 0xb6c177b6, 0xda75afda, 0x21634221, 0x10302010, 0xff1ae5ff, 0xf30efdf3, 0xd26dbfd2, 0xcd4c81cd, 0x0c14180c, 0x13352613, 0xec2fc3ec, 0x5fe1be5f, 0x97a23597, 0x44cc8844, 0x17392e17, 0xc45793c4, 0xa7f255a7, 0x7e82fc7e, 0x3d477a3d, 0x64acc864, 0x5de7ba5d, 0x192b3219, 0x7395e673, 0x60a0c060, 0x81981981, 0x4fd19e4f, 0xdc7fa3dc, 0x22664422, 0x2a7e542a, 0x90ab3b90, 0x88830b88, 0x46ca8c46, 0xee29c7ee, 0xb8d36bb8, 0x143c2814, 0xde79a7de, 0x5ee2bc5e, 0x0b1d160b, 0xdb76addb, 0xe03bdbe0, 0x32566432, 0x3a4e743a, 0x0a1e140a, 0x49db9249, 0x060a0c06, 0x246c4824, 0x5ce4b85c, 0xc25d9fc2, 0xd36ebdd3, 0xacef43ac, 0x62a6c462, 0x91a83991, 0x95a43195, 0xe437d3e4, 0x798bf279, 0xe732d5e7, 0xc8438bc8, 0x37596e37, 0x6db7da6d, 0x8d8c018d, 0xd564b1d5, 0x4ed29c4e, 0xa9e049a9, 0x6cb4d86c, 0x56faac56, 0xf407f3f4, 0xea25cfea, 0x65afca65, 0x7a8ef47a, 0xaee947ae, 0x08181008, 0xbad56fba, 0x7888f078, 0x256f4a25, 0x2e725c2e, 0x1c24381c, 0xa6f157a6, 0xb4c773b4, 0xc65197c6, 0xe823cbe8, 0xdd7ca1dd, 0x749ce874, 0x1f213e1f, 0x4bdd964b, 0xbddc61bd, 0x8b860d8b, 0x8a850f8a, 0x7090e070, 0x3e427c3e, 0xb5c471b5, 0x66aacc66, 0x48d89048, 0x03050603, 0xf601f7f6, 0x0e121c0e, 0x61a3c261, 0x355f6a35, 0x57f9ae57, 0xb9d069b9, 0x86911786, 0xc15899c1, 0x1d273a1d, 0x9eb9279e, 0xe138d9e1, 0xf813ebf8, 0x98b32b98, 0x11332211, 0x69bbd269, 0xd970a9d9, 0x8e89078e, 0x94a73394, 0x9bb62d9b, 0x1e223c1e, 0x87921587, 0xe920c9e9, 0xce4987ce, 0x55ffaa55, 0x28785028, 0xdf7aa5df, 0x8c8f038c, 0xa1f859a1, 0x89800989, 0x0d171a0d, 0xbfda65bf, 0xe631d7e6, 0x42c68442, 0x68b8d068, 0x41c38241, 0x99b02999, 0x2d775a2d, 0x0f111e0f, 0xb0cb7bb0, 0x54fca854, 0xbbd66dbb, 0x163a2c16]);
        T4 = new Uint32Array([0x6363a5c6, 0x7c7c84f8, 0x777799ee, 0x7b7b8df6, 0xf2f20dff, 0x6b6bbdd6, 0x6f6fb1de, 0xc5c55491, 0x30305060, 0x01010302, 0x6767a9ce, 0x2b2b7d56, 0xfefe19e7, 0xd7d762b5, 0xababe64d, 0x76769aec, 0xcaca458f, 0x82829d1f, 0xc9c94089, 0x7d7d87fa, 0xfafa15ef, 0x5959ebb2, 0x4747c98e, 0xf0f00bfb, 0xadadec41, 0xd4d467b3, 0xa2a2fd5f, 0xafafea45, 0x9c9cbf23, 0xa4a4f753, 0x727296e4, 0xc0c05b9b, 0xb7b7c275, 0xfdfd1ce1, 0x9393ae3d, 0x26266a4c, 0x36365a6c, 0x3f3f417e, 0xf7f702f5, 0xcccc4f83, 0x34345c68, 0xa5a5f451, 0xe5e534d1, 0xf1f108f9, 0x717193e2, 0xd8d873ab, 0x31315362, 0x15153f2a, 0x04040c08, 0xc7c75295, 0x23236546, 0xc3c35e9d, 0x18182830, 0x9696a137, 0x05050f0a, 0x9a9ab52f, 0x0707090e, 0x12123624, 0x80809b1b, 0xe2e23ddf, 0xebeb26cd, 0x2727694e, 0xb2b2cd7f, 0x75759fea, 0x09091b12, 0x83839e1d, 0x2c2c7458, 0x1a1a2e34, 0x1b1b2d36, 0x6e6eb2dc, 0x5a5aeeb4, 0xa0a0fb5b, 0x5252f6a4, 0x3b3b4d76, 0xd6d661b7, 0xb3b3ce7d, 0x29297b52, 0xe3e33edd, 0x2f2f715e, 0x84849713, 0x5353f5a6, 0xd1d168b9, 0x00000000, 0xeded2cc1, 0x20206040, 0xfcfc1fe3, 0xb1b1c879, 0x5b5bedb6, 0x6a6abed4, 0xcbcb468d, 0xbebed967, 0x39394b72, 0x4a4ade94, 0x4c4cd498, 0x5858e8b0, 0xcfcf4a85, 0xd0d06bbb, 0xefef2ac5, 0xaaaae54f, 0xfbfb16ed, 0x4343c586, 0x4d4dd79a, 0x33335566, 0x85859411, 0x4545cf8a, 0xf9f910e9, 0x02020604, 0x7f7f81fe, 0x5050f0a0, 0x3c3c4478, 0x9f9fba25, 0xa8a8e34b, 0x5151f3a2, 0xa3a3fe5d, 0x4040c080, 0x8f8f8a05, 0x9292ad3f, 0x9d9dbc21, 0x38384870, 0xf5f504f1, 0xbcbcdf63, 0xb6b6c177, 0xdada75af, 0x21216342, 0x10103020, 0xffff1ae5, 0xf3f30efd, 0xd2d26dbf, 0xcdcd4c81, 0x0c0c1418, 0x13133526, 0xecec2fc3, 0x5f5fe1be, 0x9797a235, 0x4444cc88, 0x1717392e, 0xc4c45793, 0xa7a7f255, 0x7e7e82fc, 0x3d3d477a, 0x6464acc8, 0x5d5de7ba, 0x19192b32, 0x737395e6, 0x6060a0c0, 0x81819819, 0x4f4fd19e, 0xdcdc7fa3, 0x22226644, 0x2a2a7e54, 0x9090ab3b, 0x8888830b, 0x4646ca8c, 0xeeee29c7, 0xb8b8d36b, 0x14143c28, 0xdede79a7, 0x5e5ee2bc, 0x0b0b1d16, 0xdbdb76ad, 0xe0e03bdb, 0x32325664, 0x3a3a4e74, 0x0a0a1e14, 0x4949db92, 0x06060a0c, 0x24246c48, 0x5c5ce4b8, 0xc2c25d9f, 0xd3d36ebd, 0xacacef43, 0x6262a6c4, 0x9191a839, 0x9595a431, 0xe4e437d3, 0x79798bf2, 0xe7e732d5, 0xc8c8438b, 0x3737596e, 0x6d6db7da, 0x8d8d8c01, 0xd5d564b1, 0x4e4ed29c, 0xa9a9e049, 0x6c6cb4d8, 0x5656faac, 0xf4f407f3, 0xeaea25cf, 0x6565afca, 0x7a7a8ef4, 0xaeaee947, 0x08081810, 0xbabad56f, 0x787888f0, 0x25256f4a, 0x2e2e725c, 0x1c1c2438, 0xa6a6f157, 0xb4b4c773, 0xc6c65197, 0xe8e823cb, 0xdddd7ca1, 0x74749ce8, 0x1f1f213e, 0x4b4bdd96, 0xbdbddc61, 0x8b8b860d, 0x8a8a850f, 0x707090e0, 0x3e3e427c, 0xb5b5c471, 0x6666aacc, 0x4848d890, 0x03030506, 0xf6f601f7, 0x0e0e121c, 0x6161a3c2, 0x35355f6a, 0x5757f9ae, 0xb9b9d069, 0x86869117, 0xc1c15899, 0x1d1d273a, 0x9e9eb927, 0xe1e138d9, 0xf8f813eb, 0x9898b32b, 0x11113322, 0x6969bbd2, 0xd9d970a9, 0x8e8e8907, 0x9494a733, 0x9b9bb62d, 0x1e1e223c, 0x87879215, 0xe9e920c9, 0xcece4987, 0x5555ffaa, 0x28287850, 0xdfdf7aa5, 0x8c8c8f03, 0xa1a1f859, 0x89898009, 0x0d0d171a, 0xbfbfda65, 0xe6e631d7, 0x4242c684, 0x6868b8d0, 0x4141c382, 0x9999b029, 0x2d2d775a, 0x0f0f111e, 0xb0b0cb7b, 0x5454fca8, 0xbbbbd66d, 0x16163a2c]);
        T5 = new Uint32Array([0x51f4a750, 0x7e416553, 0x1a17a4c3, 0x3a275e96, 0x3bab6bcb, 0x1f9d45f1, 0xacfa58ab, 0x4be30393, 0x2030fa55, 0xad766df6, 0x88cc7691, 0xf5024c25, 0x4fe5d7fc, 0xc52acbd7, 0x26354480, 0xb562a38f, 0xdeb15a49, 0x25ba1b67, 0x45ea0e98, 0x5dfec0e1, 0xc32f7502, 0x814cf012, 0x8d4697a3, 0x6bd3f9c6, 0x038f5fe7, 0x15929c95, 0xbf6d7aeb, 0x955259da, 0xd4be832d, 0x587421d3, 0x49e06929, 0x8ec9c844, 0x75c2896a, 0xf48e7978, 0x99583e6b, 0x27b971dd, 0xbee14fb6, 0xf088ad17, 0xc920ac66, 0x7dce3ab4, 0x63df4a18, 0xe51a3182, 0x97513360, 0x62537f45, 0xb16477e0, 0xbb6bae84, 0xfe81a01c, 0xf9082b94, 0x70486858, 0x8f45fd19, 0x94de6c87, 0x527bf8b7, 0xab73d323, 0x724b02e2, 0xe31f8f57, 0x6655ab2a, 0xb2eb2807, 0x2fb5c203, 0x86c57b9a, 0xd33708a5, 0x302887f2, 0x23bfa5b2, 0x02036aba, 0xed16825c, 0x8acf1c2b, 0xa779b492, 0xf307f2f0, 0x4e69e2a1, 0x65daf4cd, 0x0605bed5, 0xd134621f, 0xc4a6fe8a, 0x342e539d, 0xa2f355a0, 0x058ae132, 0xa4f6eb75, 0x0b83ec39, 0x4060efaa, 0x5e719f06, 0xbd6e1051, 0x3e218af9, 0x96dd063d, 0xdd3e05ae, 0x4de6bd46, 0x91548db5, 0x71c45d05, 0x0406d46f, 0x605015ff, 0x1998fb24, 0xd6bde997, 0x894043cc, 0x67d99e77, 0xb0e842bd, 0x07898b88, 0xe7195b38, 0x79c8eedb, 0xa17c0a47, 0x7c420fe9, 0xf8841ec9, 0x00000000, 0x09808683, 0x322bed48, 0x1e1170ac, 0x6c5a724e, 0xfd0efffb, 0x0f853856, 0x3daed51e, 0x362d3927, 0x0a0fd964, 0x685ca621, 0x9b5b54d1, 0x24362e3a, 0x0c0a67b1, 0x9357e70f, 0xb4ee96d2, 0x1b9b919e, 0x80c0c54f, 0x61dc20a2, 0x5a774b69, 0x1c121a16, 0xe293ba0a, 0xc0a02ae5, 0x3c22e043, 0x121b171d, 0x0e090d0b, 0xf28bc7ad, 0x2db6a8b9, 0x141ea9c8, 0x57f11985, 0xaf75074c, 0xee99ddbb, 0xa37f60fd, 0xf701269f, 0x5c72f5bc, 0x44663bc5, 0x5bfb7e34, 0x8b432976, 0xcb23c6dc, 0xb6edfc68, 0xb8e4f163, 0xd731dcca, 0x42638510, 0x13972240, 0x84c61120, 0x854a247d, 0xd2bb3df8, 0xaef93211, 0xc729a16d, 0x1d9e2f4b, 0xdcb230f3, 0x0d8652ec, 0x77c1e3d0, 0x2bb3166c, 0xa970b999, 0x119448fa, 0x47e96422, 0xa8fc8cc4, 0xa0f03f1a, 0x567d2cd8, 0x223390ef, 0x87494ec7, 0xd938d1c1, 0x8ccaa2fe, 0x98d40b36, 0xa6f581cf, 0xa57ade28, 0xdab78e26, 0x3fadbfa4, 0x2c3a9de4, 0x5078920d, 0x6a5fcc9b, 0x547e4662, 0xf68d13c2, 0x90d8b8e8, 0x2e39f75e, 0x82c3aff5, 0x9f5d80be, 0x69d0937c, 0x6fd52da9, 0xcf2512b3, 0xc8ac993b, 0x10187da7, 0xe89c636e, 0xdb3bbb7b, 0xcd267809, 0x6e5918f4, 0xec9ab701, 0x834f9aa8, 0xe6956e65, 0xaaffe67e, 0x21bccf08, 0xef15e8e6, 0xbae79bd9, 0x4a6f36ce, 0xea9f09d4, 0x29b07cd6, 0x31a4b2af, 0x2a3f2331, 0xc6a59430, 0x35a266c0, 0x744ebc37, 0xfc82caa6, 0xe090d0b0, 0x33a7d815, 0xf104984a, 0x41ecdaf7, 0x7fcd500e, 0x1791f62f, 0x764dd68d, 0x43efb04d, 0xccaa4d54, 0xe49604df, 0x9ed1b5e3, 0x4c6a881b, 0xc12c1fb8, 0x4665517f, 0x9d5eea04, 0x018c355d, 0xfa877473, 0xfb0b412e, 0xb3671d5a, 0x92dbd252, 0xe9105633, 0x6dd64713, 0x9ad7618c, 0x37a10c7a, 0x59f8148e, 0xeb133c89, 0xcea927ee, 0xb761c935, 0xe11ce5ed, 0x7a47b13c, 0x9cd2df59, 0x55f2733f, 0x1814ce79, 0x73c737bf, 0x53f7cdea, 0x5ffdaa5b, 0xdf3d6f14, 0x7844db86, 0xcaaff381, 0xb968c43e, 0x3824342c, 0xc2a3405f, 0x161dc372, 0xbce2250c, 0x283c498b, 0xff0d9541, 0x39a80171, 0x080cb3de, 0xd8b4e49c, 0x6456c190, 0x7bcb8461, 0xd532b670, 0x486c5c74, 0xd0b85742]);
        T6 = new Uint32Array([0x5051f4a7, 0x537e4165, 0xc31a17a4, 0x963a275e, 0xcb3bab6b, 0xf11f9d45, 0xabacfa58, 0x934be303, 0x552030fa, 0xf6ad766d, 0x9188cc76, 0x25f5024c, 0xfc4fe5d7, 0xd7c52acb, 0x80263544, 0x8fb562a3, 0x49deb15a, 0x6725ba1b, 0x9845ea0e, 0xe15dfec0, 0x02c32f75, 0x12814cf0, 0xa38d4697, 0xc66bd3f9, 0xe7038f5f, 0x9515929c, 0xebbf6d7a, 0xda955259, 0x2dd4be83, 0xd3587421, 0x2949e069, 0x448ec9c8, 0x6a75c289, 0x78f48e79, 0x6b99583e, 0xdd27b971, 0xb6bee14f, 0x17f088ad, 0x66c920ac, 0xb47dce3a, 0x1863df4a, 0x82e51a31, 0x60975133, 0x4562537f, 0xe0b16477, 0x84bb6bae, 0x1cfe81a0, 0x94f9082b, 0x58704868, 0x198f45fd, 0x8794de6c, 0xb7527bf8, 0x23ab73d3, 0xe2724b02, 0x57e31f8f, 0x2a6655ab, 0x07b2eb28, 0x032fb5c2, 0x9a86c57b, 0xa5d33708, 0xf2302887, 0xb223bfa5, 0xba02036a, 0x5ced1682, 0x2b8acf1c, 0x92a779b4, 0xf0f307f2, 0xa14e69e2, 0xcd65daf4, 0xd50605be, 0x1fd13462, 0x8ac4a6fe, 0x9d342e53, 0xa0a2f355, 0x32058ae1, 0x75a4f6eb, 0x390b83ec, 0xaa4060ef, 0x065e719f, 0x51bd6e10, 0xf93e218a, 0x3d96dd06, 0xaedd3e05, 0x464de6bd, 0xb591548d, 0x0571c45d, 0x6f0406d4, 0xff605015, 0x241998fb, 0x97d6bde9, 0xcc894043, 0x7767d99e, 0xbdb0e842, 0x8807898b, 0x38e7195b, 0xdb79c8ee, 0x47a17c0a, 0xe97c420f, 0xc9f8841e, 0x00000000, 0x83098086, 0x48322bed, 0xac1e1170, 0x4e6c5a72, 0xfbfd0eff, 0x560f8538, 0x1e3daed5, 0x27362d39, 0x640a0fd9, 0x21685ca6, 0xd19b5b54, 0x3a24362e, 0xb10c0a67, 0x0f9357e7, 0xd2b4ee96, 0x9e1b9b91, 0x4f80c0c5, 0xa261dc20, 0x695a774b, 0x161c121a, 0x0ae293ba, 0xe5c0a02a, 0x433c22e0, 0x1d121b17, 0x0b0e090d, 0xadf28bc7, 0xb92db6a8, 0xc8141ea9, 0x8557f119, 0x4caf7507, 0xbbee99dd, 0xfda37f60, 0x9ff70126, 0xbc5c72f5, 0xc544663b, 0x345bfb7e, 0x768b4329, 0xdccb23c6, 0x68b6edfc, 0x63b8e4f1, 0xcad731dc, 0x10426385, 0x40139722, 0x2084c611, 0x7d854a24, 0xf8d2bb3d, 0x11aef932, 0x6dc729a1, 0x4b1d9e2f, 0xf3dcb230, 0xec0d8652, 0xd077c1e3, 0x6c2bb316, 0x99a970b9, 0xfa119448, 0x2247e964, 0xc4a8fc8c, 0x1aa0f03f, 0xd8567d2c, 0xef223390, 0xc787494e, 0xc1d938d1, 0xfe8ccaa2, 0x3698d40b, 0xcfa6f581, 0x28a57ade, 0x26dab78e, 0xa43fadbf, 0xe42c3a9d, 0x0d507892, 0x9b6a5fcc, 0x62547e46, 0xc2f68d13, 0xe890d8b8, 0x5e2e39f7, 0xf582c3af, 0xbe9f5d80, 0x7c69d093, 0xa96fd52d, 0xb3cf2512, 0x3bc8ac99, 0xa710187d, 0x6ee89c63, 0x7bdb3bbb, 0x09cd2678, 0xf46e5918, 0x01ec9ab7, 0xa8834f9a, 0x65e6956e, 0x7eaaffe6, 0x0821bccf, 0xe6ef15e8, 0xd9bae79b, 0xce4a6f36, 0xd4ea9f09, 0xd629b07c, 0xaf31a4b2, 0x312a3f23, 0x30c6a594, 0xc035a266, 0x37744ebc, 0xa6fc82ca, 0xb0e090d0, 0x1533a7d8, 0x4af10498, 0xf741ecda, 0x0e7fcd50, 0x2f1791f6, 0x8d764dd6, 0x4d43efb0, 0x54ccaa4d, 0xdfe49604, 0xe39ed1b5, 0x1b4c6a88, 0xb8c12c1f, 0x7f466551, 0x049d5eea, 0x5d018c35, 0x73fa8774, 0x2efb0b41, 0x5ab3671d, 0x5292dbd2, 0x33e91056, 0x136dd647, 0x8c9ad761, 0x7a37a10c, 0x8e59f814, 0x89eb133c, 0xeecea927, 0x35b761c9, 0xede11ce5, 0x3c7a47b1, 0x599cd2df, 0x3f55f273, 0x791814ce, 0xbf73c737, 0xea53f7cd, 0x5b5ffdaa, 0x14df3d6f, 0x867844db, 0x81caaff3, 0x3eb968c4, 0x2c382434, 0x5fc2a340, 0x72161dc3, 0x0cbce225, 0x8b283c49, 0x41ff0d95, 0x7139a801, 0xde080cb3, 0x9cd8b4e4, 0x906456c1, 0x617bcb84, 0x70d532b6, 0x74486c5c, 0x42d0b857]);
        T7 = new Uint32Array([0xa75051f4, 0x65537e41, 0xa4c31a17, 0x5e963a27, 0x6bcb3bab, 0x45f11f9d, 0x58abacfa, 0x03934be3, 0xfa552030, 0x6df6ad76, 0x769188cc, 0x4c25f502, 0xd7fc4fe5, 0xcbd7c52a, 0x44802635, 0xa38fb562, 0x5a49deb1, 0x1b6725ba, 0x0e9845ea, 0xc0e15dfe, 0x7502c32f, 0xf012814c, 0x97a38d46, 0xf9c66bd3, 0x5fe7038f, 0x9c951592, 0x7aebbf6d, 0x59da9552, 0x832dd4be, 0x21d35874, 0x692949e0, 0xc8448ec9, 0x896a75c2, 0x7978f48e, 0x3e6b9958, 0x71dd27b9, 0x4fb6bee1, 0xad17f088, 0xac66c920, 0x3ab47dce, 0x4a1863df, 0x3182e51a, 0x33609751, 0x7f456253, 0x77e0b164, 0xae84bb6b, 0xa01cfe81, 0x2b94f908, 0x68587048, 0xfd198f45, 0x6c8794de, 0xf8b7527b, 0xd323ab73, 0x02e2724b, 0x8f57e31f, 0xab2a6655, 0x2807b2eb, 0xc2032fb5, 0x7b9a86c5, 0x08a5d337, 0x87f23028, 0xa5b223bf, 0x6aba0203, 0x825ced16, 0x1c2b8acf, 0xb492a779, 0xf2f0f307, 0xe2a14e69, 0xf4cd65da, 0xbed50605, 0x621fd134, 0xfe8ac4a6, 0x539d342e, 0x55a0a2f3, 0xe132058a, 0xeb75a4f6, 0xec390b83, 0xefaa4060, 0x9f065e71, 0x1051bd6e, 0x8af93e21, 0x063d96dd, 0x05aedd3e, 0xbd464de6, 0x8db59154, 0x5d0571c4, 0xd46f0406, 0x15ff6050, 0xfb241998, 0xe997d6bd, 0x43cc8940, 0x9e7767d9, 0x42bdb0e8, 0x8b880789, 0x5b38e719, 0xeedb79c8, 0x0a47a17c, 0x0fe97c42, 0x1ec9f884, 0x00000000, 0x86830980, 0xed48322b, 0x70ac1e11, 0x724e6c5a, 0xfffbfd0e, 0x38560f85, 0xd51e3dae, 0x3927362d, 0xd9640a0f, 0xa621685c, 0x54d19b5b, 0x2e3a2436, 0x67b10c0a, 0xe70f9357, 0x96d2b4ee, 0x919e1b9b, 0xc54f80c0, 0x20a261dc, 0x4b695a77, 0x1a161c12, 0xba0ae293, 0x2ae5c0a0, 0xe0433c22, 0x171d121b, 0x0d0b0e09, 0xc7adf28b, 0xa8b92db6, 0xa9c8141e, 0x198557f1, 0x074caf75, 0xddbbee99, 0x60fda37f, 0x269ff701, 0xf5bc5c72, 0x3bc54466, 0x7e345bfb, 0x29768b43, 0xc6dccb23, 0xfc68b6ed, 0xf163b8e4, 0xdccad731, 0x85104263, 0x22401397, 0x112084c6, 0x247d854a, 0x3df8d2bb, 0x3211aef9, 0xa16dc729, 0x2f4b1d9e, 0x30f3dcb2, 0x52ec0d86, 0xe3d077c1, 0x166c2bb3, 0xb999a970, 0x48fa1194, 0x642247e9, 0x8cc4a8fc, 0x3f1aa0f0, 0x2cd8567d, 0x90ef2233, 0x4ec78749, 0xd1c1d938, 0xa2fe8cca, 0x0b3698d4, 0x81cfa6f5, 0xde28a57a, 0x8e26dab7, 0xbfa43fad, 0x9de42c3a, 0x920d5078, 0xcc9b6a5f, 0x4662547e, 0x13c2f68d, 0xb8e890d8, 0xf75e2e39, 0xaff582c3, 0x80be9f5d, 0x937c69d0, 0x2da96fd5, 0x12b3cf25, 0x993bc8ac, 0x7da71018, 0x636ee89c, 0xbb7bdb3b, 0x7809cd26, 0x18f46e59, 0xb701ec9a, 0x9aa8834f, 0x6e65e695, 0xe67eaaff, 0xcf0821bc, 0xe8e6ef15, 0x9bd9bae7, 0x36ce4a6f, 0x09d4ea9f, 0x7cd629b0, 0xb2af31a4, 0x23312a3f, 0x9430c6a5, 0x66c035a2, 0xbc37744e, 0xcaa6fc82, 0xd0b0e090, 0xd81533a7, 0x984af104, 0xdaf741ec, 0x500e7fcd, 0xf62f1791, 0xd68d764d, 0xb04d43ef, 0x4d54ccaa, 0x04dfe496, 0xb5e39ed1, 0x881b4c6a, 0x1fb8c12c, 0x517f4665, 0xea049d5e, 0x355d018c, 0x7473fa87, 0x412efb0b, 0x1d5ab367, 0xd25292db, 0x5633e910, 0x47136dd6, 0x618c9ad7, 0x0c7a37a1, 0x148e59f8, 0x3c89eb13, 0x27eecea9, 0xc935b761, 0xe5ede11c, 0xb13c7a47, 0xdf599cd2, 0x733f55f2, 0xce791814, 0x37bf73c7, 0xcdea53f7, 0xaa5b5ffd, 0x6f14df3d, 0xdb867844, 0xf381caaf, 0xc43eb968, 0x342c3824, 0x405fc2a3, 0xc372161d, 0x250cbce2, 0x498b283c, 0x9541ff0d, 0x017139a8, 0xb3de080c, 0xe49cd8b4, 0xc1906456, 0x84617bcb, 0xb670d532, 0x5c74486c, 0x5742d0b8]);
        T8 = new Uint32Array([0xf4a75051, 0x4165537e, 0x17a4c31a, 0x275e963a, 0xab6bcb3b, 0x9d45f11f, 0xfa58abac, 0xe303934b, 0x30fa5520, 0x766df6ad, 0xcc769188, 0x024c25f5, 0xe5d7fc4f, 0x2acbd7c5, 0x35448026, 0x62a38fb5, 0xb15a49de, 0xba1b6725, 0xea0e9845, 0xfec0e15d, 0x2f7502c3, 0x4cf01281, 0x4697a38d, 0xd3f9c66b, 0x8f5fe703, 0x929c9515, 0x6d7aebbf, 0x5259da95, 0xbe832dd4, 0x7421d358, 0xe0692949, 0xc9c8448e, 0xc2896a75, 0x8e7978f4, 0x583e6b99, 0xb971dd27, 0xe14fb6be, 0x88ad17f0, 0x20ac66c9, 0xce3ab47d, 0xdf4a1863, 0x1a3182e5, 0x51336097, 0x537f4562, 0x6477e0b1, 0x6bae84bb, 0x81a01cfe, 0x082b94f9, 0x48685870, 0x45fd198f, 0xde6c8794, 0x7bf8b752, 0x73d323ab, 0x4b02e272, 0x1f8f57e3, 0x55ab2a66, 0xeb2807b2, 0xb5c2032f, 0xc57b9a86, 0x3708a5d3, 0x2887f230, 0xbfa5b223, 0x036aba02, 0x16825ced, 0xcf1c2b8a, 0x79b492a7, 0x07f2f0f3, 0x69e2a14e, 0xdaf4cd65, 0x05bed506, 0x34621fd1, 0xa6fe8ac4, 0x2e539d34, 0xf355a0a2, 0x8ae13205, 0xf6eb75a4, 0x83ec390b, 0x60efaa40, 0x719f065e, 0x6e1051bd, 0x218af93e, 0xdd063d96, 0x3e05aedd, 0xe6bd464d, 0x548db591, 0xc45d0571, 0x06d46f04, 0x5015ff60, 0x98fb2419, 0xbde997d6, 0x4043cc89, 0xd99e7767, 0xe842bdb0, 0x898b8807, 0x195b38e7, 0xc8eedb79, 0x7c0a47a1, 0x420fe97c, 0x841ec9f8, 0x00000000, 0x80868309, 0x2bed4832, 0x1170ac1e, 0x5a724e6c, 0x0efffbfd, 0x8538560f, 0xaed51e3d, 0x2d392736, 0x0fd9640a, 0x5ca62168, 0x5b54d19b, 0x362e3a24, 0x0a67b10c, 0x57e70f93, 0xee96d2b4, 0x9b919e1b, 0xc0c54f80, 0xdc20a261, 0x774b695a, 0x121a161c, 0x93ba0ae2, 0xa02ae5c0, 0x22e0433c, 0x1b171d12, 0x090d0b0e, 0x8bc7adf2, 0xb6a8b92d, 0x1ea9c814, 0xf1198557, 0x75074caf, 0x99ddbbee, 0x7f60fda3, 0x01269ff7, 0x72f5bc5c, 0x663bc544, 0xfb7e345b, 0x4329768b, 0x23c6dccb, 0xedfc68b6, 0xe4f163b8, 0x31dccad7, 0x63851042, 0x97224013, 0xc6112084, 0x4a247d85, 0xbb3df8d2, 0xf93211ae, 0x29a16dc7, 0x9e2f4b1d, 0xb230f3dc, 0x8652ec0d, 0xc1e3d077, 0xb3166c2b, 0x70b999a9, 0x9448fa11, 0xe9642247, 0xfc8cc4a8, 0xf03f1aa0, 0x7d2cd856, 0x3390ef22, 0x494ec787, 0x38d1c1d9, 0xcaa2fe8c, 0xd40b3698, 0xf581cfa6, 0x7ade28a5, 0xb78e26da, 0xadbfa43f, 0x3a9de42c, 0x78920d50, 0x5fcc9b6a, 0x7e466254, 0x8d13c2f6, 0xd8b8e890, 0x39f75e2e, 0xc3aff582, 0x5d80be9f, 0xd0937c69, 0xd52da96f, 0x2512b3cf, 0xac993bc8, 0x187da710, 0x9c636ee8, 0x3bbb7bdb, 0x267809cd, 0x5918f46e, 0x9ab701ec, 0x4f9aa883, 0x956e65e6, 0xffe67eaa, 0xbccf0821, 0x15e8e6ef, 0xe79bd9ba, 0x6f36ce4a, 0x9f09d4ea, 0xb07cd629, 0xa4b2af31, 0x3f23312a, 0xa59430c6, 0xa266c035, 0x4ebc3774, 0x82caa6fc, 0x90d0b0e0, 0xa7d81533, 0x04984af1, 0xecdaf741, 0xcd500e7f, 0x91f62f17, 0x4dd68d76, 0xefb04d43, 0xaa4d54cc, 0x9604dfe4, 0xd1b5e39e, 0x6a881b4c, 0x2c1fb8c1, 0x65517f46, 0x5eea049d, 0x8c355d01, 0x877473fa, 0x0b412efb, 0x671d5ab3, 0xdbd25292, 0x105633e9, 0xd647136d, 0xd7618c9a, 0xa10c7a37, 0xf8148e59, 0x133c89eb, 0xa927eece, 0x61c935b7, 0x1ce5ede1, 0x47b13c7a, 0xd2df599c, 0xf2733f55, 0x14ce7918, 0xc737bf73, 0xf7cdea53, 0xfdaa5b5f, 0x3d6f14df, 0x44db8678, 0xaff381ca, 0x68c43eb9, 0x24342c38, 0xa3405fc2, 0x1dc37216, 0xe2250cbc, 0x3c498b28, 0x0d9541ff, 0xa8017139, 0x0cb3de08, 0xb4e49cd8, 0x56c19064, 0xcb84617b, 0x32b670d5, 0x6c5c7448, 0xb85742d0]);
        U1 = new Uint32Array([0x00000000, 0x0e090d0b, 0x1c121a16, 0x121b171d, 0x3824342c, 0x362d3927, 0x24362e3a, 0x2a3f2331, 0x70486858, 0x7e416553, 0x6c5a724e, 0x62537f45, 0x486c5c74, 0x4665517f, 0x547e4662, 0x5a774b69, 0xe090d0b0, 0xee99ddbb, 0xfc82caa6, 0xf28bc7ad, 0xd8b4e49c, 0xd6bde997, 0xc4a6fe8a, 0xcaaff381, 0x90d8b8e8, 0x9ed1b5e3, 0x8ccaa2fe, 0x82c3aff5, 0xa8fc8cc4, 0xa6f581cf, 0xb4ee96d2, 0xbae79bd9, 0xdb3bbb7b, 0xd532b670, 0xc729a16d, 0xc920ac66, 0xe31f8f57, 0xed16825c, 0xff0d9541, 0xf104984a, 0xab73d323, 0xa57ade28, 0xb761c935, 0xb968c43e, 0x9357e70f, 0x9d5eea04, 0x8f45fd19, 0x814cf012, 0x3bab6bcb, 0x35a266c0, 0x27b971dd, 0x29b07cd6, 0x038f5fe7, 0x0d8652ec, 0x1f9d45f1, 0x119448fa, 0x4be30393, 0x45ea0e98, 0x57f11985, 0x59f8148e, 0x73c737bf, 0x7dce3ab4, 0x6fd52da9, 0x61dc20a2, 0xad766df6, 0xa37f60fd, 0xb16477e0, 0xbf6d7aeb, 0x955259da, 0x9b5b54d1, 0x894043cc, 0x87494ec7, 0xdd3e05ae, 0xd33708a5, 0xc12c1fb8, 0xcf2512b3, 0xe51a3182, 0xeb133c89, 0xf9082b94, 0xf701269f, 0x4de6bd46, 0x43efb04d, 0x51f4a750, 0x5ffdaa5b, 0x75c2896a, 0x7bcb8461, 0x69d0937c, 0x67d99e77, 0x3daed51e, 0x33a7d815, 0x21bccf08, 0x2fb5c203, 0x058ae132, 0x0b83ec39, 0x1998fb24, 0x1791f62f, 0x764dd68d, 0x7844db86, 0x6a5fcc9b, 0x6456c190, 0x4e69e2a1, 0x4060efaa, 0x527bf8b7, 0x5c72f5bc, 0x0605bed5, 0x080cb3de, 0x1a17a4c3, 0x141ea9c8, 0x3e218af9, 0x302887f2, 0x223390ef, 0x2c3a9de4, 0x96dd063d, 0x98d40b36, 0x8acf1c2b, 0x84c61120, 0xaef93211, 0xa0f03f1a, 0xb2eb2807, 0xbce2250c, 0xe6956e65, 0xe89c636e, 0xfa877473, 0xf48e7978, 0xdeb15a49, 0xd0b85742, 0xc2a3405f, 0xccaa4d54, 0x41ecdaf7, 0x4fe5d7fc, 0x5dfec0e1, 0x53f7cdea, 0x79c8eedb, 0x77c1e3d0, 0x65daf4cd, 0x6bd3f9c6, 0x31a4b2af, 0x3fadbfa4, 0x2db6a8b9, 0x23bfa5b2, 0x09808683, 0x07898b88, 0x15929c95, 0x1b9b919e, 0xa17c0a47, 0xaf75074c, 0xbd6e1051, 0xb3671d5a, 0x99583e6b, 0x97513360, 0x854a247d, 0x8b432976, 0xd134621f, 0xdf3d6f14, 0xcd267809, 0xc32f7502, 0xe9105633, 0xe7195b38, 0xf5024c25, 0xfb0b412e, 0x9ad7618c, 0x94de6c87, 0x86c57b9a, 0x88cc7691, 0xa2f355a0, 0xacfa58ab, 0xbee14fb6, 0xb0e842bd, 0xea9f09d4, 0xe49604df, 0xf68d13c2, 0xf8841ec9, 0xd2bb3df8, 0xdcb230f3, 0xcea927ee, 0xc0a02ae5, 0x7a47b13c, 0x744ebc37, 0x6655ab2a, 0x685ca621, 0x42638510, 0x4c6a881b, 0x5e719f06, 0x5078920d, 0x0a0fd964, 0x0406d46f, 0x161dc372, 0x1814ce79, 0x322bed48, 0x3c22e043, 0x2e39f75e, 0x2030fa55, 0xec9ab701, 0xe293ba0a, 0xf088ad17, 0xfe81a01c, 0xd4be832d, 0xdab78e26, 0xc8ac993b, 0xc6a59430, 0x9cd2df59, 0x92dbd252, 0x80c0c54f, 0x8ec9c844, 0xa4f6eb75, 0xaaffe67e, 0xb8e4f163, 0xb6edfc68, 0x0c0a67b1, 0x02036aba, 0x10187da7, 0x1e1170ac, 0x342e539d, 0x3a275e96, 0x283c498b, 0x26354480, 0x7c420fe9, 0x724b02e2, 0x605015ff, 0x6e5918f4, 0x44663bc5, 0x4a6f36ce, 0x587421d3, 0x567d2cd8, 0x37a10c7a, 0x39a80171, 0x2bb3166c, 0x25ba1b67, 0x0f853856, 0x018c355d, 0x13972240, 0x1d9e2f4b, 0x47e96422, 0x49e06929, 0x5bfb7e34, 0x55f2733f, 0x7fcd500e, 0x71c45d05, 0x63df4a18, 0x6dd64713, 0xd731dcca, 0xd938d1c1, 0xcb23c6dc, 0xc52acbd7, 0xef15e8e6, 0xe11ce5ed, 0xf307f2f0, 0xfd0efffb, 0xa779b492, 0xa970b999, 0xbb6bae84, 0xb562a38f, 0x9f5d80be, 0x91548db5, 0x834f9aa8, 0x8d4697a3]);
        U2 = new Uint32Array([0x00000000, 0x0b0e090d, 0x161c121a, 0x1d121b17, 0x2c382434, 0x27362d39, 0x3a24362e, 0x312a3f23, 0x58704868, 0x537e4165, 0x4e6c5a72, 0x4562537f, 0x74486c5c, 0x7f466551, 0x62547e46, 0x695a774b, 0xb0e090d0, 0xbbee99dd, 0xa6fc82ca, 0xadf28bc7, 0x9cd8b4e4, 0x97d6bde9, 0x8ac4a6fe, 0x81caaff3, 0xe890d8b8, 0xe39ed1b5, 0xfe8ccaa2, 0xf582c3af, 0xc4a8fc8c, 0xcfa6f581, 0xd2b4ee96, 0xd9bae79b, 0x7bdb3bbb, 0x70d532b6, 0x6dc729a1, 0x66c920ac, 0x57e31f8f, 0x5ced1682, 0x41ff0d95, 0x4af10498, 0x23ab73d3, 0x28a57ade, 0x35b761c9, 0x3eb968c4, 0x0f9357e7, 0x049d5eea, 0x198f45fd, 0x12814cf0, 0xcb3bab6b, 0xc035a266, 0xdd27b971, 0xd629b07c, 0xe7038f5f, 0xec0d8652, 0xf11f9d45, 0xfa119448, 0x934be303, 0x9845ea0e, 0x8557f119, 0x8e59f814, 0xbf73c737, 0xb47dce3a, 0xa96fd52d, 0xa261dc20, 0xf6ad766d, 0xfda37f60, 0xe0b16477, 0xebbf6d7a, 0xda955259, 0xd19b5b54, 0xcc894043, 0xc787494e, 0xaedd3e05, 0xa5d33708, 0xb8c12c1f, 0xb3cf2512, 0x82e51a31, 0x89eb133c, 0x94f9082b, 0x9ff70126, 0x464de6bd, 0x4d43efb0, 0x5051f4a7, 0x5b5ffdaa, 0x6a75c289, 0x617bcb84, 0x7c69d093, 0x7767d99e, 0x1e3daed5, 0x1533a7d8, 0x0821bccf, 0x032fb5c2, 0x32058ae1, 0x390b83ec, 0x241998fb, 0x2f1791f6, 0x8d764dd6, 0x867844db, 0x9b6a5fcc, 0x906456c1, 0xa14e69e2, 0xaa4060ef, 0xb7527bf8, 0xbc5c72f5, 0xd50605be, 0xde080cb3, 0xc31a17a4, 0xc8141ea9, 0xf93e218a, 0xf2302887, 0xef223390, 0xe42c3a9d, 0x3d96dd06, 0x3698d40b, 0x2b8acf1c, 0x2084c611, 0x11aef932, 0x1aa0f03f, 0x07b2eb28, 0x0cbce225, 0x65e6956e, 0x6ee89c63, 0x73fa8774, 0x78f48e79, 0x49deb15a, 0x42d0b857, 0x5fc2a340, 0x54ccaa4d, 0xf741ecda, 0xfc4fe5d7, 0xe15dfec0, 0xea53f7cd, 0xdb79c8ee, 0xd077c1e3, 0xcd65daf4, 0xc66bd3f9, 0xaf31a4b2, 0xa43fadbf, 0xb92db6a8, 0xb223bfa5, 0x83098086, 0x8807898b, 0x9515929c, 0x9e1b9b91, 0x47a17c0a, 0x4caf7507, 0x51bd6e10, 0x5ab3671d, 0x6b99583e, 0x60975133, 0x7d854a24, 0x768b4329, 0x1fd13462, 0x14df3d6f, 0x09cd2678, 0x02c32f75, 0x33e91056, 0x38e7195b, 0x25f5024c, 0x2efb0b41, 0x8c9ad761, 0x8794de6c, 0x9a86c57b, 0x9188cc76, 0xa0a2f355, 0xabacfa58, 0xb6bee14f, 0xbdb0e842, 0xd4ea9f09, 0xdfe49604, 0xc2f68d13, 0xc9f8841e, 0xf8d2bb3d, 0xf3dcb230, 0xeecea927, 0xe5c0a02a, 0x3c7a47b1, 0x37744ebc, 0x2a6655ab, 0x21685ca6, 0x10426385, 0x1b4c6a88, 0x065e719f, 0x0d507892, 0x640a0fd9, 0x6f0406d4, 0x72161dc3, 0x791814ce, 0x48322bed, 0x433c22e0, 0x5e2e39f7, 0x552030fa, 0x01ec9ab7, 0x0ae293ba, 0x17f088ad, 0x1cfe81a0, 0x2dd4be83, 0x26dab78e, 0x3bc8ac99, 0x30c6a594, 0x599cd2df, 0x5292dbd2, 0x4f80c0c5, 0x448ec9c8, 0x75a4f6eb, 0x7eaaffe6, 0x63b8e4f1, 0x68b6edfc, 0xb10c0a67, 0xba02036a, 0xa710187d, 0xac1e1170, 0x9d342e53, 0x963a275e, 0x8b283c49, 0x80263544, 0xe97c420f, 0xe2724b02, 0xff605015, 0xf46e5918, 0xc544663b, 0xce4a6f36, 0xd3587421, 0xd8567d2c, 0x7a37a10c, 0x7139a801, 0x6c2bb316, 0x6725ba1b, 0x560f8538, 0x5d018c35, 0x40139722, 0x4b1d9e2f, 0x2247e964, 0x2949e069, 0x345bfb7e, 0x3f55f273, 0x0e7fcd50, 0x0571c45d, 0x1863df4a, 0x136dd647, 0xcad731dc, 0xc1d938d1, 0xdccb23c6, 0xd7c52acb, 0xe6ef15e8, 0xede11ce5, 0xf0f307f2, 0xfbfd0eff, 0x92a779b4, 0x99a970b9, 0x84bb6bae, 0x8fb562a3, 0xbe9f5d80, 0xb591548d, 0xa8834f9a, 0xa38d4697]);
        U3 = new Uint32Array([0x00000000, 0x0d0b0e09, 0x1a161c12, 0x171d121b, 0x342c3824, 0x3927362d, 0x2e3a2436, 0x23312a3f, 0x68587048, 0x65537e41, 0x724e6c5a, 0x7f456253, 0x5c74486c, 0x517f4665, 0x4662547e, 0x4b695a77, 0xd0b0e090, 0xddbbee99, 0xcaa6fc82, 0xc7adf28b, 0xe49cd8b4, 0xe997d6bd, 0xfe8ac4a6, 0xf381caaf, 0xb8e890d8, 0xb5e39ed1, 0xa2fe8cca, 0xaff582c3, 0x8cc4a8fc, 0x81cfa6f5, 0x96d2b4ee, 0x9bd9bae7, 0xbb7bdb3b, 0xb670d532, 0xa16dc729, 0xac66c920, 0x8f57e31f, 0x825ced16, 0x9541ff0d, 0x984af104, 0xd323ab73, 0xde28a57a, 0xc935b761, 0xc43eb968, 0xe70f9357, 0xea049d5e, 0xfd198f45, 0xf012814c, 0x6bcb3bab, 0x66c035a2, 0x71dd27b9, 0x7cd629b0, 0x5fe7038f, 0x52ec0d86, 0x45f11f9d, 0x48fa1194, 0x03934be3, 0x0e9845ea, 0x198557f1, 0x148e59f8, 0x37bf73c7, 0x3ab47dce, 0x2da96fd5, 0x20a261dc, 0x6df6ad76, 0x60fda37f, 0x77e0b164, 0x7aebbf6d, 0x59da9552, 0x54d19b5b, 0x43cc8940, 0x4ec78749, 0x05aedd3e, 0x08a5d337, 0x1fb8c12c, 0x12b3cf25, 0x3182e51a, 0x3c89eb13, 0x2b94f908, 0x269ff701, 0xbd464de6, 0xb04d43ef, 0xa75051f4, 0xaa5b5ffd, 0x896a75c2, 0x84617bcb, 0x937c69d0, 0x9e7767d9, 0xd51e3dae, 0xd81533a7, 0xcf0821bc, 0xc2032fb5, 0xe132058a, 0xec390b83, 0xfb241998, 0xf62f1791, 0xd68d764d, 0xdb867844, 0xcc9b6a5f, 0xc1906456, 0xe2a14e69, 0xefaa4060, 0xf8b7527b, 0xf5bc5c72, 0xbed50605, 0xb3de080c, 0xa4c31a17, 0xa9c8141e, 0x8af93e21, 0x87f23028, 0x90ef2233, 0x9de42c3a, 0x063d96dd, 0x0b3698d4, 0x1c2b8acf, 0x112084c6, 0x3211aef9, 0x3f1aa0f0, 0x2807b2eb, 0x250cbce2, 0x6e65e695, 0x636ee89c, 0x7473fa87, 0x7978f48e, 0x5a49deb1, 0x5742d0b8, 0x405fc2a3, 0x4d54ccaa, 0xdaf741ec, 0xd7fc4fe5, 0xc0e15dfe, 0xcdea53f7, 0xeedb79c8, 0xe3d077c1, 0xf4cd65da, 0xf9c66bd3, 0xb2af31a4, 0xbfa43fad, 0xa8b92db6, 0xa5b223bf, 0x86830980, 0x8b880789, 0x9c951592, 0x919e1b9b, 0x0a47a17c, 0x074caf75, 0x1051bd6e, 0x1d5ab367, 0x3e6b9958, 0x33609751, 0x247d854a, 0x29768b43, 0x621fd134, 0x6f14df3d, 0x7809cd26, 0x7502c32f, 0x5633e910, 0x5b38e719, 0x4c25f502, 0x412efb0b, 0x618c9ad7, 0x6c8794de, 0x7b9a86c5, 0x769188cc, 0x55a0a2f3, 0x58abacfa, 0x4fb6bee1, 0x42bdb0e8, 0x09d4ea9f, 0x04dfe496, 0x13c2f68d, 0x1ec9f884, 0x3df8d2bb, 0x30f3dcb2, 0x27eecea9, 0x2ae5c0a0, 0xb13c7a47, 0xbc37744e, 0xab2a6655, 0xa621685c, 0x85104263, 0x881b4c6a, 0x9f065e71, 0x920d5078, 0xd9640a0f, 0xd46f0406, 0xc372161d, 0xce791814, 0xed48322b, 0xe0433c22, 0xf75e2e39, 0xfa552030, 0xb701ec9a, 0xba0ae293, 0xad17f088, 0xa01cfe81, 0x832dd4be, 0x8e26dab7, 0x993bc8ac, 0x9430c6a5, 0xdf599cd2, 0xd25292db, 0xc54f80c0, 0xc8448ec9, 0xeb75a4f6, 0xe67eaaff, 0xf163b8e4, 0xfc68b6ed, 0x67b10c0a, 0x6aba0203, 0x7da71018, 0x70ac1e11, 0x539d342e, 0x5e963a27, 0x498b283c, 0x44802635, 0x0fe97c42, 0x02e2724b, 0x15ff6050, 0x18f46e59, 0x3bc54466, 0x36ce4a6f, 0x21d35874, 0x2cd8567d, 0x0c7a37a1, 0x017139a8, 0x166c2bb3, 0x1b6725ba, 0x38560f85, 0x355d018c, 0x22401397, 0x2f4b1d9e, 0x642247e9, 0x692949e0, 0x7e345bfb, 0x733f55f2, 0x500e7fcd, 0x5d0571c4, 0x4a1863df, 0x47136dd6, 0xdccad731, 0xd1c1d938, 0xc6dccb23, 0xcbd7c52a, 0xe8e6ef15, 0xe5ede11c, 0xf2f0f307, 0xfffbfd0e, 0xb492a779, 0xb999a970, 0xae84bb6b, 0xa38fb562, 0x80be9f5d, 0x8db59154, 0x9aa8834f, 0x97a38d46]);
        U4 = new Uint32Array([0x00000000, 0x090d0b0e, 0x121a161c, 0x1b171d12, 0x24342c38, 0x2d392736, 0x362e3a24, 0x3f23312a, 0x48685870, 0x4165537e, 0x5a724e6c, 0x537f4562, 0x6c5c7448, 0x65517f46, 0x7e466254, 0x774b695a, 0x90d0b0e0, 0x99ddbbee, 0x82caa6fc, 0x8bc7adf2, 0xb4e49cd8, 0xbde997d6, 0xa6fe8ac4, 0xaff381ca, 0xd8b8e890, 0xd1b5e39e, 0xcaa2fe8c, 0xc3aff582, 0xfc8cc4a8, 0xf581cfa6, 0xee96d2b4, 0xe79bd9ba, 0x3bbb7bdb, 0x32b670d5, 0x29a16dc7, 0x20ac66c9, 0x1f8f57e3, 0x16825ced, 0x0d9541ff, 0x04984af1, 0x73d323ab, 0x7ade28a5, 0x61c935b7, 0x68c43eb9, 0x57e70f93, 0x5eea049d, 0x45fd198f, 0x4cf01281, 0xab6bcb3b, 0xa266c035, 0xb971dd27, 0xb07cd629, 0x8f5fe703, 0x8652ec0d, 0x9d45f11f, 0x9448fa11, 0xe303934b, 0xea0e9845, 0xf1198557, 0xf8148e59, 0xc737bf73, 0xce3ab47d, 0xd52da96f, 0xdc20a261, 0x766df6ad, 0x7f60fda3, 0x6477e0b1, 0x6d7aebbf, 0x5259da95, 0x5b54d19b, 0x4043cc89, 0x494ec787, 0x3e05aedd, 0x3708a5d3, 0x2c1fb8c1, 0x2512b3cf, 0x1a3182e5, 0x133c89eb, 0x082b94f9, 0x01269ff7, 0xe6bd464d, 0xefb04d43, 0xf4a75051, 0xfdaa5b5f, 0xc2896a75, 0xcb84617b, 0xd0937c69, 0xd99e7767, 0xaed51e3d, 0xa7d81533, 0xbccf0821, 0xb5c2032f, 0x8ae13205, 0x83ec390b, 0x98fb2419, 0x91f62f17, 0x4dd68d76, 0x44db8678, 0x5fcc9b6a, 0x56c19064, 0x69e2a14e, 0x60efaa40, 0x7bf8b752, 0x72f5bc5c, 0x05bed506, 0x0cb3de08, 0x17a4c31a, 0x1ea9c814, 0x218af93e, 0x2887f230, 0x3390ef22, 0x3a9de42c, 0xdd063d96, 0xd40b3698, 0xcf1c2b8a, 0xc6112084, 0xf93211ae, 0xf03f1aa0, 0xeb2807b2, 0xe2250cbc, 0x956e65e6, 0x9c636ee8, 0x877473fa, 0x8e7978f4, 0xb15a49de, 0xb85742d0, 0xa3405fc2, 0xaa4d54cc, 0xecdaf741, 0xe5d7fc4f, 0xfec0e15d, 0xf7cdea53, 0xc8eedb79, 0xc1e3d077, 0xdaf4cd65, 0xd3f9c66b, 0xa4b2af31, 0xadbfa43f, 0xb6a8b92d, 0xbfa5b223, 0x80868309, 0x898b8807, 0x929c9515, 0x9b919e1b, 0x7c0a47a1, 0x75074caf, 0x6e1051bd, 0x671d5ab3, 0x583e6b99, 0x51336097, 0x4a247d85, 0x4329768b, 0x34621fd1, 0x3d6f14df, 0x267809cd, 0x2f7502c3, 0x105633e9, 0x195b38e7, 0x024c25f5, 0x0b412efb, 0xd7618c9a, 0xde6c8794, 0xc57b9a86, 0xcc769188, 0xf355a0a2, 0xfa58abac, 0xe14fb6be, 0xe842bdb0, 0x9f09d4ea, 0x9604dfe4, 0x8d13c2f6, 0x841ec9f8, 0xbb3df8d2, 0xb230f3dc, 0xa927eece, 0xa02ae5c0, 0x47b13c7a, 0x4ebc3774, 0x55ab2a66, 0x5ca62168, 0x63851042, 0x6a881b4c, 0x719f065e, 0x78920d50, 0x0fd9640a, 0x06d46f04, 0x1dc37216, 0x14ce7918, 0x2bed4832, 0x22e0433c, 0x39f75e2e, 0x30fa5520, 0x9ab701ec, 0x93ba0ae2, 0x88ad17f0, 0x81a01cfe, 0xbe832dd4, 0xb78e26da, 0xac993bc8, 0xa59430c6, 0xd2df599c, 0xdbd25292, 0xc0c54f80, 0xc9c8448e, 0xf6eb75a4, 0xffe67eaa, 0xe4f163b8, 0xedfc68b6, 0x0a67b10c, 0x036aba02, 0x187da710, 0x1170ac1e, 0x2e539d34, 0x275e963a, 0x3c498b28, 0x35448026, 0x420fe97c, 0x4b02e272, 0x5015ff60, 0x5918f46e, 0x663bc544, 0x6f36ce4a, 0x7421d358, 0x7d2cd856, 0xa10c7a37, 0xa8017139, 0xb3166c2b, 0xba1b6725, 0x8538560f, 0x8c355d01, 0x97224013, 0x9e2f4b1d, 0xe9642247, 0xe0692949, 0xfb7e345b, 0xf2733f55, 0xcd500e7f, 0xc45d0571, 0xdf4a1863, 0xd647136d, 0x31dccad7, 0x38d1c1d9, 0x23c6dccb, 0x2acbd7c5, 0x15e8e6ef, 0x1ce5ede1, 0x07f2f0f3, 0x0efffbfd, 0x79b492a7, 0x70b999a9, 0x6bae84bb, 0x62a38fb5, 0x5d80be9f, 0x548db591, 0x4f9aa883, 0x4697a38d]);
        function AES() {
            if (this.ρσ_object_id === undefined) Object.defineProperty(this, "ρσ_object_id", {"value":++ρσ_object_counter});
            AES.prototype.__init__.apply(this, arguments);
        }
        AES.prototype.__init__ = function __init__(key) {
            var self = this;
            var rounds, round_key_count, KC, tk, index, rconpointer, t, tt, i, r, c;
            self.working_mem = ρσ_list_decorate([ new Uint32Array(4), new Uint32Array(4) ]);
            rounds = number_of_rounds[ρσ_bound_index(key.length, number_of_rounds)];
            if (!rounds) {
                throw new ValueError("invalid key size (must be length 16, 24 or 32)");
            }
            self._Ke = [];
            self._Kd = [];
            for (var i = 0; i <= rounds; i++) {
                self._Ke.push(new Uint32Array(4));
                self._Kd.push(new Uint32Array(4));
            }
            round_key_count = (rounds + 1) * 4;
            KC = key.length / 4;
            tk = new Uint32Array(KC);
            convert_to_int32(key, tk);
            index = 0;
            for (var i = 0; i < KC; i++) {
                index = i >> 2;
                (ρσ_expr_temp = (ρσ_expr_temp = self._Ke)[(typeof index === "number" && index < 0) ? ρσ_expr_temp.length + index : index])[ρσ_bound_index(i % 4, ρσ_expr_temp)] = tk[(typeof i === "number" && i < 0) ? tk.length + i : i];
                (ρσ_expr_temp = (ρσ_expr_temp = self._Kd)[ρσ_bound_index(rounds - index, ρσ_expr_temp)])[ρσ_bound_index(i % 4, ρσ_expr_temp)] = tk[(typeof i === "number" && i < 0) ? tk.length + i : i];
            }
            rconpointer = 0;
            t = KC;
            while (t < round_key_count) {
                tt = tk[ρσ_bound_index(KC - 1, tk)];
                tk[0] ^= S[ρσ_bound_index(tt >> 16 & 255, S)] << 24 ^ S[ρσ_bound_index(tt >> 8 & 255, S)] << 16 ^ S[ρσ_bound_index(tt & 255, S)] << 8 ^ S[ρσ_bound_index(tt >> 24 & 255, S)] ^ rcon[(typeof rconpointer === "number" && rconpointer < 0) ? rcon.length + rconpointer : rconpointer] << 24;
                rconpointer += 1;
                if ((KC !== 8 && (typeof KC !== "object" || ρσ_not_equals(KC, 8)))) {
                    for (var i = 1; i < KC; i++) {
                        tk[(typeof i === "number" && i < 0) ? tk.length + i : i] ^= tk[ρσ_bound_index(i - 1, tk)];
                    }
                } else {
                    for (var i = 1; i < (KC / 2); i++) {
                        tk[(typeof i === "number" && i < 0) ? tk.length + i : i] ^= tk[ρσ_bound_index(i - 1, tk)];
                    }
                    tt = tk[ρσ_bound_index(KC / 2 - 1, tk)];
                    tk[ρσ_bound_index(KC / 2, tk)] ^= S[ρσ_bound_index(tt & 255, S)] ^ S[ρσ_bound_index(tt >> 8 & 255, S)] << 8 ^ S[ρσ_bound_index(tt >> 16 & 255, S)] << 16 ^ S[ρσ_bound_index(tt >> 24 & 255, S)] << 24;
                    for (var i = (KC / 2) + 1; i < KC; i++) {
                        tk[(typeof i === "number" && i < 0) ? tk.length + i : i] ^= tk[ρσ_bound_index(i - 1, tk)];
                    }
                }
                i = 0;
                while (i < KC && t < round_key_count) {
                    r = t >> 2;
                    c = t % 4;
                    (ρσ_expr_temp = (ρσ_expr_temp = self._Ke)[(typeof r === "number" && r < 0) ? ρσ_expr_temp.length + r : r])[(typeof c === "number" && c < 0) ? ρσ_expr_temp.length + c : c] = tk[(typeof i === "number" && i < 0) ? tk.length + i : i];
                    (ρσ_expr_temp = (ρσ_expr_temp = self._Kd)[ρσ_bound_index(rounds - r, ρσ_expr_temp)])[(typeof c === "number" && c < 0) ? ρσ_expr_temp.length + c : c] = tk[ρσ_bound_index(i++, tk)];
                    t += 1;
                }
            }
            for (var r = 1; r < rounds; r++) {
                for (var c = 0; c < 4; c++) {
                    tt = (ρσ_expr_temp = (ρσ_expr_temp = self._Kd)[(typeof r === "number" && r < 0) ? ρσ_expr_temp.length + r : r])[(typeof c === "number" && c < 0) ? ρσ_expr_temp.length + c : c];
                    (ρσ_expr_temp = (ρσ_expr_temp = self._Kd)[(typeof r === "number" && r < 0) ? ρσ_expr_temp.length + r : r])[(typeof c === "number" && c < 0) ? ρσ_expr_temp.length + c : c] = U1[ρσ_bound_index(tt >> 24 & 255, U1)] ^ U2[ρσ_bound_index(tt >> 16 & 255, U2)] ^ U3[ρσ_bound_index(tt >> 8 & 255, U3)] ^ U4[ρσ_bound_index(tt & 255, U4)];
                }
            }
        };
        if (!AES.prototype.__init__.__argnames__) Object.defineProperties(AES.prototype.__init__, {
            __argnames__ : {value: ["key"]},
            __module__ : {value: "aes"}
        });
        AES.__argnames__ = AES.prototype.__init__.__argnames__;
        AES.__handles_kwarg_interpolation__ = AES.prototype.__init__.__handles_kwarg_interpolation__;
        AES.prototype._crypt = function _crypt(ciphertext, offset, encrypt) {
            var self = this;
            var R1, R2, R3, R4, o1, o3, SB, K, rounds, a, t, tt;
            if (encrypt) {
                R1 = T1;
                R2 = T2;
                R3 = T3;
                R4 = T4;
                o1 = 1;
                o3 = 3;
                SB = S;
                K = self._Ke;
            } else {
                R1 = T5;
                R2 = T6;
                R3 = T7;
                R4 = T8;
                o1 = 3;
                o3 = 1;
                SB = Si;
                K = self._Kd;
            }
            rounds = K.length - 1;
            a = self.working_mem[0];
            t = self.working_mem[1];
            for (var i = 0; i < 4; i++) {
                t[(typeof i === "number" && i < 0) ? t.length + i : i] ^= (ρσ_expr_temp = K[0])[(typeof i === "number" && i < 0) ? ρσ_expr_temp.length + i : i];
            }
            for (var r = 1; r < rounds; r++) {
                for (var i = 0; i < 4; i++) {
                    a[(typeof i === "number" && i < 0) ? a.length + i : i] = R1[ρσ_bound_index(t[(typeof i === "number" && i < 0) ? t.length + i : i] >> 24 & 255, R1)] ^ R2[ρσ_bound_index(t[ρσ_bound_index((i + o1) % 4, t)] >> 16 & 255, R2)] ^ R3[ρσ_bound_index(t[ρσ_bound_index((i + 2) % 4, t)] >> 8 & 255, R3)] ^ R4[ρσ_bound_index(t[ρσ_bound_index((i + o3) % 4, t)] & 255, R4)] ^ (ρσ_expr_temp = K[(typeof r === "number" && r < 0) ? K.length + r : r])[(typeof i === "number" && i < 0) ? ρσ_expr_temp.length + i : i];
                }
                t.set(a);
            }
            for (var i = 0; i < 4; i++) {
                tt = (ρσ_expr_temp = K[(typeof rounds === "number" && rounds < 0) ? K.length + rounds : rounds])[(typeof i === "number" && i < 0) ? ρσ_expr_temp.length + i : i];
                ciphertext[ρσ_bound_index(offset + 4 * i, ciphertext)] = (SB[ρσ_bound_index(t[(typeof i === "number" && i < 0) ? t.length + i : i] >> 24 & 255, SB)] ^ tt >> 24) & 255;
                ciphertext[ρσ_bound_index(offset + 4 * i + 1, ciphertext)] = (SB[ρσ_bound_index(t[ρσ_bound_index((i + o1) % 4, t)] >> 16 & 255, SB)] ^ tt >> 16) & 255;
                ciphertext[ρσ_bound_index(offset + 4 * i + 2, ciphertext)] = (SB[ρσ_bound_index(t[ρσ_bound_index((i + 2) % 4, t)] >> 8 & 255, SB)] ^ tt >> 8) & 255;
                ciphertext[ρσ_bound_index(offset + 4 * i + 3, ciphertext)] = (SB[ρσ_bound_index(t[ρσ_bound_index((i + o3) % 4, t)] & 255, SB)] ^ tt) & 255;
            }
        };
        if (!AES.prototype._crypt.__argnames__) Object.defineProperties(AES.prototype._crypt, {
            __argnames__ : {value: ["ciphertext", "offset", "encrypt"]},
            __module__ : {value: "aes"}
        });
        AES.prototype.encrypt = function encrypt(plaintext, ciphertext, offset) {
            var self = this;
            convert_to_int32(plaintext, self.working_mem[1], offset, 16);
            return self._crypt(ciphertext, offset, true);
        };
        if (!AES.prototype.encrypt.__argnames__) Object.defineProperties(AES.prototype.encrypt, {
            __argnames__ : {value: ["plaintext", "ciphertext", "offset"]},
            __module__ : {value: "aes"}
        });
        AES.prototype.encrypt32 = function encrypt32(plaintext, ciphertext, offset) {
            var self = this;
            self.working_mem[1].set(plaintext);
            return self._crypt(ciphertext, offset, true);
        };
        if (!AES.prototype.encrypt32.__argnames__) Object.defineProperties(AES.prototype.encrypt32, {
            __argnames__ : {value: ["plaintext", "ciphertext", "offset"]},
            __module__ : {value: "aes"}
        });
        AES.prototype.decrypt = function decrypt(ciphertext, plaintext, offset) {
            var self = this;
            convert_to_int32(ciphertext, self.working_mem[1], offset, 16);
            return self._crypt(plaintext, offset, false);
        };
        if (!AES.prototype.decrypt.__argnames__) Object.defineProperties(AES.prototype.decrypt, {
            __argnames__ : {value: ["ciphertext", "plaintext", "offset"]},
            __module__ : {value: "aes"}
        });
        AES.prototype.decrypt32 = function decrypt32(ciphertext, plaintext, offset) {
            var self = this;
            self.working_mem[1].set(ciphertext);
            return self._crypt(plaintext, offset, false);
        };
        if (!AES.prototype.decrypt32.__argnames__) Object.defineProperties(AES.prototype.decrypt32, {
            __argnames__ : {value: ["ciphertext", "plaintext", "offset"]},
            __module__ : {value: "aes"}
        });
        AES.prototype.__repr__ = function __repr__ () {
                        return "<" + __name__ + "." + this.constructor.name + " #" + this.ρσ_object_id + ">";
        };
        AES.prototype.__str__ = function __str__ () {
            return this.__repr__();
        };
        Object.defineProperty(AES.prototype, "__bases__", {value: []});

        function random_bytes_insecure(sz) {
            var ans;
            ans = new Uint8Array(sz);
            for (var i = 0; i < sz; i++) {
                ans[(typeof i === "number" && i < 0) ? ans.length + i : i] = Math.floor(Math.random() * 256);
            }
            return ans;
        };
        if (!random_bytes_insecure.__argnames__) Object.defineProperties(random_bytes_insecure, {
            __argnames__ : {value: ["sz"]},
            __module__ : {value: "aes"}
        });

        function random_bytes_secure(sz) {
            var ans;
            ans = new Uint8Array(sz);
            crypto.getRandomValues(ans);
            return ans;
        };
        if (!random_bytes_secure.__argnames__) Object.defineProperties(random_bytes_secure, {
            __argnames__ : {value: ["sz"]},
            __module__ : {value: "aes"}
        });

        random_bytes = (typeof crypto !== "undefined" && typeof crypto.getRandomValues === "function") ? random_bytes_secure : random_bytes_insecure;
        if (random_bytes === random_bytes_insecure) {
            try {
                noderandom = require("crypto").randomBytes;
                random_bytes = (function() {
                    var ρσ_anonfunc = function (sz) {
                        return new Uint8Array(noderandom(sz));
                    };
                    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                        __argnames__ : {value: ["sz"]},
                        __module__ : {value: "aes"}
                    });
                    return ρσ_anonfunc;
                })();
            } catch (ρσ_Exception) {
                ρσ_last_exception = ρσ_Exception;
                {
                    print("WARNING: Using insecure RNG for AES");
                } 
            }
        }
        function ModeOfOperation() {
            if (this.ρσ_object_id === undefined) Object.defineProperty(this, "ρσ_object_id", {"value":++ρσ_object_counter});
            ModeOfOperation.prototype.__init__.apply(this, arguments);
        }
        Object.defineProperties(ModeOfOperation.prototype,  {
            "key_as_js": {
                "enumerable": true, 
                "get": function key_as_js() {
                    var self = this;
                    return typed_array_as_js(self.key);
                }, 
                "set": function () { throw new AttributeError("can't set attribute") }
            }, 
        });
        ModeOfOperation.prototype.__init__ = function __init__(key) {
            var self = this;
            self.key = key || generate_key(32);
            self.aes = new AES(self.key);
        };
        if (!ModeOfOperation.prototype.__init__.__argnames__) Object.defineProperties(ModeOfOperation.prototype.__init__, {
            __argnames__ : {value: ["key"]},
            __module__ : {value: "aes"}
        });
        ModeOfOperation.__argnames__ = ModeOfOperation.prototype.__init__.__argnames__;
        ModeOfOperation.__handles_kwarg_interpolation__ = ModeOfOperation.prototype.__init__.__handles_kwarg_interpolation__;
        ModeOfOperation.prototype.tag_as_bytes = function tag_as_bytes(tag) {
            var self = this;
            if (ρσ_instanceof(tag, Uint8Array)) {
                return tag;
            }
            if (!tag) {
                return new Uint8Array(0);
            }
            if (typeof tag === "string") {
                return string_to_bytes(tag);
            }
            throw new TypeError("Invalid tag, must be a string or a Uint8Array");
        };
        if (!ModeOfOperation.prototype.tag_as_bytes.__argnames__) Object.defineProperties(ModeOfOperation.prototype.tag_as_bytes, {
            __argnames__ : {value: ["tag"]},
            __module__ : {value: "aes"}
        });
        ModeOfOperation.prototype.__repr__ = function __repr__ () {
                        return "<" + __name__ + "." + this.constructor.name + " #" + this.ρσ_object_id + ">";
        };
        ModeOfOperation.prototype.__str__ = function __str__ () {
            return this.__repr__();
        };
        Object.defineProperty(ModeOfOperation.prototype, "__bases__", {value: []});
        

        function GaloisField() {
            if (this.ρσ_object_id === undefined) Object.defineProperty(this, "ρσ_object_id", {"value":++ρσ_object_counter});
            GaloisField.prototype.__init__.apply(this, arguments);
        }
        GaloisField.prototype.__init__ = function __init__(sub_key) {
            var self = this;
            var k32;
            k32 = new Uint32Array(4);
            convert_to_int32(sub_key, k32, 0);
            self.m = self.generate_hash_table(k32);
            self.wmem = new Uint32Array(4);
        };
        if (!GaloisField.prototype.__init__.__argnames__) Object.defineProperties(GaloisField.prototype.__init__, {
            __argnames__ : {value: ["sub_key"]},
            __module__ : {value: "aes"}
        });
        GaloisField.__argnames__ = GaloisField.prototype.__init__.__argnames__;
        GaloisField.__handles_kwarg_interpolation__ = GaloisField.prototype.__init__.__handles_kwarg_interpolation__;
        GaloisField.prototype.power = function power(x, out) {
            var self = this;
            var lsb;
            lsb = x[3] & 1;
            for (var i = 3; i > 0; --i) {
                out[(typeof i === "number" && i < 0) ? out.length + i : i] = x[(typeof i === "number" && i < 0) ? x.length + i : i] >>> 1 | (x[ρσ_bound_index(i - 1, x)] & 1) << 31;
            }
            out[0] = x[0] >>> 1;
            if (lsb) {
                out[0] ^= 3774873600;
            }
        };
        if (!GaloisField.prototype.power.__argnames__) Object.defineProperties(GaloisField.prototype.power, {
            __argnames__ : {value: ["x", "out"]},
            __module__ : {value: "aes"}
        });
        GaloisField.prototype.multiply = function multiply(x, y) {
            var self = this;
            var z_i, v_i, x_i;
            z_i = new Uint32Array(4);
            v_i = new Uint32Array(y);
            for (var i = 0; i < 128; ++i) {
                x_i = x[ρσ_bound_index(i / 32 | 0, x)] & 1 << 31 - i % 32;
                if (x_i) {
                    z_i[0] ^= v_i[0];
                    z_i[1] ^= v_i[1];
                    z_i[2] ^= v_i[2];
                    z_i[3] ^= v_i[3];
                }
                self.power(v_i, v_i);
            }
            return z_i;
        };
        if (!GaloisField.prototype.multiply.__argnames__) Object.defineProperties(GaloisField.prototype.multiply, {
            __argnames__ : {value: ["x", "y"]},
            __module__ : {value: "aes"}
        });
        GaloisField.prototype.generate_sub_hash_table = function generate_sub_hash_table(mid) {
            var self = this;
            var bits, size, half, m, i, m_i, m_j, x, y;
            bits = mid.length;
            size = 1 << bits;
            half = size >>> 1;
            m = new Array(size);
            m[(typeof half === "number" && half < 0) ? m.length + half : half] = new Uint32Array(mid);
            i = half >>> 1;
            while (i > 0) {
                m[(typeof i === "number" && i < 0) ? m.length + i : i] = new Uint32Array(4);
                self.power(m[ρσ_bound_index(2 * i, m)], m[(typeof i === "number" && i < 0) ? m.length + i : i]);
                i >>= 1;
            }
            i = 2;
            while (i < half) {
                for (var j = 1; j < i; ++j) {
                    m_i = m[(typeof i === "number" && i < 0) ? m.length + i : i];
                    m_j = m[(typeof j === "number" && j < 0) ? m.length + j : j];
                    m[ρσ_bound_index(i + j, m)] = x = new Uint32Array(4);
                    for (var c = 0; c < 4; c++) {
                        x[(typeof c === "number" && c < 0) ? x.length + c : c] = m_i[(typeof c === "number" && c < 0) ? m_i.length + c : c] ^ m_j[(typeof c === "number" && c < 0) ? m_j.length + c : c];
                    }
                }
                i *= 2;
            }
            m[0] = new Uint32Array(4);
            for (i = half + 1; i < size; ++i) {
                x = m[ρσ_bound_index(i ^ half, m)];
                m[(typeof i === "number" && i < 0) ? m.length + i : i] = y = new Uint32Array(4);
                for (var c = 0; c < 4; c++) {
                    y[(typeof c === "number" && c < 0) ? y.length + c : c] = mid[(typeof c === "number" && c < 0) ? mid.length + c : c] ^ x[(typeof c === "number" && c < 0) ? x.length + c : c];
                }
            }
            return m;
        };
        if (!GaloisField.prototype.generate_sub_hash_table.__argnames__) Object.defineProperties(GaloisField.prototype.generate_sub_hash_table, {
            __argnames__ : {value: ["mid"]},
            __module__ : {value: "aes"}
        });
        GaloisField.prototype.generate_hash_table = function generate_hash_table(key_as_int32_array) {
            var self = this;
            var bits, multiplier, per_int, size, ans, tmp, idx, shft;
            bits = key_as_int32_array.length;
            multiplier = 8 / bits;
            per_int = 4 * multiplier;
            size = 16 * multiplier;
            ans = new Array(size);
            for (var i =0; i < size; ++i) {
                tmp = new Uint32Array(4);
                idx = i / per_int | 0;
                shft = (per_int - 1 - i % per_int) * bits;
                tmp[(typeof idx === "number" && idx < 0) ? tmp.length + idx : idx] = 1 << bits - 1 << shft;
                ans[(typeof i === "number" && i < 0) ? ans.length + i : i] = self.generate_sub_hash_table(self.multiply(tmp, key_as_int32_array));
            }
            return ans;
        };
        if (!GaloisField.prototype.generate_hash_table.__argnames__) Object.defineProperties(GaloisField.prototype.generate_hash_table, {
            __argnames__ : {value: ["key_as_int32_array"]},
            __module__ : {value: "aes"}
        });
        GaloisField.prototype.table_multiply = function table_multiply(x) {
            var self = this;
            var z, idx, x_i, ah;
            z = new Uint32Array(4);
            for (var i = 0; i < 32; ++i) {
                idx = i / 8 | 0;
                x_i = x[(typeof idx === "number" && idx < 0) ? x.length + idx : idx] >>> (7 - i % 8) * 4 & 15;
                ah = (ρσ_expr_temp = (ρσ_expr_temp = self.m)[(typeof i === "number" && i < 0) ? ρσ_expr_temp.length + i : i])[(typeof x_i === "number" && x_i < 0) ? ρσ_expr_temp.length + x_i : x_i];
                z[0] ^= ah[0];
                z[1] ^= ah[1];
                z[2] ^= ah[2];
                z[3] ^= ah[3];
            }
            return z;
        };
        if (!GaloisField.prototype.table_multiply.__argnames__) Object.defineProperties(GaloisField.prototype.table_multiply, {
            __argnames__ : {value: ["x"]},
            __module__ : {value: "aes"}
        });
        GaloisField.prototype.ghash = function ghash(x, y) {
            var self = this;
            var z;
            z = self.wmem;
            z[0] = y[0] ^ x[0];
            z[1] = y[1] ^ x[1];
            z[2] = y[2] ^ x[2];
            z[3] = y[3] ^ x[3];
            return self.table_multiply(z);
        };
        if (!GaloisField.prototype.ghash.__argnames__) Object.defineProperties(GaloisField.prototype.ghash, {
            __argnames__ : {value: ["x", "y"]},
            __module__ : {value: "aes"}
        });
        GaloisField.prototype.__repr__ = function __repr__ () {
                        return "<" + __name__ + "." + this.constructor.name + " #" + this.ρσ_object_id + ">";
        };
        GaloisField.prototype.__str__ = function __str__ () {
            return this.__repr__();
        };
        Object.defineProperty(GaloisField.prototype, "__bases__", {value: []});

        function generate_key(sz) {
            if (!number_of_rounds[(typeof sz === "number" && sz < 0) ? number_of_rounds.length + sz : sz]) {
                throw new ValueError("Invalid key size, must be: 16, 24 or 32");
            }
            return random_bytes(sz);
        };
        if (!generate_key.__argnames__) Object.defineProperties(generate_key, {
            __argnames__ : {value: ["sz"]},
            __module__ : {value: "aes"}
        });

        function generate_tag(sz) {
            return random_bytes(sz || 32);
        };
        if (!generate_tag.__argnames__) Object.defineProperties(generate_tag, {
            __argnames__ : {value: ["sz"]},
            __module__ : {value: "aes"}
        });

        function typed_array_as_js(x) {
            var name;
            name = x.constructor.name || "Uint8Array";
            return "(new " + name + "(" + JSON.stringify(Array.prototype.slice.call(x)) + "))";
        };
        if (!typed_array_as_js.__argnames__) Object.defineProperties(typed_array_as_js, {
            __argnames__ : {value: ["x"]},
            __module__ : {value: "aes"}
        });

        function CBC() {
            if (this.ρσ_object_id === undefined) Object.defineProperty(this, "ρσ_object_id", {"value":++ρσ_object_counter});
            CBC.prototype.__init__.apply(this, arguments);
        }
        ρσ_extends(CBC, ModeOfOperation);
        CBC.prototype.__init__ = function __init__ () {
            ModeOfOperation.prototype.__init__ && ModeOfOperation.prototype.__init__.apply(this, arguments);
        };
        CBC.prototype.encrypt_bytes = function encrypt_bytes(bytes, tag_bytes, iv) {
            var self = this;
            var first_iv, mlen, padsz, inputbytes, offset, outputbytes, ρσ_unpack;
            iv = first_iv = iv || random_bytes(16);
            mlen = bytes.length + tag_bytes.length;
            padsz = (16 - mlen % 16) % 16;
            inputbytes = new Uint8Array(mlen + padsz);
            if (tag_bytes.length) {
                inputbytes.set(tag_bytes);
            }
            inputbytes.set(bytes, tag_bytes.length);
            offset = 0;
            outputbytes = new Uint8Array(inputbytes.length);
            for (var block = 0; block < inputbytes.length; block += 16) {
                if (block > 0) {
                    ρσ_unpack = [outputbytes, block - 16];
                    iv = ρσ_unpack[0];
                    offset = ρσ_unpack[1];
                }
                for (var i = 0; i < 16; i++) {
                    inputbytes[ρσ_bound_index(block + i, inputbytes)] ^= iv[ρσ_bound_index(offset + i, iv)];
                }
                self.aes.encrypt(inputbytes, outputbytes, block);
            }
            return (function(){
                var ρσ_d = {};
                ρσ_d["iv"] = first_iv;
                ρσ_d["cipherbytes"] = outputbytes;
                return ρσ_d;
            }).call(this);
        };
        if (!CBC.prototype.encrypt_bytes.__argnames__) Object.defineProperties(CBC.prototype.encrypt_bytes, {
            __argnames__ : {value: ["bytes", "tag_bytes", "iv"]},
            __module__ : {value: "aes"}
        });
        CBC.prototype.encrypt = function encrypt(plaintext, tag) {
            var self = this;
            return self.encrypt_bytes(string_to_bytes(plaintext), self.tag_as_bytes(tag));
        };
        if (!CBC.prototype.encrypt.__argnames__) Object.defineProperties(CBC.prototype.encrypt, {
            __argnames__ : {value: ["plaintext", "tag"]},
            __module__ : {value: "aes"}
        });
        CBC.prototype.decrypt_bytes = function decrypt_bytes(inputbytes, tag_bytes, iv) {
            var self = this;
            var offset, outputbytes, ρσ_unpack;
            offset = 0;
            outputbytes = new Uint8Array(inputbytes.length);
            for (var block = 0; block < inputbytes.length; block += 16) {
                self.aes.decrypt(inputbytes, outputbytes, block);
                if (block > 0) {
                    ρσ_unpack = [inputbytes, block - 16];
                    iv = ρσ_unpack[0];
                    offset = ρσ_unpack[1];
                }
                for (var i = 0; i < 16; i++) {
                    outputbytes[ρσ_bound_index(block + i, outputbytes)] ^= iv[ρσ_bound_index(offset + i, iv)];
                }
            }
            for (var i = 0; i < tag_bytes.length; i++) {
                if ((tag_bytes[(typeof i === "number" && i < 0) ? tag_bytes.length + i : i] !== outputbytes[(typeof i === "number" && i < 0) ? outputbytes.length + i : i] && (typeof tag_bytes[(typeof i === "number" && i < 0) ? tag_bytes.length + i : i] !== "object" || ρσ_not_equals(tag_bytes[(typeof i === "number" && i < 0) ? tag_bytes.length + i : i], outputbytes[(typeof i === "number" && i < 0) ? outputbytes.length + i : i])))) {
                    throw new ValueError("Corrupt message");
                }
            }
            outputbytes = outputbytes.subarray(tag_bytes.length);
            return outputbytes;
        };
        if (!CBC.prototype.decrypt_bytes.__argnames__) Object.defineProperties(CBC.prototype.decrypt_bytes, {
            __argnames__ : {value: ["inputbytes", "tag_bytes", "iv"]},
            __module__ : {value: "aes"}
        });
        CBC.prototype.decrypt = function decrypt(output_from_encrypt, tag) {
            var self = this;
            var ans;
            ans = self.decrypt_bytes(output_from_encrypt.cipherbytes, self.tag_as_bytes(tag), output_from_encrypt.iv);
            return str.rstrip(bytes_to_string(ans), "\u0000");
        };
        if (!CBC.prototype.decrypt.__argnames__) Object.defineProperties(CBC.prototype.decrypt, {
            __argnames__ : {value: ["output_from_encrypt", "tag"]},
            __module__ : {value: "aes"}
        });
        CBC.prototype.__repr__ = function __repr__ () {
            if(ModeOfOperation.prototype.__repr__) return ModeOfOperation.prototype.__repr__.call(this);
            return "<" + __name__ + "." + this.constructor.name + " #" + this.ρσ_object_id + ">";
        };
        CBC.prototype.__str__ = function __str__ () {
            if(ModeOfOperation.prototype.__str__) return ModeOfOperation.prototype.__str__.call(this);
return this.__repr__();
        };
        Object.defineProperty(CBC.prototype, "__bases__", {value: [ModeOfOperation]});

        function CTR() {
            if (this.ρσ_object_id === undefined) Object.defineProperty(this, "ρσ_object_id", {"value":++ρσ_object_counter});
            CTR.prototype.__init__.apply(this, arguments);
        }
        ρσ_extends(CTR, ModeOfOperation);
        CTR.prototype.__init__ = function __init__(key, iv) {
            var self = this;
            ModeOfOperation.prototype.__init__.call(self, key);
            self.wmem = new Uint8Array(16);
            self.counter_block = new Uint8Array(iv || 16);
            if ((self.counter_block.length !== 16 && (typeof self.counter_block.length !== "object" || ρσ_not_equals(self.counter_block.length, 16)))) {
                throw new ValueError("iv must be 16 bytes long");
            }
            self.counter_index = 16;
        };
        if (!CTR.prototype.__init__.__argnames__) Object.defineProperties(CTR.prototype.__init__, {
            __argnames__ : {value: ["key", "iv"]},
            __module__ : {value: "aes"}
        });
        CTR.__argnames__ = CTR.prototype.__init__.__argnames__;
        CTR.__handles_kwarg_interpolation__ = CTR.prototype.__init__.__handles_kwarg_interpolation__;
        CTR.prototype._crypt = function _crypt(bytes) {
            var self = this;
            for (var i = 0; i < bytes.length; i++, self.counter_index++) {
                if (self.counter_index === 16) {
                    self.counter_index = 0;
                    self.aes.encrypt(self.counter_block, self.wmem, 0);
                    increment_counter(self.counter_block);
                }
                bytes[(typeof i === "number" && i < 0) ? bytes.length + i : i] ^= (ρσ_expr_temp = self.wmem)[ρσ_bound_index(self.counter_index, ρσ_expr_temp)];
            }
            self.counter_index = 16;
        };
        if (!CTR.prototype._crypt.__argnames__) Object.defineProperties(CTR.prototype._crypt, {
            __argnames__ : {value: ["bytes"]},
            __module__ : {value: "aes"}
        });
        CTR.prototype.encrypt = function encrypt(plaintext, tag) {
            var self = this;
            var outbytes, counterbytes, tag_bytes, t;
            outbytes = string_to_bytes(plaintext);
            counterbytes = new Uint8Array(self.counter_block);
            if (tag) {
                tag_bytes = self.tag_as_bytes(tag);
                t = new Uint8Array(outbytes.length + tag_bytes.length);
                t.set(tag_bytes);
                t.set(outbytes, tag_bytes.length);
                outbytes = t;
            }
            self._crypt(outbytes);
            return (function(){
                var ρσ_d = {};
                ρσ_d["cipherbytes"] = outbytes;
                ρσ_d["counterbytes"] = counterbytes;
                return ρσ_d;
            }).call(this);
        };
        if (!CTR.prototype.encrypt.__argnames__) Object.defineProperties(CTR.prototype.encrypt, {
            __argnames__ : {value: ["plaintext", "tag"]},
            __module__ : {value: "aes"}
        });
        CTR.prototype.__enter__ = function __enter__() {
            var self = this;
            self.before_index = self.counter_index;
            self.before_counter = new Uint8Array(self.counter_block);
        };
        if (!CTR.prototype.__enter__.__module__) Object.defineProperties(CTR.prototype.__enter__, {
            __module__ : {value: "aes"}
        });
        CTR.prototype.__exit__ = function __exit__() {
            var self = this;
            self.counter_index = self.before_index;
            self.counter_block = self.before_counter;
        };
        if (!CTR.prototype.__exit__.__module__) Object.defineProperties(CTR.prototype.__exit__, {
            __module__ : {value: "aes"}
        });
        CTR.prototype.decrypt = function decrypt(output_from_encrypt, tag) {
            var self = this;
            var b, ρσ_with_exception, ρσ_with_suppress, offset, tag_bytes;
            b = new Uint8Array(output_from_encrypt.cipherbytes);
            ρσ_with_exception = undefined;
            var ρσ_with_clause_1 = self;
            ρσ_with_clause_1.__enter__();
            try {
                {
                    self.counter_block = output_from_encrypt.counterbytes;
                    self.counter_index = 16;
                    self._crypt(b);
                }
            } catch(e){
                ρσ_with_exception = e;
            }
            if (ρσ_with_exception === undefined){
                ρσ_with_clause_1.__exit__();
            } else {
                ρσ_with_suppress = false;
                ρσ_with_suppress |= ρσ_bool(ρσ_with_clause_1.__exit__(ρσ_with_exception.constructor, ρσ_with_exception, ρσ_with_exception.stack));
                if (!ρσ_with_suppress) throw ρσ_with_exception;
            }
            offset = 0;
            if (tag) {
                tag_bytes = self.tag_as_bytes(tag);
                for (var i = 0; i < tag_bytes.length; i++) {
                    if ((tag_bytes[(typeof i === "number" && i < 0) ? tag_bytes.length + i : i] !== b[(typeof i === "number" && i < 0) ? b.length + i : i] && (typeof tag_bytes[(typeof i === "number" && i < 0) ? tag_bytes.length + i : i] !== "object" || ρσ_not_equals(tag_bytes[(typeof i === "number" && i < 0) ? tag_bytes.length + i : i], b[(typeof i === "number" && i < 0) ? b.length + i : i])))) {
                        throw new ValueError("Corrupted message");
                    }
                }
                offset = tag_bytes.length;
            }
            return bytes_to_string(b, offset);
        };
        if (!CTR.prototype.decrypt.__argnames__) Object.defineProperties(CTR.prototype.decrypt, {
            __argnames__ : {value: ["output_from_encrypt", "tag"]},
            __module__ : {value: "aes"}
        });
        CTR.prototype.__repr__ = function __repr__ () {
            if(ModeOfOperation.prototype.__repr__) return ModeOfOperation.prototype.__repr__.call(this);
            return "<" + __name__ + "." + this.constructor.name + " #" + this.ρσ_object_id + ">";
        };
        CTR.prototype.__str__ = function __str__ () {
            if(ModeOfOperation.prototype.__str__) return ModeOfOperation.prototype.__str__.call(this);
return this.__repr__();
        };
        Object.defineProperty(CTR.prototype, "__bases__", {value: [ModeOfOperation]});

        function GCM() {
            if (this.ρσ_object_id === undefined) Object.defineProperty(this, "ρσ_object_id", {"value":++ρσ_object_counter});
            GCM.prototype.__init__.apply(this, arguments);
        }
        ρσ_extends(GCM, ModeOfOperation);
        GCM.prototype.__init__ = function __init__() {
            var self = this;
            var key = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[0];
            var random_iv = (arguments[1] === undefined || ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? __init__.__defaults__.random_iv : arguments[1];
            var ρσ_kwargs_obj = arguments[arguments.length-1];
            if (ρσ_kwargs_obj === null || typeof ρσ_kwargs_obj !== "object" || ρσ_kwargs_obj [ρσ_kwargs_symbol] !== true) ρσ_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "random_iv")){
                random_iv = ρσ_kwargs_obj.random_iv;
            }
            var H;
            ModeOfOperation.prototype.__init__.call(self, key);
            self.random_iv = random_iv;
            if (!random_iv) {
                self.current_iv = new Uint8Array(12);
            }
            H = new Uint8Array(16);
            self.aes.encrypt(new Uint8Array(16), H, 0);
            self.galois = new GaloisField(H);
            self.J0 = new Uint32Array(4);
            self.wmem = new Uint32Array(4);
            self.byte_block = new Uint8Array(16);
        };
        if (!GCM.prototype.__init__.__defaults__) Object.defineProperties(GCM.prototype.__init__, {
            __defaults__ : {value: {random_iv:false}},
            __handles_kwarg_interpolation__ : {value: true},
            __argnames__ : {value: ["key", "random_iv"]},
            __module__ : {value: "aes"}
        });
        GCM.__argnames__ = GCM.prototype.__init__.__argnames__;
        GCM.__handles_kwarg_interpolation__ = GCM.prototype.__init__.__handles_kwarg_interpolation__;
        GCM.prototype.increment_iv = function increment_iv() {
            var self = this;
            var c;
            c = self.current_iv;
            for (var i = 11; i >=0; i--) {
                if (c[(typeof i === "number" && i < 0) ? c.length + i : i] === 255) {
                    if (i === 0) {
                        throw new ValueError("The GCM IV space is exhausted, cannot encrypt anymore messages with this key as doing so would cause the IV to repeat");
                    }
                    c[(typeof i === "number" && i < 0) ? c.length + i : i] = 0;
                } else {
                    c[(typeof i === "number" && i < 0) ? c.length + i : i] += 1;
                    break;
                }
            }
        };
        if (!GCM.prototype.increment_iv.__module__) Object.defineProperties(GCM.prototype.increment_iv, {
            __module__ : {value: "aes"}
        });
        GCM.prototype._create_j0 = function _create_j0(iv) {
            var self = this;
            var J0, tmp;
            J0 = self.J0;
            if (iv.length === 12) {
                convert_to_int32(iv, J0);
                J0[3] = 1;
            } else {
                J0.fill(0);
                tmp = convert_to_int32_pad(iv);
                while (tmp.length) {
                    J0 = self.galois.ghash(J0, tmp);
                    tmp = tmp.subarray(4);
                }
                tmp = new Uint32Array(4);
                tmp.set(from_64_to_32(iv.length * 8), 2);
                J0 = self.galois.ghash(J0, tmp);
            }
            return J0;
        };
        if (!GCM.prototype._create_j0.__argnames__) Object.defineProperties(GCM.prototype._create_j0, {
            __argnames__ : {value: ["iv"]},
            __module__ : {value: "aes"}
        });
        GCM.prototype._start = function _start(iv, additional_data) {
            var self = this;
            var J0, in_block, S, overflow;
            J0 = self._create_j0(iv);
            in_block = new Uint32Array(J0);
            in_block[3] = in_block[3] + 1 & 4294967295;
            S = new Uint32Array(4);
            overflow = additional_data.length % 16;
            for (var i = 0; i < additional_data.length - overflow; i += 16) {
                convert_to_int32(additional_data, self.wmem, i, 16);
                S = self.galois.ghash(S, self.wmem);
            }
            if (overflow) {
                self.byte_block.fill(0);
                self.byte_block.set(additional_data.subarray(additional_data.length - overflow));
                convert_to_int32(self.byte_block, self.wmem);
                S = self.galois.ghash(S, self.wmem);
            }
            return [J0, in_block, S];
        };
        if (!GCM.prototype._start.__argnames__) Object.defineProperties(GCM.prototype._start, {
            __argnames__ : {value: ["iv", "additional_data"]},
            __module__ : {value: "aes"}
        });
        GCM.prototype._finish = function _finish(iv, J0, adata_len, S, outbytes) {
            var self = this;
            var lengths, tag;
            lengths = new Uint32Array(4);
            lengths.set(from_64_to_32(adata_len * 8));
            lengths.set(from_64_to_32(outbytes.length * 8), 2);
            S = self.galois.ghash(S, lengths);
            self.aes.encrypt32(J0, self.byte_block, 0);
            convert_to_int32(self.byte_block, self.wmem);
            tag = new Uint32Array(4);
            for (var i = 0; i < S.length; i++) {
                tag[(typeof i === "number" && i < 0) ? tag.length + i : i] = S[(typeof i === "number" && i < 0) ? S.length + i : i] ^ (ρσ_expr_temp = self.wmem)[(typeof i === "number" && i < 0) ? ρσ_expr_temp.length + i : i];
            }
            return (function(){
                var ρσ_d = {};
                ρσ_d["iv"] = iv;
                ρσ_d["cipherbytes"] = outbytes;
                ρσ_d["tag"] = tag;
                return ρσ_d;
            }).call(this);
        };
        if (!GCM.prototype._finish.__argnames__) Object.defineProperties(GCM.prototype._finish, {
            __argnames__ : {value: ["iv", "J0", "adata_len", "S", "outbytes"]},
            __module__ : {value: "aes"}
        });
        GCM.prototype._crypt = function _crypt(iv, bytes, additional_data, decrypt) {
            var self = this;
            var ghash, outbytes, ρσ_unpack, J0, in_block, S, bb, enc, hash_bytes, counter_index, overflow;
            ghash = self.galois.ghash.bind(self.galois);
            outbytes = new Uint8Array(bytes.length);
            ρσ_unpack = self._start(iv, additional_data);
ρσ_unpack = ρσ_unpack_asarray(3, ρσ_unpack);
            J0 = ρσ_unpack[0];
            in_block = ρσ_unpack[1];
            S = ρσ_unpack[2];
            bb = self.byte_block;
            enc = self.aes.encrypt32.bind(self.aes);
            hash_bytes = (decrypt) ? bytes : outbytes;
            for (var i = 0, counter_index = 16; i < bytes.length; i++, counter_index++) {
                if (counter_index === 16) {
                    enc(in_block, bb, 0);
                    in_block[3] = in_block[3] + 1 & 4294967295;
                    counter_index = 0;
                }
                outbytes[(typeof i === "number" && i < 0) ? outbytes.length + i : i] = bytes[(typeof i === "number" && i < 0) ? bytes.length + i : i] ^ bb[(typeof counter_index === "number" && counter_index < 0) ? bb.length + counter_index : counter_index];
                if (counter_index === 15) {
                    convert_to_int32(hash_bytes, self.wmem, i - 15, 16);
                    S = ghash(S, self.wmem);
                }
            }
            overflow = outbytes.length % 16;
            if (overflow) {
                bb.fill(0);
                bb.set(hash_bytes.subarray(hash_bytes.length - overflow));
                convert_to_int32(bb, self.wmem);
                S = ghash(S, self.wmem);
            }
            return self._finish(iv, J0, additional_data.length, S, outbytes);
        };
        if (!GCM.prototype._crypt.__argnames__) Object.defineProperties(GCM.prototype._crypt, {
            __argnames__ : {value: ["iv", "bytes", "additional_data", "decrypt"]},
            __module__ : {value: "aes"}
        });
        GCM.prototype.encrypt = function encrypt(plaintext, tag) {
            var self = this;
            var iv;
            if (self.random_iv) {
                iv = random_bytes(12);
            } else {
                self.increment_iv();
                iv = self.current_iv;
            }
            return self._crypt(iv, string_to_bytes(plaintext), self.tag_as_bytes(tag), false);
        };
        if (!GCM.prototype.encrypt.__argnames__) Object.defineProperties(GCM.prototype.encrypt, {
            __argnames__ : {value: ["plaintext", "tag"]},
            __module__ : {value: "aes"}
        });
        GCM.prototype.decrypt = function decrypt(output_from_encrypt, tag) {
            var self = this;
            var ans;
            if ((output_from_encrypt.tag.length !== 4 && (typeof output_from_encrypt.tag.length !== "object" || ρσ_not_equals(output_from_encrypt.tag.length, 4)))) {
                throw new ValueError("Corrupted message");
            }
            ans = self._crypt(output_from_encrypt.iv, output_from_encrypt.cipherbytes, self.tag_as_bytes(tag), true);
            if ((ans.tag !== output_from_encrypt.tag && (typeof ans.tag !== "object" || ρσ_not_equals(ans.tag, output_from_encrypt.tag)))) {
                throw new ValueError("Corrupted message");
            }
            return bytes_to_string(ans.cipherbytes);
        };
        if (!GCM.prototype.decrypt.__argnames__) Object.defineProperties(GCM.prototype.decrypt, {
            __argnames__ : {value: ["output_from_encrypt", "tag"]},
            __module__ : {value: "aes"}
        });
        GCM.prototype.__repr__ = function __repr__ () {
            if(ModeOfOperation.prototype.__repr__) return ModeOfOperation.prototype.__repr__.call(this);
            return "<" + __name__ + "." + this.constructor.name + " #" + this.ρσ_object_id + ">";
        };
        GCM.prototype.__str__ = function __str__ () {
            if(ModeOfOperation.prototype.__str__) return ModeOfOperation.prototype.__str__.call(this);
return this.__repr__();
        };
        Object.defineProperty(GCM.prototype, "__bases__", {value: [ModeOfOperation]});

        ρσ_modules.aes.string_to_bytes = string_to_bytes;
        ρσ_modules.aes.bytes_to_string = bytes_to_string;
        ρσ_modules.aes.number_of_rounds = number_of_rounds;
        ρσ_modules.aes.rcon = rcon;
        ρσ_modules.aes.S = S;
        ρσ_modules.aes.Si = Si;
        ρσ_modules.aes.T1 = T1;
        ρσ_modules.aes.T2 = T2;
        ρσ_modules.aes.T3 = T3;
        ρσ_modules.aes.T4 = T4;
        ρσ_modules.aes.T5 = T5;
        ρσ_modules.aes.T6 = T6;
        ρσ_modules.aes.T7 = T7;
        ρσ_modules.aes.T8 = T8;
        ρσ_modules.aes.U1 = U1;
        ρσ_modules.aes.U2 = U2;
        ρσ_modules.aes.U3 = U3;
        ρσ_modules.aes.U4 = U4;
        ρσ_modules.aes.random_bytes = random_bytes;
        ρσ_modules.aes.noderandom = noderandom;
        ρσ_modules.aes.string_to_bytes_encoder = string_to_bytes_encoder;
        ρσ_modules.aes.string_to_bytes_slow = string_to_bytes_slow;
        ρσ_modules.aes.as_hex = as_hex;
        ρσ_modules.aes.bytes_to_string_decoder = bytes_to_string_decoder;
        ρσ_modules.aes.bytes_to_string_slow = bytes_to_string_slow;
        ρσ_modules.aes.increment_counter = increment_counter;
        ρσ_modules.aes.convert_to_int32 = convert_to_int32;
        ρσ_modules.aes.convert_to_int32_pad = convert_to_int32_pad;
        ρσ_modules.aes.from_64_to_32 = from_64_to_32;
        ρσ_modules.aes.AES = AES;
        ρσ_modules.aes.random_bytes_insecure = random_bytes_insecure;
        ρσ_modules.aes.random_bytes_secure = random_bytes_secure;
        ρσ_modules.aes.ModeOfOperation = ModeOfOperation;
        ρσ_modules.aes.GaloisField = GaloisField;
        ρσ_modules.aes.generate_key = generate_key;
        ρσ_modules.aes.generate_tag = generate_tag;
        ρσ_modules.aes.typed_array_as_js = typed_array_as_js;
        ρσ_modules.aes.CBC = CBC;
        ρσ_modules.aes.CTR = CTR;
        ρσ_modules.aes.GCM = GCM;
    })();

    (function(){
        var __name__ = "read_book.globals";
        var _boss, dark_link_color, uid, default_color_schemes, IN_DEVELOP_MODE, runtime, ui_operations, annot_id_uuid_map;
        var random_bytes = ρσ_modules.aes.random_bytes;

        var hexlify = ρσ_modules.encodings.hexlify;

        var _ = ρσ_modules.gettext.gettext;
        var register_callback = ρσ_modules.gettext.register_callback;
        var gt = ρσ_modules.gettext.gettext;

        _boss = null;
        dark_link_color = "#6cb4ee";
        function set_boss(b) {
            _boss = b;
        };
        if (!set_boss.__argnames__) Object.defineProperties(set_boss, {
            __argnames__ : {value: ["b"]},
            __module__ : {value: "read_book.globals"}
        });

        function get_boss() {
            return _boss;
        };
        if (!get_boss.__module__) Object.defineProperties(get_boss, {
            __module__ : {value: "read_book.globals"}
        });

        function current_book() {
            return current_book.book;
        };
        if (!current_book.__module__) Object.defineProperties(current_book, {
            __module__ : {value: "read_book.globals"}
        });

        current_book.book = null;
        function rtl_page_progression() {
            return (current_book().manifest.page_progression_direction === "rtl" || typeof current_book().manifest.page_progression_direction === "object" && ρσ_equals(current_book().manifest.page_progression_direction, "rtl"));
        };
        if (!rtl_page_progression.__module__) Object.defineProperties(rtl_page_progression, {
            __module__ : {value: "read_book.globals"}
        });

        function ltr_page_progression() {
            return !rtl_page_progression();
        };
        if (!ltr_page_progression.__module__) Object.defineProperties(ltr_page_progression, {
            __module__ : {value: "read_book.globals"}
        });

        uid = "calibre-" + hexlify(random_bytes(12));
        function viewport_mode_changer(val) {
            if (val) {
                viewport_mode_changer.val = val;
            }
            return viewport_mode_changer.val;
        };
        if (!viewport_mode_changer.__argnames__) Object.defineProperties(viewport_mode_changer, {
            __argnames__ : {value: ["val"]},
            __module__ : {value: "read_book.globals"}
        });

        function current_layout_mode() {
            return current_layout_mode.value;
        };
        if (!current_layout_mode.__module__) Object.defineProperties(current_layout_mode, {
            __module__ : {value: "read_book.globals"}
        });

        current_layout_mode.value = "flow";
        function set_layout_mode(val) {
            current_layout_mode.value = val;
            viewport_mode_changer()(val);
        };
        if (!set_layout_mode.__argnames__) Object.defineProperties(set_layout_mode, {
            __argnames__ : {value: ["val"]},
            __module__ : {value: "read_book.globals"}
        });

        function current_spine_item() {
            return current_spine_item.value;
        };
        if (!current_spine_item.__module__) Object.defineProperties(current_spine_item, {
            __module__ : {value: "read_book.globals"}
        });

        current_spine_item.value = null;
        function set_current_spine_item(val) {
            current_spine_item.value = val;
        };
        if (!set_current_spine_item.__argnames__) Object.defineProperties(set_current_spine_item, {
            __argnames__ : {value: ["val"]},
            __module__ : {value: "read_book.globals"}
        });

        function toc_anchor_map() {
            return toc_anchor_map.value;
        };
        if (!toc_anchor_map.__module__) Object.defineProperties(toc_anchor_map, {
            __module__ : {value: "read_book.globals"}
        });

        function set_toc_anchor_map(val) {
            toc_anchor_map.value = val;
        };
        if (!set_toc_anchor_map.__argnames__) Object.defineProperties(set_toc_anchor_map, {
            __argnames__ : {value: ["val"]},
            __module__ : {value: "read_book.globals"}
        });

        default_color_schemes = (function(){
            var ρσ_d = Object.create(null);
            ρσ_d["system"] = (function(){
                var ρσ_d = Object.create(null);
                ρσ_d["foreground"] = "#000000";
                ρσ_d["background"] = "#ffffff";
                ρσ_d["name"] = _("System");
                return ρσ_d;
            }).call(this);
            ρσ_d["white"] = (function(){
                var ρσ_d = Object.create(null);
                ρσ_d["foreground"] = "#000000";
                ρσ_d["background"] = "#ffffff";
                ρσ_d["name"] = _("White");
                return ρσ_d;
            }).call(this);
            ρσ_d["black"] = (function(){
                var ρσ_d = Object.create(null);
                ρσ_d["foreground"] = "#ffffff";
                ρσ_d["background"] = "#000000";
                ρσ_d["link"] = "#4f81bd";
                ρσ_d["name"] = _("Black");
                return ρσ_d;
            }).call(this);
            ρσ_d["sepia-light"] = (function(){
                var ρσ_d = Object.create(null);
                ρσ_d["foreground"] = "#39322B";
                ρσ_d["background"] = "#F6F3E9";
                ρσ_d["name"] = _("Sepia light");
                return ρσ_d;
            }).call(this);
            ρσ_d["sepia-dark"] = (function(){
                var ρσ_d = Object.create(null);
                ρσ_d["background"] = "#39322B";
                ρσ_d["foreground"] = "#F6F3E9";
                ρσ_d["link"] = "#4f81bd";
                ρσ_d["name"] = _("Sepia dark");
                return ρσ_d;
            }).call(this);
            return ρσ_d;
        }).call(this);
        function set_system_colors(spec) {
            var c;
            c = default_color_schemes.system;
            c.foreground = spec.foreground;
            c.background = spec.background;
            delete c.link;
            if (spec.link) {
                c.link = spec.link;
            }
        };
        if (!set_system_colors.__argnames__) Object.defineProperties(set_system_colors, {
            __argnames__ : {value: ["spec"]},
            __module__ : {value: "read_book.globals"}
        });

        register_callback((function() {
            var ρσ_anonfunc = function () {
                var scheme, key;
                var ρσ_Iter0 = ρσ_Iterable(default_color_schemes);
                for (var ρσ_Index0 = 0; ρσ_Index0 < ρσ_Iter0.length; ρσ_Index0++) {
                    key = ρσ_Iter0[ρσ_Index0];
                    scheme = default_color_schemes[(typeof key === "number" && key < 0) ? default_color_schemes.length + key : key];
                    scheme.name = gt(scheme.name);
                }
                if (window.matchMedia && window.matchMedia("(prefers-color-scheme: dark)").matches) {
                    set_system_colors((function(){
                        var ρσ_d = Object.create(null);
                        ρσ_d["background"] = "#111";
                        ρσ_d["foreground"] = "#ddd";
                        ρσ_d["link"] = dark_link_color;
                        return ρσ_d;
                    }).call(this));
                }
            };
            if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
                __module__ : {value: "read_book.globals"}
            });
            return ρσ_anonfunc;
        })());
        IN_DEVELOP_MODE = "__IN_DEVELOP_MODE__";
        runtime = (function(){
            var ρσ_d = Object.create(null);
            ρσ_d["is_standalone_viewer"] = false;
            ρσ_d["viewer_in_full_screen"] = false;
            ρσ_d["in_develop_mode"] = IN_DEVELOP_MODE === "1";
            ρσ_d["QT_VERSION"] = 0;
            return ρσ_d;
        }).call(this);
        ui_operations = (function(){
            var ρσ_d = Object.create(null);
            ρσ_d["get_file"] = null;
            ρσ_d["get_mathjax_files"] = null;
            ρσ_d["update_url_state"] = null;
            ρσ_d["update_last_read_time"] = null;
            ρσ_d["show_error"] = null;
            ρσ_d["redisplay_book"] = null;
            ρσ_d["reload_book"] = null;
            ρσ_d["forward_gesture"] = null;
            ρσ_d["update_color_scheme"] = null;
            ρσ_d["update_font_size"] = null;
            ρσ_d["goto_cfi"] = null;
            ρσ_d["delete_book"] = null;
            ρσ_d["focus_iframe"] = null;
            ρσ_d["toggle_toc"] = null;
            ρσ_d["toggle_full_screen"] = null;
            return ρσ_d;
        }).call(this);
        annot_id_uuid_map = Object.create(null);
        function clear_annot_id_uuid_map() {
            annot_id_uuid_map = Object.create(null);
        };
        if (!clear_annot_id_uuid_map.__module__) Object.defineProperties(clear_annot_id_uuid_map, {
            __module__ : {value: "read_book.globals"}
        });

        function is_dark_theme(set_val) {
            if ((typeof set_val !== "undefined" && set_val !== null)) {
                is_dark_theme.ans = set_val;
            }
            return !!is_dark_theme.ans;
        };
        if (!is_dark_theme.__argnames__) Object.defineProperties(is_dark_theme, {
            __argnames__ : {value: ["set_val"]},
            __module__ : {value: "read_book.globals"}
        });

        ρσ_modules["read_book.globals"]._boss = _boss;
        ρσ_modules["read_book.globals"].dark_link_color = dark_link_color;
        ρσ_modules["read_book.globals"].uid = uid;
        ρσ_modules["read_book.globals"].default_color_schemes = default_color_schemes;
        ρσ_modules["read_book.globals"].IN_DEVELOP_MODE = IN_DEVELOP_MODE;
        ρσ_modules["read_book.globals"].runtime = runtime;
        ρσ_modules["read_book.globals"].ui_operations = ui_operations;
        ρσ_modules["read_book.globals"].annot_id_uuid_map = annot_id_uuid_map;
        ρσ_modules["read_book.globals"].set_boss = set_boss;
        ρσ_modules["read_book.globals"].get_boss = get_boss;
        ρσ_modules["read_book.globals"].current_book = current_book;
        ρσ_modules["read_book.globals"].rtl_page_progression = rtl_page_progression;
        ρσ_modules["read_book.globals"].ltr_page_progression = ltr_page_progression;
        ρσ_modules["read_book.globals"].viewport_mode_changer = viewport_mode_changer;
        ρσ_modules["read_book.globals"].current_layout_mode = current_layout_mode;
        ρσ_modules["read_book.globals"].set_layout_mode = set_layout_mode;
        ρσ_modules["read_book.globals"].current_spine_item = current_spine_item;
        ρσ_modules["read_book.globals"].set_current_spine_item = set_current_spine_item;
        ρσ_modules["read_book.globals"].toc_anchor_map = toc_anchor_map;
        ρσ_modules["read_book.globals"].set_toc_anchor_map = set_toc_anchor_map;
        ρσ_modules["read_book.globals"].set_system_colors = set_system_colors;
        ρσ_modules["read_book.globals"].clear_annot_id_uuid_map = clear_annot_id_uuid_map;
        ρσ_modules["read_book.globals"].is_dark_theme = is_dark_theme;
    })();

    (function(){
        var __name__ = "read_book.viewport";
        var FUNCTIONS, scroll_viewport, attr;
        FUNCTIONS = "x y scroll_to scroll_into_view reset_globals __reset_transforms window_scroll_pos content_size".split(" ");
        var get_boss = ρσ_modules["read_book.globals"].get_boss;
        var viewport_mode_changer = ρσ_modules["read_book.globals"].viewport_mode_changer;

        var document_height = ρσ_modules.utils.document_height;
        var document_width = ρσ_modules.utils.document_width;
        var ios_major_version = ρσ_modules.utils.ios_major_version;

        function ScrollViewport() {
            if (this.ρσ_object_id === undefined) Object.defineProperty(this, "ρσ_object_id", {"value":++ρσ_object_counter});
            ScrollViewport.prototype.__bind_methods__.call(this);
            ScrollViewport.prototype.__init__.apply(this, arguments);
        }
        Object.defineProperty(ScrollViewport.prototype, "__bind_methods__", {value: function () {
            this.set_mode = ScrollViewport.prototype.set_mode.bind(this);
            this.initialize_on_layout = ScrollViewport.prototype.initialize_on_layout.bind(this);
            this.flow_x = ScrollViewport.prototype.flow_x.bind(this);
            this.flow_y = ScrollViewport.prototype.flow_y.bind(this);
            this.flow_window_scroll_pos = ScrollViewport.prototype.flow_window_scroll_pos.bind(this);
            this.inline_pos = ScrollViewport.prototype.inline_pos.bind(this);
            this.block_pos = ScrollViewport.prototype.block_pos.bind(this);
            this.flow_scroll_to = ScrollViewport.prototype.flow_scroll_to.bind(this);
            this.scroll_to_in_inline_direction = ScrollViewport.prototype.scroll_to_in_inline_direction.bind(this);
            this.scroll_to_in_block_direction = ScrollViewport.prototype.scroll_to_in_block_direction.bind(this);
            this.flow_scroll_into_view = ScrollViewport.prototype.flow_scroll_into_view.bind(this);
            this.scroll_by = ScrollViewport.prototype.scroll_by.bind(this);
            this.scroll_by_in_inline_direction = ScrollViewport.prototype.scroll_by_in_inline_direction.bind(this);
            this.scroll_by_in_block_direction = ScrollViewport.prototype.scroll_by_in_block_direction.bind(this);
            this.flow_reset_globals = ScrollViewport.prototype.flow_reset_globals.bind(this);
            this.flow___reset_transforms = ScrollViewport.prototype.flow___reset_transforms.bind(this);
            this.flow_content_size = ScrollViewport.prototype.flow_content_size.bind(this);
            this.paged_content_inline_size = ScrollViewport.prototype.paged_content_inline_size.bind(this);
            this.paged_content_block_size = ScrollViewport.prototype.paged_content_block_size.bind(this);
            this.inline_size = ScrollViewport.prototype.inline_size.bind(this);
            this.block_size = ScrollViewport.prototype.block_size.bind(this);
            this.update_window_size = ScrollViewport.prototype.update_window_size.bind(this);
            this.width = ScrollViewport.prototype.width.bind(this);
            this.height = ScrollViewport.prototype.height.bind(this);
            this.document_inline_size = ScrollViewport.prototype.document_inline_size.bind(this);
            this.document_block_size = ScrollViewport.prototype.document_block_size.bind(this);
            this.viewport_to_document = ScrollViewport.prototype.viewport_to_document.bind(this);
            this.rect_inline_start = ScrollViewport.prototype.rect_inline_start.bind(this);
            this.rect_inline_end = ScrollViewport.prototype.rect_inline_end.bind(this);
            this.rect_block_start = ScrollViewport.prototype.rect_block_start.bind(this);
            this.rect_block_end = ScrollViewport.prototype.rect_block_end.bind(this);
            this.rect_inline_size = ScrollViewport.prototype.rect_inline_size.bind(this);
            this.rect_block_size = ScrollViewport.prototype.rect_block_size.bind(this);
            this.viewport_to_document_inline = ScrollViewport.prototype.viewport_to_document_inline.bind(this);
            this.viewport_to_document_block = ScrollViewport.prototype.viewport_to_document_block.bind(this);
            this.viewport_to_document_inline_block = ScrollViewport.prototype.viewport_to_document_inline_block.bind(this);
        }});
        ScrollViewport.prototype.__init__ = function __init__() {
            var self = this;
            self.set_mode("flow");
            self.window_width_from_parent = self.window_height_from_parent = null;
            self.rtl = false;
            self.ltr = true;
            self.vertical_writing_mode = false;
            self.horizontal_writing_mode = true;
        };
        if (!ScrollViewport.prototype.__init__.__module__) Object.defineProperties(ScrollViewport.prototype.__init__, {
            __module__ : {value: "read_book.viewport"}
        });
        ScrollViewport.__argnames__ = ScrollViewport.prototype.__init__.__argnames__;
        ScrollViewport.__handles_kwarg_interpolation__ = ScrollViewport.prototype.__init__.__handles_kwarg_interpolation__;
        ScrollViewport.prototype.set_mode = function set_mode(mode) {
            var self = this;
            var prefix, attr;
            prefix = ((mode === "flow") ? "flow" : "paged") + "_";
            var ρσ_Iter0 = ρσ_Iterable(FUNCTIONS);
            for (var ρσ_Index0 = 0; ρσ_Index0 < ρσ_Iter0.length; ρσ_Index0++) {
                attr = ρσ_Iter0[ρσ_Index0];
                self[(typeof attr === "number" && attr < 0) ? self.length + attr : attr] = self[ρσ_bound_index(prefix + attr, self)];
            }
        };
        if (!ScrollViewport.prototype.set_mode.__argnames__) Object.defineProperties(ScrollViewport.prototype.set_mode, {
            __argnames__ : {value: ["mode"]},
            __module__ : {value: "read_book.viewport"}
        });
        ScrollViewport.prototype.initialize_on_layout = function initialize_on_layout(body_style) {
            var self = this;
            var css_vertical_rl, css_vertical_lr;
            self.horizontal_writing_mode = true;
            self.vertical_writing_mode = false;
            self.ltr = true;
            self.rtl = false;
            if (body_style.direction === "rtl") {
                self.rtl = true;
                self.ltr = false;
            }
            css_vertical_rl = body_style.getPropertyValue("writing-mode") === "vertical-rl";
            if (css_vertical_rl) {
                self.vertical_writing_mode = true;
                self.horizontal_writing_mode = false;
                self.rtl = true;
                self.ltr = false;
            } else {
                css_vertical_lr = body_style.getPropertyValue("writing-mode") === "vertical-lr";
                if (css_vertical_lr) {
                    self.vertical_writing_mode = true;
                    self.horizontal_writing_mode = false;
                    self.ltr = true;
                    self.rtl = false;
                }
            }
        };
        if (!ScrollViewport.prototype.initialize_on_layout.__argnames__) Object.defineProperties(ScrollViewport.prototype.initialize_on_layout, {
            __argnames__ : {value: ["body_style"]},
            __module__ : {value: "read_book.viewport"}
        });
        ScrollViewport.prototype.flow_x = function flow_x() {
            var self = this;
            if (self.rtl) {
                return -window.pageXOffset;
            }
            return window.pageXOffset;
        };
        if (!ScrollViewport.prototype.flow_x.__module__) Object.defineProperties(ScrollViewport.prototype.flow_x, {
            __module__ : {value: "read_book.viewport"}
        });
        ScrollViewport.prototype.flow_y = function flow_y() {
            var self = this;
            return window.pageYOffset;
        };
        if (!ScrollViewport.prototype.flow_y.__module__) Object.defineProperties(ScrollViewport.prototype.flow_y, {
            __module__ : {value: "read_book.viewport"}
        });
        ScrollViewport.prototype.flow_window_scroll_pos = function flow_window_scroll_pos() {
            var self = this;
            return [window.pageXOffset, window.pageYOffset];
        };
        if (!ScrollViewport.prototype.flow_window_scroll_pos.__module__) Object.defineProperties(ScrollViewport.prototype.flow_window_scroll_pos, {
            __module__ : {value: "read_book.viewport"}
        });
        ScrollViewport.prototype.inline_pos = function inline_pos() {
            var self = this;
            if (self.vertical_writing_mode) {
                return self.y();
            }
            return self.x();
        };
        if (!ScrollViewport.prototype.inline_pos.__module__) Object.defineProperties(ScrollViewport.prototype.inline_pos, {
            __module__ : {value: "read_book.viewport"}
        });
        ScrollViewport.prototype.block_pos = function block_pos() {
            var self = this;
            if (self.horizontal_writing_mode) {
                return self.y();
            }
            return self.x();
        };
        if (!ScrollViewport.prototype.block_pos.__module__) Object.defineProperties(ScrollViewport.prototype.block_pos, {
            __module__ : {value: "read_book.viewport"}
        });
        ScrollViewport.prototype.flow_scroll_to = function flow_scroll_to(x, y) {
            var self = this;
            if (self.rtl) {
                window.scrollTo(-x, y);
            } else {
                window.scrollTo(x, y);
            }
        };
        if (!ScrollViewport.prototype.flow_scroll_to.__argnames__) Object.defineProperties(ScrollViewport.prototype.flow_scroll_to, {
            __argnames__ : {value: ["x", "y"]},
            __module__ : {value: "read_book.viewport"}
        });
        ScrollViewport.prototype.scroll_to_in_inline_direction = function scroll_to_in_inline_direction(pos, preserve_other) {
            var self = this;
            if (self.vertical_writing_mode) {
                self.scroll_to((preserve_other) ? self.x() : 0, pos);
            } else {
                self.scroll_to(pos, (preserve_other) ? self.y() : 0);
            }
        };
        if (!ScrollViewport.prototype.scroll_to_in_inline_direction.__argnames__) Object.defineProperties(ScrollViewport.prototype.scroll_to_in_inline_direction, {
            __argnames__ : {value: ["pos", "preserve_other"]},
            __module__ : {value: "read_book.viewport"}
        });
        ScrollViewport.prototype.scroll_to_in_block_direction = function scroll_to_in_block_direction(pos, preserve_other) {
            var self = this;
            if (self.horizontal_writing_mode) {
                self.scroll_to((preserve_other) ? self.x() : 0, pos);
            } else {
                self.scroll_to(pos, (preserve_other) ? self.y() : 0);
            }
        };
        if (!ScrollViewport.prototype.scroll_to_in_block_direction.__argnames__) Object.defineProperties(ScrollViewport.prototype.scroll_to_in_block_direction, {
            __argnames__ : {value: ["pos", "preserve_other"]},
            __module__ : {value: "read_book.viewport"}
        });
        ScrollViewport.prototype.flow_scroll_into_view = function flow_scroll_into_view(elem) {
            var self = this;
            elem.scrollIntoView();
        };
        if (!ScrollViewport.prototype.flow_scroll_into_view.__argnames__) Object.defineProperties(ScrollViewport.prototype.flow_scroll_into_view, {
            __argnames__ : {value: ["elem"]},
            __module__ : {value: "read_book.viewport"}
        });
        ScrollViewport.prototype.scroll_by = function scroll_by(x, y) {
            var self = this;
            if (self.ltr) {
                window.scrollBy(x, y);
            } else {
                window.scrollBy(-x, y);
            }
        };
        if (!ScrollViewport.prototype.scroll_by.__argnames__) Object.defineProperties(ScrollViewport.prototype.scroll_by, {
            __argnames__ : {value: ["x", "y"]},
            __module__ : {value: "read_book.viewport"}
        });
        ScrollViewport.prototype.scroll_by_in_inline_direction = function scroll_by_in_inline_direction(offset) {
            var self = this;
            if (self.vertical_writing_mode) {
                self.scroll_by(0, offset);
            } else {
                self.scroll_by(offset, 0);
            }
        };
        if (!ScrollViewport.prototype.scroll_by_in_inline_direction.__argnames__) Object.defineProperties(ScrollViewport.prototype.scroll_by_in_inline_direction, {
            __argnames__ : {value: ["offset"]},
            __module__ : {value: "read_book.viewport"}
        });
        ScrollViewport.prototype.scroll_by_in_block_direction = function scroll_by_in_block_direction(offset) {
            var self = this;
            if (self.horizontal_writing_mode) {
                self.scroll_by(0, offset);
            } else {
                self.scroll_by(offset, 0);
            }
        };
        if (!ScrollViewport.prototype.scroll_by_in_block_direction.__argnames__) Object.defineProperties(ScrollViewport.prototype.scroll_by_in_block_direction, {
            __argnames__ : {value: ["offset"]},
            __module__ : {value: "read_book.viewport"}
        });
        ScrollViewport.prototype.flow_reset_globals = function flow_reset_globals() {
            var self = this;
        };
        if (!ScrollViewport.prototype.flow_reset_globals.__module__) Object.defineProperties(ScrollViewport.prototype.flow_reset_globals, {
            __module__ : {value: "read_book.viewport"}
        });
        ScrollViewport.prototype.flow___reset_transforms = function flow___reset_transforms() {
            var self = this;
        };
        if (!ScrollViewport.prototype.flow___reset_transforms.__module__) Object.defineProperties(ScrollViewport.prototype.flow___reset_transforms, {
            __module__ : {value: "read_book.viewport"}
        });
        ScrollViewport.prototype.flow_content_size = function flow_content_size() {
            var self = this;
            return [document.documentElement.scrollWidth, document.documentElement.scrollHeight];
        };
        if (!ScrollViewport.prototype.flow_content_size.__module__) Object.defineProperties(ScrollViewport.prototype.flow_content_size, {
            __module__ : {value: "read_book.viewport"}
        });
        ScrollViewport.prototype.paged_content_inline_size = function paged_content_inline_size() {
            var self = this;
            var ρσ_unpack, w, h;
            ρσ_unpack = self.content_size();
ρσ_unpack = ρσ_unpack_asarray(2, ρσ_unpack);
            w = ρσ_unpack[0];
            h = ρσ_unpack[1];
            return (self.horizontal_writing_mode) ? w : h;
        };
        if (!ScrollViewport.prototype.paged_content_inline_size.__module__) Object.defineProperties(ScrollViewport.prototype.paged_content_inline_size, {
            __module__ : {value: "read_book.viewport"}
        });
        ScrollViewport.prototype.paged_content_block_size = function paged_content_block_size() {
            var self = this;
            var ρσ_unpack, w, h;
            ρσ_unpack = self.content_size();
ρσ_unpack = ρσ_unpack_asarray(2, ρσ_unpack);
            w = ρσ_unpack[0];
            h = ρσ_unpack[1];
            return (self.horizontal_writing_mode) ? h : w;
        };
        if (!ScrollViewport.prototype.paged_content_block_size.__module__) Object.defineProperties(ScrollViewport.prototype.paged_content_block_size, {
            __module__ : {value: "read_book.viewport"}
        });
        ScrollViewport.prototype.inline_size = function inline_size() {
            var self = this;
            if (self.horizontal_writing_mode) {
                return self.width();
            }
            return self.height();
        };
        if (!ScrollViewport.prototype.inline_size.__module__) Object.defineProperties(ScrollViewport.prototype.inline_size, {
            __module__ : {value: "read_book.viewport"}
        });
        ScrollViewport.prototype.block_size = function block_size() {
            var self = this;
            if (self.horizontal_writing_mode) {
                return self.height();
            }
            return self.width();
        };
        if (!ScrollViewport.prototype.block_size.__module__) Object.defineProperties(ScrollViewport.prototype.block_size, {
            __module__ : {value: "read_book.viewport"}
        });
        ScrollViewport.prototype.update_window_size = function update_window_size(w, h) {
            var self = this;
            self.window_width_from_parent = w;
            self.window_height_from_parent = h;
        };
        if (!ScrollViewport.prototype.update_window_size.__argnames__) Object.defineProperties(ScrollViewport.prototype.update_window_size, {
            __argnames__ : {value: ["w", "h"]},
            __module__ : {value: "read_book.viewport"}
        });
        ScrollViewport.prototype.width = function width() {
            var self = this;
            return window.innerWidth;
        };
        if (!ScrollViewport.prototype.width.__module__) Object.defineProperties(ScrollViewport.prototype.width, {
            __module__ : {value: "read_book.viewport"}
        });
        ScrollViewport.prototype.height = function height() {
            var self = this;
            return window.innerHeight;
        };
        if (!ScrollViewport.prototype.height.__module__) Object.defineProperties(ScrollViewport.prototype.height, {
            __module__ : {value: "read_book.viewport"}
        });
        ScrollViewport.prototype.document_inline_size = function document_inline_size() {
            var self = this;
            if (self.horizontal_writing_mode) {
                return document_width();
            }
            return document_height();
        };
        if (!ScrollViewport.prototype.document_inline_size.__module__) Object.defineProperties(ScrollViewport.prototype.document_inline_size, {
            __module__ : {value: "read_book.viewport"}
        });
        ScrollViewport.prototype.document_block_size = function document_block_size() {
            var self = this;
            if (self.horizontal_writing_mode) {
                return document_height();
            }
            return document_width();
        };
        if (!ScrollViewport.prototype.document_block_size.__module__) Object.defineProperties(ScrollViewport.prototype.document_block_size, {
            __module__ : {value: "read_book.viewport"}
        });
        ScrollViewport.prototype.viewport_to_document = function viewport_to_document(x, y, doc) {
            var self = this;
            var topdoc, frame, rect, ρσ_unpack, wx, wy;
            doc = doc || window.document;
            topdoc = window.document;
            while (doc !== topdoc && doc.defaultView) {
                frame = doc.defaultView.frameElement;
                rect = frame.getBoundingClientRect();
                x += rect.left;
                y += rect.top;
                doc = frame.ownerDocument;
            }
            ρσ_unpack = self.window_scroll_pos();
ρσ_unpack = ρσ_unpack_asarray(2, ρσ_unpack);
            wx = ρσ_unpack[0];
            wy = ρσ_unpack[1];
            x += wx;
            y += wy;
            if (self.rtl) {
                x *= -1;
            }
            return [x, y];
        };
        if (!ScrollViewport.prototype.viewport_to_document.__argnames__) Object.defineProperties(ScrollViewport.prototype.viewport_to_document, {
            __argnames__ : {value: ["x", "y", "doc"]},
            __module__ : {value: "read_book.viewport"}
        });
        ScrollViewport.prototype.rect_inline_start = function rect_inline_start(rect) {
            var self = this;
            if (self.horizontal_writing_mode) {
                return (self.ltr) ? rect.left : rect.right;
            }
            return rect.top;
        };
        if (!ScrollViewport.prototype.rect_inline_start.__argnames__) Object.defineProperties(ScrollViewport.prototype.rect_inline_start, {
            __argnames__ : {value: ["rect"]},
            __module__ : {value: "read_book.viewport"}
        });
        ScrollViewport.prototype.rect_inline_end = function rect_inline_end(rect) {
            var self = this;
            if (self.horizontal_writing_mode) {
                return (self.ltr) ? rect.right : rect.left;
            }
            return rect.bottom;
        };
        if (!ScrollViewport.prototype.rect_inline_end.__argnames__) Object.defineProperties(ScrollViewport.prototype.rect_inline_end, {
            __argnames__ : {value: ["rect"]},
            __module__ : {value: "read_book.viewport"}
        });
        ScrollViewport.prototype.rect_block_start = function rect_block_start(rect) {
            var self = this;
            if (self.horizontal_writing_mode) {
                return rect.top;
            }
            return (self.ltr) ? rect.left : rect.right;
        };
        if (!ScrollViewport.prototype.rect_block_start.__argnames__) Object.defineProperties(ScrollViewport.prototype.rect_block_start, {
            __argnames__ : {value: ["rect"]},
            __module__ : {value: "read_book.viewport"}
        });
        ScrollViewport.prototype.rect_block_end = function rect_block_end(rect) {
            var self = this;
            if (self.horizontal_writing_mode) {
                return rect.bottom;
            }
            return (self.ltr) ? rect.right : rect.left;
        };
        if (!ScrollViewport.prototype.rect_block_end.__argnames__) Object.defineProperties(ScrollViewport.prototype.rect_block_end, {
            __argnames__ : {value: ["rect"]},
            __module__ : {value: "read_book.viewport"}
        });
        ScrollViewport.prototype.rect_inline_size = function rect_inline_size(rect) {
            var self = this;
            if (self.horizontal_writing_mode) {
                return rect.width;
            }
            return rect.height;
        };
        if (!ScrollViewport.prototype.rect_inline_size.__argnames__) Object.defineProperties(ScrollViewport.prototype.rect_inline_size, {
            __argnames__ : {value: ["rect"]},
            __module__ : {value: "read_book.viewport"}
        });
        ScrollViewport.prototype.rect_block_size = function rect_block_size(rect) {
            var self = this;
            if (self.horizontal_writing_mode) {
                return rect.height;
            }
            return rect.width;
        };
        if (!ScrollViewport.prototype.rect_block_size.__argnames__) Object.defineProperties(ScrollViewport.prototype.rect_block_size, {
            __argnames__ : {value: ["rect"]},
            __module__ : {value: "read_book.viewport"}
        });
        ScrollViewport.prototype.viewport_to_document_inline = function viewport_to_document_inline(pos, doc) {
            var self = this;
            if (self.horizontal_writing_mode) {
                return self.viewport_to_document(pos, 0, doc)[0];
            }
            return self.viewport_to_document(0, pos, doc)[1];
        };
        if (!ScrollViewport.prototype.viewport_to_document_inline.__argnames__) Object.defineProperties(ScrollViewport.prototype.viewport_to_document_inline, {
            __argnames__ : {value: ["pos", "doc"]},
            __module__ : {value: "read_book.viewport"}
        });
        ScrollViewport.prototype.viewport_to_document_block = function viewport_to_document_block(pos, doc) {
            var self = this;
            if (self.horizontal_writing_mode) {
                return self.viewport_to_document(0, pos, doc)[1];
            }
            return self.viewport_to_document(pos, 0, doc)[0];
        };
        if (!ScrollViewport.prototype.viewport_to_document_block.__argnames__) Object.defineProperties(ScrollViewport.prototype.viewport_to_document_block, {
            __argnames__ : {value: ["pos", "doc"]},
            __module__ : {value: "read_book.viewport"}
        });
        ScrollViewport.prototype.viewport_to_document_inline_block = function viewport_to_document_inline_block(inline, block, doc) {
            var self = this;
            if (self.horizontal_writing_mode) {
                return self.viewport_to_document(inline, block, doc);
            }
            return self.viewport_to_document(block, inline, doc);
        };
        if (!ScrollViewport.prototype.viewport_to_document_inline_block.__argnames__) Object.defineProperties(ScrollViewport.prototype.viewport_to_document_inline_block, {
            __argnames__ : {value: ["inline", "block", "doc"]},
            __module__ : {value: "read_book.viewport"}
        });
        ScrollViewport.prototype.__repr__ = function __repr__ () {
                        return "<" + __name__ + "." + this.constructor.name + " #" + this.ρσ_object_id + ">";
        };
        ScrollViewport.prototype.__str__ = function __str__ () {
            return this.__repr__();
        };
        Object.defineProperty(ScrollViewport.prototype, "__bases__", {value: []});

        function IOSScrollViewport() {
            if (this.ρσ_object_id === undefined) Object.defineProperty(this, "ρσ_object_id", {"value":++ρσ_object_counter});
            IOSScrollViewport.prototype.__bind_methods__.call(this);
            IOSScrollViewport.prototype.__init__.apply(this, arguments);
        }
        ρσ_extends(IOSScrollViewport, ScrollViewport);
        Object.defineProperty(IOSScrollViewport.prototype, "__bind_methods__", {value: function () {
            ScrollViewport.prototype.__bind_methods__ && ScrollViewport.prototype.__bind_methods__.call(this);
            this.width = IOSScrollViewport.prototype.width.bind(this);
            this.height = IOSScrollViewport.prototype.height.bind(this);
            this._scroll_implementation = IOSScrollViewport.prototype._scroll_implementation.bind(this);
            this.paged_scroll_to = IOSScrollViewport.prototype.paged_scroll_to.bind(this);
            this.transform_val = IOSScrollViewport.prototype.transform_val.bind(this);
            this.paged_x = IOSScrollViewport.prototype.paged_x.bind(this);
            this.paged_y = IOSScrollViewport.prototype.paged_y.bind(this);
            this.paged_scroll_into_view = IOSScrollViewport.prototype.paged_scroll_into_view.bind(this);
            this.paged_window_scroll_pos = IOSScrollViewport.prototype.paged_window_scroll_pos.bind(this);
            this.paged_content_size = IOSScrollViewport.prototype.paged_content_size.bind(this);
            this.paged___reset_transforms = IOSScrollViewport.prototype.paged___reset_transforms.bind(this);
            this.paged_reset_globals = IOSScrollViewport.prototype.paged_reset_globals.bind(this);
        }});
        IOSScrollViewport.prototype.__init__ = function __init__ () {
            ScrollViewport.prototype.__init__ && ScrollViewport.prototype.__init__.apply(this, arguments);
        };
        IOSScrollViewport.prototype.width = function width() {
            var self = this;
            return self.window_width_from_parent || window.innerWidth;
        };
        if (!IOSScrollViewport.prototype.width.__module__) Object.defineProperties(IOSScrollViewport.prototype.width, {
            __module__ : {value: "read_book.viewport"}
        });
        IOSScrollViewport.prototype.height = function height() {
            var self = this;
            return self.window_height_from_parent || window.innerHeight;
        };
        if (!IOSScrollViewport.prototype.height.__module__) Object.defineProperties(IOSScrollViewport.prototype.height, {
            __module__ : {value: "read_book.viewport"}
        });
        IOSScrollViewport.prototype._scroll_implementation = function _scroll_implementation(x, y) {
            var self = this;
            if (x === 0 && y === 0) {
                document.documentElement.style.transform = "none";
            } else {
                x *= -1;
                y *= -1;
                document.documentElement.style.transform = "translateX(" + ρσ_str.format("{}", x) + "px) translateY(" + ρσ_str.format("{}", y) + "px)";
            }
        };
        if (!IOSScrollViewport.prototype._scroll_implementation.__argnames__) Object.defineProperties(IOSScrollViewport.prototype._scroll_implementation, {
            __argnames__ : {value: ["x", "y"]},
            __module__ : {value: "read_book.viewport"}
        });
        IOSScrollViewport.prototype.paged_scroll_to = function paged_scroll_to(x, y) {
            var self = this;
            var boss;
            x = x || 0;
            y = y || 0;
            if (self.ltr) {
                self._scroll_implementation(x, y);
            } else {
                self._scroll_implementation(-x, y);
            }
            boss = get_boss();
            if (boss) {
                boss.onscroll();
            }
        };
        if (!IOSScrollViewport.prototype.paged_scroll_to.__argnames__) Object.defineProperties(IOSScrollViewport.prototype.paged_scroll_to, {
            __argnames__ : {value: ["x", "y"]},
            __module__ : {value: "read_book.viewport"}
        });
        IOSScrollViewport.prototype.transform_val = function transform_val(y) {
            var self = this;
            var raw, idx, ans;
            raw = document.documentElement.style.transform;
            if (!raw || raw === "none") {
                return 0;
            }
            idx = (y) ? raw.lastIndexOf("(") : raw.indexOf("(");
            raw = raw.slice(idx + 1);
            ans = parseInt(raw);
            if (isNaN(ans)) {
                ans = 0;
            }
            return ans;
        };
        if (!IOSScrollViewport.prototype.transform_val.__argnames__) Object.defineProperties(IOSScrollViewport.prototype.transform_val, {
            __argnames__ : {value: ["y"]},
            __module__ : {value: "read_book.viewport"}
        });
        IOSScrollViewport.prototype.paged_x = function paged_x() {
            var self = this;
            var ans;
            ans = self.transform_val();
            if (self.ltr) {
                ans *= -1;
            }
            return ans;
        };
        if (!IOSScrollViewport.prototype.paged_x.__module__) Object.defineProperties(IOSScrollViewport.prototype.paged_x, {
            __module__ : {value: "read_book.viewport"}
        });
        IOSScrollViewport.prototype.paged_y = function paged_y() {
            var self = this;
            return -1 * self.transform_val(true);
        };
        if (!IOSScrollViewport.prototype.paged_y.__module__) Object.defineProperties(IOSScrollViewport.prototype.paged_y, {
            __module__ : {value: "read_book.viewport"}
        });
        IOSScrollViewport.prototype.paged_scroll_into_view = function paged_scroll_into_view(elem) {
            var self = this;
            var left, p;
            left = elem.offsetLeft;
            if (left === null) {
                return;
            }
            elem.scrollIntoView();
            window.scrollTo(0, 0);
            p = elem.offsetParent;
            while (p) {
                left += p.offsetLeft;
                p = p.offsetParent;
            }
            self._scroll_implementation(max(0, left), 0);
        };
        if (!IOSScrollViewport.prototype.paged_scroll_into_view.__argnames__) Object.defineProperties(IOSScrollViewport.prototype.paged_scroll_into_view, {
            __argnames__ : {value: ["elem"]},
            __module__ : {value: "read_book.viewport"}
        });
        IOSScrollViewport.prototype.paged_window_scroll_pos = function paged_window_scroll_pos() {
            var self = this;
            return [self.transform_val(), self.transform_val(true)];
        };
        if (!IOSScrollViewport.prototype.paged_window_scroll_pos.__module__) Object.defineProperties(IOSScrollViewport.prototype.paged_window_scroll_pos, {
            __module__ : {value: "read_book.viewport"}
        });
        IOSScrollViewport.prototype.paged_content_size = function paged_content_size() {
            var self = this;
            var w, h;
            w = document.documentElement.scrollWidth;
            h = document.documentElement.scrollHeight;
            return [w - self.transform_val(), h - self.transform_val(true)];
        };
        if (!IOSScrollViewport.prototype.paged_content_size.__module__) Object.defineProperties(IOSScrollViewport.prototype.paged_content_size, {
            __module__ : {value: "read_book.viewport"}
        });
        IOSScrollViewport.prototype.paged___reset_transforms = function paged___reset_transforms() {
            var self = this;
            var s;
            s = document.documentElement.style;
            if (s.transform !== "none") {
                s.transform = "none";
            }
        };
        if (!IOSScrollViewport.prototype.paged___reset_transforms.__module__) Object.defineProperties(IOSScrollViewport.prototype.paged___reset_transforms, {
            __module__ : {value: "read_book.viewport"}
        });
        IOSScrollViewport.prototype.paged_reset_globals = function paged_reset_globals() {
            var self = this;
            self.__reset_transforms();
        };
        if (!IOSScrollViewport.prototype.paged_reset_globals.__module__) Object.defineProperties(IOSScrollViewport.prototype.paged_reset_globals, {
            __module__ : {value: "read_book.viewport"}
        });
        IOSScrollViewport.prototype.__repr__ = function __repr__ () {
            if(ScrollViewport.prototype.__repr__) return ScrollViewport.prototype.__repr__.call(this);
            return "<" + __name__ + "." + this.constructor.name + " #" + this.ρσ_object_id + ">";
        };
        IOSScrollViewport.prototype.__str__ = function __str__ () {
            if(ScrollViewport.prototype.__str__) return ScrollViewport.prototype.__str__.call(this);
return this.__repr__();
        };
        Object.defineProperty(IOSScrollViewport.prototype, "__bases__", {value: [ScrollViewport]});

        if (1 < ios_major_version && ios_major_version < 15) {
            scroll_viewport = new IOSScrollViewport;
        } else {
            scroll_viewport = new ScrollViewport;
        }
        var ρσ_Iter1 = ρσ_Iterable(FUNCTIONS);
        for (var ρσ_Index1 = 0; ρσ_Index1 < ρσ_Iter1.length; ρσ_Index1++) {
            attr = ρσ_Iter1[ρσ_Index1];
            if (!scroll_viewport[ρσ_bound_index("paged_" + attr, scroll_viewport)]) {
                scroll_viewport[ρσ_bound_index("paged_" + attr, scroll_viewport)] = scroll_viewport[(typeof attr === "number" && attr < 0) ? scroll_viewport.length + attr : attr];
            }
        }
        viewport_mode_changer(scroll_viewport.set_mode);
        function get_unit_size_in_pixels(unit) {
            var d, ans;
            d = document.createElement("span");
            d.style.position = "absolute";
            d.style.visibility = "hidden";
            d.style.width = "1" + ρσ_str.format("{}", unit) + "";
            d.style.fontSize = "1" + ρσ_str.format("{}", unit) + "";
            d.style.paddingTop = d.style.paddingBottom = d.style.paddingLeft = d.style.paddingRight = "0";
            d.style.marginTop = d.style.marginBottom = d.style.marginLeft = d.style.marginRight = "0";
            d.style.borderStyle = "none";
            document.body.appendChild(d);
            ans = d.clientWidth;
            document.body.removeChild(d);
            return ans;
        };
        if (!get_unit_size_in_pixels.__argnames__) Object.defineProperties(get_unit_size_in_pixels, {
            __argnames__ : {value: ["unit"]},
            __module__ : {value: "read_book.viewport"}
        });

        function rem_size(reset) {
            var d;
            if (reset) {
                rem_size.ans = null;
                return;
            }
            if (!rem_size.ans) {
                d = document.createElement("span");
                d.style.position = "absolute";
                d.style.visibility = "hidden";
                d.style.width = "1rem";
                d.style.fontSize = "1rem";
                d.style.paddingTop = d.style.paddingBottom = d.style.paddingLeft = d.style.paddingRight = "0";
                d.style.marginTop = d.style.marginBottom = d.style.marginLeft = d.style.marginRight = "0";
                d.style.borderStyle = "none";
                document.body.appendChild(d);
                rem_size.ans = max(2, d.clientWidth);
                document.body.removeChild(d);
            }
            return rem_size.ans;
        };
        if (!rem_size.__argnames__) Object.defineProperties(rem_size, {
            __argnames__ : {value: ["reset"]},
            __module__ : {value: "read_book.viewport"}
        });

        function line_height(reset) {
            var ds, lh;
            if (reset) {
                line_height.ans = null;
                return;
            }
            if (!line_height.ans) {
                ds = window.getComputedStyle(document.body);
                try {
                    lh = float(ds.lineHeight);
                } catch (ρσ_Exception) {
                    ρσ_last_exception = ρσ_Exception;
                    {
                        try {
                            lh = 1.2 * float(ds.fontSize);
                        } catch (ρσ_Exception) {
                            ρσ_last_exception = ρσ_Exception;
                            {
                                lh = 15;
                            } 
                        }
                    } 
                }
                line_height.ans = max(5, lh);
            }
            return line_height.ans;
        };
        if (!line_height.__argnames__) Object.defineProperties(line_height, {
            __argnames__ : {value: ["reset"]},
            __module__ : {value: "read_book.viewport"}
        });

        ρσ_modules["read_book.viewport"].FUNCTIONS = FUNCTIONS;
        ρσ_modules["read_book.viewport"].scroll_viewport = scroll_viewport;
        ρσ_modules["read_book.viewport"].attr = attr;
        ρσ_modules["read_book.viewport"].ScrollViewport = ScrollViewport;
        ρσ_modules["read_book.viewport"].IOSScrollViewport = IOSScrollViewport;
        ρσ_modules["read_book.viewport"].get_unit_size_in_pixels = get_unit_size_in_pixels;
        ρσ_modules["read_book.viewport"].rem_size = rem_size;
        ρσ_modules["read_book.viewport"].line_height = line_height;
    })();

    (function(){
        var __name__ = "read_book.cfi";
        var escape_pat, unescape_pat;
        var scroll_viewport = ρσ_modules["read_book.viewport"].scroll_viewport;
        var rem_size = ρσ_modules["read_book.viewport"].rem_size;

        escape_pat = /[\[\],^();~@!]/g;
        unescape_pat = /[\^](.)/g;
        function escape_for_cfi(raw) {
            return (raw || "").replace(escape_pat, "^$&");
        };
        if (!escape_for_cfi.__argnames__) Object.defineProperties(escape_for_cfi, {
            __argnames__ : {value: ["raw"]},
            __module__ : {value: "read_book.cfi"}
        });

        function unescape_from_cfi(raw) {
            return (raw || "").replace(unescape_pat, "$1");
        };
        if (!unescape_from_cfi.__argnames__) Object.defineProperties(unescape_from_cfi, {
            __argnames__ : {value: ["raw"]},
            __module__ : {value: "read_book.cfi"}
        });

        function fstr(d) {
            var ans, n;
            ans = "";
            if (d < 0) {
                ans = "-";
                d = -d;
            }
            n = Math.floor(d);
            ans += n;
            n = Math.round((d - n) * 100);
            if (n !== 0) {
                ans += "." + ((n % 10 === 0) ? n / 10 : n);
            }
            return ans;
        };
        if (!fstr.__argnames__) Object.defineProperties(fstr, {
            __argnames__ : {value: ["d"]},
            __module__ : {value: "read_book.cfi"}
        });

        function get_current_time(target) {
            return fstr(target.currentTime || 0);
        };
        if (!get_current_time.__argnames__) Object.defineProperties(get_current_time, {
            __argnames__ : {value: ["target"]},
            __module__ : {value: "read_book.cfi"}
        });

        function id_is_unique(idval) {
            var multiples;
            try {
                multiples = document.querySelectorAll("[id=" + window.CSS.escape(idval) + "]");
            } catch (ρσ_Exception) {
                ρσ_last_exception = ρσ_Exception;
                {
                    return false;
                } 
            }
            if (multiples && multiples.length < 2) {
                return true;
            }
            return false;
        };
        if (!id_is_unique.__argnames__) Object.defineProperties(id_is_unique, {
            __argnames__ : {value: ["idval"]},
            __module__ : {value: "read_book.cfi"}
        });

        function range_has_point(range_, x, y) {
            var rects, rect;
            rects = range_.getClientRects();
            for (var i = 0; i < rects.length; i++) {
                rect = rects[(typeof i === "number" && i < 0) ? rects.length + i : i];
                if (rect.left <= x && x <= rect.right && rect.top <= y && y <= rect.bottom) {
                    return true;
                }
            }
            return false;
        };
        if (!range_has_point.__argnames__) Object.defineProperties(range_has_point, {
            __argnames__ : {value: ["range_", "x", "y"]},
            __module__ : {value: "read_book.cfi"}
        });

        function offset_in_text_node(node, range_, x, y) {
            var limits, pivot, lr, rr;
            limits = [0, node.nodeValue.length];
            while (limits[0] !== limits[1]) {
                pivot = Math.floor((limits[0] + limits[1]) / 2);
                lr = [limits[0], pivot];
                rr = [pivot+1, limits[1]];
                range_.setStart(node, pivot);
                range_.setEnd(node, pivot + 1);
                if (range_has_point(range_, x, y)) {
                    return pivot;
                }
                range_.setStart(node, rr[0]);
                range_.setEnd(node, rr[1]);
                if (range_has_point(range_, x, y)) {
                    limits = rr;
                    continue;
                }
                range_.setStart(node, lr[0]);
                range_.setEnd(node, lr[1]);
                if (range_has_point(range_, x, y)) {
                    limits = lr;
                    continue;
                }
                break;
            }
            return limits[0];
        };
        if (!offset_in_text_node.__argnames__) Object.defineProperties(offset_in_text_node, {
            __argnames__ : {value: ["node", "range_", "x", "y"]},
            __module__ : {value: "read_book.cfi"}
        });

        function find_offset_for_point(x, y, node, cdoc) {
            var range_, child;
            range_ = cdoc.createRange();
            child = node.firstChild;
            while (child) {
                if (Node.TEXT_NODE <= (ρσ_cond_temp = child.nodeType) && ρσ_cond_temp <= Node.ENTITY_NODE && child.nodeValue && child.nodeValue.length) {
                    range_.setStart(child, 0);
                    range_.setEnd(child, child.nodeValue.length);
                    if (range_has_point(range_, x, y)) {
                        return [child, offset_in_text_node(child, range_, x, y)];
                    }
                }
                child = child.nextSibling;
            }
            return [null, null];
        };
        if (!find_offset_for_point.__argnames__) Object.defineProperties(find_offset_for_point, {
            __argnames__ : {value: ["x", "y", "node", "cdoc"]},
            __module__ : {value: "read_book.cfi"}
        });

        function set_current_time(target, val) {
            if (target.currentTime === undefined) {
                return;
            }
            if (target.readyState === 4 || target.readyState === "complete") {
                target.currentTime = val + 0;
            } else {
                target.addEventListener("canplay", (function() {
                    var ρσ_anonfunc = function () {
                        target.currentTime = val;
                    };
                    if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
                        __module__ : {value: "read_book.cfi"}
                    });
                    return ρσ_anonfunc;
                })(), false);
            }
        };
        if (!set_current_time.__argnames__) Object.defineProperties(set_current_time, {
            __argnames__ : {value: ["target", "val"]},
            __module__ : {value: "read_book.cfi"}
        });

        function is_text_node(node) {
            return node.nodeType === Node.TEXT_NODE || node.nodeType === Node.CDATA_SECTION_NODE;
        };
        if (!is_text_node.__argnames__) Object.defineProperties(is_text_node, {
            __argnames__ : {value: ["node"]},
            __module__ : {value: "read_book.cfi"}
        });

        function text_length_in_range_wrapper(node) {
            var p, ans;
            p = node.firstChild;
            ans = 0;
            while (p) {
                if (is_text_node(p)) {
                    ans += p.nodeValue.length;
                } else if (p.nodeType === Node.ELEMENT_NODE && ρσ_exists.d(p.dataset).calibreRangeWrapper) {
                    ans += text_length_in_range_wrapper(p);
                }
                p = p.nextSibling;
            }
            return ans;
        };
        if (!text_length_in_range_wrapper.__argnames__) Object.defineProperties(text_length_in_range_wrapper, {
            __argnames__ : {value: ["node"]},
            __module__ : {value: "read_book.cfi"}
        });

        function adjust_node_for_text_offset(node) {
            var offset, adjusted, p;
            if (node.parentNode && ρσ_exists.d(node.parentNode.dataset).calibreRangeWrapper) {
                node = node.parentNode;
            }
            offset = 0;
            adjusted = false;
            while (true) {
                p = node.previousSibling;
                if (!p || p.nodeType > Node.COMMENT_NODE) {
                    break;
                }
                if (is_text_node(p)) {
                    offset += p.nodeValue.length;
                } else if (p.nodeType === Node.ELEMENT_NODE && ρσ_exists.d(p.dataset).calibreRangeWrapper) {
                    offset += text_length_in_range_wrapper(p);
                }
                node = p;
                adjusted = true;
            }
            if (adjusted && node.nodeType === Node.ELEMENT_NODE && ρσ_exists.d(node.dataset).calibreRangeWrapper) {
                if (!node.firstChild || node.firstChild.nodeType !== Node.TEXT_NODE) {
                    node.insertBefore(document.createTextNode(""), node.firstChild || null);
                }
                node = node.firstChild;
            }
            return [node, offset, adjusted];
        };
        if (!adjust_node_for_text_offset.__argnames__) Object.defineProperties(adjust_node_for_text_offset, {
            __argnames__ : {value: ["node"]},
            __module__ : {value: "read_book.cfi"}
        });

        function unwrapped_nodes(range_wrapper) {
            var ans, child;
            ans = [];
            var ρσ_Iter0 = ρσ_Iterable(range_wrapper.childNodes);
            for (var ρσ_Index0 = 0; ρσ_Index0 < ρσ_Iter0.length; ρσ_Index0++) {
                child = ρσ_Iter0[ρσ_Index0];
                if (child.nodeType === Node.ELEMENT_NODE && ρσ_exists.d(child.dataset).calibreRangeWrapper) {
                    ans = ans.concat(unwrapped_nodes(child));
                } else {
                    ans.push(child);
                }
            }
            return ans;
        };
        if (!unwrapped_nodes.__argnames__) Object.defineProperties(unwrapped_nodes, {
            __argnames__ : {value: ["range_wrapper"]},
            __module__ : {value: "read_book.cfi"}
        });

        function increment_index_for_child(child, index, sentinel) {
            var is_element, nodes;
            is_element = child.nodeType === Node.ELEMENT_NODE;
            if (is_element && ρσ_exists.d(child.dataset).calibreRangeWrapper) {
                nodes = unwrapped_nodes(child);
                index = increment_index_for_children(nodes, index, sentinel);
            } else {
                index |= 1;
                if (is_element) {
                    index += 1;
                }
            }
            return index;
        };
        if (!increment_index_for_child.__argnames__) Object.defineProperties(increment_index_for_child, {
            __argnames__ : {value: ["child", "index", "sentinel"]},
            __module__ : {value: "read_book.cfi"}
        });

        function increment_index_for_children(children, index, sentinel) {
            var child, i;
            for (var ρσ_Index1 = 0; ρσ_Index1 < children.length; ρσ_Index1++) {
                i = ρσ_Index1;
                child = children[(typeof i === "number" && i < 0) ? children.length + i : i];
                index = increment_index_for_child(child, index, sentinel);
                if (child === sentinel) {
                    break;
                }
            }
            return index;
        };
        if (!increment_index_for_children.__argnames__) Object.defineProperties(increment_index_for_children, {
            __argnames__ : {value: ["children", "index", "sentinel"]},
            __module__ : {value: "read_book.cfi"}
        });

        function non_range_wrapper_parent(node) {
            var p, child;
            p = node.parentNode;
            child = node;
            while (ρσ_exists.d(p.dataset).calibreRangeWrapper) {
                child = p;
                p = p.parentNode;
            }
            return [p, child];
        };
        if (!non_range_wrapper_parent.__argnames__) Object.defineProperties(non_range_wrapper_parent, {
            __argnames__ : {value: ["node"]},
            __module__ : {value: "read_book.cfi"}
        });

        function encode(doc, node, offset, tail) {
            var cfi, q, ρσ_unpack, adjusted_node, additional_offset, adjusted, is_first, p, sentinel, win, index, id, idspec;
            cfi = tail || "";
            if (node.nodeType === Node.ELEMENT_NODE) {
                if (typeof offset === "number") {
                    q = node.childNodes.item(offset);
                    if (q) {
                        if (q.nodeType === Node.ELEMENT_NODE) {
                            node = q;
                            if (ρσ_exists.d(node.dataset).calibreRangeWrapper) {
                                if (!node.firstChild) {
                                    node.appendChild(document.createTextNode(""));
                                }
                                node = node.firstChild;
                            }
                        }
                    }
                } else if (ρσ_exists.d(node.dataset).calibreRangeWrapper) {
                    if (!node.firstChild) {
                        node.appendChild(document.createTextNode(""));
                    }
                    node = node.firstChild;
                }
            }
            if (is_text_node(node)) {
                offset = offset || 0;
                ρσ_unpack = adjust_node_for_text_offset(node);
ρσ_unpack = ρσ_unpack_asarray(3, ρσ_unpack);
                adjusted_node = ρσ_unpack[0];
                additional_offset = ρσ_unpack[1];
                adjusted = ρσ_unpack[2];
                if (adjusted) {
                    node = adjusted_node;
                    offset += additional_offset;
                }
                cfi = ":" + offset + cfi;
            } else if (node.nodeType !== Node.ELEMENT_NODE) {
                print("Offsets for nodes of type " + ρσ_str.format("{}", node.nodeType) + " are not handled");
            }
            is_first = true;
            while (node !== doc) {
                ρσ_unpack = non_range_wrapper_parent(node);
ρσ_unpack = ρσ_unpack_asarray(2, ρσ_unpack);
                p = ρσ_unpack[0];
                sentinel = ρσ_unpack[1];
                if (!p) {
                    if ((node.nodeType === Node.DOCUMENT_NODE || typeof node.nodeType === "object" && ρσ_equals(node.nodeType, Node.DOCUMENT_NODE))) {
                        win = node.defaultView;
                        if (win.frameElement) {
                            node = win.frameElement;
                            cfi = "!" + cfi;
                            continue;
                        }
                    }
                    break;
                }
                index = increment_index_for_children(p.childNodes, 0, sentinel);
                if (is_first) {
                    is_first = false;
                    if (node.nodeType === Node.ELEMENT_NODE && ρσ_exists.d(node.dataset).calibreRangeWrapper) {
                        index -= 1;
                    }
                }
                id = node.id;
                idspec = "";
                if (id && id_is_unique(id)) {
                    idspec = "[" + escape_for_cfi(id) + "]";
                }
                cfi = "/" + index + idspec + cfi;
                node = p;
            }
            return cfi;
        };
        if (!encode.__argnames__) Object.defineProperties(encode, {
            __argnames__ : {value: ["doc", "node", "offset", "tail"]},
            __module__ : {value: "read_book.cfi"}
        });

        function node_at_index(nodes, target, index, iter_text_nodes) {
            var node, is_element, ρσ_unpack, q, i;
            for (var ρσ_Index2 = 0; ρσ_Index2 < nodes.length; ρσ_Index2++) {
                i = ρσ_Index2;
                node = nodes[(typeof i === "number" && i < 0) ? nodes.length + i : i];
                is_element = node.nodeType === Node.ELEMENT_NODE;
                if (is_element && ρσ_exists.d(node.dataset).calibreRangeWrapper) {
                    ρσ_unpack = node_at_index(unwrapped_nodes(node), target, index, iter_text_nodes);
ρσ_unpack = ρσ_unpack_asarray(2, ρσ_unpack);
                    q = ρσ_unpack[0];
                    index = ρσ_unpack[1];
                    if (q) {
                        return [q, index];
                    }
                    continue;
                }
                if (iter_text_nodes && !is_text_node(node) || !iter_text_nodes && !is_element) {
                    continue;
                }
                if (index === target) {
                    return [node, index];
                }
                index += 1;
            }
            return [null, index];
        };
        if (!node_at_index.__argnames__) Object.defineProperties(node_at_index, {
            __argnames__ : {value: ["nodes", "target", "index", "iter_text_nodes"]},
            __module__ : {value: "read_book.cfi"}
        });

        function node_for_path_step(parent, target, assertion) {
            var q, is_element;
            if (assertion) {
                q = document.getElementById(assertion);
                if (q && id_is_unique(assertion)) {
                    return q;
                }
            }
            is_element = ρσ_equals(target % 2, 0);
            target = Math.floor(target / 2);
            if (is_element && target > 0) {
                target -= 1;
            }
            return node_at_index(parent.childNodes, target, 0, !is_element)[0];
        };
        if (!node_for_path_step.__argnames__) Object.defineProperties(node_for_path_step, {
            __argnames__ : {value: ["parent", "target", "assertion"]},
            __module__ : {value: "read_book.cfi"}
        });

        function node_for_text_offset(nodes, offset, first_node) {
            var last_text_node, seen_first, node, l, ρσ_unpack, qn, ok, i;
            last_text_node = null;
            seen_first = false;
            for (var ρσ_Index3 = 0; ρσ_Index3 < nodes.length; ρσ_Index3++) {
                i = ρσ_Index3;
                node = nodes[(typeof i === "number" && i < 0) ? nodes.length + i : i];
                if (!seen_first) {
                    if (!first_node || node.isSameNode(first_node)) {
                        seen_first = true;
                    } else {
                        continue;
                    }
                }
                if (is_text_node(node)) {
                    l = node.nodeValue.length;
                    if (offset <= l) {
                        return [node, offset, true];
                    }
                    last_text_node = node;
                    offset -= l;
                } else if (node.nodeType === Node.ELEMENT_NODE && ρσ_exists.d(node.dataset).calibreRangeWrapper) {
                    ρσ_unpack = node_for_text_offset(unwrapped_nodes(node), offset);
ρσ_unpack = ρσ_unpack_asarray(3, ρσ_unpack);
                    qn = ρσ_unpack[0];
                    offset = ρσ_unpack[1];
                    ok = ρσ_unpack[2];
                    if (ok) {
                        return [qn, offset, true];
                    }
                }
            }
            return [last_text_node, offset, false];
        };
        if (!node_for_text_offset.__argnames__) Object.defineProperties(node_for_text_offset, {
            __argnames__ : {value: ["nodes", "offset", "first_node"]},
            __module__ : {value: "read_book.cfi"}
        });

        function decode(cfi, doc) {
            var simple_node_regex, error, node, orig_cfi, r, target, assertion, q, decoded, offset, orig_offset, ρσ_unpack, qnode, ok;
            doc = doc || window.document;
            simple_node_regex = /^\/(\d+)(\[[^\]]*\])?/;
            error = null;
            node = doc;
            orig_cfi = cfi;
            while (cfi.length > 0 && !error) {
                r = cfi.match(simple_node_regex);
                if (r) {
                    target = parseInt(r[1]);
                    assertion = r[2];
                    if (assertion) {
                        assertion = unescape_from_cfi(assertion.slice(1, assertion.length - 1));
                    }
                    q = node_for_path_step(node, target, assertion);
                    if (q) {
                        node = q;
                        cfi = cfi.substr(r[0].length);
                    } else {
                        if (target) {
                            error = "No matching child found for CFI: " + ρσ_str.format("{}", orig_cfi) + " leftover: " + ρσ_str.format("{}", cfi) + "";
                            break;
                        } else {
                            cfi = cfi.substr(r[0].length);
                        }
                    }
                } else if (cfi[0] === "!") {
                    if (node.contentDocument) {
                        node = node.contentDocument;
                        cfi = cfi.substr(1);
                    } else {
                        error = "Cannot reference " + node.nodeName + "'s content: " + cfi;
                    }
                } else {
                    break;
                }
            }
            if (error) {
                print(error);
                return null;
            }
            decoded = Object.create(null);
            error = null;
            offset = null;
            r = cfi.match(/^:(\d+)/);
            if (r) {
                offset = parseInt(r[1]);
                cfi = cfi.substr(r[0].length);
            }
            r = cfi.match(/^~(-?\d+(\.\d+)?)/);
            if (r) {
                decoded.time = r[1] - 0;
                cfi = cfi.substr(r[0].length);
            }
            r = cfi.match(/^@(-?\d+(\.\d+)?):(-?\d+(\.\d+)?)/);
            if (r) {
                decoded.x = r[1] - 0;
                decoded.y = r[3] - 0;
                cfi = cfi.substr(r[0].length);
            }
            r = cfi.match(/^\[([^\]]+)\]/);
            if (r) {
                assertion = r[1];
                cfi = cfi.substr(r[0].length);
                r = assertion.match(/;s=([ab])$/);
                if (r) {
                    if (r.index > 0 && assertion[ρσ_bound_index(r.index - 1, assertion)] !== "^") {
                        assertion = assertion.substr(0, r.index);
                        decoded.forward = r[1] === "a";
                    }
                    assertion = unescape_from_cfi(assertion);
                }
            }
            if (offset !== null) {
                orig_offset = offset;
                if (ρσ_exists.d(node.parentNode).nodeType === Node.ELEMENT_NODE && ρσ_exists.d(node.parentNode.dataset).calibreRangeWrapper) {
                    node = node.parentNode;
                }
                ρσ_unpack = node_for_text_offset(node.parentNode.childNodes, offset, node);
ρσ_unpack = ρσ_unpack_asarray(3, ρσ_unpack);
                qnode = ρσ_unpack[0];
                offset = ρσ_unpack[1];
                ok = ρσ_unpack[2];
                if (!ok) {
                    error = "Offset out of range: " + orig_offset;
                }
                if (qnode) {
                    node = qnode;
                }
                decoded.offset = offset;
            }
            decoded.node = node;
            if (error) {
                decoded.error = error;
            } else if (cfi.length > 0) {
                decoded.error = "Undecoded CFI: " + cfi;
            }
            if (decoded.error) {
                print(decoded.error);
            }
            return decoded;
        };
        if (!decode.__argnames__) Object.defineProperties(decode, {
            __argnames__ : {value: ["cfi", "doc"]},
            __module__ : {value: "read_book.cfi"}
        });

        function cfi_sort_key(cfi) {
            var simple_node_regex, steps, r, target, ans, offset;
            simple_node_regex = /^\/(\d+)(\[[^\]]*\])?/;
            steps = [];
            while (cfi.length > 0) {
                r = cfi.match(simple_node_regex);
                if (r) {
                    target = parseInt(r[1]);
                    cfi = cfi.substr(r[0].length);
                    steps.push(target);
                } else if (cfi[0] === "!") {
                    cfi = cfi.substr(1);
                } else {
                    break;
                }
            }
            ans = (function(){
                var ρσ_d = Object.create(null);
                ρσ_d["steps"] = steps;
                ρσ_d["text_offset"] = 0;
                ρσ_d["temporal_offset"] = 0;
                ρσ_d["spatial_offset"] = [0, 0];
                return ρσ_d;
            }).call(this);
            r = cfi.match(/^:(\d+)/);
            if (r) {
                offset = parseInt(r[1]);
                ans["text_offset"] = offset;
                cfi = cfi.substr(r[0].length);
            }
            r = cfi.match(/^~(-?\d+(\.\d+)?)/);
            if (r) {
                ans["temporal_offset"] = r[1] - 0;
                cfi = cfi.substr(r[0].length);
            }
            r = cfi.match(/^@(-?\d+(\.\d+)?):(-?\d+(\.\d+)?)/);
            if (r) {
                ans["spatial_offset"] = [r[1] - 0, r[3] - 0];
                cfi = cfi.substr(r[0].length);
            }
            return ans;
        };
        if (!cfi_sort_key.__argnames__) Object.defineProperties(cfi_sort_key, {
            __argnames__ : {value: ["cfi"]},
            __module__ : {value: "read_book.cfi"}
        });

        function create_cfi_cmp(key_map) {
            if (!key_map) {
                key_map = Object.create(null);
            }
            function cfi_cmp(a_cfi, b_cfi) {
                var a, b, diff, i;
                a = key_map[(typeof a_cfi === "number" && a_cfi < 0) ? key_map.length + a_cfi : a_cfi];
                if (!a) {
                    a = key_map[(typeof a_cfi === "number" && a_cfi < 0) ? key_map.length + a_cfi : a_cfi] = cfi_sort_key(a_cfi);
                }
                b = key_map[(typeof b_cfi === "number" && b_cfi < 0) ? key_map.length + b_cfi : b_cfi];
                if (!b) {
                    b = key_map[(typeof b_cfi === "number" && b_cfi < 0) ? key_map.length + b_cfi : b_cfi] = cfi_sort_key(b_cfi);
                }
                var ρσ_Iter4 = ρσ_Iterable(range(min(a.steps.length, b.steps.length)));
                for (var ρσ_Index4 = 0; ρσ_Index4 < ρσ_Iter4.length; ρσ_Index4++) {
                    i = ρσ_Iter4[ρσ_Index4];
                    diff = (ρσ_expr_temp = a.steps)[(typeof i === "number" && i < 0) ? ρσ_expr_temp.length + i : i] - (ρσ_expr_temp = b.steps)[(typeof i === "number" && i < 0) ? ρσ_expr_temp.length + i : i];
                    if (diff !== 0) {
                        return diff;
                    }
                }
                diff = a.steps.length - b.steps.length;
                if (diff !== 0) {
                    return diff;
                }
                if (a.temporal_offset !== b.temporal_offset) {
                    return a.temporal_offset - b.temporal_offset;
                }
                if (a.spatial_offset[0] !== b.spatial_offset[0]) {
                    return a.spatial_offset[0] - b.spatial_offset[0];
                }
                if (a.spatial_offset[1] !== b.spatial_offset[1]) {
                    return a.spatial_offset[1] - b.spatial_offset[1];
                }
                if (a.text_offset !== b.text_offset) {
                    return a.text_offset - b.text_offset;
                }
                return 0;
            };
            if (!cfi_cmp.__argnames__) Object.defineProperties(cfi_cmp, {
                __argnames__ : {value: ["a_cfi", "b_cfi"]},
                __module__ : {value: "read_book.cfi"}
            });

            return cfi_cmp;
        };
        if (!create_cfi_cmp.__argnames__) Object.defineProperties(create_cfi_cmp, {
            __argnames__ : {value: ["key_map"]},
            __module__ : {value: "read_book.cfi"}
        });

        function sort_cfis(array_of_cfis) {
            var key_map, cfi;
            key_map = (function() {
                var ρσ_Iter = ρσ_Iterable(array_of_cfis), ρσ_Result = Object.create(null), cfi;
                for (var ρσ_Index = 0; ρσ_Index < ρσ_Iter.length; ρσ_Index++) {
                    cfi = ρσ_Iter[ρσ_Index];
                    ρσ_Result[cfi] = (cfi_sort_key(cfi));
                }
                return ρσ_Result;
            })();
            Array.prototype.sort.call(array_of_cfis, create_cfi_cmp(key_map));
        };
        if (!sort_cfis.__argnames__) Object.defineProperties(sort_cfis, {
            __argnames__ : {value: ["array_of_cfis"]},
            __module__ : {value: "read_book.cfi"}
        });

        function at(x, y, doc) {
            var cdoc, target, tail, offset, name, cd, rect, px, py, ρσ_unpack;
            doc = doc || window.document;
            cdoc = doc;
            target = null;
            tail = "";
            offset = null;
            name = null;
            while (true) {
                target = cdoc.elementFromPoint(x, y);
                if (!target || target === cdoc.documentElement || target === cdoc.body) {
                    return null;
                }
                name = target.localName;
                if (!ρσ_in(name, (function(){
                    var s = ρσ_set();
                    s.jsset.add("iframe");
                    s.jsset.add("embed");
                    s.jsset.add("object");
                    return s;
                })())) {
                    break;
                }
                cd = target.contentDocument;
                if (!cd) {
                    break;
                }
                rect = target.getBoundingClientRect();
                x -= rect.left;
                y -= rect.top;
                cdoc = cd;
            }
            (target.parentNode || target).normalize();
            if (ρσ_in(name, (function(){
                var s = ρσ_set();
                s.jsset.add("audio");
                s.jsset.add("video");
                return s;
            })())) {
                tail = "~" + get_current_time(target);
            }
            if (ρσ_in(name, (function(){
                var s = ρσ_set();
                s.jsset.add("img");
                s.jsset.add("video");
                return s;
            })())) {
                rect = target.getBoundingClientRect();
                px = (x - rect.left) * 100 / target.offsetWidth;
                py = (y - rect.top) * 100 / target.offsetHeight;
                tail = str.format("{}@{}:{}", tail, fstr(px), fstr(py));
            } else if (name !== "audio") {
                ρσ_unpack = find_offset_for_point(x, y, target, cdoc);
ρσ_unpack = ρσ_unpack_asarray(2, ρσ_unpack);
                target = ρσ_unpack[0];
                offset = ρσ_unpack[1];
                if (target === null) {
                    return null;
                }
            }
            return encode(doc, target, offset, tail);
        };
        if (!at.__argnames__) Object.defineProperties(at, {
            __argnames__ : {value: ["x", "y", "doc"]},
            __module__ : {value: "read_book.cfi"}
        });

        function decode_with_range(cfi, doc) {
            var decoded, node, ndoc, range_, position_at_end_of_range, node_len, offset, rect;
            doc = doc || window.document;
            decoded = decode(cfi, doc);
            if (!decoded || !decoded.node) {
                return null;
            }
            node = decoded.node;
            ndoc = node.ownerDocument;
            if (!ndoc) {
                print(str.format("CFI node has no owner document: {} {}", cfi, node));
                return null;
            }
            range_ = null;
            position_at_end_of_range = null;
            if (typeof decoded.offset === "number") {
                node_len = (node.nodeValue) ? node.nodeValue.length : 0;
                if (!node_len && ρσ_exists.d(ρσ_exists.d(node.nextSibling).dataset).calibreRangeWrapper && ρσ_exists.d(node.nextSibling.firstChild).nodeType === Node.TEXT_NODE) {
                    node = node.nextSibling.firstChild;
                    node_len = (node.nodeValue) ? node.nodeValue.length : 0;
                }
                if (node_len) {
                    range_ = ndoc.createRange();
                    offset = decoded.offset;
                    position_at_end_of_range = false;
                    if (offset >= node_len) {
                        offset = node_len - 1;
                        position_at_end_of_range = true;
                    }
                    range_.setStart(node, offset);
                    range_.setEnd(node, offset + 1);
                    rect = range_.getBoundingClientRect();
                    if (!rect) {
                        print(str.format("Could not find caret position for {} (offset: {})", cfi, decoded.offset));
                        range_ = null;
                    }
                } else {
                    print("Caret offset pointed to an empty text node or a non-text node for " + ρσ_str.format("{}", cfi) + ", (offset: " + ρσ_str.format("{}", decoded.offset) + ")");
                    range_ = null;
                }
            }
            decoded.range = range_;
            decoded.use_range_end_pos = position_at_end_of_range;
            return decoded;
        };
        if (!decode_with_range.__argnames__) Object.defineProperties(decode_with_range, {
            __argnames__ : {value: ["cfi", "doc"]},
            __module__ : {value: "read_book.cfi"}
        });

        function decoded_range_to_document_position(decoded) {
            var rect, inserted_node, inline_vs_pos, block_vs_pos;
            rect = decoded.range.getBoundingClientRect();
            inserted_node = null;
            if (!rect.width && !rect.height && !rect.left && !rect.right) {
                inserted_node = document.createTextNode(" ");
                decoded.range.insertNode(inserted_node);
                rect = decoded.range.getBoundingClientRect();
            }
            if (decoded.use_range_end_pos) {
                inline_vs_pos = scroll_viewport.rect_inline_end(rect);
            } else {
                inline_vs_pos = scroll_viewport.rect_inline_start(rect);
            }
            if (decoded.forward) {
                block_vs_pos = scroll_viewport.rect_block_end(rect);
            } else {
                block_vs_pos = scroll_viewport.rect_block_start(rect);
            }
            if (inserted_node) {
                inserted_node.parentNode.removeChild(inserted_node);
            }
            return scroll_viewport.viewport_to_document_inline_block(inline_vs_pos, block_vs_pos, decoded.node.ownerDocument);
        };
        if (!decoded_range_to_document_position.__argnames__) Object.defineProperties(decoded_range_to_document_position, {
            __argnames__ : {value: ["decoded"]},
            __module__ : {value: "read_book.cfi"}
        });

        function decoded_node_or_spatial_offset_to_document_position(decoded) {
            var node, rect, ρσ_unpack, percentx, percenty, viewx, viewy, doc_left, doc_top, block_vs_pos, inline_vs_pos;
            node = decoded.node;
            rect = node.getBoundingClientRect();
            ρσ_unpack = [decoded.x, decoded.y];
            percentx = ρσ_unpack[0];
            percenty = ρσ_unpack[1];
            if (typeof percentx === "number" && node.offsetWidth && typeof percenty === "number" && node.offsetHeight) {
                viewx = rect.left + percentx * node.offsetWidth / 100;
                viewy = rect.top + percenty * node.offsetHeight / 100;
                ρσ_unpack = scroll_viewport.viewport_to_document(viewx, viewy, node.ownerDocument);
ρσ_unpack = ρσ_unpack_asarray(2, ρσ_unpack);
                doc_left = ρσ_unpack[0];
                doc_top = ρσ_unpack[1];
                return [doc_left, doc_top];
            } else {
                if (decoded.forward) {
                    block_vs_pos = scroll_viewport.rect_block_end(rect);
                } else {
                    block_vs_pos = scroll_viewport.rect_block_start(rect);
                }
                inline_vs_pos = scroll_viewport.rect_inline_start(rect);
                return scroll_viewport.viewport_to_document_inline_block(inline_vs_pos, block_vs_pos, node.ownerDocument);
            }
        };
        if (!decoded_node_or_spatial_offset_to_document_position.__argnames__) Object.defineProperties(decoded_node_or_spatial_offset_to_document_position, {
            __argnames__ : {value: ["decoded"]},
            __module__ : {value: "read_book.cfi"}
        });

        function decoded_to_document_position(decoded) {
            var node;
            node = decoded.node;
            if (decoded.range !== null) {
                return decoded_range_to_document_position(decoded);
            } else if (node !== null && node.getBoundingClientRect) {
                return decoded_node_or_spatial_offset_to_document_position(decoded);
            }
            return [null, null];
        };
        if (!decoded_to_document_position.__argnames__) Object.defineProperties(decoded_to_document_position, {
            __argnames__ : {value: ["decoded"]},
            __module__ : {value: "read_book.cfi"}
        });

        function scroll_to(cfi, callback, doc) {
            var decoded, fn;
            decoded = decode_with_range(cfi, doc);
            if (!decoded) {
                print("No location information found for cfi: " + cfi);
                return;
            }
            if (typeof decoded.time === "number") {
                set_current_time(decoded.node, decoded.time);
            }
            function handle_text_node() {
                var r, ρσ_unpack, so, eo, original_node, node_parent, original_node_index, ndoc, span;
                r = decoded.range;
                ρσ_unpack = [r.startOffset, r.endOffset];
                so = ρσ_unpack[0];
                eo = ρσ_unpack[1];
                original_node = r.startContainer;
                node_parent = original_node.parentNode;
                original_node_index = 0;
                for (var i = 0; i < node_parent.childNodes.length; i++) {
                    if ((ρσ_expr_temp = node_parent.childNodes)[(typeof i === "number" && i < 0) ? ρσ_expr_temp.length + i : i].isSameNode(original_node)) {
                        original_node_index = i;
                        break;
                    }
                }
                ndoc = original_node.ownerDocument || document;
                span = ndoc.createElement("span");
                span.setAttribute("style", "border-width: 0; padding: 0; margin: 0");
                r.surroundContents(span);
                scroll_viewport.scroll_into_view(span);
                return (function() {
                    var ρσ_anonfunc = function () {
                        var p, node, offset, ρσ_unpack, doc_x, doc_y;
                        p = span.parentNode;
                        var ρσ_Iter5 = ρσ_Iterable(span.childNodes);
                        for (var ρσ_Index5 = 0; ρσ_Index5 < ρσ_Iter5.length; ρσ_Index5++) {
                            node = ρσ_Iter5[ρσ_Index5];
                            span.removeChild(node);
                            p.insertBefore(node, span);
                        }
                        p.removeChild(span);
                        p.normalize();
                        original_node = (ρσ_expr_temp = node_parent.childNodes)[(typeof original_node_index === "number" && original_node_index < 0) ? ρσ_expr_temp.length + original_node_index : original_node_index];
                        if (!original_node) {
                            return;
                        }
                        offset = so;
                        while (offset > -1) {
                            try {
                                r.setStart(original_node, offset);
                                break;
                            } catch (ρσ_Exception) {
                                ρσ_last_exception = ρσ_Exception;
                                {
                                    offset -= 1;
                                } 
                            }
                        }
                        offset = eo;
                        while (offset > -1) {
                            try {
                                r.setEnd(original_node, offset);
                                break;
                            } catch (ρσ_Exception) {
                                ρσ_last_exception = ρσ_Exception;
                                {
                                    offset -= 1;
                                } 
                            }
                        }
                        ρσ_unpack = decoded_range_to_document_position(decoded);
ρσ_unpack = ρσ_unpack_asarray(2, ρσ_unpack);
                        doc_x = ρσ_unpack[0];
                        doc_y = ρσ_unpack[1];
                        if (doc_x === null || doc_y === null) {
                            return;
                        }
                        if (scroll_viewport.rtl) {
                            doc_x += scroll_viewport.width();
                        }
                        if (callback) {
                            callback(doc_x, doc_y);
                        }
                    };
                    if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
                        __module__ : {value: "read_book.cfi"}
                    });
                    return ρσ_anonfunc;
                })();
            };
            if (!handle_text_node.__module__) Object.defineProperties(handle_text_node, {
                __module__ : {value: "read_book.cfi"}
            });

            function handle_element_node() {
                var node;
                node = decoded.node;
                if (node.nodeType === Node.TEXT_NODE) {
                    node = decoded.node = node.parentNode;
                }
                if (!node.scrollIntoView) {
                    return;
                }
                scroll_viewport.scroll_into_view(node);
                return (function() {
                    var ρσ_anonfunc = function () {
                        var ρσ_unpack, doc_x, doc_y;
                        ρσ_unpack = decoded_node_or_spatial_offset_to_document_position(decoded);
ρσ_unpack = ρσ_unpack_asarray(2, ρσ_unpack);
                        doc_x = ρσ_unpack[0];
                        doc_y = ρσ_unpack[1];
                        if (doc_x === null || doc_y === null) {
                            return;
                        }
                        if (scroll_viewport.rtl) {
                            doc_x += scroll_viewport.width();
                        }
                        if (callback) {
                            callback(doc_x, doc_y);
                        }
                    };
                    if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
                        __module__ : {value: "read_book.cfi"}
                    });
                    return ρσ_anonfunc;
                })();
            };
            if (!handle_element_node.__module__) Object.defineProperties(handle_element_node, {
                __module__ : {value: "read_book.cfi"}
            });

            if (decoded.range !== null) {
                fn = handle_text_node();
            } else {
                fn = handle_element_node();
            }
            setTimeout(fn, 10);
        };
        if (!scroll_to.__argnames__) Object.defineProperties(scroll_to, {
            __argnames__ : {value: ["cfi", "callback", "doc"]},
            __module__ : {value: "read_book.cfi"}
        });

        function at_point(x, y) {
            var cfi, decoded, ρσ_unpack, cfix, cfiy;
            function dist(p1, p2) {
                Math.sqrt(Math.pow(p1[0] - p2[0], 2), Math.pow(p1[1] - p2[1], 2));
            };
            if (!dist.__argnames__) Object.defineProperties(dist, {
                __argnames__ : {value: ["p1", "p2"]},
                __module__ : {value: "read_book.cfi"}
            });

            try {
                cfi = at(x, y);
            } catch (ρσ_Exception) {
                ρσ_last_exception = ρσ_Exception;
                {
                    cfi = null;
                } 
            }
            if (cfi === null) {
                return null;
            }
            try {
                decoded = decode_with_range(cfi);
            } catch (ρσ_Exception) {
                ρσ_last_exception = ρσ_Exception;
                {
                    decoded = null;
                } 
            }
            if (!decoded) {
                return null;
            }
            if (cfi) {
                try {
                    ρσ_unpack = decoded_to_document_position(decoded);
ρσ_unpack = ρσ_unpack_asarray(2, ρσ_unpack);
                    cfix = ρσ_unpack[0];
                    cfiy = ρσ_unpack[1];
                } catch (ρσ_Exception) {
                    ρσ_last_exception = ρσ_Exception;
                    {
                        cfix = cfiy = null;
                    } 
                }
                if (cfix === null || cfiy === null || dist(scroll_viewport.viewport_to_document(x, y), [cfix, cfiy]) > 50) {
                    cfi = null;
                }
            }
            return cfi;
        };
        if (!at_point.__argnames__) Object.defineProperties(at_point, {
            __argnames__ : {value: ["x", "y"]},
            __module__ : {value: "read_book.cfi"}
        });

        function at_current() {
            var ρσ_unpack, wini, winb, deltai, deltab, startb, endb, starti, endi, up_boundb, up_boundi, low_boundb, low_boundi, at_point_conditional, curb, cfi, x, y, de, rect, px, py;
            ρσ_unpack = [scroll_viewport.inline_size() - 1, scroll_viewport.block_size() - 1];
            wini = ρσ_unpack[0];
            winb = ρσ_unpack[1];
            deltai = deltab = max(8, min(Math.ceil(rem_size() / 2), 32));
            if (scroll_viewport.horizontal_writing_mode) {
                startb = 0;
                endb = winb;
                if (scroll_viewport.ltr) {
                    starti = 0;
                    endi = wini;
                } else {
                    starti = wini;
                    endi = 0;
                    deltai = -deltai;
                }
            } else {
                starti = 0;
                endi = winb;
                if (scroll_viewport.rtl) {
                    startb = winb;
                    endb = 0;
                    deltab = -deltab;
                } else {
                    startb = 0;
                    endb = winb;
                }
            }
            up_boundb = max(startb, endb);
            up_boundi = max(starti, endi);
            low_boundb = min(startb, endb);
            low_boundi = min(starti, endi);
            function at_point_vertical_mode(i, b) {
                return at_point(b, i);
            };
            if (!at_point_vertical_mode.__argnames__) Object.defineProperties(at_point_vertical_mode, {
                __argnames__ : {value: ["i", "b"]},
                __module__ : {value: "read_book.cfi"}
            });

            at_point_conditional = (scroll_viewport.vertical_writing_mode) ? at_point_vertical_mode : at_point;
            function i_loop(curb) {
                var curi, cfi;
                curi = starti;
                while (low_boundi <= curi && curi <= up_boundi) {
                    cfi = at_point_conditional(curi, curb);
                    if (cfi) {
                        return cfi;
                    }
                    curi += deltai;
                }
            };
            if (!i_loop.__argnames__) Object.defineProperties(i_loop, {
                __argnames__ : {value: ["curb"]},
                __module__ : {value: "read_book.cfi"}
            });

            curb = startb;
            cfi = null;
            while (low_boundb <= curb && curb <= up_boundb && !cfi) {
                cfi = i_loop(curb);
                curb += deltab;
            }
            if (cfi) {
                return cfi;
            }
            ρσ_unpack = [scroll_viewport.x() + ((scroll_viewport.ltr) ? 0 : scroll_viewport.width()), 
            scroll_viewport.y()];
            x = ρσ_unpack[0];
            y = ρσ_unpack[1];
            de = document.documentElement;
            rect = de.getBoundingClientRect();
            px = x * 100 / rect.width;
            py = y * 100 / rect.height;
            cfi = str.format("/2@{}:{}", fstr(px), fstr(py));
            return cfi;
        };
        if (!at_current.__module__) Object.defineProperties(at_current, {
            __module__ : {value: "read_book.cfi"}
        });

        function cfi_for_selection(r) {
            if (!r) {
                r = window.getSelection().getRangeAt(0);
            }
            function pos(container, offset) {
                var nt;
                nt = container.nodeType;
                if (nt === Node.TEXT_NODE || nt === Node.CDATA_SECTION_NODE || nt === Node.COMMENT_NODE) {
                    return [container, offset];
                }
                if (nt === Node.ELEMENT_NODE && offset && container.childNodes.length > offset) {
                    return [(ρσ_expr_temp = container.childNodes)[(typeof offset === "number" && offset < 0) ? ρσ_expr_temp.length + offset : offset], 
                    0];
                }
                return [container, offset];
            };
            if (!pos.__argnames__) Object.defineProperties(pos, {
                __argnames__ : {value: ["container", "offset"]},
                __module__ : {value: "read_book.cfi"}
            });

            return (function(){
                var ρσ_d = Object.create(null);
                ρσ_d["start"] = encode.apply(this, [r.startContainer.ownerDocument].concat(pos(r.startContainer, r.startOffset)));
                ρσ_d["end"] = encode.apply(this, [r.endContainer.ownerDocument].concat(pos(r.endContainer, r.endOffset)));
                return ρσ_d;
            }).call(this);
        };
        if (!cfi_for_selection.__argnames__) Object.defineProperties(cfi_for_selection, {
            __argnames__ : {value: ["r"]},
            __module__ : {value: "read_book.cfi"}
        });

        function range_from_cfi(start, end) {
            var r;
            start = decode(start);
            end = decode(end);
            if (!start || start.error || !end || end.error) {
                return;
            }
            r = document.createRange();
            r.setStart(start.node, start.offset);
            r.setEnd(end.node, end.offset);
            return r;
        };
        if (!range_from_cfi.__argnames__) Object.defineProperties(range_from_cfi, {
            __argnames__ : {value: ["start", "end"]},
            __module__ : {value: "read_book.cfi"}
        });

        ρσ_modules["read_book.cfi"].escape_pat = escape_pat;
        ρσ_modules["read_book.cfi"].unescape_pat = unescape_pat;
        ρσ_modules["read_book.cfi"].escape_for_cfi = escape_for_cfi;
        ρσ_modules["read_book.cfi"].unescape_from_cfi = unescape_from_cfi;
        ρσ_modules["read_book.cfi"].fstr = fstr;
        ρσ_modules["read_book.cfi"].get_current_time = get_current_time;
        ρσ_modules["read_book.cfi"].id_is_unique = id_is_unique;
        ρσ_modules["read_book.cfi"].range_has_point = range_has_point;
        ρσ_modules["read_book.cfi"].offset_in_text_node = offset_in_text_node;
        ρσ_modules["read_book.cfi"].find_offset_for_point = find_offset_for_point;
        ρσ_modules["read_book.cfi"].set_current_time = set_current_time;
        ρσ_modules["read_book.cfi"].is_text_node = is_text_node;
        ρσ_modules["read_book.cfi"].text_length_in_range_wrapper = text_length_in_range_wrapper;
        ρσ_modules["read_book.cfi"].adjust_node_for_text_offset = adjust_node_for_text_offset;
        ρσ_modules["read_book.cfi"].unwrapped_nodes = unwrapped_nodes;
        ρσ_modules["read_book.cfi"].increment_index_for_child = increment_index_for_child;
        ρσ_modules["read_book.cfi"].increment_index_for_children = increment_index_for_children;
        ρσ_modules["read_book.cfi"].non_range_wrapper_parent = non_range_wrapper_parent;
        ρσ_modules["read_book.cfi"].encode = encode;
        ρσ_modules["read_book.cfi"].node_at_index = node_at_index;
        ρσ_modules["read_book.cfi"].node_for_path_step = node_for_path_step;
        ρσ_modules["read_book.cfi"].node_for_text_offset = node_for_text_offset;
        ρσ_modules["read_book.cfi"].decode = decode;
        ρσ_modules["read_book.cfi"].cfi_sort_key = cfi_sort_key;
        ρσ_modules["read_book.cfi"].create_cfi_cmp = create_cfi_cmp;
        ρσ_modules["read_book.cfi"].sort_cfis = sort_cfis;
        ρσ_modules["read_book.cfi"].at = at;
        ρσ_modules["read_book.cfi"].decode_with_range = decode_with_range;
        ρσ_modules["read_book.cfi"].decoded_range_to_document_position = decoded_range_to_document_position;
        ρσ_modules["read_book.cfi"].decoded_node_or_spatial_offset_to_document_position = decoded_node_or_spatial_offset_to_document_position;
        ρσ_modules["read_book.cfi"].decoded_to_document_position = decoded_to_document_position;
        ρσ_modules["read_book.cfi"].scroll_to = scroll_to;
        ρσ_modules["read_book.cfi"].at_point = at_point;
        ρσ_modules["read_book.cfi"].at_current = at_current;
        ρσ_modules["read_book.cfi"].cfi_for_selection = cfi_for_selection;
        ρσ_modules["read_book.cfi"].range_from_cfi = range_from_cfi;
    })();

    (function(){
        var __name__ = "read_book.annotations";
        var no_cfi, field_map, getter_map;
        var _ = ρσ_modules.gettext.gettext;

        var create_cfi_cmp = ρσ_modules["read_book.cfi"].create_cfi_cmp;
        var cfi_sort_key = ρσ_modules["read_book.cfi"].cfi_sort_key;

        var ui_operations = ρσ_modules["read_book.globals"].ui_operations;

        no_cfi = "/99999999";
        function bookmark_get_cfi(b) {
            if (b.pos_type === "epubcfi") {
                return b.pos.slice(8, -1);
            }
            return no_cfi;
        };
        if (!bookmark_get_cfi.__argnames__) Object.defineProperties(bookmark_get_cfi, {
            __argnames__ : {value: ["b"]},
            __module__ : {value: "read_book.annotations"}
        });

        function highlight_get_cfi(hl) {
            var cfi, si;
            cfi = hl.start_cfi;
            if (cfi) {
                si = (ρσ_exists.n(hl.spine_index)) ? "/" + ρσ_str.format("{}", hl.spine_index) + "" : no_cfi;
                return si + cfi;
            }
            return no_cfi;
        };
        if (!highlight_get_cfi.__argnames__) Object.defineProperties(highlight_get_cfi, {
            __argnames__ : {value: ["hl"]},
            __module__ : {value: "read_book.annotations"}
        });

        function sort_annot_list(annots, get_cfi_func) {
            var key_map, cfi, annot, cfi_cmp;
            key_map = (function(){
                var ρσ_d = Object.create(null);
                ρσ_d[no_cfi] = cfi_sort_key(no_cfi);
                return ρσ_d;
            }).call(this);
            var ρσ_Iter0 = ρσ_Iterable(annots);
            for (var ρσ_Index0 = 0; ρσ_Index0 < ρσ_Iter0.length; ρσ_Index0++) {
                annot = ρσ_Iter0[ρσ_Index0];
                cfi = get_cfi_func(annot);
                if (cfi && !key_map[(typeof cfi === "number" && cfi < 0) ? key_map.length + cfi : cfi]) {
                    key_map[(typeof cfi === "number" && cfi < 0) ? key_map.length + cfi : cfi] = cfi_sort_key(cfi);
                }
            }
            cfi_cmp = create_cfi_cmp(key_map);
            annots.sort((function() {
                var ρσ_anonfunc = function (a, b) {
                    var acfi, bcfi;
                    acfi = get_cfi_func(a);
                    bcfi = get_cfi_func(b);
                    return cfi_cmp(acfi, bcfi);
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["a", "b"]},
                    __module__ : {value: "read_book.annotations"}
                });
                return ρσ_anonfunc;
            })());
        };
        if (!sort_annot_list.__argnames__) Object.defineProperties(sort_annot_list, {
            __argnames__ : {value: ["annots", "get_cfi_func"]},
            __module__ : {value: "read_book.annotations"}
        });

        function annots_descending_cmp(a, b) {
            return (a.timestamp > b.timestamp) ? -1 : (a.timestamp < b.timestamp) ? 1 : 0;
        };
        if (!annots_descending_cmp.__argnames__) Object.defineProperties(annots_descending_cmp, {
            __argnames__ : {value: ["a", "b"]},
            __module__ : {value: "read_book.annotations"}
        });

        function merge_annots_with_identical_field(annots_a, annots_b, field, cfi_getter_func) {
            var title_groups, changed, all_annots, q, a, tg, seen, ans, title, candidates;
            title_groups = Object.create(null);
            changed = false;
            all_annots = annots_a.concat(annots_b);
            var ρσ_Iter1 = ρσ_Iterable(all_annots);
            for (var ρσ_Index1 = 0; ρσ_Index1 < ρσ_Iter1.length; ρσ_Index1++) {
                a = ρσ_Iter1[ρσ_Index1];
                q = title_groups[ρσ_bound_index(a[(typeof field === "number" && field < 0) ? a.length + field : field], title_groups)];
                if (!q) {
                    q = title_groups[ρσ_bound_index(a[(typeof field === "number" && field < 0) ? a.length + field : field], title_groups)] = [];
                }
                q.push(a);
            }
            var ρσ_Iter2 = ρσ_Iterable(Object.values(title_groups));
            for (var ρσ_Index2 = 0; ρσ_Index2 < ρσ_Iter2.length; ρσ_Index2++) {
                tg = ρσ_Iter2[ρσ_Index2];
                tg.sort(annots_descending_cmp);
            }
            seen = Object.create(null);
            ans = [];
            var ρσ_Iter3 = ρσ_Iterable(all_annots);
            for (var ρσ_Index3 = 0; ρσ_Index3 < ρσ_Iter3.length; ρσ_Index3++) {
                a = ρσ_Iter3[ρσ_Index3];
                title = a[(typeof field === "number" && field < 0) ? a.length + field : field];
                if (!seen[(typeof title === "number" && title < 0) ? seen.length + title : title]) {
                    seen[(typeof title === "number" && title < 0) ? seen.length + title : title] = true;
                    candidates = title_groups[(typeof title === "number" && title < 0) ? title_groups.length + title : title];
                    if (!changed && candidates.length > 1 && candidates[0].timestamp !== candidates[1].timestamp) {
                        changed = true;
                    }
                    ans.push(title_groups[(typeof title === "number" && title < 0) ? title_groups.length + title : title][0]);
                }
            }
            if (ans.length !== annots_a.length || ans.length !== annots_b.length) {
                changed = true;
            }
            if (changed) {
                sort_annot_list(ans, cfi_getter_func);
            }
            return [changed, ans];
        };
        if (!merge_annots_with_identical_field.__argnames__) Object.defineProperties(merge_annots_with_identical_field, {
            __argnames__ : {value: ["annots_a", "annots_b", "field", "cfi_getter_func"]},
            __module__ : {value: "read_book.annotations"}
        });

        field_map = (function(){
            var ρσ_d = Object.create(null);
            ρσ_d["bookmark"] = "title";
            ρσ_d["highlight"] = "uuid";
            return ρσ_d;
        }).call(this);
        getter_map = (function(){
            var ρσ_d = Object.create(null);
            ρσ_d["bookmark"] = bookmark_get_cfi;
            ρσ_d["highlight"] = highlight_get_cfi;
            return ρσ_d;
        }).call(this);
        function merge_annot_lists(a, b, field) {
            var key_field;
            key_field = field_map[(typeof field === "number" && field < 0) ? field_map.length + field : field];
            return merge_annots_with_identical_field(a, b, key_field, getter_map[(typeof field === "number" && field < 0) ? getter_map.length + field : field]);
        };
        if (!merge_annot_lists.__argnames__) Object.defineProperties(merge_annot_lists, {
            __argnames__ : {value: ["a", "b", "field"]},
            __module__ : {value: "read_book.annotations"}
        });

        function merge_annotation_maps(a, b) {
            var updated, ans, a_items, b_items, ρσ_unpack, changed, field;
            updated = false;
            ans = Object.create(null);
            var ρσ_Iter4 = ρσ_Iterable(field_map);
            for (var ρσ_Index4 = 0; ρσ_Index4 < ρσ_Iter4.length; ρσ_Index4++) {
                field = ρσ_Iter4[ρσ_Index4];
                a_items = a[(typeof field === "number" && field < 0) ? a.length + field : field] || [];
                b_items = b[(typeof field === "number" && field < 0) ? b.length + field : field] || [];
                if (!a_items.length) {
                    ans[(typeof field === "number" && field < 0) ? ans.length + field : field] = b_items;
                    updated = true;
                    continue;
                }
                if (!b_items.length) {
                    ans[(typeof field === "number" && field < 0) ? ans.length + field : field] = a_items;
                    continue;
                }
                ρσ_unpack = merge_annot_lists(a_items, b_items, field);
ρσ_unpack = ρσ_unpack_asarray(2, ρσ_unpack);
                changed = ρσ_unpack[0];
                ans[(typeof field === "number" && field < 0) ? ans.length + field : field] = ρσ_unpack[1];
                if (changed) {
                    updated = true;
                }
            }
            return [updated, ans];
        };
        if (!merge_annotation_maps.__argnames__) Object.defineProperties(merge_annotation_maps, {
            __argnames__ : {value: ["a", "b"]},
            __module__ : {value: "read_book.annotations"}
        });

        function AnnotationsManager() {
            if (this.ρσ_object_id === undefined) Object.defineProperty(this, "ρσ_object_id", {"value":++ρσ_object_counter});
            AnnotationsManager.prototype.__bind_methods__.call(this);
            AnnotationsManager.prototype.__init__.apply(this, arguments);
        }
        Object.defineProperty(AnnotationsManager.prototype, "__bind_methods__", {value: function () {
            this.sync_annots_to_server = AnnotationsManager.prototype.sync_annots_to_server.bind(this);
            this.set_bookmarks = AnnotationsManager.prototype.set_bookmarks.bind(this);
            this.all_bookmarks = AnnotationsManager.prototype.all_bookmarks.bind(this);
            this.add_bookmark = AnnotationsManager.prototype.add_bookmark.bind(this);
            this.remove_bookmark = AnnotationsManager.prototype.remove_bookmark.bind(this);
            this.edit_bookmark = AnnotationsManager.prototype.edit_bookmark.bind(this);
            this.default_bookmark_title = AnnotationsManager.prototype.default_bookmark_title.bind(this);
            this.set_highlights = AnnotationsManager.prototype.set_highlights.bind(this);
            this.all_highlights = AnnotationsManager.prototype.all_highlights.bind(this);
            this.merge_highlights = AnnotationsManager.prototype.merge_highlights.bind(this);
            this.remove_highlight = AnnotationsManager.prototype.remove_highlight.bind(this);
            this.delete_highlight = AnnotationsManager.prototype.delete_highlight.bind(this);
            this.notes_for_highlight = AnnotationsManager.prototype.notes_for_highlight.bind(this);
            this.text_for_highlight = AnnotationsManager.prototype.text_for_highlight.bind(this);
            this.set_notes_for_highlight = AnnotationsManager.prototype.set_notes_for_highlight.bind(this);
            this.style_for_highlight = AnnotationsManager.prototype.style_for_highlight.bind(this);
            this.data_for_highlight = AnnotationsManager.prototype.data_for_highlight.bind(this);
            this.spine_index_for_highlight = AnnotationsManager.prototype.spine_index_for_highlight.bind(this);
            this.cfi_for_highlight = AnnotationsManager.prototype.cfi_for_highlight.bind(this);
            this.add_highlight = AnnotationsManager.prototype.add_highlight.bind(this);
            this.highlights_for_currently_showing = AnnotationsManager.prototype.highlights_for_currently_showing.bind(this);
        }});
        AnnotationsManager.prototype.__init__ = function __init__(view) {
            var self = this;
            self.view = view;
            self.set_highlights();
            self.set_bookmarks();
        };
        if (!AnnotationsManager.prototype.__init__.__argnames__) Object.defineProperties(AnnotationsManager.prototype.__init__, {
            __argnames__ : {value: ["view"]},
            __module__ : {value: "read_book.annotations"}
        });
        AnnotationsManager.__argnames__ = AnnotationsManager.prototype.__init__.__argnames__;
        AnnotationsManager.__handles_kwarg_interpolation__ = AnnotationsManager.prototype.__init__.__handles_kwarg_interpolation__;
        AnnotationsManager.prototype.sync_annots_to_server = function sync_annots_to_server(which) {
            var self = this;
            var amap;
            if (ui_operations.annots_changed) {
                amap = Object.create(null);
                if (!which || which === "bookmarks") {
                    amap.bookmark = self.bookmarks.as_array();
                }
                if (!which || which === "highlights") {
                    amap.highlight = Object.values(self.highlights);
                }
                ui_operations.annots_changed(amap);
            }
        };
        if (!AnnotationsManager.prototype.sync_annots_to_server.__argnames__) Object.defineProperties(AnnotationsManager.prototype.sync_annots_to_server, {
            __argnames__ : {value: ["which"]},
            __module__ : {value: "read_book.annotations"}
        });
        AnnotationsManager.prototype.set_bookmarks = function set_bookmarks(bookmarks) {
            var self = this;
            bookmarks = bookmarks || [];
            self.bookmarks = list(bookmarks);
        };
        if (!AnnotationsManager.prototype.set_bookmarks.__argnames__) Object.defineProperties(AnnotationsManager.prototype.set_bookmarks, {
            __argnames__ : {value: ["bookmarks"]},
            __module__ : {value: "read_book.annotations"}
        });
        AnnotationsManager.prototype.all_bookmarks = function all_bookmarks() {
            var self = this;
            return self.bookmarks;
        };
        if (!AnnotationsManager.prototype.all_bookmarks.__module__) Object.defineProperties(AnnotationsManager.prototype.all_bookmarks, {
            __module__ : {value: "read_book.annotations"}
        });
        AnnotationsManager.prototype.add_bookmark = function add_bookmark(title, cfi) {
            var self = this;
            var b;
            if (!title || !cfi) {
                return;
            }
            self.bookmarks = (function() {
                var ρσ_Iter = ρσ_Iterable(self.bookmarks), ρσ_Result = [], b;
                for (var ρσ_Index = 0; ρσ_Index < ρσ_Iter.length; ρσ_Index++) {
                    b = ρσ_Iter[ρσ_Index];
                    if (b.title !== title) {
                        ρσ_Result.push(b);
                    }
                }
                ρσ_Result = ρσ_list_constructor(ρσ_Result);
                return ρσ_Result;
            })();
            self.bookmarks.push((function(){
                var ρσ_d = Object.create(null);
                ρσ_d["type"] = "bookmark";
                ρσ_d["timestamp"] = (new Date).toISOString();
                ρσ_d["pos_type"] = "epubcfi";
                ρσ_d["pos"] = cfi;
                ρσ_d["title"] = title;
                return ρσ_d;
            }).call(this));
            sort_annot_list(self.bookmarks, bookmark_get_cfi);
            self.sync_annots_to_server("bookmarks");
        };
        if (!AnnotationsManager.prototype.add_bookmark.__argnames__) Object.defineProperties(AnnotationsManager.prototype.add_bookmark, {
            __argnames__ : {value: ["title", "cfi"]},
            __module__ : {value: "read_book.annotations"}
        });
        AnnotationsManager.prototype.remove_bookmark = function remove_bookmark(title) {
            var self = this;
            var changed, b;
            changed = false;
            var ρσ_Iter5 = ρσ_Iterable(self.bookmarks);
            for (var ρσ_Index5 = 0; ρσ_Index5 < ρσ_Iter5.length; ρσ_Index5++) {
                b = ρσ_Iter5[ρσ_Index5];
                if (b.title === title) {
                    b.removed = true;
                    b.timestamp = (new Date).toISOString();
                    changed = true;
                }
            }
            if (changed) {
                self.sync_annots_to_server("bookmarks");
            }
            return changed;
        };
        if (!AnnotationsManager.prototype.remove_bookmark.__argnames__) Object.defineProperties(AnnotationsManager.prototype.remove_bookmark, {
            __argnames__ : {value: ["title"]},
            __module__ : {value: "read_book.annotations"}
        });
        AnnotationsManager.prototype.edit_bookmark = function edit_bookmark(title, new_title) {
            var self = this;
            var changed, b;
            changed = false;
            var ρσ_Iter6 = ρσ_Iterable(self.bookmarks);
            for (var ρσ_Index6 = 0; ρσ_Index6 < ρσ_Iter6.length; ρσ_Index6++) {
                b = ρσ_Iter6[ρσ_Index6];
                if (b.title === title) {
                    b.title = new_title;
                    b.timestamp = (new Date).toISOString();
                    changed = true;
                }
            }
            if (changed) {
                self.sync_annots_to_server("bookmarks");
            }
            return changed;
        };
        if (!AnnotationsManager.prototype.edit_bookmark.__argnames__) Object.defineProperties(AnnotationsManager.prototype.edit_bookmark, {
            __argnames__ : {value: ["title", "new_title"]},
            __module__ : {value: "read_book.annotations"}
        });
        AnnotationsManager.prototype.default_bookmark_title = function default_bookmark_title(base_default_title) {
            var self = this;
            var all_titles, bm, c, default_title;
            all_titles = (function() {
                var ρσ_Iter = ρσ_Iterable(self.bookmarks), ρσ_Result = Object.create(null), bm;
                for (var ρσ_Index = 0; ρσ_Index < ρσ_Iter.length; ρσ_Index++) {
                    bm = ρσ_Iter[ρσ_Index];
                    if (!bm.removed) {
                        ρσ_Result[bm.title] = (true);
                    }
                }
                return ρσ_Result;
            })();
            base_default_title = base_default_title || _("Bookmark");
            c = 0;
            while (true) {
                c += 1;
                default_title = "" + ρσ_str.format("{}", base_default_title) + " #" + ρσ_str.format("{}", c) + "";
                if (!all_titles[(typeof default_title === "number" && default_title < 0) ? all_titles.length + default_title : default_title]) {
                    return default_title;
                }
            }
        };
        if (!AnnotationsManager.prototype.default_bookmark_title.__argnames__) Object.defineProperties(AnnotationsManager.prototype.default_bookmark_title, {
            __argnames__ : {value: ["base_default_title"]},
            __module__ : {value: "read_book.annotations"}
        });
        AnnotationsManager.prototype.set_highlights = function set_highlights(highlights) {
            var self = this;
            var h;
            highlights = highlights || [];
            self.highlights = (function() {
                var ρσ_Iter = ρσ_Iterable(highlights), ρσ_Result = Object.create(null), h;
                for (var ρσ_Index = 0; ρσ_Index < ρσ_Iter.length; ρσ_Index++) {
                    h = ρσ_Iter[ρσ_Index];
                    ρσ_Result[h.uuid] = (h);
                }
                return ρσ_Result;
            })();
        };
        if (!AnnotationsManager.prototype.set_highlights.__argnames__) Object.defineProperties(AnnotationsManager.prototype.set_highlights, {
            __argnames__ : {value: ["highlights"]},
            __module__ : {value: "read_book.annotations"}
        });
        AnnotationsManager.prototype.all_highlights = function all_highlights() {
            var self = this;
            var ans;
            ans = (function() {
                var ρσ_Iter = ρσ_Iterable(Object.values(self.highlights)), ρσ_Result = [], h;
                for (var ρσ_Index = 0; ρσ_Index < ρσ_Iter.length; ρσ_Index++) {
                    h = ρσ_Iter[ρσ_Index];
                    if (!h.removed) {
                        ρσ_Result.push(h);
                    }
                }
                ρσ_Result = ρσ_list_constructor(ρσ_Result);
                return ρσ_Result;
            })().as_array();
            sort_annot_list(ans, highlight_get_cfi);
            return ans;
        };
        if (!AnnotationsManager.prototype.all_highlights.__module__) Object.defineProperties(AnnotationsManager.prototype.all_highlights, {
            __module__ : {value: "read_book.annotations"}
        });
        AnnotationsManager.prototype.merge_highlights = function merge_highlights(highlights) {
            var self = this;
            var updated, base, newvals, ρσ_unpack, ans;
            highlights = highlights || [];
            updated = false;
            if (highlights.length) {
                base = (function(){
                    var ρσ_d = Object.create(null);
                    ρσ_d["highlight"] = Object.values(self.highlights);
                    return ρσ_d;
                }).call(this);
                newvals = (function(){
                    var ρσ_d = Object.create(null);
                    ρσ_d["highlight"] = highlights;
                    return ρσ_d;
                }).call(this);
                ρσ_unpack = merge_annotation_maps(base, newvals);
ρσ_unpack = ρσ_unpack_asarray(2, ρσ_unpack);
                updated = ρσ_unpack[0];
                ans = ρσ_unpack[1];
                if (updated) {
                    self.set_highlights(ans.highlight);
                }
            }
            return updated;
        };
        if (!AnnotationsManager.prototype.merge_highlights.__argnames__) Object.defineProperties(AnnotationsManager.prototype.merge_highlights, {
            __argnames__ : {value: ["highlights"]},
            __module__ : {value: "read_book.annotations"}
        });
        AnnotationsManager.prototype.remove_highlight = function remove_highlight(uuid) {
            var self = this;
            var h;
            h = (ρσ_expr_temp = self.highlights)[(typeof uuid === "number" && uuid < 0) ? ρσ_expr_temp.length + uuid : uuid];
            if (h) {
                h.timestamp = (new Date).toISOString();
                h.removed = true;
                delete h.style;
                delete h.highlighted_text;
                delete h.start_cfi;
                delete h.end_cfi;
                delete h.notes;
                delete h.spine_name;
                delete h.spine_index;
                delete h.toc_family_titles;
                return true;
            }
        };
        if (!AnnotationsManager.prototype.remove_highlight.__argnames__) Object.defineProperties(AnnotationsManager.prototype.remove_highlight, {
            __argnames__ : {value: ["uuid"]},
            __module__ : {value: "read_book.annotations"}
        });
        AnnotationsManager.prototype.delete_highlight = function delete_highlight(uuid) {
            var self = this;
            if (self.remove_highlight(uuid)) {
                self.sync_annots_to_server("highlights");
            }
        };
        if (!AnnotationsManager.prototype.delete_highlight.__argnames__) Object.defineProperties(AnnotationsManager.prototype.delete_highlight, {
            __argnames__ : {value: ["uuid"]},
            __module__ : {value: "read_book.annotations"}
        });
        AnnotationsManager.prototype.notes_for_highlight = function notes_for_highlight(uuid) {
            var self = this;
            var h;
            h = (uuid) ? (ρσ_expr_temp = self.highlights)[(typeof uuid === "number" && uuid < 0) ? ρσ_expr_temp.length + uuid : uuid] : null;
            if (h) {
                return h.notes;
            }
        };
        if (!AnnotationsManager.prototype.notes_for_highlight.__argnames__) Object.defineProperties(AnnotationsManager.prototype.notes_for_highlight, {
            __argnames__ : {value: ["uuid"]},
            __module__ : {value: "read_book.annotations"}
        });
        AnnotationsManager.prototype.text_for_highlight = function text_for_highlight(uuid) {
            var self = this;
            var h;
            h = (uuid) ? (ρσ_expr_temp = self.highlights)[(typeof uuid === "number" && uuid < 0) ? ρσ_expr_temp.length + uuid : uuid] : null;
            if (h) {
                return h.highlighted_text;
            }
        };
        if (!AnnotationsManager.prototype.text_for_highlight.__argnames__) Object.defineProperties(AnnotationsManager.prototype.text_for_highlight, {
            __argnames__ : {value: ["uuid"]},
            __module__ : {value: "read_book.annotations"}
        });
        AnnotationsManager.prototype.set_notes_for_highlight = function set_notes_for_highlight(uuid, notes) {
            var self = this;
            var h;
            h = (ρσ_expr_temp = self.highlights)[(typeof uuid === "number" && uuid < 0) ? ρσ_expr_temp.length + uuid : uuid];
            if (h) {
                if (notes) {
                    h.notes = notes;
                } else {
                    delete h.notes;
                }
                self.sync_annots_to_server("highlights");
                return true;
            }
            return false;
        };
        if (!AnnotationsManager.prototype.set_notes_for_highlight.__argnames__) Object.defineProperties(AnnotationsManager.prototype.set_notes_for_highlight, {
            __argnames__ : {value: ["uuid", "notes"]},
            __module__ : {value: "read_book.annotations"}
        });
        AnnotationsManager.prototype.style_for_highlight = function style_for_highlight(uuid) {
            var self = this;
            var h;
            h = (ρσ_expr_temp = self.highlights)[(typeof uuid === "number" && uuid < 0) ? ρσ_expr_temp.length + uuid : uuid];
            if (h) {
                return h.style;
            }
        };
        if (!AnnotationsManager.prototype.style_for_highlight.__argnames__) Object.defineProperties(AnnotationsManager.prototype.style_for_highlight, {
            __argnames__ : {value: ["uuid"]},
            __module__ : {value: "read_book.annotations"}
        });
        AnnotationsManager.prototype.data_for_highlight = function data_for_highlight(uuid) {
            var self = this;
            return (ρσ_expr_temp = self.highlights)[(typeof uuid === "number" && uuid < 0) ? ρσ_expr_temp.length + uuid : uuid];
        };
        if (!AnnotationsManager.prototype.data_for_highlight.__argnames__) Object.defineProperties(AnnotationsManager.prototype.data_for_highlight, {
            __argnames__ : {value: ["uuid"]},
            __module__ : {value: "read_book.annotations"}
        });
        AnnotationsManager.prototype.spine_index_for_highlight = function spine_index_for_highlight(uuid, spine) {
            var self = this;
            var h, ans, name, idx;
            h = (ρσ_expr_temp = self.highlights)[(typeof uuid === "number" && uuid < 0) ? ρσ_expr_temp.length + uuid : uuid];
            if (!h) {
                return -1;
            }
            ans = h.spine_index;
            name = h.spine_name;
            if (name) {
                idx = spine.indexOf(name);
                if (idx > -1) {
                    ans = idx;
                }
            }
            return ans;
        };
        if (!AnnotationsManager.prototype.spine_index_for_highlight.__argnames__) Object.defineProperties(AnnotationsManager.prototype.spine_index_for_highlight, {
            __argnames__ : {value: ["uuid", "spine"]},
            __module__ : {value: "read_book.annotations"}
        });
        AnnotationsManager.prototype.cfi_for_highlight = function cfi_for_highlight(uuid, spine_index) {
            var self = this;
            var h, x;
            h = (ρσ_expr_temp = self.highlights)[(typeof uuid === "number" && uuid < 0) ? ρσ_expr_temp.length + uuid : uuid];
            if (h) {
                x = 2 * (spine_index + 1);
                return "epubcfi(/" + ρσ_str.format("{}", x) + "" + ρσ_str.format("{}", h.start_cfi) + ")";
            }
        };
        if (!AnnotationsManager.prototype.cfi_for_highlight.__argnames__) Object.defineProperties(AnnotationsManager.prototype.cfi_for_highlight, {
            __argnames__ : {value: ["uuid", "spine_index"]},
            __module__ : {value: "read_book.annotations"}
        });
        AnnotationsManager.prototype.add_highlight = function add_highlight(msg, style, notes, toc_family) {
            var self = this;
            var now, uuid, annot, toc_family_titles, x;
            now = (new Date).toISOString();
            var ρσ_Iter7 = ρσ_Iterable(msg.removed_highlights);
            for (var ρσ_Index7 = 0; ρσ_Index7 < ρσ_Iter7.length; ρσ_Index7++) {
                uuid = ρσ_Iter7[ρσ_Index7];
                self.remove_highlight(uuid);
            }
            annot = (ρσ_expr_temp = self.highlights)[ρσ_bound_index(msg.uuid, ρσ_expr_temp)] = (function(){
                var ρσ_d = Object.create(null);
                ρσ_d["type"] = "highlight";
                ρσ_d["timestamp"] = now;
                ρσ_d["uuid"] = msg.uuid;
                ρσ_d["highlighted_text"] = msg.highlighted_text;
                ρσ_d["start_cfi"] = msg.bounds.start;
                ρσ_d["end_cfi"] = msg.bounds.end;
                ρσ_d["style"] = style;
                ρσ_d["spine_name"] = self.view.currently_showing.name;
                ρσ_d["spine_index"] = self.view.currently_showing.spine_index;
                return ρσ_d;
            }).call(this);
            if (notes) {
                annot.notes = notes;
            }
            if ((typeof toc_family !== "undefined" && toc_family !== null ? toc_family : Object.create(null)).length) {
                toc_family_titles = [];
                var ρσ_Iter8 = ρσ_Iterable(toc_family);
                for (var ρσ_Index8 = 0; ρσ_Index8 < ρσ_Iter8.length; ρσ_Index8++) {
                    x = ρσ_Iter8[ρσ_Index8];
                    if (x.title) {
                        toc_family_titles.push(x.title);
                    }
                }
                annot.toc_family_titles = toc_family_titles;
            }
            self.sync_annots_to_server("highlights");
        };
        if (!AnnotationsManager.prototype.add_highlight.__argnames__) Object.defineProperties(AnnotationsManager.prototype.add_highlight, {
            __argnames__ : {value: ["msg", "style", "notes", "toc_family"]},
            __module__ : {value: "read_book.annotations"}
        });
        AnnotationsManager.prototype.highlights_for_currently_showing = function highlights_for_currently_showing() {
            var self = this;
            var name, ans, h;
            name = self.view.currently_showing.name;
            ans = [];
            var ρσ_Iter9 = ρσ_Iterable(Object.values(self.highlights));
            for (var ρσ_Index9 = 0; ρσ_Index9 < ρσ_Iter9.length; ρσ_Index9++) {
                h = ρσ_Iter9[ρσ_Index9];
                if (h.spine_name === name && !h.removed && h.start_cfi) {
                    ans.push(h);
                }
            }
            return ans;
        };
        if (!AnnotationsManager.prototype.highlights_for_currently_showing.__module__) Object.defineProperties(AnnotationsManager.prototype.highlights_for_currently_showing, {
            __module__ : {value: "read_book.annotations"}
        });
        AnnotationsManager.prototype.__repr__ = function __repr__ () {
                        return "<" + __name__ + "." + this.constructor.name + " #" + this.ρσ_object_id + ">";
        };
        AnnotationsManager.prototype.__str__ = function __str__ () {
            return this.__repr__();
        };
        Object.defineProperty(AnnotationsManager.prototype, "__bases__", {value: []});

        ρσ_modules["read_book.annotations"].no_cfi = no_cfi;
        ρσ_modules["read_book.annotations"].field_map = field_map;
        ρσ_modules["read_book.annotations"].getter_map = getter_map;
        ρσ_modules["read_book.annotations"].bookmark_get_cfi = bookmark_get_cfi;
        ρσ_modules["read_book.annotations"].highlight_get_cfi = highlight_get_cfi;
        ρσ_modules["read_book.annotations"].sort_annot_list = sort_annot_list;
        ρσ_modules["read_book.annotations"].annots_descending_cmp = annots_descending_cmp;
        ρσ_modules["read_book.annotations"].merge_annots_with_identical_field = merge_annots_with_identical_field;
        ρσ_modules["read_book.annotations"].merge_annot_lists = merge_annot_lists;
        ρσ_modules["read_book.annotations"].merge_annotation_maps = merge_annotation_maps;
        ρσ_modules["read_book.annotations"].AnnotationsManager = AnnotationsManager;
    })();

    (function(){
        var __name__ = "read_book.db";
        var DB_NAME, DB_VERSION;
        var base64decode = ρσ_modules.encodings.base64decode;
        var base64encode = ρσ_modules.encodings.base64encode;

        var _ = ρσ_modules.gettext.gettext;

        var is_reading_book = ρσ_modules["book_list.router"].is_reading_book;

        var error_dialog = ρσ_modules.modals.error_dialog;

        var merge_annotation_maps = ρσ_modules["read_book.annotations"].merge_annotation_maps;

        var get_interface_data = ρσ_modules.session.get_interface_data;

        var username_key = ρσ_modules.utils.username_key;

        function upgrade_schema(idb, old_version, new_version, transaction) {
            var books_store;
            print("upgrade_schema:", old_version, new_version);
            if (!idb.objectStoreNames.contains("books")) {
                idb.createObjectStore("books", (function(){
                    var ρσ_d = Object.create(null);
                    ρσ_d["keyPath"] = "key";
                    return ρσ_d;
                }).call(this));
            }
            if (!idb.objectStoreNames.contains("files")) {
                idb.createObjectStore("files");
            }
            if (!idb.objectStoreNames.contains("mathjax")) {
                idb.createObjectStore("mathjax");
            }
            if (!idb.objectStoreNames.contains("objects")) {
                idb.createObjectStore("objects", (function(){
                    var ρσ_d = Object.create(null);
                    ρσ_d["keyPath"] = "key";
                    return ρσ_d;
                }).call(this));
            }
            books_store = transaction.objectStore("books");
            if (!books_store.indexNames.contains("recent_index")) {
                books_store.createIndex("recent_index", "recent_date");
            }
        };
        if (!upgrade_schema.__argnames__) Object.defineProperties(upgrade_schema, {
            __argnames__ : {value: ["idb", "old_version", "new_version", "transaction"]},
            __module__ : {value: "read_book.db"}
        });

        function file_store_name(book, name) {
            return book.book_hash + " " + name;
        };
        if (!file_store_name.__argnames__) Object.defineProperties(file_store_name, {
            __argnames__ : {value: ["book", "name"]},
            __module__ : {value: "read_book.db"}
        });

        function get_error_details(event) {
            var desc;
            desc = event.target;
            if (desc.error && desc.error.toString) {
                desc = desc.error.toString();
            } else if (desc.errorCode) {
                desc = desc.errorCode;
            } else if (desc.error) {
                desc = desc.error;
                if (desc.name === "QuotaExceededError") {
                    desc = _("Offline storage quota exceeded! Try deleting some stored books first.");
                } else if (desc.name) {
                    desc = desc.name;
                }
            }
            return desc || "Unknown Error";
        };
        if (!get_error_details.__argnames__) Object.defineProperties(get_error_details, {
            __argnames__ : {value: ["event"]},
            __module__ : {value: "read_book.db"}
        });

        function new_book(key, metadata) {
            return (function(){
                var ρσ_d = Object.create(null);
                ρσ_d["key"] = key;
                ρσ_d["is_complete"] = false;
                ρσ_d["stored_files"] = Object.create(null);
                ρσ_d["book_hash"] = null;
                ρσ_d["metadata"] = metadata;
                ρσ_d["manifest"] = null;
                ρσ_d["cover_width"] = null;
                ρσ_d["cover_height"] = null;
                ρσ_d["cover_name"] = null;
                ρσ_d["recent_date"] = new Date;
                ρσ_d["last_read"] = Object.create(null);
                ρσ_d["last_read_position"] = Object.create(null);
                ρσ_d["saved_reading_rates"] = Object.create(null);
                ρσ_d["annotations_map"] = Object.create(null);
                return ρσ_d;
            }).call(this);
        };
        if (!new_book.__argnames__) Object.defineProperties(new_book, {
            __argnames__ : {value: ["key", "metadata"]},
            __module__ : {value: "read_book.db"}
        });

        DB_NAME = "calibre";
        DB_VERSION = 1;
        function indexed_db_api() {
            if ((typeof window !== "undefined" && window !== null)) {
                return window.indexedDB;
            }
            if ((typeof self !== "undefined" && self !== null)) {
                return self.indexedDB;
            }
        };
        if (!indexed_db_api.__module__) Object.defineProperties(indexed_db_api, {
            __module__ : {value: "read_book.db"}
        });

        function DB() {
            if (this.ρσ_object_id === undefined) Object.defineProperty(this, "ρσ_object_id", {"value":++ρσ_object_counter});
            DB.prototype.__bind_methods__.call(this);
            DB.prototype.__init__.apply(this, arguments);
        }
        Object.defineProperty(DB.prototype, "__bind_methods__", {value: function () {
            this.show_error = DB.prototype.show_error.bind(this);
            this.initialize_stage1 = DB.prototype.initialize_stage1.bind(this);
            this.initialize_stage2 = DB.prototype.initialize_stage2.bind(this);
            this.display_error = DB.prototype.display_error.bind(this);
            this.do_op = DB.prototype.do_op.bind(this);
            this.get_book = DB.prototype.get_book.bind(this);
            this.get_mathjax_info = DB.prototype.get_mathjax_info.bind(this);
            this.save_manifest = DB.prototype.save_manifest.bind(this);
            this.store_file = DB.prototype.store_file.bind(this);
            this.store_cover = DB.prototype.store_cover.bind(this);
            this.store_file_stage2 = DB.prototype.store_file_stage2.bind(this);
            this.clear_mathjax = DB.prototype.clear_mathjax.bind(this);
            this.store_mathjax_file = DB.prototype.store_mathjax_file.bind(this);
            this.finish_book = DB.prototype.finish_book.bind(this);
            this.finish_mathjax = DB.prototype.finish_mathjax.bind(this);
            this.update_last_read_time = DB.prototype.update_last_read_time.bind(this);
            this.update_metadata = DB.prototype.update_metadata.bind(this);
            this.save_reading_rates = DB.prototype.save_reading_rates.bind(this);
            this.update_annotations_data_from_key = DB.prototype.update_annotations_data_from_key.bind(this);
            this.get_file = DB.prototype.get_file.bind(this);
            this.get_book_file = DB.prototype.get_book_file.bind(this);
            this.get_mathjax_files = DB.prototype.get_mathjax_files.bind(this);
            this.get_recently_read_books = DB.prototype.get_recently_read_books.bind(this);
            this.has_book_matching = DB.prototype.has_book_matching.bind(this);
            this.delete_book = DB.prototype.delete_book.bind(this);
            this.delete_books_matching = DB.prototype.delete_books_matching.bind(this);
        }});
        DB.prototype.__init__ = function __init__(callback, show_read_book_error) {
            var self = this;
            self.initialized = false;
            self.is_ok = false;
            self.initialize_error_msg = null;
            self.callback = callback;
            self.show_read_book_error = show_read_book_error;
            self.initialize_stage1();
        };
        if (!DB.prototype.__init__.__argnames__) Object.defineProperties(DB.prototype.__init__, {
            __argnames__ : {value: ["callback", "show_read_book_error"]},
            __module__ : {value: "read_book.db"}
        });
        DB.__argnames__ = DB.prototype.__init__.__argnames__;
        DB.__handles_kwarg_interpolation__ = DB.prototype.__init__.__handles_kwarg_interpolation__;
        DB.prototype.show_error = function show_error(title, msg, det_msg) {
            var self = this;
            if (!(typeof window !== "undefined" && window !== null) || is_reading_book()) {
                self.show_read_book_error(title, msg, det_msg);
            } else {
                error_dialog(title, msg, det_msg);
            }
        };
        if (!DB.prototype.show_error.__argnames__) Object.defineProperties(DB.prototype.show_error, {
            __argnames__ : {value: ["title", "msg", "det_msg"]},
            __module__ : {value: "read_book.db"}
        });
        DB.prototype.initialize_stage1 = function initialize_stage1() {
            var self = this;
            var idb, request;
            idb = indexed_db_api();
            if (!idb) {
                self.initialize_error_msg = _("Your browser does not support IndexedDB. Cannot read books. Consider using a modern browser, such as Chrome or Firefox.");
                self.initialized = true;
                setTimeout(self.callback, 0);
                return;
            }
            request = idb.open(DB_NAME, DB_VERSION);
            request.onupgradeneeded = (function() {
                var ρσ_anonfunc = function (event) {
                    upgrade_schema(event.target.result, event.oldVersion, event.newVersion, event.target.transaction);
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["event"]},
                    __module__ : {value: "read_book.db"}
                });
                return ρσ_anonfunc;
            })();
            request.onblocked = (function() {
                var ρσ_anonfunc = function (event) {
                    self.initialize_error_msg = _("Please close all other browser tabs with calibre open");
                    self.initialized = true;
                    console.log(event);
                    self.callback();
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["event"]},
                    __module__ : {value: "read_book.db"}
                });
                return ρσ_anonfunc;
            })();
            request.onerror = (function() {
                var ρσ_anonfunc = function (event) {
                    self.initialize_error_msg = _("You must allow calibre to use IndexedDB storage in your browser to read books");
                    self.initialized = true;
                    console.log(event);
                    self.callback();
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["event"]},
                    __module__ : {value: "read_book.db"}
                });
                return ρσ_anonfunc;
            })();
            request.onsuccess = (function() {
                var ρσ_anonfunc = function (event) {
                    var blob, idb, store, req;
                    blob = new Blob(ρσ_list_decorate([ "test" ]), (function(){
                        var ρσ_d = Object.create(null);
                        ρσ_d["type"] = "text/plain";
                        return ρσ_d;
                    }).call(this));
                    idb = event.target.result;
                    store = idb.transaction(ρσ_list_decorate([ "files" ]), "readwrite").objectStore("files");
                    try {
                        req = store.put(blob, ":-test-blob-:");
                    } catch (ρσ_Exception) {
                        ρσ_last_exception = ρσ_Exception;
                        {
                            self.initialize_stage2(idb, false);
                            return;
                        } 
                    }
                    req.onsuccess = (function() {
                        var ρσ_anonfunc = function (event) {
                            self.initialize_stage2(idb, true);
                        };
                        if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                            __argnames__ : {value: ["event"]},
                            __module__ : {value: "read_book.db"}
                        });
                        return ρσ_anonfunc;
                    })();
                    req.onerror = (function() {
                        var ρσ_anonfunc = function (event) {
                            setTimeout(self.initialize_stage2.bind(null, idb, false), 0);
                        };
                        if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                            __argnames__ : {value: ["event"]},
                            __module__ : {value: "read_book.db"}
                        });
                        return ρσ_anonfunc;
                    })();
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["event"]},
                    __module__ : {value: "read_book.db"}
                });
                return ρσ_anonfunc;
            })();
        };
        if (!DB.prototype.initialize_stage1.__module__) Object.defineProperties(DB.prototype.initialize_stage1, {
            __module__ : {value: "read_book.db"}
        });
        DB.prototype.initialize_stage2 = function initialize_stage2(idb, supports_blobs) {
            var self = this;
            self.idb = idb;
            self.supports_blobs = supports_blobs;
            self.initialized = true;
            self.is_ok = true;
            if (!supports_blobs) {
                print("WARNING: browser does not support blob storage, calibre falling back to base64 encoding");
            }
            idb.onerror = (function() {
                var ρσ_anonfunc = function (event) {
                    self.display_error(null, event);
                    if (console.dir) {
                        console.dir(event);
                    } else {
                        console.log(event);
                    }
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["event"]},
                    __module__ : {value: "read_book.db"}
                });
                return ρσ_anonfunc;
            })();
            idb.onversionchange = (function() {
                var ρσ_anonfunc = function (event) {
                    idb.close();
                    self.show_error(_("Database upgraded!"), _("A newer version of calibre is available, please click the Reload button in your browser."));
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["event"]},
                    __module__ : {value: "read_book.db"}
                });
                return ρσ_anonfunc;
            })();
            self.callback();
        };
        if (!DB.prototype.initialize_stage2.__argnames__) Object.defineProperties(DB.prototype.initialize_stage2, {
            __argnames__ : {value: ["idb", "supports_blobs"]},
            __module__ : {value: "read_book.db"}
        });
        DB.prototype.display_error = function display_error(msg, event) {
            var self = this;
            if (event.already_displayed_by_calibre) {
                return;
            }
            event.already_displayed_by_calibre = true;
            msg = msg || _("There was an error while interacting with the database used to store books for offline reading. Click \"Show details\" for more information.");
            self.show_error(_("Cannot read book"), msg, get_error_details(event));
        };
        if (!DB.prototype.display_error.__argnames__) Object.defineProperties(DB.prototype.display_error, {
            __argnames__ : {value: ["msg", "event"]},
            __module__ : {value: "read_book.db"}
        });
        DB.prototype.do_op = function do_op() {
            var self = this;
            var stores = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[0];
            var data = ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[1];
            var error_msg = ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[2];
            var proceed = ( 3 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[3];
            var op = (arguments[4] === undefined || ( 4 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? do_op.__defaults__.op : arguments[4];
            var store = (arguments[5] === undefined || ( 5 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true)) ? do_op.__defaults__.store : arguments[5];
            var ρσ_kwargs_obj = arguments[arguments.length-1];
            if (ρσ_kwargs_obj === null || typeof ρσ_kwargs_obj !== "object" || ρσ_kwargs_obj [ρσ_kwargs_symbol] !== true) ρσ_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "op")){
                op = ρσ_kwargs_obj.op;
            }
            if (Object.prototype.hasOwnProperty.call(ρσ_kwargs_obj, "store")){
                store = ρσ_kwargs_obj.store;
            }
            var transaction, req;
            store = store || stores[0];
            if (op === "get") {
                transaction = self.idb.transaction(stores);
                req = transaction.objectStore(store).get(data);
                req.onsuccess = (function() {
                    var ρσ_anonfunc = function (event) {
                        if (proceed) {
                            proceed(req.result);
                        }
                    };
                    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                        __argnames__ : {value: ["event"]},
                        __module__ : {value: "read_book.db"}
                    });
                    return ρσ_anonfunc;
                })();
            } else if (op === "put") {
                transaction = self.idb.transaction(stores, "readwrite");
                req = transaction.objectStore(store).put(data);
                if (proceed) {
                    req.onsuccess = proceed;
                }
            }
            req.onerror = (function() {
                var ρσ_anonfunc = function (event) {
                    self.display_error(error_msg, event);
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["event"]},
                    __module__ : {value: "read_book.db"}
                });
                return ρσ_anonfunc;
            })();
        };
        if (!DB.prototype.do_op.__defaults__) Object.defineProperties(DB.prototype.do_op, {
            __defaults__ : {value: {op:"get", store:null}},
            __handles_kwarg_interpolation__ : {value: true},
            __argnames__ : {value: ["stores", "data", "error_msg", "proceed", "op", "store"]},
            __module__ : {value: "read_book.db"}
        });
        DB.prototype.get_book = function get_book(library_id, book_id, fmt, metadata, proceed) {
            var self = this;
            var key;
            fmt = fmt.toUpperCase();
            book_id = int(book_id);
            key = [library_id, book_id, fmt];
            self.do_op(ρσ_list_decorate([ "books" ]), key, _("Failed to read from the books database"), (function() {
                var ρσ_anonfunc = function (result) {
                    if (result && !result.annotations_map) {
                        result.annotations_map = Object.create(null);
                    }
                    proceed(result || new_book(key, metadata));
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["result"]},
                    __module__ : {value: "read_book.db"}
                });
                return ρσ_anonfunc;
            })());
        };
        if (!DB.prototype.get_book.__argnames__) Object.defineProperties(DB.prototype.get_book, {
            __argnames__ : {value: ["library_id", "book_id", "fmt", "metadata", "proceed"]},
            __module__ : {value: "read_book.db"}
        });
        DB.prototype.get_mathjax_info = function get_mathjax_info(proceed) {
            var self = this;
            self.do_op(ρσ_list_decorate([ "objects" ]), "mathjax-info", _("Failed to read from the objects database"), (function() {
                var ρσ_anonfunc = function (result) {
                    proceed(result || (function(){
                        var ρσ_d = Object.create(null);
                        ρσ_d["key"] = "mathjax-info";
                        return ρσ_d;
                    }).call(this));
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["result"]},
                    __module__ : {value: "read_book.db"}
                });
                return ρσ_anonfunc;
            })());
        };
        if (!DB.prototype.get_mathjax_info.__argnames__) Object.defineProperties(DB.prototype.get_mathjax_info, {
            __argnames__ : {value: ["proceed"]},
            __module__ : {value: "read_book.db"}
        });
        DB.prototype.save_manifest = function save_manifest(book, manifest, proceed) {
            var self = this;
            var newest_epoch, newest_pos, pos, username, unkey;
            book.manifest = manifest;
            book.metadata = manifest.metadata;
            book.book_hash = manifest.book_hash.hash;
            book.stored_files = Object.create(null);
            book.is_complete = false;
            newest_epoch = newest_pos = null;
            var ρσ_Iter0 = ρσ_Iterable(manifest.last_read_positions);
            for (var ρσ_Index0 = 0; ρσ_Index0 < ρσ_Iter0.length; ρσ_Index0++) {
                pos = ρσ_Iter0[ρσ_Index0];
                if (newest_epoch === null || pos.epoch > newest_epoch) {
                    newest_epoch = pos.epoch;
                    newest_pos = pos.cfi;
                }
            }
            username = get_interface_data().username;
            unkey = username_key(username);
            if (newest_pos && username) {
                (ρσ_expr_temp = book.last_read)[(typeof unkey === "number" && unkey < 0) ? ρσ_expr_temp.length + unkey : unkey] = new Date(newest_epoch * 1e3);
                (ρσ_expr_temp = book.last_read_position)[(typeof unkey === "number" && unkey < 0) ? ρσ_expr_temp.length + unkey : unkey] = newest_pos;
            }
            if (manifest.annotations_map) {
                (ρσ_expr_temp = book.annotations_map)[(typeof unkey === "number" && unkey < 0) ? ρσ_expr_temp.length + unkey : unkey] = manifest.annotations_map;
            }
            delete manifest.metadata;
            delete manifest.last_read_positions;
            delete manifest.annotations_map;
            ρσ_interpolate_kwargs.call(self, self.do_op, [ρσ_list_decorate([ "books" ]), book, _("Failed to write to the books database"), proceed].concat([ρσ_desugar_kwargs({op: "put"})]));
        };
        if (!DB.prototype.save_manifest.__argnames__) Object.defineProperties(DB.prototype.save_manifest, {
            __argnames__ : {value: ["book", "manifest", "proceed"]},
            __module__ : {value: "read_book.db"}
        });
        DB.prototype.store_file = function store_file(book, name, xhr, proceed, is_cover) {
            var self = this;
            var store_as_text, fname, needs_encoding, mt;
            store_as_text = xhr.responseType === "text" || !xhr.responseType;
            fname = file_store_name(book, name);
            needs_encoding = !store_as_text && !self.supports_blobs;
            mt = ρσ_exists.d((ρσ_expr_temp = book.manifest.files)[(typeof name === "number" && name < 0) ? ρσ_expr_temp.length + name : name]).mimetype;
            if (!mt && is_cover) {
                mt = "image/jpeg";
            }
            (ρσ_expr_temp = book.stored_files)[(typeof fname === "number" && fname < 0) ? ρσ_expr_temp.length + fname : fname] = (function(){
                var ρσ_d = Object.create(null);
                ρσ_d["encoded"] = needs_encoding;
                ρσ_d["mimetype"] = mt;
                ρσ_d["store_as_text"] = store_as_text;
                return ρσ_d;
            }).call(this);
            if (is_cover) {
                self.store_cover(book, needs_encoding, xhr.response, name, fname, proceed);
            } else {
                self.store_file_stage2(needs_encoding, xhr.response, name, fname, proceed);
            }
        };
        if (!DB.prototype.store_file.__argnames__) Object.defineProperties(DB.prototype.store_file, {
            __argnames__ : {value: ["book", "name", "xhr", "proceed", "is_cover"]},
            __module__ : {value: "read_book.db"}
        });
        DB.prototype.store_cover = function store_cover(book, needs_encoding, data, name, fname, proceed) {
            var self = this;
            var blob, url, img, proceeded;
            blob = data;
            if (needs_encoding) {
                blob = new Blob(ρσ_list_decorate([ data ]), (function(){
                    var ρσ_d = Object.create(null);
                    ρσ_d["type"] = "image/jpeg";
                    return ρσ_d;
                }).call(this));
            }
            url = window.URL.createObjectURL(blob);
            img = new Image;
            book.cover_name = name;
            proceeded = false;
            function done() {
                if (!proceeded) {
                    proceeded = true;
                    window.URL.revokeObjectURL(url);
                    self.store_file_stage2(needs_encoding, data, name, fname, proceed);
                }
            };
            if (!done.__module__) Object.defineProperties(done, {
                __module__ : {value: "read_book.db"}
            });

            img.onload = (function() {
                var ρσ_anonfunc = function () {
                    book.cover_width = this.width;
                    book.cover_height = this.height;
                    done();
                };
                if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
                    __module__ : {value: "read_book.db"}
                });
                return ρσ_anonfunc;
            })();
            img.onerror = (function() {
                var ρσ_anonfunc = function () {
                    print("WARNING: Failed to read dimensions of cover");
                    done();
                };
                if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
                    __module__ : {value: "read_book.db"}
                });
                return ρσ_anonfunc;
            })();
            img.src = url;
        };
        if (!DB.prototype.store_cover.__argnames__) Object.defineProperties(DB.prototype.store_cover, {
            __argnames__ : {value: ["book", "needs_encoding", "data", "name", "fname", "proceed"]},
            __module__ : {value: "read_book.db"}
        });
        DB.prototype.store_file_stage2 = function store_file_stage2(needs_encoding, data, name, fname, proceed) {
            var self = this;
            var req;
            if (needs_encoding) {
                data = base64encode(new Uint8Array(data));
            }
            req = self.idb.transaction(ρσ_list_decorate([ "files" ]), "readwrite").objectStore("files").put(data, fname);
            req.onsuccess = (function() {
                var ρσ_anonfunc = function (event) {
                    proceed();
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["event"]},
                    __module__ : {value: "read_book.db"}
                });
                return ρσ_anonfunc;
            })();
            req.onerror = (function() {
                var ρσ_anonfunc = function (event) {
                    proceed(_("Failed to store book data ({0}) with error: {1}").format(name, get_error_details(event)));
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["event"]},
                    __module__ : {value: "read_book.db"}
                });
                return ρσ_anonfunc;
            })();
        };
        if (!DB.prototype.store_file_stage2.__argnames__) Object.defineProperties(DB.prototype.store_file_stage2, {
            __argnames__ : {value: ["needs_encoding", "data", "name", "fname", "proceed"]},
            __module__ : {value: "read_book.db"}
        });
        DB.prototype.clear_mathjax = function clear_mathjax(proceed) {
            var self = this;
            self.idb.transaction(ρσ_list_decorate([ "mathjax" ]), "readwrite").objectStore("mathjax").clear().onsuccess = proceed;
        };
        if (!DB.prototype.clear_mathjax.__argnames__) Object.defineProperties(DB.prototype.clear_mathjax, {
            __argnames__ : {value: ["proceed"]},
            __module__ : {value: "read_book.db"}
        });
        DB.prototype.store_mathjax_file = function store_mathjax_file(name, xhr, proceed) {
            var self = this;
            var data, req;
            data = xhr.response;
            if (!self.supports_blobs) {
                data = base64encode(new Uint8Array(data));
            }
            req = self.idb.transaction(ρσ_list_decorate([ "mathjax" ]), "readwrite").objectStore("mathjax").put(data, name);
            req.onsuccess = (function() {
                var ρσ_anonfunc = function (event) {
                    proceed();
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["event"]},
                    __module__ : {value: "read_book.db"}
                });
                return ρσ_anonfunc;
            })();
            req.onerror = (function() {
                var ρσ_anonfunc = function (event) {
                    proceed(_("Failed to store mathjax file ({0}) with error: {1}").format(name, get_error_details(event)));
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["event"]},
                    __module__ : {value: "read_book.db"}
                });
                return ρσ_anonfunc;
            })();
        };
        if (!DB.prototype.store_mathjax_file.__argnames__) Object.defineProperties(DB.prototype.store_mathjax_file, {
            __argnames__ : {value: ["name", "xhr", "proceed"]},
            __module__ : {value: "read_book.db"}
        });
        DB.prototype.finish_book = function finish_book(book, proceed) {
            var self = this;
            book.is_complete = true;
            ρσ_interpolate_kwargs.call(self, self.do_op, [ρσ_list_decorate([ "books" ]), book, _("Failed to write to the books database"), proceed].concat([ρσ_desugar_kwargs({op: "put"})]));
        };
        if (!DB.prototype.finish_book.__argnames__) Object.defineProperties(DB.prototype.finish_book, {
            __argnames__ : {value: ["book", "proceed"]},
            __module__ : {value: "read_book.db"}
        });
        DB.prototype.finish_mathjax = function finish_mathjax(mathjax_info, proceed) {
            var self = this;
            ρσ_interpolate_kwargs.call(self, self.do_op, [ρσ_list_decorate([ "objects" ]), mathjax_info, _("Failed to write to the objects database"), proceed].concat([ρσ_desugar_kwargs({op: "put"})]));
        };
        if (!DB.prototype.finish_mathjax.__argnames__) Object.defineProperties(DB.prototype.finish_mathjax, {
            __argnames__ : {value: ["mathjax_info", "proceed"]},
            __module__ : {value: "read_book.db"}
        });
        DB.prototype.update_last_read_time = function update_last_read_time(book) {
            var self = this;
            var unkey, now;
            unkey = username_key(get_interface_data().username);
            now = new Date;
            (ρσ_expr_temp = book.last_read)[(typeof unkey === "number" && unkey < 0) ? ρσ_expr_temp.length + unkey : unkey] = book.recent_date = now;
            ρσ_interpolate_kwargs.call(self, self.do_op, [ρσ_list_decorate([ "books" ]), book, _("Failed to write to the books database")].concat([ρσ_desugar_kwargs({op: "put"})]));
        };
        if (!DB.prototype.update_last_read_time.__argnames__) Object.defineProperties(DB.prototype.update_last_read_time, {
            __argnames__ : {value: ["book"]},
            __module__ : {value: "read_book.db"}
        });
        DB.prototype.update_metadata = function update_metadata(book, new_metadata) {
            var self = this;
            var key;
            if (book.metadata) {
                var ρσ_Iter1 = ρσ_Iterable(Object.keys(new_metadata));
                for (var ρσ_Index1 = 0; ρσ_Index1 < ρσ_Iter1.length; ρσ_Index1++) {
                    key = ρσ_Iter1[ρσ_Index1];
                    (ρσ_expr_temp = book.metadata)[(typeof key === "number" && key < 0) ? ρσ_expr_temp.length + key : key] = new_metadata[(typeof key === "number" && key < 0) ? new_metadata.length + key : key];
                }
                ρσ_interpolate_kwargs.call(self, self.do_op, [ρσ_list_decorate([ "books" ]), book, _("Failed to write to the books database"), (function() {
                    var ρσ_anonfunc = function () {
                        null;
                    };
                    if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
                        __module__ : {value: "read_book.db"}
                    });
                    return ρσ_anonfunc;
                })()].concat([ρσ_desugar_kwargs({op: "put"})]));
            }
        };
        if (!DB.prototype.update_metadata.__argnames__) Object.defineProperties(DB.prototype.update_metadata, {
            __argnames__ : {value: ["book", "new_metadata"]},
            __module__ : {value: "read_book.db"}
        });
        DB.prototype.save_reading_rates = function save_reading_rates(book, rates) {
            var self = this;
            book.saved_reading_rates = rates;
            ρσ_interpolate_kwargs.call(self, self.do_op, [ρσ_list_decorate([ "books" ]), book, _("Failed to write to the books database"), (function() {
                var ρσ_anonfunc = function () {
                    null;
                };
                if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
                    __module__ : {value: "read_book.db"}
                });
                return ρσ_anonfunc;
            })()].concat([ρσ_desugar_kwargs({op: "put"})]));
        };
        if (!DB.prototype.save_reading_rates.__argnames__) Object.defineProperties(DB.prototype.save_reading_rates, {
            __argnames__ : {value: ["book", "rates"]},
            __module__ : {value: "read_book.db"}
        });
        DB.prototype.update_annotations_data_from_key = function update_annotations_data_from_key(library_id, book_id, fmt, new_data) {
            var self = this;
            var unkey;
            unkey = username_key(get_interface_data().username);
            self.get_book(library_id, book_id, fmt, null, (function() {
                var ρσ_anonfunc = function (book) {
                    var changed, existing, ρσ_unpack, updated, merged;
                    if (book.metadata) {
                        changed = false;
                        if (new_data.last_read_position) {
                            (ρσ_expr_temp = book.last_read)[(typeof unkey === "number" && unkey < 0) ? ρσ_expr_temp.length + unkey : unkey] = book.recent_date = new_data.last_read;
                            (ρσ_expr_temp = book.last_read_position)[(typeof unkey === "number" && unkey < 0) ? ρσ_expr_temp.length + unkey : unkey] = new_data.last_read_position;
                            changed = true;
                        }
                        if (!book.annotations_map) {
                            book.annotations_map = {};
                        }
                        if (new_data.annotations_map) {
                            existing = (ρσ_expr_temp = book.annotations_map)[(typeof unkey === "number" && unkey < 0) ? ρσ_expr_temp.length + unkey : unkey];
                            if (!existing) {
                                changed = true;
                                (ρσ_expr_temp = book.annotations_map)[(typeof unkey === "number" && unkey < 0) ? ρσ_expr_temp.length + unkey : unkey] = new_data.annotations_map;
                            } else {
                                ρσ_unpack = merge_annotation_maps(existing, new_data.annotations_map);
ρσ_unpack = ρσ_unpack_asarray(2, ρσ_unpack);
                                updated = ρσ_unpack[0];
                                merged = ρσ_unpack[1];
                                if (updated) {
                                    changed = true;
                                    (ρσ_expr_temp = book.annotations_map)[(typeof unkey === "number" && unkey < 0) ? ρσ_expr_temp.length + unkey : unkey] = merged;
                                }
                            }
                        }
                        if (changed) {
                            ρσ_interpolate_kwargs.call(self, self.do_op, [ρσ_list_decorate([ "books" ]), book, _("Failed to write to the books database"), (function() {
                                var ρσ_anonfunc = function () {
                                    null;
                                };
                                if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
                                    __module__ : {value: "read_book.db"}
                                });
                                return ρσ_anonfunc;
                            })()].concat([ρσ_desugar_kwargs({op: "put"})]));
                        }
                    }
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["book"]},
                    __module__ : {value: "read_book.db"}
                });
                return ρσ_anonfunc;
            })());
        };
        if (!DB.prototype.update_annotations_data_from_key.__argnames__) Object.defineProperties(DB.prototype.update_annotations_data_from_key, {
            __argnames__ : {value: ["library_id", "book_id", "fmt", "new_data"]},
            __module__ : {value: "read_book.db"}
        });
        DB.prototype.get_file = function get_file(book, name, proceed) {
            var self = this;
            var key, err;
            key = file_store_name(book, name);
            err = _("Failed to read the file {0} for the book {1} from the browser offline cache.").format(name, book.metadata.title);
            self.do_op(ρσ_list_decorate([ "files" ]), key, err, (function() {
                var ρσ_anonfunc = function (result) {
                    var bad, fdata, mt;
                    if (!result) {
                        bad = err + _(" This usually means the cache is close to full. Clear the browser cache from the browser settings.");
                        self.show_error(_("Cannot read file from book"), bad);
                        return;
                    }
                    fdata = (ρσ_expr_temp = book.stored_files)[(typeof key === "number" && key < 0) ? ρσ_expr_temp.length + key : key];
                    mt = fdata.mimetype || "application/octet-stream";
                    if (fdata.encoded) {
                        result = new Blob(ρσ_list_decorate([ base64decode(result) ]), (function(){
                            var ρσ_d = Object.create(null);
                            ρσ_d["type"] = mt;
                            return ρσ_d;
                        }).call(this));
                    }
                    proceed(result, name, mt, book);
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["result"]},
                    __module__ : {value: "read_book.db"}
                });
                return ρσ_anonfunc;
            })());
        };
        if (!DB.prototype.get_file.__argnames__) Object.defineProperties(DB.prototype.get_file, {
            __argnames__ : {value: ["book", "name", "proceed"]},
            __module__ : {value: "read_book.db"}
        });
        DB.prototype.get_book_file = function get_book_file(book_hash, stored_files, name, proceed) {
            var self = this;
            var stores, key, transaction, req;
            stores = ρσ_list_decorate([ "files" ]);
            key = file_store_name((function(){
                var ρσ_d = Object.create(null);
                ρσ_d["book_hash"] = book_hash;
                return ρσ_d;
            }).call(this), name);
            transaction = self.idb.transaction(stores);
            req = transaction.objectStore(stores[0]).get(key);
            req.onsuccess = (function() {
                var ρσ_anonfunc = function (event) {
                    var fdata, mt, result;
                    if (!req.result) {
                        proceed((function(){
                            var ρσ_d = Object.create(null);
                            ρσ_d["ok"] = false;
                            ρσ_d["name"] = name;
                            ρσ_d["details"] = "ENOENT";
                            return ρσ_d;
                        }).call(this));
                        return;
                    }
                    fdata = stored_files[(typeof key === "number" && key < 0) ? stored_files.length + key : key];
                    mt = fdata.mimetype || "application/octet-stream";
                    if (fdata.encoded) {
                        result = new Blob(ρσ_list_decorate([ base64decode(result) ]), (function(){
                            var ρσ_d = Object.create(null);
                            ρσ_d["type"] = mt;
                            return ρσ_d;
                        }).call(this));
                    }
                    proceed((function(){
                        var ρσ_d = Object.create(null);
                        ρσ_d["ok"] = true;
                        ρσ_d["result"] = req.result;
                        ρσ_d["name"] = name;
                        ρσ_d["mt"] = mt;
                        return ρσ_d;
                    }).call(this));
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["event"]},
                    __module__ : {value: "read_book.db"}
                });
                return ρσ_anonfunc;
            })();
            req.onerror = (function() {
                var ρσ_anonfunc = function (event) {
                    var details;
                    details = get_error_details(event);
                    proceed((function(){
                        var ρσ_d = Object.create(null);
                        ρσ_d["ok"] = false;
                        ρσ_d["name"] = name;
                        ρσ_d["details"] = details;
                        return ρσ_d;
                    }).call(this));
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["event"]},
                    __module__ : {value: "read_book.db"}
                });
                return ρσ_anonfunc;
            })();
        };
        if (!DB.prototype.get_book_file.__argnames__) Object.defineProperties(DB.prototype.get_book_file, {
            __argnames__ : {value: ["book_hash", "stored_files", "name", "proceed"]},
            __module__ : {value: "read_book.db"}
        });
        DB.prototype.get_mathjax_files = function get_mathjax_files(proceed) {
            var self = this;
            var c, data;
            c = self.idb.transaction("mathjax").objectStore("mathjax").openCursor();
            c.onerror = (function() {
                var ρσ_anonfunc = function (event) {
                    var err;
                    err = _("Failed to read the MathJax files from the browser offline cache.");
                    self.display_error(err, event);
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["event"]},
                    __module__ : {value: "read_book.db"}
                });
                return ρσ_anonfunc;
            })();
            data = Object.create(null);
            c.onsuccess = (function() {
                var ρσ_anonfunc = function (event) {
                    var cursor, ρσ_unpack, name, result, mt;
                    cursor = event.target.result;
                    if (cursor) {
                        ρσ_unpack = [cursor.key, cursor.value];
                        name = ρσ_unpack[0];
                        result = ρσ_unpack[1];
                        if (!(ρσ_instanceof(result, Blob))) {
                            mt = (name.endswith(".woff")) ? "application/x-font-woff" : "text/javascript";
                            result = new Blob(ρσ_list_decorate([ base64decode(result) ]), (function(){
                                var ρσ_d = Object.create(null);
                                ρσ_d["type"] = mt;
                                return ρσ_d;
                            }).call(this));
                        }
                        data[(typeof name === "number" && name < 0) ? data.length + name : name] = result;
                        cursor.continue();
                    } else {
                        proceed(data);
                    }
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["event"]},
                    __module__ : {value: "read_book.db"}
                });
                return ρσ_anonfunc;
            })();
        };
        if (!DB.prototype.get_mathjax_files.__argnames__) Object.defineProperties(DB.prototype.get_mathjax_files, {
            __argnames__ : {value: ["proceed"]},
            __module__ : {value: "read_book.db"}
        });
        DB.prototype.get_recently_read_books = function get_recently_read_books(proceed, limit) {
            var self = this;
            var c, books;
            limit = limit || 3;
            c = self.idb.transaction(ρσ_list_decorate([ "books" ]), "readonly").objectStore("books").index("recent_index").openCursor(null, "prev");
            books = [];
            c.onerror = (function() {
                var ρσ_anonfunc = function (event) {
                    var err;
                    err = _("Failed to read recent books from local storage");
                    self.display_error(err, event);
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["event"]},
                    __module__ : {value: "read_book.db"}
                });
                return ρσ_anonfunc;
            })();
            c.onsuccess = (function() {
                var ρσ_anonfunc = function (ev) {
                    var cursor;
                    cursor = ev.target.result;
                    if (cursor) {
                        books.push(cursor.value);
                    }
                    if (books.length >= limit || !cursor) {
                        proceed(books);
                        return;
                    }
                    if (cursor) {
                        cursor.continue();
                    }
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["ev"]},
                    __module__ : {value: "read_book.db"}
                });
                return ρσ_anonfunc;
            })();
        };
        if (!DB.prototype.get_recently_read_books.__argnames__) Object.defineProperties(DB.prototype.get_recently_read_books, {
            __argnames__ : {value: ["proceed", "limit"]},
            __module__ : {value: "read_book.db"}
        });
        DB.prototype.has_book_matching = function has_book_matching(library_id, book_id, proceed) {
            var self = this;
            var c;
            c = self.idb.transaction(ρσ_list_decorate([ "books" ]), "readonly").objectStore("books").index("recent_index").openCursor(null, "prev");
            c.onerror = (function() {
                var ρσ_anonfunc = function (event) {
                    proceed(false);
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["event"]},
                    __module__ : {value: "read_book.db"}
                });
                return ρσ_anonfunc;
            })();
            book_id = int(book_id);
            c.onsuccess = (function() {
                var ρσ_anonfunc = function (ev) {
                    var cursor, book;
                    cursor = ev.target.result;
                    if (cursor) {
                        book = cursor.value;
                        if (book.key[0] === library_id && book.key[1] === book_id) {
                            proceed(true);
                            return;
                        }
                        cursor.continue();
                    } else {
                        proceed(false);
                    }
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["ev"]},
                    __module__ : {value: "read_book.db"}
                });
                return ρσ_anonfunc;
            })();
        };
        if (!DB.prototype.has_book_matching.__argnames__) Object.defineProperties(DB.prototype.has_book_matching, {
            __argnames__ : {value: ["library_id", "book_id", "proceed"]},
            __module__ : {value: "read_book.db"}
        });
        DB.prototype.delete_book = function delete_book(book, proceed) {
            var self = this;
            var c, files, books, filenames;
            c = self.idb.transaction(ρσ_list_decorate([ "books", "files" ]), "readwrite");
            files = c.objectStore("files");
            books = c.objectStore("books");
            filenames = Object.keys(book.stored_files);
            c.oncomplete = (function() {
                var ρσ_anonfunc = function (event) {
                    proceed(book);
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["event"]},
                    __module__ : {value: "read_book.db"}
                });
                return ρσ_anonfunc;
            })();
            c.onerror = (function() {
                var ρσ_anonfunc = function (event) {
                    proceed(book, c.error.toString());
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["event"]},
                    __module__ : {value: "read_book.db"}
                });
                return ρσ_anonfunc;
            })();
            function next_step() {
                var r;
                if (filenames.length) {
                    r = files.delete(filenames.pop());
                    r.onsuccess = next_step;
                } else {
                    books.delete(book.key);
                }
            };
            if (!next_step.__module__) Object.defineProperties(next_step, {
                __module__ : {value: "read_book.db"}
            });

            next_step();
        };
        if (!DB.prototype.delete_book.__argnames__) Object.defineProperties(DB.prototype.delete_book, {
            __argnames__ : {value: ["book", "proceed"]},
            __module__ : {value: "read_book.db"}
        });
        DB.prototype.delete_books_matching = function delete_books_matching(library_id, book_id, proceed) {
            var self = this;
            var c, matches;
            c = self.idb.transaction(ρσ_list_decorate([ "books" ]), "readonly").objectStore("books").index("recent_index").openCursor(null, "prev");
            c.onerror = (function() {
                var ρσ_anonfunc = function (event) {
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["event"]},
                    __module__ : {value: "read_book.db"}
                });
                return ρσ_anonfunc;
            })();
            book_id = int(book_id);
            matches = [];
            function delete_all() {
                var book;
                if (matches.length) {
                    book = matches.pop();
                    self.delete_book(book, delete_all);
                } else {
                    if (proceed) {
                        proceed();
                    }
                }
            };
            if (!delete_all.__module__) Object.defineProperties(delete_all, {
                __module__ : {value: "read_book.db"}
            });

            c.onsuccess = (function() {
                var ρσ_anonfunc = function (ev) {
                    var cursor, book;
                    cursor = ev.target.result;
                    if (cursor) {
                        book = cursor.value;
                        if (book.key[0] === library_id && book.key[1] === book_id) {
                            matches.push(book);
                        }
                        cursor.continue();
                    } else {
                        delete_all();
                    }
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["ev"]},
                    __module__ : {value: "read_book.db"}
                });
                return ρσ_anonfunc;
            })();
        };
        if (!DB.prototype.delete_books_matching.__argnames__) Object.defineProperties(DB.prototype.delete_books_matching, {
            __argnames__ : {value: ["library_id", "book_id", "proceed"]},
            __module__ : {value: "read_book.db"}
        });
        DB.prototype.__repr__ = function __repr__ () {
                        return "<" + __name__ + "." + this.constructor.name + " #" + this.ρσ_object_id + ">";
        };
        DB.prototype.__str__ = function __str__ () {
            return this.__repr__();
        };
        Object.defineProperty(DB.prototype, "__bases__", {value: []});

        function get_db(callback, show_read_book_error) {
            if (!get_db.ans) {
                get_db.ans = new DB(callback, show_read_book_error);
            }
            return get_db.ans;
        };
        if (!get_db.__argnames__) Object.defineProperties(get_db, {
            __argnames__ : {value: ["callback", "show_read_book_error"]},
            __module__ : {value: "read_book.db"}
        });

        ρσ_modules["read_book.db"].DB_NAME = DB_NAME;
        ρσ_modules["read_book.db"].DB_VERSION = DB_VERSION;
        ρσ_modules["read_book.db"].upgrade_schema = upgrade_schema;
        ρσ_modules["read_book.db"].file_store_name = file_store_name;
        ρσ_modules["read_book.db"].get_error_details = get_error_details;
        ρσ_modules["read_book.db"].new_book = new_book;
        ρσ_modules["read_book.db"].indexed_db_api = indexed_db_api;
        ρσ_modules["read_book.db"].DB = DB;
        ρσ_modules["read_book.db"].get_db = get_db;
    })();

    (function(){
        var __name__ = "iframe_comm";
        var LOADING_DOC, instance_numbers;
        var GCM = ρσ_modules.aes.GCM;

        var E = ρσ_modules.elementmaker.E;

        var traceback = ρσ_modules.traceback;

        var get_translations = ρσ_modules["book_list.globals"].get_translations;
        var main_js = ρσ_modules["book_list.globals"].main_js;

        var get_font_family = ρσ_modules["book_list.theme"].get_font_family;

        var ensure_id = ρσ_modules.dom.ensure_id;

        var install = ρσ_modules.gettext.install;

        LOADING_DOC = "\n<!DOCTYPE html>\n<html>\n<head>\n<meta name=\"viewport\" content=\"width=device-width, initial-scale=1, user-scalable=no\">\n<meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\">\n<script type=\"text/javascript\" id=\"bootstrap\">\nwindow.iframe_entry_point = '__ENTRY_POINT__';  // different in different iframes\nwindow.default_font_family = '__FONT__';  // from the theme\n__SCRIPT__\nend_script\n</head>\n<body>\n<div style=\"font-size:larger; font-weight: bold; margin-top:48vh; text-align:center\">\n__BS__\n</div>\n</body>\n</html>\n".replace("end_script", "<" + "/script>");
        function Messenger() {
            if (this.ρσ_object_id === undefined) Object.defineProperty(this, "ρσ_object_id", {"value":++ρσ_object_counter});
            Messenger.prototype.__bind_methods__.call(this);
            Messenger.prototype.__init__.apply(this, arguments);
        }
        Object.defineProperty(Messenger.prototype, "__bind_methods__", {value: function () {
            this.reset = Messenger.prototype.reset.bind(this);
            this.encrypt = Messenger.prototype.encrypt.bind(this);
            this.decrypt = Messenger.prototype.decrypt.bind(this);
        }});
        Messenger.prototype.__init__ = function __init__() {
            var self = this;
            self.secret = new Uint8Array(64);
        };
        if (!Messenger.prototype.__init__.__module__) Object.defineProperties(Messenger.prototype.__init__, {
            __module__ : {value: "iframe_comm"}
        });
        Messenger.__argnames__ = Messenger.prototype.__init__.__argnames__;
        Messenger.__handles_kwarg_interpolation__ = Messenger.prototype.__init__.__handles_kwarg_interpolation__;
        Messenger.prototype.reset = function reset() {
            var self = this;
            window.crypto.getRandomValues(self.secret);
            self.gcm_to_iframe = new GCM(self.secret.subarray(0, 32));
            self.gcm_from_iframe = new GCM(self.secret.subarray(32));
        };
        if (!Messenger.prototype.reset.__module__) Object.defineProperties(Messenger.prototype.reset, {
            __module__ : {value: "iframe_comm"}
        });
        Messenger.prototype.encrypt = function encrypt(data) {
            var self = this;
            return self.gcm_to_iframe.encrypt(JSON.stringify(data));
        };
        if (!Messenger.prototype.encrypt.__argnames__) Object.defineProperties(Messenger.prototype.encrypt, {
            __argnames__ : {value: ["data"]},
            __module__ : {value: "iframe_comm"}
        });
        Messenger.prototype.decrypt = function decrypt(data) {
            var self = this;
            return JSON.parse(self.gcm_from_iframe.decrypt(data));
        };
        if (!Messenger.prototype.decrypt.__argnames__) Object.defineProperties(Messenger.prototype.decrypt, {
            __argnames__ : {value: ["data"]},
            __module__ : {value: "iframe_comm"}
        });
        Messenger.prototype.__repr__ = function __repr__ () {
                        return "<" + __name__ + "." + this.constructor.name + " #" + this.ρσ_object_id + ">";
        };
        Messenger.prototype.__str__ = function __str__ () {
            return this.__repr__();
        };
        Object.defineProperty(Messenger.prototype, "__bases__", {value: []});

        function IframeWrapper() {
            if (this.ρσ_object_id === undefined) Object.defineProperty(this, "ρσ_object_id", {"value":++ρσ_object_counter});
            IframeWrapper.prototype.__bind_methods__.call(this);
            IframeWrapper.prototype.__init__.apply(this, arguments);
        }
        Object.defineProperty(IframeWrapper.prototype, "__bind_methods__", {value: function () {
            this.destroy = IframeWrapper.prototype.destroy.bind(this);
            this.create_srcdoc = IframeWrapper.prototype.create_srcdoc.bind(this);
            this.init = IframeWrapper.prototype.init.bind(this);
            this.reset = IframeWrapper.prototype.reset.bind(this);
            this._send_message = IframeWrapper.prototype._send_message.bind(this);
            this.send_message = IframeWrapper.prototype.send_message.bind(this);
            this.send_unencrypted_message = IframeWrapper.prototype.send_unencrypted_message.bind(this);
            this.handle_message = IframeWrapper.prototype.handle_message.bind(this);
            this.on_iframe_ready = IframeWrapper.prototype.on_iframe_ready.bind(this);
        }});
        Object.defineProperties(IframeWrapper.prototype,  {
            "iframe": {
                "enumerable": true, 
                "get": function iframe() {
                    var self = this;
                    return document.getElementById(self.iframe_id);
                }, 
                "set": function () { throw new AttributeError("can't set attribute") }
            }, 
        });
        IframeWrapper.prototype.__init__ = function __init__(handlers, iframe, entry_point, bootstrap_text) {
            var self = this;
            var k;
            self.messenger = new Messenger;
            self.iframe_id = ensure_id(iframe, "content-iframe");
            self.reload_count = 0;
            if (ρσ_in(":", entry_point)) {
                self.needs_init = iframe.src !== entry_point;
                self.srcdoc_created = true;
                self.constructor_url = entry_point;
                self.entry_point = null;
            } else {
                self.needs_init = true;
                self.srcdoc_created = false;
                self.constructor_url = null;
                self.entry_point = entry_point;
            }
            self.ready = false;
            self.encrypted_communications = false;
            self.bootstrap_text = bootstrap_text || "";
            self.handlers = (function() {
                var ρσ_Iter = ρσ_Iterable(handlers), ρσ_Result = Object.create(null), k;
                for (var ρσ_Index = 0; ρσ_Index < ρσ_Iter.length; ρσ_Index++) {
                    k = ρσ_Iter[ρσ_Index];
                    ρσ_Result[k] = (handlers[(typeof k === "number" && k < 0) ? handlers.length + k : k]);
                }
                return ρσ_Result;
            })();
            self.on_ready_handler = self.handlers.ready;
            self.handlers.ready = self.on_iframe_ready;
            window.addEventListener("message", self.handle_message, false);
        };
        if (!IframeWrapper.prototype.__init__.__argnames__) Object.defineProperties(IframeWrapper.prototype.__init__, {
            __argnames__ : {value: ["handlers", "iframe", "entry_point", "bootstrap_text"]},
            __module__ : {value: "iframe_comm"}
        });
        IframeWrapper.__argnames__ = IframeWrapper.prototype.__init__.__argnames__;
        IframeWrapper.__handles_kwarg_interpolation__ = IframeWrapper.prototype.__init__.__handles_kwarg_interpolation__;
        IframeWrapper.prototype.destroy = function destroy() {
            var self = this;
            window.removeEventListener("message", self.handle_message, false);
        };
        if (!IframeWrapper.prototype.destroy.__module__) Object.defineProperties(IframeWrapper.prototype.destroy, {
            __module__ : {value: "iframe_comm"}
        });
        IframeWrapper.prototype.create_srcdoc = function create_srcdoc() {
            var self = this;
            var r, data;
            r = /__([A-Z][A-Z_0-9]*[A-Z0-9])__/g;
            if (self.entry_point) {
                data = (function(){
                    var ρσ_d = Object.create(null);
                    ρσ_d["BS"] = self.bootstrap_text;
                    ρσ_d["SCRIPT"] = main_js();
                    ρσ_d["FONT"] = get_font_family();
                    ρσ_d["ENTRY_POINT"] = self.entry_point;
                    return ρσ_d;
                }).call(this);
                self.iframe.srcdoc = LOADING_DOC.replace(r, (function() {
                    var ρσ_anonfunc = function (match, field) {
                        return data[(typeof field === "number" && field < 0) ? data.length + field : field];
                    };
                    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                        __argnames__ : {value: ["match", "field"]},
                        __module__ : {value: "iframe_comm"}
                    });
                    return ρσ_anonfunc;
                })());
            } else {
                self.iframe.src = self.constructor_url;
            }
            self.srcdoc_created = true;
        };
        if (!IframeWrapper.prototype.create_srcdoc.__module__) Object.defineProperties(IframeWrapper.prototype.create_srcdoc, {
            __module__ : {value: "iframe_comm"}
        });
        IframeWrapper.prototype.init = function init() {
            var self = this;
            var iframe, sdoc, ch;
            if (!self.needs_init) {
                return;
            }
            self.needs_init = false;
            iframe = self.iframe;
            if (self.srcdoc_created) {
                if (self.entry_point) {
                    sdoc = iframe.srcdoc;
                    iframe.srcdoc = "<p>&nbsp;</p>";
                    iframe.srcdoc = sdoc;
                } else {
                    self.reload_count += 1;
                    ch = (ρσ_in("?", self.constructor_url)) ? "&" : "?";
                    iframe.src = self.constructor_url + ("" + ρσ_str.format("{}", ch) + "rc=" + ρσ_str.format("{}", self.reload_count) + "");
                }
            } else {
                self.create_srcdoc();
            }
        };
        if (!IframeWrapper.prototype.init.__module__) Object.defineProperties(IframeWrapper.prototype.init, {
            __module__ : {value: "iframe_comm"}
        });
        IframeWrapper.prototype.reset = function reset() {
            var self = this;
            self.ready = false;
            self.needs_init = true;
            self.encrypted_communications = false;
        };
        if (!IframeWrapper.prototype.reset.__module__) Object.defineProperties(IframeWrapper.prototype.reset, {
            __module__ : {value: "iframe_comm"}
        });
        IframeWrapper.prototype._send_message = function _send_message(action, encrypted, data) {
            var self = this;
            var msg;
            if (!self.ready) {
                return;
            }
            data.action = action;
            msg = (function(){
                var ρσ_d = Object.create(null);
                ρσ_d["data"] = data;
                ρσ_d["encrypted"] = encrypted;
                return ρσ_d;
            }).call(this);
            if (encrypted) {
                msg.data = self.messenger.encrypt(data);
            }
            self.iframe.contentWindow.postMessage(msg, "*");
        };
        if (!IframeWrapper.prototype._send_message.__argnames__) Object.defineProperties(IframeWrapper.prototype._send_message, {
            __argnames__ : {value: ["action", "encrypted", "data"]},
            __module__ : {value: "iframe_comm"}
        });
        IframeWrapper.prototype.send_message = function send_message() {
            var self = this;
            var action = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[0];
            var data = arguments[arguments.length-1];
            if (data === null || typeof data !== "object" || data [ρσ_kwargs_symbol] !== true) data = {};
            self._send_message(action, self.encrypted_communications, data);
        };
        if (!IframeWrapper.prototype.send_message.__handles_kwarg_interpolation__) Object.defineProperties(IframeWrapper.prototype.send_message, {
            __handles_kwarg_interpolation__ : {value: true},
            __argnames__ : {value: ["action"]},
            __module__ : {value: "iframe_comm"}
        });
        IframeWrapper.prototype.send_unencrypted_message = function send_unencrypted_message() {
            var self = this;
            var action = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) ? undefined : arguments[0];
            var data = arguments[arguments.length-1];
            if (data === null || typeof data !== "object" || data [ρσ_kwargs_symbol] !== true) data = {};
            self._send_message(action, false, data);
        };
        if (!IframeWrapper.prototype.send_unencrypted_message.__handles_kwarg_interpolation__) Object.defineProperties(IframeWrapper.prototype.send_unencrypted_message, {
            __handles_kwarg_interpolation__ : {value: true},
            __argnames__ : {value: ["action"]},
            __module__ : {value: "iframe_comm"}
        });
        IframeWrapper.prototype.handle_message = function handle_message(event) {
            var self = this;
            var data, func;
            if (event.source !== ρσ_exists.d(self.iframe).contentWindow) {
                return;
            }
            data = event.data;
            if (self.encrypted_communications) {
                if (data.tag === undefined) {
                    print("Ignoring unencrypted message from iframe:", data);
                    return;
                }
                try {
                    data = self.messenger.decrypt(data);
                } catch (ρσ_Exception) {
                    ρσ_last_exception = ρσ_Exception;
                    if (ρσ_Exception instanceof Error) {
                        var e = ρσ_Exception;
                        print("Could not decrypt message from iframe:");
                        console.log(e);
                        traceback.print_exc();
                        return;
                    } else {
                        throw ρσ_Exception;
                    }
                }
            }
            if (!data.action) {
                return;
            }
            func = (ρσ_expr_temp = self.handlers)[ρσ_bound_index(data.action, ρσ_expr_temp)];
            if (func) {
                func(data);
            } else {
                print("Unknown action in message from iframe to parent:", data.action);
            }
        };
        if (!IframeWrapper.prototype.handle_message.__argnames__) Object.defineProperties(IframeWrapper.prototype.handle_message, {
            __argnames__ : {value: ["event"]},
            __module__ : {value: "iframe_comm"}
        });
        IframeWrapper.prototype.on_iframe_ready = function on_iframe_ready(data) {
            var self = this;
            var msg, callback;
            self.messenger.reset();
            msg = (function(){
                var ρσ_d = Object.create(null);
                ρσ_d["secret"] = self.messenger.secret;
                ρσ_d["translations"] = get_translations();
                return ρσ_d;
            }).call(this);
            self.ready = true;
            callback = null;
            if (self.on_ready_handler) {
                callback = self.on_ready_handler(msg);
            }
            self._send_message("initialize", false, msg);
            self.encrypted_communications = true;
            if (callback) {
                callback();
            }
        };
        if (!IframeWrapper.prototype.on_iframe_ready.__argnames__) Object.defineProperties(IframeWrapper.prototype.on_iframe_ready, {
            __argnames__ : {value: ["data"]},
            __module__ : {value: "iframe_comm"}
        });
        IframeWrapper.prototype.__repr__ = function __repr__ () {
                        return "<" + __name__ + "." + this.constructor.name + " #" + this.ρσ_object_id + ">";
        };
        IframeWrapper.prototype.__str__ = function __str__ () {
            return this.__repr__();
        };
        Object.defineProperty(IframeWrapper.prototype, "__bases__", {value: []});
        

        function create_wrapped_iframe(handlers, bootstrap_text, entry_point, kw) {
            var iframe, ans;
            if (ρσ_in(":", entry_point)) {
                kw.src = entry_point;
                kw.sandbox = (kw.sandbox || "") + " allow-same-origin";
            }
            iframe = ρσ_interpolate_kwargs.call(E, E.iframe, [ρσ_desugar_kwargs(kw)]);
            ans = new IframeWrapper(handlers, iframe, entry_point, bootstrap_text);
            return [iframe, ans];
        };
        if (!create_wrapped_iframe.__argnames__) Object.defineProperties(create_wrapped_iframe, {
            __argnames__ : {value: ["handlers", "bootstrap_text", "entry_point", "kw"]},
            __module__ : {value: "iframe_comm"}
        });

        instance_numbers = Object.create(null);
        function IframeClient() {
            if (this.ρσ_object_id === undefined) Object.defineProperty(this, "ρσ_object_id", {"value":++ρσ_object_counter});
            IframeClient.prototype.__bind_methods__.call(this);
            IframeClient.prototype.__init__.apply(this, arguments);
        }
        Object.defineProperty(IframeClient.prototype, "__bind_methods__", {value: function () {
            this.send_ready = IframeClient.prototype.send_ready.bind(this);
            this.initialize = IframeClient.prototype.initialize.bind(this);
            this.print_to_parent = IframeClient.prototype.print_to_parent.bind(this);
            this.handle_message = IframeClient.prototype.handle_message.bind(this);
            this.send_message = IframeClient.prototype.send_message.bind(this);
        }});
        IframeClient.prototype.__init__ = function __init__(handlers, name) {
            var self = this;
            var k;
            self.encrypted_communications = false;
            self.name = name;
            if (!instance_numbers[ρσ_bound_index(self.name, instance_numbers)]) {
                instance_numbers[ρσ_bound_index(self.name, instance_numbers)] = 0;
            }
            instance_numbers[ρσ_bound_index(self.name, instance_numbers)] += 1;
            self.instance_num = instance_numbers[ρσ_bound_index(self.name, instance_numbers)];
            self.handlers = (function() {
                var ρσ_Iter = ρσ_Iterable(handlers), ρσ_Result = Object.create(null), k;
                for (var ρσ_Index = 0; ρσ_Index < ρσ_Iter.length; ρσ_Index++) {
                    k = ρσ_Iter[ρσ_Index];
                    ρσ_Result[k] = (handlers[(typeof k === "number" && k < 0) ? handlers.length + k : k]);
                }
                return ρσ_Result;
            })();
            self.initialize_handler = handlers.initialize;
            self.handlers.initialize = self.initialize;
            self.ready_sent = false;
            window.addEventListener("message", self.handle_message, false);
            window.addEventListener("load", self.send_ready, (function(){
                var ρσ_d = Object.create(null);
                ρσ_d["once"] = true;
                return ρσ_d;
            }).call(this));
        };
        if (!IframeClient.prototype.__init__.__argnames__) Object.defineProperties(IframeClient.prototype.__init__, {
            __argnames__ : {value: ["handlers", "name"]},
            __module__ : {value: "iframe_comm"}
        });
        IframeClient.__argnames__ = IframeClient.prototype.__init__.__argnames__;
        IframeClient.__handles_kwarg_interpolation__ = IframeClient.prototype.__init__.__handles_kwarg_interpolation__;
        IframeClient.prototype.send_ready = function send_ready() {
            var self = this;
            if (!self.ready_sent) {
                self.send_message("ready", Object.create(null));
                self.ready_sent = true;
            }
        };
        if (!IframeClient.prototype.send_ready.__module__) Object.defineProperties(IframeClient.prototype.send_ready, {
            __module__ : {value: "iframe_comm"}
        });
        IframeClient.prototype.initialize = function initialize(data) {
            var self = this;
            var ρσ_unpack;
            ρσ_unpack = [new GCM(data.secret.subarray(0, 32)), new GCM(data.secret.subarray(32))];
            self.gcm_from_parent = ρσ_unpack[0];
            self.gcm_to_parent = ρσ_unpack[1];
            self.encrypted_communications = true;
            if (data.translations) {
                install(data.translations);
            }
            print = self.print_to_parent;
            if (self.initialize_handler) {
                self.initialize_handler(data);
            }
        };
        if (!IframeClient.prototype.initialize.__argnames__) Object.defineProperties(IframeClient.prototype.initialize, {
            __argnames__ : {value: ["data"]},
            __module__ : {value: "iframe_comm"}
        });
        IframeClient.prototype.print_to_parent = function print_to_parent() {
            var self = this;
            var args = Array.prototype.slice.call(arguments, 0);
            if (arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [ρσ_kwargs_symbol] === true) args.pop();
            ρσ_interpolate_kwargs.call(self, self.send_message, ["print"].concat([ρσ_desugar_kwargs({string: " ".join(map(str, args))})]));
        };
        if (!IframeClient.prototype.print_to_parent.__handles_kwarg_interpolation__) Object.defineProperties(IframeClient.prototype.print_to_parent, {
            __handles_kwarg_interpolation__ : {value: true},
            __module__ : {value: "iframe_comm"}
        });
        IframeClient.prototype.handle_message = function handle_message(event) {
            var self = this;
            var msg, data, func, details;
            if (event.source !== window.parent) {
                return;
            }
            msg = event.data;
            data = msg.data;
            if (msg.encrypted) {
                if (!self.gcm_from_parent) {
                    print("the iframe " + ρσ_str.format("{}", self.name) + "-" + ρσ_str.format("{}", self.instance_num) + " got an encrypted message from its parent without being initialized");
                    return;
                }
                try {
                    data = JSON.parse(self.gcm_from_parent.decrypt(data));
                } catch (ρσ_Exception) {
                    ρσ_last_exception = ρσ_Exception;
                    if (ρσ_Exception instanceof Error) {
                        var e = ρσ_Exception;
                        print("Could not process message from parent:");
                        console.log(e);
                        return;
                    } else {
                        throw ρσ_Exception;
                    }
                }
            }
            if (!data || !data.action) {
                console.log("Got a null message from parent in iframe, ignoring");
                return;
            }
            func = (ρσ_expr_temp = self.handlers)[ρσ_bound_index(data.action, ρσ_expr_temp)];
            if (func) {
                try {
                    func(data);
                } catch (ρσ_Exception) {
                    ρσ_last_exception = ρσ_Exception;
                    if (ρσ_Exception instanceof Error) {
                        var e = ρσ_Exception;
                        console.log("Error in iframe message handler {}:".format((typeof data !== "undefined" && data !== null ? data : Object.create(null)).action));
                        console.log(e);
                        details = traceback.format_exc();
                        console.log(details);
                        ρσ_interpolate_kwargs.call(self, self.send_message, ["error"].concat([ρσ_desugar_kwargs({title: "Error in message handler", details: details, msg: e.toString()})]));
                    } else {
                        throw ρσ_Exception;
                    }
                }
            } else {
                print("Unknown action in message to iframe from parent: " + data.action);
            }
        };
        if (!IframeClient.prototype.handle_message.__argnames__) Object.defineProperties(IframeClient.prototype.handle_message, {
            __argnames__ : {value: ["event"]},
            __module__ : {value: "iframe_comm"}
        });
        IframeClient.prototype.send_message = function send_message(action, data) {
            var self = this;
            data.action = action;
            data.iframe_id = "" + ρσ_str.format("{}", self.name) + "-" + ρσ_str.format("{}", self.instance_num) + "";
            if (self.encrypted_communications) {
                data = self.gcm_to_parent.encrypt(JSON.stringify(data));
            }
            window.parent.postMessage(data, "*");
        };
        if (!IframeClient.prototype.send_message.__argnames__) Object.defineProperties(IframeClient.prototype.send_message, {
            __argnames__ : {value: ["action", "data"]},
            __module__ : {value: "iframe_comm"}
        });
        IframeClient.prototype.__repr__ = function __repr__ () {
                        return "<" + __name__ + "." + this.constructor.name + " #" + this.ρσ_object_id + ">";
        };
        IframeClient.prototype.__str__ = function __str__ () {
            return this.__repr__();
        };
        Object.defineProperty(IframeClient.prototype, "__bases__", {value: []});

        ρσ_modules.iframe_comm.LOADING_DOC = LOADING_DOC;
        ρσ_modules.iframe_comm.instance_numbers = instance_numbers;
        ρσ_modules.iframe_comm.Messenger = Messenger;
        ρσ_modules.iframe_comm.IframeWrapper = IframeWrapper;
        ρσ_modules.iframe_comm.create_wrapped_iframe = create_wrapped_iframe;
        ρσ_modules.iframe_comm.IframeClient = IframeClient;
    })();

    (function(){
        var __name__ = "read_book.settings";
        var opts, styles_id;
        var E = ρσ_modules.elementmaker.E;

        var dark_link_color = ρσ_modules["read_book.globals"].dark_link_color;
        var runtime = ρσ_modules["read_book.globals"].runtime;

        var defaults = ρσ_modules.session.defaults;

        opts = Object.create(null);
        function update_settings(settings) {
            settings = Object.assign(Object.create(null), defaults, settings);
            opts.base_font_size = max(8, min(settings.base_font_size, 64));
            opts.bg_image_fade = settings.bg_image_fade || "transparent";
            opts.color_scheme = settings.color_scheme;
            opts.columns_per_screen = settings.columns_per_screen;
            opts.cover_preserve_aspect_ratio = !!settings.cover_preserve_aspect_ratio;
            opts.hide_tooltips = settings.hide_tooltips;
            opts.is_dark_theme = !!settings.is_dark_theme;
            opts.lines_per_sec_auto = settings.lines_per_sec_auto;
            opts.lines_per_sec_smooth = settings.lines_per_sec_smooth;
            opts.margin_left = max(0, settings.margin_left);
            opts.margin_right = max(0, settings.margin_right);
            opts.margin_top = max(0, settings.margin_top);
            opts.margin_bottom = max(0, settings.margin_bottom);
            opts.override_book_colors = settings.override_book_colors;
            opts.paged_wheel_scrolls_by_screen = !!settings.paged_wheel_scrolls_by_screen;
            opts.paged_pixel_scroll_threshold = settings.paged_pixel_scroll_threshold;
            opts.paged_taps_scroll_by_screen = !!settings.paged_taps_scroll_by_screen;
            opts.scroll_auto_boundary_delay = settings.scroll_auto_boundary_delay;
            opts.scroll_stop_boundaries = !!settings.scroll_stop_boundaries;
            opts.reverse_page_turn_zones = !!settings.reverse_page_turn_zones;
            opts.user_stylesheet = settings.user_stylesheet;
        };
        if (!update_settings.__argnames__) Object.defineProperties(update_settings, {
            __argnames__ : {value: ["settings"]},
            __module__ : {value: "read_book.settings"}
        });

        update_settings();
        function apply_font_size() {
            if (!runtime.is_standalone_viewer) {
                document.documentElement.style.fontSize = "{}px".format(opts.base_font_size);
            }
        };
        if (!apply_font_size.__module__) Object.defineProperties(apply_font_size, {
            __module__ : {value: "read_book.settings"}
        });

        function default_selection_colors() {
            if (opts.is_dark_theme) {
                return [dark_link_color, "#111"];
            }
            return ["#3297FD", "#fff"];
        };
        if (!default_selection_colors.__module__) Object.defineProperties(default_selection_colors, {
            __module__ : {value: "read_book.settings"}
        });

        function make_selection_background_opaque(selbg) {
            if (selbg && selbg.startsWith("#") && len(selbg) === 7) {
                selbg += "fe";
            }
            return selbg;
        };
        if (!make_selection_background_opaque.__argnames__) Object.defineProperties(make_selection_background_opaque, {
            __argnames__ : {value: ["selbg"]},
            __module__ : {value: "read_book.settings"}
        });

        styles_id = "calibre-color-scheme-style-overrides";
        function apply_colors(is_content_popup) {
            var des, elem, ss, text, c, ρσ_unpack, selbg, selfg, hints_box_css;
            des = document.documentElement.style;
            des.setProperty("--calibre-viewer-background-color", opts.color_scheme.background);
            des.setProperty("--calibre-viewer-foreground-color", opts.color_scheme.foreground);
            des.colorScheme = (opts.is_dark_theme) ? "dark" : "light";
            if (opts.color_scheme.link) {
                des.setProperty("--calibre-viewer-link-color", opts.color_scheme.link);
            }
            var ρσ_Iter0 = ρσ_Iterable(ρσ_list_decorate([ document.documentElement, document.body ]));
            for (var ρσ_Index0 = 0; ρσ_Index0 < ρσ_Iter0.length; ρσ_Index0++) {
                elem = ρσ_Iter0[ρσ_Index0];
                elem.style.color = opts.color_scheme.foreground;
                elem.style.backgroundColor = "transparent";
            }
            des.backgroundColor = opts.bg_image_fade;
            ss = document.getElementById("calibre-color-scheme-style-overrides");
            if (!ss) {
                ss = ρσ_interpolate_kwargs.call(E, E.style, [ρσ_desugar_kwargs({id: styles_id, type: "text/css"})]);
                document.documentElement.appendChild(ss);
            }
            text = "";
            if (runtime.is_standalone_viewer && ρσ_in("macos", window.navigator.userAgent)) {
                text += "\n* { -webkit-hyphenate-character: \"-\" !important }\n";
            }
            if (opts.override_book_colors !== "never") {
                text = "body";
                if (opts.override_book_colors === "dark") {
                    text += ".calibre-viewer-dark-colors";
                }
                text += "\n        * {\n            color: " + ρσ_str.format("{}", opts.color_scheme.foreground) + " !important; /**/\n            background-color: " + ρσ_str.format("{}", opts.color_scheme.background) + " !important; /**/\n            border-color: " + ρσ_str.format("{}", opts.color_scheme.foreground) + " !important; /**/\n        }";
            }
            if (opts.color_scheme.link) {
                c = opts.color_scheme.link;
                text += "\nhtml > body :link, html > body :link * { color: " + ρσ_str.format("{}", c) + " !important } html > body :visited, html > body :visited * { color: " + ρσ_str.format("{}", c) + " !important }";
            }
            ρσ_unpack = default_selection_colors();
ρσ_unpack = ρσ_unpack_asarray(2, ρσ_unpack);
            selbg = ρσ_unpack[0];
            selfg = ρσ_unpack[1];
            selbg = make_selection_background_opaque(selbg);
            text += "\n::selection { background-color: " + ρσ_str.format("{}", selbg) + "; color: " + ρσ_str.format("{}", selfg) + " }";
            text += "\n::selection:window-inactive { background-color: " + ρσ_str.format("{}", selbg) + "; color: " + ρσ_str.format("{}", selfg) + " }";
            if (!is_content_popup) {
                text += "\nhtml::-webkit-scrollbar, body::-webkit-scrollbar { display: none !important }";
                text += "\nhtml, body { scrollbar-width: none !important }";
                text += "\n\n\n        .crw-has-dot::after {\n            content: \"\";            vertical-align: text-top;            background-color: currentColor !important;            text-decoration: none !important;            display: inline-block;            height: 0.7ex;            width: 0.7ex;            border-radius: 50%;        }\n        ";
            }
            hints_box_css = "\n            display: inline-block !important;            position: absolute !important;            text-indent: 0 !important;            text-decoration: none !important;            font-weight: bold !important;            color: " + ρσ_str.format("{}", selfg) + " !important;            background: " + ρσ_str.format("{}", selbg) + " !important;            cursor: default !important;            padding: 1px !important;            border: solid 1px " + ρσ_str.format("{}", opts.color_scheme.foreground) + " !important;    ";
            text += "\n\n\n        .calibre-reference-mode [data-calibre-ref-num]::before {\n            content: attr(data-calibre-ref-num) !important;            " + ρσ_str.format("{}", hints_box_css) + "\n        }\n    ";
            text += "\n\n\n        .calibre-hint-visible::before {\n            content: attr(data-calibre-hint-render) !important;            " + ρσ_str.format("{}", hints_box_css) + "\n        }\n\n        .calibre-hint-enter::before {\n            background: #FF5733 !important;         }\n\n        .calibre-animated-hint {\n            animation-name: calibre-animate-hint;             animation-duration: 0.3s;             animation-timing-function: ease-out;             display: inline-block !important;             text-indent: 0 !important;         }\n        @keyframes calibre-animate-hint {\n            from { transform: scale(1); }\n            to { transform: scale(2); }\n        }\n    ";
            ss.textContent = text;
        };
        if (!apply_colors.__argnames__) Object.defineProperties(apply_colors, {
            __argnames__ : {value: ["is_content_popup"]},
            __module__ : {value: "read_book.settings"}
        });

        function set_selection_style(style) {
            var ρσ_unpack, selbg, selfg, sheet, css_text, prop, rule;
            if (!style) {
                ρσ_unpack = default_selection_colors();
ρσ_unpack = ρσ_unpack_asarray(2, ρσ_unpack);
                selbg = ρσ_unpack[0];
                selfg = ρσ_unpack[1];
                style = (function(){
                    var ρσ_d = Object.create(null);
                    ρσ_d["color"] = selfg;
                    ρσ_d["background-color"] = selbg;
                    return ρσ_d;
                }).call(this);
            }
            sheet = document.getElementById(styles_id);
            if (!sheet) {
                return;
            }
            css_text = "";
            if (style.selbg) {
                style.selbg = make_selection_background_opaque(style.selbg);
            }
            var ρσ_Iter1 = ρσ_Iterable(Object.keys(style));
            for (var ρσ_Index1 = 0; ρσ_Index1 < ρσ_Iter1.length; ρσ_Index1++) {
                prop = ρσ_Iter1[ρσ_Index1];
                css_text += "" + ρσ_str.format("{}", prop) + ": " + ρσ_str.format("{}", style[(typeof prop === "number" && prop < 0) ? style.length + prop : prop]) + "; ";
            }
            var ρσ_Iter2 = ρσ_Iterable(sheet.sheet.cssRules);
            for (var ρσ_Index2 = 0; ρσ_Index2 < ρσ_Iter2.length; ρσ_Index2++) {
                rule = ρσ_Iter2[ρσ_Index2];
                if (rule.type === rule.STYLE_RULE && rule.selectorText.indexOf("selection") > -1) {
                    rule.style.cssText = css_text;
                }
            }
        };
        if (!set_selection_style.__argnames__) Object.defineProperties(set_selection_style, {
            __argnames__ : {value: ["style"]},
            __module__ : {value: "read_book.settings"}
        });

        function set_color_scheme_class() {
            document.documentElement.classList.add("is-calibre-viewer");
            if (opts.is_dark_theme) {
                document.body.classList.add("calibre-viewer-dark-colors");
                document.body.classList.remove("calibre-viewer-light-colors");
            } else {
                document.body.classList.add("calibre-viewer-light-colors");
                document.body.classList.remove("calibre-viewer-dark-colors");
            }
        };
        if (!set_color_scheme_class.__module__) Object.defineProperties(set_color_scheme_class, {
            __module__ : {value: "read_book.settings"}
        });

        function apply_stylesheet() {
            var sid, style;
            sid = "calibre-browser-viewer-user-stylesheet";
            style = document.getElementById(sid);
            if (!style) {
                if (!opts.user_stylesheet) {
                    return;
                }
                style = ρσ_interpolate_kwargs.call(E, E.style, [ρσ_desugar_kwargs({type: "text/css", id: sid})]);
                document.documentElement.appendChild(style);
            }
            style.textContent = opts.user_stylesheet;
        };
        if (!apply_stylesheet.__module__) Object.defineProperties(apply_stylesheet, {
            __module__ : {value: "read_book.settings"}
        });

        function apply_settings(is_content_popup) {
            apply_font_size();
            apply_colors(is_content_popup);
            apply_stylesheet();
        };
        if (!apply_settings.__argnames__) Object.defineProperties(apply_settings, {
            __argnames__ : {value: ["is_content_popup"]},
            __module__ : {value: "read_book.settings"}
        });

        ρσ_modules["read_book.settings"].opts = opts;
        ρσ_modules["read_book.settings"].styles_id = styles_id;
        ρσ_modules["read_book.settings"].update_settings = update_settings;
        ρσ_modules["read_book.settings"].apply_font_size = apply_font_size;
        ρσ_modules["read_book.settings"].default_selection_colors = default_selection_colors;
        ρσ_modules["read_book.settings"].make_selection_background_opaque = make_selection_background_opaque;
        ρσ_modules["read_book.settings"].apply_colors = apply_colors;
        ρσ_modules["read_book.settings"].set_selection_style = set_selection_style;
        ρσ_modules["read_book.settings"].set_color_scheme_class = set_color_scheme_class;
        ρσ_modules["read_book.settings"].apply_stylesheet = apply_stylesheet;
        ρσ_modules["read_book.settings"].apply_settings = apply_settings;
    })();

    (function(){
        var __name__ = "read_book.resources";
        var JSON_XHTML_MIMETYPE, mathjax_data, js_types, k, resource_tag_names, ns_rmap, ns_count, hide_tooltips;
        var E = ρσ_modules.elementmaker.E;

        var base64decode = ρσ_modules.encodings.base64decode;
        var utf8_decode = ρσ_modules.encodings.utf8_decode;

        var clear = ρσ_modules.dom.clear;
        var remove_all_attributes = ρσ_modules.dom.remove_all_attributes;

        var runtime = ρσ_modules["read_book.globals"].runtime;
        var ui_operations = ρσ_modules["read_book.globals"].ui_operations;

        var opts = ρσ_modules["read_book.settings"].opts;

        JSON_XHTML_MIMETYPE = "application/calibre+xhtml+json";
        function decode_component(x) {
            return utf8_decode(base64decode(x));
        };
        if (!decode_component.__argnames__) Object.defineProperties(decode_component, {
            __argnames__ : {value: ["x"]},
            __module__ : {value: "read_book.resources"}
        });

        function decode_url(x) {
            var parts;
            parts = x.split("#", 1);
            return [decode_component(parts[0]), parts[1] || ""];
        };
        if (!decode_url.__argnames__) Object.defineProperties(decode_url, {
            __argnames__ : {value: ["x"]},
            __module__ : {value: "read_book.resources"}
        });

        function create_link_pat(book) {
            return new RegExp(book.manifest.link_uid + "\\|([^|]+)\\|", "g");
        };
        if (!create_link_pat.__argnames__) Object.defineProperties(create_link_pat, {
            __argnames__ : {value: ["book"]},
            __module__ : {value: "read_book.resources"}
        });

        function load_resources(book, root_name, previous_resources, proceed) {
            var ans, pending_resources, link_pat;
            ans = Object.create(null);
            pending_resources = [root_name];
            link_pat = create_link_pat(book);
            function do_one() {
                var name, k, data;
                name = pending_resources.shift();
                if (!name) {
                    var ρσ_Iter0 = ρσ_Iterable(previous_resources);
                    for (var ρσ_Index0 = 0; ρσ_Index0 < ρσ_Iter0.length; ρσ_Index0++) {
                        k = ρσ_Iter0[ρσ_Index0];
                        delete previous_resources[k];
                    }
                    if ((ρσ_expr_temp = book.manifest.files)[(typeof root_name === "number" && root_name < 0) ? ρσ_expr_temp.length + root_name : root_name].has_maths) {
                        return load_mathjax(book, ans, proceed);
                    }
                    return proceed(ans);
                }
                if (ans[(typeof name === "number" && name < 0) ? ans.length + name : name]) {
                    return setTimeout(do_one, 0);
                }
                if (previous_resources[(typeof name === "number" && name < 0) ? previous_resources.length + name : name]) {
                    ans[(typeof name === "number" && name < 0) ? ans.length + name : name] = data = previous_resources[(typeof name === "number" && name < 0) ? previous_resources.length + name : name];
                    if (typeof data[0] === "string") {
                        find_virtualized_resources(data[0]);
                    }
                    return setTimeout(do_one, 0);
                }
                ui_operations.get_file(book, name, got_one);
            };
            if (!do_one.__module__) Object.defineProperties(do_one, {
                __module__ : {value: "read_book.resources"}
            });

            function got_one(data, name, mimetype) {
                ans[(typeof name === "number" && name < 0) ? ans.length + name : name] = [data, mimetype];
                if (typeof data === "string" && ρσ_exists.d((ρσ_expr_temp = book.manifest.files)[(typeof name === "number" && name < 0) ? ρσ_expr_temp.length + name : name]).is_virtualized) {
                    find_virtualized_resources(data);
                }
                return setTimeout(do_one, 0);
            };
            if (!got_one.__argnames__) Object.defineProperties(got_one, {
                __argnames__ : {value: ["data", "name", "mimetype"]},
                __module__ : {value: "read_book.resources"}
            });

            function find_virtualized_resources(text) {
                var seen, already_pending, x, m, name;
                seen = set();
                already_pending = (function() {
                    var ρσ_Iter = ρσ_Iterable(pending_resources), ρσ_Result = ρσ_set(), x;
                    for (var ρσ_Index = 0; ρσ_Index < ρσ_Iter.length; ρσ_Index++) {
                        x = ρσ_Iter[ρσ_Index];
                        ρσ_Result.add(x.name);
                    }
                    return ρσ_Result;
                })();
                link_pat.lastIndex = 0;
                while (true) {
                    m = link_pat.exec(text);
                    if (!m) {
                        break;
                    }
                    name = decode_url(m[1])[0];
                    if (ρσ_in(name, seen) || ρσ_in(name, already_pending)) {
                        continue;
                    }
                    seen.add(name);
                    pending_resources.push(name);
                }
            };
            if (!find_virtualized_resources.__argnames__) Object.defineProperties(find_virtualized_resources, {
                __argnames__ : {value: ["text"]},
                __module__ : {value: "read_book.resources"}
            });

            do_one();
        };
        if (!load_resources.__argnames__) Object.defineProperties(load_resources, {
            __argnames__ : {value: ["book", "root_name", "previous_resources", "proceed"]},
            __module__ : {value: "read_book.resources"}
        });

        mathjax_data = null;
        function load_mathjax(book, resource_data, proceed) {
            if (mathjax_data === null) {
                ui_operations.get_mathjax_files((function() {
                    var ρσ_anonfunc = function (data) {
                        mathjax_data = data;
                        resource_data["..mathjax-files.."] = data;
                        proceed(resource_data);
                    };
                    if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                        __argnames__ : {value: ["data"]},
                        __module__ : {value: "read_book.resources"}
                    });
                    return ρσ_anonfunc;
                })());
            } else {
                resource_data["..mathjax-files.."] = mathjax_data;
                proceed(resource_data);
            }
        };
        if (!load_mathjax.__argnames__) Object.defineProperties(load_mathjax, {
            __argnames__ : {value: ["book", "resource_data", "proceed"]},
            __module__ : {value: "read_book.resources"}
        });

        function finalize_resources(book, root_name, resource_data) {
            var blob_url_map, root_data, link_pat, mathjax, ρσ_unpack, data, mimetype, name, unresolved_deps_map, resolved, num, text, unresolved_deps, unresolved;
            blob_url_map = Object.create(null);
            root_data = null;
            link_pat = create_link_pat(book);
            mathjax = resource_data["..mathjax-files.."];
            delete resource_data["..mathjax-files.."];
            var ρσ_Iter1 = ρσ_Iterable(resource_data);
            for (var ρσ_Index1 = 0; ρσ_Index1 < ρσ_Iter1.length; ρσ_Index1++) {
                name = ρσ_Iter1[ρσ_Index1];
                ρσ_unpack = resource_data[(typeof name === "number" && name < 0) ? resource_data.length + name : name];
ρσ_unpack = ρσ_unpack_asarray(2, ρσ_unpack);
                data = ρσ_unpack[0];
                mimetype = ρσ_unpack[1];
                if (typeof data !== "string") {
                    blob_url_map[(typeof name === "number" && name < 0) ? blob_url_map.length + name : name] = window.URL.createObjectURL(data);
                }
            }
            var ρσ_Iter2 = ρσ_Iterable(blob_url_map);
            for (var ρσ_Index2 = 0; ρσ_Index2 < ρσ_Iter2.length; ρσ_Index2++) {
                name = ρσ_Iter2[ρσ_Index2];
                delete resource_data[name];
            }
            function add_virtualized_resource(name, text, mimetype) {
                if (name === root_name) {
                    root_data = JSON.parse(text);
                } else {
                    blob_url_map[(typeof name === "number" && name < 0) ? blob_url_map.length + name : name] = window.URL.createObjectURL(new Blob(ρσ_list_decorate([ text ]), (function(){
                        var ρσ_d = Object.create(null);
                        ρσ_d["type"] = mimetype;
                        return ρσ_d;
                    }).call(this)));
                }
            };
            if (!add_virtualized_resource.__argnames__) Object.defineProperties(add_virtualized_resource, {
                __argnames__ : {value: ["name", "text", "mimetype"]},
                __module__ : {value: "read_book.resources"}
            });

            function replace_deps(text) {
                var replacements, unresolved_deps, m, ρσ_unpack, dname, frag, rtext, index, sz, repl;
                replacements = [];
                unresolved_deps = set();
                link_pat.lastIndex = 0;
                while (true) {
                    m = link_pat.exec(text);
                    if (!m) {
                        break;
                    }
                    ρσ_unpack = decode_url(m[1]);
ρσ_unpack = ρσ_unpack_asarray(2, ρσ_unpack);
                    dname = ρσ_unpack[0];
                    frag = ρσ_unpack[1];
                    if (blob_url_map[(typeof dname === "number" && dname < 0) ? blob_url_map.length + dname : dname]) {
                        rtext = blob_url_map[(typeof dname === "number" && dname < 0) ? blob_url_map.length + dname : dname];
                        if (frag) {
                            rtext += "#" + frag;
                        }
                        replacements.push([m.index, m[0].length, rtext]);
                    } else {
                        unresolved_deps.add(dname);
                    }
                }
                var ρσ_Iter3 = ρσ_Iterable(reversed(replacements));
                for (var ρσ_Index3 = 0; ρσ_Index3 < ρσ_Iter3.length; ρσ_Index3++) {
                    ρσ_unpack = ρσ_flatten(ρσ_Iter3[ρσ_Index3]);
                    index = ρσ_unpack[0];
                    sz = ρσ_unpack[1];
                    repl = ρσ_unpack[2];
                    text = text.slice(0, index) + repl + text.slice(index + sz);
                }
                return [unresolved_deps, text];
            };
            if (!replace_deps.__argnames__) Object.defineProperties(replace_deps, {
                __argnames__ : {value: ["text"]},
                __module__ : {value: "read_book.resources"}
            });

            unresolved_deps_map = Object.create(null);
            function has_unresolvable_deps(name) {
                var deps, x;
                deps = unresolved_deps_map[(typeof name === "number" && name < 0) ? unresolved_deps_map.length + name : name];
                if (!deps || !deps.length) {
                    return false;
                }
                var ρσ_Iter4 = ρσ_Iterable(deps);
                for (var ρσ_Index4 = 0; ρσ_Index4 < ρσ_Iter4.length; ρσ_Index4++) {
                    x = ρσ_Iter4[ρσ_Index4];
                    if (!blob_url_map[(typeof x === "number" && x < 0) ? blob_url_map.length + x : x]) {
                        return true;
                    }
                }
                return false;
            };
            if (!has_unresolvable_deps.__argnames__) Object.defineProperties(has_unresolvable_deps, {
                __argnames__ : {value: ["name"]},
                __module__ : {value: "read_book.resources"}
            });

            while (true) {
                resolved = [];
                num = 0;
                var ρσ_Iter5 = ρσ_Iterable(resource_data);
                for (var ρσ_Index5 = 0; ρσ_Index5 < ρσ_Iter5.length; ρσ_Index5++) {
                    name = ρσ_Iter5[ρσ_Index5];
                    if (!blob_url_map[(typeof name === "number" && name < 0) ? blob_url_map.length + name : name]) {
                        num += 1;
                        ρσ_unpack = resource_data[(typeof name === "number" && name < 0) ? resource_data.length + name : name];
ρσ_unpack = ρσ_unpack_asarray(2, ρσ_unpack);
                        text = ρσ_unpack[0];
                        mimetype = ρσ_unpack[1];
                        if (!has_unresolvable_deps(name)) {
                            ρσ_unpack = replace_deps(text);
ρσ_unpack = ρσ_unpack_asarray(2, ρσ_unpack);
                            unresolved_deps = ρσ_unpack[0];
                            text = ρσ_unpack[1];
                            unresolved_deps_map[(typeof name === "number" && name < 0) ? unresolved_deps_map.length + name : name] = unresolved_deps;
                            if (!unresolved_deps.length) {
                                add_virtualized_resource(name, text, mimetype);
                                resolved.push(name);
                            }
                        }
                    }
                }
                if (!num) {
                    break;
                }
                if (!resolved.length) {
                    unresolved = (function() {
                        var ρσ_Iter = ρσ_Iterable(resource_data), ρσ_Result = [], name;
                        for (var ρσ_Index = 0; ρσ_Index < ρσ_Iter.length; ρσ_Index++) {
                            name = ρσ_Iter[ρσ_Index];
                            if (!blob_url_map[(typeof name === "number" && name < 0) ? blob_url_map.length + name : name]) {
                                ρσ_Result.push(name);
                            }
                        }
                        ρσ_Result = ρσ_list_constructor(ρσ_Result);
                        return ρσ_Result;
                    })();
                    print("ERROR: Could not resolve all dependencies of {} because of a cyclic dependency. Remaining deps: {}".format(root_name, unresolved));
                    var ρσ_Iter6 = ρσ_Iterable(resource_data);
                    for (var ρσ_Index6 = 0; ρσ_Index6 < ρσ_Iter6.length; ρσ_Index6++) {
                        name = ρσ_Iter6[ρσ_Index6];
                        if (!blob_url_map[(typeof name === "number" && name < 0) ? blob_url_map.length + name : name]) {
                            ρσ_unpack = resource_data[(typeof name === "number" && name < 0) ? resource_data.length + name : name];
ρσ_unpack = ρσ_unpack_asarray(2, ρσ_unpack);
                            text = ρσ_unpack[0];
                            mimetype = ρσ_unpack[1];
                            text = replace_deps(text)[1];
                            add_virtualized_resource(name, text, mimetype);
                        }
                    }
                    break;
                }
                var ρσ_Iter7 = ρσ_Iterable(resolved);
                for (var ρσ_Index7 = 0; ρσ_Index7 < ρσ_Iter7.length; ρσ_Index7++) {
                    name = ρσ_Iter7[ρσ_Index7];
                    delete resource_data[name];
                }
            }
            return [root_data, mathjax, blob_url_map];
        };
        if (!finalize_resources.__argnames__) Object.defineProperties(finalize_resources, {
            __argnames__ : {value: ["book", "root_name", "resource_data"]},
            __module__ : {value: "read_book.resources"}
        });

        js_types = (function() {
            var ρσ_Iter = ρσ_Iterable("text/javascript text/ecmascript application/javascript application/ecmascript".split(" ")), ρσ_Result = Object.create(null), k;
            for (var ρσ_Index = 0; ρσ_Index < ρσ_Iter.length; ρσ_Index++) {
                k = ρσ_Iter[ρσ_Index];
                ρσ_Result[k] = (true);
            }
            return ρσ_Result;
        })();
        resource_tag_names = (function(){
            var ρσ_d = Object.create(null);
            ρσ_d["script"] = "src";
            ρσ_d["link"] = "href";
            ρσ_d["img"] = "src";
            ρσ_d["image"] = "xlink:href";
            return ρσ_d;
        }).call(this);
        ns_rmap = (function(){
            var ρσ_d = Object.create(null);
            ρσ_d["http://www.w3.org/2000/svg"] = "svg";
            ρσ_d["http://www.w3.org/1999/xlink"] = "xlink";
            ρσ_d["http://www.w3.org/1998/Math/MathML"] = "math";
            ρσ_d["http://www.w3.org/XML/1998/namespace"] = "xml";
            ρσ_d["http://www.idpf.org/2007/ops"] = "epub";
            return ρσ_d;
        }).call(this);
        ns_count = 0;
        hide_tooltips = false;
        function get_prefix(ns) {
            var ans;
            ans = ns_rmap[(typeof ns === "number" && ns < 0) ? ns_rmap.length + ns : ns];
            if (!ans) {
                ns_rmap[(typeof ns === "number" && ns < 0) ? ns_rmap.length + ns : ns] = ans = "ns" + ns_count;
                ns_count += 1;
            }
            return ans + ":";
        };
        if (!get_prefix.__argnames__) Object.defineProperties(get_prefix, {
            __argnames__ : {value: ["ns"]},
            __module__ : {value: "read_book.resources"}
        });

        function apply_attributes(src, elem, ns_map) {
            var attributes, ns, name, a;
            attributes = src.a;
            if (!attributes) {
                return;
            }
            var ρσ_Iter8 = ρσ_Iterable(attributes);
            for (var ρσ_Index8 = 0; ρσ_Index8 < ρσ_Iter8.length; ρσ_Index8++) {
                a = ρσ_Iter8[ρσ_Index8];
                if (a[2]) {
                    ns = ns_map[ρσ_bound_index(a[2], ns_map)];
                    elem.setAttributeNS(ns, get_prefix(ns) + a[0], a[1]);
                } else {
                    name = a[0];
                    if (hide_tooltips && (name === "title" || name === "alt")) {
                        continue;
                    }
                    elem.setAttribute(name, a[1]);
                }
            }
        };
        if (!apply_attributes.__argnames__) Object.defineProperties(apply_attributes, {
            __argnames__ : {value: ["src", "elem", "ns_map"]},
            __module__ : {value: "read_book.resources"}
        });

        function is_loadable_link(attributes) {
            var x, a;
            var ρσ_Iter9 = ρσ_Iterable(attributes);
            for (var ρσ_Index9 = 0; ρσ_Index9 < ρσ_Iter9.length; ρσ_Index9++) {
                a = ρσ_Iter9[ρσ_Index9];
                if (a[0].toLowerCase() === "rel" && a[1]) {
                    var ρσ_Iter10 = ρσ_Iterable(a[1].split(" "));
                    for (var ρσ_Index10 = 0; ρσ_Index10 < ρσ_Iter10.length; ρσ_Index10++) {
                        x = ρσ_Iter10[ρσ_Index10];
                        if (x.toLowerCase() === "stylesheet") {
                            return true;
                        }
                    }
                }
            }
            return false;
        };
        if (!is_loadable_link.__argnames__) Object.defineProperties(is_loadable_link, {
            __argnames__ : {value: ["attributes"]},
            __module__ : {value: "read_book.resources"}
        });

        function process_stack(stack, tag_map, ns_map, load_required, onload) {
            var ρσ_unpack, node, parent, tag_id, src, elem, loadable, attr, a, load_callback;
            while (stack.length) {
                ρσ_unpack = stack.pop();
ρσ_unpack = ρσ_unpack_asarray(2, ρσ_unpack);
                node = ρσ_unpack[0];
                parent = ρσ_unpack[1];
                if (tag_map) {
                    tag_id = node[0];
                    src = tag_map[(typeof tag_id === "number" && tag_id < 0) ? tag_map.length + tag_id : tag_id];
                } else {
                    src = node;
                    tag_id = process_stack.tag_id++;
                }
                if (src.s) {
                    if (src.n) {
                        elem = document.createElementNS(ns_map[ρσ_bound_index(src.s, ns_map)], src.n);
                    } else {
                        if (src.l) {
                            parent.appendChild(document.createTextNode(src.l));
                        }
                        continue;
                    }
                } else {
                    elem = document.createElement(src.n);
                }
                loadable = false;
                attr = resource_tag_names[ρσ_bound_index(src.n, resource_tag_names)];
                if (attr) {
                    if (ρσ_not_equals(attr.indexOf(":"), -1)) {
                        attr = attr.replace("xlink:", "");
                    }
                    if (src.a) {
                        var ρσ_Iter11 = ρσ_Iterable(src.a);
                        for (var ρσ_Index11 = 0; ρσ_Index11 < ρσ_Iter11.length; ρσ_Index11++) {
                            a = ρσ_Iter11[ρσ_Index11];
                            if (a[0] === attr) {
                                loadable = (src.n === "link") ? is_loadable_link(src.a) : true;
                                break;
                            }
                        }
                    }
                }
                if (loadable) {
                    load_required.add(tag_id);
                    load_callback = onload.bind(tag_id);
                    elem.addEventListener("load", load_callback);
                    elem.addEventListener("error", load_callback);
                }
                apply_attributes(src, elem, ns_map);
                parent.appendChild(elem);
                if (src.x) {
                    if (src.n === "script" && js_types[ρσ_bound_index((elem.getAttribute("type") || "text/javascript").toLowerCase(), js_types)] === true) {
                        elem.text = src.x;
                    } else {
                        elem.appendChild(document.createTextNode(src.x));
                    }
                }
                if (src.l) {
                    parent.appendChild(document.createTextNode(src.l));
                }
                if (tag_map) {
                    for (var i = node.length - 1; i >= 1; i--) {
                        stack.push([node[i], elem]);
                    }
                } else if (node.c) {
                    for (var i = node.c.length; i-- > 0;) {
                        stack.push([node.c[i], elem]);
                    }
                }
            }
        };
        if (!process_stack.__argnames__) Object.defineProperties(process_stack, {
            __argnames__ : {value: ["stack", "tag_map", "ns_map", "load_required", "onload"]},
            __module__ : {value: "read_book.resources"}
        });

        function unserialize_html(serialized_data, proceed, postprocess_dom, root_name) {
            var html, ns_map, base, load_required, proceeded, hang_timeout, body_done, child, ev;
            hide_tooltips = opts.hide_tooltips;
            if (serialized_data.tag_map) {
                return unserialize_html_legacy(serialized_data, proceed, postprocess_dom, root_name);
            }
            html = serialized_data.tree;
            ns_map = serialized_data.ns_map;
            remove_all_attributes(document.documentElement, document.head, document.body);
            clear(document.head, document.body);
            apply_attributes(html, document.documentElement, ns_map);
            document.head.appendChild(ρσ_interpolate_kwargs.call(E, E.style, ["html::-webkit-scrollbar, body::-webkit-scrollbar { display: none !important }"].concat([ρσ_desugar_kwargs({type: "text/css"})])));
            if (runtime.is_standalone_viewer && root_name) {
                if (root_name.indexOf("/") > -1) {
                    base = window.location.pathname.rpartition("/")[0];
                    base = "" + ρσ_str.format("{}", window.location.protocol) + "//" + ρσ_str.format("{}", window.location.hostname) + "" + ρσ_str.format("{}", base) + "/" + root_name;
                    document.head.appendChild(ρσ_interpolate_kwargs.call(E, E.base, [ρσ_desugar_kwargs({href: base})]));
                }
            }
            if (!runtime.is_standalone_viewer) {
                document.head.appendChild(ρσ_interpolate_kwargs.call(E, E.style, ["html {{ font-family: {} }}".format(window.default_font_family || "sans-serif")].concat([ρσ_desugar_kwargs({type: "text/css"})])));
            }
            load_required = set();
            proceeded = false;
            hang_timeout = 5;
            function hangcheck() {
                if (!proceeded) {
                    proceeded = true;
                    print("WARNING: All resources did not load in " + ρσ_str.format("{}", hang_timeout) + " seconds, proceeding anyway (" + ρσ_str.format("{}", load_required.length) + " resources left)");
                    proceed();
                }
            };
            if (!hangcheck.__module__) Object.defineProperties(hangcheck, {
                __module__ : {value: "read_book.resources"}
            });

            function onload() {
                load_required.discard(this);
                if (!load_required.length && !proceeded) {
                    proceeded = true;
                    proceed();
                }
            };
            if (!onload.__module__) Object.defineProperties(onload, {
                __module__ : {value: "read_book.resources"}
            });

            function process_children(node, parent) {
                var stack, child;
                if (!node.c) {
                    return;
                }
                stack = [];
                for (var i = node.c.length; i-- > 0;) {
                    child = node.c[i];
                    if (child.n !== "meta" && child.n !== "base") {
                        stack.push([child, parent]);
                    }
                }
                process_stack(stack, null, ns_map, load_required, onload);
            };
            if (!process_children.__argnames__) Object.defineProperties(process_children, {
                __argnames__ : {value: ["node", "parent"]},
                __module__ : {value: "read_book.resources"}
            });

            body_done = false;
            process_stack.tag_id = 1;
            var ρσ_Iter12 = ρσ_Iterable(html.c);
            for (var ρσ_Index12 = 0; ρσ_Index12 < ρσ_Iter12.length; ρσ_Index12++) {
                child = ρσ_Iter12[ρσ_Index12];
                if (child.n === "head") {
                    process_children(child, document.head);
                } else if (child.n === "body") {
                    if (!document.body) {
                        document.documentElement.appendChild(document.createElement("body"));
                    }
                    if (!body_done) {
                        body_done = true;
                        apply_attributes(child, document.body, ns_map);
                    }
                    if (child.x) {
                        document.body.appendChild(document.createTextNode(child.x));
                    }
                    process_children(child, document.body);
                }
            }
            if (postprocess_dom) {
                postprocess_dom();
            }
            ev = document.createEvent("Event");
            ev.initEvent("DOMContentLoaded", true, true);
            document.dispatchEvent(ev);
            if (load_required.length) {
                setTimeout(hangcheck, hang_timeout * 1e3);
            } else {
                proceeded = true;
                proceed();
            }
        };
        if (!unserialize_html.__argnames__) Object.defineProperties(unserialize_html, {
            __argnames__ : {value: ["serialized_data", "proceed", "postprocess_dom", "root_name"]},
            __module__ : {value: "read_book.resources"}
        });

        function unserialize_html_legacy(serialized_data, proceed, postprocess_dom, root_name) {
            var tag_map, tree, ns_map, html, ρσ_unpack, head, body, base, load_required, proceeded, hang_timeout, stack, bnode, ev;
            tag_map = serialized_data.tag_map;
            tree = serialized_data.tree;
            ns_map = serialized_data.ns_map;
            html = tag_map[0];
            remove_all_attributes(document.documentElement);
            apply_attributes(html, document.documentElement, ns_map);
            ρσ_unpack = [tree[1], tree[2]];
            head = ρσ_unpack[0];
            body = ρσ_unpack[1];
            clear(document.head, document.body);
            remove_all_attributes(document.head, document.body);
            document.head.appendChild(ρσ_interpolate_kwargs.call(E, E.style, ["html::-webkit-scrollbar, body::-webkit-scrollbar { display: none !important }"].concat([ρσ_desugar_kwargs({type: "text/css"})])));
            if (runtime.is_standalone_viewer && root_name) {
                if (root_name.indexOf("/") > -1) {
                    base = window.location.pathname.rpartition("/")[0];
                    base = "" + ρσ_str.format("{}", window.location.protocol) + "//" + ρσ_str.format("{}", window.location.hostname) + "" + ρσ_str.format("{}", base) + "/" + root_name;
                    document.head.appendChild(ρσ_interpolate_kwargs.call(E, E.base, [ρσ_desugar_kwargs({href: base})]));
                }
            }
            if (!runtime.is_standalone_viewer) {
                document.head.appendChild(ρσ_interpolate_kwargs.call(E, E.style, ["html {{ font-family: {} }}".format(window.default_font_family || "sans-serif")].concat([ρσ_desugar_kwargs({type: "text/css"})])));
            }
            load_required = set();
            proceeded = false;
            hang_timeout = 5;
            function hangcheck() {
                if (!proceeded) {
                    proceeded = true;
                    print("WARNING: All resources did not load in " + ρσ_str.format("{}", hang_timeout) + " seconds, proceeding anyway (" + ρσ_str.format("{}", load_required.length) + " resources left)");
                    proceed();
                }
            };
            if (!hangcheck.__module__) Object.defineProperties(hangcheck, {
                __module__ : {value: "read_book.resources"}
            });

            function onload() {
                load_required.discard(this);
                if (!load_required.length && !proceeded) {
                    proceeded = true;
                    proceed();
                }
            };
            if (!onload.__module__) Object.defineProperties(onload, {
                __module__ : {value: "read_book.resources"}
            });

            stack = [];
            for (var i = head.length - 1; i >= 1; i--) {
                stack.push([head[i], document.head]);
            }
            process_stack(stack, tag_map, ns_map, load_required, onload);
            bnode = tag_map[ρσ_bound_index(body[0], tag_map)];
            apply_attributes(bnode, document.body, ns_map);
            if (bnode.x) {
                document.body.appendChild(document.createTextNode(bnode.x));
            }
            for (var i = body.length - 1; i >= 1; i--) {
                stack.push([body[i], document.body]);
            }
            process_stack(stack, tag_map, ns_map, load_required, onload);
            if (postprocess_dom) {
                postprocess_dom();
            }
            ev = document.createEvent("Event");
            ev.initEvent("DOMContentLoaded", true, true);
            document.dispatchEvent(ev);
            if (load_required.length) {
                setTimeout(hangcheck, hang_timeout * 1e3);
            } else {
                proceeded = true;
                proceed();
            }
        };
        if (!unserialize_html_legacy.__argnames__) Object.defineProperties(unserialize_html_legacy, {
            __argnames__ : {value: ["serialized_data", "proceed", "postprocess_dom", "root_name"]},
            __module__ : {value: "read_book.resources"}
        });

        function text_from_serialized_html(data, get_anchor_offset_map) {
            var serialized_data, tag_map, ans, stack, child, ignore_text, anchor_offset_map, text_pos, node, src, x, aid;
            serialized_data = JSON.parse(data);
            tag_map = serialized_data.tag_map;
            ans = [];
            if (tag_map) {
                stack = [serialized_data.tree[2]];
            } else {
                stack = [];
                var ρσ_Iter13 = ρσ_Iterable(serialized_data.tree.c);
                for (var ρσ_Index13 = 0; ρσ_Index13 < ρσ_Iter13.length; ρσ_Index13++) {
                    child = ρσ_Iter13[ρσ_Index13];
                    if (child.n === "body") {
                        stack.push(child);
                    }
                }
            }
            ignore_text = (function(){
                var ρσ_d = Object.create(null);
                ρσ_d["script"] = true;
                ρσ_d["style"] = true;
                ρσ_d["title"] = true;
                return ρσ_d;
            }).call(this);
            anchor_offset_map = Object.create(null);
            text_pos = 0;
            while (stack.length) {
                node = stack.pop();
                if (typeof node === "string") {
                    ans.push(node);
                    text_pos += node.length;
                    continue;
                }
                if (tag_map) {
                    src = tag_map[ρσ_bound_index(node[0], tag_map)];
                } else {
                    src = node;
                }
                if (get_anchor_offset_map && src.a) {
                    for (var i = 0; i < src.a.length; i++) {
                        x = (ρσ_expr_temp = src.a)[(typeof i === "number" && i < 0) ? ρσ_expr_temp.length + i : i];
                        if (x[0] === "id") {
                            aid = x[1];
                            if (typeof anchor_offset_map[(typeof aid === "number" && aid < 0) ? anchor_offset_map.length + aid : aid] !== "number") {
                                anchor_offset_map[(typeof aid === "number" && aid < 0) ? anchor_offset_map.length + aid : aid] = text_pos;
                            }
                        }
                    }
                }
                if (src.n && !ignore_text[ρσ_bound_index(src.n, ignore_text)] && src.x) {
                    ans.push(src.x);
                    text_pos += src.x.length;
                }
                if (src.l) {
                    stack.push(src.l);
                }
                if (tag_map) {
                    for (var i = node.length - 1; i >= 1; i--) {
                        stack.push(node[(typeof i === "number" && i < 0) ? node.length + i : i]);
                    }
                } else {
                    if (src.c) {
                        for (var i = src.c.length; i-- > 0;) {
                            stack.push(src.c[i]);
                        }
                    }
                }
            }
            ans = ans.join("");
            if (get_anchor_offset_map) {
                return [ans, anchor_offset_map];
            }
            return ans;
        };
        if (!text_from_serialized_html.__argnames__) Object.defineProperties(text_from_serialized_html, {
            __argnames__ : {value: ["data", "get_anchor_offset_map"]},
            __module__ : {value: "read_book.resources"}
        });

        ρσ_modules["read_book.resources"].JSON_XHTML_MIMETYPE = JSON_XHTML_MIMETYPE;
        ρσ_modules["read_book.resources"].mathjax_data = mathjax_data;
        ρσ_modules["read_book.resources"].js_types = js_types;
        ρσ_modules["read_book.resources"].k = k;
        ρσ_modules["read_book.resources"].resource_tag_names = resource_tag_names;
        ρσ_modules["read_book.resources"].ns_rmap = ns_rmap;
        ρσ_modules["read_book.resources"].ns_count = ns_count;
        ρσ_modules["read_book.resources"].hide_tooltips = hide_tooltips;
        ρσ_modules["read_book.resources"].decode_component = decode_component;
        ρσ_modules["read_book.resources"].decode_url = decode_url;
        ρσ_modules["read_book.resources"].create_link_pat = create_link_pat;
        ρσ_modules["read_book.resources"].load_resources = load_resources;
        ρσ_modules["read_book.resources"].load_mathjax = load_mathjax;
        ρσ_modules["read_book.resources"].finalize_resources = finalize_resources;
        ρσ_modules["read_book.resources"].get_prefix = get_prefix;
        ρσ_modules["read_book.resources"].apply_attributes = apply_attributes;
        ρσ_modules["read_book.resources"].is_loadable_link = is_loadable_link;
        ρσ_modules["read_book.resources"].process_stack = process_stack;
        ρσ_modules["read_book.resources"].unserialize_html = unserialize_html;
        ρσ_modules["read_book.resources"].unserialize_html_legacy = unserialize_html_legacy;
        ρσ_modules["read_book.resources"].text_from_serialized_html = text_from_serialized_html;
    })();

    (function(){
        var __name__ = "read_book.footnotes";
        var block_names, block_display_styles, ok_list_types;
        var clear = ρσ_modules.dom.clear;

        var IframeClient = ρσ_modules.iframe_comm.IframeClient;

        var runtime = ρσ_modules["read_book.globals"].runtime;
        var current_spine_item = ρσ_modules["read_book.globals"].current_spine_item;
        var set_current_spine_item = ρσ_modules["read_book.globals"].set_current_spine_item;

        var finalize_resources = ρσ_modules["read_book.resources"].finalize_resources;
        var unserialize_html = ρσ_modules["read_book.resources"].unserialize_html;

        var apply_settings = ρσ_modules["read_book.settings"].apply_settings;
        var set_color_scheme_class = ρσ_modules["read_book.settings"].set_color_scheme_class;
        var update_settings = ρσ_modules["read_book.settings"].update_settings;

        block_names = dict.fromkeys(['p', 'div', 'li', 'td', 'h1', 'h2', 'h2', 'h3', 'h4', 'h5', 'h6', 'body'], true).as_object();
        block_display_styles = dict.fromkeys(['block', 'list-item', 'table-cell', 'table'], true).as_object();
        function elem_roles(elem) {
            return (function() {
                var ρσ_Iter = ρσ_Iterable((elem.getAttribute("role") || "").split(" ")), ρσ_Result = Object.create(null), k;
                for (var ρσ_Index = 0; ρσ_Index < ρσ_Iter.length; ρσ_Index++) {
                    k = ρσ_Iter[ρσ_Index];
                    ρσ_Result[k.toLowerCase()] = (true);
                }
                return ρσ_Result;
            })();
        };
        if (!elem_roles.__argnames__) Object.defineProperties(elem_roles, {
            __argnames__ : {value: ["elem"]},
            __module__ : {value: "read_book.footnotes"}
        });

        function epub_type(elem) {
            var a;
            var ρσ_Iter0 = ρσ_Iterable(elem.attributes);
            for (var ρσ_Index0 = 0; ρσ_Index0 < ρσ_Iter0.length; ρσ_Index0++) {
                a = ρσ_Iter0[ρσ_Index0];
                if (ρσ_equals(a.nodeName.toLowerCase(), "epub:type") && a.nodeValue) {
                    return a.nodeValue;
                }
            }
        };
        if (!epub_type.__argnames__) Object.defineProperties(epub_type, {
            __argnames__ : {value: ["elem"]},
            __module__ : {value: "read_book.footnotes"}
        });

        function get_containing_block(node) {
            while (node && node.tagName && block_names[ρσ_bound_index(node.tagName.toLowerCase(), block_names)] !== true) {
                node = node.parentNode;
            }
            return node;
        };
        if (!get_containing_block.__argnames__) Object.defineProperties(get_containing_block, {
            __argnames__ : {value: ["node"]},
            __module__ : {value: "read_book.footnotes"}
        });

        function is_footnote_link(a, dest_name, dest_frag, src_name, link_to_map) {
            var roles, ρσ_unpack, x, num, style, children, text_children, eid, files_linking_to_self, files_linking_to_anchor, cb, ltext, ctext;
            roles = elem_roles(a);
            if (roles["doc-noteref"] || roles["doc-biblioref"] || roles["doc-glossref"]) {
                return true;
            }
            if (roles["doc-link"]) {
                return false;
            }
            if (epub_type(a) === "noteref") {
                return true;
            }
            ρσ_unpack = [a, 3];
            x = ρσ_unpack[0];
            num = ρσ_unpack[1];
            while (x && num > 0) {
                style = window.getComputedStyle(x);
                if (!(ρσ_expr_temp = is_footnote_link.inline_displays)[ρσ_bound_index(style.display, ρσ_expr_temp)]) {
                    break;
                }
                if ((ρσ_expr_temp = is_footnote_link.vert_aligns)[ρσ_bound_index(style.verticalAlign, ρσ_expr_temp)]) {
                    return true;
                }
                x = x.parentNode;
                num -= 1;
            }
            children = (function() {
                var ρσ_Iter = ρσ_Iterable(a.childNodes), ρσ_Result = [], x;
                for (var ρσ_Index = 0; ρσ_Index < ρσ_Iter.length; ρσ_Index++) {
                    x = ρσ_Iter[ρσ_Index];
                    if (x.nodeType === Node.ELEMENT_NODE) {
                        ρσ_Result.push(x);
                    }
                }
                ρσ_Result = ρσ_list_constructor(ρσ_Result);
                return ρσ_Result;
            })();
            if ((children.length === 1 || typeof children.length === "object" && ρσ_equals(children.length, 1))) {
                style = window.getComputedStyle(children[0]);
                if ((ρσ_expr_temp = is_footnote_link.inline_displays)[ρσ_bound_index(style.display, ρσ_expr_temp)] && (ρσ_expr_temp = is_footnote_link.vert_aligns)[ρσ_bound_index(style.verticalAlign, ρσ_expr_temp)]) {
                    text_children = (function() {
                        var ρσ_Iter = ρσ_Iterable(a.childNodes), ρσ_Result = [], x;
                        for (var ρσ_Index = 0; ρσ_Index < ρσ_Iter.length; ρσ_Index++) {
                            x = ρσ_Iter[ρσ_Index];
                            if (x.nodeType === Node.TEXT_NODE && x.nodeValue && /\S+/.test(x.nodeValue)) {
                                ρσ_Result.push(x);
                            }
                        }
                        ρσ_Result = ρσ_list_constructor(ρσ_Result);
                        return ρσ_Result;
                    })();
                    if (!text_children.length) {
                        return true;
                    }
                }
            }
            eid = a.getAttribute("id") || a.getAttribute("name");
            files_linking_to_self = link_to_map[(typeof src_name === "number" && src_name < 0) ? link_to_map.length + src_name : src_name];
            if (eid && files_linking_to_self) {
                files_linking_to_anchor = files_linking_to_self[(typeof eid === "number" && eid < 0) ? files_linking_to_self.length + eid : eid] || [];
                if (files_linking_to_anchor.length > 1 || (files_linking_to_anchor.length === 1 || typeof files_linking_to_anchor.length === "object" && ρσ_equals(files_linking_to_anchor.length, 1)) && files_linking_to_anchor[0] !== src_name) {
                    cb = get_containing_block(a);
                    if (!cb || ρσ_equals(cb.tagName.toLowerCase(), "body")) {
                        return false;
                    }
                    ltext = a.textContent;
                    if (!ltext) {
                        return false;
                    }
                    ctext = cb.textContent;
                    if (!ctext) {
                        return false;
                    }
                    if (ctext.strip() === ltext.strip()) {
                        return false;
                    }
                    return true;
                }
            }
            return false;
        };
        if (!is_footnote_link.__argnames__) Object.defineProperties(is_footnote_link, {
            __argnames__ : {value: ["a", "dest_name", "dest_frag", "src_name", "link_to_map"]},
            __module__ : {value: "read_book.footnotes"}
        });

        is_footnote_link.inline_displays = (function(){
            var ρσ_d = Object.create(null);
            ρσ_d["inline"] = true;
            ρσ_d["inline-block"] = true;
            return ρσ_d;
        }).call(this);
        is_footnote_link.vert_aligns = (function(){
            var ρσ_d = Object.create(null);
            ρσ_d["sub"] = true;
            ρσ_d["super"] = true;
            ρσ_d["top"] = true;
            ρσ_d["bottom"] = true;
            return ρσ_d;
        }).call(this);
        function is_epub_footnote(node) {
            var et, roles;
            et = epub_type(node);
            if (et) {
                et = et.toLowerCase();
                if (et === "note" || et === "footnote" || et === "rearnote") {
                    return true;
                }
            }
            roles = elem_roles(node);
            if (roles["doc-note"] || roles["doc-footnote"] || roles["doc-rearnote"]) {
                return true;
            }
            return false;
        };
        if (!is_epub_footnote.__argnames__) Object.defineProperties(is_epub_footnote, {
            __argnames__ : {value: ["node"]},
            __module__ : {value: "read_book.footnotes"}
        });

        function get_note_container(node) {
            while (node && block_names[ρσ_bound_index(node.tagName.toLowerCase(), block_names)] !== true && block_display_styles[ρσ_bound_index(window.getComputedStyle(node).display, block_display_styles)] !== true) {
                node = node.parentNode;
            }
            return node;
        };
        if (!get_note_container.__argnames__) Object.defineProperties(get_note_container, {
            __argnames__ : {value: ["node"]},
            __module__ : {value: "read_book.footnotes"}
        });

        function get_parents_and_self(node) {
            var ans;
            ans = [];
            while (node && node !== document.body) {
                ans.push(node);
                node = node.parentNode;
            }
            return ans;
        };
        if (!get_parents_and_self.__argnames__) Object.defineProperties(get_parents_and_self, {
            __argnames__ : {value: ["node"]},
            __module__ : {value: "read_book.footnotes"}
        });

        function get_page_break(node) {
            var style;
            style = window.getComputedStyle(node);
            return (function(){
                var ρσ_d = Object.create(null);
                ρσ_d["before"] = (ρσ_expr_temp = get_page_break.on)[ρσ_bound_index(style.getPropertyValue("page-break-before"), ρσ_expr_temp)] === true;
                ρσ_d["after"] = (ρσ_expr_temp = get_page_break.on)[ρσ_bound_index(style.getPropertyValue("page-break-after"), ρσ_expr_temp)] === true;
                return ρσ_d;
            }).call(this);
        };
        if (!get_page_break.__argnames__) Object.defineProperties(get_page_break, {
            __argnames__ : {value: ["node"]},
            __module__ : {value: "read_book.footnotes"}
        });

        get_page_break.on = (function(){
            var ρσ_d = Object.create(null);
            ρσ_d["always"] = true;
            ρσ_d["left"] = true;
            ρσ_d["right"] = true;
            return ρσ_d;
        }).call(this);
        function hide_children(node) {
            var child;
            var ρσ_Iter1 = ρσ_Iterable(node.childNodes);
            for (var ρσ_Index1 = 0; ρσ_Index1 < ρσ_Iter1.length; ρσ_Index1++) {
                child = ρσ_Iter1[ρσ_Index1];
                if (child.nodeType === Node.ELEMENT_NODE) {
                    if (child.do_not_hide) {
                        hide_children(child);
                        delete child.do_not_hide;
                    } else {
                        child.style.display = "none";
                    }
                }
            }
        };
        if (!hide_children.__argnames__) Object.defineProperties(hide_children, {
            __argnames__ : {value: ["node"]},
            __module__ : {value: "read_book.footnotes"}
        });

        function unhide_tree(elem) {
            var c;
            elem.do_not_hide = true;
            var ρσ_Iter2 = ρσ_Iterable(elem.getElementsByTagName("*"));
            for (var ρσ_Index2 = 0; ρσ_Index2 < ρσ_Iter2.length; ρσ_Index2++) {
                c = ρσ_Iter2[ρσ_Index2];
                c.do_not_hide = true;
            }
        };
        if (!unhide_tree.__argnames__) Object.defineProperties(unhide_tree, {
            __argnames__ : {value: ["elem"]},
            __module__ : {value: "read_book.footnotes"}
        });

        ok_list_types = (function(){
            var ρσ_d = Object.create(null);
            ρσ_d["disc"] = true;
            ρσ_d["circle"] = true;
            ρσ_d["square"] = true;
            return ρσ_d;
        }).call(this);
        function is_new_footnote_start(elem, start_elem) {
            var c;
            c = get_note_container(elem);
            return c !== start_elem && c !== start_elem.firstElementChild;
        };
        if (!is_new_footnote_start.__argnames__) Object.defineProperties(is_new_footnote_start, {
            __argnames__ : {value: ["elem", "start_elem"]},
            __module__ : {value: "read_book.footnotes"}
        });

        function show_footnote(target, known_anchors) {
            var start_elem, style, elem, found_note_start, eid, pb;
            if (!target) {
                return;
            }
            start_elem = document.getElementById(target);
            if (!start_elem) {
                return;
            }
            start_elem = get_note_container(start_elem);
            var ρσ_Iter3 = ρσ_Iterable(get_parents_and_self(start_elem));
            for (var ρσ_Index3 = 0; ρσ_Index3 < ρσ_Iter3.length; ρσ_Index3++) {
                elem = ρσ_Iter3[ρσ_Index3];
                elem.do_not_hide = true;
                style = window.getComputedStyle(elem);
                if (style.display === "list-item" && ok_list_types[ρσ_bound_index(style.listStyleType, ok_list_types)] !== true) {
                    elem.style.listStyleType = "none";
                }
            }
            if (is_epub_footnote(start_elem)) {
                unhide_tree(start_elem);
            } else {
                found_note_start = false;
                var ρσ_Iter4 = ρσ_Iterable(document.documentElement.getElementsByTagName("*"));
                for (var ρσ_Index4 = 0; ρσ_Index4 < ρσ_Iter4.length; ρσ_Index4++) {
                    elem = ρσ_Iter4[ρσ_Index4];
                    if (found_note_start) {
                        eid = elem.getAttribute("id");
                        if (eid !== target && known_anchors[(typeof eid === "number" && eid < 0) ? known_anchors.length + eid : eid] && is_new_footnote_start(elem, start_elem)) {
                            delete get_note_container(elem).do_not_hide;
                            break;
                        }
                        pb = get_page_break(elem);
                        if (pb.before) {
                            break;
                        }
                        if (pb.after) {
                            unhide_tree(elem);
                            break;
                        }
                        elem.do_not_hide = true;
                    } else if (elem === start_elem) {
                        found_note_start = true;
                    }
                }
            }
            hide_children(document.body);
            window.location.hash = "#" + target;
        };
        if (!show_footnote.__argnames__) Object.defineProperties(show_footnote, {
            __argnames__ : {value: ["target", "known_anchors"]},
            __module__ : {value: "read_book.footnotes"}
        });

        function PopupIframeBoss() {
            if (this.ρσ_object_id === undefined) Object.defineProperty(this, "ρσ_object_id", {"value":++ρσ_object_counter});
            PopupIframeBoss.prototype.__bind_methods__.call(this);
            PopupIframeBoss.prototype.__init__.apply(this, arguments);
        }
        Object.defineProperty(PopupIframeBoss.prototype, "__bind_methods__", {value: function () {
            this.initialize = PopupIframeBoss.prototype.initialize.bind(this);
            this.on_error = PopupIframeBoss.prototype.on_error.bind(this);
            this.display = PopupIframeBoss.prototype.display.bind(this);
            this.connect_links = PopupIframeBoss.prototype.connect_links.bind(this);
            this.link_activated = PopupIframeBoss.prototype.link_activated.bind(this);
            this.activate_link = PopupIframeBoss.prototype.activate_link.bind(this);
            this.on_clear = PopupIframeBoss.prototype.on_clear.bind(this);
            this.show_only_footnote = PopupIframeBoss.prototype.show_only_footnote.bind(this);
            this.content_loaded = PopupIframeBoss.prototype.content_loaded.bind(this);
        }});
        PopupIframeBoss.prototype.__init__ = function __init__() {
            var self = this;
            var handlers;
            handlers = (function(){
                var ρσ_d = Object.create(null);
                ρσ_d["initialize"] = self.initialize;
                ρσ_d["clear"] = self.on_clear;
                ρσ_d["display"] = self.display;
                return ρσ_d;
            }).call(this);
            self.comm = new IframeClient(handlers, "popup-iframe");
            self.blob_url_map = Object.create(null);
            self.name = null;
            self.frag = null;
            self.link_attr = null;
        };
        if (!PopupIframeBoss.prototype.__init__.__module__) Object.defineProperties(PopupIframeBoss.prototype.__init__, {
            __module__ : {value: "read_book.footnotes"}
        });
        PopupIframeBoss.__argnames__ = PopupIframeBoss.prototype.__init__.__argnames__;
        PopupIframeBoss.__handles_kwarg_interpolation__ = PopupIframeBoss.prototype.__init__.__handles_kwarg_interpolation__;
        PopupIframeBoss.prototype.initialize = function initialize(data) {
            var self = this;
            window.addEventListener("error", self.on_error);
        };
        if (!PopupIframeBoss.prototype.initialize.__argnames__) Object.defineProperties(PopupIframeBoss.prototype.initialize, {
            __argnames__ : {value: ["data"]},
            __module__ : {value: "read_book.footnotes"}
        });
        PopupIframeBoss.prototype.on_error = function on_error(evt) {
            var self = this;
            var msg, script_url, line_number, column_number, error_object;
            msg = evt.message;
            script_url = evt.filename;
            line_number = evt.lineno;
            column_number = evt.colno;
            error_object = evt.error;
            [evt.stopPropagation(), evt.preventDefault()];
            if (error_object === null) {
                console.log("Unhandled error from external javascript, ignoring: " + ρσ_str.format("{}", msg) + " " + ρσ_str.format("{}", script_url) + " " + ρσ_str.format("{}", line_number) + ":" + ρσ_str.format("{}", column_number) + "");
            } else {
                console.log(error_object);
            }
        };
        if (!PopupIframeBoss.prototype.on_error.__argnames__) Object.defineProperties(PopupIframeBoss.prototype.on_error, {
            __argnames__ : {value: ["evt"]},
            __module__ : {value: "read_book.footnotes"}
        });
        PopupIframeBoss.prototype.display = function display(data) {
            var self = this;
            var spine, index, name, ρσ_unpack, root_data;
            self.book = data.book;
            self.name = data.name;
            self.frag = data.frag;
            self.link_attr = "data-" + self.book.manifest.link_uid;
            spine = self.book.manifest.spine;
            index = spine.indexOf(data.name);
            set_current_spine_item((function(){
                var ρσ_d = Object.create(null);
                ρσ_d["name"] = data.name;
                ρσ_d["is_first"] = index === 0;
                ρσ_d["is_last"] = index === spine.length - 1;
                ρσ_d["index"] = index;
                ρσ_d["initial_position"] = data.initial_position;
                return ρσ_d;
            }).call(this));
            update_settings(data.settings);
            var ρσ_Iter5 = ρσ_Iterable(self.blob_url_map);
            for (var ρσ_Index5 = 0; ρσ_Index5 < ρσ_Iter5.length; ρσ_Index5++) {
                name = ρσ_Iter5[ρσ_Index5];
                window.URL.revokeObjectURL((ρσ_expr_temp = self.blob_url_map)[(typeof name === "number" && name < 0) ? ρσ_expr_temp.length + name : name]);
            }
            document.body.style.removeProperty("font-family");
            ρσ_unpack = finalize_resources(self.book, data.name, data.resource_data);
ρσ_unpack = ρσ_unpack_asarray(3, ρσ_unpack);
            root_data = ρσ_unpack[0];
            self.mathjax = ρσ_unpack[1];
            self.blob_url_map = ρσ_unpack[2];
            self.resource_urls = unserialize_html(root_data, self.content_loaded, self.show_only_footnote, data.name);
        };
        if (!PopupIframeBoss.prototype.display.__argnames__) Object.defineProperties(PopupIframeBoss.prototype.display, {
            __argnames__ : {value: ["data"]},
            __module__ : {value: "read_book.footnotes"}
        });
        PopupIframeBoss.prototype.connect_links = function connect_links() {
            var self = this;
            var a;
            var ρσ_Iter6 = ρσ_Iterable(document.body.querySelectorAll("a[" + ρσ_str.format("{}", self.link_attr) + "]"));
            for (var ρσ_Index6 = 0; ρσ_Index6 < ρσ_Iter6.length; ρσ_Index6++) {
                a = ρσ_Iter6[ρσ_Index6];
                a.addEventListener("click", self.link_activated);
            }
            if (runtime.is_standalone_viewer) {
                var ρσ_Iter7 = ρσ_Iterable(document.body.querySelectorAll("a[target]"));
                for (var ρσ_Index7 = 0; ρσ_Index7 < ρσ_Iter7.length; ρσ_Index7++) {
                    a = ρσ_Iter7[ρσ_Index7];
                    a.removeAttribute("target");
                }
            }
        };
        if (!PopupIframeBoss.prototype.connect_links.__module__) Object.defineProperties(PopupIframeBoss.prototype.connect_links, {
            __module__ : {value: "read_book.footnotes"}
        });
        PopupIframeBoss.prototype.link_activated = function link_activated(evt) {
            var self = this;
            var data;
            try {
                data = JSON.parse(evt.currentTarget.getAttribute(self.link_attr));
            } catch (ρσ_Exception) {
                ρσ_last_exception = ρσ_Exception;
                {
                    print("WARNING: Failed to parse link data {}, ignoring".format(ρσ_exists.c(ρσ_exists.d(evt.currentTarget).getAttribute)(self.link_attr)));
                    return;
                } 
            }
            self.activate_link(data.name, data.frag, evt.currentTarget);
        };
        if (!PopupIframeBoss.prototype.link_activated.__argnames__) Object.defineProperties(PopupIframeBoss.prototype.link_activated, {
            __argnames__ : {value: ["evt"]},
            __module__ : {value: "read_book.footnotes"}
        });
        PopupIframeBoss.prototype.activate_link = function activate_link(name, frag, target_elem) {
            var self = this;
            var is_popup, title;
            if (!name) {
                name = current_spine_item().name;
            }
            try {
                is_popup = is_footnote_link(target_elem, name, frag, current_spine_item().name, self.book.manifest.link_to_map || Object.create(null));
                title = target_elem.textContent;
            } catch (ρσ_Exception) {
                ρσ_last_exception = ρσ_Exception;
                {
                    var traceback = ρσ_modules.traceback;

                    traceback.print_exc();
                    is_popup = false;
                    title = "";
                } 
            }
            ρσ_interpolate_kwargs.call(self.comm, self.comm.send_message, ["link_activated"].concat([ρσ_desugar_kwargs({is_popup: is_popup, name: name, frag: frag, title: title})]));
        };
        if (!PopupIframeBoss.prototype.activate_link.__argnames__) Object.defineProperties(PopupIframeBoss.prototype.activate_link, {
            __argnames__ : {value: ["name", "frag", "target_elem"]},
            __module__ : {value: "read_book.footnotes"}
        });
        PopupIframeBoss.prototype.on_clear = function on_clear(data) {
            var self = this;
            clear(document.head);
            clear(document.body);
            document.body.textContent = data.text;
            self.name = null;
            self.frag = null;
        };
        if (!PopupIframeBoss.prototype.on_clear.__argnames__) Object.defineProperties(PopupIframeBoss.prototype.on_clear, {
            __argnames__ : {value: ["data"]},
            __module__ : {value: "read_book.footnotes"}
        });
        PopupIframeBoss.prototype.show_only_footnote = function show_only_footnote() {
            var self = this;
            var known_anchors, ltm, k;
            known_anchors = Object.create(null);
            ltm = (ρσ_expr_temp = ρσ_exists.d(self.book.manifest.link_to_map))[ρσ_bound_index(self.name, ρσ_expr_temp)];
            if (ltm) {
                known_anchors = (function() {
                    var ρσ_Iter = ρσ_Iterable(Object.keys(ltm)), ρσ_Result = Object.create(null), k;
                    for (var ρσ_Index = 0; ρσ_Index < ρσ_Iter.length; ρσ_Index++) {
                        k = ρσ_Iter[ρσ_Index];
                        ρσ_Result[k] = (true);
                    }
                    return ρσ_Result;
                })();
            }
            show_footnote(self.frag, known_anchors);
        };
        if (!PopupIframeBoss.prototype.show_only_footnote.__module__) Object.defineProperties(PopupIframeBoss.prototype.show_only_footnote, {
            __module__ : {value: "read_book.footnotes"}
        });
        PopupIframeBoss.prototype.content_loaded = function content_loaded() {
            var self = this;
            if (!self.comm.encrypted_communications) {
                window.setTimeout(self.content_loaded, 2);
                return;
            }
            self.connect_links();
            document.head.removeChild(document.head.firstChild);
            document.body.classList.add("calibre-footnote-container");
            set_color_scheme_class();
            apply_settings(true);
            ρσ_interpolate_kwargs.call(self.comm, self.comm.send_message, ["content_loaded"].concat([ρσ_desugar_kwargs({height: document.documentElement.scrollHeight + 25})]));
        };
        if (!PopupIframeBoss.prototype.content_loaded.__module__) Object.defineProperties(PopupIframeBoss.prototype.content_loaded, {
            __module__ : {value: "read_book.footnotes"}
        });
        PopupIframeBoss.prototype.__repr__ = function __repr__ () {
                        return "<" + __name__ + "." + this.constructor.name + " #" + this.ρσ_object_id + ">";
        };
        PopupIframeBoss.prototype.__str__ = function __str__ () {
            return this.__repr__();
        };
        Object.defineProperty(PopupIframeBoss.prototype, "__bases__", {value: []});

        function main() {
            main.boss = new PopupIframeBoss;
        };
        if (!main.__module__) Object.defineProperties(main, {
            __module__ : {value: "read_book.footnotes"}
        });

        ρσ_modules["read_book.footnotes"].block_names = block_names;
        ρσ_modules["read_book.footnotes"].block_display_styles = block_display_styles;
        ρσ_modules["read_book.footnotes"].ok_list_types = ok_list_types;
        ρσ_modules["read_book.footnotes"].elem_roles = elem_roles;
        ρσ_modules["read_book.footnotes"].epub_type = epub_type;
        ρσ_modules["read_book.footnotes"].get_containing_block = get_containing_block;
        ρσ_modules["read_book.footnotes"].is_footnote_link = is_footnote_link;
        ρσ_modules["read_book.footnotes"].is_epub_footnote = is_epub_footnote;
        ρσ_modules["read_book.footnotes"].get_note_container = get_note_container;
        ρσ_modules["read_book.footnotes"].get_parents_and_self = get_parents_and_self;
        ρσ_modules["read_book.footnotes"].get_page_break = get_page_break;
        ρσ_modules["read_book.footnotes"].hide_children = hide_children;
        ρσ_modules["read_book.footnotes"].unhide_tree = unhide_tree;
        ρσ_modules["read_book.footnotes"].is_new_footnote_start = is_new_footnote_start;
        ρσ_modules["read_book.footnotes"].show_footnote = show_footnote;
        ρσ_modules["read_book.footnotes"].PopupIframeBoss = PopupIframeBoss;
        ρσ_modules["read_book.footnotes"].main = main;
    })();

    (function(){
        var __name__ = "fs_images";
        function is_svg_fs_markup(names, svg) {
            if (svg !== null) {
                if (names.length === 2 || names.length === 3) {
                    if (names[names.length-1] === "image" && names[names.length-2] === "svg") {
                        if (names.length === 2 || names[0] === "div") {
                            if (svg.width === "100%" && svg.height === "100%") {
                                return true;
                            }
                        }
                    }
                }
            }
            return false;
        };
        if (!is_svg_fs_markup.__argnames__) Object.defineProperties(is_svg_fs_markup, {
            __argnames__ : {value: ["names", "svg"]},
            __module__ : {value: "fs_images"}
        });

        function fix_fullscreen_svg_images() {
            var child_names, name, node, names, svg;
            child_names = [];
            var ρσ_Iter0 = ρσ_Iterable(document.body.childNodes);
            for (var ρσ_Index0 = 0; ρσ_Index0 < ρσ_Iter0.length; ρσ_Index0++) {
                node = ρσ_Iter0[ρσ_Index0];
                if (node.tagName) {
                    name = node.tagName.toLowerCase();
                    if (name !== "style" && name !== "script") {
                        child_names.push(name);
                    }
                    if (child_names.length > 1) {
                        break;
                    }
                }
            }
            if (child_names.length === 1 && (child_names[0] === "div" || child_names[0] === "svg")) {
                names = [];
                svg = null;
                var ρσ_Iter1 = ρσ_Iterable(document.body.querySelectorAll("*"));
                for (var ρσ_Index1 = 0; ρσ_Index1 < ρσ_Iter1.length; ρσ_Index1++) {
                    node = ρσ_Iter1[ρσ_Index1];
                    if (node.tagName) {
                        name = node.tagName.toLowerCase();
                        if (name !== "style" && name !== "script") {
                            names.push(name);
                            if (name === "svg") {
                                svg = node;
                            }
                        }
                    }
                }
                if (is_svg_fs_markup(names, svg)) {
                    svg.setAttribute("width", "100vw");
                    svg.setAttribute("height", "100vh");
                }
            }
        };
        if (!fix_fullscreen_svg_images.__module__) Object.defineProperties(fix_fullscreen_svg_images, {
            __module__ : {value: "fs_images"}
        });

        ρσ_modules.fs_images.is_svg_fs_markup = is_svg_fs_markup;
        ρσ_modules.fs_images.fix_fullscreen_svg_images = fix_fullscreen_svg_images;
    })();

    (function(){
        var __name__ = "range_utils";
        var wrapper_counter;
        function is_non_empty_text_node(node) {
            return (node.nodeType === Node.TEXT_NODE || node.nodeType === Node.CDATA_SECTION_NODE) && node.nodeValue.length > 0;
        };
        if (!is_non_empty_text_node.__argnames__) Object.defineProperties(is_non_empty_text_node, {
            __argnames__ : {value: ["node"]},
            __module__ : {value: "range_utils"}
        });

        function text_nodes_in_range(r) {
            var parent, doc, iterator, in_range, ans, node;
            parent = r.commonAncestorContainer;
            doc = parent.ownerDocument || document;
            iterator = doc.createNodeIterator(parent);
            in_range = false;
            ans = [];
            while (true) {
                node = iterator.nextNode();
                if (!node) {
                    break;
                }
                if (!in_range && node.isSameNode(r.startContainer)) {
                    in_range = true;
                }
                if (in_range) {
                    if (is_non_empty_text_node(node)) {
                        ans.push(node);
                    }
                    if (node.isSameNode(r.endContainer)) {
                        break;
                    }
                }
            }
            return ans;
        };
        if (!text_nodes_in_range.__argnames__) Object.defineProperties(text_nodes_in_range, {
            __argnames__ : {value: ["r"]},
            __module__ : {value: "range_utils"}
        });

        function all_annots_in_range(r, annot_id_uuid_map, ans) {
            var parent, doc, iterator, is_full_tree, in_range, node, annot_id;
            parent = r.commonAncestorContainer;
            doc = parent.ownerDocument || document;
            iterator = doc.createNodeIterator(parent);
            is_full_tree = parent === doc.documentElement;
            in_range = is_full_tree;
            while (true) {
                node = iterator.nextNode();
                if (!node) {
                    break;
                }
                if (!in_range && node.isSameNode(r.startContainer)) {
                    in_range = true;
                }
                if (in_range) {
                    if (node.dataset && node.dataset.calibreRangeWrapper) {
                        annot_id = annot_id_uuid_map[ρσ_bound_index(node.dataset.calibreRangeWrapper, annot_id_uuid_map)];
                        if (annot_id) {
                            if (!ans) {
                                return annot_id;
                            }
                            ans[(typeof annot_id === "number" && annot_id < 0) ? ans.length + annot_id : annot_id] = true;
                        }
                    }
                    if (!is_full_tree && node.isSameNode(r.endContainer)) {
                        break;
                    }
                }
            }
            return ans;
        };
        if (!all_annots_in_range.__argnames__) Object.defineProperties(all_annots_in_range, {
            __argnames__ : {value: ["r", "annot_id_uuid_map", "ans"]},
            __module__ : {value: "range_utils"}
        });

        function first_annot_in_range(r, annot_id_uuid_map) {
            return all_annots_in_range(r, annot_id_uuid_map);
        };
        if (!first_annot_in_range.__argnames__) Object.defineProperties(first_annot_in_range, {
            __argnames__ : {value: ["r", "annot_id_uuid_map"]},
            __module__ : {value: "range_utils"}
        });

        function all_annots_in_selection(sel, annot_id_uuid_map) {
            var ans, i;
            ans = {};
            for (var ρσ_Index0 = 0; ρσ_Index0 < sel.rangeCount; ρσ_Index0++) {
                i = ρσ_Index0;
                all_annots_in_range(sel.getRangeAt(i), annot_id_uuid_map, ans);
            }
            return Object.keys(ans);
        };
        if (!all_annots_in_selection.__argnames__) Object.defineProperties(all_annots_in_selection, {
            __argnames__ : {value: ["sel", "annot_id_uuid_map"]},
            __module__ : {value: "range_utils"}
        });

        function remove(node) {
            if (node.parentNode) {
                node.parentNode.removeChild(node);
            }
        };
        if (!remove.__argnames__) Object.defineProperties(remove, {
            __argnames__ : {value: ["node"]},
            __module__ : {value: "range_utils"}
        });

        function replace_node(replacement, node) {
            var p;
            p = node.parentNode;
            p.insertBefore(replacement, node);
            remove(node);
            return p;
        };
        if (!replace_node.__argnames__) Object.defineProperties(replace_node, {
            __argnames__ : {value: ["replacement", "node"]},
            __module__ : {value: "range_utils"}
        });

        function unwrap(node) {
            var r, p;
            r = (node.ownerDocument || document).createRange();
            r.selectNodeContents(node);
            p = replace_node(r.extractContents(), node);
            if (p) {
                p.normalize();
            }
        };
        if (!unwrap.__argnames__) Object.defineProperties(unwrap, {
            __argnames__ : {value: ["node"]},
            __module__ : {value: "range_utils"}
        });

        function unwrap_crw(crw) {
            var node;
            var ρσ_Iter1 = ρσ_Iterable(document.querySelectorAll("span[data-calibre-range-wrapper=\"" + ρσ_str.format("{}", crw) + "\"]"));
            for (var ρσ_Index1 = 0; ρσ_Index1 < ρσ_Iter1.length; ρσ_Index1++) {
                node = ρσ_Iter1[ρσ_Index1];
                unwrap(node);
            }
        };
        if (!unwrap_crw.__argnames__) Object.defineProperties(unwrap_crw, {
            __argnames__ : {value: ["crw"]},
            __module__ : {value: "range_utils"}
        });

        function unwrap_all_crw() {
            var node;
            var ρσ_Iter2 = ρσ_Iterable(document.querySelectorAll("span[data-calibre-range-wrapper]"));
            for (var ρσ_Index2 = 0; ρσ_Index2 < ρσ_Iter2.length; ρσ_Index2++) {
                node = ρσ_Iter2[ρσ_Index2];
                unwrap(node);
            }
        };
        if (!unwrap_all_crw.__module__) Object.defineProperties(unwrap_all_crw, {
            __module__ : {value: "range_utils"}
        });

        function select_crw(crw) {
            var nodes, r, sel;
            nodes = document.querySelectorAll("span[data-calibre-range-wrapper=\"" + ρσ_str.format("{}", crw) + "\"]");
            if (nodes && nodes.length) {
                r = document.createRange();
                r.setStart(nodes[0].firstChild, 0);
                r.setEnd(nodes[nodes.length-1].lastChild, nodes[nodes.length-1].lastChild.nodeValue.length);
                sel = window.getSelection();
                sel.removeAllRanges();
                sel.addRange(r);
                return true;
            } else {
                print("range-wrapper: " + ρσ_str.format("{}", crw) + " does not exist");
            }
            return false;
        };
        if (!select_crw.__argnames__) Object.defineProperties(select_crw, {
            __argnames__ : {value: ["crw"]},
            __module__ : {value: "range_utils"}
        });

        function wrap_range(r, wrapper) {
            try {
                r.surroundContents(wrapper);
            } catch (ρσ_Exception) {
                ρσ_last_exception = ρσ_Exception;
                {
                    wrapper.appendChild(r.extractContents());
                    r.insertNode(wrapper);
                } 
            }
        };
        if (!wrap_range.__argnames__) Object.defineProperties(wrap_range, {
            __argnames__ : {value: ["r", "wrapper"]},
            __module__ : {value: "range_utils"}
        });

        function create_wrapper_function(wrapper_elem, r, intersecting_wrappers, process_wrapper, all_wrappers) {
            var start_node, end_node, start_offset, end_offset;
            start_node = r.startContainer;
            end_node = r.endContainer;
            start_offset = r.startOffset;
            end_offset = r.endOffset;
            function wrap_node(node) {
                var current_range, current_wrapper, crw;
                current_range = (node.ownerDocument || document).createRange();
                current_wrapper = wrapper_elem.cloneNode();
                current_range.selectNodeContents(node);
                if (node.isSameNode(start_node)) {
                    current_range.setStart(node, start_offset);
                    start_node = current_wrapper;
                    start_offset = 0;
                }
                if (node.isSameNode(end_node)) {
                    current_range.setEnd(node, end_offset);
                    end_node = current_wrapper;
                    end_offset = 1;
                }
                if (current_range.collapsed) {
                    return;
                }
                crw = ρσ_exists.d(ρσ_exists.d(node.parentNode).dataset).calibreRangeWrapper;
                if (crw) {
                    intersecting_wrappers[(typeof crw === "number" && crw < 0) ? intersecting_wrappers.length + crw : crw] = true;
                }
                wrap_range(current_range, current_wrapper);
                if (process_wrapper) {
                    process_wrapper(current_wrapper);
                }
                all_wrappers.push(current_wrapper);
            };
            if (!wrap_node.__argnames__) Object.defineProperties(wrap_node, {
                __argnames__ : {value: ["node"]},
                __module__ : {value: "range_utils"}
            });

            return wrap_node;
        };
        if (!create_wrapper_function.__argnames__) Object.defineProperties(create_wrapper_function, {
            __argnames__ : {value: ["wrapper_elem", "r", "intersecting_wrappers", "process_wrapper", "all_wrappers"]},
            __module__ : {value: "range_utils"}
        });

        wrapper_counter = 0;
        function wrap_text_in_range(styler, r, class_to_add_to_last, process_wrapper) {
            var sel, wrapper_elem, intersecting_wrappers, all_wrappers, wrap_node, ancestor, crw;
            if (!r) {
                sel = window.getSelection();
                if (!sel || !sel.rangeCount) {
                    return [null, []];
                }
                r = sel.getRangeAt(0);
            }
            if (r.isCollapsed) {
                return [null, []];
            }
            wrapper_elem = document.createElement("span");
            wrapper_elem.dataset.calibreRangeWrapper = ++wrapper_counter + "";
            if (styler) {
                styler(wrapper_elem);
            }
            intersecting_wrappers = Object.create(null);
            all_wrappers = [];
            wrap_node = create_wrapper_function(wrapper_elem, r, intersecting_wrappers, process_wrapper, all_wrappers);
            text_nodes_in_range(r).map(wrap_node);
            ancestor = r.commonAncestorContainer;
            if (ancestor.nodeType === Node.TEXT_NODE) {
                ancestor = ancestor.parentNode;
            }
            ancestor.normalize();
            crw = wrapper_elem.dataset.calibreRangeWrapper;
            delete intersecting_wrappers[crw];
            if (class_to_add_to_last && all_wrappers.length) {
                all_wrappers[all_wrappers.length-1].classList.add(class_to_add_to_last);
            }
            return [crw, Object.keys(intersecting_wrappers)];
        };
        if (!wrap_text_in_range.__argnames__) Object.defineProperties(wrap_text_in_range, {
            __argnames__ : {value: ["styler", "r", "class_to_add_to_last", "process_wrapper"]},
            __module__ : {value: "range_utils"}
        });

        function last_span_for_crw(crw) {
            var nodes;
            nodes = document.querySelectorAll("span[data-calibre-range-wrapper=\"" + ρσ_str.format("{}", crw) + "\"]");
            if (nodes && nodes.length) {
                return nodes[nodes.length-1];
            }
        };
        if (!last_span_for_crw.__argnames__) Object.defineProperties(last_span_for_crw, {
            __argnames__ : {value: ["crw"]},
            __module__ : {value: "range_utils"}
        });

        function reset_highlight_counter() {
            wrapper_counter = 0;
        };
        if (!reset_highlight_counter.__module__) Object.defineProperties(reset_highlight_counter, {
            __module__ : {value: "range_utils"}
        });

        function get_annot_id_for(node, offset, annot_id_uuid_map) {
            if (!node) {
                return;
            }
            if (node.nodeType === Node.ELEMENT_NODE) {
                if (node.dataset.calibreRangeWrapper) {
                    return annot_id_uuid_map[ρσ_bound_index(node.dataset.calibreRangeWrapper, annot_id_uuid_map)];
                }
                if (offset === 0) {
                    if (ρσ_exists.d(node.firstChild).nodeType === Node.ELEMENT_NODE && node.firstChild.dataset.calibreRangeWrapper) {
                        return annot_id_uuid_map[ρσ_bound_index(node.firstChild.dataset.calibreRangeWrapper, annot_id_uuid_map)];
                    }
                } else if (offset < node.childNodes.length) {
                    node = (ρσ_expr_temp = node.childNodes)[(typeof offset === "number" && offset < 0) ? ρσ_expr_temp.length + offset : offset];
                    return get_annot_id_for(node, 0, annot_id_uuid_map);
                }
            } else if (node.nodeType === Node.TEXT_NODE) {
                if (ρσ_exists.d(node.parentNode).nodeType === Node.ELEMENT_NODE && node.parentNode.dataset.calibreRangeWrapper) {
                    return annot_id_uuid_map[ρσ_bound_index(node.parentNode.dataset.calibreRangeWrapper, annot_id_uuid_map)];
                }
            }
        };
        if (!get_annot_id_for.__argnames__) Object.defineProperties(get_annot_id_for, {
            __argnames__ : {value: ["node", "offset", "annot_id_uuid_map"]},
            __module__ : {value: "range_utils"}
        });

        function highlight_associated_with_selection(sel, annot_id_uuid_map) {
            var annot_id, r;
            if (sel.rangeCount) {
                annot_id = get_annot_id_for(sel.focusNode, sel.focusOffset, annot_id_uuid_map) || get_annot_id_for(sel.anchorNode, sel.anchorOffset, annot_id_uuid_map);
                if (annot_id) {
                    return annot_id;
                }
                for (var i = 0; i < sel.rangeCount; i++) {
                    r = sel.getRangeAt(i);
                    annot_id = first_annot_in_range(r, annot_id_uuid_map);
                    if (annot_id) {
                        return annot_id;
                    }
                }
            }
        };
        if (!highlight_associated_with_selection.__argnames__) Object.defineProperties(highlight_associated_with_selection, {
            __argnames__ : {value: ["sel", "annot_id_uuid_map"]},
            __module__ : {value: "range_utils"}
        });

        ρσ_modules.range_utils.wrapper_counter = wrapper_counter;
        ρσ_modules.range_utils.is_non_empty_text_node = is_non_empty_text_node;
        ρσ_modules.range_utils.text_nodes_in_range = text_nodes_in_range;
        ρσ_modules.range_utils.all_annots_in_range = all_annots_in_range;
        ρσ_modules.range_utils.first_annot_in_range = first_annot_in_range;
        ρσ_modules.range_utils.all_annots_in_selection = all_annots_in_selection;
        ρσ_modules.range_utils.remove = remove;
        ρσ_modules.range_utils.replace_node = replace_node;
        ρσ_modules.range_utils.unwrap = unwrap;
        ρσ_modules.range_utils.unwrap_crw = unwrap_crw;
        ρσ_modules.range_utils.unwrap_all_crw = unwrap_all_crw;
        ρσ_modules.range_utils.select_crw = select_crw;
        ρσ_modules.range_utils.wrap_range = wrap_range;
        ρσ_modules.range_utils.create_wrapper_function = create_wrapper_function;
        ρσ_modules.range_utils.wrap_text_in_range = wrap_text_in_range;
        ρσ_modules.range_utils.last_span_for_crw = last_span_for_crw;
        ρσ_modules.range_utils.reset_highlight_counter = reset_highlight_counter;
        ρσ_modules.range_utils.get_annot_id_for = get_annot_id_for;
        ρσ_modules.range_utils.highlight_associated_with_selection = highlight_associated_with_selection;
    })();

    (function(){
        var __name__ = "read_book.extract";
        var annot_id_uuid_map = ρσ_modules["read_book.globals"].annot_id_uuid_map;

        function get_elements(x, y) {
            var ans, tl, annot_id, elem;
            ans = (function(){
                var ρσ_d = Object.create(null);
                ρσ_d["link"] = null;
                ρσ_d["img"] = null;
                ρσ_d["highlight"] = null;
                ρσ_d["crw"] = null;
                return ρσ_d;
            }).call(this);
            var ρσ_Iter0 = ρσ_Iterable(document.elementsFromPoint(x, y));
            for (var ρσ_Index0 = 0; ρσ_Index0 < ρσ_Iter0.length; ρσ_Index0++) {
                elem = ρσ_Iter0[ρσ_Index0];
                tl = elem.tagName.toLowerCase();
                if (tl === "a" && elem.getAttribute("href") && !ans.link) {
                    ans.link = elem.getAttribute("href");
                } else if ((tl === "img" || tl === "image") && elem.getAttribute("data-calibre-src") && !ans.img) {
                    ans.img = elem.getAttribute("data-calibre-src");
                } else if (ρσ_exists.d(elem.dataset).calibreRangeWrapper) {
                    ans.crw = elem.dataset.calibreRangeWrapper;
                    annot_id = annot_id_uuid_map[ρσ_bound_index(ans.crw, annot_id_uuid_map)];
                    if (annot_id) {
                        ans.highlight = annot_id;
                    }
                }
            }
            return ans;
        };
        if (!get_elements.__argnames__) Object.defineProperties(get_elements, {
            __argnames__ : {value: ["x", "y"]},
            __module__ : {value: "read_book.extract"}
        });

        ρσ_modules["read_book.extract"].get_elements = get_elements;
    })();

    (function(){
        var __name__ = "read_book.find";
        var cache;
        function build_text_map() {
            var node_list, flat_text, ignored_tags, text_node_type, element_node_type;
            node_list = [];
            flat_text = "";
            ignored_tags = (function(){
                var ρσ_d = Object.create(null);
                ρσ_d["style"] = true;
                ρσ_d["script"] = true;
                ρσ_d["noscript"] = true;
                ρσ_d["title"] = true;
                ρσ_d["meta"] = true;
                ρσ_d["head"] = true;
                ρσ_d["link"] = true;
                ρσ_d["html"] = true;
                ρσ_d["img"] = true;
                return ρσ_d;
            }).call(this);
            text_node_type = Node.TEXT_NODE;
            element_node_type = Node.ELEMENT_NODE;
            function process_node(node) {
                var nt, text, tag, style, children, i;
                nt = node.nodeType;
                if (nt === text_node_type) {
                    text = node.nodeValue;
                    if (text && text.length) {
                        node_list.push({node: node, offset: flat_text.length, length: text.length});
                        flat_text += text;
                    }
                } else if (nt === element_node_type) {
                    if (!node.hasChildNodes()) {
                        return;
                    }
                    tag = node.tagName.toLowerCase();
                    if (ignored_tags[(typeof tag === "number" && tag < 0) ? ignored_tags.length + tag : tag]) {
                        return;
                    }
                    style = window.getComputedStyle(node);
                    if (style.display === "none" || style.visibility === "hidden") {
                        return;
                    }
                    children = node.childNodes;
                    for (var ρσ_Index0 = 0; ρσ_Index0 < children.length; ρσ_Index0++) {
                        i = ρσ_Index0;
                        process_node(children[i]);
                    }
                }
            };
            if (!process_node.__argnames__) Object.defineProperties(process_node, {
                __argnames__ : {value: ["node"]},
                __module__ : {value: "read_book.find"}
            });

            process_node(document.body);
            return (function(){
                var ρσ_d = Object.create(null);
                ρσ_d["timestamp"] = window.performance.now();
                ρσ_d["flat_text"] = flat_text;
                ρσ_d["node_list"] = node_list;
                return ρσ_d;
            }).call(this);
        };
        if (!build_text_map.__module__) Object.defineProperties(build_text_map, {
            __module__ : {value: "read_book.find"}
        });

        function index_for_node(node, node_list) {
            var entry;
            var ρσ_Iter1 = ρσ_Iterable(node_list);
            for (var ρσ_Index1 = 0; ρσ_Index1 < ρσ_Iter1.length; ρσ_Index1++) {
                entry = ρσ_Iter1[ρσ_Index1];
                if (entry.node.isSameNode(node)) {
                    return entry.offset;
                }
            }
        };
        if (!index_for_node.__argnames__) Object.defineProperties(index_for_node, {
            __argnames__ : {value: ["node", "node_list"]},
            __module__ : {value: "read_book.find"}
        });

        function tts_word_regex() {
            return /[\p{Letter}\p{Mark}\p{Number}\p{Punctuation}\p{Cf}]{1,50}/gu;
        };
        if (!tts_word_regex.__module__) Object.defineProperties(tts_word_regex, {
            __module__ : {value: "read_book.find"}
        });

        function tts_data(text_node, offset) {
            var offset_in_flat_text, match, first, last, marked_text, text, start, trailer;
            offset_in_flat_text = offset || 0;
            if (!cache.text_map) {
                cache.text_map = build_text_map();
            }
            if (text_node) {
                offset_in_flat_text += index_for_node(text_node, cache.text_map.node_list) || 0;
            }
            match = null;
            first = true;
            last = null;
            marked_text = [];
            text = cache.text_map.flat_text.slice(offset_in_flat_text);
            for (match of text.matchAll(tts_word_regex())) {
                start = match.index;
                if (first) {
                    first = false;
                    if (start) {
                        marked_text.push(text.slice(0, start));
                    }
                } else if (start > last) {
                    marked_text.push(text.slice(last, start));
                }
                marked_text.push(start + offset_in_flat_text);
                marked_text.push(match[0]);
                last = start + match[0].length;
            }
            if (last === null) {
                marked_text.push(text);
            } else {
                trailer = text.slice(last);
                if (trailer) {
                    marked_text.push(trailer);
                }
            }
            return marked_text;
        };
        if (!tts_data.__argnames__) Object.defineProperties(tts_data, {
            __argnames__ : {value: ["text_node", "offset"]},
            __module__ : {value: "read_book.find"}
        });

        function find_node_for_index_binary(node_list, idx_in_flat_text, start) {
            var end, mid, q, limit, start_node, start_offset;
            start = start || 0;
            end = node_list.length - 1;
            while (start <= end) {
                mid = Math.floor((start + end) / 2);
                q = node_list[(typeof mid === "number" && mid < 0) ? node_list.length + mid : mid];
                limit = q.offset + q.length;
                if (q.offset <= idx_in_flat_text && limit > idx_in_flat_text) {
                    start_node = q.node;
                    start_offset = idx_in_flat_text - q.offset;
                    return [start_node, start_offset, mid];
                }
                if (limit <= idx_in_flat_text) {
                    start = mid + 1;
                } else {
                    end = mid - 1;
                }
            }
            return [null, null, null];
        };
        if (!find_node_for_index_binary.__argnames__) Object.defineProperties(find_node_for_index_binary, {
            __argnames__ : {value: ["node_list", "idx_in_flat_text", "start"]},
            __module__ : {value: "read_book.find"}
        });

        function get_occurrence_data(node_list, start, end) {
            var ρσ_unpack, start_node, start_offset, start_pos, end_node, end_offset, node_pos;
            ρσ_unpack = find_node_for_index_binary(node_list, start);
ρσ_unpack = ρσ_unpack_asarray(3, ρσ_unpack);
            start_node = ρσ_unpack[0];
            start_offset = ρσ_unpack[1];
            start_pos = ρσ_unpack[2];
            if (start_node !== null) {
                ρσ_unpack = find_node_for_index_binary(node_list, end, start_pos);
ρσ_unpack = ρσ_unpack_asarray(3, ρσ_unpack);
                end_node = ρσ_unpack[0];
                end_offset = ρσ_unpack[1];
                node_pos = ρσ_unpack[2];
                if (end_node !== null) {
                    return (function(){
                        var ρσ_d = Object.create(null);
                        ρσ_d["start_node"] = start_node;
                        ρσ_d["start_offset"] = start_offset;
                        ρσ_d["start_pos"] = start_pos;
                        ρσ_d["end_node"] = end_node;
                        ρσ_d["end_offset"] = end_offset;
                        ρσ_d["end_pos"] = node_pos;
                        return ρσ_d;
                    }).call(this);
                }
            }
        };
        if (!get_occurrence_data.__argnames__) Object.defineProperties(get_occurrence_data, {
            __argnames__ : {value: ["node_list", "start", "end"]},
            __module__ : {value: "read_book.find"}
        });

        function find_specific_occurrence(q, num, before_len, after_len, text_map, from_offset) {
            var from_idx, flat_text, match_num, idx;
            if (!q || !q.length) {
                return;
            }
            from_idx = from_offset || 0;
            flat_text = text_map.flat_text;
            match_num = -1;
            while (true) {
                idx = flat_text.indexOf(q, from_idx);
                if (idx < 0) {
                    break;
                }
                match_num += 1;
                from_idx = idx + 1;
                if (match_num < num) {
                    continue;
                }
                return get_occurrence_data(text_map.node_list, idx + before_len, idx + q.length - after_len);
            }
        };
        if (!find_specific_occurrence.__argnames__) Object.defineProperties(find_specific_occurrence, {
            __argnames__ : {value: ["q", "num", "before_len", "after_len", "text_map", "from_offset"]},
            __module__ : {value: "read_book.find"}
        });

        cache = Object.create(null);
        function reset_find_caches() {
            cache = Object.create(null);
        };
        if (!reset_find_caches.__module__) Object.defineProperties(reset_find_caches, {
            __module__ : {value: "read_book.find"}
        });

        function select_find_result(match) {
            var sel;
            sel = window.getSelection();
            try {
                sel.setBaseAndExtent(match.start_node, match.start_offset, match.end_node, match.end_offset);
            } catch (ρσ_Exception) {
                ρσ_last_exception = ρσ_Exception;
                {
                    return false;
                } 
            }
            return true;
        };
        if (!select_find_result.__argnames__) Object.defineProperties(select_find_result, {
            __argnames__ : {value: ["match"]},
            __module__ : {value: "read_book.find"}
        });

        function select_search_result(sr) {
            var q, before_len, after_len, after, match;
            window.getSelection().removeAllRanges();
            if (!cache.text_map) {
                cache.text_map = build_text_map();
            }
            q = "";
            before_len = after_len = 0;
            if (sr.before) {
                q = sr.before.slice(-15);
                before_len = q.length;
            }
            q += sr.text;
            if (sr.after) {
                after = sr.after.slice(0, 15);
                after_len = after.length;
                q += after;
            }
            match = find_specific_occurrence(q, int(sr.index), before_len, after_len, cache.text_map, sr.from_offset);
            if (!match) {
                return false;
            }
            return select_find_result(match);
        };
        if (!select_search_result.__argnames__) Object.defineProperties(select_search_result, {
            __argnames__ : {value: ["sr"]},
            __module__ : {value: "read_book.find"}
        });

        function select_tts_mark(idx_in_flat_text) {
            var r, match, word_length;
            window.getSelection().removeAllRanges();
            if (!cache.text_map) {
                cache.text_map = build_text_map();
            }
            r = tts_word_regex();
            r.lastIndex = idx_in_flat_text;
            match = r.exec(cache.text_map.flat_text);
            word_length = 5;
            if (match) {
                word_length = ρσ_exists.d(match[0]).length || 5;
            }
            match = get_occurrence_data(cache.text_map.node_list, idx_in_flat_text, idx_in_flat_text + word_length);
            if (!match) {
                return false;
            }
            return select_find_result(match);
        };
        if (!select_tts_mark.__argnames__) Object.defineProperties(select_tts_mark, {
            __argnames__ : {value: ["idx_in_flat_text"]},
            __module__ : {value: "read_book.find"}
        });

        ρσ_modules["read_book.find"].cache = cache;
        ρσ_modules["read_book.find"].build_text_map = build_text_map;
        ρσ_modules["read_book.find"].index_for_node = index_for_node;
        ρσ_modules["read_book.find"].tts_word_regex = tts_word_regex;
        ρσ_modules["read_book.find"].tts_data = tts_data;
        ρσ_modules["read_book.find"].find_node_for_index_binary = find_node_for_index_binary;
        ρσ_modules["read_book.find"].get_occurrence_data = get_occurrence_data;
        ρσ_modules["read_book.find"].find_specific_occurrence = find_specific_occurrence;
        ρσ_modules["read_book.find"].reset_find_caches = reset_find_caches;
        ρσ_modules["read_book.find"].select_find_result = select_find_result;
        ρσ_modules["read_book.find"].select_search_result = select_search_result;
        ρσ_modules["read_book.find"].select_tts_mark = select_tts_mark;
    })();

    (function(){
        var __name__ = "read_book.flow_mode";
        var small_scroll_events, last_change_spine_item_request, DIRECTION, scroll_animator, flick_animator, drag_scroller, anchor_funcs;
        var set_css = ρσ_modules.dom.set_css;

        var wrap_range = ρσ_modules.range_utils.wrap_range;
        var unwrap = ρσ_modules.range_utils.unwrap;

        var cfi_scroll_to = ρσ_modules["read_book.cfi"].scroll_to;

        var current_spine_item = ρσ_modules["read_book.globals"].current_spine_item;
        var get_boss = ρσ_modules["read_book.globals"].get_boss;
        var rtl_page_progression = ρσ_modules["read_book.globals"].rtl_page_progression;
        var ltr_page_progression = ρσ_modules["read_book.globals"].ltr_page_progression;

        var opts = ρσ_modules["read_book.settings"].opts;

        var line_height = ρσ_modules["read_book.viewport"].line_height;
        var rem_size = ρσ_modules["read_book.viewport"].rem_size;
        var scroll_viewport = ρσ_modules["read_book.viewport"].scroll_viewport;

        function flow_to_scroll_fraction(frac, on_initial_load) {
            scroll_viewport.scroll_to_in_block_direction(scroll_viewport.document_block_size() * frac);
        };
        if (!flow_to_scroll_fraction.__argnames__) Object.defineProperties(flow_to_scroll_fraction, {
            __argnames__ : {value: ["frac", "on_initial_load"]},
            __module__ : {value: "read_book.flow_mode"}
        });

        small_scroll_events = [];
        function clear_small_scrolls() {
            small_scroll_events = [];
        };
        if (!clear_small_scrolls.__module__) Object.defineProperties(clear_small_scrolls, {
            __module__ : {value: "read_book.flow_mode"}
        });

        function dispatch_small_scrolls() {
            var now, amt, x;
            if (small_scroll_events.length) {
                now = window.performance.now();
                if (now - small_scroll_events[small_scroll_events.length-1].time <= 2e3) {
                    window.setTimeout(dispatch_small_scrolls, 100);
                    return;
                }
                amt = 0;
                var ρσ_Iter0 = ρσ_Iterable(small_scroll_events);
                for (var ρσ_Index0 = 0; ρσ_Index0 < ρσ_Iter0.length; ρσ_Index0++) {
                    x = ρσ_Iter0[ρσ_Index0];
                    amt += x.amt;
                }
                clear_small_scrolls();
                get_boss().report_human_scroll(amt / scroll_viewport.document_block_size());
            }
        };
        if (!dispatch_small_scrolls.__module__) Object.defineProperties(dispatch_small_scrolls, {
            __module__ : {value: "read_book.flow_mode"}
        });

        function add_small_scroll(amt) {
            small_scroll_events.push((function(){
                var ρσ_d = Object.create(null);
                ρσ_d["amt"] = amt;
                ρσ_d["time"] = window.performance.now();
                return ρσ_d;
            }).call(this));
            window.setTimeout(dispatch_small_scrolls, 100);
        };
        if (!add_small_scroll.__argnames__) Object.defineProperties(add_small_scroll, {
            __argnames__ : {value: ["amt"]},
            __module__ : {value: "read_book.flow_mode"}
        });

        function report_human_scroll(amt) {
            var h, is_large_scroll;
            h = scroll_viewport.height();
            is_large_scroll = abs(amt) / h >= .5;
            if (amt > 0) {
                if (is_large_scroll) {
                    clear_small_scrolls();
                    get_boss().report_human_scroll(amt / scroll_viewport.document_block_size());
                } else {
                    add_small_scroll(amt);
                }
            } else if (amt === 0 || is_large_scroll) {
                clear_small_scrolls();
            }
        };
        if (!report_human_scroll.__argnames__) Object.defineProperties(report_human_scroll, {
            __argnames__ : {value: ["amt"]},
            __module__ : {value: "read_book.flow_mode"}
        });

        last_change_spine_item_request = Object.create(null);
        function _check_for_scroll_end(func, obj, args, report) {
            var before, should_flip_progression_direction, now, csi, go_to_previous_page;
            before = scroll_viewport.block_pos();
            should_flip_progression_direction = func.apply(obj, args);
            now = window.performance.now();
            scroll_animator.sync(now);
            if (scroll_viewport.block_pos() === before) {
                csi = current_spine_item();
                if (last_change_spine_item_request.name === csi.name && now - last_change_spine_item_request.at < 2e3) {
                    return false;
                }
                last_change_spine_item_request.name = csi.name;
                last_change_spine_item_request.at = now;
                go_to_previous_page = args[0] < 0;
                if (should_flip_progression_direction) {
                    go_to_previous_page = !go_to_previous_page;
                }
                (ρσ_expr_temp = get_boss(), ρσ_interpolate_kwargs.call(ρσ_expr_temp, ρσ_expr_temp.send_message, ["next_spine_item"].concat([ρσ_desugar_kwargs({previous: go_to_previous_page})])));
                return false;
            }
            if (report) {
                report_human_scroll(scroll_viewport.block_pos() - before);
            }
            return true;
        };
        if (!_check_for_scroll_end.__argnames__) Object.defineProperties(_check_for_scroll_end, {
            __argnames__ : {value: ["func", "obj", "args", "report"]},
            __module__ : {value: "read_book.flow_mode"}
        });

        function check_for_scroll_end(func) {
            return (function() {
                var ρσ_anonfunc = function () {
                    return _check_for_scroll_end(func, this, arguments, false);
                };
                if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
                    __module__ : {value: "read_book.flow_mode"}
                });
                return ρσ_anonfunc;
            })();
        };
        if (!check_for_scroll_end.__argnames__) Object.defineProperties(check_for_scroll_end, {
            __argnames__ : {value: ["func"]},
            __module__ : {value: "read_book.flow_mode"}
        });

        function check_for_scroll_end_and_report(func) {
            return (function() {
                var ρσ_anonfunc = function () {
                    return _check_for_scroll_end(func, this, arguments, true);
                };
                if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
                    __module__ : {value: "read_book.flow_mode"}
                });
                return ρσ_anonfunc;
            })();
        };
        if (!check_for_scroll_end_and_report.__argnames__) Object.defineProperties(check_for_scroll_end_and_report, {
            __argnames__ : {value: ["func"]},
            __module__ : {value: "read_book.flow_mode"}
        });

        
        var scroll_by_and_check_next_page = check_for_scroll_end_and_report((function() {
            var ρσ_anonfunc = function scroll_by_and_check_next_page(y) {
                scroll_viewport.scroll_by_in_block_direction(y);
                return false;
            };
            if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                __argnames__ : {value: ["y"]},
                __module__ : {value: "read_book.flow_mode"}
            });
            return ρσ_anonfunc;
        })());

        function flow_onwheel(evt) {
            var di, db, WheelEvent, dx;
            di = db = 0;
            WheelEvent = window.WheelEvent;
            if (evt.deltaY) {
                if (evt.deltaMode === WheelEvent.DOM_DELTA_PIXEL) {
                    db = evt.deltaY;
                } else if (evt.deltaMode === WheelEvent.DOM_DELTA_LINE) {
                    db = line_height() * evt.deltaY;
                }
                if (evt.deltaMode === WheelEvent.DOM_DELTA_PAGE) {
                    db = (scroll_viewport.block_size() - 30) * evt.deltaY;
                }
            }
            if (evt.deltaX) {
                if (evt.deltaMode === WheelEvent.DOM_DELTA_PIXEL) {
                    dx = evt.deltaX;
                } else if (evt.deltaMode === WheelEvent.DOM_DELTA_LINE) {
                    dx = line_height() * evt.deltaX;
                } else {
                    dx = (scroll_viewport.block_size() - 30) * evt.deltaX;
                }
                if (scroll_viewport.horizontal_writing_mode) {
                    di = dx;
                } else {
                    if (scroll_viewport.rtl) {
                        db = -dx;
                    } else {
                        db = dx;
                    }
                }
            }
            if (Math.abs(di) >= 1) {
                scroll_viewport.scroll_by_in_inline_direction(di);
            }
            if (Math.abs(db) >= 1) {
                scroll_by_and_check_next_page(db);
            }
        };
        if (!flow_onwheel.__argnames__) Object.defineProperties(flow_onwheel, {
            __argnames__ : {value: ["evt"]},
            __module__ : {value: "read_book.flow_mode"}
        });

        
        var goto_boundary = check_for_scroll_end((function() {
            var ρσ_anonfunc = function goto_boundary(dir) {
                var position;
                position = (dir === DIRECTION.Up) ? 0 : scroll_viewport.document_block_size();
                scroll_viewport.scroll_to_in_block_direction(position);
                get_boss().report_human_scroll();
                return false;
            };
            if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                __argnames__ : {value: ["dir"]},
                __module__ : {value: "read_book.flow_mode"}
            });
            return ρσ_anonfunc;
        })());

        
        var scroll_by_page = check_for_scroll_end_and_report((function() {
            var ρσ_anonfunc = function scroll_by_page(direction, flip_if_rtl_page_progression) {
                var b;
                b = scroll_viewport.block_size() - 10;
                scroll_viewport.scroll_by_in_block_direction(b * direction);
                return flip_if_rtl_page_progression && rtl_page_progression();
            };
            if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                __argnames__ : {value: ["direction", "flip_if_rtl_page_progression"]},
                __module__ : {value: "read_book.flow_mode"}
            });
            return ρσ_anonfunc;
        })());

        function scroll_to_extend_annotation(backward, horizontal, by_page) {
            var direction, h, before;
            direction = (backward) ? -1 : 1;
            h = line_height();
            if (by_page) {
                h = ((horizontal) ? window.innerWidth : window.innerHeight) - h;
            }
            if (horizontal) {
                before = window.pageXOffset;
                window.scrollBy(h * direction, 0);
                return window.pageXOffset !== before;
            }
            before = window.pageYOffset;
            window.scrollBy(0, h * direction);
            return window.pageYOffset !== before;
        };
        if (!scroll_to_extend_annotation.__argnames__) Object.defineProperties(scroll_to_extend_annotation, {
            __argnames__ : {value: ["backward", "horizontal", "by_page"]},
            __module__ : {value: "read_book.flow_mode"}
        });

        function is_auto_scroll_active() {
            return scroll_animator.is_active();
        };
        if (!is_auto_scroll_active.__module__) Object.defineProperties(is_auto_scroll_active, {
            __module__ : {value: "read_book.flow_mode"}
        });

        function start_autoscroll() {
            scroll_animator.start(DIRECTION.Down, true);
        };
        if (!start_autoscroll.__module__) Object.defineProperties(start_autoscroll, {
            __module__ : {value: "read_book.flow_mode"}
        });

        function toggle_autoscroll() {
            var running;
            if (is_auto_scroll_active()) {
                cancel_scroll();
                running = false;
            } else {
                start_autoscroll();
                running = true;
            }
            (ρσ_expr_temp = get_boss(), ρσ_interpolate_kwargs.call(ρσ_expr_temp, ρσ_expr_temp.send_message, ["autoscroll_state_changed"].concat([ρσ_desugar_kwargs({running: running})])));
        };
        if (!toggle_autoscroll.__module__) Object.defineProperties(toggle_autoscroll, {
            __module__ : {value: "read_book.flow_mode"}
        });

        function handle_shortcut(sc_name, evt) {
            if (sc_name === "down") {
                scroll_animator.start(DIRECTION.Down, false);
                return true;
            }
            if (sc_name === "up") {
                scroll_animator.start(DIRECTION.Up, false);
                return true;
            }
            if (sc_name === "start_of_file") {
                goto_boundary(DIRECTION.Up);
                return true;
            }
            if (sc_name === "end_of_file") {
                goto_boundary(DIRECTION.Down);
                return true;
            }
            if (sc_name === "left") {
                scroll_by_and_check_next_page((ltr_page_progression()) ? -15 : 15, 0);
                return true;
            }
            if (sc_name === "right") {
                scroll_by_and_check_next_page((ltr_page_progression()) ? 15 : -15, 0);
                return true;
            }
            if (sc_name === "start_of_book") {
                (ρσ_expr_temp = get_boss(), ρσ_interpolate_kwargs.call(ρσ_expr_temp, ρσ_expr_temp.send_message, ["goto_doc_boundary"].concat([ρσ_desugar_kwargs({start: true})])));
                return true;
            }
            if (sc_name === "end_of_book") {
                (ρσ_expr_temp = get_boss(), ρσ_interpolate_kwargs.call(ρσ_expr_temp, ρσ_expr_temp.send_message, ["goto_doc_boundary"].concat([ρσ_desugar_kwargs({start: false})])));
                return true;
            }
            if (sc_name === "pageup") {
                scroll_by_page(-1, false);
                return true;
            }
            if (sc_name === "pagedown") {
                scroll_by_page(1, false);
                return true;
            }
            if (sc_name === "toggle_autoscroll") {
                toggle_autoscroll();
                return true;
            }
            if (sc_name.startsWith("scrollspeed_")) {
                scroll_animator.sync();
            }
            return false;
        };
        if (!handle_shortcut.__argnames__) Object.defineProperties(handle_shortcut, {
            __argnames__ : {value: ["sc_name", "evt"]},
            __module__ : {value: "read_book.flow_mode"}
        });

        function layout(is_single_page) {
            var body_style;
            add_visibility_listener();
            line_height(true);
            rem_size(true);
            ρσ_interpolate_kwargs.call(this, set_css, [document.body].concat([ρσ_desugar_kwargs({margin: "0", border_width: "0", padding: "0"})]));
            body_style = window.getComputedStyle(document.body);
            scroll_viewport.initialize_on_layout(body_style);
            document.documentElement.style.overflow = (scroll_viewport.vertical_writing_mode) ? "visible" : "hidden";
        };
        if (!layout.__argnames__) Object.defineProperties(layout, {
            __argnames__ : {value: ["is_single_page"]},
            __module__ : {value: "read_book.flow_mode"}
        });

        function auto_scroll_resume() {
            scroll_animator.wait = false;
            scroll_animator.sync();
        };
        if (!auto_scroll_resume.__module__) Object.defineProperties(auto_scroll_resume, {
            __module__ : {value: "read_book.flow_mode"}
        });

        function add_visibility_listener() {
            if (add_visibility_listener.done) {
                return;
            }
            add_visibility_listener.done = true;
            document.addEventListener("visibilitychange", (function() {
                var ρσ_anonfunc = function () {
                    if (document.visibilityState === "visible") {
                        scroll_animator.sync();
                    } else {
                        scroll_animator.pause();
                    }
                };
                if (!ρσ_anonfunc.__module__) Object.defineProperties(ρσ_anonfunc, {
                    __module__ : {value: "read_book.flow_mode"}
                });
                return ρσ_anonfunc;
            })());
        };
        if (!add_visibility_listener.__module__) Object.defineProperties(add_visibility_listener, {
            __module__ : {value: "read_book.flow_mode"}
        });

        function cancel_scroll() {
            scroll_animator.stop();
        };
        if (!cancel_scroll.__module__) Object.defineProperties(cancel_scroll, {
            __module__ : {value: "read_book.flow_mode"}
        });

        function is_scroll_end(pos) {
            return !((0 <= pos && pos <= scroll_viewport.document_block_size() - scroll_viewport.block_size()));
        };
        if (!is_scroll_end.__argnames__) Object.defineProperties(is_scroll_end, {
            __argnames__ : {value: ["pos"]},
            __module__ : {value: "read_book.flow_mode"}
        });

        DIRECTION = (function(){
            var ρσ_d = Object.create(null);
            ρσ_d["Up"] = -1;
            ρσ_d["up"] = -1;
            ρσ_d["Down"] = 1;
            ρσ_d["down"] = 1;
            ρσ_d["UP"] = -1;
            ρσ_d["DOWN"] = 1;
            return ρσ_d;
        }).call(this);
        function ScrollAnimator() {
            if (this.ρσ_object_id === undefined) Object.defineProperty(this, "ρσ_object_id", {"value":++ρσ_object_counter});
            ScrollAnimator.prototype.__bind_methods__.call(this);
            ScrollAnimator.prototype.__init__.apply(this, arguments);
        }
        Object.defineProperty(ScrollAnimator.prototype, "__bind_methods__", {value: function () {
            this.is_running = ScrollAnimator.prototype.is_running.bind(this);
            this.is_active = ScrollAnimator.prototype.is_active.bind(this);
            this.start = ScrollAnimator.prototype.start.bind(this);
            this.smooth_scroll = ScrollAnimator.prototype.smooth_scroll.bind(this);
            this.auto_scroll = ScrollAnimator.prototype.auto_scroll.bind(this);
            this.request_next_spine_item = ScrollAnimator.prototype.request_next_spine_item.bind(this);
            this.report = ScrollAnimator.prototype.report.bind(this);
            this.sync = ScrollAnimator.prototype.sync.bind(this);
            this.stop = ScrollAnimator.prototype.stop.bind(this);
            this.stop_auto_spine_transition = ScrollAnimator.prototype.stop_auto_spine_transition.bind(this);
            this.pause = ScrollAnimator.prototype.pause.bind(this);
            this.resume = ScrollAnimator.prototype.resume.bind(this);
        }});
        ScrollAnimator.prototype.__init__ = function __init__() {
            var self = this;
            self.animation_id = null;
            self.auto = false;
            self.auto_timer = null;
            self.paused = false;
        };
        if (!ScrollAnimator.prototype.__init__.__module__) Object.defineProperties(ScrollAnimator.prototype.__init__, {
            __module__ : {value: "read_book.flow_mode"}
        });
        ScrollAnimator.__argnames__ = ScrollAnimator.prototype.__init__.__argnames__;
        ScrollAnimator.__handles_kwarg_interpolation__ = ScrollAnimator.prototype.__init__.__handles_kwarg_interpolation__;
        ScrollAnimator.prototype.is_running = function is_running() {
            var self = this;
            return self.animation_id !== null || self.auto_timer !== null;
        };
        if (!ScrollAnimator.prototype.is_running.__module__) Object.defineProperties(ScrollAnimator.prototype.is_running, {
            __module__ : {value: "read_book.flow_mode"}
        });
        ScrollAnimator.prototype.is_active = function is_active() {
            var self = this;
            return self.is_running() && (self.auto || self.auto_timer !== null);
        };
        if (!ScrollAnimator.prototype.is_active.__module__) Object.defineProperties(ScrollAnimator.prototype.is_active, {
            __module__ : {value: "read_book.flow_mode"}
        });
        ScrollAnimator.prototype.start = function start(direction, auto) {
            var self = this;
            var now;
            cancel_drag_scroll();
            if (self.wait) {
                return;
            }
            now = window.performance.now();
            self.end_time = now + self.DURATION;
            self.stop_auto_spine_transition();
            if (!self.is_running() || direction !== self.direction || auto !== self.auto) {
                if (self.auto && !auto) {
                    self.pause();
                }
                self.stop();
                self.auto = auto;
                self.direction = direction;
                self.start_time = now;
                self.start_offset = scroll_viewport.block_pos();
                self.csi_idx = current_spine_item().index;
                self.animation_id = window.requestAnimationFrame((auto) ? self.auto_scroll : self.smooth_scroll);
            }
        };
        if (!ScrollAnimator.prototype.start.__argnames__) Object.defineProperties(ScrollAnimator.prototype.start, {
            __argnames__ : {value: ["direction", "auto"]},
            __module__ : {value: "read_book.flow_mode"}
        });
        ScrollAnimator.prototype.smooth_scroll = function smooth_scroll(ts) {
            var self = this;
            var duration, progress, scroll_target, amt;
            duration = self.end_time - self.start_time;
            if (duration <= 0) {
                self.animation_id = null;
                return;
            }
            progress = max(0, min(1, (ts - self.start_time) / duration));
            scroll_target = self.start_offset;
            scroll_target += Math.trunc(self.direction * progress * duration * line_height() * opts.lines_per_sec_smooth) / 1e3;
            scroll_viewport.scroll_to_in_block_direction(scroll_target);
            amt = scroll_viewport.block_pos() - self.start_offset;
            if (is_scroll_end(scroll_target) && (!opts.scroll_stop_boundaries || abs(amt) < 3 && duration === self.DURATION)) {
                self.animation_id = null;
                self.wait = true;
                report_human_scroll(amt);
                (ρσ_expr_temp = get_boss(), ρσ_interpolate_kwargs.call(ρσ_expr_temp, ρσ_expr_temp.send_message, ["next_spine_item"].concat([ρσ_desugar_kwargs({previous: self.direction === DIRECTION.Up})])));
            } else if (progress < 1) {
                self.animation_id = window.requestAnimationFrame(self.smooth_scroll);
            } else if (self.paused) {
                self.resume();
            } else {
                self.animation_id = null;
                report_human_scroll(amt);
            }
        };
        if (!ScrollAnimator.prototype.smooth_scroll.__argnames__) Object.defineProperties(ScrollAnimator.prototype.smooth_scroll, {
            __argnames__ : {value: ["ts"]},
            __module__ : {value: "read_book.flow_mode"}
        });
        ScrollAnimator.prototype.auto_scroll = function auto_scroll(ts) {
            var self = this;
            var elapsed, scroll_target, scroll_finished;
            elapsed = max(0, ts - self.start_time);
            scroll_target = self.start_offset;
            scroll_target += Math.trunc(self.direction * elapsed * line_height() * opts.lines_per_sec_auto) / 1e3;
            scroll_viewport.scroll_to_in_block_direction(scroll_target);
            scroll_finished = is_scroll_end(scroll_target);
            if (elapsed >= 1e3) {
                self.sync(ts);
            }
            if (scroll_finished) {
                self.pause();
                if (opts.scroll_auto_boundary_delay >= 0) {
                    self.auto_timer = setTimeout(self.request_next_spine_item, opts.scroll_auto_boundary_delay * 1e3);
                }
            } else {
                self.animation_id = window.requestAnimationFrame(self.auto_scroll);
            }
        };
        if (!ScrollAnimator.prototype.auto_scroll.__argnames__) Object.defineProperties(ScrollAnimator.prototype.auto_scroll, {
            __argnames__ : {value: ["ts"]},
            __module__ : {value: "read_book.flow_mode"}
        });
        ScrollAnimator.prototype.request_next_spine_item = function request_next_spine_item() {
            var self = this;
            self.auto_timer = null;
            (ρσ_expr_temp = get_boss(), ρσ_interpolate_kwargs.call(ρσ_expr_temp, ρσ_expr_temp.send_message, ["next_spine_item"].concat([ρσ_desugar_kwargs({previous: self.direction === DIRECTION.Up})])));
        };
        if (!ScrollAnimator.prototype.request_next_spine_item.__module__) Object.defineProperties(ScrollAnimator.prototype.request_next_spine_item, {
            __module__ : {value: "read_book.flow_mode"}
        });
        ScrollAnimator.prototype.report = function report() {
            var self = this;
            var amt;
            amt = scroll_viewport.block_pos() - self.start_offset;
            if (abs(amt) > 0 && self.csi_idx === current_spine_item().index) {
                report_human_scroll(amt);
            }
        };
        if (!ScrollAnimator.prototype.report.__module__) Object.defineProperties(ScrollAnimator.prototype.report, {
            __module__ : {value: "read_book.flow_mode"}
        });
        ScrollAnimator.prototype.sync = function sync(ts) {
            var self = this;
            if (self.auto) {
                self.report();
                self.csi_idx = current_spine_item().index;
                self.start_time = ts || window.performance.now();
                self.start_offset = scroll_viewport.block_pos();
            } else {
                self.resume();
            }
        };
        if (!ScrollAnimator.prototype.sync.__argnames__) Object.defineProperties(ScrollAnimator.prototype.sync, {
            __argnames__ : {value: ["ts"]},
            __module__ : {value: "read_book.flow_mode"}
        });
        ScrollAnimator.prototype.stop = function stop() {
            var self = this;
            self.auto = false;
            if (self.animation_id !== null) {
                window.cancelAnimationFrame(self.animation_id);
                self.animation_id = null;
                self.report();
            }
            self.stop_auto_spine_transition();
        };
        if (!ScrollAnimator.prototype.stop.__module__) Object.defineProperties(ScrollAnimator.prototype.stop, {
            __module__ : {value: "read_book.flow_mode"}
        });
        ScrollAnimator.prototype.stop_auto_spine_transition = function stop_auto_spine_transition() {
            var self = this;
            if (self.auto_timer !== null) {
                clearTimeout(self.auto_timer);
                self.auto_timer = null;
                self.paused = false;
            }
        };
        if (!ScrollAnimator.prototype.stop_auto_spine_transition.__module__) Object.defineProperties(ScrollAnimator.prototype.stop_auto_spine_transition, {
            __module__ : {value: "read_book.flow_mode"}
        });
        ScrollAnimator.prototype.pause = function pause() {
            var self = this;
            if (self.auto) {
                self.paused = self.direction;
                self.stop();
            } else {
                self.paused = false;
            }
        };
        if (!ScrollAnimator.prototype.pause.__module__) Object.defineProperties(ScrollAnimator.prototype.pause, {
            __module__ : {value: "read_book.flow_mode"}
        });
        ScrollAnimator.prototype.resume = function resume() {
            var self = this;
            if (self.paused) {
                self.start(self.paused, true);
                self.paused = false;
            }
        };
        if (!ScrollAnimator.prototype.resume.__module__) Object.defineProperties(ScrollAnimator.prototype.resume, {
            __module__ : {value: "read_book.flow_mode"}
        });
        ScrollAnimator.prototype.__repr__ = function __repr__ () {
                        return "<" + __name__ + "." + this.constructor.name + " #" + this.ρσ_object_id + ">";
        };
        ScrollAnimator.prototype.__str__ = function __str__ () {
            return this.__repr__();
        };
        Object.defineProperty(ScrollAnimator.prototype, "__bases__", {value: []});
        ScrollAnimator.prototype.DURATION = 100;

        scroll_animator = new ScrollAnimator;
        function FlickAnimator() {
            if (this.ρσ_object_id === undefined) Object.defineProperty(this, "ρσ_object_id", {"value":++ρσ_object_counter});
            FlickAnimator.prototype.__bind_methods__.call(this);
            FlickAnimator.prototype.__init__.apply(this, arguments);
        }
        Object.defineProperty(FlickAnimator.prototype, "__bind_methods__", {value: function () {
            this.cancel_current_drag_scroll = FlickAnimator.prototype.cancel_current_drag_scroll.bind(this);
            this.start = FlickAnimator.prototype.start.bind(this);
            this.auto_scroll = FlickAnimator.prototype.auto_scroll.bind(this);
            this.scroll_y = FlickAnimator.prototype.scroll_y.bind(this);
            this.scroll_x = FlickAnimator.prototype.scroll_x.bind(this);
            this.stop = FlickAnimator.prototype.stop.bind(this);
        }});
        FlickAnimator.prototype.__init__ = function __init__() {
            var self = this;
            self.animation_id = null;
        };
        if (!FlickAnimator.prototype.__init__.__module__) Object.defineProperties(FlickAnimator.prototype.__init__, {
            __module__ : {value: "read_book.flow_mode"}
        });
        FlickAnimator.__argnames__ = FlickAnimator.prototype.__init__.__argnames__;
        FlickAnimator.__handles_kwarg_interpolation__ = FlickAnimator.prototype.__init__.__handles_kwarg_interpolation__;
        FlickAnimator.prototype.cancel_current_drag_scroll = function cancel_current_drag_scroll() {
            var self = this;
            cancel_drag_scroll();
        };
        if (!FlickAnimator.prototype.cancel_current_drag_scroll.__module__) Object.defineProperties(FlickAnimator.prototype.cancel_current_drag_scroll, {
            __module__ : {value: "read_book.flow_mode"}
        });
        FlickAnimator.prototype.start = function start(gesture) {
            var self = this;
            var now, points, times, ρσ_unpack, i, t, elapsed, delta, velocity;
            self.cancel_current_drag_scroll();
            self.vertical = gesture.axis === "vertical";
            now = window.performance.now();
            points = times = null;
            var ρσ_Iter1 = ρσ_Iterable(enumerate(gesture.times));
            for (var ρσ_Index1 = 0; ρσ_Index1 < ρσ_Iter1.length; ρσ_Index1++) {
                ρσ_unpack = ρσ_Iter1[ρσ_Index1];
                i = ρσ_unpack[0];
                t = ρσ_unpack[1];
                if (now - t < self.VELOCITY_HISTORY) {
                    ρσ_unpack = [gesture.points.slice(i), gesture.times.slice(i)];
                    points = ρσ_unpack[0];
                    times = ρσ_unpack[1];
                    break;
                }
            }
            if (times && times.length > 1) {
                elapsed = (times[times.length-1] - times[0]) / 1e3;
                if (elapsed > 0 && points.length > 1) {
                    delta = points[0] - points[points.length-1];
                    velocity = delta / elapsed;
                    if (abs(velocity) > self.MIMUMUM_VELOCITY) {
                        self.amplitude = self.SPEED_FACTOR * velocity;
                        self.start_time = now;
                        self.animation_id = window.requestAnimationFrame(self.auto_scroll);
                    }
                }
            }
        };
        if (!FlickAnimator.prototype.start.__argnames__) Object.defineProperties(FlickAnimator.prototype.start, {
            __argnames__ : {value: ["gesture"]},
            __module__ : {value: "read_book.flow_mode"}
        });
        FlickAnimator.prototype.auto_scroll = function auto_scroll(ts) {
            var self = this;
            var elapsed, delta;
            if (self.animation_id === null) {
                return;
            }
            elapsed = window.performance.now() - self.start_time;
            delta = self.amplitude * Math.exp(-elapsed / self.DECEL_TIME_CONSTANT);
            if (abs(delta) >= 1) {
                delta = Math.round(delta);
                if (self.vertical) {
                    self.scroll_y(delta);
                } else {
                    self.scroll_x(delta);
                }
                self.animation_id = window.requestAnimationFrame(self.auto_scroll);
            }
        };
        if (!FlickAnimator.prototype.auto_scroll.__argnames__) Object.defineProperties(FlickAnimator.prototype.auto_scroll, {
            __argnames__ : {value: ["ts"]},
            __module__ : {value: "read_book.flow_mode"}
        });
        FlickAnimator.prototype.scroll_y = function scroll_y(delta) {
            var self = this;
            window.scrollBy(0, delta);
        };
        if (!FlickAnimator.prototype.scroll_y.__argnames__) Object.defineProperties(FlickAnimator.prototype.scroll_y, {
            __argnames__ : {value: ["delta"]},
            __module__ : {value: "read_book.flow_mode"}
        });
        FlickAnimator.prototype.scroll_x = function scroll_x(delta) {
            var self = this;
            window.scrollBy(delta, 0);
        };
        if (!FlickAnimator.prototype.scroll_x.__argnames__) Object.defineProperties(FlickAnimator.prototype.scroll_x, {
            __argnames__ : {value: ["delta"]},
            __module__ : {value: "read_book.flow_mode"}
        });
        FlickAnimator.prototype.stop = function stop() {
            var self = this;
            if (self.animation_id !== null) {
                window.cancelAnimationFrame(self.animation_id);
                self.animation_id = null;
            }
        };
        if (!FlickAnimator.prototype.stop.__module__) Object.defineProperties(FlickAnimator.prototype.stop, {
            __module__ : {value: "read_book.flow_mode"}
        });
        FlickAnimator.prototype.__repr__ = function __repr__ () {
                        return "<" + __name__ + "." + this.constructor.name + " #" + this.ρσ_object_id + ">";
        };
        FlickAnimator.prototype.__str__ = function __str__ () {
            return this.__repr__();
        };
        Object.defineProperty(FlickAnimator.prototype, "__bases__", {value: []});
        FlickAnimator.prototype.SPEED_FACTOR = .04;
        FlickAnimator.prototype.DECEL_TIME_CONSTANT = 325;
        FlickAnimator.prototype.VELOCITY_HISTORY = 300;
        FlickAnimator.prototype.MIMUMUM_VELOCITY = 100;

        flick_animator = new FlickAnimator;
        function DragScroller() {
            if (this.ρσ_object_id === undefined) Object.defineProperty(this, "ρσ_object_id", {"value":++ρσ_object_counter});
            DragScroller.prototype.__bind_methods__.call(this);
            DragScroller.prototype.__init__.apply(this, arguments);
        }
        Object.defineProperty(DragScroller.prototype, "__bind_methods__", {value: function () {
            this.is_running = DragScroller.prototype.is_running.bind(this);
            this.smooth_scroll = DragScroller.prototype.smooth_scroll.bind(this);
            this.start = DragScroller.prototype.start.bind(this);
            this.stop = DragScroller.prototype.stop.bind(this);
        }});
        DragScroller.prototype.__init__ = function __init__() {
            var self = this;
            self.animation_id = null;
            self.direction = 1;
            self.speed_factor = 1;
            self.start_time = self.end_time = 0;
            self.start_offset = 0;
        };
        if (!DragScroller.prototype.__init__.__module__) Object.defineProperties(DragScroller.prototype.__init__, {
            __module__ : {value: "read_book.flow_mode"}
        });
        DragScroller.__argnames__ = DragScroller.prototype.__init__.__argnames__;
        DragScroller.__handles_kwarg_interpolation__ = DragScroller.prototype.__init__.__handles_kwarg_interpolation__;
        DragScroller.prototype.is_running = function is_running() {
            var self = this;
            return self.animation_id !== null;
        };
        if (!DragScroller.prototype.is_running.__module__) Object.defineProperties(DragScroller.prototype.is_running, {
            __module__ : {value: "read_book.flow_mode"}
        });
        DragScroller.prototype.smooth_scroll = function smooth_scroll(ts) {
            var self = this;
            var duration, progress, scroll_target;
            duration = self.end_time - self.start_time;
            if (duration <= 0) {
                self.animation_id = null;
                self.start(self.direction, self.speed_factor);
                return;
            }
            progress = max(0, min(1, (ts - self.start_time) / duration));
            scroll_target = self.start_offset;
            scroll_target += Math.trunc(self.direction * progress * duration * line_height() * opts.lines_per_sec_smooth * self.speed_factor) / 1e3;
            scroll_viewport.scroll_to_in_block_direction(scroll_target);
            if (progress < 1) {
                self.animation_id = window.requestAnimationFrame(self.smooth_scroll);
            } else {
                self.animation_id = null;
                self.start(self.direction, self.speed_factor);
            }
        };
        if (!DragScroller.prototype.smooth_scroll.__argnames__) Object.defineProperties(DragScroller.prototype.smooth_scroll, {
            __argnames__ : {value: ["ts"]},
            __module__ : {value: "read_book.flow_mode"}
        });
        DragScroller.prototype.start = function start(direction, speed_factor) {
            var self = this;
            var now;
            now = window.performance.now();
            self.end_time = now + self.DURATION;
            if (!self.is_running() || direction !== self.direction || speed_factor !== self.speed_factor) {
                self.stop();
                self.direction = direction;
                self.speed_factor = speed_factor;
                self.start_time = now;
                self.start_offset = scroll_viewport.block_pos();
                self.animation_id = window.requestAnimationFrame(self.smooth_scroll);
            }
        };
        if (!DragScroller.prototype.start.__argnames__) Object.defineProperties(DragScroller.prototype.start, {
            __argnames__ : {value: ["direction", "speed_factor"]},
            __module__ : {value: "read_book.flow_mode"}
        });
        DragScroller.prototype.stop = function stop() {
            var self = this;
            if (self.animation_id !== null) {
                window.cancelAnimationFrame(self.animation_id);
                self.animation_id = null;
            }
        };
        if (!DragScroller.prototype.stop.__module__) Object.defineProperties(DragScroller.prototype.stop, {
            __module__ : {value: "read_book.flow_mode"}
        });
        DragScroller.prototype.__repr__ = function __repr__ () {
                        return "<" + __name__ + "." + this.constructor.name + " #" + this.ρσ_object_id + ">";
        };
        DragScroller.prototype.__str__ = function __str__ () {
            return this.__repr__();
        };
        Object.defineProperty(DragScroller.prototype, "__bases__", {value: []});
        DragScroller.prototype.DURATION = 100;

        drag_scroller = new DragScroller;
        function cancel_drag_scroll() {
            drag_scroller.stop();
        };
        if (!cancel_drag_scroll.__module__) Object.defineProperties(cancel_drag_scroll, {
            __module__ : {value: "read_book.flow_mode"}
        });

        function start_drag_scroll(delta) {
            var limit, direction, speed_factor;
            limit = (delta < 0) ? opts.margin_top : opts.margin_bottom;
            direction = (delta >= 0) ? 1 : -1;
            speed_factor = min(abs(delta), limit) / limit;
            speed_factor *= 2 - speed_factor;
            drag_scroller.start(direction, 2 * speed_factor);
        };
        if (!start_drag_scroll.__argnames__) Object.defineProperties(start_drag_scroll, {
            __argnames__ : {value: ["delta"]},
            __module__ : {value: "read_book.flow_mode"}
        });

        function handle_gesture(gesture) {
            var delta;
            flick_animator.stop();
            if (gesture.type === "swipe") {
                if (gesture.points.length > 1 && !gesture.is_held) {
                    delta = (ρσ_expr_temp = gesture.points)[ρσ_expr_temp.length-2] - (ρσ_expr_temp = gesture.points)[ρσ_expr_temp.length-1];
                    if (Math.abs(delta) >= 1) {
                        if (gesture.axis === "vertical") {
                            if (scroll_viewport.vertical_writing_mode) {
                                scroll_viewport.scroll_by(delta, 0);
                            } else {
                                scroll_by_and_check_next_page(delta);
                            }
                        } else {
                            if (scroll_viewport.vertical_writing_mode) {
                                scroll_by_and_check_next_page(delta);
                            } else {
                                scroll_viewport.scroll_by(delta, 0);
                            }
                        }
                    }
                }
                if (!gesture.active && !gesture.is_held) {
                    flick_animator.start(gesture);
                }
            } else if (gesture.type === "prev-page") {
                scroll_by_page(-1, false);
            } else if (gesture.type === "next-page") {
                scroll_by_page(1, false);
            }
        };
        if (!handle_gesture.__argnames__) Object.defineProperties(handle_gesture, {
            __argnames__ : {value: ["gesture"]},
            __module__ : {value: "read_book.flow_mode"}
        });

        anchor_funcs = (function(){
            var ρσ_d = Object.create(null);
            ρσ_d["pos_for_elem"] = (function() {
                var ρσ_anonfunc = function pos_for_elem(elem) {
                    var br;
                    if (!elem) {
                        return (function(){
                            var ρσ_d = Object.create(null);
                            ρσ_d["block"] = 0;
                            ρσ_d["inline"] = 0;
                            return ρσ_d;
                        }).call(this);
                    }
                    br = elem.getBoundingClientRect();
                    return (function(){
                        var ρσ_d = Object.create(null);
                        ρσ_d["block"] = scroll_viewport.viewport_to_document_block(scroll_viewport.rect_block_start(br), elem.ownerDocument);
                        ρσ_d["inline"] = scroll_viewport.viewport_to_document_inline(scroll_viewport.rect_inline_start(br), elem.ownerDocument);
                        return ρσ_d;
                    }).call(this);
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["elem"]},
                    __module__ : {value: "read_book.flow_mode"}
                });
                return ρσ_anonfunc;
            })();
            ρσ_d["visibility"] = (function() {
                var ρσ_anonfunc = function visibility(pos) {
                    var q;
                    q = pos.block;
                    if (scroll_viewport.vertical_writing_mode && scroll_viewport.rtl) {
                        q = -q;
                    }
                    if (q + 1 < scroll_viewport.block_pos()) {
                        return -1;
                    }
                    if (q <= scroll_viewport.block_pos() + scroll_viewport.block_size()) {
                        return 0;
                    }
                    return 1;
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["pos"]},
                    __module__ : {value: "read_book.flow_mode"}
                });
                return ρσ_anonfunc;
            })();
            ρσ_d["cmp"] = (function() {
                var ρσ_anonfunc = function cmp(a, b) {
                    return a.block - b.block || a.inline - b.inline;
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["a", "b"]},
                    __module__ : {value: "read_book.flow_mode"}
                });
                return ρσ_anonfunc;
            })();
            return ρσ_d;
        }).call(this);
        function auto_scroll_action(action) {
            if (action === "toggle") {
                toggle_autoscroll();
            } else if (action === "start") {
                if (!is_auto_scroll_active()) {
                    toggle_autoscroll();
                }
            } else if (action === "stop") {
                if (is_auto_scroll_active()) {
                    toggle_autoscroll();
                }
            } else if (action === "resume") {
                auto_scroll_resume();
            }
            return is_auto_scroll_active();
        };
        if (!auto_scroll_action.__argnames__) Object.defineProperties(auto_scroll_action, {
            __argnames__ : {value: ["action"]},
            __module__ : {value: "read_book.flow_mode"}
        });

        function closest_preceding_element(p) {
            while (p && !p.scrollIntoView) {
                p = p.previousSibling || p.parentNode;
            }
            return p;
        };
        if (!closest_preceding_element.__argnames__) Object.defineProperties(closest_preceding_element, {
            __argnames__ : {value: ["p"]},
            __module__ : {value: "read_book.flow_mode"}
        });

        function ensure_selection_visible() {
            var s, p, r, rect, wrapper;
            s = window.getSelection();
            p = s.anchorNode;
            if (!p) {
                return;
            }
            p = closest_preceding_element(p);
            if ((typeof p !== "undefined" && p !== null ? p : Object.create(null)).scrollIntoView) {
                p.scrollIntoView();
            }
            r = s.getRangeAt(0);
            if (!r) {
                return;
            }
            rect = r.getBoundingClientRect();
            if (!rect) {
                return;
            }
            if (rect.top < 0 || rect.top >= window.innerHeight || rect.left < 0 || rect.left >= window.innerWidth) {
                wrapper = document.createElement("span");
                wrap_range(r, wrapper);
                wrapper.scrollIntoView();
                unwrap(wrapper);
            }
        };
        if (!ensure_selection_visible.__module__) Object.defineProperties(ensure_selection_visible, {
            __module__ : {value: "read_book.flow_mode"}
        });

        function ensure_selection_boundary_visible(use_end) {
            var sel, rr, r, node, x, y;
            sel = window.getSelection();
            try {
                rr = sel.getRangeAt(0);
            } catch (ρσ_Exception) {
                ρσ_last_exception = ρσ_Exception;
                {
                    rr = null;
                } 
            }
            if (rr) {
                r = rr.getBoundingClientRect();
                if (r) {
                    node = (use_end) ? sel.focusNode : sel.anchorNode;
                    x = (use_end) ? scroll_viewport.rect_inline_end(r) : scroll_viewport.rect_inline_start(r);
                    if (x < 0 || x >= window.innerWidth) {
                        x = ρσ_interpolate_kwargs.call(scroll_viewport, scroll_viewport.viewport_to_document_inline, [x].concat([ρσ_desugar_kwargs({doc: node.ownerDocument})]));
                        if (use_end) {
                            x -= line_height();
                        }
                        scroll_viewport.scroll_to_in_inline_direction(x, true);
                    }
                    y = (use_end) ? scroll_viewport.rect_block_end(r) : scroll_viewport.rect_block_start(r);
                    if (y < 0 || y >= window.innerHeight) {
                        y = ρσ_interpolate_kwargs.call(scroll_viewport, scroll_viewport.viewport_to_document_block, [y].concat([ρσ_desugar_kwargs({doc: node.ownerDocument})]));
                        if (use_end) {
                            y -= line_height();
                        }
                        scroll_viewport.scroll_to_in_block_direction(y, true);
                    }
                }
            }
        };
        if (!ensure_selection_boundary_visible.__argnames__) Object.defineProperties(ensure_selection_boundary_visible, {
            __argnames__ : {value: ["use_end"]},
            __module__ : {value: "read_book.flow_mode"}
        });

        function jump_to_cfi(cfi) {
            cfi_scroll_to(cfi, (function() {
                var ρσ_anonfunc = function (x, y) {
                    if (scroll_viewport.horizontal_writing_mode) {
                        scroll_viewport.scroll_to_in_block_direction(y);
                    } else {
                        scroll_viewport.scroll_to_in_block_direction(x);
                    }
                };
                if (!ρσ_anonfunc.__argnames__) Object.defineProperties(ρσ_anonfunc, {
                    __argnames__ : {value: ["x", "y"]},
                    __module__ : {value: "read_book.flow_mode"}
                });
                return ρσ_anonfunc;
            })());
        };
        if (!jump_to_cfi.__argnames__) Object.defineProperties(jump_to_cfi, {
            __argnames__ : {value: ["cfi"]},
            __module__ : {value: "read_book.flow_mode"}
        });

        ρσ_modules["read_book.flow_mode"].small_scroll_events = small_scroll_events;
        ρσ_modules["read_book.flow_mode"].last_change_spine_item_request = last_change_spine_item_request;
        ρσ_modules["read_book.flow_mode"].DIRECTION = DIRECTION;
        ρσ_modules["read_book.flow_mode"].scroll_animator = scroll_animator;
        ρσ_modules["read_book.flow_mode"].flick_animator = flick_animator;
        ρσ_modules["read_book.flow_mode"].drag_scroller = drag_scroller;
        ρσ_modules["read_book.flow_mode"].anchor_funcs = anchor_funcs;
        ρσ_modules["read_book.flow_mode"].flow_to_scroll_fraction = flow_to_scroll_fraction;
        ρσ_modules["read_book.flow_mode"].clear_small_scrolls = clear_small_scrolls;
        ρσ_modules["read_book.flow_mode"].dispatch_small_scrolls = dispatch_small_scrolls;
        ρσ_modules["read_book.flow_mode"].add_small_scroll = add_small_scroll;
        ρσ_modules["read_book.flow_mode"].report_human_scroll = report_human_scroll;
        ρσ_modules["read_book.flow_mode"]._check_for_scroll_end = _check_for_scroll_end;
        ρσ_modules["read_book.flow_mode"].check_for_scroll_end = check_for_scroll_end;
        ρσ_modules["read_book.flow_mode"].check_for_scroll_end_and_report = check_for_scroll_end_and_report;
        ρσ_modules["read_book.flow_mode"].scroll_by_and_check_next_page = scroll_by_and_check_next_page;
        ρσ_modules["read_book.flow_mode"].flow_onwheel = flow_onwheel;
        ρσ_modules["read_book.flow_mode"].goto_boundary = goto_boundary;
        ρσ_modules["read_book.flow_mode"].scroll_by_page = scroll_by_page;
        ρσ_modules["read_book.flow_mode"].scroll_to_extend_annotation = scroll_to_extend_annotation;
        ρσ_modules["read_book.flow_mode"].is_auto_scroll_active = is_auto_scroll_active;
        ρσ_modules["read_book.flow_mode"].start_autoscroll = start_autoscroll;
        ρσ_modules["read_book.flow_mode"].toggle_autoscroll = toggle_autoscroll;
        ρσ_modules["read_book.flow_mode"].handle_shortcut = handle_shortcut;
        ρσ_modules["read_book.flow_mode"].layout = layout;
        ρσ_modules["read_book.flow_mode"].auto_scroll_resume = auto_scroll_resume;
        ρσ_modules["read_book.flow_mode"].add_visibility_listener = add_visibility_listener;
        ρσ_modules["read_book.flow_mode"].cancel_scroll = cancel_scroll;
        ρσ_modules["read_book.flow_mode"].is_scroll_end = is_scroll_end;
        ρσ_modules["read_book.flow_mode"].ScrollAnimator = ScrollAnimator;
        ρσ_modules["read_book.flow_mode"].FlickAnimator = FlickAnimator;
        ρσ_modules["read_book.flow_mode"].DragScroller = DragScroller;
        ρσ_modules["read_book.flow_mode"].cancel_drag_scroll = cancel_drag_scroll;
        ρσ_modules["read_book.flow_mode"].start_drag_scroll = start_drag_scroll;
        ρσ_modules["read_book.flow_mode"].handle_gesture = handle_gesture;
        ρσ_modules["read_book.flow_mode"].auto_scroll_action = auto_scroll_action;
        ρσ_modules["read_book.flow_mode"].closest_preceding_element = closest_preceding_element;
        ρσ_modules["read_book.flow_mode"].ensure_selection_visible = ensure_selection_visible;
        ρσ_modules["read_book.flow_mode"].ensure_selection_boundary_visible = ensure_selection_boundary_visible;
        ρσ_modules["read_book.flow_mode"].jump_to_cfi = jump_to_cfi;
    })();

    (function(){
        var __name__ = "complete";
        var ensure_id = ρσ_modules.dom.ensure_id;
        var unique_id = ρσ_modules.dom.unique_id;
        var clear = ρσ_modules.dom.clear;

        var E = ρσ_modules.elementmaker.E;

        var local_storage = ρσ_modules.session.local_storage;

        var CompletionPopup = ρσ_modules.popups.CompletionPopup;

        var uniq = ρσ_modules.utils.uniq;

        function EditWithComplete() {
            if (this.ρσ_object_id === undefined) Object.defineProperty(this, "ρσ_object_id", {"value":++ρσ_object_counter});
            EditWithComplete.prototype.__bind_methods__.call(this);
            EditWithComplete.prototype.__init__.apply(this, arguments);
        }
        Object.defineProperty(EditWithComplete.prototype, "__bind_methods__", {value: function () {
            this.apply_completion = EditWithComplete.prototype.apply_completion.bind(this);
            this.onkeydown = EditWithComplete.prototype.onkeydown.bind(this);
            this.oninput = EditWithComplete.prototype.oninput.