/*************************************************************
 *
 *  MathJax/jax/output/SVG/fonts/TeX/svg/SansSerif/Italic/BasicLatin.js
 *
 *  Copyright (c) 2011 Design Science, Inc.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */

MathJax.Hub.Insert(
  MathJax.OutputJax.SVG.FONTDATA.FONTS['MathJax_SansSerif-italic'],
  {
    // SPACE
    0x20: [0,0,250,0,0,''],

    // EXCLAMATION MARK
    0x21: [694,0,319,110,355,'160 187L257 694H306Q355 694 355 693L238 186H199Q160 186 160 187ZM110 2Q111 3 120 49T131 96Q131 98 180 98T229 96L219 50Q209 3 208 2V0H110V2'],

    // QUOTATION MARK
    0x22: [694,-471,500,133,472,'171 647L180 694H229Q278 694 278 693L276 686Q275 680 273 668T268 644L258 597L182 471H157Q133 471 133 472L189 595Q189 596 174 596H160V598Q160 601 171 647ZM365 647L374 694H423Q472 694 472 693L470 686Q469 680 467 668T462 644L452 597L376 471H351Q327 471 327 472L383 595Q383 596 368 596H354V598Q354 601 365 647'],

    // NUMBER SIGN
    0x23: [694,194,833,87,851,'793 170Q809 162 809 149Q809 145 807 141T802 135T796 132L793 130H547L472 -27Q397 -184 394 -187Q389 -194 379 -194Q367 -194 362 -183Q359 -179 359 -173Q360 -168 431 -20L503 129Q503 130 410 130H317L242 -27Q167 -184 164 -187Q159 -194 149 -194Q137 -194 132 -183Q129 -179 129 -173Q130 -168 201 -19L273 130H187L100 131Q87 141 87 150Q87 162 102 170H294L331 248Q339 265 349 286T365 318L370 328Q370 330 258 330Q145 330 142 332Q129 338 129 351Q129 362 140 368Q146 370 267 370L391 371L467 527Q542 684 544 686Q544 688 549 691T560 694H562Q565 693 567 692T571 690T575 686T578 681T579 672Q577 665 507 520T436 373L435 370H528L621 371L692 518Q767 675 769 677Q775 694 789 694Q798 694 804 688T809 672Q806 664 737 519L665 371L751 370Q835 370 841 368Q851 362 851 350Q851 337 841 334T799 330H765H741H645L606 250L568 170H793ZM600 328Q600 330 508 330H415Q412 326 338 171Q338 170 431 170H524L561 248Q569 265 579 286T595 318L600 328'],

    // DOLLAR SIGN
    0x24: [750,56,500,56,565,'228 70Q233 92 246 155T270 266T280 316Q271 318 265 320T237 333T200 360T172 403T159 468Q159 537 205 600T325 691Q352 701 360 701Q361 701 361 701T362 703T364 711T368 727L372 750H409Q445 750 445 749L436 705Q436 703 450 702T494 691T554 657L565 649Q562 642 548 604L534 568Q511 591 484 605T440 621L424 623L419 624L372 405Q399 400 424 384Q490 338 490 247V240Q490 156 430 85Q374 13 294 -5L284 -7L280 -30Q279 -35 278 -41T275 -52L274 -55Q274 -56 237 -56Q201 -56 201 -54Q202 -53 205 -34T211 -11Q211 -9 206 -9Q154 -2 115 19Q80 35 56 59L88 141L99 131Q109 121 119 113T141 99T160 89T180 82T197 77T214 73T228 70ZM303 426Q304 427 313 471T332 564T345 620L335 616Q287 596 263 549Q252 525 252 499Q252 470 267 451T298 426Q303 424 303 426ZM302 75Q305 75 315 80T340 98T367 125T390 164T399 214Q399 247 384 268T349 297Q338 247 326 186L302 75'],

    // PERCENT SIGN
    0x25: [750,56,833,165,815,'268 347Q224 347 195 386T165 488Q165 517 173 552Q191 637 246 693T349 749Q389 749 414 725T448 673T456 614Q456 506 396 427T268 347ZM372 604Q372 674 339 674Q311 674 290 633T261 549T253 482V474Q253 438 272 426Q277 424 286 424Q319 424 345 485T372 604ZM189 -56Q179 -56 173 -49T167 -37Q167 -30 347 198Q425 296 475 360Q780 745 785 747Q790 750 796 750Q814 748 814 730Q814 725 811 719L204 -49Q198 -56 189 -56ZM523 87Q523 184 583 265T713 347Q758 347 786 308T815 207Q815 110 757 28T629 -55Q576 -55 550 -12T523 87ZM729 200Q729 271 696 271Q675 271 658 247T631 189T616 125T611 76Q611 21 644 21H647Q672 21 700 77T729 200'],

    // AMPERSAND
    0x26: [716,22,758,71,747,'219 -22Q158 -22 117 13T71 111Q71 131 74 150T84 185T98 215T118 241T137 262T159 281T179 295T199 308L214 318L258 348L256 362Q254 373 254 413V435Q254 483 271 537T325 641T411 708Q427 715 441 715Q446 716 455 716Q504 716 534 681T565 590Q565 522 519 468T377 347L358 334Q359 333 363 320T374 290T387 262Q404 227 428 187T460 139Q521 183 574 251T651 362T674 409L710 398Q746 388 747 388Q747 381 720 333T635 213T517 94L510 87Q542 57 598 57Q649 57 708 72Q716 75 718 75L709 34L701 -7Q636 -22 578 -22Q531 -22 498 -8T428 34L408 25Q314 -22 219 -22ZM480 579Q480 640 436 640Q410 640 385 615T351 554Q340 513 340 457Q340 413 343 410Q343 406 360 419Q431 471 455 505T480 579ZM245 57Q279 59 311 67T359 81T375 89T358 113T318 178T281 260L274 277L245 257Q167 205 167 135Q167 110 174 93T194 69T217 60T237 57H245'],

    // APOSTROPHE
    0x27: [694,-471,278,190,335,'228 647L237 694H286Q335 694 335 693L334 686Q332 680 330 668T325 644L315 597L239 471H214Q190 471 190 472L246 595Q246 596 231 596H217V598Q217 601 228 647'],

    // LEFT PARENTHESIS
    0x28: [750,250,389,104,491,'195 37Q195 -7 200 -47T213 -113T231 -166T250 -204T268 -232T280 -250H204L194 -238Q104 -124 104 55Q104 238 181 432T405 740L417 750H454Q491 750 491 749L468 729Q446 709 411 667T337 565T262 405T208 188Q195 110 195 37'],

    // RIGHT PARENTHESIS
    0x29: [750,250,389,2,390,'300 463Q300 634 222 740L214 750H290L299 740Q300 738 309 726T323 707T337 682T353 651T367 613T379 566T387 510T390 444Q390 314 344 156T203 -125Q179 -155 145 -191Q111 -224 89 -241L78 -250H2Q4 -248 27 -227T65 -189T107 -140T155 -71T200 16T244 129T278 266Q300 372 300 463'],

    // ASTERISK
    0x2A: [750,-306,500,156,568,'193 608Q193 628 210 644T246 660Q250 660 252 660T257 658T264 654T272 648T284 638T302 623Q340 590 340 593Q341 594 345 623T354 682T360 715Q365 729 378 739T407 750Q424 750 433 740T443 720Q443 712 427 652L410 591L462 623Q505 650 514 655T534 660Q549 660 558 650T568 625Q568 617 567 611T560 599T551 590T536 580T519 571T496 561T470 548L429 528L474 500Q482 495 492 489T506 481T516 475T523 469T527 464T529 458T530 450Q530 430 514 414T479 397H475Q468 397 460 402T423 433Q414 440 404 448T388 461L383 465L365 344Q348 306 314 306Q302 306 292 313T281 338Q281 347 297 404L313 464L260 433Q201 397 195 397H189Q173 397 165 407T156 432Q156 438 157 443T161 452T166 460T175 468T185 475T198 482T212 489T230 497T250 506L295 528L250 556Q203 582 202 585Q193 591 193 608'],

    // PLUS SIGN
    0x2B: [583,83,778,108,775,'108 244T108 250T112 261T119 268T124 270H426V272Q428 274 457 419Q489 565 492 573Q497 583 508 583Q516 583 522 577T528 565Q528 553 498 417Q491 384 483 346T471 288L467 270H760Q775 262 775 250T760 230H458Q456 221 426 77T394 -71Q389 -83 375 -83Q367 -83 362 -78T356 -64Q356 -58 387 84Q394 118 401 155T413 210L417 229Q417 230 271 230H124Q123 230 120 232T112 239'],

    // COMMA
    0x2C: [98,125,278,63,209,'90 2Q91 3 100 49T111 96Q111 98 160 98T209 96L199 50Q189 3 188 2Q188 0 149 -63L112 -125H63L120 0H105Q90 0 90 2'],

    // HYPHEN-MINUS
    0x2D: [259,-186,333,51,332,'66 257V259H332V257L324 220L317 186H184Q51 186 51 187T58 220T66 257'],

    // FULL STOP
    0x2E: [98,0,278,90,209,'90 2Q91 3 100 49T111 96Q111 98 160 98T209 96L199 50Q189 3 188 2V0H90V2'],

    // SOLIDUS
    0x2F: [750,250,500,6,600,'564 744L568 747Q573 750 579 750Q588 750 594 744T599 729Q597 721 321 241T41 -243Q37 -250 27 -250Q6 -250 6 -230Q6 -228 8 -222Q9 -219 285 261T564 744'],

    // DIGIT ZERO
    0x30: [678,22,500,87,549,'245 -22Q209 -22 181 -11T135 20T107 65T92 116T88 171Q88 235 114 354T194 557Q226 606 269 635T340 671T392 678H395Q422 678 446 670T495 643T534 582T549 481Q549 430 534 350T499 213Q459 89 379 25Q315 -22 247 -22H245ZM430 582Q408 601 378 601Q313 601 269 534Q234 475 205 341Q181 232 181 174Q181 104 209 76Q231 54 260 54T318 73T368 125Q410 194 447 375Q460 445 460 487Q460 555 430 582'],

    // DIGIT ONE
    0x31: [678,0,500,88,451,'234 613Q277 613 331 628T428 678H439Q451 678 451 676Q450 671 387 373T323 74T384 73H445L430 0H259L88 1L104 73H229L332 560Q278 541 198 539Q198 540 198 541T199 546T200 554T202 564T205 576L213 612H219Q221 612 226 612T234 613'],

    // DIGIT TWO
    0x32: [678,0,500,50,551,'190 460Q189 460 181 475T164 507T155 527Q155 535 182 571Q259 678 380 678Q462 678 506 630T551 513V507Q551 418 487 349Q469 329 441 305T391 265T344 232T316 212Q158 87 158 86T188 85Q194 85 234 85T311 86Q467 86 467 85Q451 9 449 2V0H50Q54 18 58 40L67 79L133 133Q246 226 269 243Q369 318 410 373T452 492Q452 535 433 560T393 592T350 599Q311 599 279 578T231 532T203 484T190 460'],

    // DIGIT THREE
    0x33: [678,23,500,56,544,'446 542Q446 576 424 590T372 605Q330 605 288 583T216 524Q209 515 208 516Q207 517 192 549L178 580L187 589Q224 627 276 652T386 678Q456 678 500 642T544 550Q544 515 530 482T495 427T453 387T418 362L403 353L413 348Q440 335 462 313Q500 271 500 217Q500 135 423 57T236 -22T63 59L56 68L85 141Q106 112 125 98Q177 54 254 54Q315 54 355 105T396 218Q396 242 393 254Q380 301 335 313Q327 315 280 316Q233 316 233 318L249 392Q298 392 322 399Q373 408 409 453T446 542'],

    // DIGIT FOUR
    0x34: [656,0,500,62,521,'78 235L411 656H465Q519 656 519 655T475 447T430 237V235H521V233L505 160Q505 159 459 159H414L380 0H286L320 159H62L63 164Q64 169 66 179T70 198L78 235ZM342 235L421 607Q420 607 419 604Q409 535 197 267Q173 236 173 235H342'],

    // DIGIT FIVE
    0x35: [656,22,500,49,555,'330 350Q263 350 214 272H133V275Q134 276 174 467L214 655Q214 656 385 656H555V653Q555 652 554 647T550 631T546 613L539 577H284L265 486Q261 464 256 441T248 406L246 395L250 398Q255 401 264 406T286 415T315 423T350 427Q412 427 455 381T498 256Q498 150 415 64T222 -22Q186 -22 155 -12T105 12T74 41T55 65T50 77L51 79Q61 89 78 112L104 145L107 138Q110 130 114 123T125 106T142 88T165 72T196 60T236 55Q282 55 316 79T366 140T389 208T396 267Q396 310 378 330T337 350H330'],

    // DIGIT SIX
    0x36: [678,22,500,94,548,'437 605Q397 605 361 585T301 536T261 477T236 426T228 401L236 408Q244 414 260 424T296 445T345 462T402 469H404Q422 469 434 467T465 446T498 394Q515 351 515 307Q515 254 497 193T439 85Q352 -22 246 -22Q220 -22 196 -14T148 15T109 78T94 179Q94 272 123 373Q163 505 257 591T450 678Q474 678 498 674T535 664T548 656L540 621L532 586L520 590Q509 594 485 599T437 605ZM339 392Q281 392 233 334T185 163V158Q185 87 230 61Q244 54 262 54Q325 54 371 122Q395 158 407 217T419 298Q419 337 401 364T339 392'],

    // DIGIT SEVEN
    0x37: [656,11,500,143,596,'173 614L181 656H389Q596 656 596 655L595 650Q594 645 592 635T588 616L580 578L554 551Q313 307 245 4L242 -11H192Q143 -11 143 -10Q144 0 148 17T169 89T212 198T285 327T393 470Q423 504 472 550Q479 555 485 561T496 571L329 570Q163 570 163 571L164 577Q166 583 168 593T173 614'],

    // DIGIT EIGHT
    0x38: [678,22,500,77,554,'159 470Q159 547 229 612T394 678Q467 678 510 636T554 533Q554 512 549 493T535 458T515 429T492 405T467 386T443 372T423 362T409 356L404 354Q404 353 405 353Q411 353 432 341T476 295T500 218Q500 134 424 56T246 -22Q175 -22 126 22T77 143Q77 204 110 251T188 327L202 334Q216 340 229 346T243 353T235 358T214 372T189 393T168 426T159 470ZM467 527Q467 605 375 605Q317 605 281 566T244 472Q244 429 271 411T334 392Q392 392 429 430T467 527ZM405 228Q405 262 384 289T315 316Q257 316 216 266T174 144Q174 95 199 75T262 54Q329 54 367 109T405 228'],

    // DIGIT NINE
    0x39: [677,22,500,77,545,'220 594Q303 677 389 677Q545 677 545 479Q545 413 526 327Q493 175 398 77T202 -22Q124 -22 77 25L130 91L137 83Q169 54 218 54Q255 54 290 76T347 129Q364 151 380 182T403 232T411 256Q410 255 390 241T353 217T303 197T236 187Q195 187 173 209Q155 226 140 263T124 352Q124 392 135 435Q154 527 220 594ZM455 497Q455 605 383 605Q340 605 305 577T246 492Q220 411 220 360Q220 278 279 264Q280 264 287 264T299 263Q347 263 387 302Q455 375 455 497'],

    // COLON
    0x3A: [444,0,278,90,282,'174 396L184 444H233Q282 444 282 443Q277 421 272 394L262 346H213Q164 346 164 347Q169 369 174 396ZM90 2Q91 3 100 49T111 96Q111 98 160 98T209 96L199 50Q189 3 188 2V0H90V2'],

    // SEMICOLON
    0x3B: [444,125,278,63,282,'174 396L184 444H233Q282 444 282 443Q277 421 272 394L262 346H213Q164 346 164 347Q169 369 174 396ZM90 2Q91 3 100 49T111 96Q111 98 160 98T209 96L199 50Q189 3 188 2Q188 0 149 -63L112 -125H63L120 0H105Q90 0 90 2'],

    // EQUALS SIGN
    0x3D: [370,-130,778,88,796,'142 368Q145 370 463 370Q780 370 784 368Q796 364 796 350T784 332Q780 330 463 330Q145 330 142 332Q129 338 129 351Q129 362 142 368ZM88 137T88 150T102 170H738Q739 170 742 168T750 161T754 150T750 139T743 132T738 130H102Q88 137 88 150'],

    // QUESTION MARK
    0x3F: [704,0,472,173,536,'194 652Q194 654 218 666T284 691T362 704Q444 704 490 678T536 583Q536 541 516 500T459 433Q415 400 387 371T343 313T321 266T307 216L301 186H262Q223 186 223 187Q224 199 228 218T250 288T294 377Q317 413 344 440T391 481T414 499Q442 527 442 574Q442 584 441 590T433 607T409 623T362 629Q335 629 310 624T267 610T235 595T214 582T205 576L200 614Q194 651 194 652ZM173 2Q174 3 183 49T194 96Q194 98 243 98T292 96L282 50Q272 3 271 2V0H173V2'],

    // COMMERCIAL AT
    0x40: [705,10,667,120,707,'120 267Q120 377 179 478T336 642T538 705Q610 705 658 662T707 513Q707 425 681 331Q658 241 590 179T447 117Q386 117 343 163T300 288Q300 397 374 486T544 576Q575 576 608 562Q590 628 517 628Q406 628 309 522T212 278Q212 179 267 122T404 65T550 91H631Q513 -10 390 -10Q265 -10 193 70T120 267ZM600 397Q600 441 581 471T530 501Q476 501 433 436T390 298Q390 254 409 224T462 193Q512 193 556 257T600 397'],

    // LATIN CAPITAL LETTER A
    0x41: [694,0,667,28,638,'28 0L429 694H533L585 350Q596 275 610 182T632 46L638 3V0H530L528 18Q527 25 515 103T503 183H223L135 29L118 1L73 0H28ZM492 254Q492 256 473 398T454 589V610Q433 552 290 301L264 255L378 254H492'],

    // LATIN CAPITAL LETTER B
    0x42: [694,0,667,90,696,'501 363Q557 355 605 316T653 222Q653 148 586 85T403 2Q394 1 240 0Q90 0 90 1L100 46Q109 90 128 177T164 348L238 694H375Q518 693 546 688Q614 674 655 635T696 544Q696 490 648 441T516 368L501 363ZM601 530Q601 568 566 590T479 621Q472 622 394 623H320L297 513Q292 489 286 459T276 415L273 401V399H339H372Q504 399 571 466Q601 498 601 530ZM257 322Q256 320 230 197T203 73Q203 71 289 71Q379 72 387 73Q459 84 507 122T556 210Q556 255 519 283T428 320Q415 322 336 323Q257 323 257 322'],

    // LATIN CAPITAL LETTER C
    0x43: [705,10,639,124,719,'124 266Q124 372 179 473T333 639T544 705Q592 705 635 697T698 679L718 670Q719 669 701 621T681 572L676 576Q670 580 661 586T641 598T614 611T583 620Q558 625 526 625Q406 625 318 516T230 276Q230 238 236 212Q251 148 294 108T412 68Q469 68 508 80T598 123Q608 129 608 128Q606 109 603 87L598 45L573 33Q521 7 486 -1T394 -10Q358 -10 346 -8Q260 5 202 62Q124 145 124 266'],

    // LATIN CAPITAL LETTER D
    0x44: [694,0,722,88,747,'162 348L236 694H385Q535 693 543 692Q600 682 641 654T705 586T737 506T747 425Q747 296 672 187Q625 114 548 62T384 1Q376 0 262 0Q88 0 88 1L98 46Q107 90 126 177T162 348ZM622 533Q575 624 443 624Q434 624 419 624T399 623H321L263 348Q249 283 234 213T212 107L204 72Q204 71 289 71Q374 72 386 74Q501 94 573 193T646 422Q646 487 622 533'],

    // LATIN CAPITAL LETTER E
    0x45: [691,0,597,86,688,'86 2Q88 4 160 346T233 689Q233 691 461 691Q688 691 688 689Q685 686 671 611H495L320 612L319 609Q319 607 297 501L274 397H436Q597 397 597 396L596 391Q595 386 593 376T589 358L581 322L420 321Q258 321 258 320Q209 89 208 87Q208 85 390 85Q417 85 460 85T518 86L572 85Q556 8 554 2V0H86V2'],

    // LATIN CAPITAL LETTER F
    0x46: [691,0,569,86,673,'86 2Q88 4 160 346T233 689Q233 691 453 691T673 689Q670 686 656 611H488L320 612Q314 579 302 523T281 427T272 385Q272 384 419 384H567L551 308H255L223 156Q216 124 207 82T194 20L190 2Q190 0 138 0H86V2'],

    // LATIN CAPITAL LETTER G
    0x47: [705,11,667,125,730,'125 267Q125 375 182 476T337 641T544 705Q598 705 644 693T710 669T730 655L712 609L693 560L692 557L681 567Q618 626 526 626Q447 626 378 573T269 440T229 277Q229 185 276 127T406 68Q422 68 451 71T502 78T524 84L526 93Q528 102 532 119T539 153L553 222Q553 223 495 223Q436 223 436 224Q436 230 444 262L452 299H662V296Q661 290 635 166T607 40Q606 37 576 25T492 1T391 -11Q272 -11 199 66T125 267'],

    // LATIN CAPITAL LETTER H
    0x48: [694,0,708,86,768,'517 2Q518 3 551 161T585 322Q586 323 557 323T422 323H259L190 0H138Q86 0 86 1L96 46Q105 90 124 177T160 348L234 694H337V691Q336 690 306 545T275 399H602L603 403Q603 407 634 551L665 694H768V691Q768 690 695 348T621 2V0H517V2'],

    // LATIN CAPITAL LETTER I
    0x49: [694,0,278,87,338,'161 348L235 694H338V691Q338 690 265 348T191 2V0H139Q87 0 87 1L96 46Q106 90 125 177T161 348'],

    // LATIN CAPITAL LETTER J
    0x4A: [694,22,472,46,535,'377 424L435 694H535V691Q534 685 476 412T416 135Q401 74 350 26T210 -22Q165 -22 124 -11T65 9T46 21L54 41Q62 61 70 83T81 109Q82 111 85 106Q86 105 87 103Q93 94 103 84T135 64T185 53Q238 53 272 76T317 142Q317 145 325 182T348 289T377 424'],

    // LATIN CAPITAL LETTER K
    0x4B: [694,0,694,88,784,'236 223Q235 222 213 113T188 2V0H138Q88 0 88 1L98 46Q107 90 126 177T162 348L236 694H285Q335 694 335 693L330 671Q326 649 316 603T298 518Q289 477 280 433T266 366L261 343L672 694H729L784 693L465 420L651 0H596L541 1L384 350Q383 351 310 288T236 223'],

    // LATIN CAPITAL LETTER L
    0x4C: [694,0,542,87,516,'161 348L235 694H338V691Q338 690 273 385T208 79Q278 80 362 80H516Q502 11 499 2V0H293Q87 0 87 1L96 46Q106 90 125 177T161 348'],

    // LATIN CAPITAL LETTER M
    0x4D: [694,0,875,92,929,'375 691Q456 215 459 124V106Q488 177 762 641L793 694H929V691Q929 690 856 348T782 2V0H689V2Q691 4 753 304Q817 604 818 606Q819 611 817 608Q817 607 815 603Q798 559 540 117L484 22H440L397 23L393 42Q393 47 373 169T334 422T315 594V609L250 306Q186 3 185 2Q185 0 138 0Q92 0 92 1L102 46Q111 90 130 177T166 348L240 694H375V691'],

    // LATIN CAPITAL LETTER N
    0x4E: [694,0,708,88,766,'311 609Q310 608 246 306T181 2V0H134Q88 0 88 1L98 46Q107 90 126 177T162 348L236 694H382L383 691Q383 688 418 561T493 286T541 97L544 84L545 89Q545 90 553 128T578 246T610 394L674 694H766V691Q766 690 693 348T619 2V0H472L469 13Q468 17 393 293T312 605L311 609'],

    // LATIN CAPITAL LETTER O
    0x4F: [716,23,736,118,763,'118 254Q118 366 174 473T324 648T517 716Q627 716 695 638T763 435Q763 321 706 215T555 43T362 -22Q256 -22 187 56T118 254ZM380 58Q452 58 518 116T622 263T661 442Q661 496 646 535T608 594T567 622T534 634Q516 636 496 636Q400 636 313 528T225 264Q225 172 267 115T380 58'],

    // LATIN CAPITAL LETTER P
    0x50: [694,0,639,88,690,'162 348L236 694H378Q522 693 530 692Q604 680 647 635T690 524Q690 474 665 430T612 359Q550 299 465 280Q443 275 343 274H250V271Q250 269 235 201T206 68T192 2V0H140Q88 0 88 1L98 46Q107 90 126 177T162 348ZM594 513Q594 560 562 588T477 622Q470 623 394 623H321L293 487L263 349V347H342H347H375Q530 347 578 449Q594 483 594 513'],

    // LATIN CAPITAL LETTER Q
    0x51: [716,125,736,118,763,'118 254Q118 366 174 473T324 648T517 716Q627 716 695 638T763 435Q763 305 693 194T543 36Q547 29 586 -47T625 -125H504L450 -8Q406 -22 363 -22Q256 -22 187 56T118 254ZM661 437Q661 532 616 584T506 636Q428 636 361 578T257 433T220 258Q220 167 264 113T380 58Q390 58 397 58T408 59T413 60T417 61Q417 63 387 127T356 193Q356 194 409 194H462L485 150L508 105Q509 103 532 125T567 161Q661 278 661 437'],

    // LATIN CAPITAL LETTER R
    0x52: [694,0,646,88,698,'162 348L236 694H375H414H445Q507 694 538 690T606 668Q698 623 698 534V528Q698 447 608 377Q582 358 555 345T512 326L497 321L617 0H565L513 1L402 309H255L189 0H138Q88 0 88 1L98 46Q107 90 126 177T162 348ZM603 525Q603 603 499 620Q486 622 403 623H321L297 506Q292 482 285 449T274 402L271 387V385H346Q350 385 363 385T386 384Q548 384 592 479Q603 503 603 525'],

    // LATIN CAPITAL LETTER S
    0x53: [716,22,556,54,609,'161 478Q161 568 242 642T435 716Q527 716 599 673L609 667Q595 633 589 615L571 568Q570 568 564 575T546 592T518 611T475 628T417 635Q351 635 305 596T259 507Q259 465 290 444T372 411T432 396Q473 385 509 343T545 236Q545 140 464 59T270 -22Q155 -22 54 48L92 146Q93 146 101 138T124 117T161 92T216 72T288 63Q360 63 403 109T447 204Q447 220 444 233T435 256T421 273T404 285T385 295T366 301T347 306T331 310T315 314T292 321T265 331T235 346T207 367T183 395T168 431T161 478'],

    // LATIN CAPITAL LETTER T
    0x54: [688,0,681,165,790,'165 608L182 687Q182 688 486 688H790L789 685L781 645L773 609H521L457 306Q393 3 392 2Q392 0 340 0H288V2Q289 5 353 304T417 605V609L291 608H165'],

    // LATIN CAPITAL LETTER U
    0x55: [694,22,688,131,747,'340 -22Q251 -22 191 33T131 177V187Q131 192 131 195T132 205T133 215T136 231T141 253T147 285T156 328T168 384T184 457L235 694H338V691Q338 690 288 451T236 210Q234 194 234 177Q234 138 247 111T280 72T319 54T357 49Q408 49 449 74T510 128Q516 136 521 143T530 158T538 175T545 194T553 220T560 250T569 289T579 336T591 395T606 464L655 694H747V691Q651 243 645 213Q623 149 587 102Q482 -22 340 -22'],

    // LATIN CAPITAL LETTER V
    0x56: [694,0,667,161,799,'220 348L161 694H216Q270 694 270 693L283 613Q334 313 346 215Q359 102 359 96Q359 87 358 84Q388 162 684 657L706 694H753Q799 694 799 693L387 0H333Q279 0 279 1L272 45Q264 89 249 177T220 348'],

    // LATIN CAPITAL LETTER W
    0x57: [694,0,944,161,1076,'596 540Q596 562 597 585T599 609Q599 588 436 255Q402 185 362 104L310 0H213V3Q213 6 188 347T161 694H263L265 664Q290 327 293 184Q293 112 289 85Q290 85 290 87Q290 95 301 123T332 194T373 282T419 380T463 469T498 541T517 579L574 694H671V689L674 646Q678 603 682 538T691 401T699 263T703 160Q703 102 700 87Q719 154 930 576L989 694H1076Q1076 693 903 347L730 0H628V4L626 26Q624 48 622 85T616 168T609 267T603 369T598 464T596 540'],

    // LATIN CAPITAL LETTER X
    0x58: [694,0,667,14,758,'14 0Q17 3 184 184T352 367L265 529Q244 567 222 609T188 672L176 692Q176 694 236 694H297L338 612Q387 515 400 489L421 448L645 694H758L708 640Q481 393 456 368Q455 366 500 281T596 104T652 0H531L388 293L128 0H14'],

    // LATIN CAPITAL LETTER Y
    0x59: [694,0,667,151,809,'151 692Q151 694 212 694H272L418 362L696 683L705 694H758L809 693Q809 692 630 490T444 280Q442 275 413 139L383 1L333 0Q282 0 282 2Q283 3 312 141L341 278L246 484L151 692'],

    // LATIN CAPITAL LETTER Z
    0x5A: [694,0,611,55,702,'67 54Q551 615 551 617Q543 618 517 618Q510 618 463 618T376 617Q200 617 200 618T209 657L216 694H459Q702 694 702 692Q702 689 697 667L692 643L207 80H392Q493 81 577 81Q577 70 560 2V0H55V2L67 54'],

    // LEFT SQUARE BRACKET
    0x5B: [750,250,289,41,425,'148 252L253 750H339Q425 750 425 749L424 744Q423 739 421 729T417 711L409 675L367 674H325L235 252Q145 -167 145 -172Q145 -174 187 -174H229V-176Q213 -240 213 -250H127Q41 -250 41 -248Q41 -245 148 252'],

    // RIGHT SQUARE BRACKET
    0x5D: [750,250,289,-31,353,'353 749Q353 746 303 512T200 27T141 -250H-31Q-31 -240 -15 -176V-174H70L250 674H208L165 675L181 750H267Q353 750 353 749'],

    // CIRCUMFLEX ACCENT
    0x5E: [694,-527,500,190,533,'190 527L360 694H434L484 611Q533 528 533 527H457L390 632L385 639L266 527H190'],

    // LOW LINE
    0x5F: [-38,114,500,50,565,'59 -75L66 -38H316Q565 -38 565 -39T558 -75T549 -112Q549 -114 299 -114Q50 -114 50 -113L52 -108Q53 -103 55 -93T59 -75'],

    // LATIN SMALL LETTER A
    0x61: [461,10,481,61,473,'313 386Q286 386 260 381T217 369T186 355T164 342T155 337Q154 338 159 377T165 418Q251 461 320 461Q322 461 328 461T337 460Q397 460 435 424T473 329Q473 325 473 318T472 308Q432 110 407 2V0H317V2L325 38Q295 21 269 10Q215 -10 156 -10H149Q76 -10 62 69Q61 75 61 90Q61 127 73 150T116 194Q146 215 207 231T348 252H368L373 277Q378 302 378 318Q378 367 339 384Q332 386 313 386ZM150 116Q150 93 171 79T223 65Q259 65 293 85T341 135Q343 140 348 160T353 184Q353 186 342 186Q298 186 231 174T153 134Q150 127 150 116'],

    // LATIN SMALL LETTER B
    0x62: [694,11,517,75,539,'302 -11Q266 -11 235 1T190 26L176 38Q170 8 168 2V0H121Q75 0 75 1L84 46Q94 90 113 177T149 348L223 694H267Q312 694 312 693T282 551T251 407Q251 406 256 408T271 415Q347 454 430 454H438Q501 454 528 374Q539 339 539 299Q539 179 466 84T302 -11ZM443 275Q443 317 421 348T346 379Q318 379 296 369Q269 359 238 332L193 118L198 109Q220 65 269 65Q350 65 396 130T443 275'],

    // LATIN SMALL LETTER C
    0x63: [460,11,444,74,499,'75 164Q75 226 100 282T165 377T252 437T342 460H347Q447 460 499 417L483 378Q468 339 468 338Q466 338 455 347T424 366T385 378Q355 382 334 382Q262 382 215 318T168 177Q168 120 196 95T259 69H269Q345 69 420 108Q432 114 432 113T427 72L422 32L402 22Q382 12 344 2T259 -11Q214 -11 180 2T126 36T95 81T79 126T75 164'],

    // LATIN SMALL LETTER D
    0x64: [694,10,517,73,588,'73 156Q73 224 102 293T184 408T294 455Q375 455 432 413Q438 407 438 410T469 553L499 694H588V691Q588 690 515 348T441 2V0H348V2Q357 29 357 43L352 41Q332 24 288 7T196 -10H190Q178 -10 166 -7T134 8T98 46T75 113Q73 129 73 156ZM419 335Q419 339 412 348T386 368T342 379Q284 379 243 343T184 261T167 168Q167 122 191 94T263 66Q321 66 367 116L374 124L397 229Q419 333 419 335'],

    // LATIN SMALL LETTER E
    0x65: [460,11,444,71,472,'248 -11Q170 -11 121 41T71 173Q71 265 133 349T285 454Q305 460 318 460H328Q368 460 399 448Q472 414 472 309Q472 274 464 234L462 219H159Q156 198 156 185Q156 137 179 107T237 68Q246 66 268 66Q345 66 427 113V109Q426 108 422 73T417 37Q417 34 409 29Q329 -11 248 -11ZM401 299Q399 337 376 361T316 385Q291 385 266 371Q220 350 184 289H401V299'],

    // LATIN SMALL LETTER F
    0x66: [705,0,306,94,494,'381 443Q381 440 374 407T366 371H315Q263 371 263 369Q262 368 224 186Q215 145 205 97T189 25L184 2V0H94V2L99 25Q104 48 114 96T134 186Q172 368 173 369Q173 371 139 371H106V373L114 410L121 444H155L188 445L191 455L212 551Q232 612 288 658T415 705Q438 705 464 701T494 694Q478 614 477 614L467 618Q457 621 440 624T406 629H400Q333 629 306 579Q301 568 289 507L275 444H328Q381 444 381 443'],

    // LATIN SMALL LETTER G
    0x67: [455,206,500,12,568,'113 252Q113 334 177 394T311 454Q332 454 350 451T379 442T398 432T410 424L413 421Q412 423 411 424L409 426Q409 429 434 436T496 449T560 455H568V451Q568 447 567 429T566 394L565 377L553 379Q522 385 479 385Q463 385 456 384L443 383L436 392Q454 357 454 324Q454 243 390 182T249 120Q233 120 219 122T195 128T178 136T167 142L163 145Q149 131 149 105Q149 78 171 72L242 71Q246 71 269 71T303 71T336 68T372 62T403 51T432 32Q461 8 461 -40Q461 -112 383 -159T211 -206Q123 -206 68 -172T12 -86Q12 -55 31 -23T82 32Q90 38 89 39Q89 40 87 44T82 59T80 82Q80 134 126 189Q113 228 113 252ZM369 319Q369 354 350 368T304 383Q274 383 252 369T218 333T202 291T197 255Q197 221 217 206T263 191Q317 191 343 233T369 319ZM373 -59Q373 -41 362 -30T330 -13T291 -7T247 -5H216Q167 -5 158 -6T139 -12Q123 -20 110 -38T97 -76Q97 -102 133 -118T221 -134Q242 -134 267 -130T316 -118T357 -94T373 -59'],

    // LATIN SMALL LETTER H
    0x68: [694,0,517,73,513,'416 321Q416 379 336 379Q276 379 237 302Q226 276 209 202T180 66T166 2V0H119Q73 0 73 1L82 46Q92 90 111 177T147 348L221 694H265Q310 694 310 693T279 544L247 395Q325 455 403 455Q513 455 513 358Q513 334 508 309Q507 304 476 156T443 2V0H350V2L357 34Q364 65 373 110T392 200T409 281T416 321'],

    // LATIN SMALL LETTER I
    0x69: [680,0,239,74,315,'189 578Q190 579 199 627T211 678V680H315V678Q313 675 304 627T293 578V576H189V578ZM168 442T168 443T213 444T258 443T212 225T164 2V0H74V2Q75 7 121 224'],

    // LATIN SMALL LETTER J
    0x6A: [680,204,267,-96,336,'211 577L233 680H284Q336 680 336 679L315 576H263Q211 576 211 577ZM19 -204Q-12 -204 -40 -196T-82 -179T-96 -170Q-96 -168 -78 -132L-61 -95L-54 -103Q-32 -126 3 -126Q26 -126 50 -116Q76 -101 83 -85Q84 -79 140 180T196 443Q196 444 241 444T286 443Q286 441 232 186T175 -75Q163 -120 122 -162T19 -204'],

    // LATIN SMALL LETTER K
    0x6B: [694,0,489,76,542,'150 348L224 694H310V691Q218 259 218 258L232 270Q245 281 274 306T327 351L435 444H489L542 443Q542 442 443 357L344 272L471 1L422 0H372L366 14Q359 27 347 54T323 105L273 210Q271 210 231 174L190 139L160 0H118Q76 0 76 1L86 46Q95 90 114 177T150 348'],

    // LATIN SMALL LETTER L
    0x6C: [694,0,239,74,311,'148 348L222 694H311V691Q311 690 238 348T164 2V0H119Q74 0 74 1L84 46Q93 90 112 177T148 348'],

    // LATIN SMALL LETTER M
    0x6D: [455,0,794,73,790,'416 321Q416 379 336 379Q276 379 237 302Q226 276 209 202T180 66T166 2V0H119Q73 0 73 2L121 226L169 449Q169 450 213 450H256L249 421Q248 417 247 412T246 404T245 398T244 394T244 392Q250 398 261 407T307 433T379 454H392H400Q451 454 472 439Q482 434 489 427T500 412T506 399T510 388L511 384Q511 384 517 388Q563 431 620 446Q648 455 680 455Q790 455 790 358Q790 334 785 309Q784 304 753 156T720 2V0H627V2L634 34Q641 65 650 110T669 200T686 281T693 321Q693 379 613 379Q553 379 514 302Q503 276 486 202T457 66T443 2V0H350V2L357 34Q364 65 373 110T392 200T409 281T416 321'],

    // LATIN SMALL LETTER N
    0x6E: [454,0,517,73,514,'416 321Q416 379 336 379Q276 379 237 302Q226 276 209 202T180 66T166 2V0H119Q73 0 73 2L121 226L169 449Q169 450 213 450H256L249 421Q248 417 247 412T246 404T245 398T244 394T244 392Q250 398 261 407T307 433T379 454H392Q416 454 433 452T470 440T502 411T513 358Q513 334 508 309Q507 304 476 156T443 2V0H350V2L357 34Q364 65 373 110T392 200T409 281T416 321'],

    // LATIN SMALL LETTER O
    0x6F: [461,11,500,69,523,'69 169Q69 238 107 306T211 417T348 461Q419 461 471 412T523 271Q523 161 438 75T247 -11Q170 -11 120 39T69 169ZM432 279Q432 338 401 361T333 385Q280 385 240 352T182 273T164 178Q164 119 195 94T265 68Q306 68 344 94Q380 115 406 169T432 279'],

    // LATIN SMALL LETTER P
    0x70: [455,194,517,34,538,'259 443Q251 405 251 404L260 409Q269 414 286 421T324 436T375 449T434 455Q482 455 510 417T538 303Q538 169 463 79T302 -11Q226 -11 176 39V36Q175 35 151 -80L127 -193Q127 -194 80 -194H34V-191L102 127L169 443Q169 444 214 444T259 443ZM269 65Q332 65 386 124T441 262Q441 304 422 334T370 373Q356 375 339 375Q293 375 238 331L193 118Q200 103 206 94T229 75T269 65'],

    // LATIN SMALL LETTER Q
    0x71: [455,194,517,72,538,'72 149Q72 272 146 363T304 455Q340 455 371 442T409 423T436 398Q438 411 442 427L448 455H538L400 -193Q400 -194 354 -194Q307 -194 307 -193L356 37V41Q355 41 350 38T332 27T302 13Q247 -10 191 -10H179Q138 -10 105 32T72 149ZM414 298Q402 376 341 376Q277 376 223 317T169 182Q169 121 198 93T265 65Q319 65 365 111L377 123L414 298'],

    // LATIN SMALL LETTER R
    0x72: [455,0,342,74,424,'240 377L244 380Q248 384 255 390T272 404T296 419T325 434T361 446T401 454Q403 454 408 454T416 455H424L421 442Q419 435 413 405T406 373Q351 373 294 336T216 237Q213 231 201 173T178 60T164 2V0H119Q74 0 74 2L122 226L170 449Q170 450 213 450H255L247 414Q246 409 245 403T243 393T241 385T240 379T240 377'],

    // LATIN SMALL LETTER S
    0x73: [461,11,383,35,436,'99 299Q99 318 106 341T133 393T195 441T298 461Q336 461 370 453T420 437L436 429Q436 428 421 389T405 350Q356 386 273 386H265Q248 386 237 384T211 371T191 337Q189 329 189 326Q189 320 190 315T194 306T200 299T209 293T218 289T228 285T239 283T251 281T263 278L270 276Q278 275 283 274T298 270T316 264T333 255T351 243T367 228T380 209T388 186T391 157Q391 96 341 43T193 -11Q171 -11 150 -8T114 -1T84 9T61 19T45 28T35 33Q35 36 67 116L76 109Q132 67 211 67Q258 67 279 88T301 135Q301 159 280 170T224 187T180 197Q141 212 120 239T99 299'],

    // LATIN SMALL LETTER T
    0x74: [571,11,361,97,410,'245 68Q267 68 289 75T322 90L334 98Q338 94 338 28V24L324 19Q268 -4 218 -8Q198 -11 177 -11Q118 -11 118 75Q118 98 123 127Q125 137 149 251T174 369Q174 371 135 371H97V373L105 410L112 444H152L192 445L200 478Q208 512 213 541L219 571H261Q303 571 303 570T290 506L276 444H343Q410 444 410 443Q410 440 403 407T395 371H328Q261 371 261 369Q211 152 211 118Q211 68 245 68'],

    // LATIN SMALL LETTER U
    0x75: [444,10,517,90,537,'166 -10H160Q146 -10 137 -8T115 0T97 22T90 63Q90 79 130 268L167 443Q167 444 214 444Q260 444 260 443L224 273Q187 97 187 86Q187 70 202 65T250 59Q303 59 336 83T379 139Q380 143 412 292T444 443Q444 444 491 444Q537 444 537 443T491 225T443 2V0H353V2L361 38L352 34Q344 29 326 22T286 7T232 -5T166 -10'],

    // LATIN SMALL LETTER V
    0x76: [444,0,461,108,540,'177 6L108 442V444H201V442Q202 441 213 371T235 213T246 90V65Q259 117 429 406L450 444H495Q540 444 540 443Q539 442 411 221L282 1L230 0H178L177 6'],

    // LATIN SMALL LETTER W
    0x77: [444,0,683,108,762,'148 5Q147 8 128 222T109 440L108 444H199V442Q200 441 204 385T214 253T219 140Q219 108 215 76Q215 72 214 67V65L215 66Q219 95 278 221L390 444H475V437Q497 203 497 121Q497 90 494 70Q494 67 494 67L496 73Q520 143 654 405L674 444H718Q762 444 762 443L534 1L483 0H432V5Q429 28 422 126T413 283Q413 343 416 370L417 378Q416 377 416 376Q401 303 248 12L242 0H148V5'],

    // LATIN SMALL LETTER X
    0x78: [444,0,461,1,537,'317 229Q453 9 460 0H409L359 1L312 88Q266 176 265 176Q265 177 254 165T223 132T182 88L100 0H1L15 14Q29 28 61 59T118 115L236 229L226 244Q108 433 100 444H201L290 294L438 444H537L528 435Q526 432 512 418T468 376T418 327L317 229'],

    // LATIN SMALL LETTER Y
    0x79: [444,205,461,1,540,'11 -117L20 -120Q28 -124 46 -128T84 -132H100Q124 -122 149 -85Q200 -6 200 1Q200 17 155 204T109 442Q109 444 156 444H203Q203 443 208 419T221 357T235 277T248 190T254 114Q254 81 250 67V65Q251 65 251 67Q256 94 297 177Q339 259 422 397L450 444H540Q540 443 386 186T219 -90Q179 -153 145 -179T73 -205Q52 -205 34 -202Q29 -202 21 -201T7 -198L1 -197Q1 -196 6 -157T11 -117'],

    // LATIN SMALL LETTER Z
    0x7A: [444,0,435,28,494,'129 408L136 444H315Q494 444 494 443Q494 441 489 419L484 396L164 76L291 77Q418 77 418 76T411 41T402 2V0H215Q28 0 28 2L34 27L38 50L360 371L240 370Q121 370 121 371Q124 388 129 408'],

    // TILDE
    0x7E: [327,-193,500,199,560,'330 327Q356 326 388 298T446 269Q470 269 484 327H522Q560 327 560 325L557 316Q554 306 549 292T535 263T512 232T480 208Q453 193 429 193T370 222T315 251Q285 251 275 193H199V197Q214 257 251 292T330 327']
  }
);

MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/SansSerif/Italic/BasicLatin.js");
