/*
 * Calcurse - text-based organizer
 * Copyright (c) 2004-2005 Frederic Culot
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Send your feedback or comments to : calcurse@culot.org
 * Calcurse home page : http://culot.org/calcurse
 *
 */

#include <ncurses.h>
#include <panel.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>

#include "help.h"
#include "vars.h"
#include "utils.h"

/* Draws the help screen */
void help_screen(int which_pan, int colr)
{
	WINDOW *help_win;
	char label[80];
	int x_pos, y_pos;
	int ch;
	int help_row = row - 2;	//size of the help window
	int help_col = col;

	char help_main[] =
	    "Welcome to Calcurse. This is the main help screen.At the bottom of this screen you can see a panel with different fields represented by a letter and a short title.This panel contains all the available actions you can perform when using Calcurse.By pressing one of the letters appearing in this panel, you will be shown a short description of the corresponding action.Press '@' for credits.When finished, press 'Q' to exit help and go back to the main Calcurse screen.";

	char help_r[] =
	    "Pressing 'R' redraws the Calcurse panels.You might want to use this function when you resize your terminal screen for example, and you want Calcurse to take into account the new size of the terminal.This function can also be useful when garbage appears in the display and you want to clean it.";

	char help_s[] =
	    "Pressing 'S' saves the Calcurse data.The data is splitted into three different files which contains :      /  ~/.calcurse/conf -> the user configuration      |  		       (layout, color, general options)      |  ~/.calcurse/apts -> the data related to the appointments      \\  ~/.calcurse/todo -> the data related to the todo listIn the config menu, you can choose to save the Calcurse data automatically before quitting.";

	char help_displacement[] =
	    "Displacement keys :You can use either 'H','J','K','L' or the arrow keys '<','v','^','>'to move into the calendar. The following scheme explains how :                   move to previous week                             K ^   move to previous day   H <       > L   move to next day                             J v                        move to next weekWhen the Appointment or ToDo panel is selected, The up and down keys (respectively K or up arrow, and J or down arrow) allows you to select an item from those lists.";

	char help_v[] =
	    "Pressing 'V' allows you to view the item you select in either the ToDo or Appointment panel.This is usefull when an event description is longer than the available space to display it.If that is the case, the description will be shortened and its end replaced by '...'.To be able to read the entire description, just press 'V' and a popup window will appear, containing the whole event.Press any key to close the popup window and go back to the main CalCurse screen.";

	char help_tab[] =
	    "Pressing 'Tab' allows you to switch between panels.The panel currently in use has its border colorized.Some actions are possible only if the right panel is selected.For example, if you want to add a task in the TODO list, you need first to press the 'Tab' key to get the TODO panel selected. Then you can press 'A' to add your item.Notice that at the bottom of the screen the list of possible actions change while pressing 'Tab', so you always know what action can be performed on the selected panel.";

	char help_g[] =
	    "Pressing 'G' will allow you to go to a specified day without having to travel to that day using the displacement keys in the calendar.If you hit [ENTER] without specifying any date, Calcurse checks the system current date and you will be taken to that date.";

	char help_d[] =
	    "Pressing 'D' deletes an element in the ToDo or Appointment list.Depending on which panel is selected when you press the delete key, the hilighted item of either the ToDo or Appointment list will be removed from this list.If the general option 'confirm_delete' is set to 'YES', then you will be asked for confirmation before deleting the selected event.Do not forget to save the calendar data to retrieve the modifications next time you launch Calcurse.";

	char help_a[] =
	    "Pressing 'A' allows you to add an item in either the ToDo or Appointment list, depending on which panel is selected when you press 'A'.To enter a new item to be added in the APPOINTMENT list, you will need to enter successively the time at which the appointment begins, the appointment length, and the description of the event.The day at which occurs the appointment is the current day selected in the calendar, so you need to move to the desired day before pressing 'A' for entering the informations concerning the appointment.Once the new event description is entered, the appointment panel will be updated on the screen.Note that if an event lasts for such a long time that it continues on the next days, this event will be indicated on all the corresponding days, and the beginning or ending hour will be replaced by '..' if the event does not begin or end on the day.To enter a new item in the TODO list, you only need to enter the description of this new item.Note that if you only press [ENTER] at the APPOINTMENT or TODO event description prompt, without any description, no item will be added.Do not forget to save the calendar data to retrieve the new event next time you launch Calcurse.";

	char help_c[] =
	    "Pressing 'C' leads to the configuration submenu, from which you can select between color, layout, and general options.The color submenu lets you choose the color theme. The layout submenu lets you choose the Calcurse screen layout, in other words where to place the three different panels on the screen.The general options submenu brings a screen with the different options which modifies the way Calcurse interacts with the user.Do not forget to save the calendar data to retrieve your configuration next time you launch Calcurse.";

	char help_credits[] =
	    "Calcurse - text-based organizerCopyright (c) 2004-2005 Frederic CulotThis program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.Send your feedback or comments to : calcurse@culot.orgCalcurse home page : http://culot.org/calcurse";

	x_pos = 4;
	y_pos = 4;
	help_win = newwin(help_row, help_col, 0, 0);
	box(help_win, 0, 0);
	sprintf(label, "CalCurse %s | help", VERSION);
	win_show(help_win, label, colr);
	wrefresh(help_win);
	status_bar(which_pan, colr);
	scroller(help_main, 0, 0, help_row, help_col, colr);

	while ((ch = getch()) != 'q') {
		wclear(help_win);
		box(help_win, 0, 0);
		win_show(help_win, label, colr);
		wnoutrefresh(help_win);
		doupdate();
		switch (ch) {
		case '?':
			scroller(help_main, 0, 0, help_row, help_col,
				 colr);
			break;
		case 'r':
			scroller(help_r, 0, 0, help_row, help_col, colr);
			break;
		case 's':
			scroller(help_s, 0, 0, help_row, help_col, colr);
			break;
		case 'h':
		case 'l':
		case 'j':
		case 'k':
		case 259:
		case 258:
		case 260:
		case 261:
			scroller(help_displacement, 0, 0, help_row,
				 help_col, colr);
			break;

		case 'a':
			scroller(help_a, 0, 0, help_row, help_col, colr);
			break;

		case 'g':
			scroller(help_g, 0, 0, help_row, help_col, colr);
			break;

		case 'd':
			scroller(help_d, 0, 0, help_row, help_col, colr);
			break;

		case 'c':
			scroller(help_c, 0, 0, help_row, help_col, colr);
			break;

		case 'v':
			scroller(help_v, 0, 0, help_row, help_col, colr);
			break;

		case 9:
			scroller(help_tab, 0, 0, help_row, help_col, colr);
			break;

		case '@':
			scroller(help_credits, 0, 0, help_row, help_col,
				 colr);
			break;
		}
	}
	delwin(help_win);
}
