/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2005 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.freedesktop.cairo;

import org.gnu.glib.Handle;

/**
 * The TextExtents stores the extents of a single glyph or a string of glyphs in
 * user-space coordinates. Because text extents are in user-space coordinates,
 * they don't scale along with the current transformation matrix.
 *
 * @deprecated This class is part of the java-gnome 2.x family of libraries,
 *             which, due to their inefficiency and complexity, are no longer
 *             being maintained and have been abandoned by the java-gnome
 *             project. This class may exist in java-gnome 4.0; look out for
 *             <code>org.freedesktop.cairo.TextExtents</code>.
 *             As this package was never correctly implemented in java-gnome 2.x,
 *             any new code written will likely have a considerably different
 *             public API.
 */
public class TextExtents extends CairoObject {

    TextExtents(Handle hndl) {
        super(hndl);
    }

    public double getXBearing() {
        return get_x_bearing(getHandle());
    }

    public double getYBearing() {
        return get_y_bearning(getHandle());
    }

    public double getWidth() {
        return get_width(getHandle());
    }

    public double getHeight() {
        return get_height(getHandle());
    }

    public double getXAdvance() {
        return get_x_advance(getHandle());
    }

    public double getYAdvance() {
        return get_y_advance(getHandle());
    }

    protected void finalize() throws Throwable {
        try {
            free(getHandle());
        } finally {
            super.finalize();
        }
    }

    /*
     * Native calls
     * @deprecated Superceeded by java-gnome 4.0; this method or constant
     *             will no doubt exist conceptually, but it may have a different
     *             name or signature in order that the presented API is an
     *             algorithmic mapping of the underlying native libraries.
     */
    native static final private double get_x_bearing(Handle obj);

    native static final private double get_y_bearning(Handle obj);

    native static final private double get_width(Handle obj);

    native static final private double get_height(Handle obj);

    native static final private double get_x_advance(Handle obj);

    native static final private double get_y_advance(Handle obj);

    native static final private void free(Handle obj);
}
