#!/bin/sh
#
# Usage:   ./maketar.sh <dh version>
set -e

if [ $# -ne 1 ] ; then
    echo 'Needs c-evo-dh version number as 1st parameter'
    exit 1
fi

# Change as required
package="c-evo-dh-$1"
outfile="c-evo-dh_$1.orig.tar.xz"

echo "Packing c-evo-dh revision $1"

# Tar the files
rm -f $outfile
rm -f $outfile.sig
mkdir ../$package
cp -drp * ../$package
tar -acf $outfile ../$package
rm -fr ../$package

# Copy to where I usually use it
cp -fpv $outfile ../../Debian
gpg --detach-sign $outfile
cp -fpv $outfile.sig ../../Debian/$outfile.asc
