#include <type_traits>


//DELEGATE
template <int ...values>
struct Delegate;

template <int head, int ...tail>
struct Delegate<head, tail...>
{
    static bool const value =
        head > 0 && (head & 1) == 0 && Delegate<tail...>::value;
};

template <int head>
struct Delegate<head>
{
    static bool const value = head > 0 && (head & 1) == 0;
};
//=

//EVEN
template <int ...values>
concept bool Even()
{
    return Delegate<values...>::value;
}
//=

//EVENVAL
template <Even ...values>
void evenVal()
{}

template <int ...values>
    requires Even<values...>()
void evenVal2()
{}
//=

int main()
{
    evenVal<2, 4>();
    evenVal<2, 3>();

    evenVal2<2, 4>();
    evenVal2<2, 3>();
}
