#include <iostream>
#include <vector>
#include <list>

struct Incrementable
{
    Incrementable &operator++()
    {
        return *this;       // just for the demo
    }
};

//GENERIC
template <typename Iterator>
void step(Iterator &iterator, size_t nSteps)
{
    for ( ; nSteps--; )
        ++iterator;
}
//=

//BIDIRECTIONAL
template <typename Iter>
concept bool BiDirectionalIterator =
    requires(Iter iter)
    {
        ++iter;
        --iter;
    };

template <BiDirectionalIterator Iterator>
void step(Iterator &iterator, int nSteps)
{
    if (nSteps > 0)
    {
        for ( ; nSteps--; )
            ++iterator;
    }
    else if (nSteps < 0)
    {
        for ( ; nSteps; ++nSteps)
            ++iterator;
    }
}
//=

//RANDOM
template <typename Iter>
concept bool RandomIterator =
    requires(Iter iter, int stepSize)
    {
        requires (BiDirectionalIterator<Iter>);
        iter += stepSize;
    };

template <RandomIterator Iterator>
void step(Iterator &iterator, int nSteps)
{
    iterator += nSteps;
}
//=

using namespace std;

int main()
{
    Incrementable incrementable;
    step(incrementable, 4);

    list<int> li;
    auto begin = li.begin();
    step(begin, 4);
    step(begin, -4);

    vector<int> vi;
    auto vbeg = vi.begin();
    step(vbeg, 4);
    step(vbeg, -4);
}
