#include <iostream>
#include <vector>
#include <list>
#include <string>
#include <iostream>

// Same example as shown in overloading.cc but this time illustrating partial
// specialization using concepts.

struct Incrementable
{
    Incrementable &operator++()
    {
        return *this;       // just for the demo
    }
};

//GENERIC
template <typename Whatever, typename Iterator>
void step(Iterator &iterator, size_t nSteps)
{
    std::cout << "generic\n";

    for ( ; nSteps--; )
        ++iterator;
}
//=

//BIDIRECTIONAL
template <typename Iter>
concept bool BiDirectionalIterator =
    requires(Iter iter)
    {
        ++iter;
        --iter;
    };

template <typename Whatever, BiDirectionalIterator Iterator>
void step(Iterator &iterator, int nSteps)
{
    std::cout << "bidirectional\n";

    if (nSteps > 0)
    {
        for ( ; nSteps--; )
            ++iterator;
    }
    else if (nSteps < 0)
    {
        for ( ; nSteps; ++nSteps)
            ++iterator;
    }
}
//=

//RANDOM
template <typename Iter>
concept bool RandomIterator =
    requires(Iter iter, int stepSize)
    {
        requires (BiDirectionalIterator<Iter>);
        iter += stepSize;
    };

template <typename Whatever, RandomIterator Iterator>
void step(Iterator &iterator, int nSteps)
{
    std::cout << "randomaccess\n";
    iterator += nSteps;
}
//=

using namespace std;

int main()
{
    Incrementable incrementable;
    step<int>(incrementable, 4);

    list<int> li;
    auto begin = li.begin();
    step<int>(begin, 4);
    step<std::string>(begin, -4);
//
//    vector<int> vi;
//    auto vbeg = vi.begin();
//    step(vbeg, 4);
//    step(vbeg, -4);
}
